/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graph2.IInflationTransform;
import net.sourceforge.plantuml.graph2.InflationTransform2;
import net.sourceforge.plantuml.graph2.Plan;
import net.sourceforge.plantuml.graph2.Polyline2;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;

public class Graph5 {
    private static final Graphics2D dummyGraphics2D;
    private final int spaceWidth = 40;
    private final int spaceHeight = 40;
    private final double margin = 20.0;
    private final Board board;
    private int maxRow;
    private int maxCol;
    private final Plan plan = new Plan();
    private final IInflationTransform inflationTransform = new InflationTransform2();

    private AbstractEntityImage getImage(ANode n) {
        return new EntityImageFactory().createEntityImage((IEntity)n.getUserData());
    }

    public Graph5(Board board) {
        board.normalize();
        this.board = board;
        for (ANode n : board.getNodes()) {
            this.maxRow = Math.max(this.maxRow, n.getRow());
            this.maxCol = Math.max(this.maxCol, board.getCol(n));
            Point2D.Double pos = this.getPosition(n);
            this.plan.addPoint2D(pos);
        }
        for (ANode n : board.getNodes()) {
            AbstractEntityImage image = this.getImage(n);
            Point2D.Double pos = this.getPosition(n);
            int widthCell = (int)image.getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getWidth() + 20;
            int heightCell = (int)image.getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getHeight() + 20;
            this.inflationTransform.addInflationX(pos.getX(), widthCell);
            this.inflationTransform.addInflationY(pos.getY(), heightCell);
        }
    }

    public Point2D.Double getPosition(ANode node) {
        return new Point2D.Double(this.board.getCol(node) * 40, node.getRow() * 40);
    }

    public Dimension2D getDimension() {
        double width = 40 * this.maxCol;
        int height = 40 * this.maxRow;
        return new Dimension2DDouble(width + 40.0 + this.inflationTransform.getTotalInflationX(), (double)height + 40.0 + this.inflationTransform.getTotalInflationY());
    }

    public void draw(Graphics2D g2d) {
        g2d.translate(20.0, 20.0);
        g2d.setColor(Color.BLUE);
        for (ALink link : this.getSortedLinks()) {
            Point2D.Double start = this.getPosition(link.getNode1());
            Point2D.Double end = this.getPosition(link.getNode2());
            List<Line2D.Double> lines = this.buildPath(start, end);
            Polyline2 polyline = this.buildPolyline(start, end, lines);
            polyline.draw(g2d);
        }
        for (ANode n : this.board.getNodes()) {
            AbstractEntityImage image = this.getImage(n);
            Point2D pos = this.getPosition(n);
            pos = this.inflationTransform.inflatePoint2D(pos);
            double x = pos.getX() - image.getDimension(StringBounderUtils.asStringBounder(g2d)).getWidth() / 2.0;
            double y = pos.getY() - image.getDimension(StringBounderUtils.asStringBounder(g2d)).getHeight() / 2.0;
            g2d.translate(x, y);
            image.draw(new ColorMapperIdentity(), g2d);
            g2d.translate(-x, -y);
        }
    }

    private Polyline2 buildPolyline(Point2D start, Point2D end, List<Line2D.Double> lines) {
        Polyline2 polyline = new Polyline2(this.inflationTransform.inflatePoint2D(start), this.inflationTransform.inflatePoint2D(end));
        List<Line2D.Double> list = this.inflationTransform.inflate(lines);
        for (Line2D.Double l1 : list) {
            polyline.addLine(l1);
        }
        return polyline;
    }

    private List<Line2D.Double> buildPath(Point2D start, Point2D end) {
        Point2D current = start;
        List<Point2D.Double> interm = this.plan.getIntermediatePoints(start, end);
        ArrayList<Line2D.Double> lines = new ArrayList<Line2D.Double>();
        for (Point2D.Double inter : interm) {
            this.plan.addPoint2D(inter);
            lines.add(new Line2D.Double(current, inter));
            this.plan.createLink(current, inter);
            current = inter;
        }
        lines.add(new Line2D.Double(current, end));
        this.plan.createLink(current, end);
        return lines;
    }

    private List<ALink> getSortedLinks() {
        final LinkedHashMap<ALink, Double> lengths = new LinkedHashMap<ALink, Double>();
        for (ALink aLink : this.board.getLinks()) {
            Point2D.Double p1 = this.getPosition(aLink.getNode1());
            Point2D.Double p2 = this.getPosition(aLink.getNode2());
            lengths.put(aLink, p1.distance(p2));
        }
        ArrayList<ALink> all = new ArrayList<ALink>(lengths.keySet());
        Collections.sort(all, new Comparator<ALink>(){

            @Override
            public int compare(ALink l1, ALink l2) {
                double diff = (Double)lengths.get(l1) - (Double)lengths.get(l2);
                return (int)Math.signum(diff);
            }
        });
        return all;
    }

    static {
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, Color.WHITE);
        dummyGraphics2D = builder.getGraphics2D();
    }
}

