/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernEnglober
extends AbstractTextualComponent {
    private final HtmlColor borderColor;
    private final HtmlColor backColor;

    public ComponentBlueModernEnglober(HtmlColor borderColor, HtmlColor backColor, Display strings, FontConfiguration font, ISkinSimple spriteContainer) {
        super(strings, font, HorizontalAlignment.CENTER, 4, 4, 1, spriteContainer, 0.0, false, null, null);
        this.borderColor = borderColor;
        this.backColor = backColor;
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(new UChangeColor(this.borderColor));
        ug = ug.apply(new UChangeBackColor(this.backColor));
        ug.apply(new UStroke(2.0)).draw(new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight(), 9.0, 9.0));
        double xpos = (dimensionToUse.getWidth() - this.getPureTextWidth(ug.getStringBounder())) / 2.0;
        this.getTextBlock().drawU(ug.apply(new UTranslate(xpos, 0.0)));
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 3.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 10.0;
    }
}

