/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerActivity;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UFont;

public final class GroupPngMakerActivity {
    private final CucaDiagram diagram;
    private final IGroup group;
    private final Rose rose = new Rose();

    public GroupPngMakerActivity(CucaDiagram diagram, IGroup group) {
        this.diagram = diagram;
        this.group = group;
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            IEntity e1 = link.getEntity1();
            IEntity e2 = link.getEntity2();
            if (e1.getParentContainer() != this.group || e1.isGroup() || e2.getParentContainer() != this.group || e2.isGroup()) continue;
            result.add(link);
        }
        return result;
    }

    public IEntityImage getImage() throws IOException, InterruptedException {
        if (this.group.size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        List<Link> links = this.getPureInnerLinks();
        ISkinParam skinParam = this.diagram.getSkinParam();
        DotData dotData = new DotData(this.group, links, this.group.getLeafsDirect(), this.diagram.getUmlDiagramType(), skinParam, new InnerGroupHierarchy(), this.diagram.getColorMapper(), this.diagram.getEntityFactory(), false, DotMode.NORMAL, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        CucaDiagramFileMakerSvek2 svek2 = new CucaDiagramFileMakerSvek2(dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma());
        if (this.group.getGroupType() == GroupType.INNER_ACTIVITY) {
            Stereotype stereo = this.group.getStereotype();
            HtmlColor borderColor = this.getColor(ColorParam.activityBorder, stereo);
            HtmlColor backColor = this.group.getSpecificBackColor() == null ? this.getColor(ColorParam.background, stereo) : this.group.getSpecificBackColor();
            return new InnerActivity(svek2.createFile(new String[0]), borderColor, backColor, skinParam.shadowing());
        }
        throw new UnsupportedOperationException(this.group.getGroupType().toString());
    }

    private UFont getFont(FontParam fontParam) {
        ISkinParam skinParam = this.diagram.getSkinParam();
        return skinParam.getFont(fontParam, null, false);
    }

    protected final HtmlColor getColor(ColorParam colorParam, Stereotype stereo) {
        ISkinParam skinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(skinParam, colorParam, stereo);
    }

    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Collection<IGroup> getChildrenGroups(IGroup parent) {
            if (EntityUtils.groupRoot(parent)) {
                return GroupPngMakerActivity.this.diagram.getChildrenGroups(GroupPngMakerActivity.this.group);
            }
            return GroupPngMakerActivity.this.diagram.getChildrenGroups(parent);
        }

        @Override
        public boolean isEmpty(IGroup g) {
            return GroupPngMakerActivity.this.diagram.isEmpty(g);
        }
    }
}

