/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import net.sourceforge.plantuml.GeneratedImage;

class SimpleLine2
implements Comparable<SimpleLine2> {
    private final File file;
    private final GeneratedImage generatedImage;
    private final Future<List<GeneratedImage>> future;

    public SimpleLine2(File file, GeneratedImage generatedImage, Future<List<GeneratedImage>> future) {
        this.generatedImage = generatedImage;
        this.file = file;
        this.future = future;
    }

    public File getFile() {
        return this.file;
    }

    public boolean pendingAndFinished() {
        return this.generatedImage == null && this.future.isDone();
    }

    public String toString() {
        if (this.generatedImage == null) {
            return this.file.getName() + " (...pending...)";
        }
        StringBuilder sb = new StringBuilder(this.generatedImage.getPngFile().getName());
        sb.append(" ");
        sb.append(this.generatedImage.getDescription());
        return sb.toString();
    }

    public Future<List<GeneratedImage>> getFuture() {
        return this.future;
    }

    @Override
    public int compareTo(SimpleLine2 other) {
        return this.toString().compareTo(other.toString());
    }

    public GeneratedImage getGeneratedImage() {
        return this.generatedImage;
    }
}

