// Copyright 2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/plugin/descriptor/v1/file_location.proto

package descriptorv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A reference to a FileDescriptor or to a location within a FileDescriptor.
//
// A FileDescriptor is referenced by name.
// A location is referenced by its source path, following the semantics of
// google.protobuf.SourceCodeInfo.Location.path.
//
// A FileLocation may or may not include a source path. If a source path is not included, the
// FileLocation just references the FileDescriptor as a whole.
type FileLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the FileDescriptor. This matches the name field in the corresponding FileDescriptorProto.
	//
	// Required.
	//
	// The path must be relative, and cannot contain any "." or ".." components.
	// The separator "/" must be used.
	FileName string `protobuf:"bytes,1,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// The SourceCodeInfo.Location.path within the FileDescriptorProto.
	//
	// This corresponds to a SourceCodeInfo.Location within the corresponding FileDescriptorProto.
	// Buf will find the first SourceCodeInfo.Location with this path, and use this to extract line
	// and column information, as well as read the comments for ignores.
	//
	// Optional. If not set, the Location just references the File as a whole.
	//
	// It is not valid to have a non-zero value of source_path without a name.
	SourcePath []int32 `protobuf:"varint,2,rep,packed,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
}

func (x *FileLocation) Reset() {
	*x = FileLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_descriptor_v1_file_location_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileLocation) ProtoMessage() {}

func (x *FileLocation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_descriptor_v1_file_location_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileLocation.ProtoReflect.Descriptor instead.
func (*FileLocation) Descriptor() ([]byte, []int) {
	return file_buf_plugin_descriptor_v1_file_location_proto_rawDescGZIP(), []int{0}
}

func (x *FileLocation) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *FileLocation) GetSourcePath() []int32 {
	if x != nil {
		return x.SourcePath
	}
	return nil
}

var File_buf_plugin_descriptor_v1_file_location_proto protoreflect.FileDescriptor

var file_buf_plugin_descriptor_v1_file_location_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18,
	0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe0, 0x02, 0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x55, 0xba, 0x48, 0x52, 0xc8, 0x01,
	0x01, 0x72, 0x4d, 0x18, 0x80, 0x20, 0x32, 0x44, 0x5e, 0x28, 0x5b, 0x5e, 0x2f, 0x2e, 0x5d, 0x5b,
	0x5e, 0x2f, 0x5d, 0x3f, 0x7c, 0x5b, 0x5e, 0x2f, 0x5d, 0x5b, 0x5e, 0x2f, 0x2e, 0x5d, 0x7c, 0x5b,
	0x5e, 0x2f, 0x5d, 0x7b, 0x33, 0x2c, 0x7d, 0x29, 0x28, 0x2f, 0x28, 0x5b, 0x5e, 0x2f, 0x2e, 0x5d,
	0x5b, 0x5e, 0x2f, 0x5d, 0x3f, 0x7c, 0x5b, 0x5e, 0x2f, 0x5d, 0x5b, 0x5e, 0x2f, 0x2e, 0x5d, 0x7c,
	0x5b, 0x5e, 0x2f, 0x5d, 0x7b, 0x33, 0x2c, 0x7d, 0x29, 0x29, 0x2a, 0x24, 0xba, 0x01, 0x01, 0x5c,
	0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0b, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x42,
	0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x10, 0x40, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x3a, 0xb0, 0x01, 0xba, 0x48, 0xac, 0x01, 0x1a, 0xa9, 0x01, 0x0a,
	0x28, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x66, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x70, 0x72, 0x65,
	0x73, 0x65, 0x6e, 0x74, 0x20, 0x69, 0x66, 0x20, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x20, 0x69, 0x73, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x1a, 0x48,
	0x21, 0x68, 0x61, 0x73, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x68, 0x61, 0x73, 0x28, 0x74,
	0x68, 0x69, 0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x29,
	0x20, 0x26, 0x26, 0x20, 0x68, 0x61, 0x73, 0x28, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x29, 0x29, 0x42, 0x5e, 0x5a, 0x5c, 0x62, 0x75, 0x66, 0x2e,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f,
	0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_plugin_descriptor_v1_file_location_proto_rawDescOnce sync.Once
	file_buf_plugin_descriptor_v1_file_location_proto_rawDescData = file_buf_plugin_descriptor_v1_file_location_proto_rawDesc
)

func file_buf_plugin_descriptor_v1_file_location_proto_rawDescGZIP() []byte {
	file_buf_plugin_descriptor_v1_file_location_proto_rawDescOnce.Do(func() {
		file_buf_plugin_descriptor_v1_file_location_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_plugin_descriptor_v1_file_location_proto_rawDescData)
	})
	return file_buf_plugin_descriptor_v1_file_location_proto_rawDescData
}

var file_buf_plugin_descriptor_v1_file_location_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_plugin_descriptor_v1_file_location_proto_goTypes = []any{
	(*FileLocation)(nil), // 0: buf.plugin.descriptor.v1.FileLocation
}
var file_buf_plugin_descriptor_v1_file_location_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_buf_plugin_descriptor_v1_file_location_proto_init() }
func file_buf_plugin_descriptor_v1_file_location_proto_init() {
	if File_buf_plugin_descriptor_v1_file_location_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_buf_plugin_descriptor_v1_file_location_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*FileLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_plugin_descriptor_v1_file_location_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_plugin_descriptor_v1_file_location_proto_goTypes,
		DependencyIndexes: file_buf_plugin_descriptor_v1_file_location_proto_depIdxs,
		MessageInfos:      file_buf_plugin_descriptor_v1_file_location_proto_msgTypes,
	}.Build()
	File_buf_plugin_descriptor_v1_file_location_proto = out.File
	file_buf_plugin_descriptor_v1_file_location_proto_rawDesc = nil
	file_buf_plugin_descriptor_v1_file_location_proto_goTypes = nil
	file_buf_plugin_descriptor_v1_file_location_proto_depIdxs = nil
}
