// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/module/v1/resource.proto

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A Module, Label, or Commit.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*Resource_Module
	//	*Resource_Label
	//	*Resource_Commit
	Value isResource_Value `protobuf_oneof:"value"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_resource_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_resource_proto_rawDescGZIP(), []int{0}
}

func (m *Resource) GetValue() isResource_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Resource) GetModule() *Module {
	if x, ok := x.GetValue().(*Resource_Module); ok {
		return x.Module
	}
	return nil
}

func (x *Resource) GetLabel() *Label {
	if x, ok := x.GetValue().(*Resource_Label); ok {
		return x.Label
	}
	return nil
}

func (x *Resource) GetCommit() *Commit {
	if x, ok := x.GetValue().(*Resource_Commit); ok {
		return x.Commit
	}
	return nil
}

type isResource_Value interface {
	isResource_Value()
}

type Resource_Module struct {
	Module *Module `protobuf:"bytes,1,opt,name=module,proto3,oneof"`
}

type Resource_Label struct {
	Label *Label `protobuf:"bytes,2,opt,name=label,proto3,oneof"`
}

type Resource_Commit struct {
	Commit *Commit `protobuf:"bytes,3,opt,name=commit,proto3,oneof"`
}

func (*Resource_Module) isResource_Value() {}

func (*Resource_Label) isResource_Value() {}

func (*Resource_Commit) isResource_Value() {}

// A reference to any of:
//   - Module
//   - Label
//   - Commit
//
// The id or name is resolved to a specific resource.
// If an id is passed, this is interpreted as being the id of the resource.
// If a name is passed, the semantics according to ResourceRef.Name are applied.
//
// ResourceRefs can only be used in requests, and only for read-only RPCs, that is
// you should not use an arbitrary reference when modifying a specific resource.
type ResourceRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*ResourceRef_Id
	//	*ResourceRef_Name_
	Value isResourceRef_Value `protobuf_oneof:"value"`
}

func (x *ResourceRef) Reset() {
	*x = ResourceRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_resource_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceRef) ProtoMessage() {}

func (x *ResourceRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceRef.ProtoReflect.Descriptor instead.
func (*ResourceRef) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_resource_proto_rawDescGZIP(), []int{1}
}

func (m *ResourceRef) GetValue() isResourceRef_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *ResourceRef) GetId() string {
	if x, ok := x.GetValue().(*ResourceRef_Id); ok {
		return x.Id
	}
	return ""
}

func (x *ResourceRef) GetName() *ResourceRef_Name {
	if x, ok := x.GetValue().(*ResourceRef_Name_); ok {
		return x.Name
	}
	return nil
}

type isResourceRef_Value interface {
	isResourceRef_Value()
}

type ResourceRef_Id struct {
	// The id of the resource.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type ResourceRef_Name_ struct {
	// The fully-qualified name of the resource.
	Name *ResourceRef_Name `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*ResourceRef_Id) isResourceRef_Value() {}

func (*ResourceRef_Name_) isResourceRef_Value() {}

// The fully-qualified name component of a ResourceRef.
//
// The following semantics are applied:
//   - If the child oneof is not specified, the name is interpreted to reference a Module.
//   - If label_name is specified, the name is interpreted to reference a Label.
//   - If ref is specified, it is interpreted to be either an id or name.
//   - If an id, this is equivalent to setting the id field on ResourceRef. However,
//     backends can choose to validate that the owner and module fields match the resource
//     referenced, as additional validation.
//   - If a name, this is interpreted to be a Label name.
//   - If there is a conflict between names across resources (for example, there is a Commit id
//     and Label name of the same value), the following order of precedence is applied:
//   - Commit
//   - Label
//
// Names can only be used in requests, and only for read-only RPCs, that is
// you should not use an arbitrary reference when modifying a specific resource.
type ResourceRef_Name struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the User or Organization that owns the resource.
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the Module that contains or is the resource.
	Module string `protobuf:"bytes,2,opt,name=module,proto3" json:"module,omitempty"`
	// If the oneof is present but empty, this should be treated as not present.
	//
	// Types that are assignable to Child:
	//
	//	*ResourceRef_Name_LabelName
	//	*ResourceRef_Name_Ref
	Child isResourceRef_Name_Child `protobuf_oneof:"child"`
}

func (x *ResourceRef_Name) Reset() {
	*x = ResourceRef_Name{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_resource_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceRef_Name) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceRef_Name) ProtoMessage() {}

func (x *ResourceRef_Name) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceRef_Name.ProtoReflect.Descriptor instead.
func (*ResourceRef_Name) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_resource_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ResourceRef_Name) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *ResourceRef_Name) GetModule() string {
	if x != nil {
		return x.Module
	}
	return ""
}

func (m *ResourceRef_Name) GetChild() isResourceRef_Name_Child {
	if m != nil {
		return m.Child
	}
	return nil
}

func (x *ResourceRef_Name) GetLabelName() string {
	if x, ok := x.GetChild().(*ResourceRef_Name_LabelName); ok {
		return x.LabelName
	}
	return ""
}

func (x *ResourceRef_Name) GetRef() string {
	if x, ok := x.GetChild().(*ResourceRef_Name_Ref); ok {
		return x.Ref
	}
	return ""
}

type isResourceRef_Name_Child interface {
	isResourceRef_Name_Child()
}

type ResourceRef_Name_LabelName struct {
	// The name of the Label.
	//
	// If this value is present but empty, this should be treated as not present, that is
	// an empty value is the same as a null value.
	LabelName string `protobuf:"bytes,3,opt,name=label_name,json=labelName,proto3,oneof"`
}

type ResourceRef_Name_Ref struct {
	// The untyped reference, applying the semantics as documented on the Name message.
	//
	// If this value is present but empty, this should be treated as not present, that is
	// an empty value is the same as a null value.
	Ref string `protobuf:"bytes,4,opt,name=ref,proto3,oneof"`
}

func (*ResourceRef_Name_LabelName) isResourceRef_Name_Child() {}

func (*ResourceRef_Name_Ref) isResourceRef_Name_Child() {}

var File_buf_registry_module_v1_resource_proto protoreflect.FileDescriptor

var file_buf_registry_module_v1_resource_proto_rawDesc = []byte{
	0x0a, 0x25, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x1a,
	0x23, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x62,
	0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xc5, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x06,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x06,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x35, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x38, 0x0a,
	0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x48, 0x00, 0x52,
	0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x42, 0x0e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x05, 0xba, 0x48, 0x02, 0x08, 0x01, 0x22, 0x99, 0x02, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x12, 0x1a, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x88, 0x02, 0x01, 0x48, 0x00, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x1a, 0x93, 0x01, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x05,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0a, 0xba, 0x48, 0x07,
	0xc8, 0x01, 0x01, 0x72, 0x02, 0x18, 0x20, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x21,
	0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09,
	0xba, 0x48, 0x06, 0x72, 0x04, 0x10, 0x02, 0x18, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x12, 0x29, 0x0a, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0xfa, 0x01, 0x48,
	0x00, 0x52, 0x09, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x03,
	0x72, 0x65, 0x66, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x72, 0x65, 0x66,
	0x42, 0x07, 0x0a, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x3a, 0x08, 0xea, 0xc5, 0x2b, 0x04, 0x08,
	0x01, 0x18, 0x01, 0x42, 0x0e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x05, 0xba, 0x48,
	0x02, 0x08, 0x01, 0x42, 0x57, 0x5a, 0x55, 0x62, 0x75, 0x66, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2f, 0x76, 0x31, 0x3b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_registry_module_v1_resource_proto_rawDescOnce sync.Once
	file_buf_registry_module_v1_resource_proto_rawDescData = file_buf_registry_module_v1_resource_proto_rawDesc
)

func file_buf_registry_module_v1_resource_proto_rawDescGZIP() []byte {
	file_buf_registry_module_v1_resource_proto_rawDescOnce.Do(func() {
		file_buf_registry_module_v1_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_module_v1_resource_proto_rawDescData)
	})
	return file_buf_registry_module_v1_resource_proto_rawDescData
}

var file_buf_registry_module_v1_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_registry_module_v1_resource_proto_goTypes = []any{
	(*Resource)(nil),         // 0: buf.registry.module.v1.Resource
	(*ResourceRef)(nil),      // 1: buf.registry.module.v1.ResourceRef
	(*ResourceRef_Name)(nil), // 2: buf.registry.module.v1.ResourceRef.Name
	(*Module)(nil),           // 3: buf.registry.module.v1.Module
	(*Label)(nil),            // 4: buf.registry.module.v1.Label
	(*Commit)(nil),           // 5: buf.registry.module.v1.Commit
}
var file_buf_registry_module_v1_resource_proto_depIdxs = []int32{
	3, // 0: buf.registry.module.v1.Resource.module:type_name -> buf.registry.module.v1.Module
	4, // 1: buf.registry.module.v1.Resource.label:type_name -> buf.registry.module.v1.Label
	5, // 2: buf.registry.module.v1.Resource.commit:type_name -> buf.registry.module.v1.Commit
	2, // 3: buf.registry.module.v1.ResourceRef.name:type_name -> buf.registry.module.v1.ResourceRef.Name
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_resource_proto_init() }
func file_buf_registry_module_v1_resource_proto_init() {
	if File_buf_registry_module_v1_resource_proto != nil {
		return
	}
	file_buf_registry_module_v1_commit_proto_init()
	file_buf_registry_module_v1_label_proto_init()
	file_buf_registry_module_v1_module_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_module_v1_resource_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_resource_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ResourceRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_resource_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ResourceRef_Name); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_buf_registry_module_v1_resource_proto_msgTypes[0].OneofWrappers = []any{
		(*Resource_Module)(nil),
		(*Resource_Label)(nil),
		(*Resource_Commit)(nil),
	}
	file_buf_registry_module_v1_resource_proto_msgTypes[1].OneofWrappers = []any{
		(*ResourceRef_Id)(nil),
		(*ResourceRef_Name_)(nil),
	}
	file_buf_registry_module_v1_resource_proto_msgTypes[2].OneofWrappers = []any{
		(*ResourceRef_Name_LabelName)(nil),
		(*ResourceRef_Name_Ref)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_module_v1_resource_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_module_v1_resource_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_resource_proto_depIdxs,
		MessageInfos:      file_buf_registry_module_v1_resource_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_resource_proto = out.File
	file_buf_registry_module_v1_resource_proto_rawDesc = nil
	file_buf_registry_module_v1_resource_proto_goTypes = nil
	file_buf_registry_module_v1_resource_proto_depIdxs = nil
}
