To download and unpack the latest version of cdb:

    wget -m https://cdb.cr.yp.to/cdb-latest-version.txt
    version=$(cat cdb.cr.yp.to/cdb-latest-version.txt)
    wget -m https://cdb.cr.yp.to/cdb-$version.tar.gz
    tar -xzf cdb.cr.yp.to/cdb-$version.tar.gz
    cd cdb-$version

Then [install](install.html)
and [test](test.html).

### Archives and changelog (reverse chronological) {#changelog}

[`cdb-20251021.tar.gz`](cdb-20251021.tar.gz) [browse](cdb-20251021.html)

Add support for cdb64 (at least on 64-bit platforms).

Support `./configure`, `./configure --prefix=...`, and `make install`.

Switch almost all internal integers to `num`,
defined as `long long`.
Replace various `uint32`, `fmt`, `scan` functions with `num` functions.

For tests,
avoid depending on `csh`;
depend on `ulimit` instead of `softlimit`;
increase limit to handle current process bloat.

Split `buffer` interface into `inbuf` and `outbuf`.

Clean up `hier` interface.

Remove various function definitions and declarations not used in cdb.

Eliminate some wrappers:
`str_len`, `alloc`, `uint32`, `exit`, `error`, `systype`.

Tweak code to avoid deprecated C features
(old-style function definitions,
empty prototypes,
old-style `main` definitions).

Make more use of `const` and `static`.
Eliminate `register`.
Add `-Wall` to compiler options.
Tweak code to avoid `-Wall` complaints.

Add some don't-be-stupid compiler options:
`-fwrapv`,
`-fno-delete-null-pointer-checks`,
`-fno-strict-aliasing`,
and
`-fno-strict-overflow`.

Many updates to documentation.

[`cdb-0.75.tar.gz`](cdb-0.75.tar.gz) (20000219) [browse](cdb-0.75.html)

Fixed bug pointed out by Uwe Ohse:
`cdb_make_addbegin` didn't explicitly return 0,
so database creation could fail on systems that didn't follow the traditional C return behavior.

Added `testzero` to regression-test suite.

Increased `bspace` in `cdb_make.h` from 1024 to 8192.

Switched `cdbmake` to use `PUTC` and `GETC`; 3x speedup in one test.

UI: `posplus` sets `ENOMEM` if it passes 4GB.

[`cdb-0.70.tar.gz`](cdb-0.70.tar.gz) (20000217) [browse](cdb-0.70.html)

API: rewrote almost everything from scratch.
Thanks to Ken Lalonde for suggesting mmap.

UI: cdbget supports skip.

[`cdb-0.55.tar.gz`](cdb-0.55.tar.gz) (19960922) [browse](cdb-0.55.html)

First release.
