#include <unistd.h>
#include "strerr.h"
#include "cdb_make.h"

#ifdef CDB64
#define FATAL "test64zero: fatal: "
#else
#define FATAL "testzero: fatal: "
#endif

static void die_write(void)
{
  strerr_die2sys(111,FATAL,"unable to write: ");
}

static char key[4];
static char data[65536];
static struct cdb_make c;

int main(int argc,char **argv)
{
  num loop;

  if (!*argv) _exit(0);
  if (!*++argv) _exit(0);
  loop = num_fromstring_allowoverflow(*argv);

  if (cdb_make_start(&c,1) == -1) die_write();

  while (loop) {
    num_to4bytes_allowoverflow(key,--loop);
    if (cdb_make_add(&c,key,4,data,sizeof data) == -1) die_write();
  }

  if (cdb_make_finish(&c) == -1) die_write();
  _exit(0);
  return 0;
}
