/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/initdefs.c,v $
 * $Id: initdefs.c,v 1.2 1999/07/20 21:20:06 heiner Exp $
 *
 *	defines constants
 */

#if INIT_GET
# undef INIDEFS_PUT
#endif

#if INIDEFS_PUT		/*===================================================*/

#undef INIT_PUT
#undef INIT_GET
#define INIT_GET 1

#include "types.h"
#include "board.h"
#include "sysdep.h"
#include <assert.h>
#include <stdio.h>

#include "extern.c"	/*!!*/

static char const*	include_name = "CHEST_initdefs_h_INCLUDED";

/*
 * ini_bau_attdirset()
 *	Initialize 'bau_attdirset_tab[]'.
 */
     static void
ini_bau_attdirset( void )
{
#if 0
    /* see "extern.c" */
#endif
}

/*
 * ini_defines()
 *	Initialize definition tables.
 */
    static void
ini_defines(void)
{
    ini_extern();	/*!!*/

    ini_bau_attdirset();
}

#include "bsd.h"
#include "sysdep.c"			/*!!*/

static const char*	cpp_nl		= "\n";
static const char*	cpp_comment	= " /* %s */";
static const char*	cpp_fmt1	= "#%s";
static const char*	cpp_fmt2	= "#%s %s";
static const char*	cpp_fmt3	= "#%s %s\t\t%s";

static const char*	cpp_define	= "define";
static const char*	cpp_undef	= "undef";
static const char*	cpp_if		= "if";
static const char*	cpp_ifdef	= "ifdef";
static const char*	cpp_ifndef	= "ifndef";
static const char*	cpp_endif	= "endif";
static const char*	cpp_else	= "else";
static const char*	cpp_elif	= "elif";

#define wrt_			printf 
#define wrt_nl( )		wrt_ (cpp_nl)
#define wrt_comment( p1 )	wrt_ (cpp_comment, ##p1)
#define wrt_cpp1( p1 )		wrt_ (cpp_fmt1, ##p1)
#define wrt_cpp2( p1, p2 )	wrt_ (cpp_fmt2, ##p1, ##p2)
#define wrt_cpp3( p1, p2, p3 )	wrt_ (cpp_fmt3, ##p1, ##p2, ##p3)

#define wrt_define( what, as )	wrt_cpp3( cpp_define, ##what, ##as )
#define wrt_undef( what, as )	wrt_cpp3( cpp_undef, ##what, ##as )
#define wrt_if( what )		wrt_cpp2( cpp_if, ##what )
#define wrt_ifdef( what )	wrt_cpp2( cpp_ifdef, ##what )
#define wrt_ifndef( what )	wrt_cpp2( cpp_ifndef, ##what )
#define wrt_endif( )		wrt_cpp1( cpp_endif )
#define wrt_else( )		wrt_cpp1( cpp_else )
#define wrt_elif( what )	wrt_cpp2( cpp_elif, ##what )


static char		wrt_buf[ 128 ];


/*
 * wrt_bau_attdirset()
 *	Write the definition of the pawns' set
 *	of attack directions.
 */
     static void
wrt_bau_attdirset( void )
{
    char const*		const names[] = { "ATTDIRSET_W_B", "ATTDIRSET_B_B" };
    char*		fmt;
    int			pl;
    int			i;

    if( (NELEMS(bau_attdirset_tab) != NELEMS(names))
     || (white >= black)
      ) {
	printf("wrt_attdirset(): panic\n");
	sys_exit(1);
    }

    get_attdirset_fmt(&fmt, &pl, TRUE);

    for( i=0 ; i < NELEMS(names) ; ++i ) {
        sprintf(wrt_buf, fmt, bau_attdirset_tab[i]);
	assert(strlen(wrt_buf) < NELEMS(wrt_buf));
        wrt_define(names[i], wrt_buf);
	wrt_nl();
    }
}


/*
 * wrt_lin_attdirset()
 *	Write the definition of line oriented
 *	attack directions.
 */
     static void
wrt_lin_attdirset( void )
{
    char const*		const names[] = {
			  "ATTDIRSET_L_R",
			  "ATTDIRSET_U_D", 
			  "ATTDIRSET_LU_RD",
			  "ATTDIRSET_LD_RU", 
			};
    StepDelta const	deltas[ NELEMS(names) ] [ 2 ] = {
			  { DELTA_L,	DELTA_R, },
			  { DELTA_U,	DELTA_D, },
			  { DELTA_LU,	DELTA_RD, },
			  { DELTA_LD,	DELTA_RU, },
			};
    char*		fmt;
    int			pl;
    int			i, j;

    get_attdirset_fmt(&fmt, &pl, TRUE);

    for( i=0 ; i < NELEMS(deltas) ; ++i ) {
	AttDirSet	set;

	for( set=0, j=0 ; j < NELEMS(deltas[0]) ; ++j ) {
	    int		dir;

	    dir = att_dir(MK_DELTA(0,0), deltas[i][j]);
	    assert( dam_dir(dir) );
	    set |= ATTDIRSET1(dir);
	}

	sprintf(wrt_buf, fmt, set);
	assert(strlen(wrt_buf) < NELEMS(wrt_buf));
	wrt_define(names[i], wrt_buf);
	wrt_nl();
    }
}


/*
 * wrt_defines()
 *	Write the constant definitions.
 */
    static void
wrt_defines(void)
{
    wrt_ifndef(include_name); wrt_nl();
    wrt_define(include_name, ""); wrt_nl(); wrt_nl();

    wrt_bau_attdirset(); wrt_nl();
    wrt_lin_attdirset(); wrt_nl();

    wrt_endif(); wrt_comment(include_name); wrt_nl();
}

#endif /* INIDEFS_PUT *//*===================================================*/
