/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/mklcltyp.c,v $
 * $Id: mklcltyp.c,v 1.4 1999/08/05 22:56:01 heiner Exp $
 *
 *	Compute local customization.
 *	This MUST be a standalone program, i.e. must not use any
 *	generated source.  Cf. "mksupp.c" & "sysdep.h"
 */

#include <stdio.h>

#define PREF_DEF_BITS_IN	"BITS_IN_"
#define PREF_DEF_SIZE_OF	"SIZE_OF_"

#define PREF_TYP_SIGNED		"int"
#define PREF_TYP_UNSIGNED	"uint"
#define PREF_TYP_REGISTER	"r"

#define PREF_DEF_SIGNED		"Int"
#define PREF_DEF_UNSIGNED	"Uint"

#define LIN_LEN		100

/*===========================================================================*/

    static void
nl(void)
{
    printf("\n");
}

    static int
eq_string( const char* p1, const char* p2 )
{
    if( !p1 ) return !p2;
    if( !p2 ) return 0;
    for( ; *p1 == *p2 ; ++p1, ++p2 ) {
	if( ! *p1 ) return 1;
    }
    return 0;
}

    static int
is_bt( char c )
{
    return (c == ' ') || (c == '\t');
}

    static char*
app_nonbt( char* outp, const char* inp )
{
    while(                *outp ) ++outp;
    while(          is_bt(*inp) ) ++inp;
    while( *inp && !is_bt(*inp) ) *outp++ = *inp++;
    *outp = '\0';	/* terminate */
    return outp;
}

    static void
pr_idef( int len, const char* pref, const char* suff, int value )
{
    char	buf[LIN_LEN];
    char*	p;

    p = buf; *p = 0;
    p = app_nonbt(p, pref);
    p = app_nonbt(p, suff);
    printf("#define %-*s %d\n", len,buf, value);
}

    static void
pr_sdef( int len, const char* pref, const char* suff, const char* value )
{
    char	buf[LIN_LEN];
    char*	p;

    p = buf; *p = 0;
    p = app_nonbt(p, pref);
    p = app_nonbt(p, suff);
    printf("#define %-*s %s\n", len,buf, value);
}

/*===========================================================================*/
/*
 * We have to determine the number of bits in the standard integral types.
 * We also try to find a not so standard 64 bit type.
 *
 * We expect types to always come in pairs: a signed and an unsigned version.
 * A type "T" and the corresponding "unsigned T" are considered
 * to have exactly the same number of bits in them (demanded by ANSI).
 * To determine the number of bits we use the unsigned version of a type.
 */

typedef struct TypeInfo	TypeInfo;

struct TypeInfo
{
    char*	defname;	/* e.g. "CHAR" */
    char*	cname[2];	/* [whether unsigned] C-type as string */
    int		usize;		/* sizeof(unsigned) */
    int		bits;		/* effective bits in (unsigned) type */
};


static TypeInfo		g_typeinfo[9]	={ 0 };
static TypeInfo*	g_tip		= g_typeinfo;


    static TypeInfo*		/* --> just filled */
fill_1_def( char* defname, char* sname, char* uname, int usize )
{
    TypeInfo*	p;

    p = g_tip++;
    p->defname  = defname;
    p->cname[0] = sname;
    p->cname[1] = uname;
    p->usize    = usize;
    return p;
}

#define FILL_1_BITS(p, UTYP)			\
    {						\
	UTYP v; int bits;			\
	for( bits=0, v=1 ; v ; v<<=1 ) ++bits;	\
	(p)->bits = bits;			\
    }

#define F1I(defname, sname, uname, UTYP)	\
    {						\
	TypeInfo*	p;			\
	p = fill_1_def(defname, sname, uname, (int)sizeof(UTYP)); \
	FILL_1_BITS(p, UTYP)			\
    }

    static void
fill_bits(void)
{
    /*
     * For all the types we know, we call F1I once.
     * The first string is somewhat fixed, it is a logical name.
     */
    F1I("CHAR",  "signed char", "unsigned char",      unsigned char     )
    F1I("SHORT", "short",       "unsigned short",     unsigned short    )
    F1I("INT",   "int",         "unsigned int",       unsigned int      )
    F1I("LONG",  "long",        "unsigned long",      unsigned long     )
#if TRY_LOLO
    F1I("LOLO",  "long long",   "unsigned long long", unsigned long long)
#endif
#if TRY_I64
# include <inttypes.h>
    F1I("I64",   "int64_t",     "uint64_t",           uint64_t          )
    printf("#include <inttypes.h>\n");
#endif
}

/*===========================================================================*/
/*
 * The following code assumes, that the TypeInfo array is filled, already.
 */

    static void
pr_idef_bits(void)
{
    const TypeInfo*	tip;

    for( tip=g_typeinfo ; tip<g_tip ; ++tip ) {
	pr_idef(16, PREF_DEF_BITS_IN, tip->defname, tip->bits);
    }
    nl();
    for( tip=g_typeinfo ; tip<g_tip ; ++tip ) {
	pr_idef(16, PREF_DEF_SIZE_OF, tip->defname, tip->usize);
    }
}

/*===========================================================================*/

    static const TypeInfo*
find_defname( char* defname )
{
    const TypeInfo*	tip;

    for( tip=g_typeinfo ; tip<g_tip ; ++tip ) {
	if( eq_string(defname, tip->defname) ) {
	    return tip;
	}
    }
    return 0;
}


    static int
ti_is_better_than( const TypeInfo* candp, const TypeInfo* bestp )
{
    if( candp->usize < bestp->usize )	return 1;
    if( candp->usize > bestp->usize )	return 0;
    if( candp->bits  < bestp->bits  )	return 1;
    return 0;
}


    static int
ti_is_eq( const TypeInfo* p1, const TypeInfo* p2 )
{
    return ! ti_is_better_than(p1, p2)
	&& ! ti_is_better_than(p2, p1) ;
}


    static TypeInfo*
ti_contains( int wantbits )
{
    /*
     * Determine the best type that has at least "wantbits" bits.
     */
    TypeInfo*	tip;
    TypeInfo*	bestp;

    bestp = 0;
    for( tip=g_typeinfo ; tip<g_tip ; ++tip ) {
	if( tip->bits >= wantbits ) {
	    if( !bestp || ti_is_better_than(tip, bestp) ) {
		bestp = tip;
	    }
	}
    }
    return bestp;
}

/*===========================================================================*/

typedef struct WantInfo	WantInfo;

struct WantInfo
{
    int		bits;		/* so many bits necessary */
    char*	like_defname;	/* this logical type we would prefer */
};

static WantInfo	g_wantinfo[]	= {
    {  8, "CHAR"  },
    { 16, "SHORT" },
    { 32, "INT"   },
    { 64, "LONG"  },
    {  0, 0 }
};


#define FLG_unsigned	(1 << 0)
#define FLG_register	(1 << 1)


    static const char*
pref_typ( int flags )
{
    return ((flags & FLG_unsigned) ? PREF_TYP_UNSIGNED : PREF_TYP_SIGNED);
}

    static const char*
pref_def( int flags )
{
    return ((flags & FLG_unsigned) ? PREF_DEF_UNSIGNED : PREF_DEF_SIGNED);
}

    static const char*
pref_reg( int flags )
{
    return ((flags & FLG_register) ? PREF_TYP_REGISTER : " ");
}

    static void
pr_1_wanted_typ( int wantbits, const TypeInfo* tip, int flags )
{
    const TypeInfo*	usetip;

    usetip = tip;
    if( flags & FLG_register ) {
	    const TypeInfo*	inttip;
	inttip = find_defname("INT");
	if( inttip && (tip->bits < inttip->bits) ) {
	    usetip = inttip;
	}
    }
    printf("typedef %-18s\t%s%s%d;\n",
	    usetip->cname[ !!(flags & FLG_unsigned) ],
	    pref_reg (flags),
	    pref_typ (flags),
	    wantbits
    );
}

    static void
pr_1_wanted_def( int wantbits, const TypeInfo* tip, int flags )	/*ARGSUSED*/
{
    char	dname[LIN_LEN];
    char	tname[LIN_LEN];

    sprintf(dname, "%s%d", pref_def(flags), wantbits);
    sprintf(tname, "%s%d", pref_typ(flags), wantbits);
    pr_sdef(10, dname, "", tname);
}


typedef void (*	WantAppl)(int, const TypeInfo*, int);

    static void
on_wanted( WantAppl funcp, int flags )
{
    WantInfo*		wip;
    int			wantbits;
    const TypeInfo*	tip;
    const TypeInfo*	likep;

    nl();
    for( wip=g_wantinfo ; wip->bits ; ++wip ) {
	wantbits = wip->bits;
	tip = ti_contains(wantbits);
	if( tip && tip->bits ) {
	    likep = 0;
	    if( wip->like_defname ) {
		likep = find_defname(wip->like_defname);
	    }
	    if( likep && likep->bits && ti_is_eq(likep, tip) ) {
		tip = likep;
	    }
	    (*funcp)(wantbits, tip, flags);
	}
    }
}

    static void
pr_wanted(void)
{
    on_wanted( pr_1_wanted_typ, 0 );
    on_wanted( pr_1_wanted_typ, FLG_unsigned );
    on_wanted( pr_1_wanted_typ, FLG_register | 0 );
    on_wanted( pr_1_wanted_typ, FLG_register | FLG_unsigned );

    on_wanted( pr_1_wanted_def, 0 );
    on_wanted( pr_1_wanted_def, FLG_unsigned );
}

    static void
mk_doit(void)
{
    fill_bits();

    pr_idef_bits();
    pr_wanted();
}

#include "mksupp.c"			/*!!*/
