/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/timing.h,v $
 * $Id: timing.h,v 3.6 1999/12/04 23:07:17 heiner Exp $
 *
 *	Access effective user time.
 *	We prefer (virtual) processor time over (real) wall clock time.
 */

#ifndef CHEST_timing_h_INCLUDED
#define CHEST_timing_h_INCLUDED

#include "bastyp.h"

/*
 * - We want a better resulution than just seconds, say milli seconds.
 * - We want a large range for timing.  Jobs can be many days long.
 * - Now, in the late 90s, we do not want to avoid floating point
 *   computations, as we did 10 years ago.
 *
 * Hence we use (double) and measure in seconds.
 *
 * When using 32 bit for milli-seconds:
 *	2^32 msecs >= 4294967 sec >= 71582 min >= 1193 hour >= 49 days
 *
 * We do not know, where the underlying timing of the operating system
 * is anchored, but normally it starts with zero at process creation.
 */
typedef double		TimeSecs;		/* time in seconds */

Extern void		timing_init(void);	/* initialize module */

Extern const char*	timing_type(void);	/* descriptive string */
Extern int		timing_prec(void);	/* printf-precision */

Extern void		gtimer_start(void);	/* start global timer */
Extern TimeSecs		gtimer_now(void);	/* collected up to now */

#endif	/* ndef CHEST_timing_h_INCLUDED */
