// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: test.proto

package v1

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type UrlStyle int32

const (
	UrlStyle_PATH_STYLE            UrlStyle = 0
	UrlStyle_VIRTUAL_HOSTED_STYLE  UrlStyle = 1
	UrlStyle_BUCKET_BOUND_HOSTNAME UrlStyle = 2
)

// Enum value maps for UrlStyle.
var (
	UrlStyle_name = map[int32]string{
		0: "PATH_STYLE",
		1: "VIRTUAL_HOSTED_STYLE",
		2: "BUCKET_BOUND_HOSTNAME",
	}
	UrlStyle_value = map[string]int32{
		"PATH_STYLE":            0,
		"VIRTUAL_HOSTED_STYLE":  1,
		"BUCKET_BOUND_HOSTNAME": 2,
	}
)

func (x UrlStyle) Enum() *UrlStyle {
	p := new(UrlStyle)
	*p = x
	return p
}

func (x UrlStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UrlStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_test_proto_enumTypes[0].Descriptor()
}

func (UrlStyle) Type() protoreflect.EnumType {
	return &file_test_proto_enumTypes[0]
}

func (x UrlStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UrlStyle.Descriptor instead.
func (UrlStyle) EnumDescriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{0}
}

// Test resources that are necessary for a method call. For example,
// storage.objects.get would require BUCKET and OBJECT.
type Resource int32

const (
	Resource_BUCKET       Resource = 0
	Resource_OBJECT       Resource = 1
	Resource_NOTIFICATION Resource = 2
	Resource_HMAC_KEY     Resource = 3
)

// Enum value maps for Resource.
var (
	Resource_name = map[int32]string{
		0: "BUCKET",
		1: "OBJECT",
		2: "NOTIFICATION",
		3: "HMAC_KEY",
	}
	Resource_value = map[string]int32{
		"BUCKET":       0,
		"OBJECT":       1,
		"NOTIFICATION": 2,
		"HMAC_KEY":     3,
	}
)

func (x Resource) Enum() *Resource {
	p := new(Resource)
	*p = x
	return p
}

func (x Resource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Resource) Descriptor() protoreflect.EnumDescriptor {
	return file_test_proto_enumTypes[1].Descriptor()
}

func (Resource) Type() protoreflect.EnumType {
	return &file_test_proto_enumTypes[1]
}

func (x Resource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Resource.Descriptor instead.
func (Resource) EnumDescriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{1}
}

type TestFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SigningV4Tests    []*SigningV4Test    `protobuf:"bytes,1,rep,name=signing_v4_tests,json=signingV4Tests,proto3" json:"signing_v4_tests,omitempty"`
	PostPolicyV4Tests []*PostPolicyV4Test `protobuf:"bytes,2,rep,name=post_policy_v4_tests,json=postPolicyV4Tests,proto3" json:"post_policy_v4_tests,omitempty"`
	RetryTests        []*RetryTest        `protobuf:"bytes,3,rep,name=retry_tests,json=retryTests,proto3" json:"retry_tests,omitempty"`
}

func (x *TestFile) Reset() {
	*x = TestFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestFile) ProtoMessage() {}

func (x *TestFile) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestFile.ProtoReflect.Descriptor instead.
func (*TestFile) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{0}
}

func (x *TestFile) GetSigningV4Tests() []*SigningV4Test {
	if x != nil {
		return x.SigningV4Tests
	}
	return nil
}

func (x *TestFile) GetPostPolicyV4Tests() []*PostPolicyV4Test {
	if x != nil {
		return x.PostPolicyV4Tests
	}
	return nil
}

func (x *TestFile) GetRetryTests() []*RetryTest {
	if x != nil {
		return x.RetryTests
	}
	return nil
}

type SigningV4Test struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FileName                 string                 `protobuf:"bytes,1,opt,name=fileName,proto3" json:"fileName,omitempty"`
	Description              string                 `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	Bucket                   string                 `protobuf:"bytes,3,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Object                   string                 `protobuf:"bytes,4,opt,name=object,proto3" json:"object,omitempty"`
	Method                   string                 `protobuf:"bytes,5,opt,name=method,proto3" json:"method,omitempty"`
	Expiration               int64                  `protobuf:"varint,6,opt,name=expiration,proto3" json:"expiration,omitempty"`
	Timestamp                *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	ExpectedUrl              string                 `protobuf:"bytes,8,opt,name=expectedUrl,proto3" json:"expectedUrl,omitempty"`
	Headers                  map[string]string      `protobuf:"bytes,9,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	QueryParameters          map[string]string      `protobuf:"bytes,10,rep,name=query_parameters,json=queryParameters,proto3" json:"query_parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Scheme                   string                 `protobuf:"bytes,11,opt,name=scheme,proto3" json:"scheme,omitempty"`
	UrlStyle                 UrlStyle               `protobuf:"varint,12,opt,name=urlStyle,proto3,enum=google.cloud.conformance.storage.v1.UrlStyle" json:"urlStyle,omitempty"`
	BucketBoundHostname      string                 `protobuf:"bytes,13,opt,name=bucketBoundHostname,proto3" json:"bucketBoundHostname,omitempty"`
	ExpectedCanonicalRequest string                 `protobuf:"bytes,14,opt,name=expectedCanonicalRequest,proto3" json:"expectedCanonicalRequest,omitempty"`
	ExpectedStringToSign     string                 `protobuf:"bytes,15,opt,name=expectedStringToSign,proto3" json:"expectedStringToSign,omitempty"`
	Hostname                 string                 `protobuf:"bytes,16,opt,name=hostname,proto3" json:"hostname,omitempty"`
	ClientEndpoint           string                 `protobuf:"bytes,17,opt,name=clientEndpoint,proto3" json:"clientEndpoint,omitempty"`
	EmulatorHostname         string                 `protobuf:"bytes,18,opt,name=emulatorHostname,proto3" json:"emulatorHostname,omitempty"`
	UniverseDomain           string                 `protobuf:"bytes,19,opt,name=universeDomain,proto3" json:"universeDomain,omitempty"`
}

func (x *SigningV4Test) Reset() {
	*x = SigningV4Test{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SigningV4Test) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SigningV4Test) ProtoMessage() {}

func (x *SigningV4Test) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SigningV4Test.ProtoReflect.Descriptor instead.
func (*SigningV4Test) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{1}
}

func (x *SigningV4Test) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *SigningV4Test) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SigningV4Test) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *SigningV4Test) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *SigningV4Test) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *SigningV4Test) GetExpiration() int64 {
	if x != nil {
		return x.Expiration
	}
	return 0
}

func (x *SigningV4Test) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *SigningV4Test) GetExpectedUrl() string {
	if x != nil {
		return x.ExpectedUrl
	}
	return ""
}

func (x *SigningV4Test) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *SigningV4Test) GetQueryParameters() map[string]string {
	if x != nil {
		return x.QueryParameters
	}
	return nil
}

func (x *SigningV4Test) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

func (x *SigningV4Test) GetUrlStyle() UrlStyle {
	if x != nil {
		return x.UrlStyle
	}
	return UrlStyle_PATH_STYLE
}

func (x *SigningV4Test) GetBucketBoundHostname() string {
	if x != nil {
		return x.BucketBoundHostname
	}
	return ""
}

func (x *SigningV4Test) GetExpectedCanonicalRequest() string {
	if x != nil {
		return x.ExpectedCanonicalRequest
	}
	return ""
}

func (x *SigningV4Test) GetExpectedStringToSign() string {
	if x != nil {
		return x.ExpectedStringToSign
	}
	return ""
}

func (x *SigningV4Test) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *SigningV4Test) GetClientEndpoint() string {
	if x != nil {
		return x.ClientEndpoint
	}
	return ""
}

func (x *SigningV4Test) GetEmulatorHostname() string {
	if x != nil {
		return x.EmulatorHostname
	}
	return ""
}

func (x *SigningV4Test) GetUniverseDomain() string {
	if x != nil {
		return x.UniverseDomain
	}
	return ""
}

type ConditionalMatches struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Expression []string `protobuf:"bytes,1,rep,name=expression,proto3" json:"expression,omitempty"`
}

func (x *ConditionalMatches) Reset() {
	*x = ConditionalMatches{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionalMatches) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionalMatches) ProtoMessage() {}

func (x *ConditionalMatches) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionalMatches.ProtoReflect.Descriptor instead.
func (*ConditionalMatches) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{2}
}

func (x *ConditionalMatches) GetExpression() []string {
	if x != nil {
		return x.Expression
	}
	return nil
}

type PolicyConditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ContentLengthRange []int32  `protobuf:"varint,1,rep,packed,name=contentLengthRange,proto3" json:"contentLengthRange,omitempty"`
	StartsWith         []string `protobuf:"bytes,2,rep,name=startsWith,proto3" json:"startsWith,omitempty"`
}

func (x *PolicyConditions) Reset() {
	*x = PolicyConditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConditions) ProtoMessage() {}

func (x *PolicyConditions) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConditions.ProtoReflect.Descriptor instead.
func (*PolicyConditions) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{3}
}

func (x *PolicyConditions) GetContentLengthRange() []int32 {
	if x != nil {
		return x.ContentLengthRange
	}
	return nil
}

func (x *PolicyConditions) GetStartsWith() []string {
	if x != nil {
		return x.StartsWith
	}
	return nil
}

type PolicyInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// http or https
	Scheme              string                 `protobuf:"bytes,1,opt,name=scheme,proto3" json:"scheme,omitempty"`
	UrlStyle            UrlStyle               `protobuf:"varint,2,opt,name=urlStyle,proto3,enum=google.cloud.conformance.storage.v1.UrlStyle" json:"urlStyle,omitempty"`
	BucketBoundHostname string                 `protobuf:"bytes,3,opt,name=bucketBoundHostname,proto3" json:"bucketBoundHostname,omitempty"`
	Bucket              string                 `protobuf:"bytes,4,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Object              string                 `protobuf:"bytes,5,opt,name=object,proto3" json:"object,omitempty"`
	Expiration          int32                  `protobuf:"varint,6,opt,name=expiration,proto3" json:"expiration,omitempty"`
	Timestamp           *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// fields with strict equivalence which are added into
	// PolicyOutput.expectedDecodedPolicy to generate the
	// signature.
	// Expectations
	// E.1: Order them in lexigraphical order so it's the
	// signature can be verified across different language
	// implementations.
	Fields     map[string]string `protobuf:"bytes,8,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Conditions *PolicyConditions `protobuf:"bytes,9,opt,name=conditions,proto3" json:"conditions,omitempty"`
}

func (x *PolicyInput) Reset() {
	*x = PolicyInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyInput) ProtoMessage() {}

func (x *PolicyInput) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyInput.ProtoReflect.Descriptor instead.
func (*PolicyInput) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{4}
}

func (x *PolicyInput) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

func (x *PolicyInput) GetUrlStyle() UrlStyle {
	if x != nil {
		return x.UrlStyle
	}
	return UrlStyle_PATH_STYLE
}

func (x *PolicyInput) GetBucketBoundHostname() string {
	if x != nil {
		return x.BucketBoundHostname
	}
	return ""
}

func (x *PolicyInput) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *PolicyInput) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *PolicyInput) GetExpiration() int32 {
	if x != nil {
		return x.Expiration
	}
	return 0
}

func (x *PolicyInput) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *PolicyInput) GetFields() map[string]string {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *PolicyInput) GetConditions() *PolicyConditions {
	if x != nil {
		return x.Conditions
	}
	return nil
}

type PolicyOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Url                   string            `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	Fields                map[string]string `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ExpectedDecodedPolicy string            `protobuf:"bytes,3,opt,name=expectedDecodedPolicy,proto3" json:"expectedDecodedPolicy,omitempty"`
}

func (x *PolicyOutput) Reset() {
	*x = PolicyOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyOutput) ProtoMessage() {}

func (x *PolicyOutput) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyOutput.ProtoReflect.Descriptor instead.
func (*PolicyOutput) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{5}
}

func (x *PolicyOutput) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *PolicyOutput) GetFields() map[string]string {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *PolicyOutput) GetExpectedDecodedPolicy() string {
	if x != nil {
		return x.ExpectedDecodedPolicy
	}
	return ""
}

type PostPolicyV4Test struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Description  string        `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	PolicyInput  *PolicyInput  `protobuf:"bytes,2,opt,name=policyInput,proto3" json:"policyInput,omitempty"`
	PolicyOutput *PolicyOutput `protobuf:"bytes,3,opt,name=policyOutput,proto3" json:"policyOutput,omitempty"`
}

func (x *PostPolicyV4Test) Reset() {
	*x = PostPolicyV4Test{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostPolicyV4Test) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostPolicyV4Test) ProtoMessage() {}

func (x *PostPolicyV4Test) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostPolicyV4Test.ProtoReflect.Descriptor instead.
func (*PostPolicyV4Test) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{6}
}

func (x *PostPolicyV4Test) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PostPolicyV4Test) GetPolicyInput() *PolicyInput {
	if x != nil {
		return x.PolicyInput
	}
	return nil
}

func (x *PostPolicyV4Test) GetPolicyOutput() *PolicyOutput {
	if x != nil {
		return x.PolicyOutput
	}
	return nil
}

type RetryTests struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RetryTests []*RetryTest `protobuf:"bytes,1,rep,name=retryTests,proto3" json:"retryTests,omitempty"`
}

func (x *RetryTests) Reset() {
	*x = RetryTests{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryTests) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryTests) ProtoMessage() {}

func (x *RetryTests) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryTests.ProtoReflect.Descriptor instead.
func (*RetryTests) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{7}
}

func (x *RetryTests) GetRetryTests() []*RetryTest {
	if x != nil {
		return x.RetryTests
	}
	return nil
}

// A list of instructions to send as headers to the GCS emulator. Each
// instruction will force a specified failure for that request.
type InstructionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Instructions []string `protobuf:"bytes,1,rep,name=instructions,proto3" json:"instructions,omitempty"`
}

func (x *InstructionList) Reset() {
	*x = InstructionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstructionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstructionList) ProtoMessage() {}

func (x *InstructionList) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstructionList.ProtoReflect.Descriptor instead.
func (*InstructionList) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{8}
}

func (x *InstructionList) GetInstructions() []string {
	if x != nil {
		return x.Instructions
	}
	return nil
}

// A particular storage API method and required resources in order to test it.
// Methods must be implemented in tests for each language.
type Method struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      string     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"` // e.g. storage.objects.get
	Resources []Resource `protobuf:"varint,2,rep,packed,name=resources,proto3,enum=google.cloud.conformance.storage.v1.Resource" json:"resources,omitempty"`
	Group     string     `protobuf:"bytes,3,opt,name=group,proto3" json:"group,omitempty"` // e.g. storage.resumable.upload
}

func (x *Method) Reset() {
	*x = Method{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Method) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Method) ProtoMessage() {}

func (x *Method) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Method.ProtoReflect.Descriptor instead.
func (*Method) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{9}
}

func (x *Method) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Method) GetResources() []Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Method) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

// Schema for a retry test, corresponding to a single scenario from the design
// doc.
type RetryTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Scenario number
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human-readable description of the test case.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// list of emulator instruction sets.
	Cases []*InstructionList `protobuf:"bytes,3,rep,name=cases,proto3" json:"cases,omitempty"`
	// List of API methods to be tested.
	Methods []*Method `protobuf:"bytes,4,rep,name=methods,proto3" json:"methods,omitempty"`
	// Whether a precondition is provided (for conditionally-idempotent methods
	// only).
	PreconditionProvided bool `protobuf:"varint,5,opt,name=preconditionProvided,proto3" json:"preconditionProvided,omitempty"`
	// Whether we expect the method calls to eventually succeed after the client
	// library retries.
	ExpectSuccess bool `protobuf:"varint,6,opt,name=expectSuccess,proto3" json:"expectSuccess,omitempty"`
}

func (x *RetryTest) Reset() {
	*x = RetryTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_test_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryTest) ProtoMessage() {}

func (x *RetryTest) ProtoReflect() protoreflect.Message {
	mi := &file_test_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryTest.ProtoReflect.Descriptor instead.
func (*RetryTest) Descriptor() ([]byte, []int) {
	return file_test_proto_rawDescGZIP(), []int{10}
}

func (x *RetryTest) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *RetryTest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RetryTest) GetCases() []*InstructionList {
	if x != nil {
		return x.Cases
	}
	return nil
}

func (x *RetryTest) GetMethods() []*Method {
	if x != nil {
		return x.Methods
	}
	return nil
}

func (x *RetryTest) GetPreconditionProvided() bool {
	if x != nil {
		return x.PreconditionProvided
	}
	return false
}

func (x *RetryTest) GetExpectSuccess() bool {
	if x != nil {
		return x.ExpectSuccess
	}
	return false
}

var File_test_proto protoreflect.FileDescriptor

var file_test_proto_rawDesc = []byte{
	0x0a, 0x0a, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xa1, 0x02, 0x0a, 0x08, 0x54, 0x65, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0x5c, 0x0a, 0x10, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x34, 0x5f, 0x74, 0x65,
	0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x56, 0x34, 0x54, 0x65, 0x73, 0x74, 0x52, 0x0e, 0x73,
	0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x56, 0x34, 0x54, 0x65, 0x73, 0x74, 0x73, 0x12, 0x66, 0x0a,
	0x14, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x76, 0x34, 0x5f,
	0x74, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x34, 0x54, 0x65,
	0x73, 0x74, 0x52, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x34,
	0x54, 0x65, 0x73, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x74,
	0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x54, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x72, 0x65, 0x74, 0x72,
	0x79, 0x54, 0x65, 0x73, 0x74, 0x73, 0x22, 0xfd, 0x07, 0x0a, 0x0d, 0x53, 0x69, 0x67, 0x6e, 0x69,
	0x6e, 0x67, 0x56, 0x34, 0x54, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1e,
	0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65,
	0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x59, 0x0a, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x56, 0x34, 0x54, 0x65, 0x73, 0x74, 0x2e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x72, 0x0a, 0x10, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x56, 0x34, 0x54,
	0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x65, 0x12, 0x49, 0x0a, 0x08, 0x75, 0x72, 0x6c, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x72, 0x6c, 0x53, 0x74, 0x79,
	0x6c, 0x65, 0x52, 0x08, 0x75, 0x72, 0x6c, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x30, 0x0a, 0x13,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x48, 0x6f, 0x73, 0x74, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x18, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x18, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x14, 0x65, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x6f, 0x53, 0x69,
	0x67, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x6f, 0x53, 0x69, 0x67, 0x6e, 0x12, 0x1a,
	0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x10, 0x65, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x48, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x65, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26,
	0x0a, 0x0e, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x65,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x42, 0x0a, 0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x34, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x62, 0x0a, 0x10,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x2e, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x12, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x57, 0x69, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x57, 0x69, 0x74, 0x68,
	0x22, 0x94, 0x04, 0x0a, 0x0b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x75, 0x72, 0x6c, 0x53,
	0x74, 0x79, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x72, 0x6c, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x52, 0x08, 0x75, 0x72, 0x6c, 0x53, 0x74,
	0x79, 0x6c, 0x65, 0x12, 0x30, 0x0a, 0x13, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x48, 0x6f, 0x73,
	0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x54, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x55, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe8, 0x01, 0x0a, 0x0c, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x55, 0x0a, 0x06, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x12, 0x34, 0x0a, 0x15, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x15, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x65,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xdf, 0x01, 0x0a, 0x10, 0x50, 0x6f, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x56, 0x34, 0x54, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0b, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x52, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x55, 0x0a,
	0x0c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x22, 0x5c, 0x0a, 0x0a, 0x52, 0x65, 0x74, 0x72, 0x79, 0x54, 0x65, 0x73,
	0x74, 0x73, 0x12, 0x4e, 0x0a, 0x0a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x54, 0x65, 0x73, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74,
	0x72, 0x79, 0x54, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x54, 0x65, 0x73,
	0x74, 0x73, 0x22, 0x35, 0x0a, 0x0f, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x7f, 0x0a, 0x06, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xaa, 0x02, 0x0a, 0x09, 0x52,
	0x65, 0x74, 0x72, 0x79, 0x54, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x05, 0x63, 0x61,
	0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x05, 0x63, 0x61, 0x73, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x32, 0x0a,
	0x14, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x70, 0x72, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x64, 0x12, 0x24, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x53, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74,
	0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2a, 0x4f, 0x0a, 0x08, 0x55, 0x72, 0x6c, 0x53, 0x74,
	0x79, 0x6c, 0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x41, 0x54, 0x48, 0x5f, 0x53, 0x54, 0x59, 0x4c,
	0x45, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x56, 0x49, 0x52, 0x54, 0x55, 0x41, 0x4c, 0x5f, 0x48,
	0x4f, 0x53, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x19, 0x0a,
	0x15, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x48, 0x4f,
	0x53, 0x54, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x02, 0x2a, 0x42, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c,
	0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x48, 0x4d, 0x41, 0x43, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x03, 0x42, 0x7c, 0x0a, 0x27,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x6e, 0x63, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0xaa, 0x02,
	0x29, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x73, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_test_proto_rawDescOnce sync.Once
	file_test_proto_rawDescData = file_test_proto_rawDesc
)

func file_test_proto_rawDescGZIP() []byte {
	file_test_proto_rawDescOnce.Do(func() {
		file_test_proto_rawDescData = protoimpl.X.CompressGZIP(file_test_proto_rawDescData)
	})
	return file_test_proto_rawDescData
}

var file_test_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_test_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_test_proto_goTypes = []interface{}{
	(UrlStyle)(0),                 // 0: google.cloud.conformance.storage.v1.UrlStyle
	(Resource)(0),                 // 1: google.cloud.conformance.storage.v1.Resource
	(*TestFile)(nil),              // 2: google.cloud.conformance.storage.v1.TestFile
	(*SigningV4Test)(nil),         // 3: google.cloud.conformance.storage.v1.SigningV4Test
	(*ConditionalMatches)(nil),    // 4: google.cloud.conformance.storage.v1.ConditionalMatches
	(*PolicyConditions)(nil),      // 5: google.cloud.conformance.storage.v1.PolicyConditions
	(*PolicyInput)(nil),           // 6: google.cloud.conformance.storage.v1.PolicyInput
	(*PolicyOutput)(nil),          // 7: google.cloud.conformance.storage.v1.PolicyOutput
	(*PostPolicyV4Test)(nil),      // 8: google.cloud.conformance.storage.v1.PostPolicyV4Test
	(*RetryTests)(nil),            // 9: google.cloud.conformance.storage.v1.RetryTests
	(*InstructionList)(nil),       // 10: google.cloud.conformance.storage.v1.InstructionList
	(*Method)(nil),                // 11: google.cloud.conformance.storage.v1.Method
	(*RetryTest)(nil),             // 12: google.cloud.conformance.storage.v1.RetryTest
	nil,                           // 13: google.cloud.conformance.storage.v1.SigningV4Test.HeadersEntry
	nil,                           // 14: google.cloud.conformance.storage.v1.SigningV4Test.QueryParametersEntry
	nil,                           // 15: google.cloud.conformance.storage.v1.PolicyInput.FieldsEntry
	nil,                           // 16: google.cloud.conformance.storage.v1.PolicyOutput.FieldsEntry
	(*timestamppb.Timestamp)(nil), // 17: google.protobuf.Timestamp
}
var file_test_proto_depIdxs = []int32{
	3,  // 0: google.cloud.conformance.storage.v1.TestFile.signing_v4_tests:type_name -> google.cloud.conformance.storage.v1.SigningV4Test
	8,  // 1: google.cloud.conformance.storage.v1.TestFile.post_policy_v4_tests:type_name -> google.cloud.conformance.storage.v1.PostPolicyV4Test
	12, // 2: google.cloud.conformance.storage.v1.TestFile.retry_tests:type_name -> google.cloud.conformance.storage.v1.RetryTest
	17, // 3: google.cloud.conformance.storage.v1.SigningV4Test.timestamp:type_name -> google.protobuf.Timestamp
	13, // 4: google.cloud.conformance.storage.v1.SigningV4Test.headers:type_name -> google.cloud.conformance.storage.v1.SigningV4Test.HeadersEntry
	14, // 5: google.cloud.conformance.storage.v1.SigningV4Test.query_parameters:type_name -> google.cloud.conformance.storage.v1.SigningV4Test.QueryParametersEntry
	0,  // 6: google.cloud.conformance.storage.v1.SigningV4Test.urlStyle:type_name -> google.cloud.conformance.storage.v1.UrlStyle
	0,  // 7: google.cloud.conformance.storage.v1.PolicyInput.urlStyle:type_name -> google.cloud.conformance.storage.v1.UrlStyle
	17, // 8: google.cloud.conformance.storage.v1.PolicyInput.timestamp:type_name -> google.protobuf.Timestamp
	15, // 9: google.cloud.conformance.storage.v1.PolicyInput.fields:type_name -> google.cloud.conformance.storage.v1.PolicyInput.FieldsEntry
	5,  // 10: google.cloud.conformance.storage.v1.PolicyInput.conditions:type_name -> google.cloud.conformance.storage.v1.PolicyConditions
	16, // 11: google.cloud.conformance.storage.v1.PolicyOutput.fields:type_name -> google.cloud.conformance.storage.v1.PolicyOutput.FieldsEntry
	6,  // 12: google.cloud.conformance.storage.v1.PostPolicyV4Test.policyInput:type_name -> google.cloud.conformance.storage.v1.PolicyInput
	7,  // 13: google.cloud.conformance.storage.v1.PostPolicyV4Test.policyOutput:type_name -> google.cloud.conformance.storage.v1.PolicyOutput
	12, // 14: google.cloud.conformance.storage.v1.RetryTests.retryTests:type_name -> google.cloud.conformance.storage.v1.RetryTest
	1,  // 15: google.cloud.conformance.storage.v1.Method.resources:type_name -> google.cloud.conformance.storage.v1.Resource
	10, // 16: google.cloud.conformance.storage.v1.RetryTest.cases:type_name -> google.cloud.conformance.storage.v1.InstructionList
	11, // 17: google.cloud.conformance.storage.v1.RetryTest.methods:type_name -> google.cloud.conformance.storage.v1.Method
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_test_proto_init() }
func file_test_proto_init() {
	if File_test_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_test_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SigningV4Test); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionalMatches); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostPolicyV4Test); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryTests); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstructionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Method); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_test_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_test_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_test_proto_goTypes,
		DependencyIndexes: file_test_proto_depIdxs,
		EnumInfos:         file_test_proto_enumTypes,
		MessageInfos:      file_test_proto_msgTypes,
	}.Build()
	File_test_proto = out.File
	file_test_proto_rawDesc = nil
	file_test_proto_goTypes = nil
	file_test_proto_depIdxs = nil
}
