use inquire::{Text, validator::Validation};

pub fn mk_color_validator(prompt: Text) -> Text {
    prompt
        .with_help_message("(format: #xxxxxx)")
        .with_validator(|color: &str| {
            Ok(
                if color.len() == 7
                    && color.starts_with('#')
                    && color
                        .chars()
                        .skip(1)
                        .take(6)
                        .filter(|digit| digit.is_ascii_hexdigit())
                        .count()
                        == 6
                {
                    Validation::Valid
                } else {
                    Validation::Invalid("Not a color: format <#XXXXXX>".into())
                },
            )
        })
}
