use chrono::Datelike;
use time::{Date, OffsetDateTime, Time, format_description};

pub fn render_datetime_and_info(datetime: &OffsetDateTime) -> String {
    let days_passed = (OffsetDateTime::now_utc() - *datetime).whole_days();
    let at_least_one_day_passed = days_passed > 0;

    let extra_info = if at_least_one_day_passed {
        {
            let multiple_days_passed = days_passed > 1;
            let day_word = if multiple_days_passed { "days" } else { "day" };
            format!(" ({days_passed} {day_word} ago)")
        }
    } else {
        Default::default()
    };
    format!(
        "{}{extra_info}",
        datetime
            .format(
                &format_description::parse("[day].[month].[year]")
                    .expect("invalid DateTime format"),
            )
            .expect("Couldn't format DateTime'")
    )
}

pub fn render_datetime_regular(datetime: &OffsetDateTime) -> String {
    datetime
        .format(
            &format_description::parse("[day].[month].[year] [hour]:[minute]")
                .expect("invalid DateTime format"),
        )
        .expect("Couldn't format DateTime'")
}

pub fn ask_datetime(prompt: &str) -> anyhow::Result<OffsetDateTime> {
    let naive_date = inquire::DateSelect::new(prompt).prompt()?;

    Ok(OffsetDateTime::new_utc(
        Date::from_ordinal_date(naive_date.year(), naive_date.ordinal() as u16)?,
        Time::from_hms(12, 0, 0)?,
    ))
}
