use crate::actions::GlobalArgs;
use crate::actions::keys::ssh::ssh_key_identifier;
use crate::render::json::JsonToStdout;
use crate::types::context::BergContext;

use clap::Parser;
use forgejo_api::structs::UserCurrentListKeysQuery;
use itertools::Itertools;
use miette::IntoDiagnostic;

/// List all available gpg keys
#[derive(Parser, Debug)]
pub struct ListSshArgs {}

impl ListSshArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        let _ = global_args;
        let ctx = BergContext::new(self, global_args).await?;

        let options = UserCurrentListKeysQuery { fingerprint: None };

        let (_, ssh_keys) = ctx
            .client
            .user_current_list_keys(options)
            .await
            .into_diagnostic()?;

        match ctx.global_args.output_mode {
            crate::types::output::OutputMode::Pretty => {
                let key_output = ssh_keys.iter().map(ssh_key_identifier).join("\n");
                println!("{key_output}");
            }
            crate::types::output::OutputMode::Json => ssh_keys.print_json()?,
        }

        Ok(())
    }
}
