use miette::{Context, IntoDiagnostic};

use crate::actions::GlobalArgs;
use crate::types::context::BergContext;
use crate::types::git::OwnerRepo;

use clap::Parser;

/// Open the current repository in the browser
#[derive(Parser, Debug)]
pub struct RepoOpenArgs {}

impl RepoOpenArgs {
    pub async fn run(self, general_args: GlobalArgs) -> miette::Result<()> {
        let ctx = BergContext::new(self, general_args).await?;

        let OwnerRepo { owner, repo } = ctx.owner_repo()?;

        let base_url = ctx
            .config
            .url()
            .context("error while retrieving the base url for opening in browser")?;
        let repo_url = base_url
            .join(format!("{}/{}", owner, repo).as_str())
            .into_diagnostic()
            .context("error while constructing whole repo url for opening in browser")?;
        webbrowser::open(repo_url.as_str())
            .into_diagnostic()
            .context("error while opening repo url in browser")?;

        Ok(())
    }
}
