#!/bin/sh

# Setup env
set -xe
. /environ

# Clone git repository at branch / tag / commit.
REPO='https://code.videolan.org/videolan/x264'; BRANCH='stable'
git clone "$REPO" --depth=1 --branch="$BRANCH" /x264
cd /x264

# Make modifications to flags.
export CFLAGS=$(trim_spaces ${CFLAGS} \
                            -D_WASI_EMULATED_SIGNAL)
export LDFLAGS=$(trim_spaces ${LDFLAGS} \
                             -lwasi-emulated-signal)

# Configure build parameters.
#
# NOTE: ffmpeg does not support
# 2 versions of the same library
# so only build with 8 bit-depth.
./configure --host=x86-gnu \
            --prefix=/vendor \
            --exec-prefix=/vendor \
            --enable-static \
            --enable-lto \
            --disable-asm \
            --disable-opencl \
            --disable-cli \
            --disable-avs \
            --disable-gpac \
            --disable-lsmash \
            --bit-depth=all \
|| { cat config.log; exit 1; }

# Various configuration and other fixes to get build working
sed -i config.h -e 's|#define HAVE_MALLOC_H.*|#define HAVE_MALLOC_H 0|'

# Perform library install + build.
make -j $(nproc) install-lib-static

