# Generated by Django 4.2.13 on 2024-06-21 13:17

from django.db import migrations, models
import django.db.models.deletion


def merge_page_treenode(apps, schema_editor):
    Page = apps.get_model('cms', 'Page')
    db_alias = schema_editor.connection.alias

    for page in Page.objects.using(db_alias).all():
        page.depth = page.node.depth
        page.path = page.node.path
        page.site = page.node.site
        page.numchild = page.node.numchild
        if page.node.parent:
            pages = page.node.parent.cms_pages.all()
            assert len(pages) == 1
            page.parent = pages.first()
        else:
            page.parent = None
        page.save()


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('cms', '0035_auto_20230822_2208_squashed_0036_auto_20240311_1028'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='page',
            options={'default_permissions': ['add', 'change', 'delete'], 'ordering': ['path'], 'permissions': [('view_page', 'Can view page'), ('publish_page', 'Can publish page'), ('edit_static_placeholder', 'Can edit static placeholders')], 'verbose_name': 'page', 'verbose_name_plural': 'pages'},
        ),
        migrations.AlterModelOptions(
            name='treenode',
            options={'default_permissions': [], 'ordering': ['path']},
        ),
        migrations.AddField(
            model_name='page',
            name='depth',
            field=models.PositiveIntegerField(default=0),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='page',
            name='numchild',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='page',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='cms.page'),
        ),
        migrations.AddField(
            model_name='page',
            name='path',
            field=models.CharField(default=None, null=True, max_length=255, unique=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='page',
            name='site',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='djangocms_pages', to='sites.site', verbose_name='site'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='page',
            name='is_page_type',
            field=models.BooleanField(default=False, help_text='Mark this page as a page type'),
        ),
        migrations.RunPython(merge_page_treenode, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name='page',
            name='depth',
            field=models.PositiveIntegerField(),
        ),
        migrations.AlterField(
            model_name='page',
            name='path',
            field=models.CharField(max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name='page',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='djangocms_pages', to='sites.site', verbose_name='site'),
        ),
    ]
