# Generated by Django 4.2.16 on 2024-11-14 06:48

from django.db import migrations
from django.db.models import Count


def remove_pageurl_duplicates(apps, schema_editor):
    PageUrl = apps.get_model("cms", "PageUrl")
    non_unique = PageUrl.objects.values("page_id", "language").annotate(total=Count("language")).filter(total__gt=1)
    for item in non_unique:
        for url in PageUrl.objects.filter(page_id=item["page_id"], language=item["language"]).order_by("-pk")[1:]:
            url.delete()


class Migration(migrations.Migration):
    dependencies = [
        ("cms", "0038_alter_page_site"),
    ]

    operations = [
        migrations.RunPython(remove_pageurl_duplicates, reverse_code=migrations.RunPython.noop),
        migrations.RemoveField(
            model_name="page",
            name="languages",
        ),
        migrations.AlterUniqueTogether(
            name="pageurl",
            unique_together={("language", "page")},
        ),
    ]
