/* composite.c generated by valac 0.56.17, the Vala compiler
 * generated from composite.vala, do not modify */

/* libenchant: Composite dictionaries
 * Copyright (C) 2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib-object.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_COMPOSITE_DICT (enchant_composite_dict_get_type ())
#define ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict))
#define ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))
#define IS_ENCHANT_COMPOSITE_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_COMPOSITE_DICT))
#define IS_ENCHANT_COMPOSITE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_COMPOSITE_DICT))
#define ENCHANT_COMPOSITE_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDictClass))

typedef struct _EnchantCompositeDict EnchantCompositeDict;
typedef struct _EnchantCompositeDictClass EnchantCompositeDictClass;
typedef struct _EnchantCompositeDictPrivate EnchantCompositeDictPrivate;

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef struct _ParamSpecEnchantCompositeDict ParamSpecEnchantCompositeDict;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _EnchantDictPrivate EnchantDictPrivate;

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);
#define _enchant_dict_unref0(var) ((var == NULL) ? NULL : (var = (enchant_dict_unref (var), NULL)))
#define _enchant_composite_dict_unref0(var) ((var == NULL) ? NULL : (var = (enchant_composite_dict_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantCompositeDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantCompositeDictPrivate * priv;
	GSList* dict_list;
};

struct _EnchantCompositeDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantCompositeDict *self);
};

struct _ParamSpecEnchantCompositeDict {
	GParamSpec parent_instance;
};

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

static gpointer enchant_composite_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_composite_dict_ref (gpointer instance);
VALA_EXTERN void enchant_composite_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_composite_dict (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_enchant_composite_dict (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_enchant_composite_dict (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_composite_dict (const GValue* value);
VALA_EXTERN GType enchant_composite_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantCompositeDict, enchant_composite_dict_unref)
VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_new (void);
VALA_EXTERN EnchantCompositeDict* enchant_composite_dict_construct (GType object_type);
static void enchant_composite_dict_finalize (EnchantCompositeDict * obj);
static GType enchant_composite_dict_get_type_once (void);
VALA_EXTERN gint composite_dict_check (EnchantDict* _self_,
                           const gchar* word_buf,
                           size_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN gint enchant_dict_check (EnchantDict* _self_,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gchar** composite_dict_suggest (EnchantDict* me,
                                const gchar* word,
                                size_t len,
                                size_t* result_length1);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
VALA_EXTERN gchar** enchant_dict_suggest (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len,
                              size_t* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN void composite_dict_add_to_session (EnchantDict* me,
                                    const gchar* word,
                                    size_t len);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
VALA_EXTERN void composite_dict_remove_from_session (EnchantDict* me,
                                         const gchar* word,
                                         size_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

EnchantCompositeDict*
enchant_composite_dict_construct (GType object_type)
{
	EnchantCompositeDict* self = NULL;
#line 29 "composite.vala"
	self = (EnchantCompositeDict*) g_type_create_instance (object_type);
#line 29 "composite.vala"
	return self;
#line 235 "composite.c"
}

EnchantCompositeDict*
enchant_composite_dict_new (void)
{
#line 29 "composite.vala"
	return enchant_composite_dict_construct (TYPE_ENCHANT_COMPOSITE_DICT);
#line 243 "composite.c"
}

static void
value_enchant_composite_dict_init (GValue* value)
{
#line 29 "composite.vala"
	value->data[0].v_pointer = NULL;
#line 251 "composite.c"
}

static void
value_enchant_composite_dict_free_value (GValue* value)
{
#line 29 "composite.vala"
	if (value->data[0].v_pointer) {
#line 29 "composite.vala"
		enchant_composite_dict_unref (value->data[0].v_pointer);
#line 261 "composite.c"
	}
}

static void
value_enchant_composite_dict_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
#line 29 "composite.vala"
	if (src_value->data[0].v_pointer) {
#line 29 "composite.vala"
		dest_value->data[0].v_pointer = enchant_composite_dict_ref (src_value->data[0].v_pointer);
#line 273 "composite.c"
	} else {
#line 29 "composite.vala"
		dest_value->data[0].v_pointer = NULL;
#line 277 "composite.c"
	}
}

static gpointer
value_enchant_composite_dict_peek_pointer (const GValue* value)
{
#line 29 "composite.vala"
	return value->data[0].v_pointer;
#line 286 "composite.c"
}

static gchar*
value_enchant_composite_dict_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
#line 29 "composite.vala"
	if (collect_values[0].v_pointer) {
#line 297 "composite.c"
		EnchantCompositeDict * object;
		object = collect_values[0].v_pointer;
#line 29 "composite.vala"
		if (object->parent_instance.g_class == NULL) {
#line 29 "composite.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 304 "composite.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 29 "composite.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 308 "composite.c"
		}
#line 29 "composite.vala"
		value->data[0].v_pointer = enchant_composite_dict_ref (object);
#line 312 "composite.c"
	} else {
#line 29 "composite.vala"
		value->data[0].v_pointer = NULL;
#line 316 "composite.c"
	}
#line 29 "composite.vala"
	return NULL;
#line 320 "composite.c"
}

static gchar*
value_enchant_composite_dict_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	EnchantCompositeDict ** object_p;
	object_p = collect_values[0].v_pointer;
#line 29 "composite.vala"
	if (!object_p) {
#line 29 "composite.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 335 "composite.c"
	}
#line 29 "composite.vala"
	if (!value->data[0].v_pointer) {
#line 29 "composite.vala"
		*object_p = NULL;
#line 341 "composite.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 29 "composite.vala"
		*object_p = value->data[0].v_pointer;
#line 345 "composite.c"
	} else {
#line 29 "composite.vala"
		*object_p = enchant_composite_dict_ref (value->data[0].v_pointer);
#line 349 "composite.c"
	}
#line 29 "composite.vala"
	return NULL;
#line 353 "composite.c"
}

GParamSpec*
param_spec_enchant_composite_dict (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	ParamSpecEnchantCompositeDict* spec;
#line 29 "composite.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_COMPOSITE_DICT), NULL);
#line 29 "composite.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 29 "composite.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 29 "composite.vala"
	return G_PARAM_SPEC (spec);
#line 372 "composite.c"
}

gpointer
value_get_enchant_composite_dict (const GValue* value)
{
#line 29 "composite.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_COMPOSITE_DICT), NULL);
#line 29 "composite.vala"
	return value->data[0].v_pointer;
#line 382 "composite.c"
}

void
value_set_enchant_composite_dict (GValue* value,
                                  gpointer v_object)
{
	EnchantCompositeDict * old;
#line 29 "composite.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_COMPOSITE_DICT));
#line 29 "composite.vala"
	old = value->data[0].v_pointer;
#line 29 "composite.vala"
	if (v_object) {
#line 29 "composite.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_COMPOSITE_DICT));
#line 29 "composite.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "composite.vala"
		value->data[0].v_pointer = v_object;
#line 29 "composite.vala"
		enchant_composite_dict_ref (value->data[0].v_pointer);
#line 404 "composite.c"
	} else {
#line 29 "composite.vala"
		value->data[0].v_pointer = NULL;
#line 408 "composite.c"
	}
#line 29 "composite.vala"
	if (old) {
#line 29 "composite.vala"
		enchant_composite_dict_unref (old);
#line 414 "composite.c"
	}
}

void
value_take_enchant_composite_dict (GValue* value,
                                   gpointer v_object)
{
	EnchantCompositeDict * old;
#line 29 "composite.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_COMPOSITE_DICT));
#line 29 "composite.vala"
	old = value->data[0].v_pointer;
#line 29 "composite.vala"
	if (v_object) {
#line 29 "composite.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_COMPOSITE_DICT));
#line 29 "composite.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "composite.vala"
		value->data[0].v_pointer = v_object;
#line 435 "composite.c"
	} else {
#line 29 "composite.vala"
		value->data[0].v_pointer = NULL;
#line 439 "composite.c"
	}
#line 29 "composite.vala"
	if (old) {
#line 29 "composite.vala"
		enchant_composite_dict_unref (old);
#line 445 "composite.c"
	}
}

static void
enchant_composite_dict_class_init (EnchantCompositeDictClass * klass,
                                   gpointer klass_data)
{
#line 29 "composite.vala"
	enchant_composite_dict_parent_class = g_type_class_peek_parent (klass);
#line 29 "composite.vala"
	((EnchantCompositeDictClass *) klass)->finalize = enchant_composite_dict_finalize;
#line 457 "composite.c"
}

static void
enchant_composite_dict_instance_init (EnchantCompositeDict * self,
                                      gpointer klass)
{
#line 29 "composite.vala"
	self->ref_count = 1;
#line 466 "composite.c"
}

static void
enchant_composite_dict_finalize (EnchantCompositeDict * obj)
{
	EnchantCompositeDict * self;
#line 29 "composite.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict);
#line 29 "composite.vala"
	g_signal_handlers_destroy (self);
#line 30 "composite.vala"
	(self->dict_list == NULL) ? NULL : (self->dict_list = (g_slist_free (self->dict_list), NULL));
#line 479 "composite.c"
}

static GType
enchant_composite_dict_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_composite_dict_init, value_enchant_composite_dict_free_value, value_enchant_composite_dict_copy_value, value_enchant_composite_dict_peek_pointer, "p", value_enchant_composite_dict_collect_value, "p", value_enchant_composite_dict_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantCompositeDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_composite_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantCompositeDict), 0, (GInstanceInitFunc) enchant_composite_dict_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_composite_dict_type_id;
	enchant_composite_dict_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantCompositeDict", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_composite_dict_type_id;
}

GType
enchant_composite_dict_get_type (void)
{
	static volatile gsize enchant_composite_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_composite_dict_type_id__once)) {
		GType enchant_composite_dict_type_id;
		enchant_composite_dict_type_id = enchant_composite_dict_get_type_once ();
		g_once_init_leave (&enchant_composite_dict_type_id__once, enchant_composite_dict_type_id);
	}
	return enchant_composite_dict_type_id__once;
}

gpointer
enchant_composite_dict_ref (gpointer instance)
{
	EnchantCompositeDict * self;
	self = instance;
#line 29 "composite.vala"
	g_atomic_int_inc (&self->ref_count);
#line 29 "composite.vala"
	return instance;
#line 514 "composite.c"
}

void
enchant_composite_dict_unref (gpointer instance)
{
	EnchantCompositeDict * self;
	self = instance;
#line 29 "composite.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 29 "composite.vala"
		ENCHANT_COMPOSITE_DICT_GET_CLASS (self)->finalize (self);
#line 29 "composite.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 528 "composite.c"
	}
}

static gpointer
_enchant_composite_dict_ref0 (gpointer self)
{
#line 42 "composite.vala"
	return self ? enchant_composite_dict_ref (self) : NULL;
#line 537 "composite.c"
}

static gpointer
_enchant_dict_ref0 (gpointer self)
{
#line 44 "composite.vala"
	return self ? enchant_dict_ref (self) : NULL;
#line 545 "composite.c"
}

gint
composite_dict_check (EnchantDict* _self_,
                      const gchar* word_buf,
                      size_t len)
{
	gboolean _tmp0_ = FALSE;
	gchar* word = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	EnchantCompositeDict* cdict = NULL;
	void* _tmp3_;
	EnchantCompositeDict* _tmp4_;
	gint err = 0;
	EnchantCompositeDict* _tmp5_;
	GSList* _tmp6_;
	gint result;
#line 33 "composite.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 34 "composite.vala"
	if (_self_ == NULL) {
#line 34 "composite.vala"
		_tmp0_ = TRUE;
#line 570 "composite.c"
	} else {
#line 34 "composite.vala"
		_tmp0_ = word_buf == NULL;
#line 574 "composite.c"
	}
#line 34 "composite.vala"
	if (_tmp0_) {
#line 35 "composite.vala"
		result = -1;
#line 35 "composite.vala"
		return result;
#line 582 "composite.c"
	}
#line 36 "composite.vala"
	_tmp1_ = buf_to_utf8_string (word_buf, (gssize) ((ssize_t) len));
#line 36 "composite.vala"
	word = _tmp1_;
#line 37 "composite.vala"
	_tmp2_ = word;
#line 37 "composite.vala"
	if (_tmp2_ == NULL) {
#line 38 "composite.vala"
		result = -1;
#line 38 "composite.vala"
		_g_free0 (word);
#line 38 "composite.vala"
		return result;
#line 598 "composite.c"
	}
#line 42 "composite.vala"
	_tmp3_ = _self_->user_data;
#line 42 "composite.vala"
	_tmp4_ = _enchant_composite_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 42 "composite.vala"
	cdict = _tmp4_;
#line 43 "composite.vala"
	err = -1;
#line 44 "composite.vala"
	_tmp5_ = cdict;
#line 44 "composite.vala"
	_tmp6_ = _tmp5_->dict_list;
#line 612 "composite.c"
	{
		GSList* dict_collection = NULL;
		GSList* dict_it = NULL;
#line 44 "composite.vala"
		dict_collection = _tmp6_;
#line 44 "composite.vala"
		for (dict_it = dict_collection; dict_it != NULL; dict_it = dict_it->next) {
#line 620 "composite.c"
			EnchantDict* _tmp7_;
			EnchantDict* dict = NULL;
#line 44 "composite.vala"
			_tmp7_ = _enchant_dict_ref0 ((EnchantDict*) dict_it->data);
#line 44 "composite.vala"
			dict = _tmp7_;
#line 627 "composite.c"
			{
				gint found = 0;
				EnchantDict* _tmp8_;
				const gchar* _tmp9_;
#line 45 "composite.vala"
				_tmp8_ = dict;
#line 45 "composite.vala"
				_tmp9_ = word;
#line 45 "composite.vala"
				found = enchant_dict_check (_tmp8_, _tmp9_, (ssize_t) len);
#line 46 "composite.vala"
				if (found == 0) {
#line 47 "composite.vala"
					result = 0;
#line 47 "composite.vala"
					_enchant_dict_unref0 (dict);
#line 47 "composite.vala"
					_enchant_composite_dict_unref0 (cdict);
#line 47 "composite.vala"
					_g_free0 (word);
#line 47 "composite.vala"
					return result;
#line 650 "composite.c"
				}
#line 48 "composite.vala"
				if (found == 1) {
#line 49 "composite.vala"
					err = 1;
#line 656 "composite.c"
				}
#line 44 "composite.vala"
				_enchant_dict_unref0 (dict);
#line 660 "composite.c"
			}
		}
	}
#line 51 "composite.vala"
	result = err;
#line 51 "composite.vala"
	_enchant_composite_dict_unref0 (cdict);
#line 51 "composite.vala"
	_g_free0 (word);
#line 51 "composite.vala"
	return result;
#line 672 "composite.c"
}

static void
_g_free0_ (gpointer var)
{
#line 58 "composite.vala"
	var = (g_free (var), NULL);
#line 680 "composite.c"
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
#line 58 "composite.vala"
	self = *((gchar**) data);
#line 58 "composite.vala"
	_g_free0_ (self);
#line 691 "composite.c"
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
#line 70 "composite.vala"
	if (length >= 0) {
#line 700 "composite.c"
		gchar** result;
		gssize i;
#line 70 "composite.vala"
		result = g_new0 (gchar*, length + 1);
#line 70 "composite.vala"
		for (i = 0; i < length; i++) {
#line 707 "composite.c"
			gchar* _tmp0_;
#line 70 "composite.vala"
			_tmp0_ = g_strdup (self[i]);
#line 70 "composite.vala"
			result[i] = _tmp0_;
#line 713 "composite.c"
		}
#line 70 "composite.vala"
		return result;
#line 717 "composite.c"
	}
#line 70 "composite.vala"
	return NULL;
#line 721 "composite.c"
}

gchar**
composite_dict_suggest (EnchantDict* me,
                        const gchar* word,
                        size_t len,
                        size_t* result_length1)
{
	EnchantCompositeDict* cdict = NULL;
	void* _tmp0_;
	EnchantCompositeDict* _tmp1_;
	gboolean _error_ = FALSE;
	GArray* res = NULL;
	GArray* _tmp2_;
	EnchantCompositeDict* _tmp3_;
	GSList* _tmp4_;
	GArray* _tmp19_;
	gpointer* _tmp20_;
	gint _tmp20__length1;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** result;
#line 55 "composite.vala"
	g_return_val_if_fail (me != NULL, NULL);
#line 55 "composite.vala"
	g_return_val_if_fail (word != NULL, NULL);
#line 56 "composite.vala"
	_tmp0_ = me->user_data;
#line 56 "composite.vala"
	_tmp1_ = _enchant_composite_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 56 "composite.vala"
	cdict = _tmp1_;
#line 57 "composite.vala"
	_error_ = TRUE;
#line 58 "composite.vala"
	_tmp2_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
#line 58 "composite.vala"
	g_array_set_clear_func (_tmp2_, (GDestroyNotify) _vala_gchar_free_function_content_of);
#line 58 "composite.vala"
	res = _tmp2_;
#line 59 "composite.vala"
	_tmp3_ = cdict;
#line 59 "composite.vala"
	_tmp4_ = _tmp3_->dict_list;
#line 768 "composite.c"
	{
		GSList* dict_collection = NULL;
		GSList* dict_it = NULL;
#line 59 "composite.vala"
		dict_collection = _tmp4_;
#line 59 "composite.vala"
		for (dict_it = dict_collection; dict_it != NULL; dict_it = dict_it->next) {
#line 776 "composite.c"
			EnchantDict* _tmp5_;
			EnchantDict* dict = NULL;
#line 59 "composite.vala"
			_tmp5_ = _enchant_dict_ref0 ((EnchantDict*) dict_it->data);
#line 59 "composite.vala"
			dict = _tmp5_;
#line 783 "composite.c"
			{
				gchar** suggs = NULL;
				EnchantDict* _tmp6_;
				size_t _tmp7_ = 0;
				gchar** _tmp8_;
				gint suggs_length1;
				gint _suggs_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
#line 60 "composite.vala"
				_tmp6_ = dict;
#line 60 "composite.vala"
				_tmp8_ = enchant_dict_suggest (_tmp6_, word, (ssize_t) len, &_tmp7_);
#line 60 "composite.vala"
				suggs = _tmp8_;
#line 60 "composite.vala"
				suggs_length1 = _tmp7_;
#line 60 "composite.vala"
				_suggs_size_ = suggs_length1;
#line 61 "composite.vala"
				_tmp9_ = suggs;
#line 61 "composite.vala"
				_tmp9__length1 = suggs_length1;
#line 61 "composite.vala"
				if (_tmp9_ != NULL) {
#line 809 "composite.c"
					gchar** _tmp10_;
					gint _tmp10__length1;
#line 62 "composite.vala"
					_error_ = FALSE;
#line 63 "composite.vala"
					_tmp10_ = suggs;
#line 63 "composite.vala"
					_tmp10__length1 = suggs_length1;
#line 63 "composite.vala"
					if (_tmp10__length1 > 0) {
#line 820 "composite.c"
						{
							size_t i = 0UL;
#line 64 "composite.vala"
							i = (size_t) 0;
#line 825 "composite.c"
							{
								gboolean _tmp11_ = FALSE;
#line 64 "composite.vala"
								_tmp11_ = TRUE;
#line 64 "composite.vala"
								while (TRUE) {
#line 832 "composite.c"
									gchar** _tmp13_;
									gint _tmp13__length1;
									GArray* _tmp14_;
									gchar** _tmp15_;
									gint _tmp15__length1;
									const gchar* _tmp16_;
									gchar* _tmp17_;
#line 64 "composite.vala"
									if (!_tmp11_) {
#line 842 "composite.c"
										size_t _tmp12_;
#line 64 "composite.vala"
										_tmp12_ = i;
#line 64 "composite.vala"
										i = _tmp12_ + 1;
#line 848 "composite.c"
									}
#line 64 "composite.vala"
									_tmp11_ = FALSE;
#line 64 "composite.vala"
									_tmp13_ = suggs;
#line 64 "composite.vala"
									_tmp13__length1 = suggs_length1;
#line 64 "composite.vala"
									if (!(i < ((size_t) _tmp13__length1))) {
#line 64 "composite.vala"
										break;
#line 860 "composite.c"
									}
#line 65 "composite.vala"
									_tmp14_ = res;
#line 65 "composite.vala"
									_tmp15_ = suggs;
#line 65 "composite.vala"
									_tmp15__length1 = suggs_length1;
#line 65 "composite.vala"
									_tmp16_ = _tmp15_[i];
#line 65 "composite.vala"
									_tmp17_ = g_strdup (_tmp16_);
#line 65 "composite.vala"
									g_array_append_val (_tmp14_, _tmp17_);
#line 874 "composite.c"
								}
							}
						}
					}
				}
#line 59 "composite.vala"
				suggs = (_vala_array_free (suggs, suggs_length1, (GDestroyNotify) g_free), NULL);
#line 59 "composite.vala"
				_enchant_dict_unref0 (dict);
#line 884 "composite.c"
			}
		}
	}
#line 68 "composite.vala"
	if (_error_ == TRUE) {
#line 890 "composite.c"
		gchar** _tmp18_;
		gint _tmp18__length1;
#line 69 "composite.vala"
		_tmp18_ = NULL;
#line 69 "composite.vala"
		_tmp18__length1 = 0;
#line 69 "composite.vala"
		if (result_length1) {
#line 69 "composite.vala"
			*result_length1 = _tmp18__length1;
#line 901 "composite.c"
		}
#line 69 "composite.vala"
		result = _tmp18_;
#line 69 "composite.vala"
		_g_array_unref0 (res);
#line 69 "composite.vala"
		_enchant_composite_dict_unref0 (cdict);
#line 69 "composite.vala"
		return result;
#line 911 "composite.c"
	}
#line 70 "composite.vala"
	_tmp19_ = res;
#line 70 "composite.vala"
	_tmp20_ = _tmp19_->data;
#line 70 "composite.vala"
	_tmp20__length1 = _tmp19_->len;
#line 70 "composite.vala"
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup1 (_tmp20_, _tmp20__length1) : _tmp20_;
#line 70 "composite.vala"
	_tmp21__length1 = _tmp20__length1;
#line 70 "composite.vala"
	_tmp22_ = _tmp21_;
#line 70 "composite.vala"
	_tmp22__length1 = _tmp21__length1;
#line 70 "composite.vala"
	if (result_length1) {
#line 70 "composite.vala"
		*result_length1 = _tmp22__length1;
#line 931 "composite.c"
	}
#line 70 "composite.vala"
	result = _tmp22_;
#line 70 "composite.vala"
	_g_array_unref0 (res);
#line 70 "composite.vala"
	_enchant_composite_dict_unref0 (cdict);
#line 70 "composite.vala"
	return result;
#line 941 "composite.c"
}

void
composite_dict_add_to_session (EnchantDict* me,
                               const gchar* word,
                               size_t len)
{
	EnchantCompositeDict* cdict = NULL;
	void* _tmp0_;
	EnchantCompositeDict* _tmp1_;
	GSList* _tmp2_;
	GSList* _tmp3_;
	gconstpointer _tmp4_;
#line 73 "composite.vala"
	g_return_if_fail (me != NULL);
#line 73 "composite.vala"
	g_return_if_fail (word != NULL);
#line 74 "composite.vala"
	_tmp0_ = me->user_data;
#line 74 "composite.vala"
	_tmp1_ = _enchant_composite_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 74 "composite.vala"
	cdict = _tmp1_;
#line 75 "composite.vala"
	_tmp2_ = cdict->dict_list;
#line 75 "composite.vala"
	_vala_assert (g_slist_length (_tmp2_) > ((guint) 0), "cdict.dict_list.length() > 0");
#line 76 "composite.vala"
	_tmp3_ = cdict->dict_list;
#line 76 "composite.vala"
	_tmp4_ = _tmp3_->data;
#line 76 "composite.vala"
	enchant_dict_add_to_session ((EnchantDict*) _tmp4_, word, (ssize_t) len);
#line 73 "composite.vala"
	_enchant_composite_dict_unref0 (cdict);
#line 977 "composite.c"
}

void
composite_dict_remove_from_session (EnchantDict* me,
                                    const gchar* word,
                                    size_t len)
{
	EnchantCompositeDict* cdict = NULL;
	void* _tmp0_;
	EnchantCompositeDict* _tmp1_;
	GSList* _tmp2_;
	GSList* _tmp3_;
	gconstpointer _tmp4_;
#line 79 "composite.vala"
	g_return_if_fail (me != NULL);
#line 79 "composite.vala"
	g_return_if_fail (word != NULL);
#line 80 "composite.vala"
	_tmp0_ = me->user_data;
#line 80 "composite.vala"
	_tmp1_ = _enchant_composite_dict_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ENCHANT_COMPOSITE_DICT, EnchantCompositeDict));
#line 80 "composite.vala"
	cdict = _tmp1_;
#line 81 "composite.vala"
	_tmp2_ = cdict->dict_list;
#line 81 "composite.vala"
	_vala_assert (g_slist_length (_tmp2_) > ((guint) 0), "cdict.dict_list.length() > 0");
#line 82 "composite.vala"
	_tmp3_ = cdict->dict_list;
#line 82 "composite.vala"
	_tmp4_ = _tmp3_->data;
#line 82 "composite.vala"
	enchant_dict_remove_from_session ((EnchantDict*) _tmp4_, word, (ssize_t) len);
#line 79 "composite.vala"
	_enchant_composite_dict_unref0 (cdict);
#line 1013 "composite.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

