#ifndef PACKAGE__PROG__PRJLIBS__DIEWARN_H
#define PACKAGE__PROG__PRJLIBS__DIEWARN_H

#define DIE1X(status,x0)          strerr_die((status),PROG,": ",(x0))
#define DIE2X(status,x0,x1)       strerr_die((status),PROG,": ",(x0),(x1))
#define DIE3X(status,x0,x1,x2)    strerr_die((status),PROG,": ",(x0),(x1),(x2))
#define DIE4X(status,x0,x1,x2,x3) strerr_die((status),PROG,": ",(x0),(x1),\
                                             (x2),(x3))

#define DIE_USAGE(x0) strerr_die(100, "usage: ", PROG, x0)
#define DIE_OVERFLOW() DIE1X(100, "arithmetic overflow")
#define DIE_NOTSET(x0) DIE2X(100, "variable not set: ", (x0))
#define DIE_MALFORMED(x0, x1) DIE4X(100, "malformed ", (x0), ": ", (x1))
#define DIE_MALFORMED_FD(x) DIE_MALFORMED("descriptor", x)

#define DIESTAT(op) \
  ((op[0]=='e' && op[1]=='x' && op[2]=='e' && op[3]=='c' && op[4]=='\0' \
    && errno==ENOENT)? 127: (error_temp(errno)? 111: 100))

#define WARNTEXT0_alloc          "allocate memory"
#define WARNTEXT0_fork           "create process"
#define WARNTEXT0_wait           "wait for child process"
#define WARNTEXT0_dup            "duplicate descriptor"
#define WARNTEXT0_dup2           WARNTEXT0_dup
#define WARNTEXT0_pipe           "create pipe"
#define WARNTEXT0_socket         "create socket"
#define WARNTEXT0_setuid         "set user id"
#define WARNTEXT0_setgid         "set group id"
#define WARNTEXT0_setgroups      "set supplementary groups"
#define WARNTEXT0_tcgetattr      "get terminal attributes"
#define WARNTEXT0_tcsetattr      "set terminal attributes"
#define WARNTEXT0_tcsetpgrp      "set foreground process group id"
#define WARNTEXT0_tcdrain        "drain terminal output"
#define WARNTEXT0_setpgid        "set process group id"
#define WARNTEXT0_setsid         "set session id"
#define WARNTEXT0_sigemptyset    "empty signal set"
#define WARNTEXT0_sigaddset      "add signal to set"
#define WARNTEXT0_sigdelset      "remove signal from set"
#define WARNTEXT0_sigaction      "set signal action"
#define WARNTEXT0_sigprocmask    "set signal mask"
#define WARNTEXT0_sigsuspend     "suspend process"
#define WARNTEXT0_setitimer      "set timer"
#define WARNTEXT0_tioccons       "redirect console messages"
#define WARNTEXT0_vt_act         "activate console"
#define WARNTEXT0_vt_qry         "find available console"
#define WARNTEXT0_vt_getm        "get VT mode"
#define WARNTEXT0_vt_setm        "set VT mode"
#define WARNTEXT0_gethostname    "get hostname"
#define WARNTEXT0_buffer_prefeed "prefeed buffer"
#define WARNTEXT1_mkdir          "create directory"
#define WARNTEXT1_chdir          "chdir to"
#define WARNTEXT1_chroot         "chroot to"
#define WARNTEXT1_chown          "change ownership of"
#define WARNTEXT1_stat           "stat"
#define WARNTEXT1_exec           "execute"
#define WARNTEXT1_unlink         "remove"
#define WARNTEXT1_utimes         "set timestamp of"
#define WARNTEXT1_open           "open"
#define WARNTEXT1_close          "close"
#define WARNTEXT1_read           "read"
#define WARNTEXT1_write          "write"
#define WARNTEXT1_getfl          "get descriptor flags for"
#define WARNTEXT1_setfl          "set descriptor flags for"
#define WARNTEXT1_mmap           "create memory map for"
#define WARNTEXT1_lseek          "set descriptor position for"
#define WARNTEXT1_fsync          "commit modifications to"
#define WARNTEXT1_connect        "connect to"
#define WARNTEXT2_link           "link"
#define WARNSEP2_link            " to "
#define WARNTEXT2_rename         "rename"
#define WARNSEP2_rename          " to "

#define WARNTEXT_unable(n, op) ": unable to " op
#define WARNTEXT0(op) WARNTEXT_unable(0, op) ": "
#define WARNTEXT1(op) WARNTEXT_unable(1, op) " "
#define WARNTEXT2(op) WARNTEXT_unable(2, op) " "

#define WARN0(op)       strerr_warnsys(PROG, WARNTEXT0(WARNTEXT0_##op))
#define WARN1(op,x0)    strerr_warnsys(PROG, WARNTEXT1(WARNTEXT1_##op), (x0), \
                                       ": ")
#define WARN2(op,x0,x1) strerr_warnsys(PROG, WARNTEXT2(WARNTEXT2_##op), (x0), \
                                       WARNSEP2_##op, (x1), ": ")

#define DIE0(op)       strerr_diesys(DIESTAT(#op), PROG, \
                                     WARNTEXT0(WARNTEXT0_##op))
#define DIE1(op,x0)    strerr_diesys(DIESTAT(#op), PROG, \
                                     WARNTEXT1(WARNTEXT1_##op), (x0), ": ")
#define DIE2(op,x0,x1) strerr_diesys(DIESTAT(#op), PROG, \
                                     WARNTEXT2(WARNTEXT2_##op), (x0),\
                                     WARNSEP2_##op, (x1), ": ")

#endif
