#include "standards.h"
#include <string.h>

#include "vec.h"

type_status vec_insn(size_t typesize, vec_type* v, size_t i, void const* d,
                     size_t n) {
  size_t newlen=v->len/typesize;
  if (i>newlen) return (errno=EINVAL, -1);
  if (vec_alloc(typesize, v, n, 1)!=0) return -1;
  newlen+=n;
  newlen*=typesize;
  i*=typesize;
  n*=typesize;
  v->len=newlen;
  memmove(v->s+i+n, v->s+i, newlen-i-n);
  if (d!=NULL) memcpy(v->s+i, d, n);
  return 0;
}
