#include "prjlibs-c/standards.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <signal.h>

#include "prjlibs-c/types.h"
#include "fdtools.h"
#include "cmsg.h"

type_status fd_xfer_send(type_fd sock, type_fd const* fds, size_t nfds) {
  struct sigaction pipe_ignore, pipe_save;
  type_status status;
  type_error error;
  char iov_buf[1]="";
  struct iovec iov={ iov_buf, sizeof iov_buf };
  struct msghdr msg={ NULL, 0, &iov, 1, NULL, 0, 0 };
  struct cmsghdr* cmsg;
  size_t const arrsize=nfds*sizeof (type_fd);
  msg.msg_controllen=CMSG_SPACE(arrsize);
  if (nfds==0 || arrsize/sizeof (type_fd)!=nfds || msg.msg_controllen<arrsize)
    { errno=EINVAL; return -1; }
  msg.msg_control=malloc(msg.msg_controllen);
  if (msg.msg_control==NULL) return -1;
  cmsg=CMSG_FIRSTHDR(&msg);
  cmsg->cmsg_len=CMSG_LEN(arrsize);
  cmsg->cmsg_level=SOL_SOCKET;
  cmsg->cmsg_type=SCM_RIGHTS;
  memcpy(CMSG_DATA(cmsg), fds, arrsize);
  msg.msg_controllen=cmsg->cmsg_len;
  pipe_ignore.sa_handler=SIG_IGN;
  sigemptyset(&pipe_ignore.sa_mask);
  pipe_ignore.sa_flags=0;
  if (sigaction(SIGPIPE, &pipe_ignore, &pipe_save)!=0) return -1;
  status=-1;
  do { if (sendmsg(sock, &msg, 0)>=0) { status=0; break; } }
  while (errno==EINTR);
  error=errno;
  if (sigaction(SIGPIPE, &pipe_save, NULL)!=0) return -1;
  errno=error;
  return status;
}
