#include "prjlibs-c/standards.h"
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/constants.h"
#include "prjlibs-c/diewarn.h"
#include "prjlibs-c/types.h"
#include "fdtools.h"

char const* PROG="grabconsole";

int main(int argc, char** argv) {
  int fd;
  type_bool scan;

  if (argc<2) DIE_USAGE(" file [program ...]");

  fd=fd_scan_or_open(&scan, argv[1], O_RDONLY, 0);
  if (fd<0) {
    if (scan) DIE_MALFORMED_FD(argv[1]);
    else DIE1(open, argv[1]);
  }

  if (fd_grabconsole(fd)!=0) DIE0(tioccons);

  argv+=2;
  mexec0((char const**)argv);
  DIE1(exec, argv[0]);
}
