#include "prjlibs-c/standards.h"
#include <unistd.h>
#include <limits.h>
#include <errno.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/constants.h"
#include "prjlibs-c/diewarn.h"
#include "fdtools.h"
#include "check_exit_exec.h"

char const* PROG="seek0";

int main(int argc, char** argv) {
  for (argv+=(argc!=0);; ++argv) {
    char const* const arg=*argv;
    unsigned int fd, len;

    check_exit_exec(argv);

    len=uint_scan(arg, &fd);
    if (len==0 || arg[len]!='\0' || fd>INT_MAX) DIE_MALFORMED_FD(arg);

    if (lseek(fd, 0, SEEK_SET)==-1) DIE1(lseek, arg);
  }
}
