#include "prjlibs-c/standards.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/diewarn.h"
#include "prjlibs-c/types.h"
#include "fdtools.h"

char const* PROG="sendfd";

int main(int argc, char** argv) {
  type_fd* fds;
  unsigned int sock;
  type_len pos;
  size_t nfds, allocsize, i;
  if (argc<3 || strcmp(argv[2], ":")==0)
    DIE_USAGE(" socket fd [...] [: program ...]");
  pos=uint_scan(argv[1], &sock);
  if (pos==0 || argv[1][pos]!='\0' || sock>INT_MAX)
    DIE_MALFORMED_FD(argv[1]);
  argv+=2;
  for (nfds=0; argv[nfds]!=NULL && strcmp(argv[nfds], ":")!=0; ++nfds);
  allocsize=nfds*sizeof (type_fd);
  if (allocsize/sizeof (type_fd)!=nfds) DIE_OVERFLOW();
  fds=malloc(allocsize);
  if (fds==NULL) DIE0(alloc);
  for (i=0; i!=nfds; ++i) {
    unsigned int fd;
    type_len const pos=uint_scan(argv[i], &fd);
    if (pos==0 || argv[i][pos]!='\0' || fd>INT_MAX)
      DIE_MALFORMED_FD(argv[i]);
    fds[i]=fd;
  }
  if (fd_xfer_send(sock, fds, nfds)!=0) DIE1(write, "to socket");
  argv+=nfds;
  if (*argv==NULL) _exit(0);
  ++argv;
  mexec0((char const**)argv);
  DIE1(exec, argv[0]);
}
