#include "prjlibs-c/standards.h"
#include <unistd.h>
#include <limits.h>
#include <errno.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/constants.h"
#include "prjlibs-c/diewarn.h"
#include "fdtools.h"
#include "check_exit_exec.h"

char const* PROG="setblock";

int main(int argc, char** argv) {
  for (argv+=(argc!=0);; ++argv) {
    char const* arg=*argv;
    int block;
    unsigned int fd, len;

    check_exit_exec(argv);

    block=(arg[0]=='+');
    if (arg[0]!='+' && arg[0]!='-')
      DIE_USAGE(" {+|-}fd [...] [: program ...]");

    ++arg;
    len=uint_scan(arg, &fd);
    if (len==0 || arg[len]!='\0' || fd>INT_MAX) DIE_MALFORMED_FD(arg);

    if ((block? ndelay_off: ndelay_on)(fd)!=0) DIE1(setfl, arg);
  }
}
