#include "prjlibs-c/standards.h"
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/vt.h>
#include <sys/sysmacros.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/constants.h"
#include "prjlibs-c/diewarn.h"
#include "prjlibs-c/types.h"
#include "fdtools.h"

char const* PROG="vc-get";
#define dev_tty "/dev/tty"

int main(int argc, char** argv) {
  if (argc<3) DIE_USAGE(" {fd|/dev/ttyN} program [arg ...]");

  {
    int fd;
    type_bool scan;
    char buf[sizeof dev_tty+(sizeof (int)*CHAR_BIT+2)/3]=dev_tty;

    fd=fd_scan_or_open(&scan, argv[1], O_RDONLY, 0);
    if (fd<0) {
      if (scan) DIE_MALFORMED_FD(argv[1]);
      else DIE1(open, argv[1]);
    }

    {
      int vtnum=-1;
      char* const bufnum=buf+sizeof dev_tty-1;
      errno=0;
      if (ioctl(fd, VT_OPENQRY, &vtnum)<0 || vtnum==-1) DIE0(vt_qry);
      bufnum[ulong_fmt(bufnum, vtnum)]='\0';
      if (env_mexec("TTY", buf)==0) DIE0(alloc);
    }
    fd_close(fd);

    fd=open(buf, O_RDWR|O_NOCTTY);
    if (fd<0) DIE1(open, buf);

    {
      struct stat statbuf;
      if (fstat(fd, &statbuf)!=0) DIE1(stat, buf);
      buf[ulong_fmt(buf, minor(statbuf.st_rdev))]='\0';
    }
    if (env_mexec("VCNUM", buf)==0) DIE0(alloc);

    buf[ulong_fmt(buf, fd)]='\0';
    if (env_mexec("VCFD", buf)==0) DIE0(alloc);
  }

  mexec((char const**)argv+2);
  DIE1(exec, argv[2]);
}
