#include "prjlibs-c/standards.h"
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/vt.h>
#include <sys/sysmacros.h>

#include <skalibs/stddjb.h>
#include "prjlibs-c/constants.h"
#include "prjlibs-c/diewarn.h"
#include "prjlibs-c/types.h"
#include "fdtools.h"

char const* PROG="vc-switch";

int main(int argc, char** argv) {
  int fd;
  type_bool scan;
  unsigned int ttyno, len;

  if (argc<3) DIE_USAGE(" {fd|/dev/ttyN} vc-number [program arg ...]");

  fd=fd_scan_or_open(&scan, argv[1], O_RDONLY, 0);
  if (fd<0) {
    if (scan) DIE_MALFORMED_FD(argv[1]);
    else DIE1(open, argv[1]);
  }

  len=uint_scan(argv[2], &ttyno);
  if (len==0 || argv[2][len]!='\0') DIE_MALFORMED("tty number", argv[2]);

  if (ioctl(fd, VT_ACTIVATE, ttyno)<0) DIE0(vt_act);
  if (!scan) fd_close(fd);

  mexec0((char const**)argv+3);
  DIE1(exec, argv[3]);
}
