#ifndef DIGEST_H
#define DIGEST_H  1


/* ========================================================================== */
/* Include files */


/*! \addtogroup DIGEST */
/*! @{ */


/* ========================================================================== */
/* Constants */

/*! \name Lenght of message digests */
/*! @{ */
#define DIGEST_SHA1_160_LEN  (size_t) 20  /*!< \brief 160 bit */
#define DIGEST_SHA2_256_LEN  (size_t) 32  /*!< \brief 256 bit */
/*! @} */

/*! \name Size of randomart images */
/*! @{ */
#define DIGEST_RA_X  (size_t) 17  /*!< \brief Field width: 17 units */
#define DIGEST_RA_Y  (size_t) 9   /*!< \brief Field height: 9 units */
/*! @} */


/*! @} */


/* ========================================================================== */
/* Function prototypes */

int  digest_sha1_160(const char*, size_t, unsigned char*);
int  digest_sha2_256(const char*, size_t, unsigned char*);
int  digest_randomart(const char*, const char*, size_t);
void  digest_init(void);
void  digest_exit(void);


#endif  /* DIGEST_H */

/* EOF */
