# ==============================================================================
# Delete duplicate strings and garbage
#
# Copyright (c) 2012-2013 by the developers. See the LICENSE file for details.


# ==============================================================================
# Get string number from environment and init current string

BEGIN \
{
   num = ENVIRON["NUM"]
   n = 0
   ready = 0
   s = "$ "
}


# ==============================================================================
# Ignore comments starting with "$ "

/^\$[ ]/ \
{
   print
   next
}


# ==============================================================================
# Ignore empty lines

/^$/ \
{
   print
   next
}


# ==============================================================================
# Delete duplicate strings

{
   rv = match($0, /^".*"/)
   if (1 == rv)
   {
      # Count strings
      ++n
      if (!ready) \
      {
         # Check whether current string is the requested one
         if (0 + num == n) \
         {
            # Yes => Store string
            s = substr($0, RSTART, RLENGTH)
            ready = 1
         }
         print
      }
      else \
      {
         # Print anything that is not a duplicate of the requested string
         cs = substr($0, RSTART, RLENGTH)
         if (cs == s) \
         {
            system("printf \"Duplicate NLS string found and removed.\\n\" >&2")
         }
         else print
      }
   }
   next
}


# EOF
