/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef JPIC0_I_ICONV_NAME_H
#define JPIC0_I_ICONV_NAME_H  1

#include "libjpiconv-0/iconv_table.h"


/*
 * Header file for encoding names
 *
 * This file is used by the library and will not be installed.
 */


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/* IANA encoding names are limited to 40 US-ASCII characters */
#define JPIC0_I_NAME_MAX  40U


/*
 * Accept IANA alias names too, if nonzero.
 * Can be disabled to reduce memory footprint.
 */
#define JPIC0_I_NAME_ENABLE_ALIASES  1


/*
 * Accept some nonstandard alias names too, if nonzero.
 * Can be disabled to reduce memory footprint.
 */
#define JPIC0_I_NAME_ENABLE_NONSTANDARD  1


/* Encoding name/table definition */
struct jpic0_i_name_def
{
    const char               *name;   /* Name of encoding (string) */
    const jpic0_i_iso2022_jp *table;  /* Mapping table */
};


/* Data type for name/table definition */
typedef struct jpic0_i_name_def  jpic0_i_name_def;


/* Name to table mappings */
extern const jpic0_i_name_def jpic0_i_name_src[];
#if JPIC0_I_NAME_ENABLE_ALIASES
extern const jpic0_i_name_def jpic0_i_name_src_alias[];
#endif  /* JPIC0_I_NAME_ENABLE_ALIASES */
#if JPIC0_I_NAME_ENABLE_NONSTANDARD
extern const jpic0_i_name_def jpic0_i_name_src_nonstd[];
#endif  /* JPIC0_I_NAME_ENABLE_NONSTANDARD */


/*! \endcond */


#pragma GCC visibility pop


#endif  /* JPIC0_I_ICONV_NAME_H */
