/*
 * Definition of pairs with encoding name and mapping table
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include <stddef.h>

#include "libjpiconv-0/iconv_name.h"
#include "libjpiconv-0/iconv_table.h"


/* ========================================================================== */
/* IANA names supported as source encoding only */
const jpic0_i_name_def jpic0_i_name_src[] =
{
    { "ISO-2022-JP", jpic0_i_iso2022_jp_table },

    { NULL, NULL }
};


#if JPIC0_I_NAME_ENABLE_ALIASES
/* ========================================================================== */
/* IANA aliases supported as source encoding only */
const jpic0_i_name_def jpic0_i_name_src_alias[] =
{
    { "CSISO2022JP", jpic0_i_iso2022_jp_table },

    { NULL, NULL }
};
#endif  /* JPIC0_I_NAME_ENABLE_ALIASES */


#if JPIC0_I_NAME_ENABLE_NONSTANDARD
/* ========================================================================== */
/* Nonstandard aliases supported as source encoding only */
const jpic0_i_name_def jpic0_i_name_src_nonstd[] =
{
    { NULL, NULL }
};
#endif  /* JPIC0_I_NAME_ENABLE_NONSTANDARD */
