/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef UCIC0_I_NONIDENT_H
#define UCIC0_I_NONIDENT_H  1

#include "iconv_private.h"


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/*
 * Execute nonidentical conversion
 *
 * Used for invalid or unknown input data on request.
 * Consumes one octet from input buffer on success (the caller must ensure it
 * is present).
 *
 * Returns zero (false / no error) on success, 'errno' will be set otherwise.
 */
ucic0_i_bool ucic0_i_nonident(ucic0_i_state *state);


/*! \endcond */


#pragma GCC visibility pop


#endif  /* UCIC0_I_NONIDENT_H */
