# fsNotifier for FreeBSD

Adaptation of 
[JetBrains' fsNotifier](https://github.com/JetBrains/intellij-community/tree/master/native/fsNotifier/linux) 
to work on FreeBSD, largely inspired by the modifications made by the user `t6` at the (now 404'd) 
[GitHub repository](https://github.com/t6/fsnotifier) by the name of `fsnotifier`.

Dynamically and statically linked libraries and executables for `fsnotifier` are built by this CMake project.

## Compilation

```shell
mkdir build
cd build
cmake -G{Ninja,"Unix Makefiles"} -DCMAKE_BUILD_TYPE={Release,Debug,RelWithDebInfo} -DLOG_LEVEL={0,1,2} ..
cmake --build .
```

## Installation

```shell
sudo cmake --install .
```

This CMake project exports its installation targets for ease of use in other CMake projects.

## Usage

```shell
fsnotifier{,-static} --version
fsnotifier{,-static} --selftest
```

## JetBrains IDE usage simulation

```commandline
fsnotifier{,-static}
ROOTS
/usr/include
#
```

('/usr/include' can be replaced by some other path, or by several other paths separated by 
line breaks.)

## List of dynamically linked libraries

```shell
[user@pc /somewhere]$ readelf -d <prefix>/bin/fsnotifier{,-static}

File: <prefix>/bin/fsnotifier

Dynamic section at offset 0x2ad0 contains 27 entries:
  Tag                Type                  Name/Value
 0x000000000000001d RUNPATH              Library runpath: [<prefix>/lib]
 0x0000000000000001 NEEDED               Shared library: [libfsnotifier.so.20230720.1554]
 0x0000000000000001 NEEDED               Shared library: [libinotify.so.0]
 0x0000000000000001 NEEDED               Shared library: [libthr.so.3]
 0x0000000000000001 NEEDED               Shared library: [libc.so.7]
 0x0000000000000015 DEBUG                0x0
 0x0000000000000007 RELA                 0x200ca8
 0x0000000000000008 RELASZ               96 (bytes)
 0x0000000000000009 RELAENT              24 (bytes)
 0x0000000000000017 JMPREL               0x200d08
 0x0000000000000002 PLTRELSZ             1008 (bytes)
 0x0000000000000003 PLTGOT               0x205c88
 0x0000000000000014 PLTREL               RELA
 0x0000000000000006 SYMTAB               0x200308
 0x000000000000000b SYMENT               24 (bytes)
 0x0000000000000005 STRTAB               0x200a50
 0x000000000000000a STRSZ                600 (bytes)
 0x000000006ffffef5 GNU_HASH             0x200868
 0x0000000000000004 HASH                 0x2008b0
 0x0000000000000019 INIT_ARRAY          
 0x000000000000001b INIT_ARRAYSZ         8 (bytes)
 0x000000000000000c INIT                 0x2037cc
 0x000000000000000d FINI                 0x2037dc
 0x000000006ffffff0 VERSYM               0x2007d0
 0x000000006ffffffe VERNEED              0x200838
 0x000000006fffffff VERNEEDNUM           1
 0x0000000000000000 NULL                 0x0

File: <prefix>/bin/fsnotifier-static

There is no dynamic section in this file.
```

## Uninstall

```shell
sudo xargs rm < install_manifest.txt
```