/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 12 "src/parser/parser.ypp"

#include <cstdint>
#include <cstdlib>
#include <iostream>
#include <vector>

#include "utils.hpp"
#include "parser/ast.hpp"
#include "proofs/dichotomy.hpp"
#include "parser/parser.hpp"

#define yyerror(msg) my_yyerror(yylloc, msg)

int yylex(YYSTYPE *yylval_param, YYLTYPE *yylloc_param);

#define error(msg) \
  std::cerr << "Error: " << msg << " at line " << yylloc.first_line << " column " << yylloc.first_column << '\n'
#define warning(msg) \
  std::cerr << "Warning: " << msg << " at line " << yylloc.first_line << " column " << yylloc.first_column << '\n'

int my_yyerror(YYLTYPE &yylloc, char const *errstr) {
    error(errstr);
    return EXIT_FAILURE;
}

#define failure(msg) do {\
  error(msg); \
  YYERROR; \
} while (0)

extern void register_user_rewrite(ast_real const *, ast_real const *, hint_cond_vect *);
extern void generate_all_approx();
extern void generate_graph(ast_prop const *p);
extern void parse_property_tree(property_tree &tree, ast_prop const *p);
extern void test_ringularity(ast_real const *, ast_real const *, bool);
extern int test_rewriting(ast_real const *, ast_real const *, std::string &);
extern void check_approx(ast_real const *);
extern std::set< ast_real const * > free_variables;
extern bool parameter_rfma;

static ast_number const *negative_number(ast_number const *nn) {
  if (nn->base == 0) return nn;
  ast_number n = *nn;
  char &c = n.mantissa[0];
  assert(c == '+');
  c = '-';
  return normalize(n);
}

static function_class const *rounding_mode = NULL;

static ast_real const *rnd_normalize(ast_real const &real) {
  ast_real const *r = normalize(real, true);
  if (!rounding_mode) return r;
  return normalize(ast_real(real_op(rounding_mode, r)), true);
}

static uintptr_t read_integer_param(ast_number const *n)
{
  return (static_cast<uintptr_t>(atoi(n->mantissa.c_str())) * 2) | 1;
}

static std::vector<function_generator *> user_functions;

RUN_LAST(free_generators) {
  for (function_generator *i: user_functions) {
    delete i;
  }
  user_functions.clear();
}

#define YYINCLUDED_STDLIB_H


#line 146 "src/parser/parser.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parser.hpp"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_PAR = 3,                        /* PAR  */
  YYSYMBOL_IN = 4,                         /* IN  */
  YYSYMBOL_SQRT = 5,                       /* SQRT  */
  YYSYMBOL_FMA = 6,                        /* FMA  */
  YYSYMBOL_NE = 7,                         /* NE  */
  YYSYMBOL_LE = 8,                         /* LE  */
  YYSYMBOL_GE = 9,                         /* GE  */
  YYSYMBOL_RDIV = 10,                      /* RDIV  */
  YYSYMBOL_FIX = 11,                       /* FIX  */
  YYSYMBOL_FLT = 12,                       /* FLT  */
  YYSYMBOL_NUMBER = 13,                    /* NUMBER  */
  YYSYMBOL_IDENT = 14,                     /* IDENT  */
  YYSYMBOL_VARID = 15,                     /* VARID  */
  YYSYMBOL_FUNID = 16,                     /* FUNID  */
  YYSYMBOL_IMPL = 17,                      /* IMPL  */
  YYSYMBOL_OR = 18,                        /* OR  */
  YYSYMBOL_AND = 19,                       /* AND  */
  YYSYMBOL_NOT = 20,                       /* NOT  */
  YYSYMBOL_21_ = 21,                       /* '+'  */
  YYSYMBOL_22_ = 22,                       /* '-'  */
  YYSYMBOL_NEG = 23,                       /* NEG  */
  YYSYMBOL_24_ = 24,                       /* '*'  */
  YYSYMBOL_25_ = 25,                       /* '/'  */
  YYSYMBOL_26_ = 26,                       /* '{'  */
  YYSYMBOL_27_ = 27,                       /* '}'  */
  YYSYMBOL_28_ = 28,                       /* '('  */
  YYSYMBOL_29_ = 29,                       /* ','  */
  YYSYMBOL_30_ = 30,                       /* ')'  */
  YYSYMBOL_31_ = 31,                       /* '['  */
  YYSYMBOL_32_ = 32,                       /* ']'  */
  YYSYMBOL_33_ = 33,                       /* '?'  */
  YYSYMBOL_34_ = 34,                       /* '|'  */
  YYSYMBOL_35_ = 35,                       /* '='  */
  YYSYMBOL_36_ = 36,                       /* ';'  */
  YYSYMBOL_37_ = 37,                       /* '<'  */
  YYSYMBOL_38_ = 38,                       /* '>'  */
  YYSYMBOL_39_ = 39,                       /* '@'  */
  YYSYMBOL_40_ = 40,                       /* '$'  */
  YYSYMBOL_41_ = 41,                       /* '~'  */
  YYSYMBOL_YYACCEPT = 42,                  /* $accept  */
  YYSYMBOL_BLOB = 43,                      /* BLOB  */
  YYSYMBOL_BLOB1 = 44,                     /* BLOB1  */
  YYSYMBOL_PROP = 45,                      /* PROP  */
  YYSYMBOL_INTSEP = 46,                    /* INTSEP  */
  YYSYMBOL_MINUS = 47,                     /* MINUS  */
  YYSYMBOL_SNUMBER = 48,                   /* SNUMBER  */
  YYSYMBOL_INTEGER = 49,                   /* INTEGER  */
  YYSYMBOL_SINTEGER = 50,                  /* SINTEGER  */
  YYSYMBOL_FUNCTION_PARAM = 51,            /* FUNCTION_PARAM  */
  YYSYMBOL_FUNCTION_PARAMS_AUX = 52,       /* FUNCTION_PARAMS_AUX  */
  YYSYMBOL_FUNCTION_PARAMS = 53,           /* FUNCTION_PARAMS  */
  YYSYMBOL_FUNCTION = 54,                  /* FUNCTION  */
  YYSYMBOL_EQUAL = 55,                     /* EQUAL  */
  YYSYMBOL_PROG = 56,                      /* PROG  */
  YYSYMBOL_REAL = 57,                      /* REAL  */
  YYSYMBOL_REALS = 58,                     /* REALS  */
  YYSYMBOL_DPOINTS = 59,                   /* DPOINTS  */
  YYSYMBOL_DVAR = 60,                      /* DVAR  */
  YYSYMBOL_DVARS = 61,                     /* DVARS  */
  YYSYMBOL_PRECOND = 62,                   /* PRECOND  */
  YYSYMBOL_PRECONDS_AUX = 63,              /* PRECONDS_AUX  */
  YYSYMBOL_PRECONDS = 64,                  /* PRECONDS  */
  YYSYMBOL_HINTS = 65                      /* HINTS  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  4
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   401

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  42
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  24
/* YYNRULES -- Number of rules.  */
#define YYNRULES  86
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  206

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   276


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,    40,     2,     2,     2,
      28,    30,    24,    21,    29,    22,     2,    25,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    36,
      37,    35,    38,    33,    39,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    31,     2,    32,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    26,    34,    27,    41,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    23
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   138,   138,   139,   142,   147,   149,   151,   153,   154,
     156,   158,   160,   162,   164,   166,   168,   169,   175,   176,
     177,   178,   179,   181,   181,   183,   183,   186,   187,   188,
     191,   198,   205,   206,   209,   210,   218,   219,   222,   235,
     236,   238,   239,   250,   258,   259,   260,   261,   264,   265,
     266,   267,   276,   285,   286,   287,   288,   289,   290,   291,
     298,   299,   300,   303,   304,   311,   312,   315,   316,   317,
     320,   321,   328,   329,   330,   331,   332,   335,   336,   343,
     344,   346,   347,   367,   383,   390,   402
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "PAR", "IN", "SQRT",
  "FMA", "NE", "LE", "GE", "RDIV", "FIX", "FLT", "NUMBER", "IDENT",
  "VARID", "FUNID", "IMPL", "OR", "AND", "NOT", "'+'", "'-'", "NEG", "'*'",
  "'/'", "'{'", "'}'", "'('", "','", "')'", "'['", "']'", "'?'", "'|'",
  "'='", "';'", "'<'", "'>'", "'@'", "'$'", "'~'", "$accept", "BLOB",
  "BLOB1", "PROP", "INTSEP", "MINUS", "SNUMBER", "INTEGER", "SINTEGER",
  "FUNCTION_PARAM", "FUNCTION_PARAMS_AUX", "FUNCTION_PARAMS", "FUNCTION",
  "EQUAL", "PROG", "REAL", "REALS", "DPOINTS", "DVAR", "DVARS", "PRECOND",
  "PRECONDS_AUX", "PRECONDS", "HINTS", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-100)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -100,    14,  -100,   100,  -100,   195,    -3,  -100,  -100,   266,
     182,   -11,     9,    22,    32,  -100,  -100,  -100,    27,   266,
     290,   290,    65,   266,   290,   290,   104,    85,   164,   -28,
    -100,    97,   290,   242,   241,   101,  -100,  -100,   290,   290,
     290,   290,   270,  -100,  -100,   290,   290,    63,    63,  -100,
     280,   217,    86,    24,  -100,   -25,   266,   266,   266,   290,
     290,   290,    48,   290,    52,    52,   290,   290,   290,  -100,
    -100,   290,   290,   290,   290,   290,   290,   290,  -100,   154,
    -100,   121,   304,   334,   343,   352,  -100,  -100,   105,   127,
    -100,  -100,  -100,    13,   314,   170,  -100,  -100,   290,   290,
    -100,    31,   290,  -100,   256,   126,  -100,    83,   376,    73,
     130,    52,  -100,   376,  -100,  -100,   139,   370,    63,  -100,
    -100,   376,   232,    63,   376,   102,  -100,   120,  -100,   290,
      52,   156,  -100,  -100,   270,  -100,   209,   298,  -100,    52,
    -100,  -100,  -100,  -100,    67,   129,   181,   290,   134,  -100,
    -100,  -100,   361,   150,   153,  -100,   176,   194,  -100,    98,
      52,  -100,  -100,  -100,    52,    52,  -100,     1,  -100,   287,
    -100,   290,  -100,  -100,   190,   200,    52,  -100,   129,   187,
     129,    52,    52,    52,    52,    52,  -100,   290,   324,  -100,
    -100,  -100,    52,  -100,    52,  -100,  -100,  -100,  -100,  -100,
    -100,  -100,   196,   204,  -100,  -100
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
      41,     0,    81,     0,     1,     2,     0,    44,    45,     0,
       0,     0,     0,     0,     0,    49,    51,    50,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    63,     0,
      39,     0,     0,     0,     0,     0,    46,    47,     0,     0,
       0,     0,     0,    38,    21,     0,     0,    61,    62,    48,
       0,     0,     0,    67,    70,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    25,
      26,     0,     0,     0,     0,     0,     0,     0,    40,     0,
       3,     0,     0,     0,     0,     0,    27,    33,     0,     0,
      31,    32,    34,     0,     0,     0,    22,    60,     0,     0,
      57,     0,     0,    85,    20,    19,    18,     0,    63,     0,
       0,     0,     8,    17,     4,     9,     0,    79,    53,    55,
      56,    16,     0,    54,    64,     0,    42,     0,    58,     0,
       0,     0,    28,    29,     0,    37,     0,     0,    30,     0,
      68,    71,    84,    52,     0,     0,     0,     0,     0,    86,
      83,    43,     0,     0,     0,    35,     0,     0,    65,     0,
       0,    15,    23,    24,     0,     0,    12,     0,    77,     0,
      82,     0,     5,     6,     0,     0,     0,    69,     0,     0,
       0,     0,     0,     0,     0,     0,    80,     0,     0,    14,
      11,    66,     0,     7,     0,    72,    73,    74,    75,    76,
      78,    59,     0,     0,    13,    10
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -100,  -100,  -100,    34,   137,   -35,   -59,    91,   -99,   103,
    -100,  -100,    -4,  -100,  -100,    -5,   186,  -100,   165,   -56,
      71,  -100,  -100,  -100
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,     1,     2,    26,   164,    75,    90,   140,    91,    92,
      93,    43,    27,    32,     3,    34,    29,   159,    54,    55,
     168,   169,   148,     5
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
      28,    76,    31,   107,   102,   114,   115,    89,   181,   182,
     183,   103,    77,    18,     4,    47,    48,    38,    51,    52,
      53,   125,    68,    69,    70,    71,    72,    79,   101,    89,
      89,   153,    30,    82,    83,    84,    85,    39,   184,   185,
      94,    95,   134,    33,   138,    68,    69,    70,    71,    72,
      40,   135,   145,    44,    53,   108,   110,    50,   113,   139,
      41,   116,   117,   118,    42,    86,   119,   120,   121,   122,
     123,   124,    53,    88,    69,    70,    89,   127,    49,   111,
     158,   112,   195,   196,   197,   198,   199,    71,    72,    98,
     104,   105,   106,   136,   137,    89,    99,    53,   160,    89,
     161,   178,    76,   143,    89,   179,   180,    68,    69,    70,
      71,    72,   102,    60,     6,     7,     8,   191,   132,   142,
     100,    56,    57,    58,   152,    89,     9,   176,   177,    89,
      89,   102,    78,   202,   144,   203,    81,    18,   150,    10,
     133,    89,   167,   146,    59,    58,    89,    89,    89,    89,
      89,    68,    69,    70,    71,    72,   151,    89,   162,    89,
      68,    69,    70,    71,    72,   163,   188,    61,    62,   138,
     170,    63,    64,    65,    66,    68,    69,    70,    71,    72,
     172,    67,   167,   173,   174,    68,    69,    70,    71,    72,
     126,    68,    69,    70,    71,    72,    35,    36,    37,    73,
      11,    12,   175,   189,   100,    74,    13,    14,    15,    16,
      17,    18,   165,   190,   166,    19,    20,    21,    22,   193,
      61,    62,   154,    23,    63,    64,    65,    66,   204,    24,
      68,    69,    70,    71,    72,    25,   205,   155,    68,    69,
      70,    71,    72,   156,    61,    62,   109,    97,    63,    64,
      65,    66,    73,    68,    69,    70,    71,    72,   200,    56,
      57,    58,    68,    69,    70,    71,    72,   141,   149,    80,
       0,    11,    12,    56,    57,    58,    73,    13,    14,    15,
      16,    17,    18,    86,    87,     0,    19,    20,    21,    22,
       0,    88,    69,    70,    23,    11,    12,    56,    57,    58,
      24,     0,     0,    15,    16,    17,    18,     0,     0,     0,
      96,    20,    21,    22,   186,   192,   187,   194,    45,    68,
      69,    70,    71,    72,    46,    68,    69,    70,    71,    72,
       0,     0,   157,     0,   128,    68,    69,    70,    71,    72,
       0,     0,     0,     0,    97,    68,    69,    70,    71,    72,
       0,     0,     0,     0,   201,    68,    69,    70,    71,    72,
       0,     0,     0,   129,    68,    69,    70,    71,    72,     0,
       0,     0,   130,    68,    69,    70,    71,    72,     0,     0,
       0,   131,    68,    69,    70,    71,    72,     0,     0,     0,
     171,    68,    69,    70,    71,    72,   147,    68,    69,    70,
      71,    72
};

static const yytype_int16 yycheck[] =
{
       5,    29,     6,    59,    29,    64,    65,    42,     7,     8,
       9,    36,    40,    16,     0,    20,    21,    28,    23,    24,
      25,    77,    21,    22,    23,    24,    25,    32,     4,    64,
      65,   130,    35,    38,    39,    40,    41,    28,    37,    38,
      45,    46,    29,     9,    13,    21,    22,    23,    24,    25,
      28,    38,   111,    19,    59,    60,    61,    23,    63,    28,
      28,    66,    67,    68,    37,    13,    71,    72,    73,    74,
      75,    76,    77,    21,    22,    23,   111,    81,    13,    31,
     139,    33,   181,   182,   183,   184,   185,    24,    25,     3,
      56,    57,    58,    98,    99,   130,    10,   102,    31,   134,
      33,   160,    29,    30,   139,   164,   165,    21,    22,    23,
      24,    25,    29,    28,    14,    15,    16,   176,    13,    36,
      34,    17,    18,    19,   129,   160,    26,    29,    30,   164,
     165,    29,    35,   192,     4,   194,    35,    16,    36,    39,
      13,   176,   147,     4,    40,    19,   181,   182,   183,   184,
     185,    21,    22,    23,    24,    25,    36,   192,    29,   194,
      21,    22,    23,    24,    25,    36,   171,     3,     4,    13,
      36,     7,     8,     9,    10,    21,    22,    23,    24,    25,
      30,    17,   187,    30,     8,    21,    22,    23,    24,    25,
      36,    21,    22,    23,    24,    25,    14,    15,    16,    35,
       5,     6,     8,    13,    34,    41,    11,    12,    13,    14,
      15,    16,    31,    13,    33,    20,    21,    22,    23,    32,
       3,     4,   131,    28,     7,     8,     9,    10,    32,    34,
      21,    22,    23,    24,    25,    40,    32,   134,    21,    22,
      23,    24,    25,    34,     3,     4,    60,    30,     7,     8,
       9,    10,    35,    21,    22,    23,    24,    25,   187,    17,
      18,    19,    21,    22,    23,    24,    25,   102,    36,    27,
      -1,     5,     6,    17,    18,    19,    35,    11,    12,    13,
      14,    15,    16,    13,    14,    -1,    20,    21,    22,    23,
      -1,    21,    22,    23,    28,     5,     6,    17,    18,    19,
      34,    -1,    -1,    13,    14,    15,    16,    -1,    -1,    -1,
      30,    21,    22,    23,    27,   178,    29,   180,    28,    21,
      22,    23,    24,    25,    34,    21,    22,    23,    24,    25,
      -1,    -1,    34,    -1,    30,    21,    22,    23,    24,    25,
      -1,    -1,    -1,    -1,    30,    21,    22,    23,    24,    25,
      -1,    -1,    -1,    -1,    30,    21,    22,    23,    24,    25,
      -1,    -1,    -1,    29,    21,    22,    23,    24,    25,    -1,
      -1,    -1,    29,    21,    22,    23,    24,    25,    -1,    -1,
      -1,    29,    21,    22,    23,    24,    25,    -1,    -1,    -1,
      29,    21,    22,    23,    24,    25,    26,    21,    22,    23,
      24,    25
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    43,    44,    56,     0,    65,    14,    15,    16,    26,
      39,     5,     6,    11,    12,    13,    14,    15,    16,    20,
      21,    22,    23,    28,    34,    40,    45,    54,    57,    58,
      35,    54,    55,    45,    57,    14,    15,    16,    28,    28,
      28,    28,    37,    53,    45,    28,    34,    57,    57,    13,
      45,    57,    57,    57,    60,    61,    17,    18,    19,    40,
      28,     3,     4,     7,     8,     9,    10,    17,    21,    22,
      23,    24,    25,    35,    41,    47,    29,    40,    35,    57,
      27,    35,    57,    57,    57,    57,    13,    14,    21,    47,
      48,    50,    51,    52,    57,    57,    30,    30,     3,    10,
      34,     4,    29,    36,    45,    45,    45,    61,    57,    58,
      57,    31,    33,    57,    48,    48,    57,    57,    57,    57,
      57,    57,    57,    57,    57,    61,    36,    54,    30,    29,
      29,    29,    13,    13,    29,    38,    57,    57,    13,    28,
      49,    60,    36,    30,     4,    48,     4,    26,    64,    36,
      36,    36,    57,    50,    49,    51,    34,    34,    48,    59,
      31,    33,    29,    36,    46,    31,    33,    57,    62,    63,
      36,    29,    30,    30,     8,     8,    29,    30,    48,    48,
      48,     7,     8,     9,    37,    38,    27,    29,    57,    13,
      13,    48,    46,    32,    46,    50,    50,    50,    50,    50,
      62,    30,    48,    48,    32,    32
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    42,    43,    44,    45,    45,    45,    45,    45,    45,
      45,    45,    45,    45,    45,    45,    45,    45,    45,    45,
      45,    45,    45,    46,    46,    47,    47,    48,    48,    48,
      49,    50,    51,    51,    52,    52,    53,    53,    54,    55,
      55,    56,    56,    56,    56,    56,    56,    56,    57,    57,
      57,    57,    57,    57,    57,    57,    57,    57,    57,    57,
      57,    57,    57,    58,    58,    59,    59,    60,    60,    60,
      61,    61,    62,    62,    62,    62,    62,    63,    63,    64,
      64,    65,    65,    65,    65,    65,    65
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     4,     3,     6,     6,     7,     3,     3,
       9,     7,     5,     9,     7,     5,     3,     3,     3,     3,
       3,     2,     3,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     3,     0,     3,     2,     1,
       2,     0,     5,     6,     2,     2,     3,     3,     2,     1,
       1,     1,     4,     3,     3,     3,     3,     3,     4,     8,
       3,     2,     2,     1,     3,     1,     3,     1,     3,     5,
       1,     3,     3,     3,     3,     3,     3,     1,     3,     0,
       3,     0,     6,     5,     5,     4,     5
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]));
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* BLOB: BLOB1 HINTS  */
#line 138 "src/parser/parser.ypp"
                                { generate_all_approx(); }
#line 1756 "src/parser/parser.cpp"
    break;

  case 3: /* BLOB1: PROG '{' PROP '}'  */
#line 139 "src/parser/parser.ypp"
                                { generate_graph((yyvsp[-1].prop)); generate_all_approx(); }
#line 1762 "src/parser/parser.cpp"
    break;

  case 4: /* PROP: REAL LE SNUMBER  */
#line 143 "src/parser/parser.ypp"
  {
    real_op const *p = boost::get< real_op const >((yyvsp[-2].real));
    (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), (!p || p->type != UOP_ABS) ? NULL : token_zero, (yyvsp[0].number)));
  }
#line 1771 "src/parser/parser.cpp"
    break;

  case 5: /* PROP: FIX '(' REAL ',' SINTEGER ')'  */
#line 148 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_fix((yyvsp[-3].real), atoi((yyvsp[-1].number)->mantissa.c_str()))); }
#line 1777 "src/parser/parser.cpp"
    break;

  case 6: /* PROP: FLT '(' REAL ',' INTEGER ')'  */
#line 150 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_flt((yyvsp[-3].real), atoi((yyvsp[-1].number)->mantissa.c_str()))); }
#line 1783 "src/parser/parser.cpp"
    break;

  case 7: /* PROP: REAL IN '[' SNUMBER INTSEP SNUMBER ']'  */
#line 152 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-6].real), (yyvsp[-3].number), (yyvsp[-1].number))); }
#line 1789 "src/parser/parser.cpp"
    break;

  case 8: /* PROP: REAL IN '?'  */
#line 153 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), NULL, NULL)); }
#line 1795 "src/parser/parser.cpp"
    break;

  case 9: /* PROP: REAL GE SNUMBER  */
#line 154 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), (yyvsp[0].number), NULL)); }
#line 1801 "src/parser/parser.cpp"
    break;

  case 10: /* PROP: REAL RDIV REAL IN '[' SNUMBER INTSEP SNUMBER ']'  */
#line 157 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-8].real), (yyvsp[-6].real), (yyvsp[-3].number), (yyvsp[-1].number))); }
#line 1807 "src/parser/parser.cpp"
    break;

  case 11: /* PROP: '|' REAL RDIV REAL '|' LE NUMBER  */
#line 159 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-5].real), (yyvsp[-3].real), negative_number((yyvsp[0].number)), (yyvsp[0].number))); }
#line 1813 "src/parser/parser.cpp"
    break;

  case 12: /* PROP: REAL RDIV REAL IN '?'  */
#line 160 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-4].real), (yyvsp[-2].real), NULL, NULL)); }
#line 1819 "src/parser/parser.cpp"
    break;

  case 13: /* PROP: REAL PAR REAL IN '[' SNUMBER INTSEP SNUMBER ']'  */
#line 163 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_lin((yyvsp[-8].real), (yyvsp[-6].real), (yyvsp[-3].number), (yyvsp[-1].number))); }
#line 1825 "src/parser/parser.cpp"
    break;

  case 14: /* PROP: '|' REAL PAR REAL '|' LE NUMBER  */
#line 165 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_lin((yyvsp[-5].real), (yyvsp[-3].real), negative_number((yyvsp[0].number)), (yyvsp[0].number))); }
#line 1831 "src/parser/parser.cpp"
    break;

  case 15: /* PROP: REAL PAR REAL IN '?'  */
#line 166 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_lin((yyvsp[-4].real), (yyvsp[-2].real), NULL, NULL)); }
#line 1837 "src/parser/parser.cpp"
    break;

  case 16: /* PROP: REAL '=' REAL  */
#line 168 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_eql((yyvsp[-2].real), (yyvsp[0].real))); }
#line 1843 "src/parser/parser.cpp"
    break;

  case 17: /* PROP: REAL NE REAL  */
#line 170 "src/parser/parser.ypp"
  {
    ast_number const *const *r = boost::get<ast_number const *const>((yyvsp[0].real));
    if (r && *r == token_zero) (yyval.prop) = new ast_prop(ast_atom_nzr((yyvsp[-2].real)));
    else (yyval.prop) = new ast_prop(new ast_prop(ast_atom_eql((yyvsp[-2].real), (yyvsp[0].real))));
  }
#line 1853 "src/parser/parser.cpp"
    break;

  case 18: /* PROP: PROP AND PROP  */
#line 175 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_AND,  (yyvsp[0].prop)); }
#line 1859 "src/parser/parser.cpp"
    break;

  case 19: /* PROP: PROP OR PROP  */
#line 176 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_OR,   (yyvsp[0].prop)); }
#line 1865 "src/parser/parser.cpp"
    break;

  case 20: /* PROP: PROP IMPL PROP  */
#line 177 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_IMPL, (yyvsp[0].prop)); }
#line 1871 "src/parser/parser.cpp"
    break;

  case 21: /* PROP: NOT PROP  */
#line 178 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop((yyvsp[0].prop)); }
#line 1877 "src/parser/parser.cpp"
    break;

  case 22: /* PROP: '(' PROP ')'  */
#line 179 "src/parser/parser.ypp"
                        { (yyval.prop) = (yyvsp[-1].prop); }
#line 1883 "src/parser/parser.cpp"
    break;

  case 27: /* SNUMBER: NUMBER  */
#line 186 "src/parser/parser.ypp"
                { (yyval.number) = (yyvsp[0].number); }
#line 1889 "src/parser/parser.cpp"
    break;

  case 28: /* SNUMBER: '+' NUMBER  */
#line 187 "src/parser/parser.ypp"
                { (yyval.number) = (yyvsp[0].number); }
#line 1895 "src/parser/parser.cpp"
    break;

  case 29: /* SNUMBER: MINUS NUMBER  */
#line 188 "src/parser/parser.ypp"
                { (yyval.number) = negative_number((yyvsp[0].number)); }
#line 1901 "src/parser/parser.cpp"
    break;

  case 30: /* INTEGER: NUMBER  */
#line 192 "src/parser/parser.ypp"
  {
    if ((yyvsp[0].number)->exponent != 0 || (yyvsp[0].number)->mantissa.size() >= 7) failure("integer expected");
    (yyval.number) = (yyvsp[0].number);
  }
#line 1910 "src/parser/parser.cpp"
    break;

  case 31: /* SINTEGER: SNUMBER  */
#line 199 "src/parser/parser.ypp"
  {
    if ((yyvsp[0].number)->exponent != 0 || (yyvsp[0].number)->mantissa.size() >= 7) failure("integer expected");
    (yyval.number) = (yyvsp[0].number);
  }
#line 1919 "src/parser/parser.cpp"
    break;

  case 32: /* FUNCTION_PARAM: SINTEGER  */
#line 205 "src/parser/parser.ypp"
                { (yyval.param) = read_integer_param((yyvsp[0].number)); }
#line 1925 "src/parser/parser.cpp"
    break;

  case 33: /* FUNCTION_PARAM: IDENT  */
#line 206 "src/parser/parser.ypp"
                { (yyval.param) = reinterpret_cast<uintptr_t>((yyvsp[0].ident)); }
#line 1931 "src/parser/parser.cpp"
    break;

  case 34: /* FUNCTION_PARAMS_AUX: FUNCTION_PARAM  */
#line 209 "src/parser/parser.ypp"
                        { (yyval.params) = new function_params(1, (yyvsp[0].param)); }
#line 1937 "src/parser/parser.cpp"
    break;

  case 35: /* FUNCTION_PARAMS_AUX: FUNCTION_PARAMS_AUX ',' FUNCTION_PARAM  */
#line 211 "src/parser/parser.ypp"
  {
    function_params *p = (yyvsp[-2].params);
    p->push_back((yyvsp[0].param));
    (yyval.params) = p;
  }
#line 1947 "src/parser/parser.cpp"
    break;

  case 36: /* FUNCTION_PARAMS: %empty  */
#line 218 "src/parser/parser.ypp"
                                { (yyval.params) = NULL; }
#line 1953 "src/parser/parser.cpp"
    break;

  case 37: /* FUNCTION_PARAMS: '<' FUNCTION_PARAMS_AUX '>'  */
#line 219 "src/parser/parser.ypp"
                                { (yyval.params) = (yyvsp[-1].params); }
#line 1959 "src/parser/parser.cpp"
    break;

  case 38: /* FUNCTION: FUNID FUNCTION_PARAMS  */
#line 223 "src/parser/parser.ypp"
  {
    ast_ident *r = (yyvsp[-1].ident);
    function_class const *f;
    if (function_params *p = (yyvsp[0].params)) {
      f = (*r->fun)(*p);
      delete p;
    } else f = (*r->fun)(function_params());
    if (!f) failure("invalid parameters for '" << r->name << "'");
    (yyval.function) = f;
  }
#line 1974 "src/parser/parser.cpp"
    break;

  case 40: /* EQUAL: FUNCTION '='  */
#line 236 "src/parser/parser.ypp"
               { rounding_mode = (yyvsp[-1].function); }
#line 1980 "src/parser/parser.cpp"
    break;

  case 42: /* PROG: PROG IDENT EQUAL REAL ';'  */
#line 240 "src/parser/parser.ypp"
  {
    ast_ident *v = (yyvsp[-3].ident);
    ast_real const *r = (yyvsp[-1].real);
    if (v->type != ID_NONE) failure("redefinition of identifier '" << (yyvsp[-3].ident)->name << "'");
    v->type = ID_VAR;
    v->var = r;
    if (r->name) warning("renaming identifier '" << r->name->name << "' as '" << v->name << "'");
    r->name = v;
    rounding_mode = NULL;
  }
#line 1995 "src/parser/parser.cpp"
    break;

  case 43: /* PROG: PROG '@' IDENT '=' FUNCTION ';'  */
#line 251 "src/parser/parser.ypp"
  {
    ast_ident *v = (yyvsp[-3].ident);
    v->type = ID_FUN;
    function_generator *g = new default_function_generator((yyvsp[-1].function));
    v->fun = g;
    user_functions.push_back(g);
  }
#line 2007 "src/parser/parser.cpp"
    break;

  case 44: /* PROG: PROG VARID  */
#line 258 "src/parser/parser.ypp"
                        { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 2013 "src/parser/parser.cpp"
    break;

  case 45: /* PROG: PROG FUNID  */
#line 259 "src/parser/parser.ypp"
                        { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 2019 "src/parser/parser.cpp"
    break;

  case 46: /* PROG: PROG '@' VARID  */
#line 260 "src/parser/parser.ypp"
                        { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 2025 "src/parser/parser.cpp"
    break;

  case 47: /* PROG: PROG '@' FUNID  */
#line 261 "src/parser/parser.ypp"
                        { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 2031 "src/parser/parser.cpp"
    break;

  case 48: /* REAL: NEG NUMBER  */
#line 264 "src/parser/parser.ypp"
                { (yyval.real) = normalize(negative_number((yyvsp[0].number)), true); }
#line 2037 "src/parser/parser.cpp"
    break;

  case 49: /* REAL: NUMBER  */
#line 265 "src/parser/parser.ypp"
                { (yyval.real) = normalize(ast_real((yyvsp[0].number)), true); }
#line 2043 "src/parser/parser.cpp"
    break;

  case 50: /* REAL: VARID  */
#line 266 "src/parser/parser.ypp"
                { (yyval.real) = (yyvsp[0].ident)->var; }
#line 2049 "src/parser/parser.cpp"
    break;

  case 51: /* REAL: IDENT  */
#line 268 "src/parser/parser.ypp"
  {
    ast_ident *v = (yyvsp[0].ident);
    v->type = ID_VAR;
    ast_real *r = normalize(ast_real(v), true);
    free_variables.insert(r);
    v->var = r;
    (yyval.real) = r;
  }
#line 2062 "src/parser/parser.cpp"
    break;

  case 52: /* REAL: FUNCTION '(' REALS ')'  */
#line 277 "src/parser/parser.ypp"
  {
    function_class const *f = (yyvsp[-3].function);
    ast_real_vect *ops = (yyvsp[-1].reals);
    if (ops->size() != 1)
      failure("incorrect number of arguments for '" << f->pretty_name() << "'");
    (yyval.real) = normalize(ast_real(real_op(f, (*ops)[0])), true);
    delete ops;
  }
#line 2075 "src/parser/parser.cpp"
    break;

  case 53: /* REAL: REAL '+' REAL  */
#line 285 "src/parser/parser.ypp"
                        { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_ADD, (yyvsp[0].real)))); }
#line 2081 "src/parser/parser.cpp"
    break;

  case 54: /* REAL: REAL MINUS REAL  */
#line 286 "src/parser/parser.ypp"
                                { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_SUB, (yyvsp[0].real)))); }
#line 2087 "src/parser/parser.cpp"
    break;

  case 55: /* REAL: REAL '*' REAL  */
#line 287 "src/parser/parser.ypp"
                        { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_MUL, (yyvsp[0].real)))); }
#line 2093 "src/parser/parser.cpp"
    break;

  case 56: /* REAL: REAL '/' REAL  */
#line 288 "src/parser/parser.ypp"
                        { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_DIV, (yyvsp[0].real)))); }
#line 2099 "src/parser/parser.cpp"
    break;

  case 57: /* REAL: '|' REAL '|'  */
#line 289 "src/parser/parser.ypp"
                        { (yyval.real) = normalize(ast_real(real_op(UOP_ABS, (yyvsp[-1].real))), true); }
#line 2105 "src/parser/parser.cpp"
    break;

  case 58: /* REAL: SQRT '(' REAL ')'  */
#line 290 "src/parser/parser.ypp"
                        { (yyval.real) = rnd_normalize(ast_real(real_op(UOP_SQRT, (yyvsp[-1].real)))); }
#line 2111 "src/parser/parser.cpp"
    break;

  case 59: /* REAL: FMA '(' REAL ',' REAL ',' REAL ')'  */
#line 292 "src/parser/parser.ypp"
  {
    if (!parameter_rfma)
      (yyval.real) = rnd_normalize(ast_real(real_op(normalize(ast_real(real_op((yyvsp[-5].real), BOP_MUL, (yyvsp[-3].real))), true), BOP_ADD, (yyvsp[-1].real))));
    else
      (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-1].real), BOP_ADD, normalize(ast_real(real_op((yyvsp[-5].real), BOP_MUL, (yyvsp[-3].real))), true))));
  }
#line 2122 "src/parser/parser.cpp"
    break;

  case 60: /* REAL: '(' REAL ')'  */
#line 298 "src/parser/parser.ypp"
                        { (yyval.real) = (yyvsp[-1].real); }
#line 2128 "src/parser/parser.cpp"
    break;

  case 61: /* REAL: '+' REAL  */
#line 299 "src/parser/parser.ypp"
                        { (yyval.real) = (yyvsp[0].real); }
#line 2134 "src/parser/parser.cpp"
    break;

  case 62: /* REAL: '-' REAL  */
#line 300 "src/parser/parser.ypp"
                        { (yyval.real) = normalize(ast_real(real_op(UOP_NEG, (yyvsp[0].real))), true); }
#line 2140 "src/parser/parser.cpp"
    break;

  case 63: /* REALS: REAL  */
#line 303 "src/parser/parser.ypp"
                { (yyval.reals) = new ast_real_vect(1, (yyvsp[0].real)); }
#line 2146 "src/parser/parser.cpp"
    break;

  case 64: /* REALS: REALS ',' REAL  */
#line 305 "src/parser/parser.ypp"
  {
    (yyvsp[-2].reals)->push_back((yyvsp[0].real));
    (yyval.reals) = (yyvsp[-2].reals);
  }
#line 2155 "src/parser/parser.cpp"
    break;

  case 65: /* DPOINTS: SNUMBER  */
#line 311 "src/parser/parser.ypp"
                        { (yyval.param) = fill_splitter(0, (yyvsp[0].number)); }
#line 2161 "src/parser/parser.cpp"
    break;

  case 66: /* DPOINTS: DPOINTS ',' SNUMBER  */
#line 312 "src/parser/parser.ypp"
                        { (yyval.param) = fill_splitter((yyvsp[-2].param), (yyvsp[0].number)); }
#line 2167 "src/parser/parser.cpp"
    break;

  case 67: /* DVAR: REAL  */
#line 315 "src/parser/parser.ypp"
                                { dichotomy_var v = { (yyvsp[0].real), 0 }; (yyval.dvar) = v; }
#line 2173 "src/parser/parser.cpp"
    break;

  case 68: /* DVAR: REAL IN INTEGER  */
#line 316 "src/parser/parser.ypp"
                                { dichotomy_var v = { (yyvsp[-2].real), read_integer_param((yyvsp[0].number)) }; (yyval.dvar) = v; }
#line 2179 "src/parser/parser.cpp"
    break;

  case 69: /* DVAR: REAL IN '(' DPOINTS ')'  */
#line 317 "src/parser/parser.ypp"
                                { dichotomy_var v = { (yyvsp[-4].real), (yyvsp[-1].param) }; (yyval.dvar) = v; }
#line 2185 "src/parser/parser.cpp"
    break;

  case 70: /* DVARS: DVAR  */
#line 320 "src/parser/parser.ypp"
                { (yyval.dvars) = new dvar_vect(1, (yyvsp[0].dvar)); }
#line 2191 "src/parser/parser.cpp"
    break;

  case 71: /* DVARS: DVARS ',' DVAR  */
#line 322 "src/parser/parser.ypp"
  {
    (yyvsp[-2].dvars)->push_back((yyvsp[0].dvar));
    (yyval.dvars) = (yyvsp[-2].dvars);
  }
#line 2200 "src/parser/parser.cpp"
    break;

  case 72: /* PRECOND: REAL NE SINTEGER  */
#line 328 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_NE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2206 "src/parser/parser.cpp"
    break;

  case 73: /* PRECOND: REAL LE SINTEGER  */
#line 329 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_LE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2212 "src/parser/parser.cpp"
    break;

  case 74: /* PRECOND: REAL GE SINTEGER  */
#line 330 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_GE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2218 "src/parser/parser.cpp"
    break;

  case 75: /* PRECOND: REAL '<' SINTEGER  */
#line 331 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_LT, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2224 "src/parser/parser.cpp"
    break;

  case 76: /* PRECOND: REAL '>' SINTEGER  */
#line 332 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_GT, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2230 "src/parser/parser.cpp"
    break;

  case 77: /* PRECONDS_AUX: PRECOND  */
#line 335 "src/parser/parser.ypp"
          { (yyval.preconds) = new hint_cond_vect(1, (yyvsp[0].precond)); }
#line 2236 "src/parser/parser.cpp"
    break;

  case 78: /* PRECONDS_AUX: PRECONDS_AUX ',' PRECOND  */
#line 337 "src/parser/parser.ypp"
  {
    (yyvsp[-2].preconds)->push_back((yyvsp[0].precond));
    (yyval.preconds) = (yyvsp[-2].preconds);
  }
#line 2245 "src/parser/parser.cpp"
    break;

  case 79: /* PRECONDS: %empty  */
#line 343 "src/parser/parser.ypp"
                        { (yyval.preconds) = NULL; }
#line 2251 "src/parser/parser.cpp"
    break;

  case 80: /* PRECONDS: '{' PRECONDS_AUX '}'  */
#line 344 "src/parser/parser.ypp"
                        { (yyval.preconds) = (yyvsp[-1].preconds); }
#line 2257 "src/parser/parser.cpp"
    break;

  case 82: /* HINTS: HINTS REAL IMPL REAL PRECONDS ';'  */
#line 348 "src/parser/parser.ypp"
  {
    ast_real const *r1 = (yyvsp[-4].real), *r2 = (yyvsp[-2].real);
    hint_cond_vect *hc = (yyvsp[-1].preconds);
    test_ringularity(r1, r2, !hc);
    std::string info;
    int t = test_rewriting(r1, r2, info);
    if (t == 1) {
      warning("no need for the rewriting");
      std::cerr << "  if one of the following relations is present\n" << info;
    } else if (t == 2) {
      warning("no need for the rewriting");
      if (!info.empty())
        std::cerr << "  if all the following properties can be proved\n" << info;
    }
    check_approx(r1);
    register_user_rewrite(r1, r2, hc);
    register_approx(r1, r2);
    delete hc;
  }
#line 2281 "src/parser/parser.cpp"
    break;

  case 83: /* HINTS: HINTS REALS '$' DVARS ';'  */
#line 368 "src/parser/parser.ypp"
  {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    ast_prop *p = NULL;
    for (ast_real_vect::const_iterator i = (yyvsp[-3].reals)->begin(), i_end = (yyvsp[-3].reals)->end();
         i != i_end; ++i)
    {
      ast_prop *q = new ast_prop(ast_atom_bnd(*i, NULL, NULL));
      if (!p) p = q;
      else p = new ast_prop(p, PROP_AND, q);
    }
    delete (yyvsp[-3].reals);
    parse_property_tree(h.dst, p);
    dichotomies.push_back(h);
  }
#line 2301 "src/parser/parser.cpp"
    break;

  case 84: /* HINTS: HINTS PROP '$' DVARS ';'  */
#line 384 "src/parser/parser.ypp"
  {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    parse_property_tree(h.dst, (yyvsp[-3].prop));
    dichotomies.push_back(h);
  }
#line 2312 "src/parser/parser.cpp"
    break;

  case 85: /* HINTS: HINTS '$' DVARS ';'  */
#line 391 "src/parser/parser.ypp"
  {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    for (dvar_vect::iterator i = h.src.begin(),
         i_end = h.src.end(); i != i_end; ++i)
    {
      // no target property and no splitter, make it four-part by default
      if (!i->splitter) i->splitter = 9;
    }
    dichotomies.push_back(h);
  }
#line 2328 "src/parser/parser.cpp"
    break;

  case 86: /* HINTS: HINTS REAL '~' REAL ';'  */
#line 403 "src/parser/parser.ypp"
  {
    if (!register_approx((yyvsp[-3].real), (yyvsp[-1].real)))
      warning("relation already known");
  }
#line 2337 "src/parser/parser.cpp"
    break;


#line 2341 "src/parser/parser.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

