static CYTHON_INLINE int __Pyx_CheckUnicodeValue(int value) {
    return value <= 1114111;
}
static PyObject* __Pyx_PyUnicode_FromOrdinal_Padded(int value, Py_ssize_t ulength, char padding_char) {
    if (likely(ulength <= 250)) {
        char chars[256];
        if (value <= 255) {
            memset(chars, padding_char, (size_t) (ulength - 1));
            chars[ulength-1] = (char) value;
            return PyUnicode_DecodeLatin1(chars, ulength, NULL);
        }
        char *cpos = chars + sizeof(chars);
        if (value < 0x800) {
            *--cpos = (char) (0b10000000 | (value & 0x3f));
            value >>= 6;
            *--cpos = (char) (0b11000000 | (value & 0x1f));
        } else if (value < 0x10000) {
            *--cpos = (char) (0b10000000 | (char) (value & 0x3f));
            value >>= 6;
            *--cpos = (char) (0b10000000 | (char) (value & 0x3f));
            value >>= 6;
            *--cpos = (char) (0b11100000 | (char) (value & 0xf));
        } else {
            *--cpos = (char) (0b10000000 | (char) (value & 0x3f));
            value >>= 6;
            *--cpos = (char) (0b10000000 | (char) (value & 0x3f));
            value >>= 6;
            *--cpos = (char) (0b10000000 | (char) (value & 0x3f));
            value >>= 6;
            *--cpos = (char) (0b11110000 | (char) (value & 0x7));
        }
        cpos -= ulength;
        memset(cpos, padding_char, (size_t) (ulength - 1));
        return PyUnicode_DecodeUTF8(cpos, chars + sizeof(chars) - cpos, NULL);
    }
    if (value <= 127 && CYTHON_USE_UNICODE_INTERNALS) {
        const char chars[1] = {(char) value};
        return __Pyx_PyUnicode_BuildFromAscii(ulength, chars, 1, 0, padding_char);
    }
    {
        PyObject *uchar, *padding_uchar, *padding, *result;
        padding_uchar = PyUnicode_FromOrdinal(padding_char);
        if (unlikely(!padding_uchar)) return NULL;
        padding = PySequence_Repeat(padding_uchar, ulength - 1);
        Py_DECREF(padding_uchar);
        if (unlikely(!padding)) return NULL;
        uchar = PyUnicode_FromOrdinal(value);
        if (unlikely(!uchar)) {
            Py_DECREF(padding);
            return NULL;
        }
        result = PyUnicode_Concat(padding, uchar);
        Py_DECREF(padding);
        Py_DECREF(uchar);
        return result;
    }
}

