#!/bin/sh

# This test ensures that the --in-place option is working correctly.

set -e
set -u
set -x

cleanup() {
	rm -f ./inplace-cli-input.json inplace-cli-reference.json
}
cleanup
trap cleanup EXIT

cp ../../doc/data/iata.json ./inplace-cli-input.json

# convert to just a list of airport codes, and lowercase them
"$RQ" -I inplace-cli-input.json -O inplace-cli-reference.json '{lower(k) | input[k]}'

# do the same thing with --in-place
"$RQ" --in-place inplace-cli-input.json '{lower(k) | input[k]}'

diff inplace-cli-input.json inplace-cli-reference.json
