// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Oracle API Access Control
//
// This service is used to restrict the control plane service apis; so that everybody won't be
// able to access those apis.
// There are two main resouces defined as a part of this service
// 1. PrivilegedApiControl: This is created by the customer which defines which service apis are
//    controlled and who can access it.
// 2. PrivilegedApiRequest: This is a request object again created by the customer operators who           seek access to those privileged apis. After a request is obtained based on the                       PrivilegedAccessControl for which the api belongs to, either it can be approved so that the          requested person can execute the service apis or it will wait for the customer to approve it.
//

package apiaccesscontrol

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// PrivilegedApiRequest An Oracle operator raises privilegedApi request when they need access to any infrastructure resource governed by PrivilegedApi Access Control.
//
//	The privilegedApi request identifies the target resource and the set of operator actions. Access request handling depends upon the Operator Control
//	that governs the target resource, and the set of operator actions listed for approval in the access request. If all of the operator actions
//	listed in the privilegedApi request are in the pre-approved list in the PrivilegedApi Control that governs the target resource, then the privilegedApi request is
//	automatically approved. If not, then the privilegedApi request requires explicit approval from the approver group specified by the PrivilegedApi Control governing the target resource.
//
// You can approve or reject an privilegedApi request. You can also revoke the approval of an already approved privilegedApi request. While creating an access request,
//
//	the operator specifies the duration of access. You have the option to approve the entire duration or reduce or even increase the time duration.
//	An operator can also request for an extension. The approval for such an extension is processed the same way the original privilegedApi request was processed.
type PrivilegedApiRequest struct {

	// The OCID of the privilegedApi request.
	Id *string `mandatory:"true" json:"id"`

	// Summary comment by the operator creating the access request.
	ReasonSummary *string `mandatory:"true" json:"reasonSummary"`

	// The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
	ResourceId *string `mandatory:"true" json:"resourceId"`

	// The current state of the Access Request.
	State PrivilegedApiRequestStateEnum `mandatory:"true" json:"state"`

	// Name of the privilegedApi control. The name must be unique.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// This is an automatic identifier generated by the system which is easier for human comprehension.
	RequestId *string `mandatory:"false" json:"requestId"`

	// The OCID of the OCI Notification topic to publish messages related to this privileged api request.
	NotificationTopicId *string `mandatory:"false" json:"notificationTopicId"`

	// List of Users who has created this privilegedApiRequest.
	RequestedBy []string `mandatory:"false" json:"requestedBy"`

	// resourceName for which the PrivilegedApiRequest is applicable
	ResourceName *string `mandatory:"false" json:"resourceName"`

	// The subresource names requested for approval.
	SubResourceNameList []string `mandatory:"false" json:"subResourceNameList"`

	// The OCID of the compartment that contains the access request.
	CompartmentId *string `mandatory:"false" json:"compartmentId"`

	// resourceType for which the AccessRequest is applicable
	ResourceType *string `mandatory:"false" json:"resourceType"`

	// entityType of resource for which the AccessRequest is applicable
	EntityType *string `mandatory:"false" json:"entityType"`

	// List of api names, attributes for which approval is sought by the user.
	PrivilegedOperationList []PrivilegedApiRequestOperationDetails `mandatory:"false" json:"privilegedOperationList"`

	// Reason in Detail for which the operator is requesting access on the target resource.
	ReasonDetail *string `mandatory:"false" json:"reasonDetail"`

	// Priority assigned to the access request by the operator
	Severity PrivilegedApiRequestSeverityEnum `mandatory:"false" json:"severity,omitempty"`

	// Duration in hours for which access is sought on the target resource.
	DurationInHrs *int `mandatory:"false" json:"durationInHrs"`

	// A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.
	TicketNumbers []string `mandatory:"false" json:"ticketNumbers"`

	// A message that describes the current state of the PrivilegedApiControl in more detail. For example,
	// can be used to provide actionable information for a resource in the Failed state.
	StateDetails *string `mandatory:"false" json:"stateDetails"`

	// The current state of the PrivilegedApiRequest.
	LifecycleState PrivilegedApiRequestLifecycleStateEnum `mandatory:"false" json:"lifecycleState,omitempty"`

	// more in detail about the lifeCycleState.
	LifecycleDetails *string `mandatory:"false" json:"lifecycleDetails"`

	// Time when the privilegedApi request was created in RFC 3339 (https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
	TimeCreated *common.SDKTime `mandatory:"false" json:"timeCreated"`

	// Time when the privilegedApi request was last modified in RFC 3339 (https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
	TimeUpdated *common.SDKTime `mandatory:"false" json:"timeUpdated"`

	// The comment entered by the operator while closing the request.
	ClosureComment *string `mandatory:"false" json:"closureComment"`

	// The OCID of the privilegedApi control governing the target resource.
	PrivilegedApiControlId *string `mandatory:"false" json:"privilegedApiControlId"`

	// Name of the privilegedApi control governing the target resource.
	PrivilegedApiControlName *string `mandatory:"false" json:"privilegedApiControlName"`

	// Number of approvers required to approve an privilegedApi request.
	NumberOfApproversRequired *int `mandatory:"false" json:"numberOfApproversRequired"`

	// Contains the approver details who have approved the privilegedApi Request during the initial request.
	ApproverDetails []ApproverDetail `mandatory:"false" json:"approverDetails"`

	// Time in future when the user for the privilegedApi request needs to be created in RFC 3339 (https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
	TimeRequestedForFutureAccess *common.SDKTime `mandatory:"false" json:"timeRequestedForFutureAccess"`

	// Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
	// For more information, see Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Department": "Finance"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// For more information, see Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Operations": {"CostCenter": "42"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// System tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m PrivilegedApiRequest) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m PrivilegedApiRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingPrivilegedApiRequestStateEnum(string(m.State)); !ok && m.State != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for State: %s. Supported values are: %s.", m.State, strings.Join(GetPrivilegedApiRequestStateEnumStringValues(), ",")))
	}

	if _, ok := GetMappingPrivilegedApiRequestSeverityEnum(string(m.Severity)); !ok && m.Severity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Severity: %s. Supported values are: %s.", m.Severity, strings.Join(GetPrivilegedApiRequestSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingPrivilegedApiRequestLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetPrivilegedApiRequestLifecycleStateEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// PrivilegedApiRequestStateEnum Enum with underlying type: string
type PrivilegedApiRequestStateEnum string

// Set of constants representing the allowable values for PrivilegedApiRequestStateEnum
const (
	PrivilegedApiRequestStateCreated           PrivilegedApiRequestStateEnum = "CREATED"
	PrivilegedApiRequestStateApprovalWaiting   PrivilegedApiRequestStateEnum = "APPROVAL_WAITING"
	PrivilegedApiRequestStateApproved          PrivilegedApiRequestStateEnum = "APPROVED"
	PrivilegedApiRequestStateApprovedForFuture PrivilegedApiRequestStateEnum = "APPROVED_FOR_FUTURE"
	PrivilegedApiRequestStateRejected          PrivilegedApiRequestStateEnum = "REJECTED"
	PrivilegedApiRequestStateDeployed          PrivilegedApiRequestStateEnum = "DEPLOYED"
	PrivilegedApiRequestStateDeployFailed      PrivilegedApiRequestStateEnum = "DEPLOY_FAILED"
	PrivilegedApiRequestStateCloseFailed       PrivilegedApiRequestStateEnum = "CLOSE_FAILED"
	PrivilegedApiRequestStateRevokeFailed      PrivilegedApiRequestStateEnum = "REVOKE_FAILED"
	PrivilegedApiRequestStateExpiryFailed      PrivilegedApiRequestStateEnum = "EXPIRY_FAILED"
	PrivilegedApiRequestStateRevoking          PrivilegedApiRequestStateEnum = "REVOKING"
	PrivilegedApiRequestStateRevoked           PrivilegedApiRequestStateEnum = "REVOKED"
	PrivilegedApiRequestStateClosing           PrivilegedApiRequestStateEnum = "CLOSING"
	PrivilegedApiRequestStateClosed            PrivilegedApiRequestStateEnum = "CLOSED"
	PrivilegedApiRequestStateExpired           PrivilegedApiRequestStateEnum = "EXPIRED"
)

var mappingPrivilegedApiRequestStateEnum = map[string]PrivilegedApiRequestStateEnum{
	"CREATED":             PrivilegedApiRequestStateCreated,
	"APPROVAL_WAITING":    PrivilegedApiRequestStateApprovalWaiting,
	"APPROVED":            PrivilegedApiRequestStateApproved,
	"APPROVED_FOR_FUTURE": PrivilegedApiRequestStateApprovedForFuture,
	"REJECTED":            PrivilegedApiRequestStateRejected,
	"DEPLOYED":            PrivilegedApiRequestStateDeployed,
	"DEPLOY_FAILED":       PrivilegedApiRequestStateDeployFailed,
	"CLOSE_FAILED":        PrivilegedApiRequestStateCloseFailed,
	"REVOKE_FAILED":       PrivilegedApiRequestStateRevokeFailed,
	"EXPIRY_FAILED":       PrivilegedApiRequestStateExpiryFailed,
	"REVOKING":            PrivilegedApiRequestStateRevoking,
	"REVOKED":             PrivilegedApiRequestStateRevoked,
	"CLOSING":             PrivilegedApiRequestStateClosing,
	"CLOSED":              PrivilegedApiRequestStateClosed,
	"EXPIRED":             PrivilegedApiRequestStateExpired,
}

var mappingPrivilegedApiRequestStateEnumLowerCase = map[string]PrivilegedApiRequestStateEnum{
	"created":             PrivilegedApiRequestStateCreated,
	"approval_waiting":    PrivilegedApiRequestStateApprovalWaiting,
	"approved":            PrivilegedApiRequestStateApproved,
	"approved_for_future": PrivilegedApiRequestStateApprovedForFuture,
	"rejected":            PrivilegedApiRequestStateRejected,
	"deployed":            PrivilegedApiRequestStateDeployed,
	"deploy_failed":       PrivilegedApiRequestStateDeployFailed,
	"close_failed":        PrivilegedApiRequestStateCloseFailed,
	"revoke_failed":       PrivilegedApiRequestStateRevokeFailed,
	"expiry_failed":       PrivilegedApiRequestStateExpiryFailed,
	"revoking":            PrivilegedApiRequestStateRevoking,
	"revoked":             PrivilegedApiRequestStateRevoked,
	"closing":             PrivilegedApiRequestStateClosing,
	"closed":              PrivilegedApiRequestStateClosed,
	"expired":             PrivilegedApiRequestStateExpired,
}

// GetPrivilegedApiRequestStateEnumValues Enumerates the set of values for PrivilegedApiRequestStateEnum
func GetPrivilegedApiRequestStateEnumValues() []PrivilegedApiRequestStateEnum {
	values := make([]PrivilegedApiRequestStateEnum, 0)
	for _, v := range mappingPrivilegedApiRequestStateEnum {
		values = append(values, v)
	}
	return values
}

// GetPrivilegedApiRequestStateEnumStringValues Enumerates the set of values in String for PrivilegedApiRequestStateEnum
func GetPrivilegedApiRequestStateEnumStringValues() []string {
	return []string{
		"CREATED",
		"APPROVAL_WAITING",
		"APPROVED",
		"APPROVED_FOR_FUTURE",
		"REJECTED",
		"DEPLOYED",
		"DEPLOY_FAILED",
		"CLOSE_FAILED",
		"REVOKE_FAILED",
		"EXPIRY_FAILED",
		"REVOKING",
		"REVOKED",
		"CLOSING",
		"CLOSED",
		"EXPIRED",
	}
}

// GetMappingPrivilegedApiRequestStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingPrivilegedApiRequestStateEnum(val string) (PrivilegedApiRequestStateEnum, bool) {
	enum, ok := mappingPrivilegedApiRequestStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// PrivilegedApiRequestLifecycleStateEnum Enum with underlying type: string
type PrivilegedApiRequestLifecycleStateEnum string

// Set of constants representing the allowable values for PrivilegedApiRequestLifecycleStateEnum
const (
	PrivilegedApiRequestLifecycleStateAccepted       PrivilegedApiRequestLifecycleStateEnum = "ACCEPTED"
	PrivilegedApiRequestLifecycleStateInProgress     PrivilegedApiRequestLifecycleStateEnum = "IN_PROGRESS"
	PrivilegedApiRequestLifecycleStateWaiting        PrivilegedApiRequestLifecycleStateEnum = "WAITING"
	PrivilegedApiRequestLifecycleStateFailed         PrivilegedApiRequestLifecycleStateEnum = "FAILED"
	PrivilegedApiRequestLifecycleStateSucceeded      PrivilegedApiRequestLifecycleStateEnum = "SUCCEEDED"
	PrivilegedApiRequestLifecycleStateCanceling      PrivilegedApiRequestLifecycleStateEnum = "CANCELING"
	PrivilegedApiRequestLifecycleStateCanceled       PrivilegedApiRequestLifecycleStateEnum = "CANCELED"
	PrivilegedApiRequestLifecycleStateNeedsAttention PrivilegedApiRequestLifecycleStateEnum = "NEEDS_ATTENTION"
)

var mappingPrivilegedApiRequestLifecycleStateEnum = map[string]PrivilegedApiRequestLifecycleStateEnum{
	"ACCEPTED":        PrivilegedApiRequestLifecycleStateAccepted,
	"IN_PROGRESS":     PrivilegedApiRequestLifecycleStateInProgress,
	"WAITING":         PrivilegedApiRequestLifecycleStateWaiting,
	"FAILED":          PrivilegedApiRequestLifecycleStateFailed,
	"SUCCEEDED":       PrivilegedApiRequestLifecycleStateSucceeded,
	"CANCELING":       PrivilegedApiRequestLifecycleStateCanceling,
	"CANCELED":        PrivilegedApiRequestLifecycleStateCanceled,
	"NEEDS_ATTENTION": PrivilegedApiRequestLifecycleStateNeedsAttention,
}

var mappingPrivilegedApiRequestLifecycleStateEnumLowerCase = map[string]PrivilegedApiRequestLifecycleStateEnum{
	"accepted":        PrivilegedApiRequestLifecycleStateAccepted,
	"in_progress":     PrivilegedApiRequestLifecycleStateInProgress,
	"waiting":         PrivilegedApiRequestLifecycleStateWaiting,
	"failed":          PrivilegedApiRequestLifecycleStateFailed,
	"succeeded":       PrivilegedApiRequestLifecycleStateSucceeded,
	"canceling":       PrivilegedApiRequestLifecycleStateCanceling,
	"canceled":        PrivilegedApiRequestLifecycleStateCanceled,
	"needs_attention": PrivilegedApiRequestLifecycleStateNeedsAttention,
}

// GetPrivilegedApiRequestLifecycleStateEnumValues Enumerates the set of values for PrivilegedApiRequestLifecycleStateEnum
func GetPrivilegedApiRequestLifecycleStateEnumValues() []PrivilegedApiRequestLifecycleStateEnum {
	values := make([]PrivilegedApiRequestLifecycleStateEnum, 0)
	for _, v := range mappingPrivilegedApiRequestLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetPrivilegedApiRequestLifecycleStateEnumStringValues Enumerates the set of values in String for PrivilegedApiRequestLifecycleStateEnum
func GetPrivilegedApiRequestLifecycleStateEnumStringValues() []string {
	return []string{
		"ACCEPTED",
		"IN_PROGRESS",
		"WAITING",
		"FAILED",
		"SUCCEEDED",
		"CANCELING",
		"CANCELED",
		"NEEDS_ATTENTION",
	}
}

// GetMappingPrivilegedApiRequestLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingPrivilegedApiRequestLifecycleStateEnum(val string) (PrivilegedApiRequestLifecycleStateEnum, bool) {
	enum, ok := mappingPrivilegedApiRequestLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
