// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Dblm API
//
// A description of the Dblm API
//

package dblm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// VulnerabilityScan A VulnerabilityScan is a description of a VulnerabilityScan.
// To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
// an administrator. If you're an administrator who needs to write policies to give users access, see
// Getting Started with Policies (https://docs.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm).
type VulnerabilityScan struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VulnerabilityScan.
	Id *string `mandatory:"true" json:"id"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// Scan type is CVE, PATCH or IMAGE_PATCH
	VulnerabilityScanType VulnerabilityScanVulnerabilityScanTypeEnum `mandatory:"true" json:"vulnerabilityScanType"`

	// The status of the vulnerability scan.
	VulnerabilityScanStatus VulnerabilityScanVulnerabilityScanStatusEnum `mandatory:"true" json:"vulnerabilityScanStatus"`

	// The message of the vulnerability scan status.
	VulnerabilityScanMessage *string `mandatory:"true" json:"vulnerabilityScanMessage"`

	// The date and time the VulnerabilityScan was created, in the format defined by RFC 3339 (https://tools.ietf.org/html/rfc3339).
	// Example: `2016-08-25T21:10:29.600Z`
	TimeCreated *common.SDKTime `mandatory:"true" json:"timeCreated"`

	// The date and time the VulnerabilityScan was updated, in the format defined by RFC 3339 (https://tools.ietf.org/html/rfc3339).
	// Example: `2016-08-25T21:10:29.600Z`
	TimeEnded *common.SDKTime `mandatory:"true" json:"timeEnded"`

	// The current state of the VulnerabilityScan.
	LifecycleState VulnerabilityScanLifecycleStateEnum `mandatory:"true" json:"lifecycleState"`

	// A user-friendly name. It does not have to be unique, and it is changeable.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// System tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m VulnerabilityScan) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m VulnerabilityScan) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingVulnerabilityScanVulnerabilityScanTypeEnum(string(m.VulnerabilityScanType)); !ok && m.VulnerabilityScanType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VulnerabilityScanType: %s. Supported values are: %s.", m.VulnerabilityScanType, strings.Join(GetVulnerabilityScanVulnerabilityScanTypeEnumStringValues(), ",")))
	}
	if _, ok := GetMappingVulnerabilityScanVulnerabilityScanStatusEnum(string(m.VulnerabilityScanStatus)); !ok && m.VulnerabilityScanStatus != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VulnerabilityScanStatus: %s. Supported values are: %s.", m.VulnerabilityScanStatus, strings.Join(GetVulnerabilityScanVulnerabilityScanStatusEnumStringValues(), ",")))
	}
	if _, ok := GetMappingVulnerabilityScanLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetVulnerabilityScanLifecycleStateEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// VulnerabilityScanVulnerabilityScanTypeEnum Enum with underlying type: string
type VulnerabilityScanVulnerabilityScanTypeEnum string

// Set of constants representing the allowable values for VulnerabilityScanVulnerabilityScanTypeEnum
const (
	VulnerabilityScanVulnerabilityScanTypeCve        VulnerabilityScanVulnerabilityScanTypeEnum = "CVE"
	VulnerabilityScanVulnerabilityScanTypePatch      VulnerabilityScanVulnerabilityScanTypeEnum = "PATCH"
	VulnerabilityScanVulnerabilityScanTypeImagePatch VulnerabilityScanVulnerabilityScanTypeEnum = "IMAGE_PATCH"
)

var mappingVulnerabilityScanVulnerabilityScanTypeEnum = map[string]VulnerabilityScanVulnerabilityScanTypeEnum{
	"CVE":         VulnerabilityScanVulnerabilityScanTypeCve,
	"PATCH":       VulnerabilityScanVulnerabilityScanTypePatch,
	"IMAGE_PATCH": VulnerabilityScanVulnerabilityScanTypeImagePatch,
}

var mappingVulnerabilityScanVulnerabilityScanTypeEnumLowerCase = map[string]VulnerabilityScanVulnerabilityScanTypeEnum{
	"cve":         VulnerabilityScanVulnerabilityScanTypeCve,
	"patch":       VulnerabilityScanVulnerabilityScanTypePatch,
	"image_patch": VulnerabilityScanVulnerabilityScanTypeImagePatch,
}

// GetVulnerabilityScanVulnerabilityScanTypeEnumValues Enumerates the set of values for VulnerabilityScanVulnerabilityScanTypeEnum
func GetVulnerabilityScanVulnerabilityScanTypeEnumValues() []VulnerabilityScanVulnerabilityScanTypeEnum {
	values := make([]VulnerabilityScanVulnerabilityScanTypeEnum, 0)
	for _, v := range mappingVulnerabilityScanVulnerabilityScanTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityScanVulnerabilityScanTypeEnumStringValues Enumerates the set of values in String for VulnerabilityScanVulnerabilityScanTypeEnum
func GetVulnerabilityScanVulnerabilityScanTypeEnumStringValues() []string {
	return []string{
		"CVE",
		"PATCH",
		"IMAGE_PATCH",
	}
}

// GetMappingVulnerabilityScanVulnerabilityScanTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityScanVulnerabilityScanTypeEnum(val string) (VulnerabilityScanVulnerabilityScanTypeEnum, bool) {
	enum, ok := mappingVulnerabilityScanVulnerabilityScanTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// VulnerabilityScanVulnerabilityScanStatusEnum Enum with underlying type: string
type VulnerabilityScanVulnerabilityScanStatusEnum string

// Set of constants representing the allowable values for VulnerabilityScanVulnerabilityScanStatusEnum
const (
	VulnerabilityScanVulnerabilityScanStatusCompleted VulnerabilityScanVulnerabilityScanStatusEnum = "COMPLETED"
	VulnerabilityScanVulnerabilityScanStatusError     VulnerabilityScanVulnerabilityScanStatusEnum = "ERROR"
	VulnerabilityScanVulnerabilityScanStatusRunning   VulnerabilityScanVulnerabilityScanStatusEnum = "RUNNING"
	VulnerabilityScanVulnerabilityScanStatusAborted   VulnerabilityScanVulnerabilityScanStatusEnum = "ABORTED"
)

var mappingVulnerabilityScanVulnerabilityScanStatusEnum = map[string]VulnerabilityScanVulnerabilityScanStatusEnum{
	"COMPLETED": VulnerabilityScanVulnerabilityScanStatusCompleted,
	"ERROR":     VulnerabilityScanVulnerabilityScanStatusError,
	"RUNNING":   VulnerabilityScanVulnerabilityScanStatusRunning,
	"ABORTED":   VulnerabilityScanVulnerabilityScanStatusAborted,
}

var mappingVulnerabilityScanVulnerabilityScanStatusEnumLowerCase = map[string]VulnerabilityScanVulnerabilityScanStatusEnum{
	"completed": VulnerabilityScanVulnerabilityScanStatusCompleted,
	"error":     VulnerabilityScanVulnerabilityScanStatusError,
	"running":   VulnerabilityScanVulnerabilityScanStatusRunning,
	"aborted":   VulnerabilityScanVulnerabilityScanStatusAborted,
}

// GetVulnerabilityScanVulnerabilityScanStatusEnumValues Enumerates the set of values for VulnerabilityScanVulnerabilityScanStatusEnum
func GetVulnerabilityScanVulnerabilityScanStatusEnumValues() []VulnerabilityScanVulnerabilityScanStatusEnum {
	values := make([]VulnerabilityScanVulnerabilityScanStatusEnum, 0)
	for _, v := range mappingVulnerabilityScanVulnerabilityScanStatusEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityScanVulnerabilityScanStatusEnumStringValues Enumerates the set of values in String for VulnerabilityScanVulnerabilityScanStatusEnum
func GetVulnerabilityScanVulnerabilityScanStatusEnumStringValues() []string {
	return []string{
		"COMPLETED",
		"ERROR",
		"RUNNING",
		"ABORTED",
	}
}

// GetMappingVulnerabilityScanVulnerabilityScanStatusEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityScanVulnerabilityScanStatusEnum(val string) (VulnerabilityScanVulnerabilityScanStatusEnum, bool) {
	enum, ok := mappingVulnerabilityScanVulnerabilityScanStatusEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// VulnerabilityScanLifecycleStateEnum Enum with underlying type: string
type VulnerabilityScanLifecycleStateEnum string

// Set of constants representing the allowable values for VulnerabilityScanLifecycleStateEnum
const (
	VulnerabilityScanLifecycleStateCreating VulnerabilityScanLifecycleStateEnum = "CREATING"
	VulnerabilityScanLifecycleStateUpdating VulnerabilityScanLifecycleStateEnum = "UPDATING"
	VulnerabilityScanLifecycleStateActive   VulnerabilityScanLifecycleStateEnum = "ACTIVE"
	VulnerabilityScanLifecycleStateDeleting VulnerabilityScanLifecycleStateEnum = "DELETING"
	VulnerabilityScanLifecycleStateDeleted  VulnerabilityScanLifecycleStateEnum = "DELETED"
	VulnerabilityScanLifecycleStateFailed   VulnerabilityScanLifecycleStateEnum = "FAILED"
)

var mappingVulnerabilityScanLifecycleStateEnum = map[string]VulnerabilityScanLifecycleStateEnum{
	"CREATING": VulnerabilityScanLifecycleStateCreating,
	"UPDATING": VulnerabilityScanLifecycleStateUpdating,
	"ACTIVE":   VulnerabilityScanLifecycleStateActive,
	"DELETING": VulnerabilityScanLifecycleStateDeleting,
	"DELETED":  VulnerabilityScanLifecycleStateDeleted,
	"FAILED":   VulnerabilityScanLifecycleStateFailed,
}

var mappingVulnerabilityScanLifecycleStateEnumLowerCase = map[string]VulnerabilityScanLifecycleStateEnum{
	"creating": VulnerabilityScanLifecycleStateCreating,
	"updating": VulnerabilityScanLifecycleStateUpdating,
	"active":   VulnerabilityScanLifecycleStateActive,
	"deleting": VulnerabilityScanLifecycleStateDeleting,
	"deleted":  VulnerabilityScanLifecycleStateDeleted,
	"failed":   VulnerabilityScanLifecycleStateFailed,
}

// GetVulnerabilityScanLifecycleStateEnumValues Enumerates the set of values for VulnerabilityScanLifecycleStateEnum
func GetVulnerabilityScanLifecycleStateEnumValues() []VulnerabilityScanLifecycleStateEnum {
	values := make([]VulnerabilityScanLifecycleStateEnum, 0)
	for _, v := range mappingVulnerabilityScanLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityScanLifecycleStateEnumStringValues Enumerates the set of values in String for VulnerabilityScanLifecycleStateEnum
func GetVulnerabilityScanLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"UPDATING",
		"ACTIVE",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingVulnerabilityScanLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityScanLifecycleStateEnum(val string) (VulnerabilityScanLifecycleStateEnum, bool) {
	enum, ok := mappingVulnerabilityScanLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
