// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// PGSQL Control Plane API
//
// Use the OCI Database with PostgreSQL API to manage resources such as database systems, database nodes, backups, and configurations.
// For information, see the user guide documentation for the service (https://docs.oracle.com/iaas/Content/postgresql/home.htm).
//

package psql

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CreateConfigurationDetails The information to create a new configuration.
type CreateConfigurationDetails struct {

	// A user-friendly display name for the configuration. Avoid entering confidential information.
	DisplayName *string `mandatory:"true" json:"displayName"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// Version of the PostgreSQL database.
	DbVersion *string `mandatory:"true" json:"dbVersion"`

	DbConfigurationOverrides *DbConfigurationOverrideCollection `mandatory:"true" json:"dbConfigurationOverrides"`

	// Details about the configuration set.
	Description *string `mandatory:"false" json:"description"`

	// The name of the shape for the configuration.
	// For multi-shape enabled configurations, it is set to PostgreSQL.X86 or similar. Please use compatibleShapes property to set the list of supported shapes.
	Shape *string `mandatory:"false" json:"shape"`

	// Whether the configuration supports flexible shapes.
	IsFlexible *bool `mandatory:"false" json:"isFlexible"`

	// CPU core count.
	// Skip or set it's value to 0 if configuration is for a flexible shape.
	InstanceOcpuCount *int `mandatory:"false" json:"instanceOcpuCount"`

	// Memory size in gigabytes with 1GB increment.
	// Skip or set it's value to 0 if configuration is for a flexible shape.
	InstanceMemorySizeInGBs *int `mandatory:"false" json:"instanceMemorySizeInGBs"`

	// Indicates the collection of compatible shapes for this configuration.
	CompatibleShapes []string `mandatory:"false" json:"compatibleShapes"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// System tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m CreateConfigurationDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CreateConfigurationDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
