// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tlog

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// GetLogProofOKCode is the HTTP code returned for type GetLogProofOK
const GetLogProofOKCode int = 200

/*
GetLogProofOK All hashes required to compute the consistency proof

swagger:response getLogProofOK
*/
type GetLogProofOK struct {

	/*
	  In: Body
	*/
	Payload *models.ConsistencyProof `json:"body,omitempty"`
}

// NewGetLogProofOK creates GetLogProofOK with default headers values
func NewGetLogProofOK() *GetLogProofOK {

	return &GetLogProofOK{}
}

// WithPayload adds the payload to the get log proof o k response
func (o *GetLogProofOK) WithPayload(payload *models.ConsistencyProof) *GetLogProofOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log proof o k response
func (o *GetLogProofOK) SetPayload(payload *models.ConsistencyProof) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogProofOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetLogProofBadRequestCode is the HTTP code returned for type GetLogProofBadRequest
const GetLogProofBadRequestCode int = 400

/*
GetLogProofBadRequest The content supplied to the server was invalid

swagger:response getLogProofBadRequest
*/
type GetLogProofBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogProofBadRequest creates GetLogProofBadRequest with default headers values
func NewGetLogProofBadRequest() *GetLogProofBadRequest {

	return &GetLogProofBadRequest{}
}

// WithPayload adds the payload to the get log proof bad request response
func (o *GetLogProofBadRequest) WithPayload(payload *models.Error) *GetLogProofBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log proof bad request response
func (o *GetLogProofBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogProofBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetLogProofDefault There was an internal error in the server while processing the request

swagger:response getLogProofDefault
*/
type GetLogProofDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogProofDefault creates GetLogProofDefault with default headers values
func NewGetLogProofDefault(code int) *GetLogProofDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogProofDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log proof default response
func (o *GetLogProofDefault) WithStatusCode(code int) *GetLogProofDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log proof default response
func (o *GetLogProofDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the get log proof default response
func (o *GetLogProofDefault) WithPayload(payload *models.Error) *GetLogProofDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log proof default response
func (o *GetLogProofDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogProofDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
