------------------------------------------------------------------------------
--                                                                          --
--                               GNATcoverage                               --
--                                                                          --
--                     Copyright (C) 2008-2024, AdaCore                     --
--                                                                          --
-- GNATcoverage is free software; you can redistribute it and/or modify it  --
-- under terms of the GNU General Public License as published by the  Free  --
-- Software  Foundation;  either version 3,  or (at your option) any later  --
-- version. This software is distributed in the hope that it will be useful --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

with Coverage;

package Annotations.Report is

   procedure Generate_Report
     (Context           : Coverage.Context_Access;
      Final_Report_Name : String_Access;
      Dump_Units        : Boolean);
   --  Generate the final report, source-wise. If Final_Report_Name is
   --  null, dump it on stdout. If Dump_Units, add a section to describe the
   --  list of units of interest considered.

   subtype Coverage_Violations is Report_Section
     range Coverage_Level'Pos (Coverage_Level'First)
        .. Coverage_Level'Pos (Coverage_Level'Last);

end Annotations.Report;
