// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package content provides access to the Content API for Shopping.
//
// For product documentation, see: https://developers.google.com/shopping-content/v2/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/content/v2.1"
//	...
//	ctx := context.Background()
//	contentService, err := content.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	contentService, err := content.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	contentService, err := content.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package content // import "google.golang.org/api/content/v2.1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "content:v2.1"
const apiName = "content"
const apiVersion = "v2.1"
const basePath = "https://shoppingcontent.googleapis.com/content/v2.1/"
const basePathTemplate = "https://shoppingcontent.UNIVERSE_DOMAIN/content/v2.1/"
const mtlsBasePath = "https://shoppingcontent.mtls.googleapis.com/content/v2.1/"

// OAuth2 scopes used by this API.
const (
	// Manage your product listings and accounts for Google Shopping
	ContentScope = "https://www.googleapis.com/auth/content"
)

// NewService creates a new APIService.
func NewService(ctx context.Context, opts ...option.ClientOption) (*APIService, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/content",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &APIService{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Accounts = NewAccountsService(s)
	s.Accountstatuses = NewAccountstatusesService(s)
	s.Accounttax = NewAccounttaxService(s)
	s.Collections = NewCollectionsService(s)
	s.Collectionstatuses = NewCollectionstatusesService(s)
	s.Conversionsources = NewConversionsourcesService(s)
	s.Csses = NewCssesService(s)
	s.Datafeeds = NewDatafeedsService(s)
	s.Datafeedstatuses = NewDatafeedstatusesService(s)
	s.Freelistingsprogram = NewFreelistingsprogramService(s)
	s.Liasettings = NewLiasettingsService(s)
	s.Localinventory = NewLocalinventoryService(s)
	s.Merchantsupport = NewMerchantsupportService(s)
	s.Ordertrackingsignals = NewOrdertrackingsignalsService(s)
	s.Pos = NewPosService(s)
	s.Productdeliverytime = NewProductdeliverytimeService(s)
	s.Products = NewProductsService(s)
	s.Productstatuses = NewProductstatusesService(s)
	s.Promotions = NewPromotionsService(s)
	s.Pubsubnotificationsettings = NewPubsubnotificationsettingsService(s)
	s.Quotas = NewQuotasService(s)
	s.Recommendations = NewRecommendationsService(s)
	s.Regionalinventory = NewRegionalinventoryService(s)
	s.Regions = NewRegionsService(s)
	s.Reports = NewReportsService(s)
	s.Returnaddress = NewReturnaddressService(s)
	s.Returnpolicy = NewReturnpolicyService(s)
	s.Returnpolicyonline = NewReturnpolicyonlineService(s)
	s.Shippingsettings = NewShippingsettingsService(s)
	s.Shoppingadsprogram = NewShoppingadsprogramService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new APIService. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*APIService, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type APIService struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService

	Accountstatuses *AccountstatusesService

	Accounttax *AccounttaxService

	Collections *CollectionsService

	Collectionstatuses *CollectionstatusesService

	Conversionsources *ConversionsourcesService

	Csses *CssesService

	Datafeeds *DatafeedsService

	Datafeedstatuses *DatafeedstatusesService

	Freelistingsprogram *FreelistingsprogramService

	Liasettings *LiasettingsService

	Localinventory *LocalinventoryService

	Merchantsupport *MerchantsupportService

	Ordertrackingsignals *OrdertrackingsignalsService

	Pos *PosService

	Productdeliverytime *ProductdeliverytimeService

	Products *ProductsService

	Productstatuses *ProductstatusesService

	Promotions *PromotionsService

	Pubsubnotificationsettings *PubsubnotificationsettingsService

	Quotas *QuotasService

	Recommendations *RecommendationsService

	Regionalinventory *RegionalinventoryService

	Regions *RegionsService

	Reports *ReportsService

	Returnaddress *ReturnaddressService

	Returnpolicy *ReturnpolicyService

	Returnpolicyonline *ReturnpolicyonlineService

	Shippingsettings *ShippingsettingsService

	Shoppingadsprogram *ShoppingadsprogramService
}

func (s *APIService) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *APIService) *AccountsService {
	rs := &AccountsService{s: s}
	rs.Credentials = NewAccountsCredentialsService(s)
	rs.Labels = NewAccountsLabelsService(s)
	rs.Returncarrier = NewAccountsReturncarrierService(s)
	return rs
}

type AccountsService struct {
	s *APIService

	Credentials *AccountsCredentialsService

	Labels *AccountsLabelsService

	Returncarrier *AccountsReturncarrierService
}

func NewAccountsCredentialsService(s *APIService) *AccountsCredentialsService {
	rs := &AccountsCredentialsService{s: s}
	return rs
}

type AccountsCredentialsService struct {
	s *APIService
}

func NewAccountsLabelsService(s *APIService) *AccountsLabelsService {
	rs := &AccountsLabelsService{s: s}
	return rs
}

type AccountsLabelsService struct {
	s *APIService
}

func NewAccountsReturncarrierService(s *APIService) *AccountsReturncarrierService {
	rs := &AccountsReturncarrierService{s: s}
	return rs
}

type AccountsReturncarrierService struct {
	s *APIService
}

func NewAccountstatusesService(s *APIService) *AccountstatusesService {
	rs := &AccountstatusesService{s: s}
	return rs
}

type AccountstatusesService struct {
	s *APIService
}

func NewAccounttaxService(s *APIService) *AccounttaxService {
	rs := &AccounttaxService{s: s}
	return rs
}

type AccounttaxService struct {
	s *APIService
}

func NewCollectionsService(s *APIService) *CollectionsService {
	rs := &CollectionsService{s: s}
	return rs
}

type CollectionsService struct {
	s *APIService
}

func NewCollectionstatusesService(s *APIService) *CollectionstatusesService {
	rs := &CollectionstatusesService{s: s}
	return rs
}

type CollectionstatusesService struct {
	s *APIService
}

func NewConversionsourcesService(s *APIService) *ConversionsourcesService {
	rs := &ConversionsourcesService{s: s}
	return rs
}

type ConversionsourcesService struct {
	s *APIService
}

func NewCssesService(s *APIService) *CssesService {
	rs := &CssesService{s: s}
	return rs
}

type CssesService struct {
	s *APIService
}

func NewDatafeedsService(s *APIService) *DatafeedsService {
	rs := &DatafeedsService{s: s}
	return rs
}

type DatafeedsService struct {
	s *APIService
}

func NewDatafeedstatusesService(s *APIService) *DatafeedstatusesService {
	rs := &DatafeedstatusesService{s: s}
	return rs
}

type DatafeedstatusesService struct {
	s *APIService
}

func NewFreelistingsprogramService(s *APIService) *FreelistingsprogramService {
	rs := &FreelistingsprogramService{s: s}
	rs.Checkoutsettings = NewFreelistingsprogramCheckoutsettingsService(s)
	return rs
}

type FreelistingsprogramService struct {
	s *APIService

	Checkoutsettings *FreelistingsprogramCheckoutsettingsService
}

func NewFreelistingsprogramCheckoutsettingsService(s *APIService) *FreelistingsprogramCheckoutsettingsService {
	rs := &FreelistingsprogramCheckoutsettingsService{s: s}
	return rs
}

type FreelistingsprogramCheckoutsettingsService struct {
	s *APIService
}

func NewLiasettingsService(s *APIService) *LiasettingsService {
	rs := &LiasettingsService{s: s}
	return rs
}

type LiasettingsService struct {
	s *APIService
}

func NewLocalinventoryService(s *APIService) *LocalinventoryService {
	rs := &LocalinventoryService{s: s}
	return rs
}

type LocalinventoryService struct {
	s *APIService
}

func NewMerchantsupportService(s *APIService) *MerchantsupportService {
	rs := &MerchantsupportService{s: s}
	return rs
}

type MerchantsupportService struct {
	s *APIService
}

func NewOrdertrackingsignalsService(s *APIService) *OrdertrackingsignalsService {
	rs := &OrdertrackingsignalsService{s: s}
	return rs
}

type OrdertrackingsignalsService struct {
	s *APIService
}

func NewPosService(s *APIService) *PosService {
	rs := &PosService{s: s}
	return rs
}

type PosService struct {
	s *APIService
}

func NewProductdeliverytimeService(s *APIService) *ProductdeliverytimeService {
	rs := &ProductdeliverytimeService{s: s}
	return rs
}

type ProductdeliverytimeService struct {
	s *APIService
}

func NewProductsService(s *APIService) *ProductsService {
	rs := &ProductsService{s: s}
	return rs
}

type ProductsService struct {
	s *APIService
}

func NewProductstatusesService(s *APIService) *ProductstatusesService {
	rs := &ProductstatusesService{s: s}
	return rs
}

type ProductstatusesService struct {
	s *APIService
}

func NewPromotionsService(s *APIService) *PromotionsService {
	rs := &PromotionsService{s: s}
	return rs
}

type PromotionsService struct {
	s *APIService
}

func NewPubsubnotificationsettingsService(s *APIService) *PubsubnotificationsettingsService {
	rs := &PubsubnotificationsettingsService{s: s}
	return rs
}

type PubsubnotificationsettingsService struct {
	s *APIService
}

func NewQuotasService(s *APIService) *QuotasService {
	rs := &QuotasService{s: s}
	return rs
}

type QuotasService struct {
	s *APIService
}

func NewRecommendationsService(s *APIService) *RecommendationsService {
	rs := &RecommendationsService{s: s}
	return rs
}

type RecommendationsService struct {
	s *APIService
}

func NewRegionalinventoryService(s *APIService) *RegionalinventoryService {
	rs := &RegionalinventoryService{s: s}
	return rs
}

type RegionalinventoryService struct {
	s *APIService
}

func NewRegionsService(s *APIService) *RegionsService {
	rs := &RegionsService{s: s}
	return rs
}

type RegionsService struct {
	s *APIService
}

func NewReportsService(s *APIService) *ReportsService {
	rs := &ReportsService{s: s}
	return rs
}

type ReportsService struct {
	s *APIService
}

func NewReturnaddressService(s *APIService) *ReturnaddressService {
	rs := &ReturnaddressService{s: s}
	return rs
}

type ReturnaddressService struct {
	s *APIService
}

func NewReturnpolicyService(s *APIService) *ReturnpolicyService {
	rs := &ReturnpolicyService{s: s}
	return rs
}

type ReturnpolicyService struct {
	s *APIService
}

func NewReturnpolicyonlineService(s *APIService) *ReturnpolicyonlineService {
	rs := &ReturnpolicyonlineService{s: s}
	return rs
}

type ReturnpolicyonlineService struct {
	s *APIService
}

func NewShippingsettingsService(s *APIService) *ShippingsettingsService {
	rs := &ShippingsettingsService{s: s}
	return rs
}

type ShippingsettingsService struct {
	s *APIService
}

func NewShoppingadsprogramService(s *APIService) *ShoppingadsprogramService {
	rs := &ShoppingadsprogramService{s: s}
	return rs
}

type ShoppingadsprogramService struct {
	s *APIService
}

// Account: Account data. After the creation of a new account it may take a few
// minutes before it's fully operational. The methods delete, insert, and
// update require the admin role.
type Account struct {
	// AccountManagement: Output only. How the account is managed. Acceptable
	// values are: - "manual" - "automatic"
	AccountManagement string `json:"accountManagement,omitempty"`
	// AdsLinks: Linked Ads accounts that are active or pending approval. To create
	// a new link request, add a new link with status `active` to the list. It will
	// remain in a `pending` state until approved or rejected either in the Ads
	// interface or through the Google Ads API. To delete an active link, or to
	// cancel a link request, remove it from the list.
	AdsLinks []*AccountAdsLink `json:"adsLinks,omitempty"`
	// AdultContent: Indicates whether the merchant sells adult content.
	AdultContent bool `json:"adultContent,omitempty"`
	// AutomaticImprovements: The automatic improvements of the account can be used
	// to automatically update items, improve images and shipping. Each section
	// inside AutomaticImprovements is updated separately.
	AutomaticImprovements *AccountAutomaticImprovements `json:"automaticImprovements,omitempty"`
	// AutomaticLabelIds: Automatically created label IDs that are assigned to the
	// account by CSS Center.
	AutomaticLabelIds googleapi.Uint64s `json:"automaticLabelIds,omitempty"`
	// BusinessIdentity: The business identity attributes can be used to
	// self-declare attributes that let customers know more about your business.
	BusinessIdentity *AccountBusinessIdentity `json:"businessIdentity,omitempty"`
	// BusinessInformation: The business information of the account.
	BusinessInformation *AccountBusinessInformation `json:"businessInformation,omitempty"`
	// ConversionSettings: Settings for conversion tracking.
	ConversionSettings *AccountConversionSettings `json:"conversionSettings,omitempty"`
	// CssId: ID of CSS the account belongs to.
	CssId uint64 `json:"cssId,omitempty,string"`
	// GoogleMyBusinessLink: The Business Profile which is linked or in the process
	// of being linked with the Merchant Center account.
	GoogleMyBusinessLink *AccountGoogleMyBusinessLink `json:"googleMyBusinessLink,omitempty"`
	// Id: Required. 64-bit Merchant Center account ID.
	Id uint64 `json:"id,omitempty,string"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#account".
	Kind string `json:"kind,omitempty"`
	// LabelIds: Manually created label IDs that are assigned to the account by
	// CSS.
	LabelIds googleapi.Uint64s `json:"labelIds,omitempty"`
	// Name: Required. Display name for the account.
	Name string `json:"name,omitempty"`
	// SellerId: Client-specific, locally-unique, internal ID for the child
	// account.
	SellerId string `json:"sellerId,omitempty"`
	// Users: Users with access to the account. Every account (except for
	// subaccounts) must have at least one admin user.
	Users []*AccountUser `json:"users,omitempty"`
	// WebsiteUrl: The merchant's website.
	WebsiteUrl string `json:"websiteUrl,omitempty"`
	// YoutubeChannelLinks: Linked YouTube channels that are active or pending
	// approval. To create a new link request, add a new link with status `active`
	// to the list. It will remain in a `pending` state until approved or rejected
	// in the YT Creator Studio interface. To delete an active link, or to cancel a
	// link request, remove it from the list.
	YoutubeChannelLinks []*AccountYouTubeChannelLink `json:"youtubeChannelLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountManagement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountManagement") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Account) MarshalJSON() ([]byte, error) {
	type NoMethod Account
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountAddress struct {
	// Country: CLDR country code (for example, "US"). All MCA sub-accounts inherit
	// the country of their parent MCA by default, however the country can be
	// updated for individual sub-accounts.
	Country string `json:"country,omitempty"`
	// Locality: City, town or commune. May also include dependent localities or
	// sublocalities (for example, neighborhoods or suburbs).
	Locality string `json:"locality,omitempty"`
	// PostalCode: Postal code or ZIP (for example, "94043").
	PostalCode string `json:"postalCode,omitempty"`
	// Region: Top-level administrative subdivision of the country. For example, a
	// state like California ("CA") or a province like Quebec ("QC").
	Region string `json:"region,omitempty"`
	// StreetAddress: Street-level part of the address. Use `\n` to add a second
	// line.
	StreetAddress string `json:"streetAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountAddress) MarshalJSON() ([]byte, error) {
	type NoMethod AccountAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountAdsLink struct {
	// AdsId: Customer ID of the Ads account.
	AdsId uint64 `json:"adsId,omitempty,string"`
	// Status: Status of the link between this Merchant Center account and the Ads
	// account. Upon retrieval, it represents the actual status of the link and can
	// be either `active` if it was approved in Google Ads or `pending` if it's
	// pending approval. Upon insertion, it represents the *intended* status of the
	// link. Re-uploading a link with status `active` when it's still pending or
	// with status `pending` when it's already active will have no effect: the
	// status will remain unchanged. Re-uploading a link with deprecated status
	// `inactive` is equivalent to not submitting the link at all and will delete
	// the link if it was active or cancel the link request if it was pending.
	// Acceptable values are: - "active" - "pending"
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdsId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdsId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountAdsLink) MarshalJSON() ([]byte, error) {
	type NoMethod AccountAdsLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountAutomaticImprovements: The automatic improvements of the account can
// be used to automatically update items, improve images and shipping.
type AccountAutomaticImprovements struct {
	// ImageImprovements: This improvement will attempt to automatically correct
	// submitted images if they don't meet the image requirements
	// (https://support.google.com/merchants/answer/6324350), for example, removing
	// overlays. If successful, the image will be replaced and approved. This
	// improvement is only applied to images of disapproved offers. For more
	// information see: Automatic image improvements
	// (https://support.google.com/merchants/answer/9242973) This field is only
	// updated (cleared) if provided.
	ImageImprovements *AccountImageImprovements `json:"imageImprovements,omitempty"`
	// ItemUpdates: Turning on item updates
	// (https://support.google.com/merchants/answer/3246284) allows Google to
	// automatically update items for you. When item updates are on, Google uses
	// the structured data markup on the website and advanced data extractors to
	// update the price and availability of the items. When the item updates are
	// off, items with mismatched data aren't shown. This field is only updated
	// (cleared) if provided.
	ItemUpdates *AccountItemUpdates `json:"itemUpdates,omitempty"`
	// ShippingImprovements: Not available for MCAs accounts
	// (https://support.google.com/merchants/answer/188487). By turning on
	// automatic shipping improvements
	// (https://support.google.com/merchants/answer/10027038), you are allowing
	// Google to improve the accuracy of your delivery times shown to shoppers
	// using Google. More accurate delivery times, especially when faster,
	// typically lead to better conversion rates. Google will improve your
	// estimated delivery times based on various factors: - Delivery address of an
	// order - Current handling time and shipping time settings - Estimated
	// weekdays or business days - Parcel tracking data This field is only updated
	// (cleared) if provided.
	ShippingImprovements *AccountShippingImprovements `json:"shippingImprovements,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageImprovements") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageImprovements") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountAutomaticImprovements) MarshalJSON() ([]byte, error) {
	type NoMethod AccountAutomaticImprovements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountBusinessIdentity: The business identity attributes
// (https://support.google.com/merchants/answer/10342414) can be used to
// self-declare attributes that let customers know more about your business.
type AccountBusinessIdentity struct {
	// BlackOwned: Specifies whether the business identifies itself as being
	// black-owned. This optional field is only available for merchants with a
	// business country set to "US". This field is not allowed for marketplaces or
	// marketplace sellers.
	BlackOwned *AccountIdentityType `json:"blackOwned,omitempty"`
	// IncludeForPromotions: Required. By setting this field, your business may be
	// included in promotions for all the selected attributes. If you clear this
	// option, it won't affect your identification with any of the attributes. For
	// this field to be set, the merchant must self identify with at least one of
	// the `AccountIdentityType`. If none are included, the request will be
	// considered invalid.
	IncludeForPromotions bool `json:"includeForPromotions,omitempty"`
	// LatinoOwned: Specifies whether the business identifies itself as being
	// latino-owned. This optional field is only available for merchants with a
	// business country set to "US". This field is not allowed for marketplaces or
	// marketplace sellers.
	LatinoOwned *AccountIdentityType `json:"latinoOwned,omitempty"`
	// SmallBusiness: Specifies whether the business identifies itself as a small
	// business. This optional field is only available for merchants with a
	// business country set to "US". It is also not allowed for marketplaces, but
	// it is allowed to marketplace sellers.
	SmallBusiness *AccountIdentityType `json:"smallBusiness,omitempty"`
	// VeteranOwned: Specifies whether the business identifies itself as being
	// veteran-owned. This optional field is only available for merchants with a
	// business country set to "US". This field is not allowed for marketplaces or
	// marketplace sellers.
	VeteranOwned *AccountIdentityType `json:"veteranOwned,omitempty"`
	// WomenOwned: Specifies whether the business identifies itself as being
	// women-owned. This optional field is only available for merchants with a
	// business country set to "US". This field is not allowed for marketplaces or
	// marketplace sellers.
	WomenOwned *AccountIdentityType `json:"womenOwned,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlackOwned") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlackOwned") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountBusinessIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod AccountBusinessIdentity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountBusinessInformation struct {
	// Address: The address of the business. Use `\n` to add a second address line.
	Address *AccountAddress `json:"address,omitempty"`
	// CustomerService: The customer service information of the business.
	CustomerService *AccountCustomerService `json:"customerService,omitempty"`
	// KoreanBusinessRegistrationNumber: The 10-digit Korean business registration
	// number (https://support.google.com/merchants/answer/9037766) separated with
	// dashes in the format: XXX-XX-XXXXX. This field will only be updated if
	// explicitly set.
	KoreanBusinessRegistrationNumber string `json:"koreanBusinessRegistrationNumber,omitempty"`
	// PhoneNumber: The phone number of the business in E.164
	// (https://en.wikipedia.org/wiki/E.164) format. This can only be updated if a
	// verified phone number is not already set. To replace a verified phone number
	// use the `Accounts.requestphoneverification` and
	// `Accounts.verifyphonenumber`.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PhoneVerificationStatus: Verification status of the phone number of the
	// business. This status is read only and can be updated only by successful
	// phone verification. Acceptable values are: - "verified" - "unverified"
	PhoneVerificationStatus string `json:"phoneVerificationStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountBusinessInformation) MarshalJSON() ([]byte, error) {
	type NoMethod AccountBusinessInformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountConversionSettings: Settings for conversion tracking.
type AccountConversionSettings struct {
	// FreeListingsAutoTaggingEnabled: When enabled, free listing URLs have a
	// parameter to enable conversion tracking for products owned by the current
	// merchant account. See auto-tagging
	// (https://support.google.com/merchants/answer/11127659).
	FreeListingsAutoTaggingEnabled bool `json:"freeListingsAutoTaggingEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "FreeListingsAutoTaggingEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FreeListingsAutoTaggingEnabled")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountConversionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AccountConversionSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountCredentials: Credentials allowing Google to call a partner's API on
// behalf of a merchant.
type AccountCredentials struct {
	// AccessToken: An OAuth access token.
	AccessToken string `json:"accessToken,omitempty"`
	// ExpiresIn: The amount of time, in seconds, after which the access token is
	// no longer valid.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// Purpose: Indicates to Google how Google should use these OAuth tokens.
	//
	// Possible values:
	//   "ACCOUNT_CREDENTIALS_PURPOSE_UNSPECIFIED" - Unknown purpose.
	//   "SHOPIFY_ORDER_MANAGEMENT" - The credentials allow Google to manage
	// Shopify orders on behalf of the merchant (deprecated).
	//   "SHOPIFY_INTEGRATION" - The credentials allow Google to manage Shopify
	// integration on behalf of the merchant.
	Purpose string `json:"purpose,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountCredentials) MarshalJSON() ([]byte, error) {
	type NoMethod AccountCredentials
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountCustomerService struct {
	// Email: Customer service email.
	Email string `json:"email,omitempty"`
	// PhoneNumber: Customer service phone number.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// Url: Customer service URL.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountCustomerService) MarshalJSON() ([]byte, error) {
	type NoMethod AccountCustomerService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountGoogleMyBusinessLink struct {
	// GmbAccountId: The ID of the Business Profile. If this is provided, then
	// `gmbEmail` is ignored. The value of this field should match the `accountId`
	// used by the Business Profile API.
	GmbAccountId string `json:"gmbAccountId,omitempty"`
	// GmbEmail: The Business Profile email address of a specific account within a
	// Business Profile. A sample account within a Business Profile could be a
	// business account with set of locations, managed under the Business Profile.
	GmbEmail string `json:"gmbEmail,omitempty"`
	// Status: Status of the link between this Merchant Center account and the
	// Business Profile. Acceptable values are: - "active" - "pending"
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GmbAccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GmbAccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountGoogleMyBusinessLink) MarshalJSON() ([]byte, error) {
	type NoMethod AccountGoogleMyBusinessLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountIdentifier struct {
	// AggregatorId: The aggregator ID, set for aggregators and subaccounts (in
	// that case, it represents the aggregator of the subaccount).
	AggregatorId uint64 `json:"aggregatorId,omitempty,string"`
	// MerchantId: The merchant account ID, set for individual accounts and
	// subaccounts.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AggregatorId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregatorId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountIdentifier) MarshalJSON() ([]byte, error) {
	type NoMethod AccountIdentifier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountIdentityType: The account identity type used to specify attributes.
type AccountIdentityType struct {
	// SelfIdentified: Optional. Indicates that the business identifies itself with
	// a given identity type. Setting this field does not automatically mean
	// eligibility for promotions.
	SelfIdentified bool `json:"selfIdentified,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelfIdentified") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelfIdentified") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountIdentityType) MarshalJSON() ([]byte, error) {
	type NoMethod AccountIdentityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountImageImprovements: This improvement will attempt to automatically
// correct submitted images if they don't meet the image requirements
// (https://support.google.com/merchants/answer/6324350), for example, removing
// overlays. If successful, the image will be replaced and approved. This
// improvement is only applied to images of disapproved offers. For more
// information see: Automatic image improvements
// (https://support.google.com/merchants/answer/9242973)
type AccountImageImprovements struct {
	// AccountImageImprovementsSettings: Determines how the images should be
	// automatically updated. If this field is not present, then the settings will
	// be deleted. If there are no settings for subaccount, they are inherited from
	// aggregator.
	AccountImageImprovementsSettings *AccountImageImprovementsSettings `json:"accountImageImprovementsSettings,omitempty"`
	// EffectiveAllowAutomaticImageImprovements: Output only. The effective value
	// of allow_automatic_image_improvements. If
	// account_image_improvements_settings is present, then this value is the same.
	// Otherwise, it represents the inherited value of the parent account.
	// Read-only.
	EffectiveAllowAutomaticImageImprovements bool `json:"effectiveAllowAutomaticImageImprovements,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AccountImageImprovementsSettings") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "AccountImageImprovementsSettings") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s AccountImageImprovements) MarshalJSON() ([]byte, error) {
	type NoMethod AccountImageImprovements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountImageImprovementsSettings: Settings for the Automatic Image
// Improvements.
type AccountImageImprovementsSettings struct {
	// AllowAutomaticImageImprovements: Enables automatic image improvements.
	AllowAutomaticImageImprovements bool `json:"allowAutomaticImageImprovements,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AllowAutomaticImageImprovements") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowAutomaticImageImprovements")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountImageImprovementsSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AccountImageImprovementsSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountIssue: An issue affecting specific merchant.
type AccountIssue struct {
	// Actions: A list of actionable steps that can be executed to solve the issue.
	// An example is requesting a re-review or providing arguments when merchant
	// disagrees with the issue. Actions that are supported in (your) third-party
	// application can be rendered as buttons and should be available to merchant
	// when they expand the issue.
	Actions []*Action `json:"actions,omitempty"`
	// Impact: Clarifies the severity of the issue. The summarizing message, if
	// present, should be shown right under the title for each issue. It helps
	// merchants to quickly understand the impact of the issue. The detailed
	// breakdown helps the merchant to fully understand the impact of the issue. It
	// can be rendered as dialog that opens when the merchant mouse over the
	// summarized impact statement. Issues with different severity can be styled
	// differently. They may use a different color or icon to signal the difference
	// between `ERROR`, `WARNING` and `INFO`.
	Impact *AccountIssueImpact `json:"impact,omitempty"`
	// PrerenderedContent: Details of the issue as a pre-rendered HTML. HTML
	// elements contain CSS classes that can be used to customize the style of the
	// content. Always sanitize the HTML before embedding it directly to your
	// application. The sanitizer needs to allow basic HTML tags, such as: `div`,
	// `span`, `p`, `a`, `ul`, `li`, `table`, `tr`, `td`. For example, you can use
	// DOMPurify (https://www.npmjs.com/package/dompurify). CSS classes: *
	// `issue-detail` - top level container for the detail of the issue *
	// `callout-banners` - section of the `issue-detail` with callout banners *
	// `callout-banner` - single callout banner, inside `callout-banners` *
	// `callout-banner-info` - callout with important information (default) *
	// `callout-banner-warning` - callout with a warning * `callout-banner-error` -
	// callout informing about an error (most severe) * `issue-content` - section
	// of the `issue-detail`, contains multiple `content-element` *
	// `content-element` - content element such as a list, link or paragraph,
	// inside `issue-content` * `root-causes` - unordered list with items
	// describing root causes of the issue, inside `issue-content` *
	// `root-causes-intro` - intro text before the `root-causes` list, inside
	// `issue-content` * `segment` - section of the text, `span` inside paragraph *
	// `segment-attribute` - section of the text that represents a product
	// attribute, for example 'image\_link' * `segment-literal` - section of the
	// text that contains a special value, for example '0-1000 kg' * `segment-bold`
	// - section of the text that should be rendered as bold * `segment-italic` -
	// section of the text that should be rendered as italic * `tooltip` - used on
	// paragraphs that should be rendered with a tooltip. A section of the text in
	// such a paragraph will have a class `tooltip-text` and is intended to be
	// shown in a mouse over dialog. If the style is not used, the `tooltip-text`
	// section would be shown on a new line, after the main part of the text. *
	// `tooltip-text` - marks a section of the text within a `tooltip`, that is
	// intended to be shown in a mouse over dialog. * `tooltip-icon` - marks a
	// section of the text within a `tooltip`, that can be replaced with a tooltip
	// icon, for example '?' or 'i'. By default, this section contains a `br` tag,
	// that is separating the main text and the tooltip text when the style is not
	// used. * `tooltip-style-question` - the tooltip shows helpful information,
	// can use the '?' as an icon. * `tooltip-style-info` - the tooltip adds
	// additional information fitting to the context, can use the 'i' as an icon. *
	// `content-moderation` - marks the paragraph that explains how the issue was
	// identified. * `new-element` - Present for new elements added to the
	// pre-rendered content in the future. To make sure that a new content element
	// does not break your style, you can hide everything with this class.
	PrerenderedContent string `json:"prerenderedContent,omitempty"`
	// Title: Title of the issue.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountIssue) MarshalJSON() ([]byte, error) {
	type NoMethod AccountIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountIssueImpact: Overall impact of the issue.
type AccountIssueImpact struct {
	// Breakdowns: Detailed impact breakdown. Explains the types of restriction the
	// issue has in different shopping destinations and territory. If present, it
	// should be rendered to the merchant. Can be shown as a mouse over dropdown or
	// a dialog. Each breakdown item represents a group of regions with the same
	// impact details.
	Breakdowns []*Breakdown `json:"breakdowns,omitempty"`
	// Message: Optional. Message summarizing the overall impact of the issue. If
	// present, it should be rendered to the merchant. For example: "Disapproves
	// 90k offers in 25 countries"
	Message string `json:"message,omitempty"`
	// Severity: The severity of the issue.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Default value. Will never be provided by the API.
	//   "ERROR" - Causes either an account suspension or an item disapproval.
	// Errors should be resolved as soon as possible to ensure items are eligible
	// to appear in results again.
	//   "WARNING" - Warnings can negatively impact the performance of ads and can
	// lead to item or account suspensions in the future unless the issue is
	// resolved.
	//   "INFO" - Infos are suggested optimizations to increase data quality.
	// Resolving these issues is recommended, but not required.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Breakdowns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Breakdowns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountIssueImpact) MarshalJSON() ([]byte, error) {
	type NoMethod AccountIssueImpact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountItemUpdates: Turning on item updates
// (https://support.google.com/merchants/answer/3246284) allows Google to
// automatically update items for you. When item updates are on, Google uses
// the structured data markup on the website and advanced data extractors to
// update the price and availability of the items. When the item updates are
// off, items with mismatched data aren't shown.
type AccountItemUpdates struct {
	// AccountItemUpdatesSettings: Determines which attributes of the items should
	// be automatically updated. If this field is not present, then the settings
	// will be deleted. If there are no settings for subaccount, they are inherited
	// from aggregator.
	AccountItemUpdatesSettings *AccountItemUpdatesSettings `json:"accountItemUpdatesSettings,omitempty"`
	// EffectiveAllowAvailabilityUpdates: Output only. The effective value of
	// allow_availability_updates. If account_item_updates_settings is present,
	// then this value is the same. Otherwise, it represents the inherited value of
	// the parent account. Read-only.
	EffectiveAllowAvailabilityUpdates bool `json:"effectiveAllowAvailabilityUpdates,omitempty"`
	// EffectiveAllowConditionUpdates: Output only. The effective value of
	// allow_condition_updates. If account_item_updates_settings is present, then
	// this value is the same. Otherwise, it represents the inherited value of the
	// parent account. Read-only.
	EffectiveAllowConditionUpdates bool `json:"effectiveAllowConditionUpdates,omitempty"`
	// EffectiveAllowPriceUpdates: Output only. The effective value of
	// allow_price_updates. If account_item_updates_settings is present, then this
	// value is the same. Otherwise, it represents the inherited value of the
	// parent account. Read-only.
	EffectiveAllowPriceUpdates bool `json:"effectiveAllowPriceUpdates,omitempty"`
	// EffectiveAllowStrictAvailabilityUpdates: Output only. The effective value of
	// allow_strict_availability_updates. If account_item_updates_settings is
	// present, then this value is the same. Otherwise, it represents the inherited
	// value of the parent account. Read-only.
	EffectiveAllowStrictAvailabilityUpdates bool `json:"effectiveAllowStrictAvailabilityUpdates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountItemUpdatesSettings")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountItemUpdatesSettings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountItemUpdates) MarshalJSON() ([]byte, error) {
	type NoMethod AccountItemUpdates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountItemUpdatesSettings: Settings for the Automatic Item Updates.
type AccountItemUpdatesSettings struct {
	// AllowAvailabilityUpdates: If availability updates are enabled, any previous
	// availability values get overwritten if Google finds an out-of-stock
	// annotation on the offer's page. If additionally `allow_availability_updates`
	// field is set to true, values get overwritten if Google finds an in-stock
	// annotation on the offer’s page.
	AllowAvailabilityUpdates bool `json:"allowAvailabilityUpdates,omitempty"`
	// AllowConditionUpdates: If condition updates are enabled, Google always
	// updates item condition with the condition detected from the details of your
	// product.
	AllowConditionUpdates bool `json:"allowConditionUpdates,omitempty"`
	// AllowPriceUpdates: If price updates are enabled, Google always updates the
	// active price with the crawled information.
	AllowPriceUpdates bool `json:"allowPriceUpdates,omitempty"`
	// AllowStrictAvailabilityUpdates: If allow_availability_updates is enabled,
	// items are automatically updated in all your Shopping target countries. By
	// default, availability updates will only be applied to items that are 'out of
	// stock' on your website but 'in stock' on Shopping. Set this to true to also
	// update items that are 'in stock' on your website, but 'out of stock' on
	// Google Shopping. In order for this field to have an effect, you must also
	// allow availability updates.
	AllowStrictAvailabilityUpdates bool `json:"allowStrictAvailabilityUpdates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowAvailabilityUpdates")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowAvailabilityUpdates") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountItemUpdatesSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AccountItemUpdatesSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountLabel: Label assigned by CSS domain or CSS group to one of its
// sub-accounts.
type AccountLabel struct {
	// AccountId: Immutable. The ID of account this label belongs to.
	AccountId int64 `json:"accountId,omitempty,string"`
	// Description: The description of this label.
	Description string `json:"description,omitempty"`
	// LabelId: Output only. The ID of the label.
	LabelId int64 `json:"labelId,omitempty,string"`
	// LabelType: Output only. The type of this label.
	//
	// Possible values:
	//   "LABEL_TYPE_UNSPECIFIED" - Unknown label type.
	//   "MANUAL" - Indicates that the label was created manually.
	//   "AUTOMATIC" - Indicates that the label was created automatically by CSS
	// Center.
	LabelType string `json:"labelType,omitempty"`
	// Name: The display name of this label.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountLabel) MarshalJSON() ([]byte, error) {
	type NoMethod AccountLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountReturnCarrier:  The return carrier information. This service is
// designed for merchants enrolled in the Buy on Google program.
type AccountReturnCarrier struct {
	// CarrierAccountId: Output only. Immutable. The Google-provided unique carrier
	// ID, used to update the resource.
	CarrierAccountId int64 `json:"carrierAccountId,omitempty,string"`
	// CarrierAccountName: Name of the carrier account.
	CarrierAccountName string `json:"carrierAccountName,omitempty"`
	// CarrierAccountNumber: Number of the carrier account.
	CarrierAccountNumber string `json:"carrierAccountNumber,omitempty"`
	// CarrierCode: The carrier code enum. Accepts the values FEDEX or UPS.
	//
	// Possible values:
	//   "CARRIER_CODE_UNSPECIFIED" - Carrier not specified
	//   "FEDEX" - FedEx carrier
	//   "UPS" - UPS carrier
	CarrierCode string `json:"carrierCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CarrierAccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CarrierAccountId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountReturnCarrier) MarshalJSON() ([]byte, error) {
	type NoMethod AccountReturnCarrier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountShippingImprovements: Not available for MCAs accounts
// (https://support.google.com/merchants/answer/188487). By turning on
// automatic shipping improvements
// (https://support.google.com/merchants/answer/10027038), you are allowing
// Google to improve the accuracy of your delivery times shown to shoppers
// using Google. More accurate delivery times, especially when faster,
// typically lead to better conversion rates. Google will improve your
// estimated delivery times based on various factors: * Delivery address of an
// order * Current handling time and shipping time settings * Estimated
// weekdays or business days * Parcel tracking data
type AccountShippingImprovements struct {
	// AllowShippingImprovements: Enables automatic shipping improvements.
	AllowShippingImprovements bool `json:"allowShippingImprovements,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowShippingImprovements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowShippingImprovements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountShippingImprovements) MarshalJSON() ([]byte, error) {
	type NoMethod AccountShippingImprovements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountStatus: The status of an account, that is, information about its
// products, which is computed offline and not returned immediately at
// insertion time.
type AccountStatus struct {
	// AccountId: The ID of the account for which the status is reported.
	AccountId string `json:"accountId,omitempty"`
	// AccountLevelIssues: A list of account level issues.
	AccountLevelIssues []*AccountStatusAccountLevelIssue `json:"accountLevelIssues,omitempty"`
	// AccountManagement: How the account is managed. Acceptable values are: -
	// "manual" - "automatic"
	AccountManagement string `json:"accountManagement,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountStatus"
	Kind string `json:"kind,omitempty"`
	// Products: List of product-related data by channel, destination, and country.
	// Data in this field may be delayed by up to 30 minutes.
	Products []*AccountStatusProducts `json:"products,omitempty"`
	// WebsiteClaimed: Whether the account's website is claimed or not.
	WebsiteClaimed bool `json:"websiteClaimed,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountStatus) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountStatusAccountLevelIssue struct {
	// Country: Country for which this issue is reported.
	Country string `json:"country,omitempty"`
	// Destination: The destination the issue applies to. If this field is empty
	// then the issue applies to all available destinations.
	Destination string `json:"destination,omitempty"`
	// Detail: Additional details about the issue.
	Detail string `json:"detail,omitempty"`
	// Documentation: The URL of a web page to help resolving this issue.
	Documentation string `json:"documentation,omitempty"`
	// Id: Issue identifier.
	Id string `json:"id,omitempty"`
	// Severity: Severity of the issue. Acceptable values are: - "critical" -
	// "error" - "suggestion"
	Severity string `json:"severity,omitempty"`
	// Title: Short description of the issue.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountStatusAccountLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatusAccountLevelIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountStatusItemLevelIssue struct {
	// AttributeName: The attribute's name, if the issue is caused by a single
	// attribute.
	AttributeName string `json:"attributeName,omitempty"`
	// Code: The error code of the issue.
	Code string `json:"code,omitempty"`
	// Description: A short issue description in English.
	Description string `json:"description,omitempty"`
	// Detail: A detailed issue description in English.
	Detail string `json:"detail,omitempty"`
	// Documentation: The URL of a web page to help with resolving this issue.
	Documentation string `json:"documentation,omitempty"`
	// NumItems: Number of items with this issue.
	NumItems int64 `json:"numItems,omitempty,string"`
	// Resolution: Whether the issue can be resolved by the merchant.
	Resolution string `json:"resolution,omitempty"`
	// Servability: How this issue affects serving of the offer.
	Servability string `json:"servability,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountStatusItemLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatusItemLevelIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountStatusProducts struct {
	// Channel: The channel the data applies to. Acceptable values are: - "local"
	// - "online"
	Channel string `json:"channel,omitempty"`
	// Country: The country the data applies to.
	Country string `json:"country,omitempty"`
	// Destination: The destination the data applies to.
	Destination string `json:"destination,omitempty"`
	// ItemLevelIssues: List of item-level issues.
	ItemLevelIssues []*AccountStatusItemLevelIssue `json:"itemLevelIssues,omitempty"`
	// Statistics: Aggregated product statistics.
	Statistics *AccountStatusStatistics `json:"statistics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountStatusProducts) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatusProducts
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountStatusStatistics struct {
	// Active: Number of active offers.
	Active int64 `json:"active,omitempty,string"`
	// Disapproved: Number of disapproved offers.
	Disapproved int64 `json:"disapproved,omitempty,string"`
	// Expiring: Number of expiring offers.
	Expiring int64 `json:"expiring,omitempty,string"`
	// Pending: Number of pending offers.
	Pending int64 `json:"pending,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountStatusStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod AccountStatusStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountTax: The tax settings of a merchant account. All methods require the
// admin role.
type AccountTax struct {
	// AccountId: Required. The ID of the account to which these account tax
	// settings belong.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountTax".
	Kind string `json:"kind,omitempty"`
	// Rules: Tax rules. Updating the tax rules will enable "US" taxes (not
	// reversible). Defining no rules is equivalent to not charging tax at all.
	Rules []*AccountTaxTaxRule `json:"rules,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountTax) MarshalJSON() ([]byte, error) {
	type NoMethod AccountTax
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountTaxTaxRule: Tax calculation rule to apply in a state or province (US
// only).
type AccountTaxTaxRule struct {
	// Country: Country code in which tax is applicable.
	Country string `json:"country,omitempty"`
	// LocationId: Required. State (or province) is which the tax is applicable,
	// described by its location ID (also called criteria ID).
	LocationId uint64 `json:"locationId,omitempty,string"`
	// RatePercent: Explicit tax rate in percent, represented as a floating point
	// number without the percentage character. Must not be negative.
	RatePercent string `json:"ratePercent,omitempty"`
	// ShippingTaxed: If true, shipping charges are also taxed.
	ShippingTaxed bool `json:"shippingTaxed,omitempty"`
	// UseGlobalRate: Whether the tax rate is taken from a global tax table or
	// specified explicitly.
	UseGlobalRate bool `json:"useGlobalRate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountTaxTaxRule) MarshalJSON() ([]byte, error) {
	type NoMethod AccountTaxTaxRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountUser struct {
	// Admin: Whether user is an admin.
	Admin bool `json:"admin,omitempty"`
	// EmailAddress: User's email address.
	EmailAddress string `json:"emailAddress,omitempty"`
	// OrderManager: Whether user is an order manager.
	OrderManager bool `json:"orderManager,omitempty"`
	// PaymentsAnalyst: Whether user can access payment statements.
	PaymentsAnalyst bool `json:"paymentsAnalyst,omitempty"`
	// PaymentsManager: Whether user can manage payment settings.
	PaymentsManager bool `json:"paymentsManager,omitempty"`
	// ReportingManager: Whether user is a reporting manager. This role is
	// equivalent to the Performance and insights role in Merchant Center.
	ReportingManager bool `json:"reportingManager,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Admin") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Admin") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountUser) MarshalJSON() ([]byte, error) {
	type NoMethod AccountUser
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountYouTubeChannelLink struct {
	// ChannelId: Channel ID.
	ChannelId string `json:"channelId,omitempty"`
	// Status: Status of the link between this Merchant Center account and the
	// YouTube channel. Upon retrieval, it represents the actual status of the link
	// and can be either `active` if it was approved in YT Creator Studio or
	// `pending` if it's pending approval. Upon insertion, it represents the
	// *intended* status of the link. Re-uploading a link with status `active` when
	// it's still pending or with status `pending` when it's already active will
	// have no effect: the status will remain unchanged. Re-uploading a link with
	// deprecated status `inactive` is equivalent to not submitting the link at all
	// and will delete the link if it was active or cancel the link request if it
	// was pending.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountYouTubeChannelLink) MarshalJSON() ([]byte, error) {
	type NoMethod AccountYouTubeChannelLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsAuthInfoResponse struct {
	// AccountIdentifiers: The account identifiers corresponding to the
	// authenticated user. - For an individual account: only the merchant ID is
	// defined - For an aggregator: only the aggregator ID is defined - For a
	// subaccount of an MCA: both the merchant ID and the aggregator ID are
	// defined.
	AccountIdentifiers []*AccountIdentifier `json:"accountIdentifiers,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountsAuthInfoResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountIdentifiers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountIdentifiers") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsAuthInfoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsAuthInfoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsClaimWebsiteResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountsClaimWebsiteResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsClaimWebsiteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsClaimWebsiteResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*AccountsCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountsCustomBatchRequestEntry: A batch entry encoding a single non-batch
// accounts request.
type AccountsCustomBatchRequestEntry struct {
	// Account: The account to create or update. Only defined if the method is
	// `insert` or `update`.
	Account *Account `json:"account,omitempty"`
	// AccountId: The ID of the targeted account. Only defined if the method is not
	// `insert`.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// Force: Whether the account should be deleted if the account has offers. Only
	// applicable if the method is `delete`.
	Force bool `json:"force,omitempty"`
	// LabelIds: Label IDs for the 'updatelabels' request.
	LabelIds googleapi.Uint64s `json:"labelIds,omitempty"`
	// LinkRequest: Details about the `link` request.
	LinkRequest *AccountsCustomBatchRequestEntryLinkRequest `json:"linkRequest,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: -
	// "claimWebsite" - "delete" - "get" - "insert" - "link" - "update"
	Method string `json:"method,omitempty"`
	// Overwrite: Only applicable if the method is `claimwebsite`. Indicates
	// whether or not to take the claim from another account in case there is a
	// conflict.
	Overwrite bool `json:"overwrite,omitempty"`
	// View: Controls which fields are visible. Only applicable if the method is
	// 'get'.
	View string `json:"view,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsCustomBatchRequestEntryLinkRequest struct {
	// Action: Action to perform for this link. The "request" action is only
	// available to select merchants. Acceptable values are: - "approve" -
	// "remove" - "request"
	Action string `json:"action,omitempty"`
	// LinkType: Type of the link between the two accounts. Acceptable values are:
	// - "channelPartner" - "eCommercePlatform" - "paymentServiceProvider" -
	// "localProductManager"
	LinkType string `json:"linkType,omitempty"`
	// LinkedAccountId: The ID of the linked account.
	LinkedAccountId string `json:"linkedAccountId,omitempty"`
	// Services: Provided services. Acceptable values are: -
	// "shoppingAdsProductManagement" - "shoppingActionsProductManagement" -
	// "shoppingActionsOrderManagement" - "paymentProcessing" -
	// "localProductManagement"
	Services []string `json:"services,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsCustomBatchRequestEntryLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchRequestEntryLinkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*AccountsCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountsCustomBatchResponseEntry: A batch entry encoding a single non-batch
// accounts response.
type AccountsCustomBatchResponseEntry struct {
	// Account: The retrieved, created, or updated account. Not defined if the
	// method was `delete`, `claimwebsite` or `link`.
	Account *Account `json:"account,omitempty"`
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountsCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsLinkRequest struct {
	// Action: Action to perform for this link. The "request" action is only
	// available to select merchants. Acceptable values are: - "approve" -
	// "remove" - "request"
	Action string `json:"action,omitempty"`
	// ECommercePlatformLinkInfo: Additional information required for
	// `eCommercePlatform` link type.
	ECommercePlatformLinkInfo *ECommercePlatformLinkInfo `json:"eCommercePlatformLinkInfo,omitempty"`
	// LinkType: Type of the link between the two accounts. Acceptable values are:
	// - "channelPartner" - "eCommercePlatform" - "paymentServiceProvider"
	LinkType string `json:"linkType,omitempty"`
	// LinkedAccountId: The ID of the linked account.
	LinkedAccountId string `json:"linkedAccountId,omitempty"`
	// PaymentServiceProviderLinkInfo: Additional information required for
	// `paymentServiceProvider` link type.
	PaymentServiceProviderLinkInfo *PaymentServiceProviderLinkInfo `json:"paymentServiceProviderLinkInfo,omitempty"`
	// Services:  Acceptable values are: - "shoppingAdsProductManagement" -
	// "shoppingActionsProductManagement" - "shoppingActionsOrderManagement" -
	// "paymentProcessing"
	Services []string `json:"services,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsLinkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsLinkResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountsLinkResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsLinkResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsLinkResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsListLinksResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountsListLinksResponse".
	Kind string `json:"kind,omitempty"`
	// Links: The list of available links.
	Links []*LinkedAccount `json:"links,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of links.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsListLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsListLinksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountsListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of accounts.
	NextPageToken string     `json:"nextPageToken,omitempty"`
	Resources     []*Account `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsUpdateLabelsRequest struct {
	// LabelIds: The IDs of labels that should be assigned to the account.
	LabelIds googleapi.Uint64s `json:"labelIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsUpdateLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsUpdateLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsUpdateLabelsResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountsUpdateLabelsResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountsUpdateLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountsUpdateLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountstatusesCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*AccountstatusesCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountstatusesCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountstatusesCustomBatchRequestEntry: A batch entry encoding a single
// non-batch accountstatuses request.
type AccountstatusesCustomBatchRequestEntry struct {
	// AccountId: The ID of the (sub-)account whose status to get.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// Destinations: If set, only issues for the specified destinations are
	// returned, otherwise only issues for the Shopping destination.
	Destinations []string `json:"destinations,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "get"
	Method string `json:"method,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountstatusesCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountstatusesCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*AccountstatusesCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountstatusesCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountstatusesCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccountstatusesCustomBatchResponseEntry: A batch entry encoding a single
// non-batch accountstatuses response.
type AccountstatusesCustomBatchResponseEntry struct {
	// AccountStatus: The requested account status. Defined if and only if the
	// request was successful.
	AccountStatus *AccountStatus `json:"accountStatus,omitempty"`
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountStatus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountstatusesCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountstatusesListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accountstatusesListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of account
	// statuses.
	NextPageToken string           `json:"nextPageToken,omitempty"`
	Resources     []*AccountStatus `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccountstatusesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccountstatusesListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccounttaxCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*AccounttaxCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccounttaxCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccounttaxCustomBatchRequestEntry: A batch entry encoding a single non-batch
// accounttax request.
type AccounttaxCustomBatchRequestEntry struct {
	// AccountId: The ID of the account for which to get/update account tax
	// settings.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// AccountTax: The account tax settings to update. Only defined if the method
	// is `update`.
	AccountTax *AccountTax `json:"accountTax,omitempty"`
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "get" -
	// "update"
	Method string `json:"method,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccounttaxCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccounttaxCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*AccounttaxCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accounttaxCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccounttaxCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccounttaxCustomBatchResponseEntry: A batch entry encoding a single
// non-batch accounttax response.
type AccounttaxCustomBatchResponseEntry struct {
	// AccountTax: The retrieved or updated account tax settings.
	AccountTax *AccountTax `json:"accountTax,omitempty"`
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accounttaxCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountTax") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountTax") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccounttaxCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccounttaxListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#accounttaxListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of account tax
	// settings.
	NextPageToken string        `json:"nextPageToken,omitempty"`
	Resources     []*AccountTax `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccounttaxListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccounttaxListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Action: An actionable step that can be executed to solve the issue.
type Action struct {
	// BuiltinSimpleAction: Action implemented and performed in (your) third-party
	// application. The application should point the merchant to the place, where
	// they can access the corresponding functionality or provide instructions, if
	// the specific functionality is not available.
	BuiltinSimpleAction *BuiltInSimpleAction `json:"builtinSimpleAction,omitempty"`
	// BuiltinUserInputAction: Action implemented and performed in (your)
	// third-party application. The application needs to show an additional content
	// and input form to the merchant as specified for given action. They can
	// trigger the action only when they provided all required inputs.
	BuiltinUserInputAction *BuiltInUserInputAction `json:"builtinUserInputAction,omitempty"`
	// ButtonLabel: Label of the action button.
	ButtonLabel string `json:"buttonLabel,omitempty"`
	// ExternalAction: Action that is implemented and performed outside of (your)
	// third-party application. The application needs to redirect the merchant to
	// the external location where they can perform the action.
	ExternalAction *ExternalAction `json:"externalAction,omitempty"`
	// IsAvailable: Controlling whether the button is active or disabled. The value
	// is 'false' when the action was already requested or is not available. If the
	// action is not available then a reason will be present. If (your) third-party
	// application shows a disabled button for action that is not available, then
	// it should also show reasons.
	IsAvailable bool `json:"isAvailable,omitempty"`
	// Reasons: List of reasons why the action is not available. The list of
	// reasons is empty if the action is available. If there is only one reason, it
	// can be displayed next to the disabled button. If there are more reasons, all
	// of them should be displayed, for example in a pop-up dialog.
	Reasons []*ActionReason `json:"reasons,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuiltinSimpleAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuiltinSimpleAction") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Action) MarshalJSON() ([]byte, error) {
	type NoMethod Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActionFlow: Flow that can be selected for an action. When merchant selects a
// flow, application should open a dialog with more information and input form.
type ActionFlow struct {
	// DialogButtonLabel: Label for the button to trigger the action from the
	// action dialog. For example: "Request review"
	DialogButtonLabel string `json:"dialogButtonLabel,omitempty"`
	// DialogCallout: Important message to be highlighted in the request dialog.
	// For example: "You can only request a review for disagreeing with this issue
	// once. If it's not approved, you'll need to fix the issue and wait a few days
	// before you can request another review."
	DialogCallout *Callout `json:"dialogCallout,omitempty"`
	// DialogMessage: Message displayed in the request dialog. For example: "Make
	// sure you've fixed all your country-specific issues. If not, you may have to
	// wait 7 days to request another review". There may be an more information to
	// be shown in a tooltip.
	DialogMessage *TextWithTooltip `json:"dialogMessage,omitempty"`
	// DialogTitle: Title of the request dialog. For example: "Before you request a
	// review"
	DialogTitle string `json:"dialogTitle,omitempty"`
	// Id: Not for display but need to be sent back for the selected action flow.
	Id string `json:"id,omitempty"`
	// Inputs: A list of input fields.
	Inputs []*InputField `json:"inputs,omitempty"`
	// Label: Text value describing the intent for the action flow. It can be used
	// as an input label if merchant needs to pick one of multiple flows. For
	// example: "I disagree with the issue"
	Label string `json:"label,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogButtonLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogButtonLabel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActionFlow) MarshalJSON() ([]byte, error) {
	type NoMethod ActionFlow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActionInput: Input provided by the merchant.
type ActionInput struct {
	// ActionFlowId: Required. Id of the selected action flow.
	ActionFlowId string `json:"actionFlowId,omitempty"`
	// InputValues: Required. Values for input fields.
	InputValues []*InputValue `json:"inputValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionFlowId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionFlowId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActionInput) MarshalJSON() ([]byte, error) {
	type NoMethod ActionInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActionReason: A single reason why the action is not available.
type ActionReason struct {
	// Action: Optional. An action that needs to be performed to solve the problem
	// represented by this reason. This action will always be available. Should be
	// rendered as a link or button next to the summarizing message. For example,
	// the review may be available only once merchant configure all required
	// attributes. In such a situation this action can be a link to the form, where
	// they can fill the missing attribute to unblock the main action.
	Action *Action `json:"action,omitempty"`
	// Detail: Detailed explanation of the reason. Should be displayed as a hint if
	// present.
	Detail string `json:"detail,omitempty"`
	// Message: Messages summarizing the reason, why the action is not available.
	// For example: "Review requested on Jan 03. Review requests can take a few
	// days to complete."
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActionReason) MarshalJSON() ([]byte, error) {
	type NoMethod ActionReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Address struct {
	// AdministrativeArea: Required. Top-level administrative subdivision of the
	// country. For example, a state like California ("CA") or a province like
	// Quebec ("QC").
	AdministrativeArea string `json:"administrativeArea,omitempty"`
	// City: Required. City, town or commune. May also include dependent localities
	// or sublocalities (for example, neighborhoods or suburbs).
	City string `json:"city,omitempty"`
	// Country: Required. CLDR country code
	// (https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml) (for
	// example, "US").
	Country string `json:"country,omitempty"`
	// PostalCode: Required. Postal code or ZIP (for example, "94043").
	PostalCode string `json:"postalCode,omitempty"`
	// StreetAddress: Street-level part of the address. Use `\n` to add a second
	// line.
	StreetAddress string `json:"streetAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdministrativeArea") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdministrativeArea") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Address) MarshalJSON() ([]byte, error) {
	type NoMethod Address
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AlternateDisputeResolution: The Alternate Dispute Resolution (ADR) that may
// be available to merchants in some regions. If present, the link should be
// shown on the same page as the list of issues.
type AlternateDisputeResolution struct {
	// Label: The label for the alternate dispute resolution link.
	Label string `json:"label,omitempty"`
	// Uri: The URL pointing to a page, where merchant can request alternative
	// dispute resolution with an external body
	// (https://support.google.com/european-union-digital-services-act-redress-options/answer/13535501).
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Label") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AlternateDisputeResolution) MarshalJSON() ([]byte, error) {
	type NoMethod AlternateDisputeResolution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttributionSettings: Represents attribution settings for conversion sources
// receiving pre-attribution data.
type AttributionSettings struct {
	// AttributionLookbackWindowInDays: Required. Lookback windows (in days) used
	// for attribution in this source. Supported values are 7, 30, 40.
	AttributionLookbackWindowInDays int64 `json:"attributionLookbackWindowInDays,omitempty"`
	// Possible values:
	//   "ATTRIBUTION_MODEL_UNSPECIFIED"
	//   "CROSS_CHANNEL_LAST_CLICK" - Cross-channel Last Click model.
	//   "ADS_PREFERRED_LAST_CLICK" - Ads-preferred Last Click model.
	//   "CROSS_CHANNEL_DATA_DRIVEN" - Cross-channel Data Driven model.
	//   "CROSS_CHANNEL_FIRST_CLICK" - Cross-channel First Click model.
	//   "CROSS_CHANNEL_LINEAR" - Cross-channel Linear model.
	//   "CROSS_CHANNEL_POSITION_BASED" - Cross-channel Position Based model.
	//   "CROSS_CHANNEL_TIME_DECAY" - Cross-channel Time Decay model.
	AttributionModel string `json:"attributionModel,omitempty"`
	// ConversionType: Immutable. Unordered list. List of different conversion
	// types a conversion event can be classified as. A standard "purchase" type
	// will be automatically created if this list is empty at creation time.
	ConversionType []*AttributionSettingsConversionType `json:"conversionType,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AttributionLookbackWindowInDays") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionLookbackWindowInDays")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttributionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AttributionSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttributionSettingsConversionType: Message representing a types of
// conversion events
type AttributionSettingsConversionType struct {
	// IncludeInReporting: Output only. Option indicating if the type should be
	// included in Merchant Center reporting.
	IncludeInReporting bool `json:"includeInReporting,omitempty"`
	// Name: Output only. Conversion event name, as it'll be reported by the
	// client.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeInReporting") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeInReporting") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttributionSettingsConversionType) MarshalJSON() ([]byte, error) {
	type NoMethod AttributionSettingsConversionType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BestSellers: Fields related to the Best sellers reports
// (https://support.google.com/merchants/answer/9488679).
type BestSellers struct {
	// CategoryId: Google product category ID to calculate the ranking for,
	// represented in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436). If a `WHERE`
	// condition on `best_sellers.category_id` is not specified in the query,
	// rankings for all top-level categories are returned.
	CategoryId int64 `json:"categoryId,omitempty,string"`
	// CountryCode: Country where the ranking is calculated. A `WHERE` condition on
	// `best_sellers.country_code` is required in the query.
	CountryCode string `json:"countryCode,omitempty"`
	// PreviousRank: Popularity rank in the previous week or month.
	PreviousRank int64 `json:"previousRank,omitempty,string"`
	// PreviousRelativeDemand: Estimated demand in relation to the item with the
	// highest popularity rank in the same category and country in the previous
	// week or month.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_UNSPECIFIED" - Relative demand is unknown.
	//   "VERY_LOW" - Demand is 0-5% of the demand of the highest ranked product
	// clusters or brands.
	//   "LOW" - Demand is 6-10% of the demand of the highest ranked product
	// clusters or brands.
	//   "MEDIUM" - Demand is 11-20% of the demand of the highest ranked product
	// clusters or brands.
	//   "HIGH" - Demand is 21-50% of the demand of the highest ranked product
	// clusters or brands.
	//   "VERY_HIGH" - Demand is 51-100% of the demand of the highest ranked
	// product clusters or brands.
	PreviousRelativeDemand string `json:"previousRelativeDemand,omitempty"`
	// Rank: Popularity on Shopping ads and free listings, in the selected category
	// and country, based on the estimated number of units sold.
	Rank int64 `json:"rank,omitempty,string"`
	// RelativeDemand: Estimated demand in relation to the item with the highest
	// popularity rank in the same category and country.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_UNSPECIFIED" - Relative demand is unknown.
	//   "VERY_LOW" - Demand is 0-5% of the demand of the highest ranked product
	// clusters or brands.
	//   "LOW" - Demand is 6-10% of the demand of the highest ranked product
	// clusters or brands.
	//   "MEDIUM" - Demand is 11-20% of the demand of the highest ranked product
	// clusters or brands.
	//   "HIGH" - Demand is 21-50% of the demand of the highest ranked product
	// clusters or brands.
	//   "VERY_HIGH" - Demand is 51-100% of the demand of the highest ranked
	// product clusters or brands.
	RelativeDemand string `json:"relativeDemand,omitempty"`
	// RelativeDemandChange: Change in the estimated demand. Whether it rose, sank
	// or remained flat.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_CHANGE_TYPE_UNSPECIFIED" - Relative demand change is
	// unknown.
	//   "SINKER" - Relative demand is lower than previous time period.
	//   "FLAT" - Relative demand is equal to previous time period.
	//   "RISER" - Relative demand is higher than the previous time period.
	RelativeDemandChange string `json:"relativeDemandChange,omitempty"`
	// ReportDate: Report date. The value of this field can only be one of the
	// following: * The first day of the week (Monday) for weekly reports. * The
	// first day of the month for monthly reports. If a `WHERE` condition on
	// `best_sellers.report_date` is not specified in the query, the latest
	// available weekly or monthly report is returned.
	ReportDate *Date `json:"reportDate,omitempty"`
	// ReportGranularity: Granularity of the report. The ranking can be done over a
	// week or a month timeframe. A `WHERE` condition on
	// `best_sellers.report_granularity` is required in the query.
	//
	// Possible values:
	//   "REPORT_GRANULARITY_UNSPECIFIED" - Report granularity is unknown.
	//   "WEEKLY" - Ranking is done over a week timeframe.
	//   "MONTHLY" - Ranking is done over a month timeframe.
	ReportGranularity string `json:"reportGranularity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoryId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BestSellers) MarshalJSON() ([]byte, error) {
	type NoMethod BestSellers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Brand: Brand fields. Values are only set for fields requested explicitly in
// the request's search query.
type Brand struct {
	// Name: Name of the brand.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Brand) MarshalJSON() ([]byte, error) {
	type NoMethod Brand
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Breakdown: A detailed impact breakdown for a group of regions where the
// impact of the issue on different shopping destinations is the same.
type Breakdown struct {
	// Details: Human readable, localized description of issue's effect on
	// different targets. Should be rendered as a list. For example: * "Products
	// not showing in ads" * "Products not showing organically"
	Details []string `json:"details,omitempty"`
	// Regions: Lists of regions. Should be rendered as a title for this group of
	// details. The full list should be shown to merchant. If the list is too long,
	// it is recommended to make it expandable.
	Regions []*BreakdownRegion `json:"regions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Breakdown) MarshalJSON() ([]byte, error) {
	type NoMethod Breakdown
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BreakdownRegion: Region with code and localized name.
type BreakdownRegion struct {
	// Code: The [CLDR territory code]
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	Code string `json:"code,omitempty"`
	// Name: The localized name of the region. For region with code='001' the value
	// is 'All countries' or the equivalent in other languages.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BreakdownRegion) MarshalJSON() ([]byte, error) {
	type NoMethod BreakdownRegion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuiltInSimpleAction: Action that is implemented and performed in (your)
// third-party application. Represents various functionality that is expected
// to be available to merchant and will help them with resolving the issue. The
// application should point the merchant to the place, where they can access
// the corresponding functionality. If the functionality is not supported, it
// is recommended to explain the situation to merchant and provide them with
// instructions how to solve the issue.
type BuiltInSimpleAction struct {
	// AdditionalContent: Long text from an external source that should be
	// available to the merchant. Present when the type is
	// `SHOW_ADDITIONAL_CONTENT`.
	AdditionalContent *BuiltInSimpleActionAdditionalContent `json:"additionalContent,omitempty"`
	// AttributeCode: The attribute that needs to be updated. Present when the type
	// is `EDIT_ITEM_ATTRIBUTE`. This field contains a code for attribute,
	// represented in snake_case. You can find a list of product's attributes, with
	// their codes here (https://support.google.com/merchants/answer/7052112).
	AttributeCode string `json:"attributeCode,omitempty"`
	// Type: The type of action that represents a functionality that is expected to
	// be available in third-party application.
	//
	// Possible values:
	//   "BUILT_IN_SIMPLE_ACTION_TYPE_UNSPECIFIED" - Default value. Will never be
	// provided by the API.
	//   "VERIFY_PHONE" - Redirect merchant to the part of your application where
	// they can verify their phone.
	//   "CLAIM_WEBSITE" - Redirect merchant to the part of your application where
	// they can claim their website.
	//   "ADD_PRODUCTS" - Redirect merchant to the part of your application where
	// they can add products.
	//   "ADD_CONTACT_INFO" - Open a form where the merchant can edit their contact
	// information.
	//   "LINK_ADS_ACCOUNT" - Redirect merchant to the part of your application
	// where they can link ads account.
	//   "ADD_BUSINESS_REGISTRATION_NUMBER" - Open a form where the merchant can
	// add their business registration number.
	//   "EDIT_ITEM_ATTRIBUTE" - Open a form where the merchant can edit an
	// attribute. The attribute that needs to be updated is specified in
	// attribute_code field of the action.
	//   "FIX_ACCOUNT_ISSUE" - Redirect merchant from the product issues to the
	// diagnostic page with their account issues in your application. This action
	// will be returned only for product issues that are caused by an account issue
	// and thus merchant should resolve the problem on the account level.
	//   "SHOW_ADDITIONAL_CONTENT" - Show additional content to the merchant. This
	// action will be used for example to deliver a justification from national
	// authority.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuiltInSimpleAction) MarshalJSON() ([]byte, error) {
	type NoMethod BuiltInSimpleAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuiltInSimpleActionAdditionalContent: Long text from external source.
type BuiltInSimpleActionAdditionalContent struct {
	// Paragraphs: Long text organized into paragraphs.
	Paragraphs []string `json:"paragraphs,omitempty"`
	// Title: Title of the additional content;
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Paragraphs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Paragraphs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuiltInSimpleActionAdditionalContent) MarshalJSON() ([]byte, error) {
	type NoMethod BuiltInSimpleActionAdditionalContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuiltInUserInputAction: Action that is implemented and performed in (your)
// third-party application. The application needs to show an additional content
// and input form to the merchant. They can start the action only when they
// provided all required inputs. The application will request processing of the
// action by calling the triggeraction method
// (https://developers.google.com/shopping-content/reference/rest/v2.1/merchantsupport/triggeraction).
type BuiltInUserInputAction struct {
	// ActionContext: Internal details. Not for display but need to be sent back
	// when triggering the action.
	ActionContext string `json:"actionContext,omitempty"`
	// Flows: Actions may provide multiple different flows. Merchant selects one
	// that fits best to their intent. Selecting the flow is the first step in
	// user's interaction with the action. It affects what input fields will be
	// available and required and also how the request will be processed.
	Flows []*ActionFlow `json:"flows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuiltInUserInputAction) MarshalJSON() ([]byte, error) {
	type NoMethod BuiltInUserInputAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BusinessDayConfig struct {
	// BusinessDays: Regular business days, such as '"monday"'. May not be empty.
	BusinessDays []string `json:"businessDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BusinessDays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BusinessDays") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BusinessDayConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BusinessDayConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Callout: An important message that should be highlighted. Usually displayed
// as a banner.
type Callout struct {
	// FullMessage: A full message that needs to be shown to the merchant.
	FullMessage *TextWithTooltip `json:"fullMessage,omitempty"`
	// StyleHint: Can be used to render messages with different severity in
	// different styles. Snippets off all types contain important information that
	// should be displayed to merchants.
	//
	// Possible values:
	//   "CALLOUT_STYLE_HINT_UNSPECIFIED" - Default value. Will never be provided
	// by the API.
	//   "ERROR" - The most important type of information highlighting problems,
	// like an unsuccessful outcome of previously requested actions.
	//   "WARNING" - Information warning about pending problems, risks or
	// deadlines.
	//   "INFO" - Default severity for important information like pending status of
	// previously requested action or cooldown for re-review.
	StyleHint string `json:"styleHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Callout) MarshalJSON() ([]byte, error) {
	type NoMethod Callout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CarrierRate struct {
	// CarrierName: Carrier service, such as "UPS" or "Fedex". The list of
	// supported carriers can be retrieved through the `getSupportedCarriers`
	// method. Required.
	CarrierName string `json:"carrierName,omitempty"`
	// CarrierService: Carrier service, such as "ground" or "2 days". The list
	// of supported services for a carrier can be retrieved through the
	// `getSupportedCarriers` method. Required.
	CarrierService string `json:"carrierService,omitempty"`
	// FlatAdjustment: Additive shipping rate modifier. Can be negative. For
	// example `{ "value": "1", "currency" : "USD" }` adds $1 to the rate, `{
	// "value": "-3", "currency" : "USD" }` removes $3 from the rate. Optional.
	FlatAdjustment *Price `json:"flatAdjustment,omitempty"`
	// Name: Name of the carrier rate. Must be unique per rate group. Required.
	Name string `json:"name,omitempty"`
	// OriginPostalCode: Shipping origin for this carrier rate. Required.
	OriginPostalCode string `json:"originPostalCode,omitempty"`
	// PercentageAdjustment: Multiplicative shipping rate modifier as a number in
	// decimal notation. Can be negative. For example "5.4" increases the rate by
	// 5.4%, "-3" decreases the rate by 3%. Optional.
	PercentageAdjustment string `json:"percentageAdjustment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CarrierName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CarrierName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CarrierRate) MarshalJSON() ([]byte, error) {
	type NoMethod CarrierRate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CarriersCarrier struct {
	// Country: The CLDR country code of the carrier (for example, "US"). Always
	// present.
	Country string `json:"country,omitempty"`
	// EddServices: A list of services supported for EDD (Estimated Delivery Date)
	// calculation. This is the list of valid values for
	// WarehouseBasedDeliveryTime.carrierService.
	EddServices []string `json:"eddServices,omitempty"`
	// Name: The name of the carrier (for example, "UPS"). Always present.
	Name string `json:"name,omitempty"`
	// Services: A list of supported services (for example, "ground") for that
	// carrier. Contains at least one service. This is the list of valid values for
	// CarrierRate.carrierService.
	Services []string `json:"services,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CarriersCarrier) MarshalJSON() ([]byte, error) {
	type NoMethod CarriersCarrier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckoutSettings: `CheckoutSettings` for a specific merchant ID.
type CheckoutSettings struct {
	// EffectiveEnrollmentState: Output only. The effective value of enrollment
	// state for a given merchant ID. If account level settings are present then
	// this value will be a copy of the account level settings. Otherwise, it will
	// have the value of the parent account.
	//
	// Possible values:
	//   "CHECKOUT_ON_MERCHANT_ENROLLMENT_STATE_UNSPECIFIED" - Default enrollment
	// state when enrollment state is not specified.
	//   "INACTIVE" - Merchant has not enrolled into the feature.
	//   "ENROLLED" - Merchant has enrolled into the feature by providing either an
	// account level URL or checkout URLs as part of their feed.
	//   "OPT_OUT" - Merchant has previously enrolled but opted out of the feature.
	EffectiveEnrollmentState string `json:"effectiveEnrollmentState,omitempty"`
	// EffectiveReviewState: Output only. The effective value of review state for a
	// given merchant ID. If account level settings are present then this value
	// will be a copy of the account level settings. Otherwise, it will have the
	// value of the parent account.
	//
	// Possible values:
	//   "CHECKOUT_ON_MERCHANT_REVIEW_STATE_UNSPECIFIED" - Default review state
	// when review state is not specified.
	//   "IN_REVIEW" - Merchant provided URLs are being reviewed for data quality
	// issues.
	//   "APPROVED" - Merchant account has been approved. Indicates the data
	// quality checks have passed.
	//   "DISAPPROVED" - Merchant account has been disapproved due to data quality
	// issues.
	EffectiveReviewState string `json:"effectiveReviewState,omitempty"`
	// EffectiveUriSettings: The effective value of `url_settings` for a given
	// merchant ID. If account level settings are present then this value will be a
	// copy of the account level settings. Otherwise, it will have the value of the
	// parent account.
	EffectiveUriSettings *UrlSettings `json:"effectiveUriSettings,omitempty"`
	// EnrollmentState: Output only. Reflects the merchant enrollment state in
	// `Checkout` feature.
	//
	// Possible values:
	//   "CHECKOUT_ON_MERCHANT_ENROLLMENT_STATE_UNSPECIFIED" - Default enrollment
	// state when enrollment state is not specified.
	//   "INACTIVE" - Merchant has not enrolled into the feature.
	//   "ENROLLED" - Merchant has enrolled into the feature by providing either an
	// account level URL or checkout URLs as part of their feed.
	//   "OPT_OUT" - Merchant has previously enrolled but opted out of the feature.
	EnrollmentState string `json:"enrollmentState,omitempty"`
	// MerchantId: Required. The ID of the account.
	MerchantId int64 `json:"merchantId,omitempty,string"`
	// ReviewState: Output only. Reflects the merchant review state in `Checkout`
	// feature. This is set based on the data quality reviews of the URL provided
	// by the merchant. A merchant with enrollment state as `ENROLLED` can be in
	// the following review states: `IN_REVIEW`, `APPROVED` or `DISAPPROVED`. A
	// merchant must be in an enrollment_state of `ENROLLED` before a review can
	// begin for the merchant.
	//
	// Possible values:
	//   "CHECKOUT_ON_MERCHANT_REVIEW_STATE_UNSPECIFIED" - Default review state
	// when review state is not specified.
	//   "IN_REVIEW" - Merchant provided URLs are being reviewed for data quality
	// issues.
	//   "APPROVED" - Merchant account has been approved. Indicates the data
	// quality checks have passed.
	//   "DISAPPROVED" - Merchant account has been disapproved due to data quality
	// issues.
	ReviewState string `json:"reviewState,omitempty"`
	// UriSettings: URL settings for cart or checkout URL.
	UriSettings *UrlSettings `json:"uriSettings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EffectiveEnrollmentState")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EffectiveEnrollmentState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckoutSettings) MarshalJSON() ([]byte, error) {
	type NoMethod CheckoutSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudExportAdditionalProperties: Product property for the Cloud Retail API.
// For example, properties for a TV product could be "Screen-Resolution" or
// "Screen-Size".
type CloudExportAdditionalProperties struct {
	// BoolValue: Boolean value of the given property. For example for a TV
	// product, "True" or "False" if the screen is UHD.
	BoolValue bool `json:"boolValue,omitempty"`
	// FloatValue: Float values of the given property. For example for a TV product
	// 1.2345. Maximum number of specified values for this field is 400. Values are
	// stored in an arbitrary but consistent order.
	FloatValue []float64 `json:"floatValue,omitempty"`
	// IntValue: Integer values of the given property. For example, 1080 for a
	// screen resolution of a TV product. Maximum number of specified values for
	// this field is 400. Values are stored in an arbitrary but consistent order.
	IntValue googleapi.Int64s `json:"intValue,omitempty"`
	// MaxValue: Maximum float value of the given property. For example for a TV
	// product 100.00.
	MaxValue float64 `json:"maxValue,omitempty"`
	// MinValue: Minimum float value of the given property. For example for a TV
	// product 1.00.
	MinValue float64 `json:"minValue,omitempty"`
	// PropertyName: Name of the given property. For example, "Screen-Resolution"
	// for a TV product. Maximum string size is 256 characters.
	PropertyName string `json:"propertyName,omitempty"`
	// TextValue: Text value of the given property. For example, "8K(UHD)" could be
	// a text value for a TV product. Maximum number of specified values for this
	// field is 400. Values are stored in an arbitrary but consistent order.
	// Maximum string size is 256 characters.
	TextValue []string `json:"textValue,omitempty"`
	// UnitCode: Unit of the given property. For example, "Pixels" for a TV
	// product. Maximum string size is 256 bytes.
	UnitCode string `json:"unitCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudExportAdditionalProperties) MarshalJSON() ([]byte, error) {
	type NoMethod CloudExportAdditionalProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudExportAdditionalProperties) UnmarshalJSON(data []byte) error {
	type NoMethod CloudExportAdditionalProperties
	var s1 struct {
		FloatValue []gensupport.JSONFloat64 `json:"floatValue"`
		MaxValue   gensupport.JSONFloat64   `json:"maxValue"`
		MinValue   gensupport.JSONFloat64   `json:"minValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = make([]float64, len(s1.FloatValue))
	for i := range s1.FloatValue {
		s.FloatValue[i] = float64(s1.FloatValue[i])
	}
	s.MaxValue = float64(s1.MaxValue)
	s.MinValue = float64(s1.MinValue)
	return nil
}

// Collection: The collection message.
type Collection struct {
	// CustomLabel0: Label that you assign to a collection to help organize bidding
	// and reporting in Shopping campaigns. Custom label
	// (https://support.google.com/merchants/answer/9674217)
	CustomLabel0 string `json:"customLabel0,omitempty"`
	// CustomLabel1: Label that you assign to a collection to help organize bidding
	// and reporting in Shopping campaigns.
	CustomLabel1 string `json:"customLabel1,omitempty"`
	// CustomLabel2: Label that you assign to a collection to help organize bidding
	// and reporting in Shopping campaigns.
	CustomLabel2 string `json:"customLabel2,omitempty"`
	// CustomLabel3: Label that you assign to a collection to help organize bidding
	// and reporting in Shopping campaigns.
	CustomLabel3 string `json:"customLabel3,omitempty"`
	// CustomLabel4: Label that you assign to a collection to help organize bidding
	// and reporting in Shopping campaigns.
	CustomLabel4 string `json:"customLabel4,omitempty"`
	// FeaturedProduct: This identifies one or more products associated with the
	// collection. Used as a lookup to the corresponding product ID in your product
	// feeds. Provide a maximum of 100 featuredProduct (for collections). Provide
	// up to 10 featuredProduct (for Shoppable Images only) with ID and X and Y
	// coordinates. featured_product attribute
	// (https://support.google.com/merchants/answer/9703736)
	FeaturedProduct []*CollectionFeaturedProduct `json:"featuredProduct,omitempty"`
	// Headline: Your collection's name. headline attribute
	// (https://support.google.com/merchants/answer/9673580)
	Headline []string `json:"headline,omitempty"`
	// Id: Required. The REST ID of the collection. Content API methods that
	// operate on collections take this as their collectionId parameter. The REST
	// ID for a collection is of the form collectionId. id attribute
	// (https://support.google.com/merchants/answer/9649290)
	Id string `json:"id,omitempty"`
	// ImageLink: The URL of a collection’s image. image_link attribute
	// (https://support.google.com/merchants/answer/9703236)
	ImageLink []string `json:"imageLink,omitempty"`
	// Language: The language of a collection and the language of any featured
	// products linked to the collection. language attribute
	// (https://support.google.com/merchants/answer/9673781)
	Language string `json:"language,omitempty"`
	// Link: A collection’s landing page. URL directly linking to your
	// collection's page on your website. link attribute
	// (https://support.google.com/merchants/answer/9673983)
	Link string `json:"link,omitempty"`
	// MobileLink: A collection’s mobile-optimized landing page when you have a
	// different URL for mobile and desktop traffic. mobile_link attribute
	// (https://support.google.com/merchants/answer/9646123)
	MobileLink string `json:"mobileLink,omitempty"`
	// ProductCountry: product_country attribute
	// (https://support.google.com/merchants/answer/9674155)
	ProductCountry string `json:"productCountry,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomLabel0") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomLabel0") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Collection) MarshalJSON() ([]byte, error) {
	type NoMethod Collection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CollectionFeaturedProduct: The message for FeaturedProduct. FeaturedProduct
// (https://support.google.com/merchants/answer/9703736)
type CollectionFeaturedProduct struct {
	// OfferId: The unique identifier for the product item.
	OfferId string `json:"offerId,omitempty"`
	// X: Required. X-coordinate of the product callout on the Shoppable Image.
	X float64 `json:"x,omitempty"`
	// Y: Required. Y-coordinate of the product callout on the Shoppable Image.
	Y float64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OfferId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OfferId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CollectionFeaturedProduct) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionFeaturedProduct
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CollectionFeaturedProduct) UnmarshalJSON(data []byte) error {
	type NoMethod CollectionFeaturedProduct
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// CollectionStatus: The collectionstatus message.
type CollectionStatus struct {
	// CollectionLevelIssuses: A list of all issues associated with the collection.
	CollectionLevelIssuses []*CollectionStatusItemLevelIssue `json:"collectionLevelIssuses,omitempty"`
	// CreationDate: Date on which the collection has been created in ISO 8601
	// (http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for
	// example "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
	CreationDate string `json:"creationDate,omitempty"`
	// DestinationStatuses: The intended destinations for the collection.
	DestinationStatuses []*CollectionStatusDestinationStatus `json:"destinationStatuses,omitempty"`
	// Id: Required. The ID of the collection for which status is reported.
	Id string `json:"id,omitempty"`
	// LastUpdateDate: Date on which the collection has been last updated in ISO
	// 8601 (http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset,
	// for example "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
	LastUpdateDate string `json:"lastUpdateDate,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CollectionLevelIssuses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionLevelIssuses") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CollectionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CollectionStatusDestinationStatus: Destination status message.
type CollectionStatusDestinationStatus struct {
	// ApprovedCountries: Country codes (ISO 3166-1 alpha-2) where the collection
	// is approved.
	ApprovedCountries []string `json:"approvedCountries,omitempty"`
	// Destination: The name of the destination
	Destination string `json:"destination,omitempty"`
	// DisapprovedCountries: Country codes (ISO 3166-1 alpha-2) where the
	// collection is disapproved.
	DisapprovedCountries []string `json:"disapprovedCountries,omitempty"`
	// PendingCountries: Country codes (ISO 3166-1 alpha-2) where the collection is
	// pending approval.
	PendingCountries []string `json:"pendingCountries,omitempty"`
	// Status: The status for the specified destination in the collections target
	// country.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApprovedCountries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApprovedCountries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CollectionStatusDestinationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionStatusDestinationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CollectionStatusItemLevelIssue: Issue associated with the collection.
type CollectionStatusItemLevelIssue struct {
	// ApplicableCountries: Country codes (ISO 3166-1 alpha-2) where issue applies
	// to the offer.
	ApplicableCountries []string `json:"applicableCountries,omitempty"`
	// AttributeName: The attribute's name, if the issue is caused by a single
	// attribute.
	AttributeName string `json:"attributeName,omitempty"`
	// Code: The error code of the issue.
	Code string `json:"code,omitempty"`
	// Description: A short issue description in English.
	Description string `json:"description,omitempty"`
	// Destination: The destination the issue applies to.
	Destination string `json:"destination,omitempty"`
	// Detail: A detailed issue description in English.
	Detail string `json:"detail,omitempty"`
	// Documentation: The URL of a web page to help with resolving this issue.
	Documentation string `json:"documentation,omitempty"`
	// Resolution: Whether the issue can be resolved by the merchant.
	Resolution string `json:"resolution,omitempty"`
	// Servability: How this issue affects the serving of the collection.
	Servability string `json:"servability,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicableCountries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicableCountries") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CollectionStatusItemLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionStatusItemLevelIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompetitiveVisibility: Fields related to [competitive visibility reports]
// (https://support.google.com/merchants/answer/11366442).
type CompetitiveVisibility struct {
	// AdsOrganicRatio: [Ads / organic ratio]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cadsfree-ratio)
	// shows how often a merchant receives impressions from Shopping ads compared
	// to organic traffic. The number is rounded and bucketed. Available only in
	// `CompetitiveVisibilityTopMerchantView` and
	// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE'
	// clause.
	AdsOrganicRatio float64 `json:"adsOrganicRatio,omitempty"`
	// CategoryBenchmarkVisibilityTrend: Change in visibility based on impressions
	// with respect to the start of the selected time range (or first day with
	// non-zero impressions) for a combined set of merchants with highest
	// visibility approximating the market. Available only in
	// `CompetitiveVisibilityBenchmarkView`. Cannot be filtered on in the 'WHERE'
	// clause.
	CategoryBenchmarkVisibilityTrend float64 `json:"categoryBenchmarkVisibilityTrend,omitempty"`
	// CategoryId: Google product category ID to calculate the report for,
	// represented in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436). Required in the
	// `SELECT` clause. A `WHERE` condition on `competitive_visibility.category_id`
	// is required in the query.
	CategoryId int64 `json:"categoryId,omitempty,string"`
	// CountryCode: The country where impression appeared. Required in the `SELECT`
	// clause. A `WHERE` condition on `competitive_visibility.country_code` is
	// required in the query.
	CountryCode string `json:"countryCode,omitempty"`
	// Date: Date of this row. Available only in
	// `CompetitiveVisibilityBenchmarkView` and
	// `CompetitiveVisibilityCompetitorView`. Required in the `SELECT` clause for
	// `CompetitiveVisibilityMarketBenchmarkView`.
	Date *Date `json:"date,omitempty"`
	// Domain: Domain of your competitor or your domain, if 'is_your_domain' is
	// true. Available only in `CompetitiveVisibilityTopMerchantView` and
	// `CompetitiveVisibilityCompetitorView`. Required in the `SELECT` clause for
	// `CompetitiveVisibilityTopMerchantView` and
	// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE'
	// clause.
	Domain string `json:"domain,omitempty"`
	// HigherPositionRate: Higher position rate shows how often a competitor’s
	// offer got placed in a higher position on the page than your offer. Available
	// only in `CompetitiveVisibilityTopMerchantView` and
	// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE'
	// clause.
	HigherPositionRate float64 `json:"higherPositionRate,omitempty"`
	// IsYourDomain: True if this row contains data for your domain. Available only
	// in `CompetitiveVisibilityTopMerchantView` and
	// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE'
	// clause.
	IsYourDomain bool `json:"isYourDomain,omitempty"`
	// PageOverlapRate: Page overlap rate describes how frequently competing
	// retailers’ offers are shown together with your offers on the same page.
	// Available only in `CompetitiveVisibilityTopMerchantView` and
	// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE'
	// clause.
	PageOverlapRate float64 `json:"pageOverlapRate,omitempty"`
	// Rank: Position of the domain in the top merchants ranking for the selected
	// keys (`date`, `category_id`, `country_code`, `listing_type`) based on
	// impressions. 1 is the highest. Available only in
	// `CompetitiveVisibilityTopMerchantView` and
	// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE'
	// clause.
	Rank uint64 `json:"rank,omitempty,string"`
	// RelativeVisibility: Relative visibility shows how often your competitors’
	// offers are shown compared to your offers. In other words, this is the number
	// of displayed impressions of a competitor retailer divided by the number of
	// your displayed impressions during a selected time range for a selected
	// product category and country. Available only in
	// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE'
	// clause.
	RelativeVisibility float64 `json:"relativeVisibility,omitempty"`
	// TrafficSource: Type of impression listing. Required in the `SELECT` clause.
	// Cannot be filtered on in the 'WHERE' clause.
	//
	// Possible values:
	//   "UNKNOWN" - Traffic source is unknown.
	//   "ORGANIC" - Organic traffic.
	//   "ADS" - Traffic from Ads.
	//   "ALL" - Organic and Ads traffic.
	TrafficSource string `json:"trafficSource,omitempty"`
	// YourDomainVisibilityTrend: Change in visibility based on impressions for
	// your domain with respect to the start of the selected time range (or first
	// day with non-zero impressions). Available only in
	// `CompetitiveVisibilityBenchmarkView`. Cannot be filtered on in the 'WHERE'
	// clause.
	YourDomainVisibilityTrend float64 `json:"yourDomainVisibilityTrend,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdsOrganicRatio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdsOrganicRatio") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompetitiveVisibility) MarshalJSON() ([]byte, error) {
	type NoMethod CompetitiveVisibility
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CompetitiveVisibility) UnmarshalJSON(data []byte) error {
	type NoMethod CompetitiveVisibility
	var s1 struct {
		AdsOrganicRatio                  gensupport.JSONFloat64 `json:"adsOrganicRatio"`
		CategoryBenchmarkVisibilityTrend gensupport.JSONFloat64 `json:"categoryBenchmarkVisibilityTrend"`
		HigherPositionRate               gensupport.JSONFloat64 `json:"higherPositionRate"`
		PageOverlapRate                  gensupport.JSONFloat64 `json:"pageOverlapRate"`
		RelativeVisibility               gensupport.JSONFloat64 `json:"relativeVisibility"`
		YourDomainVisibilityTrend        gensupport.JSONFloat64 `json:"yourDomainVisibilityTrend"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AdsOrganicRatio = float64(s1.AdsOrganicRatio)
	s.CategoryBenchmarkVisibilityTrend = float64(s1.CategoryBenchmarkVisibilityTrend)
	s.HigherPositionRate = float64(s1.HigherPositionRate)
	s.PageOverlapRate = float64(s1.PageOverlapRate)
	s.RelativeVisibility = float64(s1.RelativeVisibility)
	s.YourDomainVisibilityTrend = float64(s1.YourDomainVisibilityTrend)
	return nil
}

// ConversionSource: Represents a conversion source owned by a Merchant
// account. A merchant account can have up to 200 conversion sources.
type ConversionSource struct {
	// ConversionSourceId: Output only. Generated by the Content API upon creation
	// of a new `ConversionSource`. Format: [a-z]{4}:.+ The four characters before
	// the colon represent the type of conversio source. Content after the colon
	// represents the ID of the conversion source within that type. The ID of two
	// different conversion sources might be the same across different types. The
	// following type prefixes are supported: - galk: For GoogleAnalyticsLink
	// sources. - mcdn: For MerchantCenterDestination sources.
	ConversionSourceId string `json:"conversionSourceId,omitempty"`
	// ExpireTime: Output only. The time when an archived conversion source becomes
	// permanently deleted and is no longer available to undelete.
	ExpireTime string `json:"expireTime,omitempty"`
	// GoogleAnalyticsLink: Immutable. Conversion Source of type "Link to Google
	// Analytics Property".
	GoogleAnalyticsLink *GoogleAnalyticsLink `json:"googleAnalyticsLink,omitempty"`
	// MerchantCenterDestination: Conversion Source of type "Merchant Center Tag
	// Destination".
	MerchantCenterDestination *MerchantCenterDestination `json:"merchantCenterDestination,omitempty"`
	// State: Output only. Current state of this conversion source. Can't be edited
	// through the API.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "ACTIVE" - Conversion source is fully functional.
	//   "ARCHIVED" - Conversion source has been archived in the last 30 days and
	// not currently functional. Can be restored using the undelete method.
	//   "PENDING" - Conversion source creation has started but not fully finished
	// yet.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversionSourceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversionSourceId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConversionSource) MarshalJSON() ([]byte, error) {
	type NoMethod ConversionSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Css: Information about CSS domain.
type Css struct {
	// CssDomainId: Output only. Immutable. The CSS domain ID.
	CssDomainId int64 `json:"cssDomainId,omitempty,string"`
	// CssGroupId: Output only. Immutable. The ID of the CSS group this CSS domain
	// is affiliated with. Only populated for CSS group users.
	CssGroupId int64 `json:"cssGroupId,omitempty,string"`
	// DisplayName: Output only. Immutable. The CSS domain's display name, used
	// when space is constrained.
	DisplayName string `json:"displayName,omitempty"`
	// FullName: Output only. Immutable. The CSS domain's full name.
	FullName string `json:"fullName,omitempty"`
	// HomepageUri: Output only. Immutable. The CSS domain's homepage.
	HomepageUri string `json:"homepageUri,omitempty"`
	// LabelIds: A list of label IDs that are assigned to this CSS domain by its
	// CSS group. Only populated for CSS group users.
	LabelIds googleapi.Int64s `json:"labelIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CssDomainId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CssDomainId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Css) MarshalJSON() ([]byte, error) {
	type NoMethod Css
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomAttribute: A message that represents custom attributes. Exactly one of
// `value` or `groupValues` must be provided. Maximum allowed number of
// characters for each custom attribute is 10240 (represents sum of characters
// for name and value). Maximum 2500 custom attributes can be set per merchant,
// with total size of 102.4kB.
type CustomAttribute struct {
	// GroupValues: Subattributes within this attribute group. Exactly one of value
	// or groupValues must be provided.
	GroupValues []*CustomAttribute `json:"groupValues,omitempty"`
	// Name: The name of the attribute. Underscores will be replaced by spaces upon
	// insertion.
	Name string `json:"name,omitempty"`
	// Value: The value of the attribute.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod CustomAttribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CutoffTime struct {
	// Hour: Hour of the cutoff time until which an order has to be placed to be
	// processed in the same day. Required.
	Hour int64 `json:"hour,omitempty"`
	// Minute: Minute of the cutoff time until which an order has to be placed to
	// be processed in the same day. Required.
	Minute int64 `json:"minute,omitempty"`
	// Timezone: Timezone identifier for the cutoff time (for example,
	// "Europe/Zurich"). List of identifiers. Required.
	Timezone string `json:"timezone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hour") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hour") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CutoffTime) MarshalJSON() ([]byte, error) {
	type NoMethod CutoffTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Datafeed: Datafeed configuration data.
type Datafeed struct {
	// AttributeLanguage: The two-letter ISO 639-1 language in which the attributes
	// are defined in the data feed.
	AttributeLanguage string `json:"attributeLanguage,omitempty"`
	// ContentType: Required. The type of data feed. For product inventory feeds,
	// only feeds for local stores, not online stores, are supported. Acceptable
	// values are: - "local products" - "product inventory" - "products"
	ContentType string `json:"contentType,omitempty"`
	// FetchSchedule: Fetch schedule for the feed file.
	FetchSchedule *DatafeedFetchSchedule `json:"fetchSchedule,omitempty"`
	// FileName: Required. The filename of the feed. All feeds must have a unique
	// file name.
	FileName string `json:"fileName,omitempty"`
	// Format: Format of the feed file.
	Format *DatafeedFormat `json:"format,omitempty"`
	// Id: Required for update. The ID of the data feed.
	Id int64 `json:"id,omitempty,string"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#datafeed"
	Kind string `json:"kind,omitempty"`
	// Name: Required for insert. A descriptive name of the data feed.
	Name string `json:"name,omitempty"`
	// Targets: The targets this feed should apply to (country, language,
	// destinations).
	Targets []*DatafeedTarget `json:"targets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributeLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Datafeed) MarshalJSON() ([]byte, error) {
	type NoMethod Datafeed
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatafeedFetchSchedule: The required fields vary based on the frequency of
// fetching. For a monthly fetch schedule, day_of_month and hour are required.
// For a weekly fetch schedule, weekday and hour are required. For a daily
// fetch schedule, only hour is required.
type DatafeedFetchSchedule struct {
	// DayOfMonth: The day of the month the feed file should be fetched (1-31).
	DayOfMonth int64 `json:"dayOfMonth,omitempty"`
	// FetchUrl: The URL where the feed file can be fetched. Google Merchant Center
	// will support automatic scheduled uploads using the HTTP, HTTPS, FTP, or SFTP
	// protocols, so the value will need to be a valid link using one of those four
	// protocols.
	FetchUrl string `json:"fetchUrl,omitempty"`
	// Hour: The hour of the day the feed file should be fetched (0-23).
	Hour int64 `json:"hour,omitempty"`
	// MinuteOfHour: The minute of the hour the feed file should be fetched (0-59).
	// Read-only.
	MinuteOfHour int64 `json:"minuteOfHour,omitempty"`
	// Password: An optional password for fetch_url.
	Password string `json:"password,omitempty"`
	// Paused: Whether the scheduled fetch is paused or not.
	Paused bool `json:"paused,omitempty"`
	// TimeZone: Time zone used for schedule. UTC by default. For example,
	// "America/Los_Angeles".
	TimeZone string `json:"timeZone,omitempty"`
	// Username: An optional user name for fetch_url.
	Username string `json:"username,omitempty"`
	// Weekday: The day of the week the feed file should be fetched. Acceptable
	// values are: - "monday" - "tuesday" - "wednesday" - "thursday" -
	// "friday" - "saturday" - "sunday"
	Weekday string `json:"weekday,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DayOfMonth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DayOfMonth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedFetchSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedFetchSchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedFormat struct {
	// ColumnDelimiter: Delimiter for the separation of values in a
	// delimiter-separated values feed. If not specified, the delimiter will be
	// auto-detected. Ignored for non-DSV data feeds. Acceptable values are: -
	// "pipe" - "tab" - "tilde"
	ColumnDelimiter string `json:"columnDelimiter,omitempty"`
	// FileEncoding: Character encoding scheme of the data feed. If not specified,
	// the encoding will be auto-detected. Acceptable values are: - "latin-1" -
	// "utf-16be" - "utf-16le" - "utf-8" - "windows-1252"
	FileEncoding string `json:"fileEncoding,omitempty"`
	// QuotingMode: Specifies how double quotes are interpreted. If not specified,
	// the mode will be auto-detected. Ignored for non-DSV data feeds. Acceptable
	// values are: - "normal character" - "value quoting"
	QuotingMode string `json:"quotingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColumnDelimiter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColumnDelimiter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedFormat) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedFormat
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatafeedStatus: The status of a datafeed, that is, the result of the last
// retrieval of the datafeed computed asynchronously when the feed processing
// is finished.
type DatafeedStatus struct {
	// Country: The country for which the status is reported, represented as a CLDR
	// territory code.
	Country string `json:"country,omitempty"`
	// DatafeedId: The ID of the feed for which the status is reported.
	DatafeedId uint64 `json:"datafeedId,omitempty,string"`
	// Errors: The list of errors occurring in the feed.
	Errors []*DatafeedStatusError `json:"errors,omitempty"`
	// FeedLabel: The feed label status is reported for.
	FeedLabel string `json:"feedLabel,omitempty"`
	// ItemsTotal: The number of items in the feed that were processed.
	ItemsTotal uint64 `json:"itemsTotal,omitempty,string"`
	// ItemsValid: The number of items in the feed that were valid.
	ItemsValid uint64 `json:"itemsValid,omitempty,string"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#datafeedStatus"
	Kind string `json:"kind,omitempty"`
	// Language: The two-letter ISO 639-1 language for which the status is
	// reported.
	Language string `json:"language,omitempty"`
	// LastUploadDate: The last date at which the feed was uploaded.
	LastUploadDate string `json:"lastUploadDate,omitempty"`
	// ProcessingStatus: The processing status of the feed. Acceptable values are:
	// - ""failure": The feed could not be processed or all items had errors."
	// - "in progress": The feed is being processed. - "none": The feed has not
	// yet been processed. For example, a feed that has never been uploaded will
	// have this processing status. - "success": The feed was processed
	// successfully, though some items might have had errors.
	ProcessingStatus string `json:"processingStatus,omitempty"`
	// Warnings: The list of errors occurring in the feed.
	Warnings []*DatafeedStatusError `json:"warnings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatafeedStatusError: An error occurring in the feed, like "invalid price".
type DatafeedStatusError struct {
	// Code: The code of the error, for example, "validation/invalid_value".
	Code string `json:"code,omitempty"`
	// Count: The number of occurrences of the error in the feed.
	Count uint64 `json:"count,omitempty,string"`
	// Examples: A list of example occurrences of the error, grouped by product.
	Examples []*DatafeedStatusExample `json:"examples,omitempty"`
	// Message: The error message, for example, "Invalid price".
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedStatusError) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedStatusError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatafeedStatusExample: An example occurrence for a particular error.
type DatafeedStatusExample struct {
	// ItemId: The ID of the example item.
	ItemId string `json:"itemId,omitempty"`
	// LineNumber: Line number in the data feed where the example is found.
	LineNumber uint64 `json:"lineNumber,omitempty,string"`
	// Value: The problematic value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ItemId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ItemId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedStatusExample) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedStatusExample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedTarget struct {
	// Country: Deprecated. Use `feedLabel` instead. The country where the items in
	// the feed will be included in the search index, represented as a CLDR
	// territory code.
	Country string `json:"country,omitempty"`
	// ExcludedDestinations: The list of destinations to exclude
	// (//support.google.com/merchants/answer/6324486) for this target (corresponds
	// to cleared check boxes in Merchant Center). Products that are excluded from
	// all destinations for more than 7 days are automatically deleted.
	ExcludedDestinations []string `json:"excludedDestinations,omitempty"`
	// FeedLabel: Feed label for the DatafeedTarget. Either `country` or
	// `feedLabel` is required. If both `feedLabel` and `country` is specified, the
	// values must match. Must be less than or equal to 20 uppercase letters (A-Z),
	// numbers (0-9), and dashes (-).
	FeedLabel string `json:"feedLabel,omitempty"`
	// IncludedDestinations: The list of destinations to include
	// (//support.google.com/merchants/answer/7501026) for this target (corresponds
	// to checked check boxes in Merchant Center). Default destinations are always
	// included unless provided in `excludedDestinations`.
	IncludedDestinations []string `json:"includedDestinations,omitempty"`
	// Language: The two-letter ISO 639-1 language of the items in the feed. Must
	// be a valid language for `targets[].country`.
	Language string `json:"language,omitempty"`
	// TargetCountries: The countries where the items may be displayed. Represented
	// as a CLDR territory code. Will be ignored for "product inventory" feeds.
	TargetCountries []string `json:"targetCountries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedTarget) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*DatafeedsCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatafeedsCustomBatchRequestEntry: A batch entry encoding a single non-batch
// datafeeds request.
type DatafeedsCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// Datafeed: The data feed to insert.
	Datafeed *Datafeed `json:"datafeed,omitempty"`
	// DatafeedId: The ID of the data feed to get, delete or fetch.
	DatafeedId uint64 `json:"datafeedId,omitempty,string"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "delete" -
	// "fetchNow" - "get" - "insert" - "update"
	Method string `json:"method,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*DatafeedsCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#datafeedsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatafeedsCustomBatchResponseEntry: A batch entry encoding a single non-batch
// datafeeds response.
type DatafeedsCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// Datafeed: The requested data feed. Defined if and only if the request was
	// successful.
	Datafeed *Datafeed `json:"datafeed,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedsFetchNowResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#datafeedsFetchNowResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedsFetchNowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsFetchNowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#datafeedsListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of datafeeds.
	NextPageToken string      `json:"nextPageToken,omitempty"`
	Resources     []*Datafeed `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedstatusesCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*DatafeedstatusesCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedstatusesCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatafeedstatusesCustomBatchRequestEntry: A batch entry encoding a single
// non-batch datafeedstatuses request.
type DatafeedstatusesCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// Country: Deprecated. Use `feedLabel` instead. The country to get the
	// datafeed status for. If this parameter is provided, then `language` must
	// also be provided. Note that for multi-target datafeeds this parameter is
	// required.
	Country string `json:"country,omitempty"`
	// DatafeedId: The ID of the data feed to get.
	DatafeedId uint64 `json:"datafeedId,omitempty,string"`
	// FeedLabel: The feed label to get the datafeed status for. If this parameter
	// is provided, then `language` must also be provided. Note that for
	// multi-target datafeeds this parameter is required.
	FeedLabel string `json:"feedLabel,omitempty"`
	// Language: The language to get the datafeed status for. If this parameter is
	// provided then `country` must also be provided. Note that for multi-target
	// datafeeds this parameter is required.
	Language string `json:"language,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "get"
	Method string `json:"method,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedstatusesCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedstatusesCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*DatafeedstatusesCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#datafeedstatusesCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedstatusesCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatafeedstatusesCustomBatchResponseEntry: A batch entry encoding a single
// non-batch datafeedstatuses response.
type DatafeedstatusesCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// DatafeedStatus: The requested data feed status. Defined if and only if the
	// request was successful.
	DatafeedStatus *DatafeedStatus `json:"datafeedStatus,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedstatusesCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatafeedstatusesListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#datafeedstatusesListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of datafeed
	// statuses.
	NextPageToken string            `json:"nextPageToken,omitempty"`
	Resources     []*DatafeedStatus `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatafeedstatusesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatafeedstatusesListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DateTime: Represents civil time (or occasionally physical time). This type
// can represent a civil time in one of a few possible ways: * When utc_offset
// is set and time_zone is unset: a civil time on a calendar day with a
// particular offset from UTC. * When time_zone is set and utc_offset is unset:
// a civil time on a calendar day in a particular time zone. * When neither
// time_zone nor utc_offset is set: a civil time on a calendar day in local
// time. The date is relative to the Proleptic Gregorian Calendar. If year,
// month, or day are 0, the DateTime is considered not to have a specific year,
// month, or day respectively. This type may also be used to represent a
// physical time if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for physical
// time instead. If your use case also would like to store the user's timezone,
// that can be done in another field. This type is more flexible than some
// applications may want. Make sure to document and validate your application's
// limitations.
type DateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the year and
	// month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`
	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23,
	// defaults to 0 (midnight). An API may choose to allow the value "24:00:00"
	// for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults to
	// 0.
	Minutes int64 `json:"minutes,omitempty"`
	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a
	// datetime without a month.
	Month int64 `json:"month,omitempty"`
	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to
	// 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Optional. Seconds of minutes of the time. Must normally be from 0
	// to 59, defaults to 0. An API may allow the value 60 if it allows
	// leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// TimeZone: Time zone.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and +18
	// hours. For example, a UTC offset of -4:00 would be represented as { seconds:
	// -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`
	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
	// datetime without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DateTime) MarshalJSON() ([]byte, error) {
	type NoMethod DateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeliveryArea: A delivery area for the product. Only one of `countryCode` or
// `postalCodeRange` must be set.
type DeliveryArea struct {
	// CountryCode: Required. The country that the product can be delivered to.
	// Submit a unicode CLDR region
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) such as
	// `US` or `CH`.
	CountryCode string `json:"countryCode,omitempty"`
	// PostalCodeRange: A postal code, postal code range or postal code prefix that
	// defines this area. Limited to US and AUS.
	PostalCodeRange *DeliveryAreaPostalCodeRange `json:"postalCodeRange,omitempty"`
	// RegionCode: A state, territory, or prefecture. This is supported for the
	// United States, Australia, and Japan. Provide a subdivision code from the ISO
	// 3166-2 code tables (US (https://en.wikipedia.org/wiki/ISO_3166-2:US), AU
	// (https://en.wikipedia.org/wiki/ISO_3166-2:AU), or JP
	// (https://en.wikipedia.org/wiki/ISO_3166-2:JP)) without country prefix (for
	// example, "NY", "NSW", "03").
	RegionCode string `json:"regionCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CountryCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CountryCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeliveryArea) MarshalJSON() ([]byte, error) {
	type NoMethod DeliveryArea
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeliveryAreaPostalCodeRange: A range of postal codes that defines the
// delivery area. Only set `firstPostalCode` when specifying a single postal
// code.
type DeliveryAreaPostalCodeRange struct {
	// FirstPostalCode: Required. A postal code or a pattern of the form prefix*
	// denoting the inclusive lower bound of the range defining the area. Examples
	// values: "94108", "9410*", "9*".
	FirstPostalCode string `json:"firstPostalCode,omitempty"`
	// LastPostalCode: A postal code or a pattern of the form prefix* denoting the
	// inclusive upper bound of the range defining the area (for example [070* -
	// 078*] results in the range [07000 - 07899]). It must have the same length as
	// `firstPostalCode`: if `firstPostalCode` is a postal code then
	// `lastPostalCode` must be a postal code too; if firstPostalCode is a pattern
	// then `lastPostalCode` must be a pattern with the same prefix length. Ignored
	// if not set, then the area is defined as being all the postal codes matching
	// `firstPostalCode`.
	LastPostalCode string `json:"lastPostalCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FirstPostalCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirstPostalCode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeliveryAreaPostalCodeRange) MarshalJSON() ([]byte, error) {
	type NoMethod DeliveryAreaPostalCodeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DeliveryTime struct {
	// CutoffTime: Business days cutoff time definition. If not configured, the
	// cutoff time will be defaulted to 8AM PST. If local delivery, use
	// Service.StoreConfig.CutoffConfig.
	CutoffTime *CutoffTime `json:"cutoffTime,omitempty"`
	// HandlingBusinessDayConfig: The business days during which orders can be
	// handled. If not provided, Monday to Friday business days will be assumed.
	HandlingBusinessDayConfig *BusinessDayConfig `json:"handlingBusinessDayConfig,omitempty"`
	// HolidayCutoffs: Holiday cutoff definitions. If configured, they specify
	// order cutoff times for holiday-specific shipping.
	HolidayCutoffs []*HolidayCutoff `json:"holidayCutoffs,omitempty"`
	// MaxHandlingTimeInDays: Maximum number of business days spent before an order
	// is shipped. 0 means same day shipped, 1 means next day shipped. Must be
	// greater than or equal to `minHandlingTimeInDays`.
	MaxHandlingTimeInDays int64 `json:"maxHandlingTimeInDays,omitempty"`
	// MaxTransitTimeInDays: Maximum number of business days that are spent in
	// transit. 0 means same day delivery, 1 means next day delivery. Must be
	// greater than or equal to `minTransitTimeInDays`.
	MaxTransitTimeInDays int64 `json:"maxTransitTimeInDays,omitempty"`
	// MinHandlingTimeInDays: Minimum number of business days spent before an order
	// is shipped. 0 means same day shipped, 1 means next day shipped.
	MinHandlingTimeInDays int64 `json:"minHandlingTimeInDays,omitempty"`
	// MinTransitTimeInDays: Minimum number of business days that are spent in
	// transit. 0 means same day delivery, 1 means next day delivery. Either
	// `{min,max}TransitTimeInDays` or `transitTimeTable` must be set, but not
	// both.
	MinTransitTimeInDays int64 `json:"minTransitTimeInDays,omitempty"`
	// TransitBusinessDayConfig: The business days during which orders can be
	// in-transit. If not provided, Monday to Friday business days will be assumed.
	TransitBusinessDayConfig *BusinessDayConfig `json:"transitBusinessDayConfig,omitempty"`
	// TransitTimeTable: Transit time table, number of business days spent in
	// transit based on row and column dimensions. Either
	// `{min,max}TransitTimeInDays` or `transitTimeTable` can be set, but not both.
	TransitTimeTable *TransitTable `json:"transitTimeTable,omitempty"`
	// WarehouseBasedDeliveryTimes: Indicates that the delivery time should be
	// calculated per warehouse (shipping origin location) based on the settings of
	// the selected carrier. When set, no other transit time related field in
	// DeliveryTime should be set.
	WarehouseBasedDeliveryTimes []*WarehouseBasedDeliveryTime `json:"warehouseBasedDeliveryTimes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CutoffTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CutoffTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeliveryTime) MarshalJSON() ([]byte, error) {
	type NoMethod DeliveryTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Distance: Distance represented by an integer and unit.
type Distance struct {
	// Unit: The distance unit. Acceptable values are `None`, `Miles`, and
	// `Kilometers`.
	Unit string `json:"unit,omitempty"`
	// Value: The distance represented as a number.
	Value int64 `json:"value,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Distance) MarshalJSON() ([]byte, error) {
	type NoMethod Distance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ECommercePlatformLinkInfo: Additional information required for
// E_COMMERCE_PLATFORM link type.
type ECommercePlatformLinkInfo struct {
	// ExternalAccountId: The id used by the third party service provider to
	// identify the merchant.
	ExternalAccountId string `json:"externalAccountId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExternalAccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalAccountId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ECommercePlatformLinkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ECommercePlatformLinkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Error: An error returned by the API.
type Error struct {
	// Domain: The domain of the error.
	Domain string `json:"domain,omitempty"`
	// Message: A description of the error.
	Message string `json:"message,omitempty"`
	// Reason: The error code.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Error) MarshalJSON() ([]byte, error) {
	type NoMethod Error
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Errors: A list of errors returned by a failed batch entry.
type Errors struct {
	// Code: The HTTP status of the first error in `errors`.
	Code int64 `json:"code,omitempty"`
	// Errors: A list of errors.
	Errors []*Error `json:"errors,omitempty"`
	// Message: The message of the first error in `errors`.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Errors) MarshalJSON() ([]byte, error) {
	type NoMethod Errors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExternalAction: Action that is implemented and performed outside of the
// third-party application. It should redirect the merchant to the provided URL
// of an external system where they can perform the action. For example to
// request a review in the Merchant Center.
type ExternalAction struct {
	// Type: The type of external action.
	//
	// Possible values:
	//   "EXTERNAL_ACTION_TYPE_UNSPECIFIED" - Default value. Will never be provided
	// by the API.
	//   "REVIEW_PRODUCT_ISSUE_IN_MERCHANT_CENTER" - Redirect to Merchant Center
	// where the merchant can request a review for issue related to their product.
	//   "REVIEW_ACCOUNT_ISSUE_IN_MERCHANT_CENTER" - Redirect to Merchant Center
	// where the merchant can request a review for issue related to their account.
	//   "LEGAL_APPEAL_IN_HELP_CENTER" - Redirect to the form in Help Center where
	// the merchant can request a legal appeal for the issue.
	//   "VERIFY_IDENTITY_IN_MERCHANT_CENTER" - Redirect to Merchant Center where
	// the merchant can perform identity verification.
	Type string `json:"type,omitempty"`
	// Uri: URL to external system, for example Merchant Center, where the merchant
	// can perform the action.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalAction) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FreeListingsProgramStatus: Response message for
// GetFreeListingsProgramStatus.
type FreeListingsProgramStatus struct {
	// GlobalState: State of the program. `ENABLED` if there are offers for at
	// least one region.
	//
	// Possible values:
	//   "PROGRAM_STATE_UNSPECIFIED" - State is unknown.
	//   "NOT_ENABLED" - Program is not enabled for any country.
	//   "NO_OFFERS_UPLOADED" - No products have been uploaded for any region.
	// Upload products to Merchant Center.
	//   "ENABLED" - Program is enabled and offers are uploaded for at least one
	// country.
	GlobalState string `json:"globalState,omitempty"`
	// RegionStatuses: Status of the program in each region. Regions with the same
	// status and review eligibility are grouped together in `regionCodes`.
	RegionStatuses []*FreeListingsProgramStatusRegionStatus `json:"regionStatuses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GlobalState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FreeListingsProgramStatus) MarshalJSON() ([]byte, error) {
	type NoMethod FreeListingsProgramStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FreeListingsProgramStatusRegionStatus: Status of program and region.
type FreeListingsProgramStatusRegionStatus struct {
	// DisapprovalDate: Date by which eligibilityStatus will go from `WARNING` to
	// `DISAPPROVED`. Only visible when your eligibilityStatus is WARNING. In ISO
	// 8601 (https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DD`.
	DisapprovalDate string `json:"disapprovalDate,omitempty"`
	// EligibilityStatus: Eligibility status of the standard free listing program.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not known.
	//   "APPROVED" - If the account has no issues and review is completed
	// successfully.
	//   "DISAPPROVED" - There are one or more issues that needs to be resolved for
	// account to be active for the program. Detailed list of account issues are
	// available in
	// [accountstatuses](https://developers.google.com/shopping-content/reference/re
	// st/v2.1/accountstatuses) API.
	//   "WARNING" - If account has issues but offers are servable. Some of the
	// issue can make account DISAPPROVED after a certain deadline.
	//   "UNDER_REVIEW" - Account is under review.
	//   "PENDING_REVIEW" - Account is waiting for review to start.
	//   "ONBOARDING" - Program is currently onboarding. Upload valid offers to
	// complete onboarding.
	EligibilityStatus string `json:"eligibilityStatus,omitempty"`
	// OnboardingIssues: Issues that must be fixed to be eligible for review.
	OnboardingIssues []string `json:"onboardingIssues,omitempty"`
	// RegionCodes: The two-letter ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) codes for all the regions
	// with the same `eligibilityStatus` and `reviewEligibility`.
	RegionCodes []string `json:"regionCodes,omitempty"`
	// ReviewEligibilityStatus: If a program is eligible for review in a specific
	// region. Only visible if `eligibilityStatus` is `DISAPPROVED`.
	//
	// Possible values:
	//   "REVIEW_ELIGIBILITY_UNSPECIFIED" - Review eligibility state is unknown.
	//   "ELIGIBLE" - Account is eligible for review for a specified region code.
	//   "INELIGIBLE" - Account is not eligible for review for a specified region
	// code.
	ReviewEligibilityStatus string `json:"reviewEligibilityStatus,omitempty"`
	// ReviewIneligibilityReason: Review ineligibility reason if account is not
	// eligible for review.
	//
	// Possible values:
	//   "REVIEW_INELIGIBILITY_REASON_UNSPECIFIED" - Requesting a review from
	// Google is not possible.
	//   "ONBOARDING_ISSUES" - All onboarding issues needs to be fixed.
	//   "NOT_ENOUGH_OFFERS" - Not enough offers uploaded for this country.
	//   "IN_COOLDOWN_PERIOD" - Cooldown period applies. Wait until cooldown period
	// ends.
	//   "ALREADY_UNDER_REVIEW" - Account is already under review.
	//   "NO_REVIEW_REQUIRED" - No issues available to review.
	//   "WILL_BE_REVIEWED_AUTOMATICALLY" - Account will be automatically reviewed
	// at the end of the grace period.
	//   "IS_RETIRED" - Account is retired. Should not appear in MC.
	//   "ALREADY_REVIEWED" - Account has already been reviewed. You can't request
	// further reviews.
	ReviewIneligibilityReason string `json:"reviewIneligibilityReason,omitempty"`
	// ReviewIneligibilityReasonDescription: Reason a program in a specific region
	// isn’t eligible for review. Only visible if `reviewEligibilityStatus` is
	// `INELIGIBLE`.
	ReviewIneligibilityReasonDescription string `json:"reviewIneligibilityReasonDescription,omitempty"`
	// ReviewIneligibilityReasonDetails: Additional information for ineligibility.
	// If `reviewIneligibilityReason` is `IN_COOLDOWN_PERIOD`, a timestamp for the
	// end of the cooldown period is provided.
	ReviewIneligibilityReasonDetails *FreeListingsProgramStatusReviewIneligibilityReasonDetails `json:"reviewIneligibilityReasonDetails,omitempty"`
	// ReviewIssues: Issues evaluated in the review process. Fix all issues before
	// requesting a review.
	ReviewIssues []string `json:"reviewIssues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisapprovalDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisapprovalDate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FreeListingsProgramStatusRegionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod FreeListingsProgramStatusRegionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FreeListingsProgramStatusReviewIneligibilityReasonDetails: Additional
// details for review ineligibility reasons.
type FreeListingsProgramStatusReviewIneligibilityReasonDetails struct {
	// CooldownTime: This timestamp represents end of cooldown period for review
	// ineligbility reason `IN_COOLDOWN_PERIOD`.
	CooldownTime string `json:"cooldownTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CooldownTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CooldownTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FreeListingsProgramStatusReviewIneligibilityReasonDetails) MarshalJSON() ([]byte, error) {
	type NoMethod FreeListingsProgramStatusReviewIneligibilityReasonDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FreeShippingThreshold: Conditions to be met for a product to have free
// shipping.
type FreeShippingThreshold struct {
	// Country: Required. The CLDR territory code
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) of the
	// country to which an item will ship.
	Country string `json:"country,omitempty"`
	// PriceThreshold: Required. The minimum product price for the shipping cost to
	// become free. Represented as a number.
	PriceThreshold *Price `json:"priceThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FreeShippingThreshold) MarshalJSON() ([]byte, error) {
	type NoMethod FreeShippingThreshold
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateRecommendationsResponse: Response containing generated
// recommendations.
type GenerateRecommendationsResponse struct {
	// Recommendations: Recommendations generated for a request.
	Recommendations []*Recommendation `json:"recommendations,omitempty"`
	// ResponseToken: Output only. Response token is a string created for each
	// `GenerateRecommendationsResponse`. This token doesn't expire, and is
	// globally unique. This token must be used when reporting interactions for
	// recommendations.
	ResponseToken string `json:"responseToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Recommendations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Recommendations") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateRecommendationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateRecommendationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GmbAccounts struct {
	// AccountId: The ID of the Merchant Center account.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// GmbAccounts: A list of Business Profiles which are available to the
	// merchant.
	GmbAccounts []*GmbAccountsGmbAccount `json:"gmbAccounts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GmbAccounts) MarshalJSON() ([]byte, error) {
	type NoMethod GmbAccounts
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GmbAccountsGmbAccount struct {
	// Email: The email which identifies the Business Profile.
	Email string `json:"email,omitempty"`
	// ListingCount: Number of listings under this account.
	ListingCount uint64 `json:"listingCount,omitempty,string"`
	// Name: The name of the Business Profile.
	Name string `json:"name,omitempty"`
	// Type: The type of the Business Profile (User or Business).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GmbAccountsGmbAccount) MarshalJSON() ([]byte, error) {
	type NoMethod GmbAccountsGmbAccount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsLink: "Google Analytics Link" sources can be used to get
// conversion data from an existing Google Analytics property into the linked
// Merchant Center account.
type GoogleAnalyticsLink struct {
	// AttributionSettings: Output only. Attribution settings for the linked Google
	// Analytics property.
	AttributionSettings *AttributionSettings `json:"attributionSettings,omitempty"`
	// PropertyId: Required. Immutable. ID of the Google Analytics property the
	// merchant is linked to.
	PropertyId int64 `json:"propertyId,omitempty,string"`
	// PropertyName: Output only. Name of the Google Analytics property the
	// merchant is linked to.
	PropertyName string `json:"propertyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributionSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleAnalyticsLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Headers: A non-empty list of row or column headers for a table. Exactly one
// of `prices`, `weights`, `numItems`, `postalCodeGroupNames`, or `location`
// must be set.
type Headers struct {
	// Locations: A list of location ID sets. Must be non-empty. Can only be set if
	// all other fields are not set.
	Locations []*LocationIdSet `json:"locations,omitempty"`
	// NumberOfItems: A list of inclusive number of items upper bounds. The last
	// value can be "infinity". For example `["10", "50", "infinity"]` represents
	// the headers "<= 10 items", "<= 50 items", and "> 50 items". Must be
	// non-empty. Can only be set if all other fields are not set.
	NumberOfItems []string `json:"numberOfItems,omitempty"`
	// PostalCodeGroupNames: A list of postal group names. The last value can be
	// "all other locations". Example: `["zone 1", "zone 2", "all other
	// locations"]`. The referred postal code groups must match the delivery
	// country of the service. Must be non-empty. Can only be set if all other
	// fields are not set.
	PostalCodeGroupNames []string `json:"postalCodeGroupNames,omitempty"`
	// Prices: A list of inclusive order price upper bounds. The last price's value
	// can be "infinity". For example `[{"value": "10", "currency": "USD"},
	// {"value": "500", "currency": "USD"}, {"value": "infinity", "currency":
	// "USD"}]` represents the headers "<= $10", "<= $500", and "> $500". All
	// prices within a service must have the same currency. Must be non-empty. Can
	// only be set if all other fields are not set.
	Prices []*Price `json:"prices,omitempty"`
	// Weights: A list of inclusive order weight upper bounds. The last weight's
	// value can be "infinity". For example `[{"value": "10", "unit": "kg"},
	// {"value": "50", "unit": "kg"}, {"value": "infinity", "unit": "kg"}]`
	// represents the headers "<= 10kg", "<= 50kg", and "> 50kg". All weights
	// within a service must have the same unit. Must be non-empty. Can only be set
	// if all other fields are not set.
	Weights []*Weight `json:"weights,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Headers) MarshalJSON() ([]byte, error) {
	type NoMethod Headers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type HolidayCutoff struct {
	// DeadlineDate: Date of the order deadline, in ISO 8601 format. For example,
	// "2016-11-29" for 29th November 2016. Required.
	DeadlineDate string `json:"deadlineDate,omitempty"`
	// DeadlineHour: Hour of the day on the deadline date until which the order has
	// to be placed to qualify for the delivery guarantee. Possible values are: 0
	// (midnight), 1, ..., 12 (noon), 13, ..., 23. Required.
	DeadlineHour int64 `json:"deadlineHour,omitempty"`
	// DeadlineTimezone: Timezone identifier for the deadline hour (for example,
	// "Europe/Zurich"). List of identifiers. Required.
	DeadlineTimezone string `json:"deadlineTimezone,omitempty"`
	// HolidayId: Unique identifier for the holiday. Required.
	HolidayId string `json:"holidayId,omitempty"`
	// VisibleFromDate: Date on which the deadline will become visible to consumers
	// in ISO 8601 format. For example, "2016-10-31" for 31st October 2016.
	// Required.
	VisibleFromDate string `json:"visibleFromDate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeadlineDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeadlineDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HolidayCutoff) MarshalJSON() ([]byte, error) {
	type NoMethod HolidayCutoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type HolidaysHoliday struct {
	// CountryCode: The CLDR territory code of the country in which the holiday is
	// available. For example, "US", "DE", "GB". A holiday cutoff can only be
	// configured in a shipping settings service with matching delivery country.
	// Always present.
	CountryCode string `json:"countryCode,omitempty"`
	// Date: Date of the holiday, in ISO 8601 format. For example, "2016-12-25" for
	// Christmas 2016. Always present.
	Date string `json:"date,omitempty"`
	// DeliveryGuaranteeDate: Date on which the order has to arrive at the
	// customer's, in ISO 8601 format. For example, "2016-12-24" for 24th December
	// 2016. Always present.
	DeliveryGuaranteeDate string `json:"deliveryGuaranteeDate,omitempty"`
	// DeliveryGuaranteeHour: Hour of the day in the delivery location's timezone
	// on the guaranteed delivery date by which the order has to arrive at the
	// customer's. Possible values are: 0 (midnight), 1, ..., 12 (noon), 13, ...,
	// 23. Always present.
	DeliveryGuaranteeHour uint64 `json:"deliveryGuaranteeHour,omitempty,string"`
	// Id: Unique identifier for the holiday to be used when configuring holiday
	// cutoffs. Always present.
	Id string `json:"id,omitempty"`
	// Type: The holiday type. Always present. Acceptable values are: -
	// "Christmas" - "Easter" - "Father's Day" - "Halloween" -
	// "Independence Day (USA)" - "Mother's Day" - "Thanksgiving" -
	// "Valentine's Day"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CountryCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CountryCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HolidaysHoliday) MarshalJSON() ([]byte, error) {
	type NoMethod HolidaysHoliday
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputField: Input field that needs to be available to the merchant. If the
// field is marked as required, then a value needs to be provided for a
// successful processing of the request.
type InputField struct {
	// CheckboxInput: Input field to provide a boolean value. Corresponds to the
	// html input type=checkbox
	// (https://www.w3.org/TR/2012/WD-html-markup-20121025/input.checkbox.html#input.checkbox).
	CheckboxInput *InputFieldCheckboxInput `json:"checkboxInput,omitempty"`
	// ChoiceInput: Input field to select one of the offered choices. Corresponds
	// to the html input type=radio
	// (https://www.w3.org/TR/2012/WD-html-markup-20121025/input.radio.html#input.radio).
	ChoiceInput *InputFieldChoiceInput `json:"choiceInput,omitempty"`
	// Id: Not for display but need to be sent back for the given input field.
	Id string `json:"id,omitempty"`
	// Label: Input field label. There may be more information to be shown in a
	// tooltip.
	Label *TextWithTooltip `json:"label,omitempty"`
	// Required: Whether the field is required. The action button needs to stay
	// disabled till values for all required fields are provided.
	Required bool `json:"required,omitempty"`
	// TextInput: Input field to provide text information. Corresponds to the html
	// input type=text
	// (https://www.w3.org/TR/2012/WD-html-markup-20121025/input.text.html#input.text)
	// or html textarea
	// (https://www.w3.org/TR/2012/WD-html-markup-20121025/textarea.html#textarea).
	TextInput *InputFieldTextInput `json:"textInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckboxInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckboxInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputField) MarshalJSON() ([]byte, error) {
	type NoMethod InputField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputFieldCheckboxInput: Checkbox input allows merchants to provide a
// boolean value. Corresponds to the html input type=checkbox
// (https://www.w3.org/TR/2012/WD-html-markup-20121025/input.checkbox.html#input.checkbox).
// If merchant checks the box, the input value for the field is `true`,
// otherwise it is `false`. This type of input is often used as a confirmation
// that the merchant completed required steps before they are allowed to start
// the action. In such a case, the input field is marked as required and the
// button to trigger the action should stay disabled until the merchant checks
// the box.
type InputFieldCheckboxInput struct {
}

// InputFieldChoiceInput: Choice input allows merchants to select one of the
// offered choices. Some choices may be linked to additional input fields that
// should be displayed under or next to the choice option. The value for the
// additional input field needs to be provided only when the specific choice is
// selected by the merchant. For example, additional input field can be hidden
// or disabled until the merchant selects the specific choice.
type InputFieldChoiceInput struct {
	// Options: A list of choices. Only one option can be selected.
	Options []*InputFieldChoiceInputChoiceInputOption `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Options") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Options") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputFieldChoiceInput) MarshalJSON() ([]byte, error) {
	type NoMethod InputFieldChoiceInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputFieldChoiceInputChoiceInputOption: A choice that merchant can select.
type InputFieldChoiceInputChoiceInputOption struct {
	// AdditionalInput: Input that should be displayed when this option is
	// selected. The additional input will not contain a `ChoiceInput`.
	AdditionalInput *InputField `json:"additionalInput,omitempty"`
	// Id: Not for display but need to be sent back for the selected choice option.
	Id string `json:"id,omitempty"`
	// Label: Short description of the choice option. There may be more information
	// to be shown as a tooltip.
	Label *TextWithTooltip `json:"label,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalInput") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputFieldChoiceInputChoiceInputOption) MarshalJSON() ([]byte, error) {
	type NoMethod InputFieldChoiceInputChoiceInputOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputFieldTextInput: Text input allows merchants to provide a text value.
type InputFieldTextInput struct {
	// AdditionalInfo: Additional info regarding the field to be displayed to
	// merchant. For example, warning to not include personal identifiable
	// information. There may be more information to be shown in a tooltip.
	AdditionalInfo *TextWithTooltip `json:"additionalInfo,omitempty"`
	// AriaLabel: Text to be used as the aria-label
	// (https://www.w3.org/TR/WCAG20-TECHS/ARIA14.html) for the input.
	AriaLabel string `json:"ariaLabel,omitempty"`
	// FormatInfo: Information about the required format. If present, it should be
	// shown close to the input field to help merchants to provide a correct value.
	// For example: "VAT numbers should be in a format similar to SK9999999999"
	FormatInfo string `json:"formatInfo,omitempty"`
	// Type: Type of the text input
	//
	// Possible values:
	//   "TEXT_INPUT_TYPE_UNSPECIFIED" - Default value. Will never be provided by
	// the API.
	//   "GENERIC_SHORT_TEXT" - Used when a short text is expected. The field can
	// be rendered as a [text
	// field](https://www.w3.org/TR/2012/WD-html-markup-20121025/input.text.html#inp
	// ut.text).
	//   "GENERIC_LONG_TEXT" - Used when a longer text is expected. The field
	// should be rendered as a
	// [textarea](https://www.w3.org/TR/2012/WD-html-markup-20121025/textarea.html#t
	// extarea).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputFieldTextInput) MarshalJSON() ([]byte, error) {
	type NoMethod InputFieldTextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputValue: Input provided by the merchant for input field.
type InputValue struct {
	// CheckboxInputValue: Value for checkbox input field.
	CheckboxInputValue *InputValueCheckboxInputValue `json:"checkboxInputValue,omitempty"`
	// ChoiceInputValue: Value for choice input field.
	ChoiceInputValue *InputValueChoiceInputValue `json:"choiceInputValue,omitempty"`
	// InputFieldId: Required. Id of the corresponding input field.
	InputFieldId string `json:"inputFieldId,omitempty"`
	// TextInputValue: Value for text input field.
	TextInputValue *InputValueTextInputValue `json:"textInputValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckboxInputValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckboxInputValue") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputValue) MarshalJSON() ([]byte, error) {
	type NoMethod InputValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputValueCheckboxInputValue: Value for checkbox input field.
type InputValueCheckboxInputValue struct {
	// Value: Required. True if the merchant checked the box field. False
	// otherwise.
	Value bool `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputValueCheckboxInputValue) MarshalJSON() ([]byte, error) {
	type NoMethod InputValueCheckboxInputValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputValueChoiceInputValue: Value for choice input field.
type InputValueChoiceInputValue struct {
	// ChoiceInputOptionId: Required. Id of the option that was selected by the
	// merchant.
	ChoiceInputOptionId string `json:"choiceInputOptionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChoiceInputOptionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChoiceInputOptionId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputValueChoiceInputValue) MarshalJSON() ([]byte, error) {
	type NoMethod InputValueChoiceInputValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputValueTextInputValue: Value for text input field.
type InputValueTextInputValue struct {
	// Value: Required. Text provided by the merchant.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputValueTextInputValue) MarshalJSON() ([]byte, error) {
	type NoMethod InputValueTextInputValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InsertCheckoutSettingsRequest: Request message for the
// `InsertCheckoutSettings` method.
type InsertCheckoutSettingsRequest struct {
	// UriSettings: Required. The `UrlSettings` for the request. The presence of
	// URL settings indicates `Checkout` enrollment.
	UriSettings *UrlSettings `json:"uriSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UriSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UriSettings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InsertCheckoutSettingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InsertCheckoutSettingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Installment: Details of a monthly installment payment offering. Learn more
// (https://support.google.com/merchants/answer/6324474) about installments.
type Installment struct {
	// Amount: The amount the buyer has to pay per month.
	Amount *Price `json:"amount,omitempty"`
	// CreditType: Optional. Type of installment payments. Supported values are: -
	// "finance" - "lease"
	CreditType string `json:"creditType,omitempty"`
	// Downpayment: Optional. The initial down payment amount the buyer has to pay.
	Downpayment *Price `json:"downpayment,omitempty"`
	// Months: The number of installments the buyer has to pay.
	Months int64 `json:"months,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Amount") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Installment) MarshalJSON() ([]byte, error) {
	type NoMethod Installment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LabelIds: The IDs of labels that should be assigned to the CSS domain.
type LabelIds struct {
	// LabelIds: The list of label IDs.
	LabelIds googleapi.Int64s `json:"labelIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LabelIds) MarshalJSON() ([]byte, error) {
	type NoMethod LabelIds
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiaAboutPageSettings struct {
	// Status: The status of the verification process for the About page. Supported
	// values are: - "active" - "inactive" - "pending"
	Status string `json:"status,omitempty"`
	// Url: The URL for the About page.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiaAboutPageSettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaAboutPageSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiaCountrySettings struct {
	// About: The settings for the About page.
	About *LiaAboutPageSettings `json:"about,omitempty"`
	// Country: Required. CLDR country code (for example, "US").
	Country string `json:"country,omitempty"`
	// HostedLocalStorefrontActive: The status of the "Merchant hosted local
	// storefront" feature.
	HostedLocalStorefrontActive bool `json:"hostedLocalStorefrontActive,omitempty"`
	// Inventory: LIA inventory verification settings.
	Inventory *LiaInventorySettings `json:"inventory,omitempty"`
	// OmnichannelExperience: The omnichannel experience configured for this
	// country.
	OmnichannelExperience *LiaOmnichannelExperience `json:"omnichannelExperience,omitempty"`
	// OnDisplayToOrder: LIA "On Display To Order" settings.
	OnDisplayToOrder *LiaOnDisplayToOrderSettings `json:"onDisplayToOrder,omitempty"`
	// PosDataProvider: The POS data provider linked with this country.
	PosDataProvider *LiaPosDataProvider `json:"posDataProvider,omitempty"`
	// StorePickupActive: The status of the "Store pickup" feature.
	StorePickupActive bool `json:"storePickupActive,omitempty"`
	// ForceSendFields is a list of field names (e.g. "About") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "About") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiaCountrySettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaCountrySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiaInventorySettings struct {
	// InventoryVerificationContactEmail: The email of the contact for the
	// inventory verification process.
	InventoryVerificationContactEmail string `json:"inventoryVerificationContactEmail,omitempty"`
	// InventoryVerificationContactName: The name of the contact for the inventory
	// verification process.
	InventoryVerificationContactName string `json:"inventoryVerificationContactName,omitempty"`
	// InventoryVerificationContactStatus: The status of the verification contact.
	// Acceptable values are: - "active" - "inactive" - "pending"
	InventoryVerificationContactStatus string `json:"inventoryVerificationContactStatus,omitempty"`
	// Status: The status of the inventory verification process. Acceptable values
	// are: - "active" - "inactive" - "pending"
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "InventoryVerificationContactEmail") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "InventoryVerificationContactEmail") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s LiaInventorySettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaInventorySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LiaOmnichannelExperience: Omnichannel experience details.
type LiaOmnichannelExperience struct {
	// Country: The CLDR country code (for example, "US").
	Country string `json:"country,omitempty"`
	// LsfType: The Local Store Front (LSF) type for this country. Acceptable
	// values are: - "ghlsf" (Google-Hosted Local Store Front) - "mhlsfBasic"
	// (Merchant-Hosted Local Store Front Basic) - "mhlsfFull" (Merchant-Hosted
	// Local Store Front Full) More details about these types can be found here.
	LsfType string `json:"lsfType,omitempty"`
	// PickupTypes: The Pickup types for this country. Acceptable values are: -
	// "pickupToday" - "pickupLater"
	PickupTypes []string `json:"pickupTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiaOmnichannelExperience) MarshalJSON() ([]byte, error) {
	type NoMethod LiaOmnichannelExperience
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiaOnDisplayToOrderSettings struct {
	// ShippingCostPolicyUrl: Shipping cost and policy URL.
	ShippingCostPolicyUrl string `json:"shippingCostPolicyUrl,omitempty"`
	// Status: The status of the ?On display to order? feature. Acceptable values
	// are: - "active" - "inactive" - "pending"
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ShippingCostPolicyUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShippingCostPolicyUrl") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiaOnDisplayToOrderSettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaOnDisplayToOrderSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiaPosDataProvider struct {
	// PosDataProviderId: The ID of the POS data provider.
	PosDataProviderId uint64 `json:"posDataProviderId,omitempty,string"`
	// PosExternalAccountId: The account ID by which this merchant is known to the
	// POS data provider.
	PosExternalAccountId string `json:"posExternalAccountId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PosDataProviderId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PosDataProviderId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiaPosDataProvider) MarshalJSON() ([]byte, error) {
	type NoMethod LiaPosDataProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LiaSettings: Local Inventory ads (LIA) settings. All methods except
// listposdataproviders require the admin role.
type LiaSettings struct {
	// AccountId: The ID of the account to which these LIA settings belong. Ignored
	// upon update, always present in get request responses.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// CountrySettings: The LIA settings for each country.
	CountrySettings []*LiaCountrySettings `json:"countrySettings,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liaSettings"
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiaSettings) MarshalJSON() ([]byte, error) {
	type NoMethod LiaSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*LiasettingsCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsCustomBatchRequestEntry struct {
	// AccountId: The ID of the account for which to get/update account LIA
	// settings.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// ContactEmail: Inventory validation contact email. Required only for
	// SetInventoryValidationContact.
	ContactEmail string `json:"contactEmail,omitempty"`
	// ContactName: Inventory validation contact name. Required only for
	// SetInventoryValidationContact.
	ContactName string `json:"contactName,omitempty"`
	// Country: The country code. Required only for RequestInventoryVerification.
	Country string `json:"country,omitempty"`
	// GmbEmail: The Business Profile. Required only for RequestGmbAccess.
	GmbEmail string `json:"gmbEmail,omitempty"`
	// LiaSettings: The account Lia settings to update. Only defined if the method
	// is `update`.
	LiaSettings *LiaSettings `json:"liaSettings,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "get" -
	// "getAccessibleGmbAccounts" - "requestGmbAccess" -
	// "requestInventoryVerification" - "setInventoryVerificationContact" -
	// "update"
	Method string `json:"method,omitempty"`
	// OmnichannelExperience: The omnichannel experience for a country. Required
	// only for SetOmnichannelExperience.
	OmnichannelExperience *LiaOmnichannelExperience `json:"omnichannelExperience,omitempty"`
	// PosDataProviderId: The ID of POS data provider. Required only for
	// SetPosProvider.
	PosDataProviderId uint64 `json:"posDataProviderId,omitempty,string"`
	// PosExternalAccountId: The account ID by which this merchant is known to the
	// POS provider.
	PosExternalAccountId string `json:"posExternalAccountId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*LiasettingsCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`
	// GmbAccounts: The list of accessible Business Profiles.
	GmbAccounts *GmbAccounts `json:"gmbAccounts,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// LiaSettings: The retrieved or updated Lia settings.
	LiaSettings *LiaSettings `json:"liaSettings,omitempty"`
	// OmnichannelExperience: The updated omnichannel experience for a country.
	OmnichannelExperience *LiaOmnichannelExperience `json:"omnichannelExperience,omitempty"`
	// PosDataProviders: The list of POS data providers.
	PosDataProviders []*PosDataProviders `json:"posDataProviders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsGetAccessibleGmbAccountsResponse struct {
	// AccountId: The ID of the Merchant Center account.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// GmbAccounts: A list of Business Profiles which are available to the
	// merchant.
	GmbAccounts []*GmbAccountsGmbAccount `json:"gmbAccounts,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsGetAccessibleGmbAccountsResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsGetAccessibleGmbAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsGetAccessibleGmbAccountsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsListPosDataProvidersResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsListPosDataProvidersResponse".
	Kind string `json:"kind,omitempty"`
	// PosDataProviders: The list of POS data providers for each eligible country
	PosDataProviders []*PosDataProviders `json:"posDataProviders,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsListPosDataProvidersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsListPosDataProvidersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of LIA settings.
	NextPageToken string         `json:"nextPageToken,omitempty"`
	Resources     []*LiaSettings `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsRequestGmbAccessResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsRequestGmbAccessResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsRequestGmbAccessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsRequestGmbAccessResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsRequestInventoryVerificationResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsRequestInventoryVerificationResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsRequestInventoryVerificationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsRequestInventoryVerificationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsSetInventoryVerificationContactResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsSetInventoryVerificationContactResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsSetInventoryVerificationContactResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsSetInventoryVerificationContactResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LiasettingsSetPosDataProviderResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#liasettingsSetPosDataProviderResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LiasettingsSetPosDataProviderResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LiasettingsSetPosDataProviderResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LinkService struct {
	// Service: Service provided to or by the linked account. Acceptable values
	// are: - "shoppingActionsOrderManagement" -
	// "shoppingActionsProductManagement" - "shoppingAdsProductManagement" -
	// "paymentProcessing"
	Service string `json:"service,omitempty"`
	// Status: Status of the link Acceptable values are: - "active" -
	// "inactive" - "pending"
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinkService) MarshalJSON() ([]byte, error) {
	type NoMethod LinkService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LinkedAccount struct {
	// LinkedAccountId: The ID of the linked account.
	LinkedAccountId string `json:"linkedAccountId,omitempty"`
	// Services: List of provided services.
	Services []*LinkService `json:"services,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LinkedAccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LinkedAccountId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinkedAccount) MarshalJSON() ([]byte, error) {
	type NoMethod LinkedAccount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAccountLabelsResponse: Response message for the `ListAccountLabels`
// method.
type ListAccountLabelsResponse struct {
	// AccountLabels: The labels from the specified account.
	AccountLabels []*AccountLabel `json:"accountLabels,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountLabels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAccountLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAccountLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAccountReturnCarrierResponse: Response for listing account return
// carriers.
type ListAccountReturnCarrierResponse struct {
	// AccountReturnCarriers: List of all available account return carriers for the
	// merchant.
	AccountReturnCarriers []*AccountReturnCarrier `json:"accountReturnCarriers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountReturnCarriers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountReturnCarriers") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAccountReturnCarrierResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAccountReturnCarrierResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCollectionStatusesResponse: Response message for the
// ListCollectionStatuses method.
type ListCollectionStatusesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Resources: The collectionstatuses listed.
	Resources []*CollectionStatus `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCollectionStatusesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCollectionStatusesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCollectionsResponse: Response message for the ListCollections method.
type ListCollectionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Resources: The collections listed.
	Resources []*Collection `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCollectionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCollectionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListConversionSourcesResponse: Response message for the
// ListConversionSources method.
type ListConversionSourcesResponse struct {
	// ConversionSources: List of conversion sources.
	ConversionSources []*ConversionSource `json:"conversionSources,omitempty"`
	// NextPageToken: Token to be used to fetch the next results page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversionSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversionSources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConversionSourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConversionSourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCssesResponse: The response message for the `ListCsses` method
type ListCssesResponse struct {
	// Csses: The CSS domains affiliated with the specified CSS group.
	Csses []*Css `json:"csses,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Csses") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Csses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCssesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCssesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMethodQuotasResponse: Response message for the ListMethodQuotas method.
type ListMethodQuotasResponse struct {
	// MethodQuotas: The current quota usage and limits per each method.
	MethodQuotas []*MethodQuota `json:"methodQuotas,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MethodQuotas") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MethodQuotas") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMethodQuotasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMethodQuotasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPromotionResponse: Response message for Promotions.List method.
type ListPromotionResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Promotions: List of all available promotions for the merchant.
	Promotions []*Promotion `json:"promotions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPromotionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPromotionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRegionsResponse: Response message for the `ListRegions` method.
type ListRegionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Regions: The regions from the specified merchant.
	Regions []*Region `json:"regions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRegionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRegionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListReturnPolicyOnlineResponse: Response message for the
// `ListReturnPolicyOnline` method.
type ListReturnPolicyOnlineResponse struct {
	// ReturnPolicies: The retrieved return policies.
	ReturnPolicies []*ReturnPolicyOnline `json:"returnPolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ReturnPolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReturnPolicies") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListReturnPolicyOnlineResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReturnPolicyOnlineResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalInventory: Local inventory resource. For accepted attribute values, see
// the local product inventory feed specification.
type LocalInventory struct {
	// Availability: The availability of the product. For accepted attribute
	// values, see the local product inventory feed specification.
	Availability string `json:"availability,omitempty"`
	// CustomAttributes: A list of custom (merchant-provided) attributes. Can also
	// be used to submit any attribute of the feed specification in its generic
	// form, for example, `{ "name": "size type", "value": "regular" }`.
	CustomAttributes []*CustomAttribute `json:"customAttributes,omitempty"`
	// InstoreProductLocation: The in-store product location.
	InstoreProductLocation string `json:"instoreProductLocation,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#localInventory"
	Kind string `json:"kind,omitempty"`
	// PickupMethod: The supported pickup method for this offer. Unless the value
	// is "not supported", this field must be submitted together with `pickupSla`.
	// For accepted attribute values, see the local product inventory feed
	// specification.
	PickupMethod string `json:"pickupMethod,omitempty"`
	// PickupSla: The expected date that an order will be ready for pickup relative
	// to the order date. Must be submitted together with `pickupMethod`. For
	// accepted attribute values, see the local product inventory feed
	// specification.
	PickupSla string `json:"pickupSla,omitempty"`
	// Price: The price of the product.
	Price *Price `json:"price,omitempty"`
	// Quantity: The quantity of the product. Must be nonnegative.
	Quantity int64 `json:"quantity,omitempty"`
	// SalePrice: The sale price of the product. Mandatory if
	// `sale_price_effective_date` is defined.
	SalePrice *Price `json:"salePrice,omitempty"`
	// SalePriceEffectiveDate: A date range represented by a pair of ISO 8601 dates
	// separated by a space, comma, or slash. Both dates may be specified as 'null'
	// if undecided.
	SalePriceEffectiveDate string `json:"salePriceEffectiveDate,omitempty"`
	// StoreCode: Required. The store code of this local inventory resource.
	StoreCode string `json:"storeCode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Availability") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Availability") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalInventory) MarshalJSON() ([]byte, error) {
	type NoMethod LocalInventory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LocalinventoryCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*LocalinventoryCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalinventoryCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod LocalinventoryCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalinventoryCustomBatchRequestEntry: Batch entry encoding a single local
// inventory update request.
type LocalinventoryCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// LocalInventory: Local inventory of the product.
	LocalInventory *LocalInventory `json:"localInventory,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: Method of the batch request entry. Acceptable values are: -
	// "insert"
	Method string `json:"method,omitempty"`
	// ProductId: The ID of the product for which to update local inventory.
	ProductId string `json:"productId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalinventoryCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LocalinventoryCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LocalinventoryCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*LocalinventoryCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#localinventoryCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalinventoryCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LocalinventoryCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalinventoryCustomBatchResponseEntry: Batch entry encoding a single local
// inventory update response.
type LocalinventoryCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#localinventoryCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalinventoryCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LocalinventoryCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LocationIdSet struct {
	// LocationIds: A non-empty list of location IDs. They must all be of the same
	// location type (for example, state).
	LocationIds []string `json:"locationIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocationIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocationIdSet) MarshalJSON() ([]byte, error) {
	type NoMethod LocationIdSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoyaltyProgram: Allows the setting up of loyalty program benefits (for
// example price or points).
// https://support.google.com/merchants/answer/12922446
type LoyaltyProgram struct {
	// CashbackForFutureUse: Optional. The cashback that can be used for future
	// purchases.
	CashbackForFutureUse *Price `json:"cashbackForFutureUse,omitempty"`
	// LoyaltyPoints: Optional. The amount of loyalty points earned on a purchase.
	LoyaltyPoints int64 `json:"loyaltyPoints,omitempty,string"`
	// MemberPriceEffectiveDate: Optional. A date range during which the item is
	// eligible for member price. If not specified, the member price is always
	// applicable. The date range is represented by a pair of ISO 8601 dates
	// separated by a space, comma, or slash.
	MemberPriceEffectiveDate string `json:"memberPriceEffectiveDate,omitempty"`
	// Price: Optional. The price for members of the given tier (instant discount
	// price). Must be smaller or equal to the regular price.
	Price *Price `json:"price,omitempty"`
	// ProgramLabel: Required. The label of the loyalty program. This is an
	// internal label that uniquely identifies the relationship between a merchant
	// entity and a loyalty program entity. It must be provided so that system can
	// associate the assets below (for example, price and points) with a merchant.
	// The corresponding program must be linked to the merchant account.
	ProgramLabel string `json:"programLabel,omitempty"`
	// ShippingLabel: Optional. The shipping label for the loyalty program. You can
	// use this label to indicate whether this offer has the loyalty shipping
	// benefit. If not specified, the item is not eligible for loyalty shipping for
	// the given loyalty tier.
	ShippingLabel string `json:"shippingLabel,omitempty"`
	// TierLabel: Required. The label of the tier within the loyalty program. Must
	// match one of the labels within the program.
	TierLabel string `json:"tierLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CashbackForFutureUse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CashbackForFutureUse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyProgram) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyProgram
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MerchantCenterDestination: "Merchant Center Destination" sources can be used
// to send conversion events from a website using a Google tag directly to a
// Merchant Center account where the source is created.
type MerchantCenterDestination struct {
	// AttributionSettings: Required. Attribution settings being used for the
	// Merchant Center Destination.
	AttributionSettings *AttributionSettings `json:"attributionSettings,omitempty"`
	// CurrencyCode: Required. Three-letter currency code (ISO 4217). The currency
	// code defines in which currency the conversions sent to this destination will
	// be reported in Merchant Center.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// DestinationId: Output only. Merchant Center Destination ID.
	DestinationId string `json:"destinationId,omitempty"`
	// DisplayName: Required. Merchant-specified display name for the destination.
	// This is the name that identifies the conversion source within the Merchant
	// Center UI. Limited to 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributionSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributionSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MerchantCenterDestination) MarshalJSON() ([]byte, error) {
	type NoMethod MerchantCenterDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MethodQuota: The quota information per method in the Content API.
type MethodQuota struct {
	// Method: Output only. The method name, for example `products.list`. Method
	// name does not contain version because quota can be shared between different
	// API versions of the same method.
	Method string `json:"method,omitempty"`
	// QuotaLimit: Output only. The maximum number of calls allowed per day for the
	// method.
	QuotaLimit int64 `json:"quotaLimit,omitempty,string"`
	// QuotaMinuteLimit: Output only. The maximum number of calls allowed per
	// minute for the method.
	QuotaMinuteLimit int64 `json:"quotaMinuteLimit,omitempty,string"`
	// QuotaUsage: Output only. The current quota usage, meaning the number of
	// calls already made to the method per day. Usage is reset every day at 12 PM
	// midday UTC.
	QuotaUsage int64 `json:"quotaUsage,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Method") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Method") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MethodQuota) MarshalJSON() ([]byte, error) {
	type NoMethod MethodQuota
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Metrics: Performance metrics. Values are only set for metrics requested
// explicitly in the request's search query.
type Metrics struct {
	// Aos: *Deprecated*: This field is no longer supported and retrieving it
	// returns 0 starting from May 2024. Average order size - the average number of
	// items in an order. **This metric cannot be segmented by product dimensions
	// and customer_country_code.**
	Aos float64 `json:"aos,omitempty"`
	// AovMicros: *Deprecated*: This field is no longer supported and retrieving it
	// returns 0 starting from May 2024. Average order value in micros (1 millionth
	// of a standard unit, 1 USD = 1000000 micros) - the average value (total price
	// of items) of all placed orders. The currency of the returned value is stored
	// in the currency_code segment. If this metric is selected,
	// 'segments.currency_code' is automatically added to the SELECT clause in the
	// search query (unless it is explicitly selected by the user) and the
	// currency_code segment is populated in the response. **This metric cannot be
	// segmented by product dimensions and customer_country_code.**
	AovMicros float64 `json:"aovMicros,omitempty"`
	// Clicks: Number of clicks.
	Clicks int64 `json:"clicks,omitempty,string"`
	// ConversionRate: Number of conversions divided by the number of clicks,
	// reported on the impression date. The metric is currently available only for
	// the `FREE_PRODUCT_LISTING` program.
	ConversionRate float64 `json:"conversionRate,omitempty"`
	// ConversionValueMicros: Value of conversions in micros (1 millionth of a
	// standard unit, 1 USD = 1000000 micros) attributed to the product, reported
	// on the conversion date. The metric is currently available only for the
	// `FREE_PRODUCT_LISTING` program. The currency of the returned value is stored
	// in the currency_code segment. If this metric is selected,
	// 'segments.currency_code' is automatically added to the SELECT clause in the
	// search query (unless it is explicitly selected by the user) and the
	// currency_code segment is populated in the response.
	ConversionValueMicros int64 `json:"conversionValueMicros,omitempty,string"`
	// Conversions: Number of conversions attributed to the product, reported on
	// the conversion date. Depending on the attribution model, a conversion might
	// be distributed across multiple clicks, where each click gets its own credit
	// assigned. This metric is a sum of all such credits. The metric is currently
	// available only for the `FREE_PRODUCT_LISTING` program.
	Conversions float64 `json:"conversions,omitempty"`
	// Ctr: Click-through rate - the number of clicks merchant's products receive
	// (clicks) divided by the number of times the products are shown
	// (impressions).
	Ctr float64 `json:"ctr,omitempty"`
	// DaysToShip: *Deprecated*: This field is no longer supported and retrieving
	// it returns 0 starting from May 2024. Average number of days between an order
	// being placed and the order being fully shipped, reported on the last
	// shipment date. **This metric cannot be segmented by product dimensions and
	// customer_country_code.**
	DaysToShip float64 `json:"daysToShip,omitempty"`
	// Impressions: Number of times merchant's products are shown.
	Impressions int64 `json:"impressions,omitempty,string"`
	// ItemDaysToShip: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Average number of days
	// between an item being ordered and the item being **This metric cannot be
	// segmented by customer_country_code.**
	ItemDaysToShip float64 `json:"itemDaysToShip,omitempty"`
	// ItemFillRate: *Deprecated*: This field is no longer supported and retrieving
	// it returns 0 starting from May 2024. Percentage of shipped items in relation
	// to all finalized items (shipped or rejected by the merchant; unshipped items
	// are not taken into account), reported on the order date. Item fill rate is
	// lowered by merchant rejections. **This metric cannot be segmented by
	// customer_country_code.**
	ItemFillRate float64 `json:"itemFillRate,omitempty"`
	// OrderedItemSalesMicros: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Total price of ordered items
	// in micros (1 millionth of a standard unit, 1 USD = 1000000 micros). Excludes
	// shipping, taxes (US only), and customer cancellations that happened within
	// 30 minutes of placing the order. The currency of the returned value is
	// stored in the currency_code segment. If this metric is selected,
	// 'segments.currency_code' is automatically added to the SELECT clause in the
	// search query (unless it is explicitly selected by the user) and the
	// currency_code segment is populated in the response. **This metric cannot be
	// segmented by customer_country_code.**
	OrderedItemSalesMicros int64 `json:"orderedItemSalesMicros,omitempty,string"`
	// OrderedItems: *Deprecated*: This field is no longer supported and retrieving
	// it returns 0 starting from May 2024. Number of ordered items. Excludes
	// customer cancellations that happened within 30 minutes of placing the order.
	// **This metric cannot be segmented by customer_country_code.**
	OrderedItems int64 `json:"orderedItems,omitempty,string"`
	// Orders: *Deprecated*: This field is no longer supported and retrieving it
	// returns 0 starting from May 2024. Number of placed orders. Excludes customer
	// cancellations that happened within 30 minutes of placing the order. **This
	// metric cannot be segmented by product dimensions and
	// customer_country_code.**
	Orders int64 `json:"orders,omitempty,string"`
	// RejectedItems: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Number of ordered items
	// canceled by the merchant, reported on the order date. **This metric cannot
	// be segmented by customer_country_code.**
	RejectedItems int64 `json:"rejectedItems,omitempty,string"`
	// ReturnRate: *Deprecated*: This field is no longer supported and retrieving
	// it returns 0 starting from May 2024. Total price of returned items divided
	// by the total price of shipped items, reported on the order date. If this
	// metric is selected, 'segments.currency_code' is automatically added to the
	// SELECT clause in the search query (unless it is explicitly selected by the
	// user) and the currency_code segment is populated in the response. **This
	// metric cannot be segmented by customer_country_code.**
	ReturnRate float64 `json:"returnRate,omitempty"`
	// ReturnedItems: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Number of ordered items sent
	// back for return, reported on the date when the merchant accepted the return.
	// **This metric cannot be segmented by customer_country_code.**
	ReturnedItems int64 `json:"returnedItems,omitempty,string"`
	// ReturnsMicros: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Total price of ordered items
	// sent back for return in micros (1 millionth of a standard unit, 1 USD =
	// 1000000 micros), reported on the date when the merchant accepted the return.
	// The currency of the returned value is stored in the currency_code segment.
	// If this metric is selected, 'segments.currency_code' is automatically added
	// to the SELECT clause in the search query (unless it is explicitly selected
	// by the user) and the currency_code segment is populated in the response.
	// **This metric cannot be segmented by customer_country_code.**
	ReturnsMicros int64 `json:"returnsMicros,omitempty,string"`
	// ShippedItemSalesMicros: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Total price of shipped items
	// in micros (1 millionth of a standard unit, 1 USD = 1000000 micros), reported
	// on the order date. Excludes shipping and taxes (US only). The currency of
	// the returned value is stored in the currency_code segment. If this metric is
	// selected, 'segments.currency_code' is automatically added to the SELECT
	// clause in the search query (unless it is explicitly selected by the user)
	// and the currency_code segment is populated in the response. **This metric
	// cannot be segmented by customer_country_code.**
	ShippedItemSalesMicros int64 `json:"shippedItemSalesMicros,omitempty,string"`
	// ShippedItems: *Deprecated*: This field is no longer supported and retrieving
	// it returns 0 starting from May 2024. Number of shipped items, reported on
	// the shipment date. **This metric cannot be segmented by
	// customer_country_code.**
	ShippedItems int64 `json:"shippedItems,omitempty,string"`
	// ShippedOrders: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Number of fully shipped
	// orders, reported on the last shipment date. **This metric cannot be
	// segmented by product dimensions and customer_country_code.**
	ShippedOrders int64 `json:"shippedOrders,omitempty,string"`
	// UnshippedItems: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Number of ordered items not
	// shipped up until the end of the queried day. If a multi-day period is
	// specified in the search query, the returned value is the average number of
	// unshipped items over the days in the queried period. **This metric cannot be
	// segmented by customer_country_code.**
	UnshippedItems float64 `json:"unshippedItems,omitempty"`
	// UnshippedOrders: *Deprecated*: This field is no longer supported and
	// retrieving it returns 0 starting from May 2024. Number of orders not shipped
	// or partially shipped up until the end of the queried day. If a multi-day
	// period is specified in the search query, the returned value is the average
	// number of unshipped orders over the days in the queried period. **This
	// metric cannot be segmented by product dimensions and
	// customer_country_code.**
	UnshippedOrders float64 `json:"unshippedOrders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Aos") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Aos") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Metrics) MarshalJSON() ([]byte, error) {
	type NoMethod Metrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Metrics) UnmarshalJSON(data []byte) error {
	type NoMethod Metrics
	var s1 struct {
		Aos             gensupport.JSONFloat64 `json:"aos"`
		AovMicros       gensupport.JSONFloat64 `json:"aovMicros"`
		ConversionRate  gensupport.JSONFloat64 `json:"conversionRate"`
		Conversions     gensupport.JSONFloat64 `json:"conversions"`
		Ctr             gensupport.JSONFloat64 `json:"ctr"`
		DaysToShip      gensupport.JSONFloat64 `json:"daysToShip"`
		ItemDaysToShip  gensupport.JSONFloat64 `json:"itemDaysToShip"`
		ItemFillRate    gensupport.JSONFloat64 `json:"itemFillRate"`
		ReturnRate      gensupport.JSONFloat64 `json:"returnRate"`
		UnshippedItems  gensupport.JSONFloat64 `json:"unshippedItems"`
		UnshippedOrders gensupport.JSONFloat64 `json:"unshippedOrders"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Aos = float64(s1.Aos)
	s.AovMicros = float64(s1.AovMicros)
	s.ConversionRate = float64(s1.ConversionRate)
	s.Conversions = float64(s1.Conversions)
	s.Ctr = float64(s1.Ctr)
	s.DaysToShip = float64(s1.DaysToShip)
	s.ItemDaysToShip = float64(s1.ItemDaysToShip)
	s.ItemFillRate = float64(s1.ItemFillRate)
	s.ReturnRate = float64(s1.ReturnRate)
	s.UnshippedItems = float64(s1.UnshippedItems)
	s.UnshippedOrders = float64(s1.UnshippedOrders)
	return nil
}

type MinimumOrderValueTable struct {
	StoreCodeSetWithMovs []*MinimumOrderValueTableStoreCodeSetWithMov `json:"storeCodeSetWithMovs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StoreCodeSetWithMovs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StoreCodeSetWithMovs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MinimumOrderValueTable) MarshalJSON() ([]byte, error) {
	type NoMethod MinimumOrderValueTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MinimumOrderValueTableStoreCodeSetWithMov: A list of store code sets sharing
// the same minimum order value. At least two sets are required and the last
// one must be empty, which signifies 'MOV for all other stores'. Each store
// code can only appear once across all the sets. All prices within a service
// must have the same currency.
type MinimumOrderValueTableStoreCodeSetWithMov struct {
	// StoreCodes: A list of unique store codes or empty for the catch all.
	StoreCodes []string `json:"storeCodes,omitempty"`
	// Value: The minimum order value for the given stores.
	Value *Price `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StoreCodes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StoreCodes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MinimumOrderValueTableStoreCodeSetWithMov) MarshalJSON() ([]byte, error) {
	type NoMethod MinimumOrderValueTableStoreCodeSetWithMov
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignal: Represents a merchant trade from which signals are
// extracted, e.g. shipping.
type OrderTrackingSignal struct {
	// CustomerShippingFee: The shipping fee of the order; this value should be set
	// to zero in the case of free shipping.
	CustomerShippingFee *PriceAmount `json:"customerShippingFee,omitempty"`
	// DeliveryPostalCode: Required. The delivery postal code, as a continuous
	// string without spaces or dashes, e.g. "95016". This field will be anonymized
	// in returned OrderTrackingSignal creation response.
	DeliveryPostalCode string `json:"deliveryPostalCode,omitempty"`
	// DeliveryRegionCode: Required. The [CLDR territory code]
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for the
	// shipping destination.
	DeliveryRegionCode string `json:"deliveryRegionCode,omitempty"`
	// LineItems: Information about line items in the order.
	LineItems []*OrderTrackingSignalLineItemDetails `json:"lineItems,omitempty"`
	// MerchantId: The Google merchant ID of this order tracking signal. This value
	// is optional. If left unset, the caller's merchant ID is used. You must
	// request access in order to provide data on behalf of another merchant. For
	// more information, see Submitting Order Tracking Signals
	// (/shopping-content/guides/order-tracking-signals).
	MerchantId int64 `json:"merchantId,omitempty,string"`
	// OrderCreatedTime: Required. The time when the order was created on the
	// merchant side. Include the year and timezone string, if available.
	OrderCreatedTime *DateTime `json:"orderCreatedTime,omitempty"`
	// OrderId: Required. The ID of the order on the merchant side. This field will
	// be hashed in returned OrderTrackingSignal creation response.
	OrderId string `json:"orderId,omitempty"`
	// OrderTrackingSignalId: Output only. The ID that uniquely identifies this
	// order tracking signal.
	OrderTrackingSignalId int64 `json:"orderTrackingSignalId,omitempty,string"`
	// ShipmentLineItemMapping: The mapping of the line items to the shipment
	// information.
	ShipmentLineItemMapping []*OrderTrackingSignalShipmentLineItemMapping `json:"shipmentLineItemMapping,omitempty"`
	// ShippingInfo: The shipping information for the order.
	ShippingInfo []*OrderTrackingSignalShippingInfo `json:"shippingInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomerShippingFee") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomerShippingFee") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrderTrackingSignal) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignal
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignalLineItemDetails: The line items of the order.
type OrderTrackingSignalLineItemDetails struct {
	// Brand: Brand of the product.
	Brand string `json:"brand,omitempty"`
	// Gtin: The Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`
	// LineItemId: Required. The ID for this line item.
	LineItemId string `json:"lineItemId,omitempty"`
	// Mpn: The manufacturer part number.
	Mpn string `json:"mpn,omitempty"`
	// ProductDescription: Plain text description of this product (deprecated:
	// Please use product_title instead).
	ProductDescription string `json:"productDescription,omitempty"`
	// ProductId: Required. The Content API REST ID of the product, in the form
	// channel:contentLanguage:targetCountry:offerId.
	ProductId string `json:"productId,omitempty"`
	// ProductTitle: Plain text title of this product.
	ProductTitle string `json:"productTitle,omitempty"`
	// Quantity: The quantity of the line item in the order.
	Quantity int64 `json:"quantity,omitempty,string"`
	// Sku: Merchant SKU for this item (deprecated).
	Sku string `json:"sku,omitempty"`
	// Upc: Universal product code for this item (deprecated: Please use GTIN
	// instead).
	Upc string `json:"upc,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrderTrackingSignalLineItemDetails) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignalLineItemDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignalShipmentLineItemMapping: Represents how many items are in
// the shipment for the given shipment_id and line_item_id.
type OrderTrackingSignalShipmentLineItemMapping struct {
	// LineItemId: Required. The line item ID.
	LineItemId string `json:"lineItemId,omitempty"`
	// Quantity: The line item quantity in the shipment.
	Quantity int64 `json:"quantity,omitempty,string"`
	// ShipmentId: Required. The shipment ID. This field will be hashed in returned
	// OrderTrackingSignal creation response.
	ShipmentId string `json:"shipmentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LineItemId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrderTrackingSignalShipmentLineItemMapping) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignalShipmentLineItemMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignalShippingInfo: The shipping information for the order.
type OrderTrackingSignalShippingInfo struct {
	// ActualDeliveryTime: The time when the shipment was actually delivered.
	// Include the year and timezone string, if available. This field is required,
	// if one of the following fields is absent: tracking_id or carrier_name.
	ActualDeliveryTime *DateTime `json:"actualDeliveryTime,omitempty"`
	// CarrierName: The name of the shipping carrier for the delivery. This field
	// is required if one of the following fields is absent:
	// earliest_delivery_promise_time, latest_delivery_promise_time, and
	// actual_delivery_time.
	CarrierName string `json:"carrierName,omitempty"`
	// CarrierServiceName: The service type for fulfillment, e.g., GROUND,
	// FIRST_CLASS, etc.
	CarrierServiceName string `json:"carrierServiceName,omitempty"`
	// EarliestDeliveryPromiseTime: The earliest delivery promised time. Include
	// the year and timezone string, if available. This field is required, if one
	// of the following fields is absent: tracking_id or carrier_name.
	EarliestDeliveryPromiseTime *DateTime `json:"earliestDeliveryPromiseTime,omitempty"`
	// LatestDeliveryPromiseTime: The latest delivery promised time. Include the
	// year and timezone string, if available. This field is required, if one of
	// the following fields is absent: tracking_id or carrier_name.
	LatestDeliveryPromiseTime *DateTime `json:"latestDeliveryPromiseTime,omitempty"`
	// OriginPostalCode: The origin postal code, as a continuous string without
	// spaces or dashes, e.g. "95016". This field will be anonymized in returned
	// OrderTrackingSignal creation response.
	OriginPostalCode string `json:"originPostalCode,omitempty"`
	// OriginRegionCode: The [CLDR territory code]
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for the
	// shipping origin.
	OriginRegionCode string `json:"originRegionCode,omitempty"`
	// ShipmentId: Required. The shipment ID. This field will be hashed in returned
	// OrderTrackingSignal creation response.
	ShipmentId string `json:"shipmentId,omitempty"`
	// ShippedTime: The time when the shipment was shipped. Include the year and
	// timezone string, if available.
	ShippedTime *DateTime `json:"shippedTime,omitempty"`
	// ShippingStatus: The status of the shipment.
	//
	// Possible values:
	//   "SHIPPING_STATE_UNSPECIFIED" - The shipping status is not known to
	// merchant.
	//   "SHIPPED" - All items are shipped.
	//   "DELIVERED" - The shipment is already delivered.
	ShippingStatus string `json:"shippingStatus,omitempty"`
	// TrackingId: The tracking ID of the shipment. This field is required if one
	// of the following fields is absent: earliest_delivery_promise_time,
	// latest_delivery_promise_time, and actual_delivery_time.
	TrackingId string `json:"trackingId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActualDeliveryTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActualDeliveryTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrderTrackingSignalShippingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignalShippingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PaymentServiceProviderLinkInfo: Additional information required for
// PAYMENT_SERVICE_PROVIDER link type.
type PaymentServiceProviderLinkInfo struct {
	// ExternalAccountBusinessCountry: The business country of the merchant account
	// as identified by the third party service provider.
	ExternalAccountBusinessCountry string `json:"externalAccountBusinessCountry,omitempty"`
	// ExternalAccountId: The id used by the third party service provider to
	// identify the merchant.
	ExternalAccountId string `json:"externalAccountId,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ExternalAccountBusinessCountry") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalAccountBusinessCountry")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PaymentServiceProviderLinkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PaymentServiceProviderLinkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PickupCarrierService struct {
	// CarrierName: The name of the pickup carrier (for example, "UPS").
	// Required.
	CarrierName string `json:"carrierName,omitempty"`
	// ServiceName: The name of the pickup service (for example, "Access point").
	// Required.
	ServiceName string `json:"serviceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CarrierName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CarrierName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PickupCarrierService) MarshalJSON() ([]byte, error) {
	type NoMethod PickupCarrierService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PickupServicesPickupService struct {
	// CarrierName: The name of the carrier (for example, "UPS"). Always present.
	CarrierName string `json:"carrierName,omitempty"`
	// Country: The CLDR country code of the carrier (for example, "US"). Always
	// present.
	Country string `json:"country,omitempty"`
	// ServiceName: The name of the pickup service (for example, "Access point").
	// Always present.
	ServiceName string `json:"serviceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CarrierName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CarrierName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PickupServicesPickupService) MarshalJSON() ([]byte, error) {
	type NoMethod PickupServicesPickupService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*PosCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PosCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// Inventory: The inventory to submit. This should be set only if the method is
	// `inventory`.
	Inventory *PosInventory `json:"inventory,omitempty"`
	// MerchantId: The ID of the POS data provider.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "delete" -
	// "get" - "insert" - "inventory" - "sale"
	Method string `json:"method,omitempty"`
	// Sale: The sale information to submit. This should be set only if the method
	// is `sale`.
	Sale *PosSale `json:"sale,omitempty"`
	// Store: The store information to submit. This should be set only if the
	// method is `insert`.
	Store *PosStore `json:"store,omitempty"`
	// StoreCode: The store code. This should be set only if the method is `delete`
	// or `get`.
	StoreCode string `json:"storeCode,omitempty"`
	// TargetMerchantId: The ID of the account for which to get/submit data.
	TargetMerchantId uint64 `json:"targetMerchantId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod PosCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*PosCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#posCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PosCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`
	// Inventory: The updated inventory information.
	Inventory *PosInventory `json:"inventory,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#posCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// Sale: The updated sale information.
	Sale *PosSale `json:"sale,omitempty"`
	// Store: The retrieved or updated store information.
	Store *PosStore `json:"store,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod PosCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosDataProviders struct {
	// Country: Country code.
	Country string `json:"country,omitempty"`
	// PosDataProviders: A list of POS data providers.
	PosDataProviders []*PosDataProvidersPosDataProvider `json:"posDataProviders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosDataProviders) MarshalJSON() ([]byte, error) {
	type NoMethod PosDataProviders
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosDataProvidersPosDataProvider struct {
	// DisplayName: The display name of Pos data Provider.
	DisplayName string `json:"displayName,omitempty"`
	// FullName: The full name of this POS data Provider.
	FullName string `json:"fullName,omitempty"`
	// ProviderId: The ID of the account.
	ProviderId uint64 `json:"providerId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosDataProvidersPosDataProvider) MarshalJSON() ([]byte, error) {
	type NoMethod PosDataProvidersPosDataProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PosInventory: The absolute quantity of an item available at the given store.
type PosInventory struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for the
	// item.
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`
	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#posInventory"
	Kind string `json:"kind,omitempty"`
	// PickupMethod: Optional. Supported pickup method for this offer. Unless the
	// value is "not supported", this field must be submitted together with
	// `pickupSla`. For accepted attribute values, see the local product inventory
	// feed specification (https://support.google.com/merchants/answer/3061342).
	PickupMethod string `json:"pickupMethod,omitempty"`
	// PickupSla: Optional. Expected date that an order will be ready for pickup
	// relative to the order date. Must be submitted together with `pickupMethod`.
	// For accepted attribute values, see the local product inventory feed
	// specification (https://support.google.com/merchants/answer/3061342).
	PickupSla string `json:"pickupSla,omitempty"`
	// Price: Required. The current price of the item.
	Price *Price `json:"price,omitempty"`
	// Quantity: Required. The available quantity of the item.
	Quantity int64 `json:"quantity,omitempty,string"`
	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted through the API or the code of the store in a Business
	// Profile.
	StoreCode string `json:"storeCode,omitempty"`
	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`
	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosInventory) MarshalJSON() ([]byte, error) {
	type NoMethod PosInventory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosInventoryRequest struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for the
	// item.
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`
	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`
	// PickupMethod: Optional. Supported pickup method for this offer. Unless the
	// value is "not supported", this field must be submitted together with
	// `pickupSla`. For accepted attribute values, see the local product inventory
	// feed specification (https://support.google.com/merchants/answer/3061342).
	PickupMethod string `json:"pickupMethod,omitempty"`
	// PickupSla: Optional. Expected date that an order will be ready for pickup
	// relative to the order date. Must be submitted together with `pickupMethod`.
	// For accepted attribute values, see the local product inventory feed
	// specification (https://support.google.com/merchants/answer/3061342).
	PickupSla string `json:"pickupSla,omitempty"`
	// Price: Required. The current price of the item.
	Price *Price `json:"price,omitempty"`
	// Quantity: Required. The available quantity of the item.
	Quantity int64 `json:"quantity,omitempty,string"`
	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted through the API or the code of the store in a Business
	// Profile.
	StoreCode string `json:"storeCode,omitempty"`
	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`
	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosInventoryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PosInventoryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosInventoryResponse struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for the
	// item.
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`
	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#posInventoryResponse".
	Kind string `json:"kind,omitempty"`
	// PickupMethod: Optional. Supported pickup method for this offer. Unless the
	// value is "not supported", this field must be submitted together with
	// `pickupSla`. For accepted attribute values, see the local product inventory
	// feed specification (https://support.google.com/merchants/answer/3061342).
	PickupMethod string `json:"pickupMethod,omitempty"`
	// PickupSla: Optional. Expected date that an order will be ready for pickup
	// relative to the order date. Must be submitted together with `pickupMethod`.
	// For accepted attribute values, see the local product inventory feed
	// specification (https://support.google.com/merchants/answer/3061342).
	PickupSla string `json:"pickupSla,omitempty"`
	// Price: Required. The current price of the item.
	Price *Price `json:"price,omitempty"`
	// Quantity: Required. The available quantity of the item.
	Quantity int64 `json:"quantity,omitempty,string"`
	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted through the API or the code of the store in a Business
	// Profile.
	StoreCode string `json:"storeCode,omitempty"`
	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`
	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosInventoryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PosInventoryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#posListResponse".
	Kind      string      `json:"kind,omitempty"`
	Resources []*PosStore `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PosListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PosSale: The change of the available quantity of an item at the given store.
type PosSale struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for the
	// item.
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`
	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#posSale"
	Kind string `json:"kind,omitempty"`
	// Price: Required. The price of the item.
	Price *Price `json:"price,omitempty"`
	// Quantity: Required. The relative change of the available quantity. Negative
	// for items returned.
	Quantity int64 `json:"quantity,omitempty,string"`
	// SaleId: A unique ID to group items from the same sale event.
	SaleId string `json:"saleId,omitempty"`
	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted through the API or the code of the store in a Business
	// Profile.
	StoreCode string `json:"storeCode,omitempty"`
	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`
	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosSale) MarshalJSON() ([]byte, error) {
	type NoMethod PosSale
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosSaleRequest struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for the
	// item.
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`
	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`
	// Price: Required. The price of the item.
	Price *Price `json:"price,omitempty"`
	// Quantity: Required. The relative change of the available quantity. Negative
	// for items returned.
	Quantity int64 `json:"quantity,omitempty,string"`
	// SaleId: A unique ID to group items from the same sale event.
	SaleId string `json:"saleId,omitempty"`
	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted through the API or the code of the store in a Business
	// Profile.
	StoreCode string `json:"storeCode,omitempty"`
	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`
	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosSaleRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PosSaleRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PosSaleResponse struct {
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for the
	// item.
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// Gtin: Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`
	// ItemId: Required. A unique identifier for the item.
	ItemId string `json:"itemId,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#posSaleResponse".
	Kind string `json:"kind,omitempty"`
	// Price: Required. The price of the item.
	Price *Price `json:"price,omitempty"`
	// Quantity: Required. The relative change of the available quantity. Negative
	// for items returned.
	Quantity int64 `json:"quantity,omitempty,string"`
	// SaleId: A unique ID to group items from the same sale event.
	SaleId string `json:"saleId,omitempty"`
	// StoreCode: Required. The identifier of the merchant's store. Either a
	// `storeCode` inserted through the API or the code of the store in a Business
	// Profile.
	StoreCode string `json:"storeCode,omitempty"`
	// TargetCountry: Required. The CLDR territory code for the item.
	TargetCountry string `json:"targetCountry,omitempty"`
	// Timestamp: Required. The inventory timestamp, in ISO 8601 format.
	Timestamp string `json:"timestamp,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosSaleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PosSaleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PosStore: Store resource.
type PosStore struct {
	// GcidCategory: The business type of the store.
	GcidCategory []string `json:"gcidCategory,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#posStore"
	Kind string `json:"kind,omitempty"`
	// MatchingStatus: Output only. The matching status of POS store and Google
	// Business Profile store. Possible values are: - "matched": The POS store is
	// successfully matched with the Google Business Profile store. - "failed":
	// The POS store is not matched with the Google Business Profile store. See
	// matching_status_hint for further details. Note that there is up to 48 hours
	// propagation delay for changes in Merchant Center (e.g. creation of new
	// account, accounts linking) and Google Business Profile (e.g. store address
	// update) which may affect the matching status. In such cases, after a delay
	// call pos.list
	// (https://developers.google.com/shopping-content/reference/rest/v2.1/pos/list)
	// to retrieve the updated matching status.
	MatchingStatus string `json:"matchingStatus,omitempty"`
	// MatchingStatusHint: Output only. The hint of why the matching has failed.
	// This is only set when matching_status=failed. Possible values are: -
	// "linked-store-not-found": There aren't any Google Business Profile stores
	// available for matching. Connect your Merchant Center account with the Google
	// Business Profile account. Or add a new Google Business Profile store
	// corresponding to the POS store. - "store-match-not-found": The provided
	// POS store couldn't be matched to any of the connected Google Business
	// Profile stores. Merchant Center account is connected correctly and stores
	// are available on Google Business Profile, but POS store location address
	// does not match with Google Business Profile stores' addresses. Update POS
	// store address or Google Business Profile store address to match correctly. -
	// "store-match-unverified": The provided POS store couldn't be matched to
	// any of the connected Google Business Profile stores, as the matched Google
	// Business Profile store is unverified. Go through the Google Business Profile
	// verification process to match correctly.
	MatchingStatusHint string `json:"matchingStatusHint,omitempty"`
	// PhoneNumber: The store phone number.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PlaceId: The Google Place Id of the store location.
	PlaceId string `json:"placeId,omitempty"`
	// StoreAddress: Required. The street address of the store.
	StoreAddress string `json:"storeAddress,omitempty"`
	// StoreCode: Required. A store identifier that is unique for the given
	// merchant.
	StoreCode string `json:"storeCode,omitempty"`
	// StoreName: The merchant or store name.
	StoreName string `json:"storeName,omitempty"`
	// WebsiteUrl: The website url for the store or merchant.
	WebsiteUrl string `json:"websiteUrl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GcidCategory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcidCategory") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PosStore) MarshalJSON() ([]byte, error) {
	type NoMethod PosStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PostalCodeGroup struct {
	// Country: The CLDR territory code of the country the postal code group
	// applies to. Required.
	Country string `json:"country,omitempty"`
	// Name: The name of the postal code group, referred to in headers. Required.
	Name string `json:"name,omitempty"`
	// PostalCodeRanges: A range of postal codes. Required.
	PostalCodeRanges []*PostalCodeRange `json:"postalCodeRanges,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostalCodeGroup) MarshalJSON() ([]byte, error) {
	type NoMethod PostalCodeGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PostalCodeRange struct {
	// PostalCodeRangeBegin: A postal code or a pattern of the form `prefix*`
	// denoting the inclusive lower bound of the range defining the area. Examples
	// values: "94108", "9410*", "9*". Required.
	PostalCodeRangeBegin string `json:"postalCodeRangeBegin,omitempty"`
	// PostalCodeRangeEnd: A postal code or a pattern of the form `prefix*`
	// denoting the inclusive upper bound of the range defining the area. It must
	// have the same length as `postalCodeRangeBegin`: if `postalCodeRangeBegin` is
	// a postal code then `postalCodeRangeEnd` must be a postal code too; if
	// `postalCodeRangeBegin` is a pattern then `postalCodeRangeEnd` must be a
	// pattern with the same prefix length. Optional: if not set, then the area is
	// defined as being all the postal codes matching `postalCodeRangeBegin`.
	PostalCodeRangeEnd string `json:"postalCodeRangeEnd,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostalCodeRangeBegin") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostalCodeRangeBegin") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PostalCodeRange) MarshalJSON() ([]byte, error) {
	type NoMethod PostalCodeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Price struct {
	// Currency: The currency of the price.
	Currency string `json:"currency,omitempty"`
	// Value: The price represented as a number.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Currency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Currency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PriceAmount: The price represented as a number and currency.
type PriceAmount struct {
	// Currency: The currency of the price.
	Currency string `json:"currency,omitempty"`
	// Value: The price represented as a number.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Currency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Currency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PriceAmount) MarshalJSON() ([]byte, error) {
	type NoMethod PriceAmount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PriceCompetitiveness: Price competitiveness fields requested by the merchant
// in the query. Field values are only set if the merchant queries
// `PriceCompetitivenessProductView`.
// https://support.google.com/merchants/answer/9626903
type PriceCompetitiveness struct {
	// BenchmarkPriceCurrencyCode: The price benchmark currency (ISO 4217 code).
	BenchmarkPriceCurrencyCode string `json:"benchmarkPriceCurrencyCode,omitempty"`
	// BenchmarkPriceMicros: The latest available price benchmark in micros (1
	// millionth of a standard unit, 1 USD = 1000000 micros) for the product's
	// catalog in the benchmark country.
	BenchmarkPriceMicros int64 `json:"benchmarkPriceMicros,omitempty,string"`
	// CountryCode: The country of the price benchmark (ISO 3166 code).
	CountryCode string `json:"countryCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BenchmarkPriceCurrencyCode")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BenchmarkPriceCurrencyCode") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PriceCompetitiveness) MarshalJSON() ([]byte, error) {
	type NoMethod PriceCompetitiveness
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PriceInsights: Price insights fields requested by the merchant in the query.
// Field values are only set if the merchant queries
// `PriceInsightsProductView`.
// https://support.google.com/merchants/answer/11916926
type PriceInsights struct {
	// Effectiveness: The predicted effectiveness of applying the price suggestion,
	// bucketed.
	//
	// Possible values:
	//   "EFFECTIVENESS_UNSPECIFIED" - Effectiveness is unknown.
	//   "LOW" - Effectiveness is low.
	//   "MEDIUM" - Effectiveness is medium.
	//   "HIGH" - Effectiveness is high.
	Effectiveness string `json:"effectiveness,omitempty"`
	// PredictedClicksChangeFraction: The predicted change in clicks as a fraction
	// after introducing the suggested price compared to current active price. For
	// example, 0.05 is a 5% predicted increase in clicks.
	PredictedClicksChangeFraction float64 `json:"predictedClicksChangeFraction,omitempty"`
	// PredictedConversionsChangeFraction: The predicted change in conversions as a
	// fraction after introducing the suggested price compared to current active
	// price. For example, 0.05 is a 5% predicted increase in conversions).
	PredictedConversionsChangeFraction float64 `json:"predictedConversionsChangeFraction,omitempty"`
	// PredictedGrossProfitChangeFraction: *Deprecated*: This field is no longer
	// supported and will start returning 0. The predicted change in gross profit
	// as a fraction after introducing the suggested price compared to current
	// active price. For example, 0.05 is a 5% predicted increase in gross profit.
	PredictedGrossProfitChangeFraction float64 `json:"predictedGrossProfitChangeFraction,omitempty"`
	// PredictedImpressionsChangeFraction: The predicted change in impressions as a
	// fraction after introducing the suggested price compared to current active
	// price. For example, 0.05 is a 5% predicted increase in impressions.
	PredictedImpressionsChangeFraction float64 `json:"predictedImpressionsChangeFraction,omitempty"`
	// PredictedMonthlyGrossProfitChangeCurrencyCode: *Deprecated*: This field is
	// no longer supported and will start returning USD for all requests. The
	// predicted monthly gross profit change currency (ISO 4217 code).
	PredictedMonthlyGrossProfitChangeCurrencyCode string `json:"predictedMonthlyGrossProfitChangeCurrencyCode,omitempty"`
	// PredictedMonthlyGrossProfitChangeMicros: *Deprecated*: This field is no
	// longer supported and will start returning 0. The predicted change in gross
	// profit in micros (1 millionth of a standard unit, 1 USD = 1000000 micros)
	// after introducing the suggested price for a month compared to current active
	// price.
	PredictedMonthlyGrossProfitChangeMicros int64 `json:"predictedMonthlyGrossProfitChangeMicros,omitempty,string"`
	// SuggestedPriceCurrencyCode: The suggested price currency (ISO 4217 code).
	SuggestedPriceCurrencyCode string `json:"suggestedPriceCurrencyCode,omitempty"`
	// SuggestedPriceMicros: The latest suggested price in micros (1 millionth of a
	// standard unit, 1 USD = 1000000 micros) for the product.
	SuggestedPriceMicros int64 `json:"suggestedPriceMicros,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Effectiveness") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Effectiveness") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PriceInsights) MarshalJSON() ([]byte, error) {
	type NoMethod PriceInsights
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *PriceInsights) UnmarshalJSON(data []byte) error {
	type NoMethod PriceInsights
	var s1 struct {
		PredictedClicksChangeFraction      gensupport.JSONFloat64 `json:"predictedClicksChangeFraction"`
		PredictedConversionsChangeFraction gensupport.JSONFloat64 `json:"predictedConversionsChangeFraction"`
		PredictedGrossProfitChangeFraction gensupport.JSONFloat64 `json:"predictedGrossProfitChangeFraction"`
		PredictedImpressionsChangeFraction gensupport.JSONFloat64 `json:"predictedImpressionsChangeFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PredictedClicksChangeFraction = float64(s1.PredictedClicksChangeFraction)
	s.PredictedConversionsChangeFraction = float64(s1.PredictedConversionsChangeFraction)
	s.PredictedGrossProfitChangeFraction = float64(s1.PredictedGrossProfitChangeFraction)
	s.PredictedImpressionsChangeFraction = float64(s1.PredictedImpressionsChangeFraction)
	return nil
}

// Product:  Required product attributes are primarily defined by the product
// data specification. See the Product Data Specification Help Center article
// for information. Product data. After inserting, updating, or deleting a
// product, it may take several minutes before changes take effect.
type Product struct {
	// AdditionalImageLinks: Additional URLs of images of the item.
	AdditionalImageLinks []string `json:"additionalImageLinks,omitempty"`
	// AdditionalSizeType: Additional cut of the item. Used together with size_type
	// to represent combined size types for apparel items.
	AdditionalSizeType string `json:"additionalSizeType,omitempty"`
	// AdsGrouping: Used to group items in an arbitrary way. Only for CPA%,
	// discouraged otherwise.
	AdsGrouping string `json:"adsGrouping,omitempty"`
	// AdsLabels: Similar to ads_grouping, but only works on CPC.
	AdsLabels []string `json:"adsLabels,omitempty"`
	// AdsRedirect: Allows advertisers to override the item URL when the product is
	// shown within the context of Product Ads.
	AdsRedirect string `json:"adsRedirect,omitempty"`
	// Adult: Should be set to true if the item is targeted towards adults.
	Adult bool `json:"adult,omitempty"`
	// AgeGroup: Target age group of the item.
	AgeGroup string `json:"ageGroup,omitempty"`
	// AutoPricingMinPrice: A safeguard in the Automated Discounts
	// (//support.google.com/merchants/answer/10295759) and Dynamic Promotions
	// (//support.google.com/merchants/answer/13949249) projects, ensuring that
	// discounts on merchants' offers do not fall below this value, thereby
	// preserving the offer's value and profitability.
	AutoPricingMinPrice *Price `json:"autoPricingMinPrice,omitempty"`
	// Availability: Availability status of the item.
	Availability string `json:"availability,omitempty"`
	// AvailabilityDate: The day a pre-ordered product becomes available for
	// delivery, in ISO 8601 format.
	AvailabilityDate string `json:"availabilityDate,omitempty"`
	// Brand: Brand of the item.
	Brand string `json:"brand,omitempty"`
	// CanonicalLink: URL for the canonical version of your item's landing page.
	CanonicalLink string `json:"canonicalLink,omitempty"`
	// Certifications: Product certification
	// (https://support.google.com/merchants/answer/13528839), introduced for EU
	// energy efficiency labeling compliance using the EU EPREL
	// (https://eprel.ec.europa.eu/screen/home) database.
	Certifications []*ProductCertification `json:"certifications,omitempty"`
	// Channel: Required. The item's channel (online or local). Acceptable values
	// are: - "local" - "online"
	Channel string `json:"channel,omitempty"`
	// CloudExportAdditionalProperties: Extra fields to export to the Cloud Retail
	// program.
	CloudExportAdditionalProperties []*CloudExportAdditionalProperties `json:"cloudExportAdditionalProperties,omitempty"`
	// Color: Color of the item.
	Color string `json:"color,omitempty"`
	// Condition: Condition or state of the item.
	Condition string `json:"condition,omitempty"`
	// ContentLanguage: Required. The two-letter ISO 639-1 language code for the
	// item.
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// CostOfGoodsSold: Cost of goods sold. Used for gross profit reporting.
	CostOfGoodsSold *Price `json:"costOfGoodsSold,omitempty"`
	// CustomAttributes: A list of custom (merchant-provided) attributes. It can
	// also be used for submitting any attribute of the feed specification in its
	// generic form (for example, `{ "name": "size type", "value": "regular" }`).
	// This is useful for submitting attributes not explicitly exposed by the API,
	// such as additional attributes used for Buy on Google (formerly known as
	// Shopping Actions).
	CustomAttributes []*CustomAttribute `json:"customAttributes,omitempty"`
	// CustomLabel0: Custom label 0 for custom grouping of items in a Shopping
	// campaign.
	CustomLabel0 string `json:"customLabel0,omitempty"`
	// CustomLabel1: Custom label 1 for custom grouping of items in a Shopping
	// campaign.
	CustomLabel1 string `json:"customLabel1,omitempty"`
	// CustomLabel2: Custom label 2 for custom grouping of items in a Shopping
	// campaign.
	CustomLabel2 string `json:"customLabel2,omitempty"`
	// CustomLabel3: Custom label 3 for custom grouping of items in a Shopping
	// campaign.
	CustomLabel3 string `json:"customLabel3,omitempty"`
	// CustomLabel4: Custom label 4 for custom grouping of items in a Shopping
	// campaign.
	CustomLabel4 string `json:"customLabel4,omitempty"`
	// Description: Description of the item.
	Description string `json:"description,omitempty"`
	// DisclosureDate: The date time when an offer becomes visible in search
	// results across Google’s YouTube surfaces, in ISO 8601
	// (http://en.wikipedia.org/wiki/ISO_8601) format. See Disclosure date
	// (https://support.google.com/merchants/answer/13034208) for more information.
	DisclosureDate string `json:"disclosureDate,omitempty"`
	// DisplayAdsId: An identifier for an item for dynamic remarketing campaigns.
	DisplayAdsId string `json:"displayAdsId,omitempty"`
	// DisplayAdsLink: URL directly to your item's landing page for dynamic
	// remarketing campaigns.
	DisplayAdsLink string `json:"displayAdsLink,omitempty"`
	// DisplayAdsSimilarIds: Advertiser-specified recommendations.
	DisplayAdsSimilarIds []string `json:"displayAdsSimilarIds,omitempty"`
	// DisplayAdsTitle: Title of an item for dynamic remarketing campaigns.
	DisplayAdsTitle string `json:"displayAdsTitle,omitempty"`
	// DisplayAdsValue: Offer margin for dynamic remarketing campaigns.
	DisplayAdsValue float64 `json:"displayAdsValue,omitempty"`
	// EnergyEfficiencyClass: The energy efficiency class as defined in EU
	// directive 2010/30/EU.
	EnergyEfficiencyClass string `json:"energyEfficiencyClass,omitempty"`
	// ExcludedDestinations: The list of destinations to exclude
	// (//support.google.com/merchants/answer/6324486) for this target (corresponds
	// to cleared check boxes in Merchant Center). Products that are excluded from
	// all destinations for more than 7 days are automatically deleted.
	ExcludedDestinations []string `json:"excludedDestinations,omitempty"`
	// ExpirationDate: Date on which the item should expire, as specified upon
	// insertion, in ISO 8601 format. The actual expiration date in Google Shopping
	// is exposed in `productstatuses` as `googleExpirationDate` and might be
	// earlier if `expirationDate` is too far in the future.
	ExpirationDate string `json:"expirationDate,omitempty"`
	// ExternalSellerId: Required for multi-seller accounts. Use this attribute if
	// you're a marketplace uploading products for various sellers to your
	// multi-seller account.
	ExternalSellerId string `json:"externalSellerId,omitempty"`
	// FeedLabel: Feed label for the item. Either `targetCountry` or `feedLabel` is
	// required. Must be less than or equal to 20 uppercase letters (A-Z), numbers
	// (0-9), and dashes (-).
	FeedLabel string `json:"feedLabel,omitempty"`
	// FreeShippingThreshold: Optional. Conditions to be met for a product to have
	// free shipping.
	FreeShippingThreshold []*FreeShippingThreshold `json:"freeShippingThreshold,omitempty"`
	// Gender: Target gender of the item.
	Gender string `json:"gender,omitempty"`
	// GoogleProductCategory: Google's category of the item (see Google product
	// taxonomy (https://support.google.com/merchants/answer/1705911)). When
	// querying products, this field will contain the user provided value. There is
	// currently no way to get back the auto assigned google product categories
	// through the API.
	GoogleProductCategory string `json:"googleProductCategory,omitempty"`
	// Gtin: Global Trade Item Number (GTIN) of the item.
	Gtin string `json:"gtin,omitempty"`
	// Id: The REST ID of the product. Content API methods that operate on products
	// take this as their `productId` parameter. The REST ID for a product has one
	// of the 2 forms channel:contentLanguage: targetCountry: offerId or
	// channel:contentLanguage:feedLabel: offerId.
	Id string `json:"id,omitempty"`
	// IdentifierExists: False when the item does not have unique product
	// identifiers appropriate to its category, such as GTIN, MPN, and brand.
	// Required according to the Unique Product Identifier Rules for all target
	// countries except for Canada.
	IdentifierExists bool `json:"identifierExists,omitempty"`
	// ImageLink: URL of an image of the item.
	ImageLink string `json:"imageLink,omitempty"`
	// IncludedDestinations: The list of destinations to include
	// (//support.google.com/merchants/answer/7501026) for this target (corresponds
	// to checked check boxes in Merchant Center). Default destinations are always
	// included unless provided in `excludedDestinations`.
	IncludedDestinations []string `json:"includedDestinations,omitempty"`
	// Installment: Number and amount of installments to pay for an item.
	Installment *Installment `json:"installment,omitempty"`
	// IsBundle: Whether the item is a merchant-defined bundle. A bundle is a
	// custom grouping of different products sold by a merchant for a single price.
	IsBundle bool `json:"isBundle,omitempty"`
	// ItemGroupId: Shared identifier for all variants of the same product.
	ItemGroupId string `json:"itemGroupId,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#product"
	Kind string `json:"kind,omitempty"`
	// LifestyleImageLinks: Additional URLs of lifestyle images of the item. Used
	// to explicitly identify images that showcase your item in a real-world
	// context. See the Help Center article for more information.
	LifestyleImageLinks []string `json:"lifestyleImageLinks,omitempty"`
	// Link: URL directly linking to your item's page on your website.
	Link string `json:"link,omitempty"`
	// LinkTemplate: URL template for merchant hosted local storefront.
	LinkTemplate string `json:"linkTemplate,omitempty"`
	// LoyaltyProgram: Loyalty program information that is used to surface loyalty
	// benefits ( for example, better pricing, points, etc) to the user of this
	// item. This signular field points to the latest uploaded loyalty program
	// info. This field will be deprecated in the coming weeks and should not be
	// used in favor of the plural 'LoyaltyProgram' field below.
	LoyaltyProgram *LoyaltyProgram `json:"loyaltyProgram,omitempty"`
	// LoyaltyPrograms: Optional. A list of loyalty program information that is
	// used to surface loyalty benefits (for example, better pricing, points, etc)
	// to the user of this item.
	LoyaltyPrograms []*LoyaltyProgram `json:"loyaltyPrograms,omitempty"`
	// Material: The material of which the item is made.
	Material string `json:"material,omitempty"`
	// MaxEnergyEfficiencyClass: The energy efficiency class as defined in EU
	// directive 2010/30/EU.
	MaxEnergyEfficiencyClass string `json:"maxEnergyEfficiencyClass,omitempty"`
	// MaxHandlingTime: Maximal product handling time (in business days).
	MaxHandlingTime int64 `json:"maxHandlingTime,omitempty,string"`
	// MinEnergyEfficiencyClass: The energy efficiency class as defined in EU
	// directive 2010/30/EU.
	MinEnergyEfficiencyClass string `json:"minEnergyEfficiencyClass,omitempty"`
	// MinHandlingTime: Minimal product handling time (in business days).
	MinHandlingTime int64 `json:"minHandlingTime,omitempty,string"`
	// MobileLink: URL for the mobile-optimized version of your item's landing
	// page.
	MobileLink string `json:"mobileLink,omitempty"`
	// MobileLinkTemplate: URL template for merchant hosted local storefront
	// optimized for mobile devices.
	MobileLinkTemplate string `json:"mobileLinkTemplate,omitempty"`
	// Mpn: Manufacturer Part Number (MPN) of the item.
	Mpn string `json:"mpn,omitempty"`
	// Multipack: The number of identical products in a merchant-defined multipack.
	Multipack int64 `json:"multipack,omitempty,string"`
	// OfferId: Required. A unique identifier for the item. Leading and trailing
	// whitespaces are stripped and multiple whitespaces are replaced by a single
	// whitespace upon submission. Only valid unicode characters are accepted. See
	// the products feed specification for details. *Note:* Content API methods
	// that operate on products take the REST ID of the product, *not* this
	// identifier.
	OfferId string `json:"offerId,omitempty"`
	// Pattern: The item's pattern (for example, polka dots).
	Pattern string `json:"pattern,omitempty"`
	// Pause: Publication of this item should be temporarily paused. Acceptable
	// values are: - "ads"
	Pause string `json:"pause,omitempty"`
	// PickupMethod: The pick up option for the item. Acceptable values are: -
	// "buy" - "reserve" - "ship to store" - "not supported"
	PickupMethod string `json:"pickupMethod,omitempty"`
	// PickupSla: Item store pickup timeline. Acceptable values are: - "same day"
	// - "next day" - "2-day" - "3-day" - "4-day" - "5-day" - "6-day" -
	// "7-day" - "multi-week"
	PickupSla string `json:"pickupSla,omitempty"`
	// Price: Price of the item.
	Price *Price `json:"price,omitempty"`
	// ProductDetails: Technical specification or additional product details.
	ProductDetails []*ProductProductDetail `json:"productDetails,omitempty"`
	// ProductHeight: The height of the product in the units provided. The value
	// must be between 0 (exclusive) and 3000 (inclusive).
	ProductHeight *ProductDimension `json:"productHeight,omitempty"`
	// ProductHighlights: Bullet points describing the most relevant highlights of
	// a product.
	ProductHighlights []string `json:"productHighlights,omitempty"`
	// ProductLength: The length of the product in the units provided. The value
	// must be between 0 (exclusive) and 3000 (inclusive).
	ProductLength *ProductDimension `json:"productLength,omitempty"`
	// ProductTypes: Categories of the item (formatted as in product data
	// specification).
	ProductTypes []string `json:"productTypes,omitempty"`
	// ProductWeight: The weight of the product in the units provided. The value
	// must be between 0 (exclusive) and 2000 (inclusive).
	ProductWeight *ProductWeight `json:"productWeight,omitempty"`
	// ProductWidth: The width of the product in the units provided. The value must
	// be between 0 (exclusive) and 3000 (inclusive).
	ProductWidth *ProductDimension `json:"productWidth,omitempty"`
	// PromotionIds: The unique ID of a promotion.
	PromotionIds []string `json:"promotionIds,omitempty"`
	// SalePrice: Advertised sale price of the item.
	SalePrice *Price `json:"salePrice,omitempty"`
	// SalePriceEffectiveDate: Date range during which the item is on sale (see
	// product data specification ).
	SalePriceEffectiveDate string `json:"salePriceEffectiveDate,omitempty"`
	// SellOnGoogleQuantity: The quantity of the product that is available for
	// selling on Google. Supported only for online products.
	SellOnGoogleQuantity int64 `json:"sellOnGoogleQuantity,omitempty,string"`
	// Shipping: Shipping rules.
	Shipping []*ProductShipping `json:"shipping,omitempty"`
	// ShippingHeight: Height of the item for shipping.
	ShippingHeight *ProductShippingDimension `json:"shippingHeight,omitempty"`
	// ShippingLabel: The shipping label of the product, used to group product in
	// account-level shipping rules.
	ShippingLabel string `json:"shippingLabel,omitempty"`
	// ShippingLength: Length of the item for shipping.
	ShippingLength *ProductShippingDimension `json:"shippingLength,omitempty"`
	// ShippingWeight: Weight of the item for shipping.
	ShippingWeight *ProductShippingWeight `json:"shippingWeight,omitempty"`
	// ShippingWidth: Width of the item for shipping.
	ShippingWidth *ProductShippingDimension `json:"shippingWidth,omitempty"`
	// ShoppingAdsExcludedCountries: List of country codes (ISO 3166-1 alpha-2) to
	// exclude the offer from Shopping Ads destination. Countries from this list
	// are removed from countries configured in MC feed settings.
	ShoppingAdsExcludedCountries []string `json:"shoppingAdsExcludedCountries,omitempty"`
	// SizeSystem: System in which the size is specified. Recommended for apparel
	// items.
	SizeSystem string `json:"sizeSystem,omitempty"`
	// SizeType: The cut of the item. Recommended for apparel items.
	SizeType string `json:"sizeType,omitempty"`
	// Sizes: Size of the item. Only one value is allowed. For variants with
	// different sizes, insert a separate product for each size with the same
	// `itemGroupId` value (see size definition).
	Sizes []string `json:"sizes,omitempty"`
	// Source: Output only. The source of the offer, that is, how the offer was
	// created. Acceptable values are: - "api" - "crawl" - "feed"
	Source string `json:"source,omitempty"`
	// StructuredDescription: Structured description, for algorithmically
	// (AI)-generated descriptions.
	StructuredDescription *ProductStructuredDescription `json:"structuredDescription,omitempty"`
	// StructuredTitle: Structured title, for algorithmically (AI)-generated
	// titles.
	StructuredTitle *ProductStructuredTitle `json:"structuredTitle,omitempty"`
	// SubscriptionCost: Number of periods (months or years) and amount of payment
	// per period for an item with an associated subscription contract.
	SubscriptionCost *ProductSubscriptionCost `json:"subscriptionCost,omitempty"`
	// SustainabilityIncentives: Optional. The list of sustainability incentive
	// programs.
	SustainabilityIncentives []*ProductSustainabilityIncentive `json:"sustainabilityIncentives,omitempty"`
	// TargetCountry: Required. The CLDR territory code for the item's country of
	// sale.
	TargetCountry string `json:"targetCountry,omitempty"`
	// TaxCategory: The tax category of the product, used to configure detailed tax
	// nexus in account-level tax settings.
	TaxCategory string `json:"taxCategory,omitempty"`
	// Taxes: Tax information.
	Taxes []*ProductTax `json:"taxes,omitempty"`
	// Title: Title of the item.
	Title string `json:"title,omitempty"`
	// TransitTimeLabel: The transit time label of the product, used to group
	// product in account-level transit time tables.
	TransitTimeLabel string `json:"transitTimeLabel,omitempty"`
	// UnitPricingBaseMeasure: The preference of the denominator of the unit price.
	UnitPricingBaseMeasure *ProductUnitPricingBaseMeasure `json:"unitPricingBaseMeasure,omitempty"`
	// UnitPricingMeasure: The measure and dimension of an item.
	UnitPricingMeasure *ProductUnitPricingMeasure `json:"unitPricingMeasure,omitempty"`
	// VirtualModelLink: URL of the 3D model of the item to provide more visuals.
	VirtualModelLink string `json:"virtualModelLink,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdditionalImageLinks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalImageLinks") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Product) MarshalJSON() ([]byte, error) {
	type NoMethod Product
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Product) UnmarshalJSON(data []byte) error {
	type NoMethod Product
	var s1 struct {
		DisplayAdsValue gensupport.JSONFloat64 `json:"displayAdsValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DisplayAdsValue = float64(s1.DisplayAdsValue)
	return nil
}

// ProductCertification: Product certification
// (https://support.google.com/merchants/answer/13528839), introduced for EU
// energy efficiency labeling compliance using the EU EPREL
// (https://eprel.ec.europa.eu/screen/home) database.
type ProductCertification struct {
	// CertificationAuthority: The certification authority, for example
	// "European_Commission". Maximum length is 2000 characters.
	CertificationAuthority string `json:"certificationAuthority,omitempty"`
	// CertificationCode: The certification code, for eaxample "123456". Maximum
	// length is 2000 characters.
	CertificationCode string `json:"certificationCode,omitempty"`
	// CertificationName: The name of the certification, for example "EPREL".
	// Maximum length is 2000 characters.
	CertificationName string `json:"certificationName,omitempty"`
	// CertificationValue: The certification value (also known as class, level or
	// grade), for example "A+", "C", "gold". Maximum length is 2000 characters.
	CertificationValue string `json:"certificationValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificationAuthority") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificationAuthority") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductCertification) MarshalJSON() ([]byte, error) {
	type NoMethod ProductCertification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductCluster: Product cluster fields. A product cluster is a grouping for
// different offers that represent the same product. Values are only set for
// fields requested explicitly in the request's search query.
type ProductCluster struct {
	// Brand: Brand of the product cluster.
	Brand string `json:"brand,omitempty"`
	// BrandInventoryStatus: Tells if there is at least one product of the brand
	// currently `IN_STOCK` in your product feed across multiple countries, all
	// products are `OUT_OF_STOCK` in your product feed, or `NOT_IN_INVENTORY`. The
	// field doesn't take the Best Sellers report country filter into account.
	//
	// Possible values:
	//   "INVENTORY_STATUS_UNSPECIFIED" - Inventory status is unknown.
	//   "IN_STOCK" - Merchant has a product for this product cluster or brand in
	// stock.
	//   "OUT_OF_STOCK" - Merchant has a product for this product cluster or brand
	// in inventory but it is currently out of stock.
	//   "NOT_IN_INVENTORY" - Merchant does not have a product for this product
	// cluster or brand in inventory.
	BrandInventoryStatus string `json:"brandInventoryStatus,omitempty"`
	// CategoryL1: Product category (1st level) of the product cluster, represented
	// in Google's product taxonomy.
	CategoryL1 string `json:"categoryL1,omitempty"`
	// CategoryL2: Product category (2nd level) of the product cluster, represented
	// in Google's product taxonomy.
	CategoryL2 string `json:"categoryL2,omitempty"`
	// CategoryL3: Product category (3rd level) of the product cluster, represented
	// in Google's product taxonomy.
	CategoryL3 string `json:"categoryL3,omitempty"`
	// CategoryL4: Product category (4th level) of the product cluster, represented
	// in Google's product taxonomy.
	CategoryL4 string `json:"categoryL4,omitempty"`
	// CategoryL5: Product category (5th level) of the product cluster, represented
	// in Google's product taxonomy.
	CategoryL5 string `json:"categoryL5,omitempty"`
	// InventoryStatus: Tells whether the product cluster is `IN_STOCK` in your
	// product feed across multiple countries, `OUT_OF_STOCK` in your product feed,
	// or `NOT_IN_INVENTORY` at all. The field doesn't take the Best Sellers report
	// country filter into account.
	//
	// Possible values:
	//   "INVENTORY_STATUS_UNSPECIFIED" - Inventory status is unknown.
	//   "IN_STOCK" - Merchant has a product for this product cluster or brand in
	// stock.
	//   "OUT_OF_STOCK" - Merchant has a product for this product cluster or brand
	// in inventory but it is currently out of stock.
	//   "NOT_IN_INVENTORY" - Merchant does not have a product for this product
	// cluster or brand in inventory.
	InventoryStatus string `json:"inventoryStatus,omitempty"`
	// Title: Title of the product cluster.
	Title string `json:"title,omitempty"`
	// VariantGtins: GTINs of example variants of the product cluster.
	VariantGtins []string `json:"variantGtins,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductCluster) MarshalJSON() ([]byte, error) {
	type NoMethod ProductCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductDeliveryTime: The estimated days to deliver a product after an order
// is placed. Only authorized shipping signals partners working with a merchant
// can use this resource. Merchants should use the `products`
// (https://developers.google.com/shopping-content/reference/rest/v2.1/products#productshipping)
// resource instead.
type ProductDeliveryTime struct {
	// AreaDeliveryTimes: Required. A set of associations between `DeliveryArea`
	// and `DeliveryTime` entries. The total number of `areaDeliveryTimes` can be
	// at most 100.
	AreaDeliveryTimes []*ProductDeliveryTimeAreaDeliveryTime `json:"areaDeliveryTimes,omitempty"`
	// ProductId: Required. The `id` of the product.
	ProductId *ProductId `json:"productId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AreaDeliveryTimes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AreaDeliveryTimes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductDeliveryTime) MarshalJSON() ([]byte, error) {
	type NoMethod ProductDeliveryTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductDeliveryTimeAreaDeliveryTime: A pairing of `DeliveryArea` associated
// with a `DeliveryTime` for this product.
type ProductDeliveryTimeAreaDeliveryTime struct {
	// DeliveryArea: Required. The delivery area associated with `deliveryTime` for
	// this product.
	DeliveryArea *DeliveryArea `json:"deliveryArea,omitempty"`
	// DeliveryTime: Required. The delivery time associated with `deliveryArea` for
	// this product.
	DeliveryTime *ProductDeliveryTimeAreaDeliveryTimeDeliveryTime `json:"deliveryTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeliveryArea") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeliveryArea") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductDeliveryTimeAreaDeliveryTime) MarshalJSON() ([]byte, error) {
	type NoMethod ProductDeliveryTimeAreaDeliveryTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductDeliveryTimeAreaDeliveryTimeDeliveryTime: A delivery time for this
// product.
type ProductDeliveryTimeAreaDeliveryTimeDeliveryTime struct {
	// MaxHandlingTimeDays: Required. The maximum number of business days
	// (inclusive) between when an order is placed and when the product ships. If a
	// product ships in the same day, set this value to 0.
	MaxHandlingTimeDays int64 `json:"maxHandlingTimeDays,omitempty"`
	// MaxTransitTimeDays: Required. The maximum number of business days
	// (inclusive) between when the product ships and when the product is
	// delivered.
	MaxTransitTimeDays int64 `json:"maxTransitTimeDays,omitempty"`
	// MinHandlingTimeDays: Required. The minimum number of business days
	// (inclusive) between when an order is placed and when the product ships. If a
	// product ships in the same day, set this value to 0.
	MinHandlingTimeDays int64 `json:"minHandlingTimeDays,omitempty"`
	// MinTransitTimeDays: Required. The minimum number of business days
	// (inclusive) between when the product ships and when the product is
	// delivered.
	MinTransitTimeDays int64 `json:"minTransitTimeDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxHandlingTimeDays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxHandlingTimeDays") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductDeliveryTimeAreaDeliveryTimeDeliveryTime) MarshalJSON() ([]byte, error) {
	type NoMethod ProductDeliveryTimeAreaDeliveryTimeDeliveryTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductDimension struct {
	// Unit: Required. The length units. Acceptable values are: - "in" - "cm"
	Unit string `json:"unit,omitempty"`
	// Value: Required. The length value represented as a number. The value can
	// have a maximum precision of four decimal places.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductDimension) MarshalJSON() ([]byte, error) {
	type NoMethod ProductDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ProductDimension) UnmarshalJSON(data []byte) error {
	type NoMethod ProductDimension
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// ProductId: The Content API ID of the product.
type ProductId struct {
	// ProductId: The Content API ID of the product, in the form
	// `channel:contentLanguage:targetCountry:offerId`.
	ProductId string `json:"productId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProductId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProductId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductId) MarshalJSON() ([]byte, error) {
	type NoMethod ProductId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductIssue: An issue affecting specific product.
type ProductIssue struct {
	// Actions: A list of actionable steps that can be executed to solve the issue.
	// An example is requesting a re-review or providing arguments when merchant
	// disagrees with the issue. Actions that are supported in (your) third-party
	// application can be rendered as buttons and should be available to merchant
	// when they expand the issue.
	Actions []*Action `json:"actions,omitempty"`
	// Impact: Clarifies the severity of the issue. The summarizing message, if
	// present, should be shown right under the title for each issue. It helps
	// merchants to quickly understand the impact of the issue. The detailed
	// breakdown helps the merchant to fully understand the impact of the issue. It
	// can be rendered as dialog that opens when the merchant mouse over the
	// summarized impact statement. Issues with different severity can be styled
	// differently. They may use a different color or icon to signal the difference
	// between `ERROR`, `WARNING` and `INFO`.
	Impact *ProductIssueImpact `json:"impact,omitempty"`
	// PrerenderedContent: Details of the issue as a pre-rendered HTML. HTML
	// elements contain CSS classes that can be used to customize the style of the
	// content. Always sanitize the HTML before embedding it directly to your
	// application. The sanitizer needs to allow basic HTML tags, such as: `div`,
	// `span`, `p`, `a`, `ul`, `li`, `table`, `tr`, `td`. For example, you can use
	// DOMPurify (https://www.npmjs.com/package/dompurify). CSS classes: *
	// `issue-detail` - top level container for the detail of the issue *
	// `callout-banners` - section of the `issue-detail` with callout banners *
	// `callout-banner` - single callout banner, inside `callout-banners` *
	// `callout-banner-info` - callout with important information (default) *
	// `callout-banner-warning` - callout with a warning * `callout-banner-error` -
	// callout informing about an error (most severe) * `issue-content` - section
	// of the `issue-detail`, contains multiple `content-element` *
	// `content-element` - content element such as a list, link or paragraph,
	// inside `issue-content` * `root-causes` - unordered list with items
	// describing root causes of the issue, inside `issue-content` *
	// `root-causes-intro` - intro text before the `root-causes` list, inside
	// `issue-content` * `segment` - section of the text, `span` inside paragraph *
	// `segment-attribute` - section of the text that represents a product
	// attribute, for example 'image\_link' * `segment-literal` - section of the
	// text that contains a special value, for example '0-1000 kg' * `segment-bold`
	// - section of the text that should be rendered as bold * `segment-italic` -
	// section of the text that should be rendered as italic * `tooltip` - used on
	// paragraphs that should be rendered with a tooltip. A section of the text in
	// such a paragraph will have a class `tooltip-text` and is intended to be
	// shown in a mouse over dialog. If the style is not used, the `tooltip-text`
	// section would be shown on a new line, after the main part of the text. *
	// `tooltip-text` - marks a section of the text within a `tooltip`, that is
	// intended to be shown in a mouse over dialog. * `tooltip-icon` - marks a
	// section of the text within a `tooltip`, that can be replaced with a tooltip
	// icon, for example '?' or 'i'. By default, this section contains a `br` tag,
	// that is separating the main text and the tooltip text when the style is not
	// used. * `tooltip-style-question` - the tooltip shows helpful information,
	// can use the '?' as an icon. * `tooltip-style-info` - the tooltip adds
	// additional information fitting to the context, can use the 'i' as an icon. *
	// `content-moderation` - marks the paragraph that explains how the issue was
	// identified. * `list-intro` - marks the paragraph that contains an intro for
	// a list. This paragraph will be always followed by a list. * `new-element` -
	// Present for new elements added to the pre-rendered content in the future. To
	// make sure that a new content element does not break your style, you can hide
	// everything with this class.
	PrerenderedContent string `json:"prerenderedContent,omitempty"`
	// Title: Title of the issue.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductIssue) MarshalJSON() ([]byte, error) {
	type NoMethod ProductIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductIssueImpact: Overall impact of product issue.
type ProductIssueImpact struct {
	// Breakdowns: Detailed impact breakdown. Explains the types of restriction the
	// issue has in different shopping destinations and territory. If present, it
	// should be rendered to the merchant. Can be shown as a mouse over dropdown or
	// a dialog. Each breakdown item represents a group of regions with the same
	// impact details.
	Breakdowns []*Breakdown `json:"breakdowns,omitempty"`
	// Message: Optional. Message summarizing the overall impact of the issue. If
	// present, it should be rendered to the merchant. For example: "Limits
	// visibility in France"
	Message string `json:"message,omitempty"`
	// Severity: The severity of the issue.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Default value. Will never be provided by the API.
	//   "ERROR" - Causes either an account suspension or an item disapproval.
	// Errors should be resolved as soon as possible to ensure items are eligible
	// to appear in results again.
	//   "WARNING" - Warnings can negatively impact the performance of ads and can
	// lead to item or account suspensions in the future unless the issue is
	// resolved.
	//   "INFO" - Infos are suggested optimizations to increase data quality.
	// Resolving these issues is recommended, but not required.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Breakdowns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Breakdowns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductIssueImpact) MarshalJSON() ([]byte, error) {
	type NoMethod ProductIssueImpact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductProductDetail struct {
	// AttributeName: The name of the product detail.
	AttributeName string `json:"attributeName,omitempty"`
	// AttributeValue: The value of the product detail.
	AttributeValue string `json:"attributeValue,omitempty"`
	// SectionName: The section header used to group a set of product details.
	SectionName string `json:"sectionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductProductDetail) MarshalJSON() ([]byte, error) {
	type NoMethod ProductProductDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductShipping struct {
	// Country: The CLDR territory code of the country to which an item will ship.
	Country string `json:"country,omitempty"`
	// LocationGroupName: The location where the shipping is applicable,
	// represented by a location group name.
	LocationGroupName string `json:"locationGroupName,omitempty"`
	// LocationId: The numeric ID of a location that the shipping rate applies to
	// as defined in the Google Ads API.
	LocationId int64 `json:"locationId,omitempty,string"`
	// MaxHandlingTime: Maximum handling time (inclusive) between when the order is
	// received and shipped in business days. 0 means that the order is shipped on
	// the same day as it's received if it happens before the cut-off time. Both
	// maxHandlingTime and maxTransitTime are required if providing shipping
	// speeds.
	MaxHandlingTime int64 `json:"maxHandlingTime,omitempty,string"`
	// MaxTransitTime: Maximum transit time (inclusive) between when the order has
	// shipped and when it's delivered in business days. 0 means that the order is
	// delivered on the same day as it ships. Both maxHandlingTime and
	// maxTransitTime are required if providing shipping speeds.
	MaxTransitTime int64 `json:"maxTransitTime,omitempty,string"`
	// MinHandlingTime: Minimum handling time (inclusive) between when the order is
	// received and shipped in business days. 0 means that the order is shipped on
	// the same day as it's received if it happens before the cut-off time.
	// minHandlingTime can only be present together with maxHandlingTime; but it's
	// not required if maxHandlingTime is present.
	MinHandlingTime int64 `json:"minHandlingTime,omitempty,string"`
	// MinTransitTime: Minimum transit time (inclusive) between when the order has
	// shipped and when it's delivered in business days. 0 means that the order is
	// delivered on the same day as it ships. minTransitTime can only be present
	// together with maxTransitTime; but it's not required if maxTransitTime is
	// present.
	MinTransitTime int64 `json:"minTransitTime,omitempty,string"`
	// PostalCode: The postal code range that the shipping rate applies to,
	// represented by a postal code, a postal code prefix followed by a * wildcard,
	// a range between two postal codes or two postal code prefixes of equal
	// length.
	PostalCode string `json:"postalCode,omitempty"`
	// Price: Fixed shipping price, represented as a number.
	Price *Price `json:"price,omitempty"`
	// Region: The geographic region to which a shipping rate applies.
	Region string `json:"region,omitempty"`
	// Service: A free-form description of the service class or delivery speed.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductShipping) MarshalJSON() ([]byte, error) {
	type NoMethod ProductShipping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductShippingDimension struct {
	// Unit: The unit of value.
	Unit string `json:"unit,omitempty"`
	// Value: The dimension of the product used to calculate the shipping cost of
	// the item.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductShippingDimension) MarshalJSON() ([]byte, error) {
	type NoMethod ProductShippingDimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ProductShippingDimension) UnmarshalJSON(data []byte) error {
	type NoMethod ProductShippingDimension
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

type ProductShippingWeight struct {
	// Unit: The unit of value.
	Unit string `json:"unit,omitempty"`
	// Value: The weight of the product used to calculate the shipping cost of the
	// item.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductShippingWeight) MarshalJSON() ([]byte, error) {
	type NoMethod ProductShippingWeight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ProductShippingWeight) UnmarshalJSON(data []byte) error {
	type NoMethod ProductShippingWeight
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// ProductStatus: The status of a product, that is, information about a product
// computed asynchronously.
type ProductStatus struct {
	// CreationDate: Date on which the item has been created, in ISO 8601 format.
	CreationDate string `json:"creationDate,omitempty"`
	// DestinationStatuses: The intended destinations for the product.
	DestinationStatuses []*ProductStatusDestinationStatus `json:"destinationStatuses,omitempty"`
	// GoogleExpirationDate: Date on which the item expires in Google Shopping, in
	// ISO 8601 format.
	GoogleExpirationDate string `json:"googleExpirationDate,omitempty"`
	// ItemLevelIssues: A list of all issues associated with the product.
	ItemLevelIssues []*ProductStatusItemLevelIssue `json:"itemLevelIssues,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#productStatus"
	Kind string `json:"kind,omitempty"`
	// LastUpdateDate: Date on which the item has been last updated, in ISO 8601
	// format.
	LastUpdateDate string `json:"lastUpdateDate,omitempty"`
	// Link: The link to the product.
	Link string `json:"link,omitempty"`
	// ProductId: The ID of the product for which status is reported.
	ProductId string `json:"productId,omitempty"`
	// Title: The title of the product.
	Title string `json:"title,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreationDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductStatusDestinationStatus struct {
	// ApprovedCountries: List of country codes (ISO 3166-1 alpha-2) where the
	// offer is approved.
	ApprovedCountries []string `json:"approvedCountries,omitempty"`
	// Destination: The name of the destination
	Destination string `json:"destination,omitempty"`
	// DisapprovedCountries: List of country codes (ISO 3166-1 alpha-2) where the
	// offer is disapproved.
	DisapprovedCountries []string `json:"disapprovedCountries,omitempty"`
	// PendingCountries: List of country codes (ISO 3166-1 alpha-2) where the offer
	// is pending approval.
	PendingCountries []string `json:"pendingCountries,omitempty"`
	// Status: Deprecated. Destination approval status in `targetCountry` of the
	// offer.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApprovedCountries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApprovedCountries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStatusDestinationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusDestinationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductStatusItemLevelIssue struct {
	// ApplicableCountries: List of country codes (ISO 3166-1 alpha-2) where issue
	// applies to the offer.
	ApplicableCountries []string `json:"applicableCountries,omitempty"`
	// AttributeName: The attribute's name, if the issue is caused by a single
	// attribute.
	AttributeName string `json:"attributeName,omitempty"`
	// Code: The error code of the issue.
	Code string `json:"code,omitempty"`
	// Description: A short issue description in English.
	Description string `json:"description,omitempty"`
	// Destination: The destination the issue applies to.
	Destination string `json:"destination,omitempty"`
	// Detail: A detailed issue description in English.
	Detail string `json:"detail,omitempty"`
	// Documentation: The URL of a web page to help with resolving this issue.
	Documentation string `json:"documentation,omitempty"`
	// Resolution: Whether the issue can be resolved by the merchant.
	Resolution string `json:"resolution,omitempty"`
	// Servability: How this issue affects serving of the offer.
	Servability string `json:"servability,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicableCountries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicableCountries") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStatusItemLevelIssue) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusItemLevelIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductStructuredDescription: Structured description, for algorithmically
// (AI)-generated descriptions. See description
// (https://support.google.com/merchants/answer/6324468#When_to_use) for more
// information.
type ProductStructuredDescription struct {
	// Content: Required. The description text. Maximum length is 5000 characters.
	Content string `json:"content,omitempty"`
	// DigitalSourceType: Optional. The digital source type. Acceptable values are:
	// - "trained_algorithmic_media" - "default"
	DigitalSourceType string `json:"digitalSourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStructuredDescription) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStructuredDescription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductStructuredTitle: Structured title, for algorithmically (AI)-generated
// titles. See title
// (https://support.google.com/merchants/answer/6324415#Whentouse) for more
// information.
type ProductStructuredTitle struct {
	// Content: Required. The title text. Maximum length is 150 characters.
	Content string `json:"content,omitempty"`
	// DigitalSourceType: Optional. The digital source type. Acceptable values are:
	// - "trained_algorithmic_media" - "default"
	DigitalSourceType string `json:"digitalSourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStructuredTitle) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStructuredTitle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductSubscriptionCost struct {
	// Amount: The amount the buyer has to pay per subscription period.
	Amount *Price `json:"amount,omitempty"`
	// Period: The type of subscription period. - "month" - "year"
	Period string `json:"period,omitempty"`
	// PeriodLength: The number of subscription periods the buyer has to pay.
	PeriodLength int64 `json:"periodLength,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Amount") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductSubscriptionCost) MarshalJSON() ([]byte, error) {
	type NoMethod ProductSubscriptionCost
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductSustainabilityIncentive: Information regarding sustainability related
// incentive programs such as rebates or tax relief.
type ProductSustainabilityIncentive struct {
	// Amount: Optional. The fixed amount of the incentive.
	Amount *Price `json:"amount,omitempty"`
	// Percentage: Optional. The percentage of the sale price that the incentive is
	// applied to.
	Percentage float64 `json:"percentage,omitempty"`
	// Type: Required. Sustainability incentive program.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified or unknown sustainability incentive type.
	//   "EV_TAX_CREDIT" - Program offering tax liability reductions for electric
	// vehicles and, in some countries, plug-in hybrids. These reductions can be
	// based on a specific amount or a percentage of the sale price.
	//   "EV_PRICE_DISCOUNT" - A subsidy program, often called an environmental
	// bonus, provides a purchase grant for electric vehicles and, in some
	// countries, plug-in hybrids. The grant amount may be a fixed sum or a
	// percentage of the sale price.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Amount") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductSustainabilityIncentive) MarshalJSON() ([]byte, error) {
	type NoMethod ProductSustainabilityIncentive
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ProductSustainabilityIncentive) UnmarshalJSON(data []byte) error {
	type NoMethod ProductSustainabilityIncentive
	var s1 struct {
		Percentage gensupport.JSONFloat64 `json:"percentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Percentage = float64(s1.Percentage)
	return nil
}

type ProductTax struct {
	// Country: The country within which the item is taxed, specified as a CLDR
	// territory code.
	Country string `json:"country,omitempty"`
	// LocationId: The numeric ID of a location that the tax rate applies to as
	// defined in the Google Ads API.
	LocationId int64 `json:"locationId,omitempty,string"`
	// PostalCode: The postal code range that the tax rate applies to, represented
	// by a ZIP code, a ZIP code prefix using * wildcard, a range between two ZIP
	// codes or two ZIP code prefixes of equal length. Examples: 94114, 94*,
	// 94002-95460, 94*-95*.
	PostalCode string `json:"postalCode,omitempty"`
	// Rate: The percentage of tax rate that applies to the item price.
	Rate float64 `json:"rate,omitempty"`
	// Region: The geographic region to which the tax rate applies.
	Region string `json:"region,omitempty"`
	// TaxShip: Should be set to true if tax is charged on shipping.
	TaxShip bool `json:"taxShip,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductTax) MarshalJSON() ([]byte, error) {
	type NoMethod ProductTax
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ProductTax) UnmarshalJSON(data []byte) error {
	type NoMethod ProductTax
	var s1 struct {
		Rate gensupport.JSONFloat64 `json:"rate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Rate = float64(s1.Rate)
	return nil
}

type ProductUnitPricingBaseMeasure struct {
	// Unit: The unit of the denominator.
	Unit string `json:"unit,omitempty"`
	// Value: The denominator of the unit price.
	Value int64 `json:"value,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductUnitPricingBaseMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod ProductUnitPricingBaseMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductUnitPricingMeasure struct {
	// Unit: The unit of the measure.
	Unit string `json:"unit,omitempty"`
	// Value: The measure of an item.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductUnitPricingMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod ProductUnitPricingMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ProductUnitPricingMeasure) UnmarshalJSON(data []byte) error {
	type NoMethod ProductUnitPricingMeasure
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// ProductView: Product fields. Values are only set for fields requested
// explicitly in the request's search query.
type ProductView struct {
	// AggregatedDestinationStatus: Aggregated destination status.
	//
	// Possible values:
	//   "AGGREGATED_STATUS_UNSPECIFIED" - Undefined aggregated status.
	//   "NOT_ELIGIBLE_OR_DISAPPROVED" - Offer isn't eligible, or is disapproved
	// for all destinations.
	//   "PENDING" - Offer's status is pending in all destinations.
	//   "ELIGIBLE_LIMITED" - Offer is eligible for some (but not all)
	// destinations.
	//   "ELIGIBLE" - Offer is eligible for all destinations.
	AggregatedDestinationStatus string `json:"aggregatedDestinationStatus,omitempty"`
	// Availability: Availability of the product.
	Availability string `json:"availability,omitempty"`
	// Brand: Brand of the product.
	Brand string `json:"brand,omitempty"`
	// CategoryL1: First level of the product category in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL1 string `json:"categoryL1,omitempty"`
	// CategoryL2: Second level of the product category in Google's product
	// taxonomy (https://support.google.com/merchants/answer/6324436).
	CategoryL2 string `json:"categoryL2,omitempty"`
	// CategoryL3: Third level of the product category in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL3 string `json:"categoryL3,omitempty"`
	// CategoryL4: Fourth level of the product category in Google's product
	// taxonomy (https://support.google.com/merchants/answer/6324436).
	CategoryL4 string `json:"categoryL4,omitempty"`
	// CategoryL5: Fifth level of the product category in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL5 string `json:"categoryL5,omitempty"`
	// Channel: Channel of the product (online versus local).
	//
	// Possible values:
	//   "CHANNEL_UNSPECIFIED" - Indicates that the channel is unspecified.
	//   "LOCAL" - Indicates that the channel is local.
	//   "ONLINE" - Indicates that the channel is online.
	Channel string `json:"channel,omitempty"`
	// ClickPotential: Estimated performance potential compared to highest
	// performing products of the merchant.
	//
	// Possible values:
	//   "CLICK_POTENTIAL_UNSPECIFIED" - Unknown predicted clicks impact.
	//   "LOW" - Potential to receive a low number of clicks compared to the
	// highest performing products of the merchant.
	//   "MEDIUM" - Potential to receive a moderate number of clicks compared to
	// the highest performing products of the merchant.
	//   "HIGH" - Potential to receive a similar number of clicks as the highest
	// performing products of the merchant.
	ClickPotential string `json:"clickPotential,omitempty"`
	// ClickPotentialRank: Rank of the product based on its click potential. A
	// product with `click_potential_rank` 1 has the highest click potential among
	// the merchant's products that fulfill the search query conditions.
	ClickPotentialRank int64 `json:"clickPotentialRank,omitempty,string"`
	// Condition: Condition of the product.
	Condition string `json:"condition,omitempty"`
	// CreationTime: The time the merchant created the product in timestamp
	// seconds.
	CreationTime string `json:"creationTime,omitempty"`
	// CurrencyCode: Product price currency code (for example, ISO 4217). Absent if
	// product price is not available.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// ExpirationDate: Expiration date for the product. Specified on insertion.
	ExpirationDate *Date `json:"expirationDate,omitempty"`
	// Gtin: GTIN of the product.
	Gtin []string `json:"gtin,omitempty"`
	// Id: The REST ID of the product, in the form of
	// channel:contentLanguage:targetCountry:offerId. Content API methods that
	// operate on products take this as their productId parameter. Should always be
	// included in the SELECT clause.
	Id string `json:"id,omitempty"`
	// ItemGroupId: Item group ID provided by the merchant for grouping variants
	// together.
	ItemGroupId string `json:"itemGroupId,omitempty"`
	// ItemIssues: List of item issues for the product.
	ItemIssues []*ProductViewItemIssue `json:"itemIssues,omitempty"`
	// LanguageCode: Language code of the product in BCP 47 format.
	LanguageCode string `json:"languageCode,omitempty"`
	// OfferId: Merchant-provided id of the product.
	OfferId string `json:"offerId,omitempty"`
	// PriceMicros: Product price specified as micros (1 millionth of a standard
	// unit, 1 USD = 1000000 micros) in the product currency. Absent in case the
	// information about the price of the product is not available.
	PriceMicros int64 `json:"priceMicros,omitempty,string"`
	// ProductTypeL1: First level of the product type in merchant's own product
	// taxonomy (https://support.google.com/merchants/answer/6324436).
	ProductTypeL1 string `json:"productTypeL1,omitempty"`
	// ProductTypeL2: Second level of the product type in merchant's own product
	// taxonomy (https://support.google.com/merchants/answer/6324436).
	ProductTypeL2 string `json:"productTypeL2,omitempty"`
	// ProductTypeL3: Third level of the product type in merchant's own product
	// taxonomy (https://support.google.com/merchants/answer/6324436).
	ProductTypeL3 string `json:"productTypeL3,omitempty"`
	// ProductTypeL4: Fourth level of the product type in merchant's own product
	// taxonomy (https://support.google.com/merchants/answer/6324436).
	ProductTypeL4 string `json:"productTypeL4,omitempty"`
	// ProductTypeL5: Fifth level of the product type in merchant's own product
	// taxonomy (https://support.google.com/merchants/answer/6324436).
	ProductTypeL5 string `json:"productTypeL5,omitempty"`
	// ShippingLabel: The normalized shipping label specified in the feed
	ShippingLabel string `json:"shippingLabel,omitempty"`
	// Title: Title of the product.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AggregatedDestinationStatus") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregatedDestinationStatus") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductView) MarshalJSON() ([]byte, error) {
	type NoMethod ProductView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductViewItemIssue: Item issue associated with the product.
type ProductViewItemIssue struct {
	// IssueType: Item issue type.
	IssueType *ProductViewItemIssueItemIssueType `json:"issueType,omitempty"`
	// Resolution: Item issue resolution.
	//
	// Possible values:
	//   "UNKNOWN" - Unknown resolution type.
	//   "MERCHANT_ACTION" - The merchant has to fix the issue.
	//   "PENDING_PROCESSING" - The issue will be resolved automatically (for
	// example, image crawl), or Google review. No merchant action is required now.
	// Resolution might lead to another issue (for example, if crawl fails).
	Resolution string `json:"resolution,omitempty"`
	// Severity: Item issue severity.
	Severity *ProductViewItemIssueItemIssueSeverity `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductViewItemIssue) MarshalJSON() ([]byte, error) {
	type NoMethod ProductViewItemIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductViewItemIssueIssueSeverityPerDestination: Issue severity for all
// affected regions in a destination.
type ProductViewItemIssueIssueSeverityPerDestination struct {
	// DemotedCountries: List of demoted countries in the destination.
	DemotedCountries []string `json:"demotedCountries,omitempty"`
	// Destination: Issue destination.
	Destination string `json:"destination,omitempty"`
	// DisapprovedCountries: List of disapproved countries in the destination.
	DisapprovedCountries []string `json:"disapprovedCountries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DemotedCountries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DemotedCountries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductViewItemIssueIssueSeverityPerDestination) MarshalJSON() ([]byte, error) {
	type NoMethod ProductViewItemIssueIssueSeverityPerDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductViewItemIssueItemIssueSeverity: Severity of an issue per destination
// in a region, and aggregated severity.
type ProductViewItemIssueItemIssueSeverity struct {
	// AggregatedSeverity: Severity of an issue aggregated for destination.
	//
	// Possible values:
	//   "AGGREGATED_ISSUE_SEVERITY_UNSPECIFIED" - Undefined Issue severity.
	//   "DISAPPROVED" - Issue disapproves the product in at least one of the
	// selected destinations.
	//   "DEMOTED" - Issue demotes the product in all selected destinations it
	// affects.
	//   "PENDING" - Issue resolution is `PENDING_PROCESSING`.
	AggregatedSeverity string `json:"aggregatedSeverity,omitempty"`
	// SeverityPerDestination: Item issue severity for every destination.
	SeverityPerDestination []*ProductViewItemIssueIssueSeverityPerDestination `json:"severityPerDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregatedSeverity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregatedSeverity") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductViewItemIssueItemIssueSeverity) MarshalJSON() ([]byte, error) {
	type NoMethod ProductViewItemIssueItemIssueSeverity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductViewItemIssueItemIssueType: Type of the item issue.
type ProductViewItemIssueItemIssueType struct {
	// CanonicalAttribute: Canonical attribute name for attribute-specific issues.
	CanonicalAttribute string `json:"canonicalAttribute,omitempty"`
	// Code: Error code of the issue.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanonicalAttribute") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanonicalAttribute") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductViewItemIssueItemIssueType) MarshalJSON() ([]byte, error) {
	type NoMethod ProductViewItemIssueItemIssueType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductWeight struct {
	// Unit: Required. The weight unit. Acceptable values are: - "g" - "kg" -
	// "oz" - "lb"
	Unit string `json:"unit,omitempty"`
	// Value: Required. The weight represented as a number. The weight can have a
	// maximum precision of four decimal places.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductWeight) MarshalJSON() ([]byte, error) {
	type NoMethod ProductWeight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ProductWeight) UnmarshalJSON(data []byte) error {
	type NoMethod ProductWeight
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

type ProductsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ProductsCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductsCustomBatchRequestEntry: A batch entry encoding a single non-batch
// products request.
type ProductsCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// FeedId: The Content API Supplemental Feed ID. If present then product
	// insertion or deletion applies to a supplemental feed instead of primary
	// Content API feed.
	FeedId uint64 `json:"feedId,omitempty,string"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "delete" -
	// "get" - "insert" - "update"
	Method string `json:"method,omitempty"`
	// Product: The product to insert or update. Only required if the method is
	// `insert` or `update`. If the `update` method is used with `updateMask` only
	// to delete a field, then this isn't required. For example, setting
	// `salePrice` on the `updateMask` and not providing a `product` will result in
	// an existing sale price on the product specified by `productId` being
	// deleted.
	Product *Product `json:"product,omitempty"`
	// ProductId: The ID of the product to get or mutate. Only defined if the
	// method is `get`, `delete`, or `update`.
	ProductId string `json:"productId,omitempty"`
	// UpdateMask: The comma-separated list of product attributes to be updated.
	// Example: "title,salePrice". Attributes specified in the update mask
	// without a value specified in the body will be deleted from the product. *You
	// must specify the update mask to delete attributes.* Only top-level product
	// attributes can be updated. If not defined, product attributes with set
	// values will be updated and other attributes will stay unchanged. Only
	// defined if the method is `update`.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ProductsCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#productsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductsCustomBatchResponseEntry: A batch entry encoding a single non-batch
// products response.
type ProductsCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#productsCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// Product: The inserted product. Only defined if the method is `insert` and if
	// the request was successful.
	Product *Product `json:"product,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#productsListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of products.
	NextPageToken string     `json:"nextPageToken,omitempty"`
	Resources     []*Product `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ProductsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductstatusesCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ProductstatusesCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductstatusesCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductstatusesCustomBatchRequestEntry: A batch entry encoding a single
// non-batch productstatuses request.
type ProductstatusesCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// Destinations: If set, only issues for the specified destinations are
	// returned, otherwise only issues for the Shopping destination.
	Destinations []string `json:"destinations,omitempty"`
	// IncludeAttributes: Deprecated: Setting this field has no effect and
	// attributes are never included.
	IncludeAttributes bool `json:"includeAttributes,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "get"
	Method string `json:"method,omitempty"`
	// ProductId: The ID of the product whose status to get.
	ProductId string `json:"productId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductstatusesCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductstatusesCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ProductstatusesCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#productstatusesCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductstatusesCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductstatusesCustomBatchResponseEntry: A batch entry encoding a single
// non-batch productstatuses response.
type ProductstatusesCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#productstatusesCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// ProductStatus: The requested product status. Only defined if the request was
	// successful.
	ProductStatus *ProductStatus `json:"productStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductstatusesCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProductstatusesListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#productstatusesListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of products
	// statuses.
	NextPageToken string           `json:"nextPageToken,omitempty"`
	Resources     []*ProductStatus `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductstatusesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ProductstatusesListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Promotion: Represents a promotion. See the following articles for more
// details. * Promotions feed specification
// (https://support.google.com/merchants/answer/2906014) * Local promotions
// feed specification (https://support.google.com/merchants/answer/10146130) *
// Promotions on Buy on Google product data specification
// (https://support.google.com/merchants/answer/9173673)
type Promotion struct {
	// Brand: Product filter by brand for the promotion.
	Brand []string `json:"brand,omitempty"`
	// BrandExclusion: Product filter by brand exclusion for the promotion.
	BrandExclusion []string `json:"brandExclusion,omitempty"`
	// ContentLanguage: Required. The content language used as part of the unique
	// identifier. `en` content language is available for all target countries.
	// `fr` content language is available for `CA` and `FR` target countries. `de`
	// content language is available for `DE` target country. `nl` content language
	// is available for `NL` target country. `it` content language is available for
	// `IT` target country. `pt` content language is available for `BR` target
	// country. `ja` content language is available for `JP` target country. `ko`
	// content language is available for `KR` target country.
	ContentLanguage string `json:"contentLanguage,omitempty"`
	// CouponValueType: Required. Coupon value type for the promotion.
	//
	// Possible values:
	//   "COUPON_VALUE_TYPE_UNSPECIFIED" - Indicates that the coupon value type is
	// unspecified.
	//   "MONEY_OFF" - Money off coupon value type.
	//   "PERCENT_OFF" - Percent off coupon value type.
	//   "BUY_M_GET_N_MONEY_OFF" - Buy M quantity, get N money off coupon value
	// type. `buy_this_quantity` and `get_this_quantity` must be present.
	// `money_off_amount` must also be present.
	//   "BUY_M_GET_N_PERCENT_OFF" - Buy M quantity, get N percent off coupon value
	// type. `buy_this_quantity` and `get_this_quantity` must be present.
	// `percent_off_percentage` must also be present.
	//   "BUY_M_GET_MONEY_OFF" - Buy M quantity, get money off. `buy_this_quantity`
	// and `money_off_amount` must be present.
	//   "BUY_M_GET_PERCENT_OFF" - Buy M quantity, get money off.
	// `buy_this_quantity` and `percent_off_percentage` must be present.
	//   "FREE_GIFT" - Free gift with description only.
	//   "FREE_GIFT_WITH_VALUE" - Free gift with value (description is optional).
	//   "FREE_GIFT_WITH_ITEM_ID" - Free gift with item ID (description is
	// optional).
	//   "FREE_SHIPPING_STANDARD" - Standard free shipping coupon value type.
	//   "FREE_SHIPPING_OVERNIGHT" - Overnight free shipping coupon value type.
	//   "FREE_SHIPPING_TWO_DAY" - Two day free shipping coupon value type.
	CouponValueType string `json:"couponValueType,omitempty"`
	// FreeGiftDescription: Free gift description for the promotion.
	FreeGiftDescription string `json:"freeGiftDescription,omitempty"`
	// FreeGiftItemId: Free gift item ID for the promotion.
	FreeGiftItemId string `json:"freeGiftItemId,omitempty"`
	// FreeGiftValue: Free gift value for the promotion.
	FreeGiftValue *PriceAmount `json:"freeGiftValue,omitempty"`
	// GenericRedemptionCode: Generic redemption code for the promotion. To be used
	// with the `offerType` field.
	GenericRedemptionCode string `json:"genericRedemptionCode,omitempty"`
	// GetThisQuantityDiscounted: The number of items discounted in the promotion.
	GetThisQuantityDiscounted int64 `json:"getThisQuantityDiscounted,omitempty"`
	// Id: Output only. The REST promotion ID to uniquely identify the promotion.
	// Content API methods that operate on promotions take this as their
	// `promotionId` parameter. The REST ID for a promotion is of the form
	// channel:contentLanguage:targetCountry:promotionId The `channel` field has a
	// value of "online", "in_store", or "online_in_store".
	Id string `json:"id,omitempty"`
	// ItemGroupId: Product filter by item group ID for the promotion.
	ItemGroupId []string `json:"itemGroupId,omitempty"`
	// ItemGroupIdExclusion: Product filter by item group ID exclusion for the
	// promotion.
	ItemGroupIdExclusion []string `json:"itemGroupIdExclusion,omitempty"`
	// ItemId: Product filter by item ID for the promotion.
	ItemId []string `json:"itemId,omitempty"`
	// ItemIdExclusion: Product filter by item ID exclusion for the promotion.
	ItemIdExclusion []string `json:"itemIdExclusion,omitempty"`
	// LimitQuantity: Maximum purchase quantity for the promotion.
	LimitQuantity int64 `json:"limitQuantity,omitempty"`
	// LimitValue: Maximum purchase value for the promotion.
	LimitValue *PriceAmount `json:"limitValue,omitempty"`
	// LongTitle: Required. Long title for the promotion.
	LongTitle string `json:"longTitle,omitempty"`
	// MinimumPurchaseAmount: Minimum purchase amount for the promotion.
	MinimumPurchaseAmount *PriceAmount `json:"minimumPurchaseAmount,omitempty"`
	// MinimumPurchaseQuantity: Minimum purchase quantity for the promotion.
	MinimumPurchaseQuantity int64 `json:"minimumPurchaseQuantity,omitempty"`
	// MoneyBudget: Cost cap for the promotion.
	MoneyBudget *PriceAmount `json:"moneyBudget,omitempty"`
	// MoneyOffAmount: The money off amount offered in the promotion.
	MoneyOffAmount *PriceAmount `json:"moneyOffAmount,omitempty"`
	// OfferType: Required. Type of the promotion.
	//
	// Possible values:
	//   "OFFER_TYPE_UNSPECIFIED" - Unknown offer type.
	//   "NO_CODE" - Offer type without a code.
	//   "GENERIC_CODE" - Offer type with a code.
	OfferType string `json:"offerType,omitempty"`
	// OrderLimit: Order limit for the promotion.
	OrderLimit int64 `json:"orderLimit,omitempty"`
	// PercentOff: The percentage discount offered in the promotion.
	PercentOff int64 `json:"percentOff,omitempty"`
	// ProductApplicability: Required. Applicability of the promotion to either all
	// products or only specific products.
	//
	// Possible values:
	//   "PRODUCT_APPLICABILITY_UNSPECIFIED" - Which products the promotion applies
	// to is unknown.
	//   "ALL_PRODUCTS" - Applicable to all products.
	//   "SPECIFIC_PRODUCTS" - Applicable to only a single product or list of
	// products.
	ProductApplicability string `json:"productApplicability,omitempty"`
	// ProductType: Product filter by product type for the promotion.
	ProductType []string `json:"productType,omitempty"`
	// ProductTypeExclusion: Product filter by product type exclusion for the
	// promotion.
	ProductTypeExclusion []string `json:"productTypeExclusion,omitempty"`
	// PromotionDestinationIds: Destination ID for the promotion.
	PromotionDestinationIds []string `json:"promotionDestinationIds,omitempty"`
	// PromotionDisplayDates: String representation of the promotion display dates.
	// Deprecated. Use `promotion_display_time_period` instead.
	PromotionDisplayDates string `json:"promotionDisplayDates,omitempty"`
	// PromotionDisplayTimePeriod: `TimePeriod` representation of the promotion's
	// display dates.
	PromotionDisplayTimePeriod *TimePeriod `json:"promotionDisplayTimePeriod,omitempty"`
	// PromotionEffectiveDates: String representation of the promotion effective
	// dates. Deprecated. Use `promotion_effective_time_period` instead.
	PromotionEffectiveDates string `json:"promotionEffectiveDates,omitempty"`
	// PromotionEffectiveTimePeriod: Required. `TimePeriod` representation of the
	// promotion's effective dates.
	PromotionEffectiveTimePeriod *TimePeriod `json:"promotionEffectiveTimePeriod,omitempty"`
	// PromotionId: Required. The user provided promotion ID to uniquely identify
	// the promotion.
	PromotionId string `json:"promotionId,omitempty"`
	// PromotionStatus: Output only. The current status of the promotion.
	PromotionStatus *PromotionPromotionStatus `json:"promotionStatus,omitempty"`
	// PromotionUrl: URL to the page on the merchant's site where the promotion
	// shows. Local Inventory ads promotions throw an error if no promo url is
	// included. URL is used to confirm that the promotion is valid and can be
	// redeemed.
	PromotionUrl string `json:"promotionUrl,omitempty"`
	// RedemptionChannel: Required. Redemption channel for the promotion. At least
	// one channel is required.
	//
	// Possible values:
	//   "REDEMPTION_CHANNEL_UNSPECIFIED" - Indicates that the channel is
	// unspecified.
	//   "IN_STORE" - Indicates that the channel is in store.
	//   "ONLINE" - Indicates that the channel is online.
	RedemptionChannel []string `json:"redemptionChannel,omitempty"`
	// ShippingServiceNames: Shipping service names for the promotion.
	ShippingServiceNames []string `json:"shippingServiceNames,omitempty"`
	// StoreApplicability: Whether the promotion applies to all stores, or only
	// specified stores. Local Inventory ads promotions throw an error if no store
	// applicability is included. An INVALID_ARGUMENT error is thrown if
	// store_applicability is set to ALL_STORES and store_code or
	// score_code_exclusion is set to a value.
	//
	// Possible values:
	//   "STORE_APPLICABILITY_UNSPECIFIED" - Which store codes the promotion
	// applies to is unknown.
	//   "ALL_STORES" - Promotion applies to all stores.
	//   "SPECIFIC_STORES" - Promotion applies to only the specified stores.
	StoreApplicability string `json:"storeApplicability,omitempty"`
	// StoreCode: Store codes to include for the promotion.
	StoreCode []string `json:"storeCode,omitempty"`
	// StoreCodeExclusion: Store codes to exclude for the promotion.
	StoreCodeExclusion []string `json:"storeCodeExclusion,omitempty"`
	// TargetCountry: Required. The target country used as part of the unique
	// identifier. Can be `AU`, `CA`, `DE`, `FR`, `GB`, `IN`, `US`, `BR`, `ES`,
	// `NL`, `JP`, `IT` or `KR`.
	TargetCountry string `json:"targetCountry,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Promotion) MarshalJSON() ([]byte, error) {
	type NoMethod Promotion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PromotionPromotionStatus: The status of the promotion.
type PromotionPromotionStatus struct {
	// CreationDate: Date on which the promotion has been created in ISO 8601
	// (http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for
	// example "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
	CreationDate string `json:"creationDate,omitempty"`
	// DestinationStatuses: The intended destinations for the promotion.
	DestinationStatuses []*PromotionPromotionStatusDestinationStatus `json:"destinationStatuses,omitempty"`
	// LastUpdateDate: Date on which the promotion status has been last updated in
	// ISO 8601 (http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and
	// offset, for example "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
	LastUpdateDate string `json:"lastUpdateDate,omitempty"`
	// PromotionIssue: A list of issues associated with the promotion.
	PromotionIssue []*PromotionPromotionStatusPromotionIssue `json:"promotionIssue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreationDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PromotionPromotionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod PromotionPromotionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PromotionPromotionStatusDestinationStatus: The destination status of the
// promotion.
type PromotionPromotionStatusDestinationStatus struct {
	// Destination: The name of the destination.
	Destination string `json:"destination,omitempty"`
	// Status: The status for the specified destination.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown promotion state.
	//   "IN_REVIEW" - The promotion is under review.
	//   "REJECTED" - The promotion is disapproved
	//   "LIVE" - The promotion is approved and active.
	//   "STOPPED" - The promotion is stopped by merchant.
	//   "EXPIRED" - The promotion is no longer active.
	//   "PENDING" - The promotion is not stopped, and all reviews are approved,
	// but the active date is in the future.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PromotionPromotionStatusDestinationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod PromotionPromotionStatusDestinationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PromotionPromotionStatusPromotionIssue: The issue associated with the
// promotion.
type PromotionPromotionStatusPromotionIssue struct {
	// Code: Code of the issue.
	Code string `json:"code,omitempty"`
	// Detail: Explanation of the issue.
	Detail string `json:"detail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PromotionPromotionStatusPromotionIssue) MarshalJSON() ([]byte, error) {
	type NoMethod PromotionPromotionStatusPromotionIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PubsubNotificationSettings: Settings for Pub/Sub notifications, all methods
// require that the caller is a direct user of the merchant center account.
type PubsubNotificationSettings struct {
	// CloudTopicName: Cloud pub/sub topic to which notifications are sent
	// (read-only).
	CloudTopicName string `json:"cloudTopicName,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#pubsubNotificationSettings"
	Kind string `json:"kind,omitempty"`
	// RegisteredEvents: List of event types. Acceptable values are: -
	// "orderPendingShipment"
	RegisteredEvents []string `json:"registeredEvents,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CloudTopicName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudTopicName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PubsubNotificationSettings) MarshalJSON() ([]byte, error) {
	type NoMethod PubsubNotificationSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RateGroup struct {
	// ApplicableShippingLabels: A list of shipping labels defining the products to
	// which this rate group applies to. This is a disjunction: only one of the
	// labels has to match for the rate group to apply. May only be empty for the
	// last rate group of a service. Required.
	ApplicableShippingLabels []string `json:"applicableShippingLabels,omitempty"`
	// CarrierRates: A list of carrier rates that can be referred to by `mainTable`
	// or `singleValue`.
	CarrierRates []*CarrierRate `json:"carrierRates,omitempty"`
	// MainTable: A table defining the rate group, when `singleValue` is not
	// expressive enough. Can only be set if `singleValue` is not set.
	MainTable *Table `json:"mainTable,omitempty"`
	// Name: Name of the rate group. Optional. If set has to be unique within
	// shipping service.
	Name string `json:"name,omitempty"`
	// SingleValue: The value of the rate group (for example, flat rate $10). Can
	// only be set if `mainTable` and `subtables` are not set.
	SingleValue *Value `json:"singleValue,omitempty"`
	// Subtables: A list of subtables referred to by `mainTable`. Can only be set
	// if `mainTable` is set.
	Subtables []*Table `json:"subtables,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicableShippingLabels")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicableShippingLabels") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RateGroup) MarshalJSON() ([]byte, error) {
	type NoMethod RateGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Recommendation: Recommendations are suggested ways to improve your merchant
// account's performance. For example, to engage with a feature, or start using
// a new Google product.
type Recommendation struct {
	// AdditionalCallToAction: Output only. CTAs of this recommendation. Repeated.
	AdditionalCallToAction []*RecommendationCallToAction `json:"additionalCallToAction,omitempty"`
	// AdditionalDescriptions: Output only. List of additional localized
	// descriptions for a recommendation. Localication uses the `languageCode`
	// field in `GenerateRecommendations` requests. Not all description types are
	// guaranteed to be present and we recommend to rely on default description.
	AdditionalDescriptions []*RecommendationDescription `json:"additionalDescriptions,omitempty"`
	// Creative: Output only. Any creatives attached to the recommendation.
	// Repeated.
	Creative []*RecommendationCreative `json:"creative,omitempty"`
	// DefaultCallToAction: Optional. Default CTA of the recommendation.
	DefaultCallToAction *RecommendationCallToAction `json:"defaultCallToAction,omitempty"`
	// DefaultDescription: Optional. Localized recommendation description. The
	// localization the {@link `GenerateRecommendationsRequest.language_code`}
	// field in {@link `GenerateRecommendationsRequest`} requests.
	DefaultDescription string `json:"defaultDescription,omitempty"`
	// NumericalImpact: Optional. A numerical score of the impact from the
	// recommendation's description. For example, a recommendation might suggest an
	// upward trend in sales for a certain product. Higher number means larger
	// impact.
	NumericalImpact int64 `json:"numericalImpact,omitempty"`
	// Paid: Optional. Indicates whether a user needs to pay when they complete the
	// user journey suggested by the recommendation.
	Paid bool `json:"paid,omitempty"`
	// RecommendationName: Optional. Localized recommendation name. The
	// localization uses the {@link `GenerateRecommendationsRequest.language_code`}
	// field in {@link `GenerateRecommendationsRequest`} requests.
	RecommendationName string `json:"recommendationName,omitempty"`
	// SubType: Optional. Subtype of the recommendations. Only applicable when
	// multiple recommendations can be generated per type, and is used as an
	// identifier of recommendation under the same recommendation type.
	SubType string `json:"subType,omitempty"`
	// Title: Optional. Localized Recommendation Title. Localization uses the
	// {@link `GenerateRecommendationsRequest.language_code`} field in {@link
	// `GenerateRecommendationsRequest`} requests.
	Title string `json:"title,omitempty"`
	// Type: Output only. Type of the recommendation. List of currently available
	// recommendation types: - OPPORTUNITY_CREATE_NEW_COLLECTION -
	// OPPORTUNITY_CREATE_EMAIL_CAMPAIGN
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCallToAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCallToAction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Recommendation) MarshalJSON() ([]byte, error) {
	type NoMethod Recommendation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RecommendationCallToAction: Call to action (CTA) that explains how a
// merchant can implement this recommendation
type RecommendationCallToAction struct {
	// Intent: Output only. Intent of the action. This value describes the intent
	// (for example, `OPEN_CREATE_EMAIL_CAMPAIGN_FLOW`) and can vary from
	// recommendation to recommendation. This value can change over time for the
	// same recommendation. Currently available intent values: -
	// OPEN_CREATE_EMAIL_CAMPAIGN_FLOW: Opens a user journey where they can create
	// a marketing email campaign. (No default URL) - OPEN_CREATE_COLLECTION_TAB:
	// Opens a user journey where they can create a collection
	// (https://support.google.com/merchants/answer/9703228) for their Merchant
	// account. (No default URL)
	Intent string `json:"intent,omitempty"`
	// LocalizedText: Output only. Localized text of the CTA. Optional.
	LocalizedText string `json:"localizedText,omitempty"`
	// Uri: Optional. URL of the CTA. This field will only be set for some
	// recommendations where there is a suggested landing URL. Otherwise it will be
	// set to an empty string. We recommend developers to use their own custom
	// landing page according to the description of the intent field above when
	// this uri field is empty.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RecommendationCallToAction) MarshalJSON() ([]byte, error) {
	type NoMethod RecommendationCallToAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RecommendationCreative: Creative is a multimedia attachment to
// recommendation that can be used on the frontend.
type RecommendationCreative struct {
	// Type: Type of the creative.
	//
	// Possible values:
	//   "CREATIVE_TYPE_UNSPECIFIED" - Default value. If provided, shall be
	// considered invalid.
	//   "VIDEO" - Video creatives.
	//   "PHOTO" - Photo creatives.
	Type string `json:"type,omitempty"`
	// Uri: URL of the creative.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RecommendationCreative) MarshalJSON() ([]byte, error) {
	type NoMethod RecommendationCreative
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RecommendationDescription: Google-provided description for the
// recommendation.
type RecommendationDescription struct {
	// Text: Output only. Text of the description.
	Text string `json:"text,omitempty"`
	// Type: Output only. Type of the description.
	//
	// Possible values:
	//   "DESCRIPTION_TYPE_UNSPECIFIED" - Default value. Will never be provided by
	// the API.
	//   "SHORT" - Short description.
	//   "LONG" - Long description.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RecommendationDescription) MarshalJSON() ([]byte, error) {
	type NoMethod RecommendationDescription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Region: Represents a geographic region that you can use as a target with
// both the `RegionalInventory` and `ShippingSettings` services. You can define
// regions as collections of either postal codes or, in some countries, using
// predefined geotargets.
type Region struct {
	// DisplayName: The display name of the region.
	DisplayName string `json:"displayName,omitempty"`
	// GeotargetArea: A list of geotargets that defines the region area.
	GeotargetArea *RegionGeoTargetArea `json:"geotargetArea,omitempty"`
	// MerchantId: Output only. Immutable. Merchant that owns the region.
	MerchantId int64 `json:"merchantId,omitempty,string"`
	// PostalCodeArea: A list of postal codes that defines the region area.
	PostalCodeArea *RegionPostalCodeArea `json:"postalCodeArea,omitempty"`
	// RegionId: Output only. Immutable. The ID uniquely identifying each region.
	RegionId string `json:"regionId,omitempty"`
	// RegionalInventoryEligible: Output only. Indicates if the region is eligible
	// to use in the Regional Inventory configuration.
	RegionalInventoryEligible bool `json:"regionalInventoryEligible,omitempty"`
	// ShippingEligible: Output only. Indicates if the region is eligible to use in
	// the Shipping Services configuration.
	ShippingEligible bool `json:"shippingEligible,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Region) MarshalJSON() ([]byte, error) {
	type NoMethod Region
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionGeoTargetArea: A list of geotargets that defines the region area.
type RegionGeoTargetArea struct {
	// GeotargetCriteriaIds: Required. A non-empty list of location IDs
	// (https://developers.google.com/adwords/api/docs/appendix/geotargeting). They
	// must all be of the same location type (e.g., state).
	GeotargetCriteriaIds googleapi.Int64s `json:"geotargetCriteriaIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeotargetCriteriaIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeotargetCriteriaIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionGeoTargetArea) MarshalJSON() ([]byte, error) {
	type NoMethod RegionGeoTargetArea
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionPostalCodeArea: A list of postal codes that defines the region area.
// Note: All regions defined using postal codes are accessible via the
// account's `ShippingSettings.postalCodeGroups` resource.
type RegionPostalCodeArea struct {
	// PostalCodes: Required. A range of postal codes.
	PostalCodes []*RegionPostalCodeAreaPostalCodeRange `json:"postalCodes,omitempty"`
	// RegionCode: Required. CLDR territory code or the country the postal code
	// group applies to.
	RegionCode string `json:"regionCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostalCodes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostalCodes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionPostalCodeArea) MarshalJSON() ([]byte, error) {
	type NoMethod RegionPostalCodeArea
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionPostalCodeAreaPostalCodeRange: A range of postal codes that defines
// the region area.
type RegionPostalCodeAreaPostalCodeRange struct {
	// Begin: Required. A postal code or a pattern of the form prefix* denoting the
	// inclusive lower bound of the range defining the area. Examples values:
	// "94108", "9410*", "9*".
	Begin string `json:"begin,omitempty"`
	// End: Optional. A postal code or a pattern of the form prefix* denoting the
	// inclusive upper bound of the range defining the area. It must have the same
	// length as postalCodeRangeBegin: if postalCodeRangeBegin is a postal code
	// then postalCodeRangeEnd must be a postal code too; if postalCodeRangeBegin
	// is a pattern then postalCodeRangeEnd must be a pattern with the same prefix
	// length. Optional: if not set, then the area is defined as being all the
	// postal codes matching postalCodeRangeBegin.
	End string `json:"end,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Begin") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Begin") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionPostalCodeAreaPostalCodeRange) MarshalJSON() ([]byte, error) {
	type NoMethod RegionPostalCodeAreaPostalCodeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionalInventory: Regional inventory resource. contains the regional name
// and all attributes which are overridden for the specified region.
type RegionalInventory struct {
	// Availability: The availability of the product.
	Availability string `json:"availability,omitempty"`
	// CustomAttributes: A list of custom (merchant-provided) attributes. It can
	// also be used for submitting any attribute of the feed specification in its
	// generic form.
	CustomAttributes []*CustomAttribute `json:"customAttributes,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#regionalInventory".
	Kind string `json:"kind,omitempty"`
	// Price: The price of the product.
	Price *Price `json:"price,omitempty"`
	// RegionId: The ID uniquely identifying each region.
	RegionId string `json:"regionId,omitempty"`
	// SalePrice: The sale price of the product. Mandatory if
	// `sale_price_effective_date` is defined.
	SalePrice *Price `json:"salePrice,omitempty"`
	// SalePriceEffectiveDate: A date range represented by a pair of ISO 8601 dates
	// separated by a space, comma, or slash. Both dates might be specified as
	// 'null' if undecided.
	SalePriceEffectiveDate string `json:"salePriceEffectiveDate,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Availability") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Availability") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionalInventory) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalInventory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RegionalinventoryCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*RegionalinventoryCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionalinventoryCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalinventoryCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionalinventoryCustomBatchRequestEntry: A batch entry encoding a single
// non-batch regional inventory request.
type RegionalinventoryCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: Method of the batch request entry. Acceptable values are: -
	// "insert"
	Method string `json:"method,omitempty"`
	// ProductId: The ID of the product for which to update price and availability.
	ProductId string `json:"productId,omitempty"`
	// RegionalInventory: Price and availability of the product.
	RegionalInventory *RegionalInventory `json:"regionalInventory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionalinventoryCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalinventoryCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RegionalinventoryCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*RegionalinventoryCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#regionalinventoryCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionalinventoryCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalinventoryCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegionalinventoryCustomBatchResponseEntry: A batch entry encoding a single
// non-batch regional inventory response.
type RegionalinventoryCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry this entry responds to.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#regionalinventoryCustomBatchResponseEntry".
	Kind string `json:"kind,omitempty"`
	// RegionalInventory: Price and availability of the product.
	RegionalInventory *RegionalInventory `json:"regionalInventory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegionalinventoryCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod RegionalinventoryCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenderAccountIssuesRequestPayload: The payload for configuring how the
// content should be rendered.
type RenderAccountIssuesRequestPayload struct {
	// ContentOption: Optional. How the detailed content should be returned.
	// Default option is to return the content as a pre-rendered HTML text.
	//
	// Possible values:
	//   "CONTENT_OPTION_UNSPECIFIED" - Default value. Will never be provided by
	// the API.
	//   "PRE_RENDERED_HTML" - Returns the detail of the issue as a pre-rendered
	// HTML text.
	ContentOption string `json:"contentOption,omitempty"`
	// UserInputActionOption: Optional. How actions with user input form should be
	// handled. If not provided, actions will be returned as links that points
	// merchant to Merchant Center where they can request the action.
	//
	// Possible values:
	//   "USER_INPUT_ACTION_RENDERING_OPTION_UNSPECIFIED" - Default value. Will
	// never be provided by the API.
	//   "REDIRECT_TO_MERCHANT_CENTER" - Actions that require user input are
	// represented only as links that points merchant to Merchant Center where they
	// can request the action. Provides easier to implement alternative to
	// `BUILT_IN_USER_INPUT_ACTIONS`.
	//   "BUILT_IN_USER_INPUT_ACTIONS" - Returns content and input form definition
	// for each complex action. Your application needs to display this content and
	// input form to the merchant before they can request processing of the action.
	// To start the action, your application needs to call the `triggeraction`
	// method.
	UserInputActionOption string `json:"userInputActionOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentOption") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RenderAccountIssuesRequestPayload) MarshalJSON() ([]byte, error) {
	type NoMethod RenderAccountIssuesRequestPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenderAccountIssuesResponse: Response containing support content and actions
// for listed account issues.
type RenderAccountIssuesResponse struct {
	// AlternateDisputeResolution: The Alternate Dispute Resolution (ADR) contains
	// a link to a page where merchant can bring their appeal to an external body
	// (https://support.google.com/european-union-digital-services-act-redress-options/answer/13535501).
	// If the ADR is present, it MUST be available to the merchant on the page that
	// shows the list with their account issues.
	AlternateDisputeResolution *AlternateDisputeResolution `json:"alternateDisputeResolution,omitempty"`
	// Issues: List of account issues for a given account. This list can be shown
	// with compressed, expandable items. In the compressed form, the title and
	// impact should be shown for each issue. Once the issue is expanded, the
	// detailed content and available actions should be rendered.
	Issues []*AccountIssue `json:"issues,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateDisputeResolution")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateDisputeResolution") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RenderAccountIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RenderAccountIssuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenderProductIssuesRequestPayload: The payload for configuring how the
// content should be rendered.
type RenderProductIssuesRequestPayload struct {
	// ContentOption: Optional. How the detailed content should be returned.
	// Default option is to return the content as a pre-rendered HTML text.
	//
	// Possible values:
	//   "CONTENT_OPTION_UNSPECIFIED" - Default value. Will never be provided by
	// the API.
	//   "PRE_RENDERED_HTML" - Returns the detail of the issue as a pre-rendered
	// HTML text.
	ContentOption string `json:"contentOption,omitempty"`
	// UserInputActionOption: Optional. How actions with user input form should be
	// handled. If not provided, actions will be returned as links that points
	// merchant to Merchant Center where they can request the action.
	//
	// Possible values:
	//   "USER_INPUT_ACTION_RENDERING_OPTION_UNSPECIFIED" - Default value. Will
	// never be provided by the API.
	//   "REDIRECT_TO_MERCHANT_CENTER" - Actions that require user input are
	// represented only as links that points merchant to Merchant Center where they
	// can request the action. Provides easier to implement alternative to
	// `BUILT_IN_USER_INPUT_ACTIONS`.
	//   "BUILT_IN_USER_INPUT_ACTIONS" - Returns content and input form definition
	// for each complex action. Your application needs to display this content and
	// input form to the merchant before they can request processing of the action.
	// To start the action, your application needs to call the `triggeraction`
	// method.
	UserInputActionOption string `json:"userInputActionOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentOption") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RenderProductIssuesRequestPayload) MarshalJSON() ([]byte, error) {
	type NoMethod RenderProductIssuesRequestPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenderProductIssuesResponse: Response containing support content and actions
// for listed product issues.
type RenderProductIssuesResponse struct {
	// AlternateDisputeResolution: The Alternate Dispute Resolution (ADR) contains
	// a link to a page where merchant can bring their appeal to an external body
	// (https://support.google.com/european-union-digital-services-act-redress-options/answer/13535501).
	// If present, the link should be shown on the same page as the list of issues.
	AlternateDisputeResolution *AlternateDisputeResolution `json:"alternateDisputeResolution,omitempty"`
	// Issues: List of issues for a given product. This list can be shown with
	// compressed, expandable items. In the compressed form, the title and impact
	// should be shown for each issue. Once the issue is expanded, the detailed
	// content and available actions should be rendered.
	Issues []*ProductIssue `json:"issues,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateDisputeResolution")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateDisputeResolution") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RenderProductIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RenderProductIssuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportInteractionRequest: Request to report interactions on a
// recommendation.
type ReportInteractionRequest struct {
	// InteractionType: Required. Type of the interaction that is reported, for
	// example INTERACTION_CLICK.
	//
	// Possible values:
	//   "INTERACTION_TYPE_UNSPECIFIED" - Default value. If provided, the service
	// will throw ApiError with description "Required parameter: interactionType".
	//   "INTERACTION_DISMISS" - When a recommendation is dismissed.
	//   "INTERACTION_CLICK" - When a recommendation is clicked.
	InteractionType string `json:"interactionType,omitempty"`
	// ResponseToken: Required. Token of the response when recommendation was
	// returned.
	ResponseToken string `json:"responseToken,omitempty"`
	// Subtype: Optional. Subtype of the recommendations this interaction happened
	// on. This field must be set only to the value that is returned by {@link
	// `RecommendationsService.GenerateRecommendations`} call.
	Subtype string `json:"subtype,omitempty"`
	// Type: Required. Type of the recommendations on which this interaction
	// happened. This field must be set only to the value that is returned by
	// {@link `GenerateRecommendationsResponse`} call.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InteractionType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InteractionType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportInteractionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReportInteractionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportRow: Result row returned from the search query.
type ReportRow struct {
	// BestSellers: Best sellers fields requested by the merchant in the query.
	// Field values are only set if the merchant queries
	// `BestSellersProductClusterView` or `BestSellersBrandView`.
	BestSellers *BestSellers `json:"bestSellers,omitempty"`
	// Brand: Brand fields requested by the merchant in the query. Field values are
	// only set if the merchant queries `BestSellersBrandView`.
	Brand *Brand `json:"brand,omitempty"`
	// CompetitiveVisibility: Competitive visibility fields requested by the
	// merchant in the query. Field values are only set if the merchant queries
	// `CompetitiveVisibilityTopMerchantView`, `CompetitiveVisibilityBenchmarkView`
	// or `CompetitiveVisibilityCompetitorView`.
	CompetitiveVisibility *CompetitiveVisibility `json:"competitiveVisibility,omitempty"`
	// Metrics: Metrics requested by the merchant in the query. Metric values are
	// only set for metrics requested explicitly in the query.
	Metrics *Metrics `json:"metrics,omitempty"`
	// PriceCompetitiveness: Price competitiveness fields requested by the merchant
	// in the query. Field values are only set if the merchant queries
	// `PriceCompetitivenessProductView`.
	PriceCompetitiveness *PriceCompetitiveness `json:"priceCompetitiveness,omitempty"`
	// PriceInsights: Price insights fields requested by the merchant in the query.
	// Field values are only set if the merchant queries
	// `PriceInsightsProductView`.
	PriceInsights *PriceInsights `json:"priceInsights,omitempty"`
	// ProductCluster: Product cluster fields requested by the merchant in the
	// query. Field values are only set if the merchant queries
	// `BestSellersProductClusterView`.
	ProductCluster *ProductCluster `json:"productCluster,omitempty"`
	// ProductView: Product fields requested by the merchant in the query. Field
	// values are only set if the merchant queries `ProductView`.
	ProductView *ProductView `json:"productView,omitempty"`
	// Segments: Segmentation dimensions requested by the merchant in the query.
	// Dimension values are only set for dimensions requested explicitly in the
	// query.
	Segments *Segments `json:"segments,omitempty"`
	// TopicTrends: Topic trends
	// (https://support.google.com/merchants/answer/13542370) fields requested by
	// the merchant in the query. Field values are only set if the merchant queries
	// `TopicTrendsView`.
	TopicTrends *TopicTrends `json:"topicTrends,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BestSellers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BestSellers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportRow) MarshalJSON() ([]byte, error) {
	type NoMethod ReportRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RequestPhoneVerificationRequest: Request message for the
// RequestPhoneVerification method.
type RequestPhoneVerificationRequest struct {
	// LanguageCode: Language code IETF BCP 47 syntax
	// (https://tools.ietf.org/html/bcp47) (for example, en-US). Language code is
	// used to provide localized `SMS` and `PHONE_CALL`. Default language used is
	// en-US if not provided.
	LanguageCode string `json:"languageCode,omitempty"`
	// PhoneNumber: Phone number to be verified.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PhoneRegionCode: Required. Two letter country code for the phone number, for
	// example `CA` for Canadian numbers. See the ISO 3166-1 alpha-2
	// (https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
	// officially assigned codes.
	PhoneRegionCode string `json:"phoneRegionCode,omitempty"`
	// PhoneVerificationMethod: Verification method to receive verification code.
	//
	// Possible values:
	//   "PHONE_VERIFICATION_METHOD_UNSPECIFIED" - Unknown method.
	//   "SMS" - Receive verification code by SMS.
	//   "PHONE_CALL" - Receive verification code by phone call.
	PhoneVerificationMethod string `json:"phoneVerificationMethod,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RequestPhoneVerificationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RequestPhoneVerificationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RequestPhoneVerificationResponse: Response message for the
// RequestPhoneVerification method.
type RequestPhoneVerificationResponse struct {
	// VerificationId: The verification ID to use in subsequent calls to
	// `verifyphonenumber`.
	VerificationId string `json:"verificationId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "VerificationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VerificationId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RequestPhoneVerificationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RequestPhoneVerificationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RequestReviewFreeListingsRequest: Request message for the
// RequestReviewFreeListings Program method.
type RequestReviewFreeListingsRequest struct {
	// RegionCode: The code ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the country for which
	// review is to be requested.
	RegionCode string `json:"regionCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RegionCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RegionCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RequestReviewFreeListingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RequestReviewFreeListingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RequestReviewShoppingAdsRequest: Request message for the
// RequestReviewShoppingAds program method.
type RequestReviewShoppingAdsRequest struct {
	// RegionCode: The code ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the country for which
	// review is to be requested.
	RegionCode string `json:"regionCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RegionCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RegionCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RequestReviewShoppingAdsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RequestReviewShoppingAdsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReturnAddress: Return address resource.
type ReturnAddress struct {
	// Address: Required. The address.
	Address *ReturnAddressAddress `json:"address,omitempty"`
	// Country: Required. The country of sale where the return address is
	// applicable.
	Country string `json:"country,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#returnAddress"
	Kind string `json:"kind,omitempty"`
	// Label: Required. The user-defined label of the return address. For the
	// default address, use the label "default".
	Label string `json:"label,omitempty"`
	// PhoneNumber: Required. The merchant's contact phone number regarding the
	// return.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ReturnAddressId: Return address ID generated by Google.
	ReturnAddressId string `json:"returnAddressId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnAddress) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnAddressAddress struct {
	// Country: CLDR country code (for example, "US").
	Country string `json:"country,omitempty"`
	// Locality: City, town or commune. May also include dependent localities or
	// sublocalities (for example, neighborhoods or suburbs).
	Locality string `json:"locality,omitempty"`
	// PostalCode: Postal code or ZIP (for example, "94043").
	PostalCode string `json:"postalCode,omitempty"`
	// RecipientName: Name of the recipient to address returns to.
	RecipientName string `json:"recipientName,omitempty"`
	// Region: Top-level administrative subdivision of the country. For example, a
	// state like California ("CA") or a province like Quebec ("QC").
	Region string `json:"region,omitempty"`
	// StreetAddress: Street-level part of the address. May be up to two lines,
	// each line specified as an array element.
	StreetAddress []string `json:"streetAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnAddressAddress) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnAddressAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReturnPolicy: Return policy resource.
type ReturnPolicy struct {
	// Country: Required. The country of sale where the return policy is
	// applicable.
	Country string `json:"country,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#returnPolicy"
	Kind string `json:"kind,omitempty"`
	// Label: Required. The user-defined label of the return policy. For the
	// default policy, use the label "default".
	Label string `json:"label,omitempty"`
	// Name: Required. The name of the policy as shown in Merchant Center.
	Name string `json:"name,omitempty"`
	// NonFreeReturnReasons: Return reasons that will incur return fees.
	NonFreeReturnReasons []string `json:"nonFreeReturnReasons,omitempty"`
	// Policy: Required. The policy.
	Policy *ReturnPolicyPolicy `json:"policy,omitempty"`
	// ReturnPolicyId: Return policy ID generated by Google.
	ReturnPolicyId string `json:"returnPolicyId,omitempty"`
	// ReturnShippingFee: The return shipping fee that will apply to non free
	// return reasons.
	ReturnShippingFee *Price `json:"returnShippingFee,omitempty"`
	// SeasonalOverrides: An optional list of seasonal overrides.
	SeasonalOverrides []*ReturnPolicySeasonalOverride `json:"seasonalOverrides,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnline: Return policy online object. This is currently used to
// represent return policies for ads and free listings programs.
type ReturnPolicyOnline struct {
	// Countries: The countries of sale where the return policy is applicable. The
	// values must be a valid 2 letter ISO 3166 code, e.g. "US".
	Countries []string `json:"countries,omitempty"`
	// ItemConditions: The item conditions that are accepted for returns. This is
	// required to not be empty unless the type of return policy is noReturns.
	//
	// Possible values:
	//   "ITEM_CONDITION_UNSPECIFIED" - Default value. This value is unused.
	//   "NEW" - New.
	//   "USED" - Used.
	ItemConditions []string `json:"itemConditions,omitempty"`
	// Label: The unique user-defined label of the return policy. The same label
	// cannot be used in different return policies for the same country. Policies
	// with the label 'default' will apply to all products, unless a product
	// specifies a return_policy_label attribute.
	Label string `json:"label,omitempty"`
	// Name: The name of the policy as shown in Merchant Center.
	Name string `json:"name,omitempty"`
	// Policy: The return policy.
	Policy *ReturnPolicyOnlinePolicy `json:"policy,omitempty"`
	// RestockingFee: The restocking fee that applies to all return reason
	// categories. This would be treated as a free restocking fee if the value is
	// not set.
	RestockingFee *ReturnPolicyOnlineRestockingFee `json:"restockingFee,omitempty"`
	// ReturnMethods: The return methods of how customers can return an item. This
	// value is required to not be empty unless the type of return policy is
	// noReturns.
	//
	// Possible values:
	//   "RETURN_METHOD_UNSPECIFIED" - Default value. This value is unused.
	//   "BY_MAIL" - By mail.
	//   "IN_STORE" - In store.
	//   "AT_A_KIOSK" - At a kiosk.
	ReturnMethods []string `json:"returnMethods,omitempty"`
	// ReturnPolicyId: Output only. Return policy ID generated by Google.
	ReturnPolicyId string `json:"returnPolicyId,omitempty"`
	// ReturnPolicyUri: The return policy uri. This can used by Google to do a
	// sanity check for the policy.
	ReturnPolicyUri string `json:"returnPolicyUri,omitempty"`
	// ReturnReasonCategoryInfo: The return reason category information. This
	// required to not be empty unless the type of return policy is noReturns.
	ReturnReasonCategoryInfo []*ReturnPolicyOnlineReturnReasonCategoryInfo `json:"returnReasonCategoryInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Countries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Countries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnPolicyOnline) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnline
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnlinePolicy: The available policies.
type ReturnPolicyOnlinePolicy struct {
	// Days: The number of days items can be returned after delivery, where one day
	// is defined to be 24 hours after the delivery timestamp. Required for
	// `numberOfDaysAfterDelivery` returns.
	Days int64 `json:"days,omitempty,string"`
	// Type: Policy type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "NUMBER_OF_DAYS_AFTER_DELIVERY" - Number of days after a return is
	// delivered.
	//   "NO_RETURNS" - No returns.
	//   "LIFETIME_RETURNS" - Life time returns.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Days") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Days") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnPolicyOnlinePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnlinePolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnlineRestockingFee: The restocking fee. This can either be a
// fixed fee or a micro percent.
type ReturnPolicyOnlineRestockingFee struct {
	// FixedFee: Fixed restocking fee.
	FixedFee *PriceAmount `json:"fixedFee,omitempty"`
	// MicroPercent: Percent of total price in micros. 15,000,000 means 15% of the
	// total price would be charged.
	MicroPercent int64 `json:"microPercent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedFee") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedFee") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnPolicyOnlineRestockingFee) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnlineRestockingFee
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnlineReturnReasonCategoryInfo: The return reason category info
// wrapper.
type ReturnPolicyOnlineReturnReasonCategoryInfo struct {
	// ReturnLabelSource: The corresponding return label source.
	//
	// Possible values:
	//   "RETURN_LABEL_SOURCE_UNSPECIFIED" - Default value. This value is unused.
	//   "DOWNLOAD_AND_PRINT" - Download and print the label.
	//   "IN_THE_BOX" - Label in the box.
	//   "CUSTOMER_RESPONSIBILITY" - Customers' responsibility to get the label.
	ReturnLabelSource string `json:"returnLabelSource,omitempty"`
	// ReturnReasonCategory: The return reason category.
	//
	// Possible values:
	//   "RETURN_REASON_CATEGORY_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "BUYER_REMORSE" - Buyer remorse.
	//   "ITEM_DEFECT" - Item defect.
	ReturnReasonCategory string `json:"returnReasonCategory,omitempty"`
	// ReturnShippingFee: The corresponding return shipping fee. This is only
	// applicable when returnLabelSource is not the customer's responsibility.
	ReturnShippingFee *ReturnPolicyOnlineReturnShippingFee `json:"returnShippingFee,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReturnLabelSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReturnLabelSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnPolicyOnlineReturnReasonCategoryInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnlineReturnReasonCategoryInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReturnPolicyOnlineReturnShippingFee: The return shipping fee. This can
// either be a fixed fee or a boolean to indicate that the customer pays the
// actual shipping cost.
type ReturnPolicyOnlineReturnShippingFee struct {
	// FixedFee: Fixed return shipping fee amount. This value is only applicable
	// when type is FIXED. We will treat the return shipping fee as free if type is
	// FIXED and this value is not set.
	FixedFee *PriceAmount `json:"fixedFee,omitempty"`
	// Type: Type of return shipping fee.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "FIXED" - The return shipping fee is a fixed value.
	//   "CUSTOMER_PAYING_ACTUAL_FEE" - Customer will pay the actual return
	// shipping fee.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedFee") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedFee") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnPolicyOnlineReturnShippingFee) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyOnlineReturnShippingFee
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnPolicyPolicy struct {
	// LastReturnDate: Required. Last day for returning the items. In ISO 8601
	// format. When specifying the return window like this, set the policy type to
	// "lastReturnDate". Use this for seasonal overrides only.
	LastReturnDate string `json:"lastReturnDate,omitempty"`
	// NumberOfDays: The number of days items can be returned after delivery, where
	// one day is defined to be 24 hours after the delivery timestamp. When
	// specifying the return window like this, set the policy type to
	// "numberOfDaysAfterDelivery". Acceptable values are 30, 45, 60, 90, 100, 180,
	// 270 and 365 for the default policy. Additional policies further allow 14,
	// 15, 21 and 28 days, but note that for most items a minimum of 30 days is
	// required for returns. Exceptions may be made for electronics. A policy of
	// less than 30 days can only be applied to those items.
	NumberOfDays int64 `json:"numberOfDays,omitempty,string"`
	// Type: Policy type. Use "lastReturnDate" for seasonal overrides only. Note
	// that for most items a minimum of 30 days is required for returns. Exceptions
	// may be made for electronics or non-returnable items such as food,
	// perishables, and living things. A policy of less than 30 days can only be
	// applied to those items. Acceptable values are: - "lastReturnDate" -
	// "lifetimeReturns" - "noReturns" - "numberOfDaysAfterDelivery"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastReturnDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastReturnDate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnPolicyPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicyPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnPolicySeasonalOverride struct {
	// EndDate: Required. Last day on which the override applies. In ISO 8601
	// format.
	EndDate string `json:"endDate,omitempty"`
	// Name: Required. The name of the seasonal override as shown in Merchant
	// Center.
	Name string `json:"name,omitempty"`
	// Policy: Required. The policy which is in effect during that time.
	Policy *ReturnPolicyPolicy `json:"policy,omitempty"`
	// StartDate: Required. First day on which the override applies. In ISO 8601
	// format.
	StartDate string `json:"startDate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndDate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnPolicySeasonalOverride) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnPolicySeasonalOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnaddressCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ReturnaddressCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnaddressCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnaddressCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// MerchantId: The Merchant Center account ID.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: Method of the batch request entry. Acceptable values are: -
	// "delete" - "get" - "insert"
	Method string `json:"method,omitempty"`
	// ReturnAddress: The return address to submit. This should be set only if the
	// method is `insert`.
	ReturnAddress *ReturnAddress `json:"returnAddress,omitempty"`
	// ReturnAddressId: The return address ID. This should be set only if the
	// method is `delete` or `get`.
	ReturnAddressId string `json:"returnAddressId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnaddressCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnaddressCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ReturnaddressCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#returnaddressCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnaddressCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnaddressCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#returnaddressCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// ReturnAddress: The retrieved return address.
	ReturnAddress *ReturnAddress `json:"returnAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnaddressCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnaddressListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#returnaddressListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of addresses.
	NextPageToken string           `json:"nextPageToken,omitempty"`
	Resources     []*ReturnAddress `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnaddressListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnaddressListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnpolicyCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ReturnpolicyCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnpolicyCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnpolicyCustomBatchRequestEntry struct {
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// MerchantId: The Merchant Center account ID.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: Method of the batch request entry. Acceptable values are: -
	// "delete" - "get" - "insert"
	Method string `json:"method,omitempty"`
	// ReturnPolicy: The return policy to submit. This should be set only if the
	// method is `insert`.
	ReturnPolicy *ReturnPolicy `json:"returnPolicy,omitempty"`
	// ReturnPolicyId: The return policy ID. This should be set only if the method
	// is `delete` or `get`.
	ReturnPolicyId string `json:"returnPolicyId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnpolicyCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnpolicyCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ReturnpolicyCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#returnpolicyCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnpolicyCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnpolicyCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors defined if, and only if, the request failed.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#returnpolicyCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// ReturnPolicy: The retrieved return policy.
	ReturnPolicy *ReturnPolicy `json:"returnPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnpolicyCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReturnpolicyListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#returnpolicyListResponse".
	Kind      string          `json:"kind,omitempty"`
	Resources []*ReturnPolicy `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReturnpolicyListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ReturnpolicyListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Row struct {
	// Cells: The list of cells that constitute the row. Must have the same length
	// as `columnHeaders` for two-dimensional tables, a length of 1 for
	// one-dimensional tables. Required.
	Cells []*Value `json:"cells,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Row) MarshalJSON() ([]byte, error) {
	type NoMethod Row
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchRequest: Request message for the ReportService.Search method.
type SearchRequest struct {
	// PageSize: Number of ReportRows to retrieve in a single page. Defaults to
	// 1000. Values above 5000 are coerced to 5000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Token of the page to retrieve. If not specified, the first page
	// of results is returned. In order to request the next page of results, the
	// value obtained from `next_page_token` in the previous response should be
	// used.
	PageToken string `json:"pageToken,omitempty"`
	// Query: Required. Query that defines performance metrics to retrieve and
	// dimensions according to which the metrics are to be segmented. For details
	// on how to construct your query, see the Query Language guide
	// (https://developers.google.com/shopping-content/guides/reports/query-language/overview).
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SearchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchResponse: Response message for the ReportService.Search method.
type SearchResponse struct {
	// NextPageToken: Token which can be sent as `page_token` to retrieve the next
	// page. If omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Results: Rows that matched the search query.
	Results []*ReportRow `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Segments: Dimensions according to which metrics are segmented in the
// response. Values of product dimensions, such as `offer_id`, reflect the
// state of a product at the time of the corresponding event, for example,
// impression or order. Segment fields cannot be selected in queries without
// also selecting at least one metric field. Values are only set for dimensions
// requested explicitly in the request's search query.
type Segments struct {
	// Brand: Brand of the product.
	Brand string `json:"brand,omitempty"`
	// CategoryL1: Product category (1st level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL1 string `json:"categoryL1,omitempty"`
	// CategoryL2: Product category (2nd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL2 string `json:"categoryL2,omitempty"`
	// CategoryL3: Product category (3rd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL3 string `json:"categoryL3,omitempty"`
	// CategoryL4: Product category (4th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL4 string `json:"categoryL4,omitempty"`
	// CategoryL5: Product category (5th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy.
	CategoryL5 string `json:"categoryL5,omitempty"`
	// CurrencyCode: Currency in which price metrics are represented, for example,
	// if you select `ordered_item_sales_micros`, the returned value will be
	// represented by this currency.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// CustomLabel0: Custom label 0 for custom grouping of products.
	CustomLabel0 string `json:"customLabel0,omitempty"`
	// CustomLabel1: Custom label 1 for custom grouping of products.
	CustomLabel1 string `json:"customLabel1,omitempty"`
	// CustomLabel2: Custom label 2 for custom grouping of products.
	CustomLabel2 string `json:"customLabel2,omitempty"`
	// CustomLabel3: Custom label 3 for custom grouping of products.
	CustomLabel3 string `json:"customLabel3,omitempty"`
	// CustomLabel4: Custom label 4 for custom grouping of products.
	CustomLabel4 string `json:"customLabel4,omitempty"`
	// CustomerCountryCode: Code of the country where the customer is located at
	// the time of the event. Represented in the ISO 3166 format. If the customer
	// country cannot be determined, a special 'ZZ' code is returned.
	CustomerCountryCode string `json:"customerCountryCode,omitempty"`
	// Date: Date in the merchant timezone to which metrics apply.
	Date *Date `json:"date,omitempty"`
	// OfferId: Merchant-provided id of the product.
	OfferId string `json:"offerId,omitempty"`
	// ProductTypeL1: Product type (1st level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL1 string `json:"productTypeL1,omitempty"`
	// ProductTypeL2: Product type (2nd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL2 string `json:"productTypeL2,omitempty"`
	// ProductTypeL3: Product type (3rd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL3 string `json:"productTypeL3,omitempty"`
	// ProductTypeL4: Product type (4th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL4 string `json:"productTypeL4,omitempty"`
	// ProductTypeL5: Product type (5th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy.
	ProductTypeL5 string `json:"productTypeL5,omitempty"`
	// Program: Program to which metrics apply, for example, Free Product Listing.
	//
	// Possible values:
	//   "PROGRAM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - Shopping Ads.
	//   "FREE_PRODUCT_LISTING" - Free Product Listing.
	//   "FREE_LOCAL_PRODUCT_LISTING" - Free Local Product Listing.
	//   "BUY_ON_GOOGLE_LISTING" - *Deprecated*: This value is no longer supported.
	// Retrieving all metrics for the `BUY_ON_GOOGLE_LISTING` program returns 0
	// starting from May 2024. Buy on Google Listing.
	Program string `json:"program,omitempty"`
	// Title: Title of the product.
	Title string `json:"title,omitempty"`
	// Week: First day of the week (Monday) of the metrics date in the merchant
	// timezone.
	Week *Date `json:"week,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Segments) MarshalJSON() ([]byte, error) {
	type NoMethod Segments
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Service struct {
	// Active: A boolean exposing the active status of the shipping service.
	// Required.
	Active bool `json:"active,omitempty"`
	// Currency: The CLDR code of the currency to which this service applies. Must
	// match that of the prices in rate groups.
	Currency string `json:"currency,omitempty"`
	// DeliveryCountry: The CLDR territory code of the country to which the service
	// applies. Required.
	DeliveryCountry string `json:"deliveryCountry,omitempty"`
	// DeliveryTime: Time spent in various aspects from order to the delivery of
	// the product. Required.
	DeliveryTime *DeliveryTime `json:"deliveryTime,omitempty"`
	// Eligibility: Eligibility for this service. Acceptable values are: - "All
	// scenarios" - "All scenarios except Shopping Actions" - "Shopping
	// Actions"
	Eligibility string `json:"eligibility,omitempty"`
	// MinimumOrderValue: Minimum order value for this service. If set, indicates
	// that customers will have to spend at least this amount. All prices within a
	// service must have the same currency. Cannot be set together with
	// minimum_order_value_table.
	MinimumOrderValue *Price `json:"minimumOrderValue,omitempty"`
	// MinimumOrderValueTable: Table of per store minimum order values for the
	// pickup fulfillment type. Cannot be set together with minimum_order_value.
	MinimumOrderValueTable *MinimumOrderValueTable `json:"minimumOrderValueTable,omitempty"`
	// Name: Free-form name of the service. Must be unique within target account.
	// Required.
	Name string `json:"name,omitempty"`
	// PickupService: The carrier-service pair delivering items to collection
	// points. The list of supported pickup services can be retrieved through the
	// `getSupportedPickupServices` method. Required if and only if the service
	// delivery type is `pickup`.
	PickupService *PickupCarrierService `json:"pickupService,omitempty"`
	// RateGroups: Shipping rate group definitions. Only the last one is allowed to
	// have an empty `applicableShippingLabels`, which means "everything else". The
	// other `applicableShippingLabels` must not overlap.
	RateGroups []*RateGroup `json:"rateGroups,omitempty"`
	// ShipmentType: Type of locations this service ships orders to. Acceptable
	// values are: - "delivery" - "pickup` (deprecated)" - "local_delivery" -
	// "collection_point"
	ShipmentType string `json:"shipmentType,omitempty"`
	// StoreConfig: A list of stores your products are delivered from. This is only
	// available for the local delivery shipment type.
	StoreConfig *ServiceStoreConfig `json:"storeConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Service) MarshalJSON() ([]byte, error) {
	type NoMethod Service
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceStoreConfig: Stores that provide local delivery. Only valid with
// local delivery fulfillment.
type ServiceStoreConfig struct {
	// CutoffConfig: Time local delivery ends for the day. This can be either
	// `local_cutoff_time` or `store_close_offset_hours`, if both are provided an
	// error is thrown.
	CutoffConfig *ServiceStoreConfigCutoffConfig `json:"cutoffConfig,omitempty"`
	// ServiceRadius: Maximum delivery radius. Only needed for local delivery
	// fulfillment type.
	ServiceRadius *Distance `json:"serviceRadius,omitempty"`
	// StoreCodes: A list of store codes that provide local delivery. If empty,
	// then `store_service_type` must be `all_stores`, or an error is thrown. If
	// not empty, then `store_service_type` must be `selected_stores`, or an error
	// is thrown.
	StoreCodes []string `json:"storeCodes,omitempty"`
	// StoreServiceType: Indicates whether all stores listed by this merchant
	// provide local delivery or not. Acceptable values are `all stores` and
	// `selected stores`
	StoreServiceType string `json:"storeServiceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CutoffConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CutoffConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceStoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceStoreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceStoreConfigCutoffConfig: Time local delivery ends for the day based
// on the local timezone of the store. `local_cutoff_time` and
// `store_close_offset_hours` are mutually exclusive.
type ServiceStoreConfigCutoffConfig struct {
	// LocalCutoffTime: Time in hours and minutes in the local timezone when local
	// delivery ends.
	LocalCutoffTime *ServiceStoreConfigCutoffConfigLocalCutoffTime `json:"localCutoffTime,omitempty"`
	// NoDeliveryPostCutoff: Merchants can opt-out of showing n+1 day local
	// delivery when they have a shipping service configured to n day local
	// delivery. For example, if the shipping service defines same-day delivery,
	// and it's past the cut-off, setting this field to `true` results in the
	// calculated shipping service rate returning `NO_DELIVERY_POST_CUTOFF`. In the
	// same example, setting this field to `false` results in the calculated
	// shipping time being one day. This is only for local delivery.
	NoDeliveryPostCutoff bool `json:"noDeliveryPostCutoff,omitempty"`
	// StoreCloseOffsetHours: Represents cutoff time as the number of hours before
	// store closing. Mutually exclusive with other fields (hour and minute).
	StoreCloseOffsetHours int64 `json:"storeCloseOffsetHours,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "LocalCutoffTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocalCutoffTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceStoreConfigCutoffConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceStoreConfigCutoffConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceStoreConfigCutoffConfigLocalCutoffTime: Time in hours and minutes in
// the local timezone when local delivery ends.
type ServiceStoreConfigCutoffConfigLocalCutoffTime struct {
	// Hour: Hour local delivery orders must be placed by to process the same day.
	Hour int64 `json:"hour,omitempty,string"`
	// Minute: Minute local delivery orders must be placed by to process the same
	// day.
	Minute int64 `json:"minute,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Hour") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hour") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceStoreConfigCutoffConfigLocalCutoffTime) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceStoreConfigCutoffConfigLocalCutoffTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShippingSettings: The merchant account's shipping settings. All methods
// except getsupportedcarriers and getsupportedholidays require the admin role.
type ShippingSettings struct {
	// AccountId: The ID of the account to which these account shipping settings
	// belong. Ignored upon update, always present in get request responses.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// PostalCodeGroups: A list of postal code groups that can be referred to in
	// `services`. Optional.
	PostalCodeGroups []*PostalCodeGroup `json:"postalCodeGroups,omitempty"`
	// Services: The target account's list of services. Optional.
	Services []*Service `json:"services,omitempty"`
	// Warehouses: Optional. A list of warehouses which can be referred to in
	// `services`.
	Warehouses []*Warehouse `json:"warehouses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShippingsettingsCustomBatchRequest struct {
	// Entries: The request entries to be processed in the batch.
	Entries []*ShippingsettingsCustomBatchRequestEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingsettingsCustomBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsCustomBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShippingsettingsCustomBatchRequestEntry: A batch entry encoding a single
// non-batch shippingsettings request.
type ShippingsettingsCustomBatchRequestEntry struct {
	// AccountId: The ID of the account for which to get/update account shipping
	// settings.
	AccountId uint64 `json:"accountId,omitempty,string"`
	// BatchId: An entry ID, unique within the batch request.
	BatchId int64 `json:"batchId,omitempty"`
	// MerchantId: The ID of the managing account.
	MerchantId uint64 `json:"merchantId,omitempty,string"`
	// Method: The method of the batch entry. Acceptable values are: - "get" -
	// "update"
	Method string `json:"method,omitempty"`
	// ShippingSettings: The account shipping settings to update. Only defined if
	// the method is `update`.
	ShippingSettings *ShippingSettings `json:"shippingSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingsettingsCustomBatchRequestEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsCustomBatchRequestEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShippingsettingsCustomBatchResponse struct {
	// Entries: The result of the execution of the batch requests.
	Entries []*ShippingsettingsCustomBatchResponseEntry `json:"entries,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#shippingsettingsCustomBatchResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingsettingsCustomBatchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsCustomBatchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShippingsettingsCustomBatchResponseEntry: A batch entry encoding a single
// non-batch shipping settings response.
type ShippingsettingsCustomBatchResponseEntry struct {
	// BatchId: The ID of the request entry to which this entry responds.
	BatchId int64 `json:"batchId,omitempty"`
	// Errors: A list of errors for failed custombatch entries. *Note:* Schema
	// errors fail the whole request.
	Errors *Errors `json:"errors,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#shippingsettingsCustomBatchResponseEntry"
	Kind string `json:"kind,omitempty"`
	// ShippingSettings: The retrieved or updated account shipping settings.
	ShippingSettings *ShippingSettings `json:"shippingSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingsettingsCustomBatchResponseEntry) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsCustomBatchResponseEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShippingsettingsGetSupportedCarriersResponse struct {
	// Carriers: A list of supported carriers. May be empty.
	Carriers []*CarriersCarrier `json:"carriers,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#shippingsettingsGetSupportedCarriersResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Carriers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Carriers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingsettingsGetSupportedCarriersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsGetSupportedCarriersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShippingsettingsGetSupportedHolidaysResponse struct {
	// Holidays: A list of holidays applicable for delivery guarantees. May be
	// empty.
	Holidays []*HolidaysHoliday `json:"holidays,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#shippingsettingsGetSupportedHolidaysResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Holidays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Holidays") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingsettingsGetSupportedHolidaysResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsGetSupportedHolidaysResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShippingsettingsGetSupportedPickupServicesResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#shippingsettingsGetSupportedPickupServicesResponse".
	Kind string `json:"kind,omitempty"`
	// PickupServices: A list of supported pickup services. May be empty.
	PickupServices []*PickupServicesPickupService `json:"pickupServices,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingsettingsGetSupportedPickupServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsGetSupportedPickupServicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShippingsettingsListResponse struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "content#shippingsettingsListResponse".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The token for the retrieval of the next page of shipping
	// settings.
	NextPageToken string              `json:"nextPageToken,omitempty"`
	Resources     []*ShippingSettings `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingsettingsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingsettingsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShoppingAdsProgramStatus: Response message for GetShoppingAdsProgramStatus.
type ShoppingAdsProgramStatus struct {
	// GlobalState: State of the program. `ENABLED` if there are offers for at
	// least one region.
	//
	// Possible values:
	//   "PROGRAM_STATE_UNSPECIFIED" - State is unknown.
	//   "NOT_ENABLED" - Program is not enabled for any country.
	//   "NO_OFFERS_UPLOADED" - No products have been uploaded for any region.
	// Upload products to Merchant Center.
	//   "ENABLED" - Program is enabled and offers are uploaded for at least one
	// country.
	GlobalState string `json:"globalState,omitempty"`
	// RegionStatuses: Status of the program in each region. Regions with the same
	// status and review eligibility are grouped together in `regionCodes`.
	RegionStatuses []*ShoppingAdsProgramStatusRegionStatus `json:"regionStatuses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GlobalState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShoppingAdsProgramStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ShoppingAdsProgramStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShoppingAdsProgramStatusRegionStatus: Status of program and region.
type ShoppingAdsProgramStatusRegionStatus struct {
	// DisapprovalDate: Date by which eligibilityStatus will go from `WARNING` to
	// `DISAPPROVED`. Only visible when your eligibilityStatus is WARNING. In ISO
	// 8601 (https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DD`.
	DisapprovalDate string `json:"disapprovalDate,omitempty"`
	// EligibilityStatus: Eligibility status of the Shopping Ads program.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not known.
	//   "APPROVED" - If the account has no issues and review is completed
	// successfully.
	//   "DISAPPROVED" - There are one or more issues that needs to be resolved for
	// account to be active for the program. Detailed list of account issues are
	// available in
	// [accountstatuses](https://developers.google.com/shopping-content/reference/re
	// st/v2.1/accountstatuses) API.
	//   "WARNING" - If account has issues but offers are servable. Some of the
	// issue can make account DISAPPROVED after a certain deadline.
	//   "UNDER_REVIEW" - Account is under review.
	//   "PENDING_REVIEW" - Account is waiting for review to start.
	//   "ONBOARDING" - Program is currently onboarding. Upload valid offers to
	// complete onboarding.
	EligibilityStatus string `json:"eligibilityStatus,omitempty"`
	// OnboardingIssues: Issues that must be fixed to be eligible for review.
	OnboardingIssues []string `json:"onboardingIssues,omitempty"`
	// RegionCodes: The two-letter ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) codes for all the regions
	// with the same `eligibilityStatus` and `reviewEligibility`.
	RegionCodes []string `json:"regionCodes,omitempty"`
	// ReviewEligibilityStatus: If a program is eligible for review in a specific
	// region. Only visible if `eligibilityStatus` is `DISAPPROVED`.
	//
	// Possible values:
	//   "REVIEW_ELIGIBILITY_UNSPECIFIED" - Review eligibility state is unknown.
	//   "ELIGIBLE" - Account is eligible for review for a specified region code.
	//   "INELIGIBLE" - Account is not eligible for review for a specified region
	// code.
	ReviewEligibilityStatus string `json:"reviewEligibilityStatus,omitempty"`
	// ReviewIneligibilityReason: Review ineligibility reason if account is not
	// eligible for review.
	//
	// Possible values:
	//   "REVIEW_INELIGIBILITY_REASON_UNSPECIFIED" - Requesting a review from
	// Google is not possible.
	//   "ONBOARDING_ISSUES" - All onboarding issues needs to be fixed.
	//   "NOT_ENOUGH_OFFERS" - Not enough offers uploaded for this country.
	//   "IN_COOLDOWN_PERIOD" - Cooldown period applies. Wait until cooldown period
	// ends.
	//   "ALREADY_UNDER_REVIEW" - Account is already under review.
	//   "NO_REVIEW_REQUIRED" - No issues available to review.
	//   "WILL_BE_REVIEWED_AUTOMATICALLY" - Account will be automatically reviewed
	// at the end of the grace period.
	//   "IS_RETIRED" - Account is retired. Should not appear in MC.
	//   "ALREADY_REVIEWED" - Account has already been reviewed. You can't request
	// further reviews.
	ReviewIneligibilityReason string `json:"reviewIneligibilityReason,omitempty"`
	// ReviewIneligibilityReasonDescription: Reason a program in a specific region
	// isn’t eligible for review. Only visible if `reviewEligibilityStatus` is
	// `INELIGIBLE`.
	ReviewIneligibilityReasonDescription string `json:"reviewIneligibilityReasonDescription,omitempty"`
	// ReviewIneligibilityReasonDetails: Additional information for ineligibility.
	// If `reviewIneligibilityReason` is `IN_COOLDOWN_PERIOD`, a timestamp for the
	// end of the cooldown period is provided.
	ReviewIneligibilityReasonDetails *ShoppingAdsProgramStatusReviewIneligibilityReasonDetails `json:"reviewIneligibilityReasonDetails,omitempty"`
	// ReviewIssues: Issues evaluated in the review process. Fix all issues before
	// requesting a review.
	ReviewIssues []string `json:"reviewIssues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisapprovalDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisapprovalDate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShoppingAdsProgramStatusRegionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ShoppingAdsProgramStatusRegionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShoppingAdsProgramStatusReviewIneligibilityReasonDetails: Additional details
// for review ineligibility reasons.
type ShoppingAdsProgramStatusReviewIneligibilityReasonDetails struct {
	// CooldownTime: This timestamp represents end of cooldown period for review
	// ineligbility reason `IN_COOLDOWN_PERIOD`.
	CooldownTime string `json:"cooldownTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CooldownTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CooldownTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShoppingAdsProgramStatusReviewIneligibilityReasonDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ShoppingAdsProgramStatusReviewIneligibilityReasonDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Table struct {
	// ColumnHeaders: Headers of the table's columns. Optional: if not set then the
	// table has only one dimension.
	ColumnHeaders *Headers `json:"columnHeaders,omitempty"`
	// Name: Name of the table. Required for subtables, ignored for the main table.
	Name string `json:"name,omitempty"`
	// RowHeaders: Headers of the table's rows. Required.
	RowHeaders *Headers `json:"rowHeaders,omitempty"`
	// Rows: The list of rows that constitute the table. Must have the same length
	// as `rowHeaders`. Required.
	Rows []*Row `json:"rows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColumnHeaders") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColumnHeaders") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Table) MarshalJSON() ([]byte, error) {
	type NoMethod Table
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextWithTooltip: Block of text that may contain a tooltip with more
// information.
type TextWithTooltip struct {
	// SimpleTooltipValue: Value of the tooltip as a simple text.
	SimpleTooltipValue string `json:"simpleTooltipValue,omitempty"`
	// SimpleValue: Value of the message as a simple text.
	SimpleValue string `json:"simpleValue,omitempty"`
	// TooltipIconStyle: The suggested type of an icon for tooltip, if a tooltip is
	// present.
	//
	// Possible values:
	//   "TOOLTIP_ICON_STYLE_UNSPECIFIED" - Default value. Will never be provided
	// by the API.
	//   "INFO" - Used when the tooltip adds additional information to the context,
	// the 'i' can be used as an icon.
	//   "QUESTION" - Used when the tooltip shows helpful information, the '?' can
	// be used as an icon.
	TooltipIconStyle string `json:"tooltipIconStyle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleTooltipValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleTooltipValue") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextWithTooltip) MarshalJSON() ([]byte, error) {
	type NoMethod TextWithTooltip
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimePeriod: A message that represents a time period.
type TimePeriod struct {
	// EndTime: The ending timestamp.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: The starting timestamp.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod TimePeriod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type TimeZone struct {
	// Id: IANA Time Zone Database time zone. For example "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number. For example
	// "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TopicTrends: Topic trends fields requested by the merchant in the query.
// Field values are only set if the merchant queries `TopicTrendsView`.
// Forecast data can be queried up to 13 weeks by passing a future date in the
// `date` field. Historical data is measured daily, and forecasted data is
// projected weekly. All data points are normalized based on the highest data
// points returned in the response. If you make separate queries with different
// date ranges, you might see different values for the same date in each
// response. The recommended way to get a trend score of a topic is
// `last7_days_search_interest / last{$day}_days_search_interest - 1`. You can
// view trends for up to eight topics at a time.
type TopicTrends struct {
	// CustomerCountryCode: Country trends are calculated for. Must be a two-letter
	// country code (ISO 3166-1-alpha-2 code), for example, `“US”`.
	CustomerCountryCode string `json:"customerCountryCode,omitempty"`
	// Date: Date the trend score was retrieved.
	Date *Date `json:"date,omitempty"`
	// Last120DaysSearchInterest: Search interest in the last 120 days, with the
	// same normalization as search_interest. This field is only present for a past
	// date.
	Last120DaysSearchInterest float64 `json:"last120DaysSearchInterest,omitempty"`
	// Last30DaysSearchInterest: Search interest in the last 30 days, with the same
	// normalization as search_interest. This field is only present for a past
	// date.
	Last30DaysSearchInterest float64 `json:"last30DaysSearchInterest,omitempty"`
	// Last7DaysSearchInterest: Search interest in the last 7 days, with the same
	// normalization as search_interest. This field is only present for a past
	// date.
	Last7DaysSearchInterest float64 `json:"last7DaysSearchInterest,omitempty"`
	// Last90DaysSearchInterest: Search interest in the last 90 days, with the same
	// normalization as search_interest. This field is only present for a past
	// date.
	Last90DaysSearchInterest float64 `json:"last90DaysSearchInterest,omitempty"`
	// Next7DaysSearchInterest: Estimated search interest in the next 7 days, with
	// the same normalization as search_interest. This field is only present for a
	// future date.
	Next7DaysSearchInterest float64 `json:"next7DaysSearchInterest,omitempty"`
	// SearchInterest: Daily search interest, normalized to the time and country to
	// make comparisons easier, with 100 representing peak popularity (from 0 to
	// 100) for the requested time period and location.
	SearchInterest float64 `json:"searchInterest,omitempty"`
	// Topic: Google-provided topic trends are calculated for. Only top eight
	// topics are returned. Topic is what shoppers are searching for on Google,
	// grouped by the same concept.
	Topic string `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomerCountryCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomerCountryCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TopicTrends) MarshalJSON() ([]byte, error) {
	type NoMethod TopicTrends
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *TopicTrends) UnmarshalJSON(data []byte) error {
	type NoMethod TopicTrends
	var s1 struct {
		Last120DaysSearchInterest gensupport.JSONFloat64 `json:"last120DaysSearchInterest"`
		Last30DaysSearchInterest  gensupport.JSONFloat64 `json:"last30DaysSearchInterest"`
		Last7DaysSearchInterest   gensupport.JSONFloat64 `json:"last7DaysSearchInterest"`
		Last90DaysSearchInterest  gensupport.JSONFloat64 `json:"last90DaysSearchInterest"`
		Next7DaysSearchInterest   gensupport.JSONFloat64 `json:"next7DaysSearchInterest"`
		SearchInterest            gensupport.JSONFloat64 `json:"searchInterest"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Last120DaysSearchInterest = float64(s1.Last120DaysSearchInterest)
	s.Last30DaysSearchInterest = float64(s1.Last30DaysSearchInterest)
	s.Last7DaysSearchInterest = float64(s1.Last7DaysSearchInterest)
	s.Last90DaysSearchInterest = float64(s1.Last90DaysSearchInterest)
	s.Next7DaysSearchInterest = float64(s1.Next7DaysSearchInterest)
	s.SearchInterest = float64(s1.SearchInterest)
	return nil
}

type TransitTable struct {
	// PostalCodeGroupNames: A list of postal group names. The last value can be
	// "all other locations". Example: `["zone 1", "zone 2", "all other
	// locations"]`. The referred postal code groups must match the delivery
	// country of the service.
	PostalCodeGroupNames []string                      `json:"postalCodeGroupNames,omitempty"`
	Rows                 []*TransitTableTransitTimeRow `json:"rows,omitempty"`
	// TransitTimeLabels: A list of transit time labels. The last value can be
	// "all other labels". Example: `["food", "electronics", "all other
	// labels"]`.
	TransitTimeLabels []string `json:"transitTimeLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostalCodeGroupNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostalCodeGroupNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitTable) MarshalJSON() ([]byte, error) {
	type NoMethod TransitTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TransitTableTransitTimeRow struct {
	Values []*TransitTableTransitTimeRowTransitTimeValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitTableTransitTimeRow) MarshalJSON() ([]byte, error) {
	type NoMethod TransitTableTransitTimeRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TransitTableTransitTimeRowTransitTimeValue struct {
	// MaxTransitTimeInDays: Must be greater than or equal to
	// `minTransitTimeInDays`.
	MaxTransitTimeInDays int64 `json:"maxTransitTimeInDays,omitempty"`
	// MinTransitTimeInDays: Transit time range (min-max) in business days. 0 means
	// same day delivery, 1 means next day delivery.
	MinTransitTimeInDays int64 `json:"minTransitTimeInDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxTransitTimeInDays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxTransitTimeInDays") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitTableTransitTimeRowTransitTimeValue) MarshalJSON() ([]byte, error) {
	type NoMethod TransitTableTransitTimeRowTransitTimeValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerActionPayload: The payload for the triggered action.
type TriggerActionPayload struct {
	// ActionContext: Required. The context from the selected action. The value is
	// obtained from rendered issues and needs to be sent back to identify the
	// action that is being triggered.
	ActionContext string `json:"actionContext,omitempty"`
	// ActionInput: Required. Input provided by the merchant.
	ActionInput *ActionInput `json:"actionInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerActionPayload) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerActionPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TriggerActionResponse: Response informing about the started action.
type TriggerActionResponse struct {
	// Message: The message for merchant.
	Message string `json:"message,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TriggerActionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TriggerActionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UndeleteConversionSourceRequest: Request message for the
// UndeleteConversionSource method.
type UndeleteConversionSourceRequest struct {
}

// UrlSettings: Specifications related to the `Checkout` URL. The `UriTemplate`
// is of the form `https://www.mystore.com/checkout?item_id={id}` where `{id}`
// will be automatically replaced with data from the merchant account with this
// attribute offer_id
// (https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.offer_id)
type UrlSettings struct {
	// CartUriTemplate: URL template when the placeholders are expanded will
	// redirect the buyer to the cart page on the merchant website with the
	// selected item in cart.
	CartUriTemplate string `json:"cartUriTemplate,omitempty"`
	// CheckoutUriTemplate: URL template when the placeholders are expanded will
	// redirect the buyer to the merchant checkout page with the item in the cart.
	CheckoutUriTemplate string `json:"checkoutUriTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CartUriTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CartUriTemplate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UrlSettings) MarshalJSON() ([]byte, error) {
	type NoMethod UrlSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Value: The single value of a rate group or the value of a rate group table's
// cell. Exactly one of `noShipping`, `flatRate`, `pricePercentage`,
// `carrierRateName`, `subtableName` must be set.
type Value struct {
	// CarrierRateName: The name of a carrier rate referring to a carrier rate
	// defined in the same rate group. Can only be set if all other fields are not
	// set.
	CarrierRateName string `json:"carrierRateName,omitempty"`
	// FlatRate: A flat rate. Can only be set if all other fields are not set.
	FlatRate *Price `json:"flatRate,omitempty"`
	// NoShipping: If true, then the product can't ship. Must be true when set, can
	// only be set if all other fields are not set.
	NoShipping bool `json:"noShipping,omitempty"`
	// PricePercentage: A percentage of the price represented as a number in
	// decimal notation (for example, "5.4"). Can only be set if all other fields
	// are not set.
	PricePercentage string `json:"pricePercentage,omitempty"`
	// SubtableName: The name of a subtable. Can only be set in table cells (not
	// for single values), and only if all other fields are not set.
	SubtableName string `json:"subtableName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CarrierRateName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CarrierRateName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Value) MarshalJSON() ([]byte, error) {
	type NoMethod Value
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerifyPhoneNumberRequest: Request message for the VerifyPhoneNumber method.
type VerifyPhoneNumberRequest struct {
	// PhoneVerificationMethod: Verification method used to receive verification
	// code.
	//
	// Possible values:
	//   "PHONE_VERIFICATION_METHOD_UNSPECIFIED" - Unknown method.
	//   "SMS" - Receive verification code by SMS.
	//   "PHONE_CALL" - Receive verification code by phone call.
	PhoneVerificationMethod string `json:"phoneVerificationMethod,omitempty"`
	// VerificationCode: The verification code that was sent to the phone number
	// for validation.
	VerificationCode string `json:"verificationCode,omitempty"`
	// VerificationId: The verification ID returned by `requestphoneverification`.
	VerificationId string `json:"verificationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneVerificationMethod") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneVerificationMethod") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VerifyPhoneNumberRequest) MarshalJSON() ([]byte, error) {
	type NoMethod VerifyPhoneNumberRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerifyPhoneNumberResponse: Response message for the VerifyPhoneNumber
// method.
type VerifyPhoneNumberResponse struct {
	// VerifiedPhoneNumber: Verified phone number if verification is successful.
	// This phone number can only be replaced by another verified phone number.
	VerifiedPhoneNumber string `json:"verifiedPhoneNumber,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "VerifiedPhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VerifiedPhoneNumber") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VerifyPhoneNumberResponse) MarshalJSON() ([]byte, error) {
	type NoMethod VerifyPhoneNumberResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Warehouse: A fulfillment warehouse, which stores and handles inventory.
type Warehouse struct {
	// BusinessDayConfig: Business days of the warehouse. If not set, will be
	// Monday to Friday by default.
	BusinessDayConfig *BusinessDayConfig `json:"businessDayConfig,omitempty"`
	// CutoffTime: Required. The latest time of day that an order can be accepted
	// and begin processing. Later orders will be processed in the next day. The
	// time is based on the warehouse postal code.
	CutoffTime *WarehouseCutoffTime `json:"cutoffTime,omitempty"`
	// HandlingDays: Required. The number of days it takes for this warehouse to
	// pack up and ship an item. This is on the warehouse level, but can be
	// overridden on the offer level based on the attributes of an item.
	HandlingDays int64 `json:"handlingDays,omitempty,string"`
	// Name: Required. The name of the warehouse. Must be unique within account.
	Name string `json:"name,omitempty"`
	// ShippingAddress: Required. Shipping address of the warehouse.
	ShippingAddress *Address `json:"shippingAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BusinessDayConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BusinessDayConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Warehouse) MarshalJSON() ([]byte, error) {
	type NoMethod Warehouse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type WarehouseBasedDeliveryTime struct {
	// Carrier: Required. Carrier, such as "UPS" or "Fedex". The list of
	// supported carriers can be retrieved through the `listSupportedCarriers`
	// method.
	Carrier string `json:"carrier,omitempty"`
	// CarrierService: Required. Carrier service, such as "ground" or "2 days".
	// The list of supported services for a carrier can be retrieved through the
	// `listSupportedCarriers` method. The name of the service must be in the
	// eddSupportedServices list.
	CarrierService string `json:"carrierService,omitempty"`
	// OriginAdministrativeArea: Shipping origin's state.
	OriginAdministrativeArea string `json:"originAdministrativeArea,omitempty"`
	// OriginCity: Shipping origin's city.
	OriginCity string `json:"originCity,omitempty"`
	// OriginCountry: Shipping origin's country represented as a CLDR territory
	// code (https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
	OriginCountry string `json:"originCountry,omitempty"`
	// OriginPostalCode: Shipping origin.
	OriginPostalCode string `json:"originPostalCode,omitempty"`
	// OriginStreetAddress: Shipping origin's street address.
	OriginStreetAddress string `json:"originStreetAddress,omitempty"`
	// WarehouseName: The name of the warehouse. Warehouse name need to be matched
	// with name. If warehouseName is set, the below fields will be ignored. The
	// warehouse info will be read from warehouse.
	WarehouseName string `json:"warehouseName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Carrier") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Carrier") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WarehouseBasedDeliveryTime) MarshalJSON() ([]byte, error) {
	type NoMethod WarehouseBasedDeliveryTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type WarehouseCutoffTime struct {
	// Hour: Required. Hour (24-hour clock) of the cutoff time until which an order
	// has to be placed to be processed in the same day by the warehouse. Hour is
	// based on the timezone of warehouse.
	Hour int64 `json:"hour,omitempty"`
	// Minute: Required. Minute of the cutoff time until which an order has to be
	// placed to be processed in the same day by the warehouse. Minute is based on
	// the timezone of warehouse.
	Minute int64 `json:"minute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hour") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hour") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WarehouseCutoffTime) MarshalJSON() ([]byte, error) {
	type NoMethod WarehouseCutoffTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Weight struct {
	// Unit: Required. The weight unit. Acceptable values are: - "kg" - "lb"
	Unit string `json:"unit,omitempty"`
	// Value: Required. The weight represented as a number. The weight can have a
	// maximum precision of four decimal places.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Weight) MarshalJSON() ([]byte, error) {
	type NoMethod Weight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsAuthinfoCall struct {
	s            *APIService
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Authinfo: Returns information about the authenticated user.
func (r *AccountsService) Authinfo() *AccountsAuthinfoCall {
	c := &AccountsAuthinfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsAuthinfoCall) Fields(s ...googleapi.Field) *AccountsAuthinfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsAuthinfoCall) IfNoneMatch(entityTag string) *AccountsAuthinfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsAuthinfoCall) Context(ctx context.Context) *AccountsAuthinfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsAuthinfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAuthinfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/authinfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.authinfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.authinfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsAuthInfoResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsAuthinfoCall) Do(opts ...googleapi.CallOption) (*AccountsAuthInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountsAuthInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.authinfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsClaimwebsiteCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Claimwebsite: Claims the website of a Merchant Center sub-account. Merchant
// accounts with approved third-party CSSs aren't required to claim a website.
//
//   - accountId: The ID of the account whose website is claimed.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *AccountsService) Claimwebsite(merchantId uint64, accountId uint64) *AccountsClaimwebsiteCall {
	c := &AccountsClaimwebsiteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Overwrite sets the optional parameter "overwrite": Only available to
// selected merchants, for example multi-client accounts (MCAs) and their
// sub-accounts. When set to `True`, this option removes any existing claim on
// the requested website and replaces it with a claim from the account that
// makes the request.
func (c *AccountsClaimwebsiteCall) Overwrite(overwrite bool) *AccountsClaimwebsiteCall {
	c.urlParams_.Set("overwrite", fmt.Sprint(overwrite))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsClaimwebsiteCall) Fields(s ...googleapi.Field) *AccountsClaimwebsiteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsClaimwebsiteCall) Context(ctx context.Context) *AccountsClaimwebsiteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsClaimwebsiteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsClaimwebsiteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/claimwebsite")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.claimwebsite", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.claimwebsite" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsClaimWebsiteResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsClaimwebsiteCall) Do(opts ...googleapi.CallOption) (*AccountsClaimWebsiteResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountsClaimWebsiteResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.claimwebsite", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsCustombatchCall struct {
	s                          *APIService
	accountscustombatchrequest *AccountsCustomBatchRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Custombatch: Retrieves, inserts, updates, and deletes multiple Merchant
// Center (sub-)accounts in a single request.
func (r *AccountsService) Custombatch(accountscustombatchrequest *AccountsCustomBatchRequest) *AccountsCustombatchCall {
	c := &AccountsCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountscustombatchrequest = accountscustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsCustombatchCall) Fields(s ...googleapi.Field) *AccountsCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsCustombatchCall) Context(ctx context.Context) *AccountsCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountscustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsCustomBatchResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsCustombatchCall) Do(opts ...googleapi.CallOption) (*AccountsCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountsCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsDeleteCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Merchant Center sub-account.
//
//   - accountId: The ID of the account.
//   - merchantId: The ID of the managing account. This must be a multi-client
//     account, and accountId must be the ID of a sub-account of this account.
func (r *AccountsService) Delete(merchantId uint64, accountId uint64) *AccountsDeleteCall {
	c := &AccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Force sets the optional parameter "force": Option to delete sub-accounts
// with products. The default value is false.
func (c *AccountsDeleteCall) Force(force bool) *AccountsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsDeleteCall) Fields(s ...googleapi.Field) *AccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsDeleteCall) Context(ctx context.Context) *AccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.delete" call.
func (c *AccountsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type AccountsGetCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a Merchant Center account.
//
//   - accountId: The ID of the account.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *AccountsService) Get(merchantId uint64, accountId uint64) *AccountsGetCall {
	c := &AccountsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// View sets the optional parameter "view": Controls which fields will be
// populated. Acceptable values are: "merchant" and "css". The default value is
// "merchant".
//
// Possible values:
//
//	"MERCHANT" - Default. View is populated with Merchant Center fields.
//	"CSS" - View is populated with Comparison Shopping Services fields.
func (c *AccountsGetCall) View(view string) *AccountsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsGetCall) Fields(s ...googleapi.Field) *AccountsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsGetCall) IfNoneMatch(entityTag string) *AccountsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsGetCall) Context(ctx context.Context) *AccountsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Account.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsGetCall) Do(opts ...googleapi.CallOption) (*Account, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Account{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsInsertCall struct {
	s          *APIService
	merchantId uint64
	account    *Account
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a Merchant Center sub-account.
//
//   - merchantId: The ID of the managing account. This must be a multi-client
//     account.
func (r *AccountsService) Insert(merchantId uint64, account *Account) *AccountsInsertCall {
	c := &AccountsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.account = account
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsInsertCall) Fields(s ...googleapi.Field) *AccountsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsInsertCall) Context(ctx context.Context) *AccountsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.account)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Account.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsInsertCall) Do(opts ...googleapi.CallOption) (*Account, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Account{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsLinkCall struct {
	s                   *APIService
	merchantId          uint64
	accountId           uint64
	accountslinkrequest *AccountsLinkRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Link: Performs an action on a link between two Merchant Center accounts,
// namely accountId and linkedAccountId.
//
//   - accountId: The ID of the account that should be linked.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *AccountsService) Link(merchantId uint64, accountId uint64, accountslinkrequest *AccountsLinkRequest) *AccountsLinkCall {
	c := &AccountsLinkCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.accountslinkrequest = accountslinkrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsLinkCall) Fields(s ...googleapi.Field) *AccountsLinkCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsLinkCall) Context(ctx context.Context) *AccountsLinkCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsLinkCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLinkCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountslinkrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/link")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.link", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.link" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsLinkResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsLinkCall) Do(opts ...googleapi.CallOption) (*AccountsLinkResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountsLinkResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.link", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the sub-accounts in your Merchant Center account.
//
//   - merchantId: The ID of the managing account. This must be a multi-client
//     account.
func (r *AccountsService) List(merchantId uint64) *AccountsListCall {
	c := &AccountsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// Label sets the optional parameter "label": If view is set to "css", only
// return accounts that are assigned label with given ID.
func (c *AccountsListCall) Label(label uint64) *AccountsListCall {
	c.urlParams_.Set("label", fmt.Sprint(label))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// accounts to return in the response, used for paging.
func (c *AccountsListCall) MaxResults(maxResults int64) *AccountsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Name sets the optional parameter "name": If set, only the accounts with the
// given name (case sensitive) will be returned.
func (c *AccountsListCall) Name(name string) *AccountsListCall {
	c.urlParams_.Set("name", name)
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned by the
// previous request.
func (c *AccountsListCall) PageToken(pageToken string) *AccountsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Controls which fields will be
// populated. Acceptable values are: "merchant" and "css". The default value is
// "merchant".
//
// Possible values:
//
//	"MERCHANT" - Default. View is populated with Merchant Center fields.
//	"CSS" - View is populated with Comparison Shopping Services fields.
func (c *AccountsListCall) View(view string) *AccountsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsListCall) Fields(s ...googleapi.Field) *AccountsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsListCall) IfNoneMatch(entityTag string) *AccountsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsListCall) Context(ctx context.Context) *AccountsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsListCall) Do(opts ...googleapi.CallOption) (*AccountsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListCall) Pages(ctx context.Context, f func(*AccountsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AccountsListlinksCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Listlinks: Returns the list of accounts linked to your Merchant Center
// account.
//
//   - accountId: The ID of the account for which to list links.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *AccountsService) Listlinks(merchantId uint64, accountId uint64) *AccountsListlinksCall {
	c := &AccountsListlinksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// links to return in the response, used for pagination. The minimum allowed
// value is 5 results per page. If provided value is lower than 5, it will be
// automatically increased to 5.
func (c *AccountsListlinksCall) MaxResults(maxResults int64) *AccountsListlinksCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned by the
// previous request.
func (c *AccountsListlinksCall) PageToken(pageToken string) *AccountsListlinksCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsListlinksCall) Fields(s ...googleapi.Field) *AccountsListlinksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsListlinksCall) IfNoneMatch(entityTag string) *AccountsListlinksCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsListlinksCall) Context(ctx context.Context) *AccountsListlinksCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsListlinksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListlinksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/listlinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.listlinks", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.listlinks" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsListLinksResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsListlinksCall) Do(opts ...googleapi.CallOption) (*AccountsListLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountsListLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.listlinks", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListlinksCall) Pages(ctx context.Context, f func(*AccountsListLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AccountsRequestphoneverificationCall struct {
	s                               *APIService
	merchantId                      int64
	accountId                       int64
	requestphoneverificationrequest *RequestPhoneVerificationRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Requestphoneverification: Request verification code to start phone
// verification.
//
//   - accountId: The ID of the account.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     accountId must be the ID of a sub-account of this account.
func (r *AccountsService) Requestphoneverification(merchantId int64, accountId int64, requestphoneverificationrequest *RequestPhoneVerificationRequest) *AccountsRequestphoneverificationCall {
	c := &AccountsRequestphoneverificationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.requestphoneverificationrequest = requestphoneverificationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsRequestphoneverificationCall) Fields(s ...googleapi.Field) *AccountsRequestphoneverificationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsRequestphoneverificationCall) Context(ctx context.Context) *AccountsRequestphoneverificationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsRequestphoneverificationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsRequestphoneverificationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.requestphoneverificationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/requestphoneverification")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"accountId":  strconv.FormatInt(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.requestphoneverification", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.requestphoneverification" call.
// Any non-2xx status code is an error. Response headers are in either
// *RequestPhoneVerificationResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsRequestphoneverificationCall) Do(opts ...googleapi.CallOption) (*RequestPhoneVerificationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RequestPhoneVerificationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.requestphoneverification", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsUpdateCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	account    *Account
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a Merchant Center account. Any fields that are not provided
// are deleted from the resource.
//
//   - accountId: The ID of the account.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *AccountsService) Update(merchantId uint64, accountId uint64, account *Account) *AccountsUpdateCall {
	c := &AccountsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.account = account
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsUpdateCall) Fields(s ...googleapi.Field) *AccountsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsUpdateCall) Context(ctx context.Context) *AccountsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.account)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Account.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsUpdateCall) Do(opts ...googleapi.CallOption) (*Account, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Account{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsUpdatelabelsCall struct {
	s                           *APIService
	merchantId                  uint64
	accountId                   uint64
	accountsupdatelabelsrequest *AccountsUpdateLabelsRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Updatelabels: Updates labels that are assigned to the Merchant Center
// account by CSS user.
//
// - accountId: The ID of the account whose labels are updated.
// - merchantId: The ID of the managing account.
func (r *AccountsService) Updatelabels(merchantId uint64, accountId uint64, accountsupdatelabelsrequest *AccountsUpdateLabelsRequest) *AccountsUpdatelabelsCall {
	c := &AccountsUpdatelabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.accountsupdatelabelsrequest = accountsupdatelabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsUpdatelabelsCall) Fields(s ...googleapi.Field) *AccountsUpdatelabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsUpdatelabelsCall) Context(ctx context.Context) *AccountsUpdatelabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsUpdatelabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUpdatelabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountsupdatelabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/updatelabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.updatelabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.updatelabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountsUpdateLabelsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsUpdatelabelsCall) Do(opts ...googleapi.CallOption) (*AccountsUpdateLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountsUpdateLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.updatelabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsVerifyphonenumberCall struct {
	s                        *APIService
	merchantId               int64
	accountId                int64
	verifyphonenumberrequest *VerifyPhoneNumberRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Verifyphonenumber: Validates verification code to verify phone number for
// the account. If successful this will overwrite the value of
// `accounts.businessinformation.phoneNumber`. Only verified phone number will
// replace an existing verified phone number.
//
//   - accountId: The ID of the account.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     accountId must be the ID of a sub-account of this account.
func (r *AccountsService) Verifyphonenumber(merchantId int64, accountId int64, verifyphonenumberrequest *VerifyPhoneNumberRequest) *AccountsVerifyphonenumberCall {
	c := &AccountsVerifyphonenumberCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.verifyphonenumberrequest = verifyphonenumberrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsVerifyphonenumberCall) Fields(s ...googleapi.Field) *AccountsVerifyphonenumberCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsVerifyphonenumberCall) Context(ctx context.Context) *AccountsVerifyphonenumberCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsVerifyphonenumberCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsVerifyphonenumberCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.verifyphonenumberrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounts/{accountId}/verifyphonenumber")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"accountId":  strconv.FormatInt(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.verifyphonenumber", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.verifyphonenumber" call.
// Any non-2xx status code is an error. Response headers are in either
// *VerifyPhoneNumberResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsVerifyphonenumberCall) Do(opts ...googleapi.CallOption) (*VerifyPhoneNumberResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VerifyPhoneNumberResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.verifyphonenumber", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsCredentialsCreateCall struct {
	s                  *APIService
	accountId          int64
	accountcredentials *AccountCredentials
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Uploads credentials for the Merchant Center account. If credentials
// already exist for this Merchant Center account and purpose, this method
// updates them.
//
// - accountId: The merchant id of the account these credentials belong to.
func (r *AccountsCredentialsService) Create(accountId int64, accountcredentials *AccountCredentials) *AccountsCredentialsCreateCall {
	c := &AccountsCredentialsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.accountcredentials = accountcredentials
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsCredentialsCreateCall) Fields(s ...googleapi.Field) *AccountsCredentialsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsCredentialsCreateCall) Context(ctx context.Context) *AccountsCredentialsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsCredentialsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsCredentialsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountcredentials)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/credentials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.credentials.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.credentials.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountCredentials.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsCredentialsCreateCall) Do(opts ...googleapi.CallOption) (*AccountCredentials, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountCredentials{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.credentials.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsLabelsCreateCall struct {
	s            *APIService
	accountId    int64
	accountlabel *AccountLabel
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new label, not assigned to any account.
//
// - accountId: The id of the account this label belongs to.
func (r *AccountsLabelsService) Create(accountId int64, accountlabel *AccountLabel) *AccountsLabelsCreateCall {
	c := &AccountsLabelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.accountlabel = accountlabel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsLabelsCreateCall) Fields(s ...googleapi.Field) *AccountsLabelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsLabelsCreateCall) Context(ctx context.Context) *AccountsLabelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsLabelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLabelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountlabel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/labels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.labels.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.labels.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountLabel.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsLabelsCreateCall) Do(opts ...googleapi.CallOption) (*AccountLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.labels.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsLabelsDeleteCall struct {
	s          *APIService
	accountId  int64
	labelId    int64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a label and removes it from all accounts to which it was
// assigned.
//
// - accountId: The id of the account that owns the label.
// - labelId: The id of the label to delete.
func (r *AccountsLabelsService) Delete(accountId int64, labelId int64) *AccountsLabelsDeleteCall {
	c := &AccountsLabelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.labelId = labelId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsLabelsDeleteCall) Fields(s ...googleapi.Field) *AccountsLabelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsLabelsDeleteCall) Context(ctx context.Context) *AccountsLabelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsLabelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLabelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/labels/{labelId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
		"labelId":   strconv.FormatInt(c.labelId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.labels.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.labels.delete" call.
func (c *AccountsLabelsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.labels.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type AccountsLabelsListCall struct {
	s            *APIService
	accountId    int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the labels assigned to an account.
//
// - accountId: The account id for whose labels are to be listed.
func (r *AccountsLabelsService) List(accountId int64) *AccountsLabelsListCall {
	c := &AccountsLabelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// labels to return. The service may return fewer than this value. If
// unspecified, at most 50 labels will be returned. The maximum value is 1000;
// values above 1000 will be coerced to 1000.
func (c *AccountsLabelsListCall) PageSize(pageSize int64) *AccountsLabelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAccountLabels` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListAccountLabels` must match the call that provided the page token.
func (c *AccountsLabelsListCall) PageToken(pageToken string) *AccountsLabelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsLabelsListCall) Fields(s ...googleapi.Field) *AccountsLabelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsLabelsListCall) IfNoneMatch(entityTag string) *AccountsLabelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsLabelsListCall) Context(ctx context.Context) *AccountsLabelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsLabelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLabelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/labels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.labels.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.labels.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAccountLabelsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsLabelsListCall) Do(opts ...googleapi.CallOption) (*ListAccountLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAccountLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.labels.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsLabelsListCall) Pages(ctx context.Context, f func(*ListAccountLabelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AccountsLabelsPatchCall struct {
	s            *APIService
	accountId    int64
	labelId      int64
	accountlabel *AccountLabel
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates a label.
//
// - accountId: The id of the account this label belongs to.
// - labelId: The id of the label to update.
func (r *AccountsLabelsService) Patch(accountId int64, labelId int64, accountlabel *AccountLabel) *AccountsLabelsPatchCall {
	c := &AccountsLabelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.labelId = labelId
	c.accountlabel = accountlabel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsLabelsPatchCall) Fields(s ...googleapi.Field) *AccountsLabelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsLabelsPatchCall) Context(ctx context.Context) *AccountsLabelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsLabelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLabelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountlabel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/labels/{labelId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
		"labelId":   strconv.FormatInt(c.labelId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.labels.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.labels.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountLabel.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsLabelsPatchCall) Do(opts ...googleapi.CallOption) (*AccountLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.labels.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsReturncarrierCreateCall struct {
	s                    *APIService
	accountId            int64
	accountreturncarrier *AccountReturnCarrier
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Create: Links return carrier to a merchant account.
//
//   - accountId: The Merchant Center Account Id under which the Return Carrier
//     is to be linked.
func (r *AccountsReturncarrierService) Create(accountId int64, accountreturncarrier *AccountReturnCarrier) *AccountsReturncarrierCreateCall {
	c := &AccountsReturncarrierCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.accountreturncarrier = accountreturncarrier
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsReturncarrierCreateCall) Fields(s ...googleapi.Field) *AccountsReturncarrierCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsReturncarrierCreateCall) Context(ctx context.Context) *AccountsReturncarrierCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsReturncarrierCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReturncarrierCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountreturncarrier)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/returncarrier")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.returncarrier.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.returncarrier.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountReturnCarrier.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsReturncarrierCreateCall) Do(opts ...googleapi.CallOption) (*AccountReturnCarrier, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountReturnCarrier{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.returncarrier.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsReturncarrierDeleteCall struct {
	s                *APIService
	accountId        int64
	carrierAccountId int64
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Delete: Delete a return carrier in the merchant account.
//
//   - accountId: The Merchant Center Account Id under which the Return Carrier
//     is to be linked.
//   - carrierAccountId: The Google-provided unique carrier ID, used to update
//     the resource.
func (r *AccountsReturncarrierService) Delete(accountId int64, carrierAccountId int64) *AccountsReturncarrierDeleteCall {
	c := &AccountsReturncarrierDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.carrierAccountId = carrierAccountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsReturncarrierDeleteCall) Fields(s ...googleapi.Field) *AccountsReturncarrierDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsReturncarrierDeleteCall) Context(ctx context.Context) *AccountsReturncarrierDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsReturncarrierDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReturncarrierDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/returncarrier/{carrierAccountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId":        strconv.FormatInt(c.accountId, 10),
		"carrierAccountId": strconv.FormatInt(c.carrierAccountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.returncarrier.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.returncarrier.delete" call.
func (c *AccountsReturncarrierDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.returncarrier.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type AccountsReturncarrierListCall struct {
	s            *APIService
	accountId    int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists available return carriers in the merchant account.
//
//   - accountId: The Merchant Center Account Id under which the Return Carrier
//     is to be linked.
func (r *AccountsReturncarrierService) List(accountId int64) *AccountsReturncarrierListCall {
	c := &AccountsReturncarrierListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsReturncarrierListCall) Fields(s ...googleapi.Field) *AccountsReturncarrierListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountsReturncarrierListCall) IfNoneMatch(entityTag string) *AccountsReturncarrierListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsReturncarrierListCall) Context(ctx context.Context) *AccountsReturncarrierListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsReturncarrierListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReturncarrierListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/returncarrier")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId": strconv.FormatInt(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.returncarrier.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.returncarrier.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAccountReturnCarrierResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsReturncarrierListCall) Do(opts ...googleapi.CallOption) (*ListAccountReturnCarrierResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAccountReturnCarrierResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.returncarrier.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsReturncarrierPatchCall struct {
	s                    *APIService
	accountId            int64
	carrierAccountId     int64
	accountreturncarrier *AccountReturnCarrier
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Patch: Updates a return carrier in the merchant account.
//
//   - accountId: The Merchant Center Account Id under which the Return Carrier
//     is to be linked.
//   - carrierAccountId: The Google-provided unique carrier ID, used to update
//     the resource.
func (r *AccountsReturncarrierService) Patch(accountId int64, carrierAccountId int64, accountreturncarrier *AccountReturnCarrier) *AccountsReturncarrierPatchCall {
	c := &AccountsReturncarrierPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountId = accountId
	c.carrierAccountId = carrierAccountId
	c.accountreturncarrier = accountreturncarrier
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsReturncarrierPatchCall) Fields(s ...googleapi.Field) *AccountsReturncarrierPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsReturncarrierPatchCall) Context(ctx context.Context) *AccountsReturncarrierPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsReturncarrierPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReturncarrierPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountreturncarrier)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounts/{accountId}/returncarrier/{carrierAccountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"accountId":        strconv.FormatInt(c.accountId, 10),
		"carrierAccountId": strconv.FormatInt(c.carrierAccountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounts.returncarrier.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounts.returncarrier.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountReturnCarrier.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsReturncarrierPatchCall) Do(opts ...googleapi.CallOption) (*AccountReturnCarrier, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountReturnCarrier{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounts.returncarrier.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountstatusesCustombatchCall struct {
	s                                 *APIService
	accountstatusescustombatchrequest *AccountstatusesCustomBatchRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Custombatch: Retrieves multiple Merchant Center account statuses in a single
// request.
func (r *AccountstatusesService) Custombatch(accountstatusescustombatchrequest *AccountstatusesCustomBatchRequest) *AccountstatusesCustombatchCall {
	c := &AccountstatusesCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accountstatusescustombatchrequest = accountstatusescustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountstatusesCustombatchCall) Fields(s ...googleapi.Field) *AccountstatusesCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountstatusesCustombatchCall) Context(ctx context.Context) *AccountstatusesCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountstatusesCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountstatusesCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accountstatusescustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accountstatuses/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accountstatuses.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accountstatuses.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountstatusesCustomBatchResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountstatusesCustombatchCall) Do(opts ...googleapi.CallOption) (*AccountstatusesCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountstatusesCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accountstatuses.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountstatusesGetCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the status of a Merchant Center account. No itemLevelIssues
// are returned for multi-client accounts.
//
//   - accountId: The ID of the account.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *AccountstatusesService) Get(merchantId uint64, accountId uint64) *AccountstatusesGetCall {
	c := &AccountstatusesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Destinations sets the optional parameter "destinations": If set, only issues
// for the specified destinations are returned, otherwise only issues for the
// Shopping destination.
func (c *AccountstatusesGetCall) Destinations(destinations ...string) *AccountstatusesGetCall {
	c.urlParams_.SetMulti("destinations", append([]string{}, destinations...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountstatusesGetCall) Fields(s ...googleapi.Field) *AccountstatusesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountstatusesGetCall) IfNoneMatch(entityTag string) *AccountstatusesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountstatusesGetCall) Context(ctx context.Context) *AccountstatusesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountstatusesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountstatusesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accountstatuses/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accountstatuses.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accountstatuses.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountStatus.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountstatusesGetCall) Do(opts ...googleapi.CallOption) (*AccountStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accountstatuses.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountstatusesListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the statuses of the sub-accounts in your Merchant Center
// account.
//
//   - merchantId: The ID of the managing account. This must be a multi-client
//     account.
func (r *AccountstatusesService) List(merchantId uint64) *AccountstatusesListCall {
	c := &AccountstatusesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// Destinations sets the optional parameter "destinations": If set, only issues
// for the specified destinations are returned, otherwise only issues for the
// Shopping destination.
func (c *AccountstatusesListCall) Destinations(destinations ...string) *AccountstatusesListCall {
	c.urlParams_.SetMulti("destinations", append([]string{}, destinations...))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// account statuses to return in the response, used for paging.
func (c *AccountstatusesListCall) MaxResults(maxResults int64) *AccountstatusesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Name sets the optional parameter "name": If set, only the accounts with the
// given name (case sensitive) will be returned.
func (c *AccountstatusesListCall) Name(name string) *AccountstatusesListCall {
	c.urlParams_.Set("name", name)
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned by the
// previous request.
func (c *AccountstatusesListCall) PageToken(pageToken string) *AccountstatusesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountstatusesListCall) Fields(s ...googleapi.Field) *AccountstatusesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccountstatusesListCall) IfNoneMatch(entityTag string) *AccountstatusesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountstatusesListCall) Context(ctx context.Context) *AccountstatusesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountstatusesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountstatusesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accountstatuses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accountstatuses.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accountstatuses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountstatusesListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountstatusesListCall) Do(opts ...googleapi.CallOption) (*AccountstatusesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountstatusesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accountstatuses.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountstatusesListCall) Pages(ctx context.Context, f func(*AccountstatusesListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AccounttaxCustombatchCall struct {
	s                            *APIService
	accounttaxcustombatchrequest *AccounttaxCustomBatchRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Custombatch: Retrieves and updates tax settings of multiple accounts in a
// single request.
func (r *AccounttaxService) Custombatch(accounttaxcustombatchrequest *AccounttaxCustomBatchRequest) *AccounttaxCustombatchCall {
	c := &AccounttaxCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.accounttaxcustombatchrequest = accounttaxcustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccounttaxCustombatchCall) Fields(s ...googleapi.Field) *AccounttaxCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccounttaxCustombatchCall) Context(ctx context.Context) *AccounttaxCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccounttaxCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccounttaxCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accounttaxcustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "accounttax/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounttax.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounttax.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccounttaxCustomBatchResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccounttaxCustombatchCall) Do(opts ...googleapi.CallOption) (*AccounttaxCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccounttaxCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounttax.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccounttaxGetCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the tax settings of the account.
//
//   - accountId: The ID of the account for which to get/update account tax
//     settings.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *AccounttaxService) Get(merchantId uint64, accountId uint64) *AccounttaxGetCall {
	c := &AccounttaxGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccounttaxGetCall) Fields(s ...googleapi.Field) *AccounttaxGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccounttaxGetCall) IfNoneMatch(entityTag string) *AccounttaxGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccounttaxGetCall) Context(ctx context.Context) *AccounttaxGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccounttaxGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccounttaxGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounttax/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounttax.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounttax.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountTax.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccounttaxGetCall) Do(opts ...googleapi.CallOption) (*AccountTax, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountTax{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounttax.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccounttaxListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the tax settings of the sub-accounts in your Merchant Center
// account.
//
//   - merchantId: The ID of the managing account. This must be a multi-client
//     account.
func (r *AccounttaxService) List(merchantId uint64) *AccounttaxListCall {
	c := &AccounttaxListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// tax settings to return in the response, used for paging.
func (c *AccounttaxListCall) MaxResults(maxResults int64) *AccounttaxListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned by the
// previous request.
func (c *AccounttaxListCall) PageToken(pageToken string) *AccounttaxListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccounttaxListCall) Fields(s ...googleapi.Field) *AccounttaxListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AccounttaxListCall) IfNoneMatch(entityTag string) *AccounttaxListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccounttaxListCall) Context(ctx context.Context) *AccounttaxListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccounttaxListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccounttaxListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounttax")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounttax.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounttax.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccounttaxListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccounttaxListCall) Do(opts ...googleapi.CallOption) (*AccounttaxListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccounttaxListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounttax.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccounttaxListCall) Pages(ctx context.Context, f func(*AccounttaxListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type AccounttaxUpdateCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	accounttax *AccountTax
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the tax settings of the account. Any fields that are not
// provided are deleted from the resource.
//
//   - accountId: The ID of the account for which to get/update account tax
//     settings.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *AccounttaxService) Update(merchantId uint64, accountId uint64, accounttax *AccountTax) *AccounttaxUpdateCall {
	c := &AccounttaxUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.accounttax = accounttax
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccounttaxUpdateCall) Fields(s ...googleapi.Field) *AccounttaxUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccounttaxUpdateCall) Context(ctx context.Context) *AccounttaxUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccounttaxUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccounttaxUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.accounttax)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/accounttax/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.accounttax.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.accounttax.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccountTax.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccounttaxUpdateCall) Do(opts ...googleapi.CallOption) (*AccountTax, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccountTax{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.accounttax.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CollectionsCreateCall struct {
	s          *APIService
	merchantId int64
	collection *Collection
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Uploads a collection to your Merchant Center account. If a
// collection with the same collectionId already exists, this method updates
// that entry. In each update, the collection is completely replaced by the
// fields in the body of the update request.
//
//   - merchantId: The ID of the account that contains the collection. This
//     account cannot be a multi-client account.
func (r *CollectionsService) Create(merchantId int64, collection *Collection) *CollectionsCreateCall {
	c := &CollectionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.collection = collection
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CollectionsCreateCall) Fields(s ...googleapi.Field) *CollectionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CollectionsCreateCall) Context(ctx context.Context) *CollectionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CollectionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.collection)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.collections.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collections.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Collection.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CollectionsCreateCall) Do(opts ...googleapi.CallOption) (*Collection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Collection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.collections.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CollectionsDeleteCall struct {
	s            *APIService
	merchantId   int64
	collectionId string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes a collection from your Merchant Center account.
//
//   - collectionId: The collectionId of the collection. CollectionId is the same
//     as the REST ID of the collection.
//   - merchantId: The ID of the account that contains the collection. This
//     account cannot be a multi-client account.
func (r *CollectionsService) Delete(merchantId int64, collectionId string) *CollectionsDeleteCall {
	c := &CollectionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.collectionId = collectionId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CollectionsDeleteCall) Fields(s ...googleapi.Field) *CollectionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CollectionsDeleteCall) Context(ctx context.Context) *CollectionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CollectionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collections/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":   strconv.FormatInt(c.merchantId, 10),
		"collectionId": c.collectionId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.collections.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collections.delete" call.
func (c *CollectionsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.collections.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type CollectionsGetCall struct {
	s            *APIService
	merchantId   int64
	collectionId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a collection from your Merchant Center account.
//
//   - collectionId: The REST ID of the collection.
//   - merchantId: The ID of the account that contains the collection. This
//     account cannot be a multi-client account.
func (r *CollectionsService) Get(merchantId int64, collectionId string) *CollectionsGetCall {
	c := &CollectionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.collectionId = collectionId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CollectionsGetCall) Fields(s ...googleapi.Field) *CollectionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CollectionsGetCall) IfNoneMatch(entityTag string) *CollectionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CollectionsGetCall) Context(ctx context.Context) *CollectionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CollectionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collections/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":   strconv.FormatInt(c.merchantId, 10),
		"collectionId": c.collectionId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.collections.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collections.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Collection.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CollectionsGetCall) Do(opts ...googleapi.CallOption) (*Collection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Collection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.collections.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CollectionsListCall struct {
	s            *APIService
	merchantId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the collections in your Merchant Center account. The response
// might contain fewer items than specified by page_size. Rely on
// next_page_token to determine if there are more items to be requested.
//
//   - merchantId: The ID of the account that contains the collection. This
//     account cannot be a multi-client account.
func (r *CollectionsService) List(merchantId int64) *CollectionsListCall {
	c := &CollectionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// collections to return in the response, used for paging. Defaults to 50;
// values above 1000 will be coerced to 1000.
func (c *CollectionsListCall) PageSize(pageSize int64) *CollectionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token (if provided) to
// retrieve the subsequent page. All other parameters must match the original
// call that provided the page token.
func (c *CollectionsListCall) PageToken(pageToken string) *CollectionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CollectionsListCall) Fields(s ...googleapi.Field) *CollectionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CollectionsListCall) IfNoneMatch(entityTag string) *CollectionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CollectionsListCall) Context(ctx context.Context) *CollectionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CollectionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.collections.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collections.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCollectionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CollectionsListCall) Do(opts ...googleapi.CallOption) (*ListCollectionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCollectionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.collections.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CollectionsListCall) Pages(ctx context.Context, f func(*ListCollectionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CollectionstatusesGetCall struct {
	s            *APIService
	merchantId   int64
	collectionId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the status of a collection from your Merchant Center account.
//
//   - collectionId: The collectionId of the collection. CollectionId is the same
//     as the REST ID of the collection.
//   - merchantId: The ID of the account that contains the collection. This
//     account cannot be a multi-client account.
func (r *CollectionstatusesService) Get(merchantId int64, collectionId string) *CollectionstatusesGetCall {
	c := &CollectionstatusesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.collectionId = collectionId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CollectionstatusesGetCall) Fields(s ...googleapi.Field) *CollectionstatusesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CollectionstatusesGetCall) IfNoneMatch(entityTag string) *CollectionstatusesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CollectionstatusesGetCall) Context(ctx context.Context) *CollectionstatusesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CollectionstatusesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionstatusesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collectionstatuses/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":   strconv.FormatInt(c.merchantId, 10),
		"collectionId": c.collectionId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.collectionstatuses.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collectionstatuses.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CollectionStatus.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CollectionstatusesGetCall) Do(opts ...googleapi.CallOption) (*CollectionStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CollectionStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.collectionstatuses.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CollectionstatusesListCall struct {
	s            *APIService
	merchantId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the statuses of the collections in your Merchant Center account.
//
//   - merchantId: The ID of the account that contains the collection. This
//     account cannot be a multi-client account.
func (r *CollectionstatusesService) List(merchantId int64) *CollectionstatusesListCall {
	c := &CollectionstatusesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// collection statuses to return in the response, used for paging. Defaults to
// 50; values above 1000 will be coerced to 1000.
func (c *CollectionstatusesListCall) PageSize(pageSize int64) *CollectionstatusesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token (if provided) to
// retrieve the subsequent page. All other parameters must match the original
// call that provided the page token.
func (c *CollectionstatusesListCall) PageToken(pageToken string) *CollectionstatusesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CollectionstatusesListCall) Fields(s ...googleapi.Field) *CollectionstatusesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CollectionstatusesListCall) IfNoneMatch(entityTag string) *CollectionstatusesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CollectionstatusesListCall) Context(ctx context.Context) *CollectionstatusesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CollectionstatusesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CollectionstatusesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/collectionstatuses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.collectionstatuses.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.collectionstatuses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCollectionStatusesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CollectionstatusesListCall) Do(opts ...googleapi.CallOption) (*ListCollectionStatusesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCollectionStatusesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.collectionstatuses.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CollectionstatusesListCall) Pages(ctx context.Context, f func(*ListCollectionStatusesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ConversionsourcesCreateCall struct {
	s                *APIService
	merchantId       int64
	conversionsource *ConversionSource
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates a new conversion source.
//
// - merchantId: The ID of the account that owns the new conversion source.
func (r *ConversionsourcesService) Create(merchantId int64, conversionsource *ConversionSource) *ConversionsourcesCreateCall {
	c := &ConversionsourcesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.conversionsource = conversionsource
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ConversionsourcesCreateCall) Fields(s ...googleapi.Field) *ConversionsourcesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ConversionsourcesCreateCall) Context(ctx context.Context) *ConversionsourcesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ConversionsourcesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ConversionsourcesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.conversionsource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/conversionsources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.conversionsources.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.conversionsources.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConversionSource.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ConversionsourcesCreateCall) Do(opts ...googleapi.CallOption) (*ConversionSource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConversionSource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.conversionsources.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ConversionsourcesDeleteCall struct {
	s                  *APIService
	merchantId         int64
	conversionSourceId string
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Delete: Archives an existing conversion source. It will be recoverable for
// 30 days. This archiving behavior is not typical in the Content API and
// unique to this service.
//
// - conversionSourceId: The ID of the conversion source to be deleted.
// - merchantId: The ID of the account that owns the new conversion source.
func (r *ConversionsourcesService) Delete(merchantId int64, conversionSourceId string) *ConversionsourcesDeleteCall {
	c := &ConversionsourcesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.conversionSourceId = conversionSourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ConversionsourcesDeleteCall) Fields(s ...googleapi.Field) *ConversionsourcesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ConversionsourcesDeleteCall) Context(ctx context.Context) *ConversionsourcesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ConversionsourcesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ConversionsourcesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/conversionsources/{conversionSourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":         strconv.FormatInt(c.merchantId, 10),
		"conversionSourceId": c.conversionSourceId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.conversionsources.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.conversionsources.delete" call.
func (c *ConversionsourcesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.conversionsources.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type ConversionsourcesGetCall struct {
	s                  *APIService
	merchantId         int64
	conversionSourceId string
	urlParams_         gensupport.URLParams
	ifNoneMatch_       string
	ctx_               context.Context
	header_            http.Header
}

// Get: Fetches a conversion source.
//
// - conversionSourceId: The REST ID of the collection.
// - merchantId: The ID of the account that owns the new conversion source.
func (r *ConversionsourcesService) Get(merchantId int64, conversionSourceId string) *ConversionsourcesGetCall {
	c := &ConversionsourcesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.conversionSourceId = conversionSourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ConversionsourcesGetCall) Fields(s ...googleapi.Field) *ConversionsourcesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ConversionsourcesGetCall) IfNoneMatch(entityTag string) *ConversionsourcesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ConversionsourcesGetCall) Context(ctx context.Context) *ConversionsourcesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ConversionsourcesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ConversionsourcesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/conversionsources/{conversionSourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":         strconv.FormatInt(c.merchantId, 10),
		"conversionSourceId": c.conversionSourceId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.conversionsources.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.conversionsources.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConversionSource.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ConversionsourcesGetCall) Do(opts ...googleapi.CallOption) (*ConversionSource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConversionSource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.conversionsources.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ConversionsourcesListCall struct {
	s            *APIService
	merchantId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves the list of conversion sources the caller has access to.
//
// - merchantId: The ID of the account that owns the new conversion source.
func (r *ConversionsourcesService) List(merchantId int64) *ConversionsourcesListCall {
	c := &ConversionsourcesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// conversion sources to return in a page. If no `page_size` is specified,
// `100` is used as the default value. The maximum value is `200`. Values above
// `200` will be coerced to `200`. Regardless of pagination, at most `200`
// conversion sources are returned in total.
func (c *ConversionsourcesListCall) PageSize(pageSize int64) *ConversionsourcesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token.
func (c *ConversionsourcesListCall) PageToken(pageToken string) *ConversionsourcesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, also returns
// archived conversion sources.
func (c *ConversionsourcesListCall) ShowDeleted(showDeleted bool) *ConversionsourcesListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ConversionsourcesListCall) Fields(s ...googleapi.Field) *ConversionsourcesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ConversionsourcesListCall) IfNoneMatch(entityTag string) *ConversionsourcesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ConversionsourcesListCall) Context(ctx context.Context) *ConversionsourcesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ConversionsourcesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ConversionsourcesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/conversionsources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.conversionsources.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.conversionsources.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConversionSourcesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ConversionsourcesListCall) Do(opts ...googleapi.CallOption) (*ListConversionSourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConversionSourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.conversionsources.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ConversionsourcesListCall) Pages(ctx context.Context, f func(*ListConversionSourcesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ConversionsourcesPatchCall struct {
	s                  *APIService
	merchantId         int64
	conversionSourceId string
	conversionsource   *ConversionSource
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates information of an existing conversion source.
//
// - conversionSourceId: The ID of the conversion source to be updated.
// - merchantId: The ID of the account that owns the new conversion source.
func (r *ConversionsourcesService) Patch(merchantId int64, conversionSourceId string, conversionsource *ConversionSource) *ConversionsourcesPatchCall {
	c := &ConversionsourcesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.conversionSourceId = conversionSourceId
	c.conversionsource = conversionsource
	return c
}

// UpdateMask sets the optional parameter "updateMask": List of fields being
// updated.
func (c *ConversionsourcesPatchCall) UpdateMask(updateMask string) *ConversionsourcesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ConversionsourcesPatchCall) Fields(s ...googleapi.Field) *ConversionsourcesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ConversionsourcesPatchCall) Context(ctx context.Context) *ConversionsourcesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ConversionsourcesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ConversionsourcesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.conversionsource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/conversionsources/{conversionSourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":         strconv.FormatInt(c.merchantId, 10),
		"conversionSourceId": c.conversionSourceId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.conversionsources.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.conversionsources.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConversionSource.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ConversionsourcesPatchCall) Do(opts ...googleapi.CallOption) (*ConversionSource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConversionSource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.conversionsources.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ConversionsourcesUndeleteCall struct {
	s                               *APIService
	merchantId                      int64
	conversionSourceId              string
	undeleteconversionsourcerequest *UndeleteConversionSourceRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Undelete: Re-enables an archived conversion source.
//
// - conversionSourceId: The ID of the conversion source to be undeleted.
// - merchantId: The ID of the account that owns the new conversion source.
func (r *ConversionsourcesService) Undelete(merchantId int64, conversionSourceId string, undeleteconversionsourcerequest *UndeleteConversionSourceRequest) *ConversionsourcesUndeleteCall {
	c := &ConversionsourcesUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.conversionSourceId = conversionSourceId
	c.undeleteconversionsourcerequest = undeleteconversionsourcerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ConversionsourcesUndeleteCall) Fields(s ...googleapi.Field) *ConversionsourcesUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ConversionsourcesUndeleteCall) Context(ctx context.Context) *ConversionsourcesUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ConversionsourcesUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ConversionsourcesUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeleteconversionsourcerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/conversionsources/{conversionSourceId}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":         strconv.FormatInt(c.merchantId, 10),
		"conversionSourceId": c.conversionSourceId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.conversionsources.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.conversionsources.undelete" call.
func (c *ConversionsourcesUndeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.conversionsources.undelete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type CssesGetCall struct {
	s            *APIService
	cssGroupId   int64
	cssDomainId  int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a single CSS domain by ID.
//
//   - cssDomainId: The ID of the CSS domain to return.
//   - cssGroupId: The ID of the managing account. If this parameter is not the
//     same as cssDomainId (#cssDomainId), then this ID must be a CSS group ID
//     and `cssDomainId` must be the ID of a CSS domain affiliated with this
//     group.
func (r *CssesService) Get(cssGroupId int64, cssDomainId int64) *CssesGetCall {
	c := &CssesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.cssGroupId = cssGroupId
	c.cssDomainId = cssDomainId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CssesGetCall) Fields(s ...googleapi.Field) *CssesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CssesGetCall) IfNoneMatch(entityTag string) *CssesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CssesGetCall) Context(ctx context.Context) *CssesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CssesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CssesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{cssGroupId}/csses/{cssDomainId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"cssGroupId":  strconv.FormatInt(c.cssGroupId, 10),
		"cssDomainId": strconv.FormatInt(c.cssDomainId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.csses.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.csses.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Css.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CssesGetCall) Do(opts ...googleapi.CallOption) (*Css, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Css{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.csses.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CssesListCall struct {
	s            *APIService
	cssGroupId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists CSS domains affiliated with a CSS group.
//
// - cssGroupId: The CSS group ID of CSS domains to be listed.
func (r *CssesService) List(cssGroupId int64) *CssesListCall {
	c := &CssesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.cssGroupId = cssGroupId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of CSS
// domains to return. The service may return fewer than this value. If
// unspecified, at most 50 CSS domains will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *CssesListCall) PageSize(pageSize int64) *CssesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListCsses` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListCsses` must
// match the call that provided the page token.
func (c *CssesListCall) PageToken(pageToken string) *CssesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CssesListCall) Fields(s ...googleapi.Field) *CssesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CssesListCall) IfNoneMatch(entityTag string) *CssesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CssesListCall) Context(ctx context.Context) *CssesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CssesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CssesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{cssGroupId}/csses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"cssGroupId": strconv.FormatInt(c.cssGroupId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.csses.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.csses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCssesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CssesListCall) Do(opts ...googleapi.CallOption) (*ListCssesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCssesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.csses.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CssesListCall) Pages(ctx context.Context, f func(*ListCssesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CssesUpdatelabelsCall struct {
	s           *APIService
	cssGroupId  int64
	cssDomainId int64
	labelids    *LabelIds
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Updatelabels: Updates labels that are assigned to a CSS domain by its CSS
// group.
//
// - cssDomainId: The ID of the updated CSS domain.
// - cssGroupId: The CSS group ID of the updated CSS domain.
func (r *CssesService) Updatelabels(cssGroupId int64, cssDomainId int64, labelids *LabelIds) *CssesUpdatelabelsCall {
	c := &CssesUpdatelabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.cssGroupId = cssGroupId
	c.cssDomainId = cssDomainId
	c.labelids = labelids
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CssesUpdatelabelsCall) Fields(s ...googleapi.Field) *CssesUpdatelabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CssesUpdatelabelsCall) Context(ctx context.Context) *CssesUpdatelabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CssesUpdatelabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CssesUpdatelabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.labelids)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{cssGroupId}/csses/{cssDomainId}/updatelabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"cssGroupId":  strconv.FormatInt(c.cssGroupId, 10),
		"cssDomainId": strconv.FormatInt(c.cssDomainId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.csses.updatelabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.csses.updatelabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *Css.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CssesUpdatelabelsCall) Do(opts ...googleapi.CallOption) (*Css, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Css{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.csses.updatelabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatafeedsCustombatchCall struct {
	s                           *APIService
	datafeedscustombatchrequest *DatafeedsCustomBatchRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Custombatch: Deletes, fetches, gets, inserts and updates multiple datafeeds
// in a single request.
func (r *DatafeedsService) Custombatch(datafeedscustombatchrequest *DatafeedsCustomBatchRequest) *DatafeedsCustombatchCall {
	c := &DatafeedsCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.datafeedscustombatchrequest = datafeedscustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedsCustombatchCall) Fields(s ...googleapi.Field) *DatafeedsCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedsCustombatchCall) Context(ctx context.Context) *DatafeedsCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedsCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedsCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.datafeedscustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "datafeeds/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeeds.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeeds.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatafeedsCustomBatchResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DatafeedsCustombatchCall) Do(opts ...googleapi.CallOption) (*DatafeedsCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatafeedsCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeeds.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatafeedsDeleteCall struct {
	s          *APIService
	merchantId uint64
	datafeedId uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a datafeed configuration from your Merchant Center account.
//
//   - datafeedId: The ID of the datafeed.
//   - merchantId: The ID of the account that manages the datafeed. This account
//     cannot be a multi-client account.
func (r *DatafeedsService) Delete(merchantId uint64, datafeedId uint64) *DatafeedsDeleteCall {
	c := &DatafeedsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.datafeedId = datafeedId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedsDeleteCall) Fields(s ...googleapi.Field) *DatafeedsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedsDeleteCall) Context(ctx context.Context) *DatafeedsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/datafeeds/{datafeedId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"datafeedId": strconv.FormatUint(c.datafeedId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeeds.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeeds.delete" call.
func (c *DatafeedsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeeds.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type DatafeedsFetchnowCall struct {
	s          *APIService
	merchantId uint64
	datafeedId uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Fetchnow: Invokes a fetch for the datafeed in your Merchant Center account.
// If you need to call this method more than once per day, we recommend you use
// the Products service
// (https://developers.google.com/shopping-content/reference/rest/v2.1/products)
// to update your product data.
//
//   - datafeedId: The ID of the datafeed to be fetched.
//   - merchantId: The ID of the account that manages the datafeed. This account
//     cannot be a multi-client account.
func (r *DatafeedsService) Fetchnow(merchantId uint64, datafeedId uint64) *DatafeedsFetchnowCall {
	c := &DatafeedsFetchnowCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.datafeedId = datafeedId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedsFetchnowCall) Fields(s ...googleapi.Field) *DatafeedsFetchnowCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedsFetchnowCall) Context(ctx context.Context) *DatafeedsFetchnowCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedsFetchnowCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedsFetchnowCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/datafeeds/{datafeedId}/fetchNow")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"datafeedId": strconv.FormatUint(c.datafeedId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeeds.fetchnow", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeeds.fetchnow" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatafeedsFetchNowResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DatafeedsFetchnowCall) Do(opts ...googleapi.CallOption) (*DatafeedsFetchNowResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatafeedsFetchNowResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeeds.fetchnow", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatafeedsGetCall struct {
	s            *APIService
	merchantId   uint64
	datafeedId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a datafeed configuration from your Merchant Center account.
//
//   - datafeedId: The ID of the datafeed.
//   - merchantId: The ID of the account that manages the datafeed. This account
//     cannot be a multi-client account.
func (r *DatafeedsService) Get(merchantId uint64, datafeedId uint64) *DatafeedsGetCall {
	c := &DatafeedsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.datafeedId = datafeedId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedsGetCall) Fields(s ...googleapi.Field) *DatafeedsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DatafeedsGetCall) IfNoneMatch(entityTag string) *DatafeedsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedsGetCall) Context(ctx context.Context) *DatafeedsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/datafeeds/{datafeedId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"datafeedId": strconv.FormatUint(c.datafeedId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeeds.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeeds.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Datafeed.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatafeedsGetCall) Do(opts ...googleapi.CallOption) (*Datafeed, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Datafeed{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeeds.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatafeedsInsertCall struct {
	s          *APIService
	merchantId uint64
	datafeed   *Datafeed
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Registers a datafeed configuration with your Merchant Center
// account.
//
//   - merchantId: The ID of the account that manages the datafeed. This account
//     cannot be a multi-client account.
func (r *DatafeedsService) Insert(merchantId uint64, datafeed *Datafeed) *DatafeedsInsertCall {
	c := &DatafeedsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.datafeed = datafeed
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedsInsertCall) Fields(s ...googleapi.Field) *DatafeedsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedsInsertCall) Context(ctx context.Context) *DatafeedsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.datafeed)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/datafeeds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeeds.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeeds.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Datafeed.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatafeedsInsertCall) Do(opts ...googleapi.CallOption) (*Datafeed, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Datafeed{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeeds.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatafeedsListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the configurations for datafeeds in your Merchant Center
// account.
//
//   - merchantId: The ID of the account that manages the datafeeds. This account
//     cannot be a multi-client account.
func (r *DatafeedsService) List(merchantId uint64) *DatafeedsListCall {
	c := &DatafeedsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// products to return in the response, used for paging.
func (c *DatafeedsListCall) MaxResults(maxResults int64) *DatafeedsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned by the
// previous request.
func (c *DatafeedsListCall) PageToken(pageToken string) *DatafeedsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedsListCall) Fields(s ...googleapi.Field) *DatafeedsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DatafeedsListCall) IfNoneMatch(entityTag string) *DatafeedsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedsListCall) Context(ctx context.Context) *DatafeedsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/datafeeds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeeds.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeeds.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatafeedsListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *DatafeedsListCall) Do(opts ...googleapi.CallOption) (*DatafeedsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatafeedsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeeds.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DatafeedsListCall) Pages(ctx context.Context, f func(*DatafeedsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type DatafeedsUpdateCall struct {
	s          *APIService
	merchantId uint64
	datafeedId uint64
	datafeed   *Datafeed
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a datafeed configuration of your Merchant Center account.
// Any fields that are not provided are deleted from the resource.
//
//   - datafeedId: The ID of the datafeed.
//   - merchantId: The ID of the account that manages the datafeed. This account
//     cannot be a multi-client account.
func (r *DatafeedsService) Update(merchantId uint64, datafeedId uint64, datafeed *Datafeed) *DatafeedsUpdateCall {
	c := &DatafeedsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.datafeedId = datafeedId
	c.datafeed = datafeed
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedsUpdateCall) Fields(s ...googleapi.Field) *DatafeedsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedsUpdateCall) Context(ctx context.Context) *DatafeedsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.datafeed)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/datafeeds/{datafeedId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"datafeedId": strconv.FormatUint(c.datafeedId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeeds.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeeds.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Datafeed.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatafeedsUpdateCall) Do(opts ...googleapi.CallOption) (*Datafeed, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Datafeed{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeeds.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatafeedstatusesCustombatchCall struct {
	s                                  *APIService
	datafeedstatusescustombatchrequest *DatafeedstatusesCustomBatchRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Custombatch: Gets multiple Merchant Center datafeed statuses in a single
// request.
func (r *DatafeedstatusesService) Custombatch(datafeedstatusescustombatchrequest *DatafeedstatusesCustomBatchRequest) *DatafeedstatusesCustombatchCall {
	c := &DatafeedstatusesCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.datafeedstatusescustombatchrequest = datafeedstatusescustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedstatusesCustombatchCall) Fields(s ...googleapi.Field) *DatafeedstatusesCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedstatusesCustombatchCall) Context(ctx context.Context) *DatafeedstatusesCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedstatusesCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedstatusesCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.datafeedstatusescustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "datafeedstatuses/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeedstatuses.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeedstatuses.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatafeedstatusesCustomBatchResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DatafeedstatusesCustombatchCall) Do(opts ...googleapi.CallOption) (*DatafeedstatusesCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatafeedstatusesCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeedstatuses.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatafeedstatusesGetCall struct {
	s            *APIService
	merchantId   uint64
	datafeedId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the status of a datafeed from your Merchant Center account.
//
//   - datafeedId: The ID of the datafeed.
//   - merchantId: The ID of the account that manages the datafeed. This account
//     cannot be a multi-client account.
func (r *DatafeedstatusesService) Get(merchantId uint64, datafeedId uint64) *DatafeedstatusesGetCall {
	c := &DatafeedstatusesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.datafeedId = datafeedId
	return c
}

// Country sets the optional parameter "country": Deprecated. Use `feedLabel`
// instead. The country to get the datafeed status for. If this parameter is
// provided then `language` must also be provided. Note that this parameter is
// required for feeds targeting multiple countries and languages, since a feed
// may have a different status for each target.
func (c *DatafeedstatusesGetCall) Country(country string) *DatafeedstatusesGetCall {
	c.urlParams_.Set("country", country)
	return c
}

// FeedLabel sets the optional parameter "feedLabel": The feed label to get the
// datafeed status for. If this parameter is provided then `language` must also
// be provided. Note that this parameter is required for feeds targeting
// multiple countries and languages, since a feed may have a different status
// for each target.
func (c *DatafeedstatusesGetCall) FeedLabel(feedLabel string) *DatafeedstatusesGetCall {
	c.urlParams_.Set("feedLabel", feedLabel)
	return c
}

// Language sets the optional parameter "language": The language to get the
// datafeed status for. If this parameter is provided then `country` must also
// be provided. Note that this parameter is required for feeds targeting
// multiple countries and languages, since a feed may have a different status
// for each target.
func (c *DatafeedstatusesGetCall) Language(language string) *DatafeedstatusesGetCall {
	c.urlParams_.Set("language", language)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedstatusesGetCall) Fields(s ...googleapi.Field) *DatafeedstatusesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DatafeedstatusesGetCall) IfNoneMatch(entityTag string) *DatafeedstatusesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedstatusesGetCall) Context(ctx context.Context) *DatafeedstatusesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedstatusesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedstatusesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/datafeedstatuses/{datafeedId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"datafeedId": strconv.FormatUint(c.datafeedId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeedstatuses.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeedstatuses.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatafeedStatus.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatafeedstatusesGetCall) Do(opts ...googleapi.CallOption) (*DatafeedStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatafeedStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeedstatuses.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatafeedstatusesListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the statuses of the datafeeds in your Merchant Center account.
//
//   - merchantId: The ID of the account that manages the datafeeds. This account
//     cannot be a multi-client account.
func (r *DatafeedstatusesService) List(merchantId uint64) *DatafeedstatusesListCall {
	c := &DatafeedstatusesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// products to return in the response, used for paging.
func (c *DatafeedstatusesListCall) MaxResults(maxResults int64) *DatafeedstatusesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned by the
// previous request.
func (c *DatafeedstatusesListCall) PageToken(pageToken string) *DatafeedstatusesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatafeedstatusesListCall) Fields(s ...googleapi.Field) *DatafeedstatusesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DatafeedstatusesListCall) IfNoneMatch(entityTag string) *DatafeedstatusesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatafeedstatusesListCall) Context(ctx context.Context) *DatafeedstatusesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatafeedstatusesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatafeedstatusesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/datafeedstatuses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.datafeedstatuses.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.datafeedstatuses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatafeedstatusesListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DatafeedstatusesListCall) Do(opts ...googleapi.CallOption) (*DatafeedstatusesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatafeedstatusesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.datafeedstatuses.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DatafeedstatusesListCall) Pages(ctx context.Context, f func(*DatafeedstatusesListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FreelistingsprogramGetCall struct {
	s            *APIService
	merchantId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the status and review eligibility for the free listing
// program. Returns errors and warnings if they require action to resolve, will
// become disapprovals, or impact impressions. Use `accountstatuses` to view
// all issues for an account.
//
// - merchantId: The ID of the account.
func (r *FreelistingsprogramService) Get(merchantId int64) *FreelistingsprogramGetCall {
	c := &FreelistingsprogramGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FreelistingsprogramGetCall) Fields(s ...googleapi.Field) *FreelistingsprogramGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FreelistingsprogramGetCall) IfNoneMatch(entityTag string) *FreelistingsprogramGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FreelistingsprogramGetCall) Context(ctx context.Context) *FreelistingsprogramGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FreelistingsprogramGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FreelistingsprogramGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/freelistingsprogram")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.freelistingsprogram.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.freelistingsprogram.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FreeListingsProgramStatus.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FreelistingsprogramGetCall) Do(opts ...googleapi.CallOption) (*FreeListingsProgramStatus, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FreeListingsProgramStatus{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.freelistingsprogram.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FreelistingsprogramRequestreviewCall struct {
	s                                *APIService
	merchantId                       int64
	requestreviewfreelistingsrequest *RequestReviewFreeListingsRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Requestreview: Requests a review of free listings in a specific region. This
// method deprecated. Use the `MerchantSupportService` to view product and
// account issues and request a review.
//
// - merchantId: The ID of the account.
func (r *FreelistingsprogramService) Requestreview(merchantId int64, requestreviewfreelistingsrequest *RequestReviewFreeListingsRequest) *FreelistingsprogramRequestreviewCall {
	c := &FreelistingsprogramRequestreviewCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.requestreviewfreelistingsrequest = requestreviewfreelistingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FreelistingsprogramRequestreviewCall) Fields(s ...googleapi.Field) *FreelistingsprogramRequestreviewCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FreelistingsprogramRequestreviewCall) Context(ctx context.Context) *FreelistingsprogramRequestreviewCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FreelistingsprogramRequestreviewCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FreelistingsprogramRequestreviewCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.requestreviewfreelistingsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/freelistingsprogram/requestreview")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.freelistingsprogram.requestreview", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.freelistingsprogram.requestreview" call.
func (c *FreelistingsprogramRequestreviewCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.freelistingsprogram.requestreview", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type FreelistingsprogramCheckoutsettingsDeleteCall struct {
	s          *APIService
	merchantId int64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes `Checkout` settings and unenrolls merchant from `Checkout`
// program.
//
// - merchantId: The ID of the account.
func (r *FreelistingsprogramCheckoutsettingsService) Delete(merchantId int64) *FreelistingsprogramCheckoutsettingsDeleteCall {
	c := &FreelistingsprogramCheckoutsettingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FreelistingsprogramCheckoutsettingsDeleteCall) Fields(s ...googleapi.Field) *FreelistingsprogramCheckoutsettingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FreelistingsprogramCheckoutsettingsDeleteCall) Context(ctx context.Context) *FreelistingsprogramCheckoutsettingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FreelistingsprogramCheckoutsettingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FreelistingsprogramCheckoutsettingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/freelistingsprogram/checkoutsettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.freelistingsprogram.checkoutsettings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.freelistingsprogram.checkoutsettings.delete" call.
func (c *FreelistingsprogramCheckoutsettingsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.freelistingsprogram.checkoutsettings.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type FreelistingsprogramCheckoutsettingsGetCall struct {
	s            *APIService
	merchantId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets Checkout settings for the given merchant. This includes
// information about review state, enrollment state and URL settings.
//
// - merchantId: The ID of the account.
func (r *FreelistingsprogramCheckoutsettingsService) Get(merchantId int64) *FreelistingsprogramCheckoutsettingsGetCall {
	c := &FreelistingsprogramCheckoutsettingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FreelistingsprogramCheckoutsettingsGetCall) Fields(s ...googleapi.Field) *FreelistingsprogramCheckoutsettingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FreelistingsprogramCheckoutsettingsGetCall) IfNoneMatch(entityTag string) *FreelistingsprogramCheckoutsettingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FreelistingsprogramCheckoutsettingsGetCall) Context(ctx context.Context) *FreelistingsprogramCheckoutsettingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FreelistingsprogramCheckoutsettingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FreelistingsprogramCheckoutsettingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/freelistingsprogram/checkoutsettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.freelistingsprogram.checkoutsettings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.freelistingsprogram.checkoutsettings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckoutSettings.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FreelistingsprogramCheckoutsettingsGetCall) Do(opts ...googleapi.CallOption) (*CheckoutSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckoutSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.freelistingsprogram.checkoutsettings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FreelistingsprogramCheckoutsettingsInsertCall struct {
	s                             *APIService
	merchantId                    int64
	insertcheckoutsettingsrequest *InsertCheckoutSettingsRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Insert: Enrolls merchant in `Checkout` program.
//
// - merchantId: The ID of the account.
func (r *FreelistingsprogramCheckoutsettingsService) Insert(merchantId int64, insertcheckoutsettingsrequest *InsertCheckoutSettingsRequest) *FreelistingsprogramCheckoutsettingsInsertCall {
	c := &FreelistingsprogramCheckoutsettingsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.insertcheckoutsettingsrequest = insertcheckoutsettingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FreelistingsprogramCheckoutsettingsInsertCall) Fields(s ...googleapi.Field) *FreelistingsprogramCheckoutsettingsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FreelistingsprogramCheckoutsettingsInsertCall) Context(ctx context.Context) *FreelistingsprogramCheckoutsettingsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FreelistingsprogramCheckoutsettingsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FreelistingsprogramCheckoutsettingsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.insertcheckoutsettingsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/freelistingsprogram/checkoutsettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.freelistingsprogram.checkoutsettings.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.freelistingsprogram.checkoutsettings.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckoutSettings.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FreelistingsprogramCheckoutsettingsInsertCall) Do(opts ...googleapi.CallOption) (*CheckoutSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckoutSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.freelistingsprogram.checkoutsettings.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsCustombatchCall struct {
	s                             *APIService
	liasettingscustombatchrequest *LiasettingsCustomBatchRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Custombatch: Retrieves and/or updates the LIA settings of multiple accounts
// in a single request.
func (r *LiasettingsService) Custombatch(liasettingscustombatchrequest *LiasettingsCustomBatchRequest) *LiasettingsCustombatchCall {
	c := &LiasettingsCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.liasettingscustombatchrequest = liasettingscustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsCustombatchCall) Fields(s ...googleapi.Field) *LiasettingsCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsCustombatchCall) Context(ctx context.Context) *LiasettingsCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.liasettingscustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "liasettings/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiasettingsCustomBatchResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsCustombatchCall) Do(opts ...googleapi.CallOption) (*LiasettingsCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiasettingsCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsGetCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the LIA settings of the account.
//
//   - accountId: The ID of the account for which to get or update LIA settings.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *LiasettingsService) Get(merchantId uint64, accountId uint64) *LiasettingsGetCall {
	c := &LiasettingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsGetCall) Fields(s ...googleapi.Field) *LiasettingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LiasettingsGetCall) IfNoneMatch(entityTag string) *LiasettingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsGetCall) Context(ctx context.Context) *LiasettingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiaSettings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LiasettingsGetCall) Do(opts ...googleapi.CallOption) (*LiaSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiaSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsGetaccessiblegmbaccountsCall struct {
	s            *APIService
	merchantId   uint64
	accountId    uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Getaccessiblegmbaccounts: Retrieves the list of accessible Business
// Profiles.
//
//   - accountId: The ID of the account for which to retrieve accessible Business
//     Profiles.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *LiasettingsService) Getaccessiblegmbaccounts(merchantId uint64, accountId uint64) *LiasettingsGetaccessiblegmbaccountsCall {
	c := &LiasettingsGetaccessiblegmbaccountsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsGetaccessiblegmbaccountsCall) Fields(s ...googleapi.Field) *LiasettingsGetaccessiblegmbaccountsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LiasettingsGetaccessiblegmbaccountsCall) IfNoneMatch(entityTag string) *LiasettingsGetaccessiblegmbaccountsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsGetaccessiblegmbaccountsCall) Context(ctx context.Context) *LiasettingsGetaccessiblegmbaccountsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsGetaccessiblegmbaccountsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsGetaccessiblegmbaccountsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings/{accountId}/accessiblegmbaccounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.getaccessiblegmbaccounts", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.getaccessiblegmbaccounts" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiasettingsGetAccessibleGmbAccountsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsGetaccessiblegmbaccountsCall) Do(opts ...googleapi.CallOption) (*LiasettingsGetAccessibleGmbAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiasettingsGetAccessibleGmbAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.getaccessiblegmbaccounts", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsListCall struct {
	s            *APIService
	merchantId   uint64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the LIA settings of the sub-accounts in your Merchant Center
// account.
//
//   - merchantId: The ID of the managing account. This must be a multi-client
//     account.
func (r *LiasettingsService) List(merchantId uint64) *LiasettingsListCall {
	c := &LiasettingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// LIA settings to return in the response, used for paging.
func (c *LiasettingsListCall) MaxResults(maxResults int64) *LiasettingsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": The token returned by the
// previous request.
func (c *LiasettingsListCall) PageToken(pageToken string) *LiasettingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsListCall) Fields(s ...googleapi.Field) *LiasettingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LiasettingsListCall) IfNoneMatch(entityTag string) *LiasettingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsListCall) Context(ctx context.Context) *LiasettingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiasettingsListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsListCall) Do(opts ...googleapi.CallOption) (*LiasettingsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiasettingsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LiasettingsListCall) Pages(ctx context.Context, f func(*LiasettingsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type LiasettingsListposdataprovidersCall struct {
	s            *APIService
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Listposdataproviders: Retrieves the list of POS data providers that have
// active settings for the all eiligible countries.
func (r *LiasettingsService) Listposdataproviders() *LiasettingsListposdataprovidersCall {
	c := &LiasettingsListposdataprovidersCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsListposdataprovidersCall) Fields(s ...googleapi.Field) *LiasettingsListposdataprovidersCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LiasettingsListposdataprovidersCall) IfNoneMatch(entityTag string) *LiasettingsListposdataprovidersCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsListposdataprovidersCall) Context(ctx context.Context) *LiasettingsListposdataprovidersCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsListposdataprovidersCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsListposdataprovidersCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "liasettings/posdataproviders")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.listposdataproviders", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.listposdataproviders" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiasettingsListPosDataProvidersResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsListposdataprovidersCall) Do(opts ...googleapi.CallOption) (*LiasettingsListPosDataProvidersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiasettingsListPosDataProvidersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.listposdataproviders", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsRequestgmbaccessCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Requestgmbaccess: Requests access to a specified Business Profile.
//
//   - accountId: The ID of the account for which Business Profile access is
//     requested.
//   - gmbEmail: The email of the Business Profile.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *LiasettingsService) Requestgmbaccess(merchantId uint64, accountId uint64, gmbEmail string) *LiasettingsRequestgmbaccessCall {
	c := &LiasettingsRequestgmbaccessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.urlParams_.Set("gmbEmail", gmbEmail)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsRequestgmbaccessCall) Fields(s ...googleapi.Field) *LiasettingsRequestgmbaccessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsRequestgmbaccessCall) Context(ctx context.Context) *LiasettingsRequestgmbaccessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsRequestgmbaccessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsRequestgmbaccessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings/{accountId}/requestgmbaccess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.requestgmbaccess", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.requestgmbaccess" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiasettingsRequestGmbAccessResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsRequestgmbaccessCall) Do(opts ...googleapi.CallOption) (*LiasettingsRequestGmbAccessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiasettingsRequestGmbAccessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.requestgmbaccess", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsRequestinventoryverificationCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	country    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Requestinventoryverification: Requests inventory validation for the
// specified country.
//
//   - accountId: The ID of the account that manages the order. This cannot be a
//     multi-client account.
//   - country: The country for which inventory validation is requested.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *LiasettingsService) Requestinventoryverification(merchantId uint64, accountId uint64, country string) *LiasettingsRequestinventoryverificationCall {
	c := &LiasettingsRequestinventoryverificationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.country = country
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsRequestinventoryverificationCall) Fields(s ...googleapi.Field) *LiasettingsRequestinventoryverificationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsRequestinventoryverificationCall) Context(ctx context.Context) *LiasettingsRequestinventoryverificationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsRequestinventoryverificationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsRequestinventoryverificationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings/{accountId}/requestinventoryverification/{country}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
		"country":    c.country,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.requestinventoryverification", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.requestinventoryverification" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiasettingsRequestInventoryVerificationResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsRequestinventoryverificationCall) Do(opts ...googleapi.CallOption) (*LiasettingsRequestInventoryVerificationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiasettingsRequestInventoryVerificationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.requestinventoryverification", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsSetinventoryverificationcontactCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Setinventoryverificationcontact: Sets the inventory verification contract
// for the specified country.
//
//   - accountId: The ID of the account that manages the order. This cannot be a
//     multi-client account.
//   - contactEmail: The email of the inventory verification contact.
//   - contactName: The name of the inventory verification contact.
//   - country: The country for which inventory verification is requested.
//   - language: The language for which inventory verification is requested.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *LiasettingsService) Setinventoryverificationcontact(merchantId uint64, accountId uint64, country string, language string, contactName string, contactEmail string) *LiasettingsSetinventoryverificationcontactCall {
	c := &LiasettingsSetinventoryverificationcontactCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.urlParams_.Set("country", country)
	c.urlParams_.Set("language", language)
	c.urlParams_.Set("contactName", contactName)
	c.urlParams_.Set("contactEmail", contactEmail)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsSetinventoryverificationcontactCall) Fields(s ...googleapi.Field) *LiasettingsSetinventoryverificationcontactCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsSetinventoryverificationcontactCall) Context(ctx context.Context) *LiasettingsSetinventoryverificationcontactCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsSetinventoryverificationcontactCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsSetinventoryverificationcontactCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings/{accountId}/setinventoryverificationcontact")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.setinventoryverificationcontact", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.setinventoryverificationcontact" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiasettingsSetInventoryVerificationContactResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsSetinventoryverificationcontactCall) Do(opts ...googleapi.CallOption) (*LiasettingsSetInventoryVerificationContactResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiasettingsSetInventoryVerificationContactResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.setinventoryverificationcontact", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsSetomnichannelexperienceCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Setomnichannelexperience: Sets the omnichannel experience for the specified
// country. Only supported for merchants whose POS data provider is trusted to
// enable the corresponding experience. For more context, see these help
// articles about LFP (https://support.google.com/merchants/answer/7676652) and
// how to get started (https://support.google.com/merchants/answer/7676578)
// with it.
//
//   - accountId: The ID of the account for which to retrieve accessible Business
//     Profiles.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *LiasettingsService) Setomnichannelexperience(merchantId uint64, accountId uint64) *LiasettingsSetomnichannelexperienceCall {
	c := &LiasettingsSetomnichannelexperienceCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	return c
}

// Country sets the optional parameter "country": The CLDR country code (for
// example, "US") for which the omnichannel experience is selected.
func (c *LiasettingsSetomnichannelexperienceCall) Country(country string) *LiasettingsSetomnichannelexperienceCall {
	c.urlParams_.Set("country", country)
	return c
}

// LsfType sets the optional parameter "lsfType": The Local Store Front (LSF)
// type for this country. Acceptable values are: - "ghlsf" (Google-Hosted
// Local Store Front) - "mhlsfBasic" (Merchant-Hosted Local Store Front
// Basic) - "mhlsfFull" (Merchant-Hosted Local Store Front Full) More details
// about these types can be found here.
func (c *LiasettingsSetomnichannelexperienceCall) LsfType(lsfType string) *LiasettingsSetomnichannelexperienceCall {
	c.urlParams_.Set("lsfType", lsfType)
	return c
}

// PickupTypes sets the optional parameter "pickupTypes": The Pickup types for
// this country. Acceptable values are: - "pickupToday" - "pickupLater"
func (c *LiasettingsSetomnichannelexperienceCall) PickupTypes(pickupTypes ...string) *LiasettingsSetomnichannelexperienceCall {
	c.urlParams_.SetMulti("pickupTypes", append([]string{}, pickupTypes...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsSetomnichannelexperienceCall) Fields(s ...googleapi.Field) *LiasettingsSetomnichannelexperienceCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsSetomnichannelexperienceCall) Context(ctx context.Context) *LiasettingsSetomnichannelexperienceCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsSetomnichannelexperienceCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsSetomnichannelexperienceCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings/{accountId}/setomnichannelexperience")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.setomnichannelexperience", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.setomnichannelexperience" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiaOmnichannelExperience.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsSetomnichannelexperienceCall) Do(opts ...googleapi.CallOption) (*LiaOmnichannelExperience, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiaOmnichannelExperience{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.setomnichannelexperience", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsSetposdataproviderCall struct {
	s          *APIService
	merchantId uint64
	accountId  uint64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Setposdataprovider: Sets the POS data provider for the specified country.
//
//   - accountId: The ID of the account for which to retrieve accessible Business
//     Profiles.
//   - country: The country for which the POS data provider is selected.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *LiasettingsService) Setposdataprovider(merchantId uint64, accountId uint64, country string) *LiasettingsSetposdataproviderCall {
	c := &LiasettingsSetposdataproviderCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.urlParams_.Set("country", country)
	return c
}

// PosDataProviderId sets the optional parameter "posDataProviderId": The ID of
// POS data provider.
func (c *LiasettingsSetposdataproviderCall) PosDataProviderId(posDataProviderId uint64) *LiasettingsSetposdataproviderCall {
	c.urlParams_.Set("posDataProviderId", fmt.Sprint(posDataProviderId))
	return c
}

// PosExternalAccountId sets the optional parameter "posExternalAccountId": The
// account ID by which this merchant is known to the POS data provider.
func (c *LiasettingsSetposdataproviderCall) PosExternalAccountId(posExternalAccountId string) *LiasettingsSetposdataproviderCall {
	c.urlParams_.Set("posExternalAccountId", posExternalAccountId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsSetposdataproviderCall) Fields(s ...googleapi.Field) *LiasettingsSetposdataproviderCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsSetposdataproviderCall) Context(ctx context.Context) *LiasettingsSetposdataproviderCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsSetposdataproviderCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsSetposdataproviderCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings/{accountId}/setposdataprovider")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.setposdataprovider", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.setposdataprovider" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiasettingsSetPosDataProviderResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LiasettingsSetposdataproviderCall) Do(opts ...googleapi.CallOption) (*LiasettingsSetPosDataProviderResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiasettingsSetPosDataProviderResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.setposdataprovider", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LiasettingsUpdateCall struct {
	s           *APIService
	merchantId  uint64
	accountId   uint64
	liasettings *LiaSettings
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates the LIA settings of the account. Any fields that are not
// provided are deleted from the resource.
//
//   - accountId: The ID of the account for which to get or update LIA settings.
//   - merchantId: The ID of the managing account. If this parameter is not the
//     same as accountId, then this account must be a multi-client account and
//     `accountId` must be the ID of a sub-account of this account.
func (r *LiasettingsService) Update(merchantId uint64, accountId uint64, liasettings *LiaSettings) *LiasettingsUpdateCall {
	c := &LiasettingsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.accountId = accountId
	c.liasettings = liasettings
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LiasettingsUpdateCall) Fields(s ...googleapi.Field) *LiasettingsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LiasettingsUpdateCall) Context(ctx context.Context) *LiasettingsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LiasettingsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LiasettingsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.liasettings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/liasettings/{accountId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"accountId":  strconv.FormatUint(c.accountId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.liasettings.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.liasettings.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *LiaSettings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LiasettingsUpdateCall) Do(opts ...googleapi.CallOption) (*LiaSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LiaSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.liasettings.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocalinventoryCustombatchCall struct {
	s                                *APIService
	localinventorycustombatchrequest *LocalinventoryCustomBatchRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Custombatch: Updates local inventory for multiple products or stores in a
// single request.
func (r *LocalinventoryService) Custombatch(localinventorycustombatchrequest *LocalinventoryCustomBatchRequest) *LocalinventoryCustombatchCall {
	c := &LocalinventoryCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.localinventorycustombatchrequest = localinventorycustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocalinventoryCustombatchCall) Fields(s ...googleapi.Field) *LocalinventoryCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocalinventoryCustombatchCall) Context(ctx context.Context) *LocalinventoryCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocalinventoryCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocalinventoryCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.localinventorycustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "localinventory/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.localinventory.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.localinventory.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LocalinventoryCustomBatchResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LocalinventoryCustombatchCall) Do(opts ...googleapi.CallOption) (*LocalinventoryCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LocalinventoryCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.localinventory.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocalinventoryInsertCall struct {
	s              *APIService
	merchantId     uint64
	productId      string
	localinventory *LocalInventory
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Insert: Updates the local inventory of a product in your Merchant Center
// account.
//
//   - merchantId: The ID of the account that contains the product. This account
//     cannot be a multi-client account.
//   - productId: The REST ID of the product for which to update local inventory.
func (r *LocalinventoryService) Insert(merchantId uint64, productId string, localinventory *LocalInventory) *LocalinventoryInsertCall {
	c := &LocalinventoryInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.productId = productId
	c.localinventory = localinventory
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocalinventoryInsertCall) Fields(s ...googleapi.Field) *LocalinventoryInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocalinventoryInsertCall) Context(ctx context.Context) *LocalinventoryInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocalinventoryInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocalinventoryInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.localinventory)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/products/{productId}/localinventory")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"productId":  c.productId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.localinventory.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.localinventory.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *LocalInventory.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocalinventoryInsertCall) Do(opts ...googleapi.CallOption) (*LocalInventory, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LocalInventory{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.localinventory.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type MerchantsupportRenderaccountissuesCall struct {
	s                                 *APIService
	merchantId                        int64
	renderaccountissuesrequestpayload *RenderAccountIssuesRequestPayload
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Renderaccountissues: Provide a list of merchant's issues with a support
// content and available actions. This content and actions are meant to be
// rendered and shown in third-party applications.
//
// - merchantId: The ID of the account to fetch issues for.
func (r *MerchantsupportService) Renderaccountissues(merchantId int64, renderaccountissuesrequestpayload *RenderAccountIssuesRequestPayload) *MerchantsupportRenderaccountissuesCall {
	c := &MerchantsupportRenderaccountissuesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.renderaccountissuesrequestpayload = renderaccountissuesrequestpayload
	return c
}

// LanguageCode sets the optional parameter "languageCode": The IETF BCP-47
// (https://tools.ietf.org/html/bcp47) language code used to localize support
// content. If not set, the result will be in default language `en-US`.
func (c *MerchantsupportRenderaccountissuesCall) LanguageCode(languageCode string) *MerchantsupportRenderaccountissuesCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// TimeZone sets the optional parameter "timeZone": The IANA
// (https://www.iana.org/time-zones) timezone used to localize times in support
// content. For example 'America/Los_Angeles'. If not set, results will use as
// a default UTC.
func (c *MerchantsupportRenderaccountissuesCall) TimeZone(timeZone string) *MerchantsupportRenderaccountissuesCall {
	c.urlParams_.Set("timeZone", timeZone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MerchantsupportRenderaccountissuesCall) Fields(s ...googleapi.Field) *MerchantsupportRenderaccountissuesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MerchantsupportRenderaccountissuesCall) Context(ctx context.Context) *MerchantsupportRenderaccountissuesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MerchantsupportRenderaccountissuesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MerchantsupportRenderaccountissuesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.renderaccountissuesrequestpayload)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/merchantsupport/renderaccountissues")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.merchantsupport.renderaccountissues", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.merchantsupport.renderaccountissues" call.
// Any non-2xx status code is an error. Response headers are in either
// *RenderAccountIssuesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MerchantsupportRenderaccountissuesCall) Do(opts ...googleapi.CallOption) (*RenderAccountIssuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RenderAccountIssuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.merchantsupport.renderaccountissues", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type MerchantsupportRenderproductissuesCall struct {
	s                                 *APIService
	merchantId                        int64
	productId                         string
	renderproductissuesrequestpayload *RenderProductIssuesRequestPayload
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Renderproductissues: Provide a list of issues for merchant's product with a
// support content and available actions. This content and actions are meant to
// be rendered and shown in third-party applications.
//
//   - merchantId: The ID of the account that contains the product.
//   - productId: The REST_ID
//     (https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.id)
//     of the product to fetch issues for.
func (r *MerchantsupportService) Renderproductissues(merchantId int64, productId string, renderproductissuesrequestpayload *RenderProductIssuesRequestPayload) *MerchantsupportRenderproductissuesCall {
	c := &MerchantsupportRenderproductissuesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.productId = productId
	c.renderproductissuesrequestpayload = renderproductissuesrequestpayload
	return c
}

// LanguageCode sets the optional parameter "languageCode": The IETF BCP-47
// (https://tools.ietf.org/html/bcp47) language code used to localize support
// content. If not set, the result will be in default language `en-US`.
func (c *MerchantsupportRenderproductissuesCall) LanguageCode(languageCode string) *MerchantsupportRenderproductissuesCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// TimeZone sets the optional parameter "timeZone": The IANA
// (https://www.iana.org/time-zones) timezone used to localize times in support
// content. For example 'America/Los_Angeles'. If not set, results will use as
// a default UTC.
func (c *MerchantsupportRenderproductissuesCall) TimeZone(timeZone string) *MerchantsupportRenderproductissuesCall {
	c.urlParams_.Set("timeZone", timeZone)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MerchantsupportRenderproductissuesCall) Fields(s ...googleapi.Field) *MerchantsupportRenderproductissuesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MerchantsupportRenderproductissuesCall) Context(ctx context.Context) *MerchantsupportRenderproductissuesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MerchantsupportRenderproductissuesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MerchantsupportRenderproductissuesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.renderproductissuesrequestpayload)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/merchantsupport/renderproductissues/{productId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"productId":  c.productId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.merchantsupport.renderproductissues", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.merchantsupport.renderproductissues" call.
// Any non-2xx status code is an error. Response headers are in either
// *RenderProductIssuesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MerchantsupportRenderproductissuesCall) Do(opts ...googleapi.CallOption) (*RenderProductIssuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RenderProductIssuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.merchantsupport.renderproductissues", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type MerchantsupportTriggeractionCall struct {
	s                    *APIService
	merchantId           int64
	triggeractionpayload *TriggerActionPayload
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Triggeraction: Start an action. The action can be requested by merchants in
// third-party application. Before merchants can request the action, the
// third-party application needs to show them action specific content and
// display a user input form. The action can be successfully started only once
// all `required` inputs are provided. If any `required` input is missing, or
// invalid value was provided, the service will return 400 error. Validation
// errors will contain Ids for all problematic field together with translated,
// human readable error messages that can be shown to the user.
//
// - merchantId: The ID of the merchant's account.
func (r *MerchantsupportService) Triggeraction(merchantId int64, triggeractionpayload *TriggerActionPayload) *MerchantsupportTriggeractionCall {
	c := &MerchantsupportTriggeractionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.triggeractionpayload = triggeractionpayload
	return c
}

// LanguageCode sets the optional parameter "languageCode": Language code IETF
// BCP 47 syntax (https://tools.ietf.org/html/bcp47) used to localize the
// response. If not set, the result will be in default language `en-US`.
func (c *MerchantsupportTriggeractionCall) LanguageCode(languageCode string) *MerchantsupportTriggeractionCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MerchantsupportTriggeractionCall) Fields(s ...googleapi.Field) *MerchantsupportTriggeractionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MerchantsupportTriggeractionCall) Context(ctx context.Context) *MerchantsupportTriggeractionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MerchantsupportTriggeractionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MerchantsupportTriggeractionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.triggeractionpayload)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/merchantsupport/triggeraction")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.merchantsupport.triggeraction", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.merchantsupport.triggeraction" call.
// Any non-2xx status code is an error. Response headers are in either
// *TriggerActionResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *MerchantsupportTriggeractionCall) Do(opts ...googleapi.CallOption) (*TriggerActionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TriggerActionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.merchantsupport.triggeraction", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrdertrackingsignalsCreateCall struct {
	s                   *APIService
	merchantId          int64
	ordertrackingsignal *OrderTrackingSignal
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates new order tracking signal.
//
// - merchantId: The ID of the merchant for which the order signal is created.
func (r *OrdertrackingsignalsService) Create(merchantId int64, ordertrackingsignal *OrderTrackingSignal) *OrdertrackingsignalsCreateCall {
	c := &OrdertrackingsignalsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.ordertrackingsignal = ordertrackingsignal
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrdertrackingsignalsCreateCall) Fields(s ...googleapi.Field) *OrdertrackingsignalsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrdertrackingsignalsCreateCall) Context(ctx context.Context) *OrdertrackingsignalsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrdertrackingsignalsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrdertrackingsignalsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.ordertrackingsignal)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/ordertrackingsignals")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.ordertrackingsignals.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.ordertrackingsignals.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *OrderTrackingSignal.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrdertrackingsignalsCreateCall) Do(opts ...googleapi.CallOption) (*OrderTrackingSignal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrderTrackingSignal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.ordertrackingsignals.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PosCustombatchCall struct {
	s                     *APIService
	poscustombatchrequest *PosCustomBatchRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Custombatch: Batches multiple POS-related calls in a single request.
func (r *PosService) Custombatch(poscustombatchrequest *PosCustomBatchRequest) *PosCustombatchCall {
	c := &PosCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.poscustombatchrequest = poscustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PosCustombatchCall) Fields(s ...googleapi.Field) *PosCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PosCustombatchCall) Context(ctx context.Context) *PosCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PosCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PosCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.poscustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "pos/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.pos.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.pos.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *PosCustomBatchResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PosCustombatchCall) Do(opts ...googleapi.CallOption) (*PosCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PosCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.pos.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PosDeleteCall struct {
	s                *APIService
	merchantId       uint64
	targetMerchantId uint64
	storeCode        string
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Delete: Deletes a store for the given merchant.
//
// - merchantId: The ID of the POS or inventory data provider.
// - storeCode: A store code that is unique per merchant.
// - targetMerchantId: The ID of the target merchant.
func (r *PosService) Delete(merchantId uint64, targetMerchantId uint64, storeCode string) *PosDeleteCall {
	c := &PosDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.targetMerchantId = targetMerchantId
	c.storeCode = storeCode
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PosDeleteCall) Fields(s ...googleapi.Field) *PosDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PosDeleteCall) Context(ctx context.Context) *PosDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PosDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PosDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/pos/{targetMerchantId}/store/{storeCode}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":       strconv.FormatUint(c.merchantId, 10),
		"targetMerchantId": strconv.FormatUint(c.targetMerchantId, 10),
		"storeCode":        c.storeCode,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.pos.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.pos.delete" call.
func (c *PosDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.pos.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type PosGetCall struct {
	s                *APIService
	merchantId       uint64
	targetMerchantId uint64
	storeCode        string
	urlParams_       gensupport.URLParams
	ifNoneMatch_     string
	ctx_             context.Context
	header_          http.Header
}

// Get: Retrieves information about the given store.
//
// - merchantId: The ID of the POS or inventory data provider.
// - storeCode: A store code that is unique per merchant.
// - targetMerchantId: The ID of the target merchant.
func (r *PosService) Get(merchantId uint64, targetMerchantId uint64, storeCode string) *PosGetCall {
	c := &PosGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.targetMerchantId = targetMerchantId
	c.storeCode = storeCode
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PosGetCall) Fields(s ...googleapi.Field) *PosGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PosGetCall) IfNoneMatch(entityTag string) *PosGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PosGetCall) Context(ctx context.Context) *PosGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PosGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PosGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/pos/{targetMerchantId}/store/{storeCode}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":       strconv.FormatUint(c.merchantId, 10),
		"targetMerchantId": strconv.FormatUint(c.targetMerchantId, 10),
		"storeCode":        c.storeCode,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.pos.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.pos.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PosStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PosGetCall) Do(opts ...googleapi.CallOption) (*PosStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PosStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.pos.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PosInsertCall struct {
	s                *APIService
	merchantId       uint64
	targetMerchantId uint64
	posstore         *PosStore
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Insert: Creates a store for the given merchant.
//
// - merchantId: The ID of the POS or inventory data provider.
// - targetMerchantId: The ID of the target merchant.
func (r *PosService) Insert(merchantId uint64, targetMerchantId uint64, posstore *PosStore) *PosInsertCall {
	c := &PosInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.targetMerchantId = targetMerchantId
	c.posstore = posstore
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PosInsertCall) Fields(s ...googleapi.Field) *PosInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PosInsertCall) Context(ctx context.Context) *PosInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PosInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PosInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.posstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/pos/{targetMerchantId}/store")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":       strconv.FormatUint(c.merchantId, 10),
		"targetMerchantId": strconv.FormatUint(c.targetMerchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.pos.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.pos.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *PosStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PosInsertCall) Do(opts ...googleapi.CallOption) (*PosStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PosStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.pos.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PosInventoryCall struct {
	s                   *APIService
	merchantId          uint64
	targetMerchantId    uint64
	posinventoryrequest *PosInventoryRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Inventory: Submit inventory for the given merchant.
//
// - merchantId: The ID of the POS or inventory data provider.
// - targetMerchantId: The ID of the target merchant.
func (r *PosService) Inventory(merchantId uint64, targetMerchantId uint64, posinventoryrequest *PosInventoryRequest) *PosInventoryCall {
	c := &PosInventoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.targetMerchantId = targetMerchantId
	c.posinventoryrequest = posinventoryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PosInventoryCall) Fields(s ...googleapi.Field) *PosInventoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PosInventoryCall) Context(ctx context.Context) *PosInventoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PosInventoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PosInventoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.posinventoryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/pos/{targetMerchantId}/inventory")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":       strconv.FormatUint(c.merchantId, 10),
		"targetMerchantId": strconv.FormatUint(c.targetMerchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.pos.inventory", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.pos.inventory" call.
// Any non-2xx status code is an error. Response headers are in either
// *PosInventoryResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PosInventoryCall) Do(opts ...googleapi.CallOption) (*PosInventoryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PosInventoryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.pos.inventory", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PosListCall struct {
	s                *APIService
	merchantId       uint64
	targetMerchantId uint64
	urlParams_       gensupport.URLParams
	ifNoneMatch_     string
	ctx_             context.Context
	header_          http.Header
}

// List: Lists the stores of the target merchant.
//
// - merchantId: The ID of the POS or inventory data provider.
// - targetMerchantId: The ID of the target merchant.
func (r *PosService) List(merchantId uint64, targetMerchantId uint64) *PosListCall {
	c := &PosListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.targetMerchantId = targetMerchantId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PosListCall) Fields(s ...googleapi.Field) *PosListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PosListCall) IfNoneMatch(entityTag string) *PosListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PosListCall) Context(ctx context.Context) *PosListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PosListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PosListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/pos/{targetMerchantId}/store")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":       strconv.FormatUint(c.merchantId, 10),
		"targetMerchantId": strconv.FormatUint(c.targetMerchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.pos.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.pos.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *PosListResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PosListCall) Do(opts ...googleapi.CallOption) (*PosListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PosListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.pos.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type PosSaleCall struct {
	s                *APIService
	merchantId       uint64
	targetMerchantId uint64
	possalerequest   *PosSaleRequest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Sale: Submit a sale event for the given merchant.
//
// - merchantId: The ID of the POS or inventory data provider.
// - targetMerchantId: The ID of the target merchant.
func (r *PosService) Sale(merchantId uint64, targetMerchantId uint64, possalerequest *PosSaleRequest) *PosSaleCall {
	c := &PosSaleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.targetMerchantId = targetMerchantId
	c.possalerequest = possalerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PosSaleCall) Fields(s ...googleapi.Field) *PosSaleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PosSaleCall) Context(ctx context.Context) *PosSaleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PosSaleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PosSaleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.possalerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/pos/{targetMerchantId}/sale")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId":       strconv.FormatUint(c.merchantId, 10),
		"targetMerchantId": strconv.FormatUint(c.targetMerchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.pos.sale", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.pos.sale" call.
// Any non-2xx status code is an error. Response headers are in either
// *PosSaleResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *PosSaleCall) Do(opts ...googleapi.CallOption) (*PosSaleResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PosSaleResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.pos.sale", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProductdeliverytimeCreateCall struct {
	s                   *APIService
	merchantId          int64
	productdeliverytime *ProductDeliveryTime
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates or updates the delivery time of a product.
//
//   - merchantId: The Google merchant ID of the account that contains the
//     product. This account cannot be a multi-client account.
func (r *ProductdeliverytimeService) Create(merchantId int64, productdeliverytime *ProductDeliveryTime) *ProductdeliverytimeCreateCall {
	c := &ProductdeliverytimeCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.productdeliverytime = productdeliverytime
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProductdeliverytimeCreateCall) Fields(s ...googleapi.Field) *ProductdeliverytimeCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProductdeliverytimeCreateCall) Context(ctx context.Context) *ProductdeliverytimeCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProductdeliverytimeCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProductdeliverytimeCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.productdeliverytime)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/productdeliverytime")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.productdeliverytime.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.productdeliverytime.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ProductDeliveryTime.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProductdeliverytimeCreateCall) Do(opts ...googleapi.CallOption) (*ProductDeliveryTime, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ProductDeliveryTime{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.productdeliverytime.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProductdeliverytimeDeleteCall struct {
	s          *APIService
	merchantId int64
	productId  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the delivery time of a product.
//
//   - merchantId: The Google merchant ID of the account that contains the
//     product. This account cannot be a multi-client account.
//   - productId: The Content API ID of the product, in the form
//     `channel:contentLanguage:targetCountry:offerId`.
func (r *ProductdeliverytimeService) Delete(merchantId int64, productId string) *ProductdeliverytimeDeleteCall {
	c := &ProductdeliverytimeDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.productId = productId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProductdeliverytimeDeleteCall) Fields(s ...googleapi.Field) *ProductdeliverytimeDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProductdeliverytimeDeleteCall) Context(ctx context.Context) *ProductdeliverytimeDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProductdeliverytimeDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProductdeliverytimeDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/productdeliverytime/{productId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"productId":  c.productId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.productdeliverytime.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.productdeliverytime.delete" call.
func (c *ProductdeliverytimeDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.productdeliverytime.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type ProductdeliverytimeGetCall struct {
	s            *APIService
	merchantId   int64
	productId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets `productDeliveryTime` by `productId`.
//
//   - merchantId: The Google merchant ID of the account that contains the
//     product. This account cannot be a multi-client account.
//   - productId: The Content API ID of the product, in the form
//     `channel:contentLanguage:targetCountry:offerId`.
func (r *ProductdeliverytimeService) Get(merchantId int64, productId string) *ProductdeliverytimeGetCall {
	c := &ProductdeliverytimeGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.productId = productId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProductdeliverytimeGetCall) Fields(s ...googleapi.Field) *ProductdeliverytimeGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProductdeliverytimeGetCall) IfNoneMatch(entityTag string) *ProductdeliverytimeGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProductdeliverytimeGetCall) Context(ctx context.Context) *ProductdeliverytimeGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProductdeliverytimeGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProductdeliverytimeGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/productdeliverytime/{productId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatInt(c.merchantId, 10),
		"productId":  c.productId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.productdeliverytime.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.productdeliverytime.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ProductDeliveryTime.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProductdeliverytimeGetCall) Do(opts ...googleapi.CallOption) (*ProductDeliveryTime, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ProductDeliveryTime{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.productdeliverytime.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProductsCustombatchCall struct {
	s                          *APIService
	productscustombatchrequest *ProductsCustomBatchRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Custombatch: Retrieves, inserts, and deletes multiple products in a single
// request.
func (r *ProductsService) Custombatch(productscustombatchrequest *ProductsCustomBatchRequest) *ProductsCustombatchCall {
	c := &ProductsCustombatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.productscustombatchrequest = productscustombatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProductsCustombatchCall) Fields(s ...googleapi.Field) *ProductsCustombatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProductsCustombatchCall) Context(ctx context.Context) *ProductsCustombatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProductsCustombatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProductsCustombatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.productscustombatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "products/batch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.products.custombatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.products.custombatch" call.
// Any non-2xx status code is an error. Response headers are in either
// *ProductsCustomBatchResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProductsCustombatchCall) Do(opts ...googleapi.CallOption) (*ProductsCustomBatchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ProductsCustomBatchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.products.custombatch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProductsDeleteCall struct {
	s          *APIService
	merchantId uint64
	productId  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a product from your Merchant Center account.
//
//   - merchantId: The ID of the account that contains the product. This account
//     cannot be a multi-client account.
//   - productId: The REST ID of the product.
func (r *ProductsService) Delete(merchantId uint64, productId string) *ProductsDeleteCall {
	c := &ProductsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.productId = productId
	return c
}

// FeedId sets the optional parameter "feedId": The Content API Supplemental
// Feed ID. If present then product deletion applies to the data in a
// supplemental feed. If absent, entire product will be deleted.
func (c *ProductsDeleteCall) FeedId(feedId uint64) *ProductsDeleteCall {
	c.urlParams_.Set("feedId", fmt.Sprint(feedId))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProductsDeleteCall) Fields(s ...googleapi.Field) *ProductsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProductsDeleteCall) Context(ctx context.Context) *ProductsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProductsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProductsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{merchantId}/products/{productId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"merchantId": strconv.FormatUint(c.merchantId, 10),
		"productId":  c.productId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "content.products.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "content.products.delete" call.
func (c *ProductsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "content.products.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type ProductsGetCall struct {
	s            *APIService
	merchantId   uint64
	productId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a product from your Merchant Center account.
//
//   - merchantId: The ID of the account that contains the product. This account
//     cannot be a multi-client account.
//   - productId: The REST ID of the product.
func (r *ProductsService) Get(merchantId uint64, productId string) *ProductsGetCall {
	c := &ProductsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.merchantId = merchantId
	c.productId = productId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProductsGetCall) Fields(s ...googleapi.Field) *ProductsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProductsGetCall) IfNoneMatch(entityTag string) *ProductsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProductsGetCall) Context(ctx context.Context) *ProductsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by 