// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package healthcare provides access to the Cloud Healthcare API.
//
// For product documentation, see: https://cloud.google.com/healthcare
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/healthcare/v1"
//	...
//	ctx := context.Background()
//	healthcareService, err := healthcare.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	healthcareService, err := healthcare.NewService(ctx, option.WithScopes(healthcare.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	healthcareService, err := healthcare.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	healthcareService, err := healthcare.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package healthcare // import "google.golang.org/api/healthcare/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "healthcare:v1"
const apiName = "healthcare"
const apiVersion = "v1"
const basePath = "https://healthcare.googleapis.com/"
const basePathTemplate = "https://healthcare.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://healthcare.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Read, write and manage healthcare data
	CloudHealthcareScope = "https://www.googleapis.com/auth/cloud-healthcare"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-healthcare",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Datasets = NewProjectsLocationsDatasetsService(s)
	rs.Services = NewProjectsLocationsServicesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Datasets *ProjectsLocationsDatasetsService

	Services *ProjectsLocationsServicesService
}

func NewProjectsLocationsDatasetsService(s *Service) *ProjectsLocationsDatasetsService {
	rs := &ProjectsLocationsDatasetsService{s: s}
	rs.ConsentStores = NewProjectsLocationsDatasetsConsentStoresService(s)
	rs.DataMapperWorkspaces = NewProjectsLocationsDatasetsDataMapperWorkspacesService(s)
	rs.DicomStores = NewProjectsLocationsDatasetsDicomStoresService(s)
	rs.FhirStores = NewProjectsLocationsDatasetsFhirStoresService(s)
	rs.Hl7V2Stores = NewProjectsLocationsDatasetsHl7V2StoresService(s)
	rs.Operations = NewProjectsLocationsDatasetsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsService struct {
	s *Service

	ConsentStores *ProjectsLocationsDatasetsConsentStoresService

	DataMapperWorkspaces *ProjectsLocationsDatasetsDataMapperWorkspacesService

	DicomStores *ProjectsLocationsDatasetsDicomStoresService

	FhirStores *ProjectsLocationsDatasetsFhirStoresService

	Hl7V2Stores *ProjectsLocationsDatasetsHl7V2StoresService

	Operations *ProjectsLocationsDatasetsOperationsService
}

func NewProjectsLocationsDatasetsConsentStoresService(s *Service) *ProjectsLocationsDatasetsConsentStoresService {
	rs := &ProjectsLocationsDatasetsConsentStoresService{s: s}
	rs.AttributeDefinitions = NewProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService(s)
	rs.ConsentArtifacts = NewProjectsLocationsDatasetsConsentStoresConsentArtifactsService(s)
	rs.Consents = NewProjectsLocationsDatasetsConsentStoresConsentsService(s)
	rs.UserDataMappings = NewProjectsLocationsDatasetsConsentStoresUserDataMappingsService(s)
	return rs
}

type ProjectsLocationsDatasetsConsentStoresService struct {
	s *Service

	AttributeDefinitions *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService

	ConsentArtifacts *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService

	Consents *ProjectsLocationsDatasetsConsentStoresConsentsService

	UserDataMappings *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService
}

func NewProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService(s *Service) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService {
	rs := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsConsentStoresConsentArtifactsService(s *Service) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService {
	rs := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsConsentStoresConsentsService(s *Service) *ProjectsLocationsDatasetsConsentStoresConsentsService {
	rs := &ProjectsLocationsDatasetsConsentStoresConsentsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConsentStoresConsentsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsConsentStoresUserDataMappingsService(s *Service) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService {
	rs := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDataMapperWorkspacesService(s *Service) *ProjectsLocationsDatasetsDataMapperWorkspacesService {
	rs := &ProjectsLocationsDatasetsDataMapperWorkspacesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDataMapperWorkspacesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDicomStoresService(s *Service) *ProjectsLocationsDatasetsDicomStoresService {
	rs := &ProjectsLocationsDatasetsDicomStoresService{s: s}
	rs.DicomWeb = NewProjectsLocationsDatasetsDicomStoresDicomWebService(s)
	rs.Studies = NewProjectsLocationsDatasetsDicomStoresStudiesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresService struct {
	s *Service

	DicomWeb *ProjectsLocationsDatasetsDicomStoresDicomWebService

	Studies *ProjectsLocationsDatasetsDicomStoresStudiesService
}

func NewProjectsLocationsDatasetsDicomStoresDicomWebService(s *Service) *ProjectsLocationsDatasetsDicomStoresDicomWebService {
	rs := &ProjectsLocationsDatasetsDicomStoresDicomWebService{s: s}
	rs.Studies = NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresDicomWebService struct {
	s *Service

	Studies *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService
}

func NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesService(s *Service) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService {
	rs := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService{s: s}
	rs.Series = NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService struct {
	s *Service

	Series *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService
}

func NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService(s *Service) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService {
	rs := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService{s: s}
	rs.Instances = NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService struct {
	s *Service

	Instances *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService
}

func NewProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService(s *Service) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService {
	rs := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDicomStoresStudiesService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesService{s: s}
	rs.Series = NewProjectsLocationsDatasetsDicomStoresStudiesSeriesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesService struct {
	s *Service

	Series *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService
}

func NewProjectsLocationsDatasetsDicomStoresStudiesSeriesService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesService{s: s}
	rs.Instances = NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesService struct {
	s *Service

	Instances *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService
}

func NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService{s: s}
	rs.Bulkdata = NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService(s)
	rs.Frames = NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService(s)
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService struct {
	s *Service

	Bulkdata *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService

	Frames *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService
}

func NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService(s *Service) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService {
	rs := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsFhirStoresService(s *Service) *ProjectsLocationsDatasetsFhirStoresService {
	rs := &ProjectsLocationsDatasetsFhirStoresService{s: s}
	rs.Fhir = NewProjectsLocationsDatasetsFhirStoresFhirService(s)
	rs.Operations = NewProjectsLocationsDatasetsFhirStoresOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsFhirStoresService struct {
	s *Service

	Fhir *ProjectsLocationsDatasetsFhirStoresFhirService

	Operations *ProjectsLocationsDatasetsFhirStoresOperationsService
}

func NewProjectsLocationsDatasetsFhirStoresFhirService(s *Service) *ProjectsLocationsDatasetsFhirStoresFhirService {
	rs := &ProjectsLocationsDatasetsFhirStoresFhirService{s: s}
	return rs
}

type ProjectsLocationsDatasetsFhirStoresFhirService struct {
	s *Service
}

func NewProjectsLocationsDatasetsFhirStoresOperationsService(s *Service) *ProjectsLocationsDatasetsFhirStoresOperationsService {
	rs := &ProjectsLocationsDatasetsFhirStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsFhirStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsHl7V2StoresService(s *Service) *ProjectsLocationsDatasetsHl7V2StoresService {
	rs := &ProjectsLocationsDatasetsHl7V2StoresService{s: s}
	rs.Messages = NewProjectsLocationsDatasetsHl7V2StoresMessagesService(s)
	return rs
}

type ProjectsLocationsDatasetsHl7V2StoresService struct {
	s *Service

	Messages *ProjectsLocationsDatasetsHl7V2StoresMessagesService
}

func NewProjectsLocationsDatasetsHl7V2StoresMessagesService(s *Service) *ProjectsLocationsDatasetsHl7V2StoresMessagesService {
	rs := &ProjectsLocationsDatasetsHl7V2StoresMessagesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsHl7V2StoresMessagesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsOperationsService(s *Service) *ProjectsLocationsDatasetsOperationsService {
	rs := &ProjectsLocationsDatasetsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsOperationsService struct {
	s *Service
}

func NewProjectsLocationsServicesService(s *Service) *ProjectsLocationsServicesService {
	rs := &ProjectsLocationsServicesService{s: s}
	rs.Nlp = NewProjectsLocationsServicesNlpService(s)
	return rs
}

type ProjectsLocationsServicesService struct {
	s *Service

	Nlp *ProjectsLocationsServicesNlpService
}

func NewProjectsLocationsServicesNlpService(s *Service) *ProjectsLocationsServicesNlpService {
	rs := &ProjectsLocationsServicesNlpService{s: s}
	return rs
}

type ProjectsLocationsServicesNlpService struct {
	s *Service
}

// AccessDeterminationLogConfig: Configures consent audit log config for FHIR
// create, read, update, and delete (CRUD) operations. Cloud audit log for
// healthcare API must be enabled
// (https://cloud.google.com/logging/docs/audit/configure-data-access#config-console-enable).
// The consent-related logs are included as part of `protoPayload.metadata`.
type AccessDeterminationLogConfig struct {
	// LogLevel: Optional. Controls the amount of detail to include as part of the
	// audit logs.
	//
	// Possible values:
	//   "LOG_LEVEL_UNSPECIFIED" - No log level specified. This value is unused.
	//   "DISABLED" - No additional consent-related logging is added to audit logs.
	//   "MINIMUM" - The following information is included: * One of the following
	// [`consentMode`](https://cloud.google.com/healthcare-api/docs/fhir-consent#aud
	// it_logs) fields: (`off`|`emptyScope`|`enforced`|`btg`|`bypass`). * The
	// accessor's request headers * The `log_level` of the
	// AccessDeterminationLogConfig * The final consent evaluation (`PERMIT`,
	// `DENY`, or `NO_CONSENT`) * A human-readable summary of the evaluation
	//   "VERBOSE" - Includes `MINIMUM` and, for each resource owner, returns: *
	// The resource owner's name * Most specific part of the `X-Consent-Scope`
	// resulting in consensual determination * Timestamp of the applied enforcement
	// leading to the decision * Enforcement version at the time the applicable
	// consents were applied * The Consent resource name * The timestamp of the
	// Consent resource used for enforcement * Policy type (`PATIENT` or `ADMIN`)
	// Note that this mode adds some overhead to CRUD operations.
	LogLevel string `json:"logLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessDeterminationLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AccessDeterminationLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActivateConsentRequest: Activates the latest revision of the specified
// Consent by committing a new revision with `state` updated to `ACTIVE`. If
// the latest revision of the given Consent is in the `ACTIVE` state, no new
// revision is committed. A FAILED_PRECONDITION error occurs if the latest
// revision of the given consent is in the `REJECTED` or `REVOKED` state.
type ActivateConsentRequest struct {
	// ConsentArtifact: Required. The resource name of the Consent artifact that
	// contains documentation of the user's consent, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. If the
	// draft Consent had a Consent artifact, this Consent artifact overwrites it.
	ConsentArtifact string `json:"consentArtifact,omitempty"`
	// ExpireTime: Timestamp in UTC of when this Consent is considered expired.
	ExpireTime string `json:"expireTime,omitempty"`
	// Ttl: The time to live for this Consent from when it is marked as active.
	Ttl string `json:"ttl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifact") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivateConsentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ActivateConsentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdminConsents: List of admin Consent resources to be applied.
type AdminConsents struct {
	// Names: Optional. The versioned names of the admin Consent resource(s), in
	// the format
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}/_history/{version_id}`. For FHIR
	// stores with `disable_resource_versioning=true`, the format is
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}`.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdminConsents) MarshalJSON() ([]byte, error) {
	type NoMethod AdminConsents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzeEntitiesRequest: The request to analyze healthcare entities in a
// document.
type AnalyzeEntitiesRequest struct {
	// AlternativeOutputFormat: Optional. Alternative output format to be generated
	// based on the results of analysis.
	//
	// Possible values:
	//   "ALTERNATIVE_OUTPUT_FORMAT_UNSPECIFIED" - No alternative output format is
	// specified.
	//   "FHIR_BUNDLE" - FHIR bundle output.
	AlternativeOutputFormat string `json:"alternativeOutputFormat,omitempty"`
	// DocumentContent: document_content is a document to be annotated.
	DocumentContent string `json:"documentContent,omitempty"`
	// LicensedVocabularies: A list of licensed vocabularies to use in the request,
	// in addition to the default unlicensed vocabularies.
	//
	// Possible values:
	//   "LICENSED_VOCABULARY_UNSPECIFIED" - No licensed vocabulary specified.
	//   "ICD10CM" - ICD-10-CM vocabulary
	//   "SNOMEDCT_US" - SNOMED CT (US version) vocabulary
	LicensedVocabularies []string `json:"licensedVocabularies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternativeOutputFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternativeOutputFormat") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzeEntitiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzeEntitiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzeEntitiesResponse: Includes recognized entity mentions and
// relationships between them.
type AnalyzeEntitiesResponse struct {
	// Entities: The union of all the candidate entities that the entity_mentions
	// in this response could link to. These are UMLS concepts or normalized
	// mention content.
	Entities []*Entity `json:"entities,omitempty"`
	// EntityMentions: The `entity_mentions` field contains all the annotated
	// medical entities that were mentioned in the provided document.
	EntityMentions []*EntityMention `json:"entityMentions,omitempty"`
	// FhirBundle: The FHIR bundle (`R4` (http://hl7.org/fhir/R4/bundle.html)) that
	// includes all the entities, the entity mentions, and the relationships in
	// JSON format.
	FhirBundle string `json:"fhirBundle,omitempty"`
	// Relationships: relationships contains all the binary relationships that were
	// identified between entity mentions within the provided document.
	Relationships []*EntityMentionRelationship `json:"relationships,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzeEntitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzeEntitiesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyAdminConsentsErrorDetail: Contains the error details of the unsupported
// admin Consent resources for when the ApplyAdminConsents method fails to
// apply one or more Consent resources.
type ApplyAdminConsentsErrorDetail struct {
	// ConsentErrors: The list of Consent resources that are unsupported or cannot
	// be applied and the error associated with each of them.
	ConsentErrors []*ConsentErrors `json:"consentErrors,omitempty"`
	// ExistingOperationId: The currently in progress non-validate-only
	// ApplyAdminConsents operation ID if exist.
	ExistingOperationId uint64 `json:"existingOperationId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ConsentErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyAdminConsentsErrorDetail) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyAdminConsentsErrorDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyAdminConsentsRequest: Request to apply the admin Consent resources for
// the specified FHIR store.
type ApplyAdminConsentsRequest struct {
	// NewConsentsList: A new list of admin Consent resources to be applied. Any
	// existing enforced Consents, which are specified in
	// `consent_config.enforced_admin_consents` of the FhirStore, that are not part
	// of this list will be disabled. An empty list is equivalent to clearing or
	// disabling all Consents enforced on the FHIR store. When a FHIR store has
	// `disable_resource_versioning=true` and this list contains a Consent resource
	// that exists in `consent_config.enforced_admin_consents`, the method enforces
	// any updates to the existing resource since the last enforcement. If the
	// existing resource hasn't been updated since the last enforcement, the
	// resource is unaffected. After the method finishes, the resulting consent
	// enforcement model is determined by the contents of the Consent resource(s)
	// when the method was called: * When `disable_resource_versioning=true`, the
	// result is identical to the current resource(s) in the FHIR store. * When
	// `disable_resource_versioning=false`, the result is based on the historical
	// version(s) of the Consent resource(s) at the point in time when the method
	// was called. At most 200 Consents can be specified.
	NewConsentsList *AdminConsents `json:"newConsentsList,omitempty"`
	// ValidateOnly: Optional. If true, the method only validates Consent resources
	// to make sure they are supported. Otherwise, the method applies the aggregate
	// consent information to update the enforcement model and reindex the FHIR
	// resources. If all Consent resources can be applied successfully, the
	// ApplyAdminConsentsResponse is returned containing the following fields: *
	// `consent_apply_success` to indicate the number of Consent resources applied.
	// * `affected_resources` to indicate the number of resources that might have
	// had their consent access changed. If, however, one or more Consent resources
	// are unsupported or cannot be applied, the method fails and
	// ApplyAdminConsentsErrorDetail is is returned with details about the
	// unsupported Consent resources.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewConsentsList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewConsentsList") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyAdminConsentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyAdminConsentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyAdminConsentsResponse: Response when all admin Consent resources in
// scope were processed and all affected resources were reindexed successfully.
// This structure will be included in the response when the operation finishes
// successfully.
type ApplyAdminConsentsResponse struct {
	// AffectedResources: The number of resources (including the Consent resources)
	// that may have consent access change.
	AffectedResources int64 `json:"affectedResources,omitempty,string"`
	// ConsentApplySuccess: If `validate_only=false` in ApplyAdminConsentsRequest,
	// this counter contains the number of Consent resources that were successfully
	// applied. Otherwise, it is the number of Consent resources that are
	// supported.
	ConsentApplySuccess int64 `json:"consentApplySuccess,omitempty,string"`
	// FailedResources: The number of resources (including the Consent resources)
	// that ApplyAdminConsents failed to re-index.
	FailedResources int64 `json:"failedResources,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AffectedResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffectedResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyAdminConsentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyAdminConsentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyConsentsRequest: Request to apply the Consent resources for the
// specified FHIR store.
type ApplyConsentsRequest struct {
	// PatientScope: Optional. Scope down to a list of patients.
	PatientScope *PatientScope `json:"patientScope,omitempty"`
	// TimeRange: Optional. Scope down to patients whose most recent consent
	// changes are in the time range. Can only be used with a versioning store
	// (i.e. when disable_resource_versioning is set to false).
	TimeRange *TimeRange `json:"timeRange,omitempty"`
	// ValidateOnly: Optional. If true, the method only validates Consent resources
	// to make sure they are supported. When the operation completes,
	// ApplyConsentsResponse is returned where `consent_apply_success` and
	// `consent_apply_failure` indicate supported and unsupported (or invalid)
	// Consent resources, respectively. Otherwise, the method propagates the
	// aggregate consensual information to the patient's resources. Upon success,
	// `affected_resources` in the ApplyConsentsResponse indicates the number of
	// resources that may have consensual access changed.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PatientScope") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PatientScope") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyConsentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyConsentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplyConsentsResponse: Response when all Consent resources in scope were
// processed and all affected resources were reindexed successfully. This
// structure is included in the response when the operation finishes
// successfully.
type ApplyConsentsResponse struct {
	// AffectedResources: The number of resources (including the Consent resources)
	// that may have consensual access change.
	AffectedResources int64 `json:"affectedResources,omitempty,string"`
	// ConsentApplyFailure: If `validate_only = false` in ApplyConsentsRequest,
	// this counter is the number of Consent resources that were failed to apply.
	// Otherwise, it is the number of Consent resources that are not supported or
	// invalid.
	ConsentApplyFailure int64 `json:"consentApplyFailure,omitempty,string"`
	// ConsentApplySuccess: If `validate_only = false` in ApplyConsentsRequest,
	// this counter is the number of Consent resources that were successfully
	// applied. Otherwise, it is the number of Consent resources that are
	// supported.
	ConsentApplySuccess int64 `json:"consentApplySuccess,omitempty,string"`
	// FailedResources: The number of resources (including the Consent resources)
	// that ApplyConsents failed to re-index.
	FailedResources int64 `json:"failedResources,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AffectedResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffectedResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplyConsentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ApplyConsentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArchiveUserDataMappingRequest: Archives the specified User data mapping.
type ArchiveUserDataMappingRequest struct {
}

// ArchiveUserDataMappingResponse: Archives the specified User data mapping.
type ArchiveUserDataMappingResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Attribute: An attribute value for a Consent or User data mapping. Each
// Attribute must have a corresponding AttributeDefinition in the consent store
// that defines the default and allowed values.
type Attribute struct {
	// AttributeDefinitionId: Indicates the name of an attribute defined in the
	// consent store.
	AttributeDefinitionId string `json:"attributeDefinitionId,omitempty"`
	// Values: Required. The value of the attribute. Must be an acceptable value as
	// defined in the consent store. For example, if the consent store defines
	// "data type" with acceptable values "questionnaire" and "step-count", when
	// the attribute name is data type, this field must contain one of those
	// values.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeDefinitionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeDefinitionId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Attribute) MarshalJSON() ([]byte, error) {
	type NoMethod Attribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttributeDefinition: A client-defined consent attribute.
type AttributeDefinition struct {
	// AllowedValues: Required. Possible values for the attribute. The number of
	// allowed values must not exceed 500. An empty list is invalid. The list can
	// only be expanded after creation.
	AllowedValues []string `json:"allowedValues,omitempty"`
	// Category: Required. The category of the attribute. The value of this field
	// cannot be changed after creation.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - No category specified. This option is invalid.
	//   "RESOURCE" - Specify this category when this attribute describes the
	// properties of resources. For example, data anonymity or data type.
	//   "REQUEST" - Specify this category when this attribute describes the
	// properties of requests. For example, requester's role or requester's
	// organization.
	Category string `json:"category,omitempty"`
	// ConsentDefaultValues: Optional. Default values of the attribute in Consents.
	// If no default values are specified, it defaults to an empty value.
	ConsentDefaultValues []string `json:"consentDefaultValues,omitempty"`
	// DataMappingDefaultValue: Optional. Default value of the attribute in User
	// data mappings. If no default value is specified, it defaults to an empty
	// value. This field is only applicable to attributes of the category
	// `RESOURCE`.
	DataMappingDefaultValue string `json:"dataMappingDefaultValue,omitempty"`
	// Description: Optional. A description of the attribute.
	Description string `json:"description,omitempty"`
	// Name: Identifier. Resource name of the Attribute definition, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/attributeDefinitions/{attribute_definition_id}`.
	// Cannot be changed after creation.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowedValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttributeDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod AttributeDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlobStorageInfo: BlobStorageInfo contains details about the data stored in
// Blob Storage for the referenced resource. Note: Storage class is only valid
// for DICOM and hence will only be populated for DICOM resources.
type BlobStorageInfo struct {
	// SizeBytes: Size in bytes of data stored in Blob Storage.
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`
	// StorageClass: The storage class in which the Blob data is stored.
	//
	// Possible values:
	//   "BLOB_STORAGE_CLASS_UNSPECIFIED" - If unspecified in CreateDataset, the
	// StorageClass defaults to STANDARD. If unspecified in UpdateDataset and the
	// StorageClass is set in the field mask, an InvalidRequest error is thrown.
	//   "STANDARD" - This stores the Object in Blob Standard Storage:
	// https://cloud.google.com/storage/docs/storage-classes#standard
	//   "NEARLINE" - This stores the Object in Blob Nearline Storage:
	// https://cloud.google.com/storage/docs/storage-classes#nearline
	//   "COLDLINE" - This stores the Object in Blob Coldline Storage:
	// https://cloud.google.com/storage/docs/storage-classes#coldline
	//   "ARCHIVE" - This stores the Object in Blob Archive Storage:
	// https://cloud.google.com/storage/docs/storage-classes#archive
	StorageClass string `json:"storageClass,omitempty"`
	// StorageClassUpdateTime: The time at which the storage class was updated.
	// This is used to compute early deletion fees of the resource.
	StorageClassUpdateTime string `json:"storageClassUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SizeBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlobStorageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BlobStorageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BlobStorageSettings: Settings for data stored in Blob storage.
type BlobStorageSettings struct {
	// BlobStorageClass: The Storage class in which the Blob data is stored.
	//
	// Possible values:
	//   "BLOB_STORAGE_CLASS_UNSPECIFIED" - If unspecified in CreateDataset, the
	// StorageClass defaults to STANDARD. If unspecified in UpdateDataset and the
	// StorageClass is set in the field mask, an InvalidRequest error is thrown.
	//   "STANDARD" - This stores the Object in Blob Standard Storage:
	// https://cloud.google.com/storage/docs/storage-classes#standard
	//   "NEARLINE" - This stores the Object in Blob Nearline Storage:
	// https://cloud.google.com/storage/docs/storage-classes#nearline
	//   "COLDLINE" - This stores the Object in Blob Coldline Storage:
	// https://cloud.google.com/storage/docs/storage-classes#coldline
	//   "ARCHIVE" - This stores the Object in Blob Archive Storage:
	// https://cloud.google.com/storage/docs/storage-classes#archive
	BlobStorageClass string `json:"blobStorageClass,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageClass") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageClass") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BlobStorageSettings) MarshalJSON() ([]byte, error) {
	type NoMethod BlobStorageSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BulkExportGcsDestination: The configuration for exporting to Cloud Storage
// using the bulk export API.
type BulkExportGcsDestination struct {
	// UriPrefix: Optional. URI for a Cloud Storage directory where the server
	// writes result files, in the format
	// `gs://{bucket-id}/{path/to/destination/dir}`. If there is no trailing slash,
	// the service appends one when composing the object path. The user is
	// responsible for creating the Cloud Storage bucket referenced in
	// `uri_prefix`.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BulkExportGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod BulkExportGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CharacterMaskConfig: Mask a string by replacing its characters with a fixed
// character.
type CharacterMaskConfig struct {
	// MaskingCharacter: Optional. Character to mask the sensitive values. If not
	// supplied, defaults to "*".
	MaskingCharacter string `json:"maskingCharacter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaskingCharacter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaskingCharacter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CharacterMaskConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CharacterMaskConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckDataAccessRequest: Checks if a particular data_id of a User data
// mapping in the given consent store is consented for a given use.
type CheckDataAccessRequest struct {
	// ConsentList: Optional. Specific Consents to evaluate the access request
	// against. These Consents must have the same `user_id` as the evaluated User
	// data mapping, must exist in the current `consent_store`, and have a `state`
	// of either `ACTIVE` or `DRAFT`. A maximum of 100 Consents can be provided
	// here. If no selection is specified, the access request is evaluated against
	// all `ACTIVE` unexpired Consents with the same `user_id` as the evaluated
	// User data mapping.
	ConsentList *ConsentList `json:"consentList,omitempty"`
	// DataId: Required. The unique identifier of the resource to check access for.
	// This identifier must correspond to a User data mapping in the given consent
	// store.
	DataId string `json:"dataId,omitempty"`
	// RequestAttributes: The values of request attributes associated with this
	// access request.
	RequestAttributes map[string]string `json:"requestAttributes,omitempty"`
	// ResponseView: Optional. The view for CheckDataAccessResponse. If
	// unspecified, defaults to `BASIC` and returns `consented` as `TRUE` or
	// `FALSE`.
	//
	// Possible values:
	//   "RESPONSE_VIEW_UNSPECIFIED" - No response view specified. The API will
	// default to the BASIC view.
	//   "BASIC" - Only the `consented` field is populated in
	// CheckDataAccessResponse.
	//   "FULL" - All fields within CheckDataAccessResponse are populated. When set
	// to `FULL`, all `ACTIVE` Consents are evaluated even if a matching policy is
	// found during evaluation.
	ResponseView string `json:"responseView,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckDataAccessRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CheckDataAccessRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckDataAccessResponse: Checks if a particular data_id of a User data
// mapping in the given consent store is consented for a given use.
type CheckDataAccessResponse struct {
	// ConsentDetails: The resource names of all evaluated Consents mapped to their
	// evaluation.
	ConsentDetails map[string]ConsentEvaluation `json:"consentDetails,omitempty"`
	// Consented: Whether the requested resource is consented for the given use.
	Consented bool `json:"consented,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckDataAccessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckDataAccessResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Consent: Represents a user's consent.
type Consent struct {
	// ConsentArtifact: Required. The resource name of the Consent artifact that
	// contains proof of the end user's consent, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`.
	ConsentArtifact string `json:"consentArtifact,omitempty"`
	// ExpireTime: Timestamp in UTC of when this Consent is considered expired.
	ExpireTime string `json:"expireTime,omitempty"`
	// Metadata: Optional. User-supplied key-value pairs used to organize Consent
	// resources. Metadata keys must: - be between 1 and 63 characters long - have
	// a UTF-8 encoding of maximum 128 bytes - begin with a letter - consist of up
	// to 63 characters including lowercase letters, numeric characters,
	// underscores, and dashes Metadata values must be: - be between 1 and 63
	// characters long - have a UTF-8 encoding of maximum 128 bytes - consist of up
	// to 63 characters including lowercase letters, numeric characters,
	// underscores, and dashes No more than 64 metadata entries can be associated
	// with a given consent.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Name: Identifier. Resource name of the Consent, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consents/{consent_id}`. Cannot be changed after
	// creation.
	Name string `json:"name,omitempty"`
	// Policies: Optional. Represents a user's consent in terms of the resources
	// that can be accessed and under what conditions.
	Policies []*GoogleCloudHealthcareV1ConsentPolicy `json:"policies,omitempty"`
	// RevisionCreateTime: Output only. The timestamp that the revision was
	// created.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`
	// RevisionId: Output only. The revision ID of the Consent. The format is an
	// 8-character hexadecimal string. Refer to a specific revision of a Consent by
	// appending `@{revision_id}` to the Consent's resource name.
	RevisionId string `json:"revisionId,omitempty"`
	// State: Required. Indicates the current state of this Consent.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - No state specified. Treated as ACTIVE only at the
	// time of resource creation.
	//   "ACTIVE" - The Consent is active and is considered when evaluating a
	// user's consent on resources.
	//   "ARCHIVED" - The archived state is currently not being used.
	//   "REVOKED" - A revoked Consent is not considered when evaluating a user's
	// consent on resources.
	//   "DRAFT" - A draft Consent is not considered when evaluating a user's
	// consent on resources unless explicitly specified.
	//   "REJECTED" - When a draft Consent is rejected by a user, it is set to a
	// rejected state. A rejected Consent is not considered when evaluating a
	// user's consent on resources.
	State string `json:"state,omitempty"`
	// Ttl: Input only. The time to live for this Consent from when it is created.
	Ttl string `json:"ttl,omitempty"`
	// UserId: Required. User's UUID provided by the client.
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifact") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Consent) MarshalJSON() ([]byte, error) {
	type NoMethod Consent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentAccessorScope: The accessor scope that describes who can access, for
// what purpose, in which environment.
type ConsentAccessorScope struct {
	// Actor: An individual, group, or access role that identifies the accessor or
	// a characteristic of the accessor. This can be a resource ID (such as
	// `{resourceType}/{id}`) or an external URI. This value must be present.
	Actor string `json:"actor,omitempty"`
	// Environment: An abstract identifier that describes the environment or
	// conditions under which the accessor is acting. If it's not specified, it
	// applies to all environments.
	Environment string `json:"environment,omitempty"`
	// Purpose: The intent of data use. If it's not specified, it applies to all
	// purposes.
	Purpose string `json:"purpose,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actor") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentAccessorScope) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentAccessorScope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentArtifact: Documentation of a user's consent.
type ConsentArtifact struct {
	// ConsentContentScreenshots: Optional. Screenshots, PDFs, or other binary
	// information documenting the user's consent.
	ConsentContentScreenshots []*Image `json:"consentContentScreenshots,omitempty"`
	// ConsentContentVersion: Optional. An string indicating the version of the
	// consent information shown to the user.
	ConsentContentVersion string `json:"consentContentVersion,omitempty"`
	// GuardianSignature: Optional. A signature from a guardian.
	GuardianSignature *Signature `json:"guardianSignature,omitempty"`
	// Metadata: Optional. Metadata associated with the Consent artifact. For
	// example, the consent locale or user agent version.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Name: Identifier. Resource name of the Consent artifact, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. Cannot be
	// changed after creation.
	Name string `json:"name,omitempty"`
	// UserId: Required. User's UUID provided by the client.
	UserId string `json:"userId,omitempty"`
	// UserSignature: Optional. User's signature.
	UserSignature *Signature `json:"userSignature,omitempty"`
	// WitnessSignature: Optional. A signature from a witness.
	WitnessSignature *Signature `json:"witnessSignature,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentContentScreenshots")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentContentScreenshots") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentArtifact) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentArtifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentConfig: Configures whether to enforce consent for the FHIR store and
// which consent enforcement version is being used.
type ConsentConfig struct {
	// AccessDeterminationLogConfig: Optional. Specifies how the server logs the
	// consent-aware requests. If not specified, the
	// `AccessDeterminationLogConfig.LogLevel.MINIMUM` option is used.
	AccessDeterminationLogConfig *AccessDeterminationLogConfig `json:"accessDeterminationLogConfig,omitempty"`
	// AccessEnforced: Optional. The default value is false. If set to true, when
	// accessing FHIR resources, the consent headers will be verified against
	// consents given by patients. See the ConsentEnforcementVersion for the
	// supported consent headers.
	AccessEnforced bool `json:"accessEnforced,omitempty"`
	// ConsentHeaderHandling: Optional. Different options to configure the
	// behaviour of the server when handling the `X-Consent-Scope` header.
	ConsentHeaderHandling *ConsentHeaderHandling `json:"consentHeaderHandling,omitempty"`
	// EnforcedAdminConsents: Output only. The versioned names of the enforced
	// admin Consent resource(s), in the format
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}/_history/{version_id}`. For FHIR
	// stores with `disable_resource_versioning=true`, the format is
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}`. This field can only be updated
	// using ApplyAdminConsents.
	EnforcedAdminConsents []string `json:"enforcedAdminConsents,omitempty"`
	// Version: Required. Specifies which consent enforcement version is being used
	// for this FHIR store. This field can only be set once by either
	// CreateFhirStore or UpdateFhirStore. After that, you must call ApplyConsents
	// to change the version.
	//
	// Possible values:
	//   "CONSENT_ENFORCEMENT_VERSION_UNSPECIFIED" - Users must specify an
	// enforcement version or an error is returned.
	//   "V1" - Enforcement version 1. See the [FHIR Consent resources in the Cloud
	// Healthcare API](https://cloud.google.com/healthcare-api/docs/fhir-consent)
	// guide for more details.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AccessDeterminationLogConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessDeterminationLogConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentErrors: The Consent resource name and error.
type ConsentErrors struct {
	// Error: The error code and message.
	Error *Status `json:"error,omitempty"`
	// Name: The versioned name of the admin Consent resource, in the format
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}/_history/{version_id}`. For FHIR
	// stores with `disable_resource_versioning=true`, the format is
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}`.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentErrors) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentErrors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentEvaluation: The detailed evaluation of a particular Consent.
type ConsentEvaluation struct {
	// EvaluationResult: The evaluation result.
	//
	// Possible values:
	//   "EVALUATION_RESULT_UNSPECIFIED" - No evaluation result specified. This
	// option is invalid.
	//   "NOT_APPLICABLE" - The Consent is not applicable to the requested access
	// determination. For example, the Consent does not apply to the user for which
	// the access determination is requested, or it has a `state` of `REVOKED`, or
	// it has expired.
	//   "NO_MATCHING_POLICY" - The Consent does not have a policy that matches the
	// `resource_attributes` of the evaluated resource.
	//   "NO_SATISFIED_POLICY" - The Consent has at least one policy that matches
	// the `resource_attributes` of the evaluated resource, but no
	// `authorization_rule` was satisfied.
	//   "HAS_SATISFIED_POLICY" - The Consent has at least one policy that matches
	// the `resource_attributes` of the evaluated resource, and at least one
	// `authorization_rule` was satisfied.
	EvaluationResult string `json:"evaluationResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentHeaderHandling: How the server handles the consent header.
type ConsentHeaderHandling struct {
	// Profile: Optional. Specifies the default server behavior when the header is
	// empty. If not specified, the `ScopeProfile.PERMIT_EMPTY_SCOPE` option is
	// used.
	//
	// Possible values:
	//   "SCOPE_PROFILE_UNSPECIFIED" - If not specified, the default value
	// `PERMIT_EMPTY_SCOPE` is used.
	//   "PERMIT_EMPTY_SCOPE" - When no consent scopes are provided (for example,
	// if there's an empty or missing header), then consent check is disabled,
	// similar to when `access_enforced` is `false`. You can use audit logs to
	// differentiate these two cases by looking at the value of
	// `protopayload.metadata.consentMode`. If consents scopes are present, they
	// must be valid and within the allowed limits, otherwise the request will be
	// rejected with a `4xx` code.
	//   "REQUIRED_ON_READ" - The consent header must be non-empty when performing
	// read and search operations, otherwise the request is rejected with a `4xx`
	// code. Additionally, invalid consent scopes or scopes exceeding the allowed
	// limits are rejected.
	Profile string `json:"profile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Profile") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Profile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentHeaderHandling) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentHeaderHandling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentList: List of resource names of Consent resources.
type ConsentList struct {
	// Consents: The resource names of the Consents to evaluate against, of the
	// form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consents/{consent_id}`.
	Consents []string `json:"consents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Consents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Consents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentList) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsentStore: Represents a consent store.
type ConsentStore struct {
	// DefaultConsentTtl: Optional. Default time to live for Consents created in
	// this store. Must be at least 24 hours. Updating this field will not affect
	// the expiration time of existing consents.
	DefaultConsentTtl string `json:"defaultConsentTtl,omitempty"`
	// EnableConsentCreateOnUpdate: Optional. If `true`, UpdateConsent creates the
	// Consent if it does not already exist. If unspecified, defaults to `false`.
	EnableConsentCreateOnUpdate bool `json:"enableConsentCreateOnUpdate,omitempty"`
	// Labels: Optional. User-supplied key-value pairs used to organize consent
	// stores. Label keys must be between 1 and 63 characters long, have a UTF-8
	// encoding of maximum 128 bytes, and must conform to the following PCRE
	// regular expression: \p{Ll}\p{Lo}{0,62}. Label values must be between 1 and
	// 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63}. No more than 64 labels can be associated with a
	// given store. For more information:
	// https://cloud.google.com/healthcare/docs/how-tos/labeling-resources
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Resource name of the consent store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}`. Cannot be changed after creation.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DefaultConsentTtl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultConsentTtl") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsentStore) MarshalJSON() ([]byte, error) {
	type NoMethod ConsentStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateMessageRequest: Creates a new message.
type CreateMessageRequest struct {
	// Message: Required. HL7v2 message.
	Message *Message `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateMessageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateMessageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CryptoHashConfig: Pseudonymization method that generates surrogates via
// cryptographic hashing. Uses SHA-256. Outputs a base64-encoded representation
// of the hashed output (for example,
// `L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=`).
type CryptoHashConfig struct {
	// CryptoKey: An AES 128/192/256 bit key. Causes the hash to be computed based
	// on this key. A default key is generated for each Deidentify operation and is
	// used when neither `crypto_key` nor `kms_wrapped` is specified. Must not be
	// set if `kms_wrapped` is set.
	CryptoKey string `json:"cryptoKey,omitempty"`
	// KmsWrapped: KMS wrapped key. Must not be set if `crypto_key` is set.
	KmsWrapped *KmsWrappedCryptoKey `json:"kmsWrapped,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CryptoHashConfig) MarshalJSON() ([]byte, error) {
	type NoMethod CryptoHashConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Dataset: A message representing a health dataset. A health dataset
// represents a collection of healthcare data pertaining to one or more
// patients. This may include multiple modalities of healthcare data, such as
// electronic medical records or medical imaging data.
type Dataset struct {
	// EncryptionSpec: Optional. Customer-managed encryption key spec for a
	// Dataset. If set, this Dataset and all of its sub-resources will be secured
	// by this key. If empty, the Dataset is secured by the default Google
	// encryption key.
	EncryptionSpec *EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Name: Identifier. Resource name of the dataset, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Whether the dataset satisfies zone isolation.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Whether the dataset satisfies zone separation.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// TimeZone: Optional. The default timezone used by this dataset. Must be a
	// either a valid IANA time zone name such as "America/New_York" or empty,
	// which defaults to UTC. This is used for parsing times in resources, such as
	// HL7 messages, where no explicit timezone is specified.
	TimeZone string `json:"timeZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DateShiftConfig: Shift a date forward or backward in time by a random amount
// which is consistent for a given patient and crypto key combination.
type DateShiftConfig struct {
	// CryptoKey: An AES 128/192/256 bit key. The date shift is computed based on
	// this key and the patient ID. If the patient ID is empty for a DICOM
	// resource, the date shift is computed based on this key and the study
	// instance UID. If `crypto_key` is not set, then `kms_wrapped` is used to
	// calculate the date shift. If neither is set, a default key is generated for
	// each de-identify operation. Must not be set if `kms_wrapped` is set.
	CryptoKey string `json:"cryptoKey,omitempty"`
	// KmsWrapped: KMS wrapped key. If `kms_wrapped` is not set, then `crypto_key`
	// is used to calculate the date shift. If neither is set, a default key is
	// generated for each de-identify operation. Must not be set if `crypto_key` is
	// set.
	KmsWrapped *KmsWrappedCryptoKey `json:"kmsWrapped,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DateShiftConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DateShiftConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifiedStoreDestination: Contains configuration for streaming
// de-identified FHIR export.
type DeidentifiedStoreDestination struct {
	// Config: Optional. The configuration to use when de-identifying resources
	// that are added to this store.
	Config *DeidentifyConfig `json:"config,omitempty"`
	// Store: Optional. The full resource name of a Cloud Healthcare FHIR store,
	// for example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
	// es/{fhir_store_id}`.
	Store string `json:"store,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifiedStoreDestination) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifiedStoreDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyConfig: Configures de-id options specific to different types of
// content. Each submessage customizes the handling of an
// https://tools.ietf.org/html/rfc6838 media type or subtype. Configs are
// applied in a nested manner at runtime.
type DeidentifyConfig struct {
	// Dicom: Optional. Configures de-id of application/DICOM content.
	Dicom *DicomConfig `json:"dicom,omitempty"`
	// Fhir: Optional. Configures de-id of application/FHIR content.
	Fhir *FhirConfig `json:"fhir,omitempty"`
	// Image: Optional. Configures de-identification of image pixels wherever they
	// are found in the source_dataset.
	Image *ImageConfig `json:"image,omitempty"`
	// Text: Optional. Configures de-identification of text wherever it is found in
	// the source_dataset.
	Text *TextConfig `json:"text,omitempty"`
	// UseRegionalDataProcessing: Optional. Ensures in-flight data remains in the
	// region of origin during de-identification. The default value is false. Using
	// this option results in a significant reduction of throughput, and is not
	// compatible with `LOCATION` or `ORGANIZATION_NAME` infoTypes. `LOCATION` must
	// be excluded within TextConfig, and must also be excluded within ImageConfig
	// if image redaction is required.
	UseRegionalDataProcessing bool `json:"useRegionalDataProcessing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dicom") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dicom") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyDatasetRequest: Redacts identifying information from the specified
// dataset.
type DeidentifyDatasetRequest struct {
	// Config: Deidentify configuration. Only one of `config` and `gcs_config_uri`
	// can be specified.
	Config *DeidentifyConfig `json:"config,omitempty"`
	// DestinationDataset: Required. The name of the dataset resource to create and
	// write the redacted data to. * The destination dataset must not exist. * The
	// destination dataset must be in the same location as the source dataset.
	// De-identifying data across multiple locations is not supported.
	DestinationDataset string `json:"destinationDataset,omitempty"`
	// GcsConfigUri: Cloud Storage location to read the JSON
	// cloud.healthcare.deidentify.DeidentifyConfig from, overriding the default
	// config. Must be of the form `gs://{bucket_id}/path/to/object`. The Cloud
	// Storage location must grant the Cloud IAM role `roles/storage.objectViewer`
	// to the project's Cloud Healthcare Service Agent service account. Only one of
	// `config` and `gcs_config_uri` can be specified.
	GcsConfigUri string `json:"gcsConfigUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyDatasetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyDatasetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyDicomStoreRequest: Creates a new DICOM store with sensitive
// information de-identified.
type DeidentifyDicomStoreRequest struct {
	// Config: Deidentify configuration. Only one of `config` and `gcs_config_uri`
	// can be specified.
	Config *DeidentifyConfig `json:"config,omitempty"`
	// DestinationStore: Required. The name of the DICOM store to create and write
	// the redacted data to. For example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}`. * The destination dataset must exist. * The source
	// dataset and destination dataset must both reside in the same location.
	// De-identifying data across multiple locations is not supported. * The
	// destination DICOM store must not exist. * The caller must have the necessary
	// permissions to create the destination DICOM store.
	DestinationStore string `json:"destinationStore,omitempty"`
	// FilterConfig: Filter configuration.
	FilterConfig *DicomFilterConfig `json:"filterConfig,omitempty"`
	// GcsConfigUri: Cloud Storage location to read the JSON
	// cloud.healthcare.deidentify.DeidentifyConfig from, overriding the default
	// config. Must be of the form `gs://{bucket_id}/path/to/object`. The Cloud
	// Storage location must grant the Cloud IAM role `roles/storage.objectViewer`
	// to the project's Cloud Healthcare Service Agent service account. Only one of
	// `config` and `gcs_config_uri` can be specified.
	GcsConfigUri string `json:"gcsConfigUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyDicomStoreRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyDicomStoreRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifyFhirStoreRequest: Creates a new FHIR store with sensitive
// information de-identified.
type DeidentifyFhirStoreRequest struct {
	// Config: Deidentify configuration. Only one of `config` and `gcs_config_uri`
	// can be specified.
	Config *DeidentifyConfig `json:"config,omitempty"`
	// DestinationStore: Required. The name of the FHIR store to create and write
	// the redacted data to. For example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
	// es/{fhir_store_id}`. * The destination dataset must exist. * The source
	// dataset and destination dataset must both reside in the same location.
	// De-identifying data across multiple locations is not supported. * The
	// destination FHIR store must exist. * The caller must have the
	// healthcare.fhirResources.update permission to write to the destination FHIR
	// store.
	DestinationStore string `json:"destinationStore,omitempty"`
	// GcsConfigUri: Cloud Storage location to read the JSON
	// cloud.healthcare.deidentify.DeidentifyConfig from, overriding the default
	// config. Must be of the form `gs://{bucket_id}/path/to/object`. The Cloud
	// Storage location must grant the Cloud IAM role `roles/storage.objectViewer`
	// to the project's Cloud Healthcare Service Agent service account. Only one of
	// `config` and `gcs_config_uri` can be specified.
	GcsConfigUri string `json:"gcsConfigUri,omitempty"`
	// ResourceFilter: A filter specifying the resources to include in the output.
	// If not specified, all resources are included in the output.
	ResourceFilter *FhirFilter `json:"resourceFilter,omitempty"`
	// SkipModifiedResources: If true, skips resources that are created or modified
	// after the de-identify operation is created.
	SkipModifiedResources bool `json:"skipModifiedResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeidentifyFhirStoreRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeidentifyFhirStoreRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeidentifySummary: Contains a summary of the Deidentify operation.
type DeidentifySummary struct {
}

// DicomConfig: Specifies the parameters needed for de-identification of DICOM
// stores.
type DicomConfig struct {
	// FilterProfile: Tag filtering profile that determines which tags to
	// keep/remove.
	//
	// Possible values:
	//   "TAG_FILTER_PROFILE_UNSPECIFIED" - No tag filtration profile provided.
	// Same as KEEP_ALL_PROFILE.
	//   "MINIMAL_KEEP_LIST_PROFILE" - Keep only tags required to produce valid
	// DICOM.
	//   "ATTRIBUTE_CONFIDENTIALITY_BASIC_PROFILE" - Remove tags based on DICOM
	// Standard's Attribute Confidentiality Basic Profile (DICOM Standard Edition
	// 2018e)
	// http://dicom.nema.org/medical/dicom/2018e/output/chtml/part15/chapter_E.html.
	//   "KEEP_ALL_PROFILE" - Keep all tags.
	//   "DEIDENTIFY_TAG_CONTENTS" - Inspects within tag contents and replaces
	// sensitive text. The process can be configured using the TextConfig. Applies
	// to all tags with the following Value Representation names: AE, LO, LT, PN,
	// SH, ST, UC, UT, DA, DT, AS
	FilterProfile string `json:"filterProfile,omitempty"`
	// KeepList: List of tags to keep. Remove all other tags.
	KeepList *TagFilterList `json:"keepList,omitempty"`
	// RemoveList: List of tags to remove. Keep all other tags.
	RemoveList *TagFilterList `json:"removeList,omitempty"`
	// SkipIdRedaction: Optional. If true, skip replacing StudyInstanceUID,
	// SeriesInstanceUID, SOPInstanceUID, and MediaStorageSOPInstanceUID and leave
	// them untouched. The Cloud Healthcare API regenerates these UIDs by default
	// based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped
	// directly to an individual out of context, given access to the original
	// images, or to a database of the original images containing the UIDs, it
	// would be possible to recover the individual's identity."
	// http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
	SkipIdRedaction bool `json:"skipIdRedaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilterProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilterProfile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DicomConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomFilterConfig: Specifies the filter configuration for DICOM resources.
type DicomFilterConfig struct {
	// ResourcePathsGcsUri: The Cloud Storage location of the filter configuration
	// file. The `gcs_uri` must be in the format `gs://bucket/path/to/object`. The
	// filter configuration file must contain a list of resource paths separated by
	// newline characters (\n or \r\n). Each resource path must be in the format
	// "/studies/{studyUID}[/series/{seriesUID}[/instances/{instanceUID}]]" The
	// Cloud Healthcare API service account must have the
	// `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location.
	ResourcePathsGcsUri string `json:"resourcePathsGcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourcePathsGcsUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourcePathsGcsUri") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomFilterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DicomFilterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomNotificationConfig: Contains the configuration for DICOM notifications.
type DicomNotificationConfig struct {
	// PubsubTopic: Required. The Pub/Sub (https://cloud.google.com/pubsub/docs/)
	// topic that notifications of changes are published on. Supplied by the
	// client. The notification is a `PubsubMessage` with the following fields: *
	// `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId`
	// is the ID of this notification. It is guaranteed to be unique within the
	// topic. * `PubsubMessage.PublishTime` is the time when the message was
	// published. * `PubsubMessage.Attributes` contains the following attributes: *
	// `action`: The name of the endpoint that generated the notification. Possible
	// values are `StoreInstances`, `SetBlobSettings`, `ImportDicomData`, etc. *
	// `lastUpdatedTime`: The latest timestamp when the DICOM instance was updated.
	// * `storeName`: The resource name of the DICOM store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}`. * `studyInstanceUID`: The study UID of the DICOM
	// instance that was changed. * `seriesInstanceUID`: The series UID of the
	// DICOM instance that was changed. * `sopInstanceUID`: The instance UID of the
	// DICOM instance that was changed. * `versionId`: The version ID of the DICOM
	// instance that was changed. * `modality`: The modality tag of the DICOM
	// instance that was changed. * `previousStorageClass`: The storage class where
	// the DICOM instance was previously stored if the storage class was changed. *
	// `storageClass`: The storage class where the DICOM instance is currently
	// stored. Note that notifications are only sent if the topic is non-empty.
	// Topic names (https://cloud.google.com/pubsub/docs/overview#names) must be
	// scoped to a project. The Cloud Healthcare API service account,
	// service-@gcp-sa-healthcare.iam.gserviceaccount.com, must have the
	// `pubsub.topics.publish` permission (which is typically included in
	// `roles/pubsub.publisher` role) on the given Pub/Sub topic. Not having
	// adequate permissions causes the calls that send notifications to fail
	// (https://cloud.google.com/healthcare-api/docs/permissions-healthcare-api-gcp-products#dicom_fhir_and_hl7v2_store_cloud_pubsub_permissions).
	// If a notification can't be published to Pub/Sub, errors are logged to Cloud
	// Logging. For more information, see Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare-api/docs/how-tos/logging).
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PubsubTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PubsubTopic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomNotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DicomNotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomStore: Represents a DICOM store.
type DicomStore struct {
	// Labels: User-supplied key-value pairs used to organize DICOM stores. Label
	// keys must be between 1 and 63 characters long, have a UTF-8 encoding of
	// maximum 128 bytes, and must conform to the following PCRE regular
	// expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1
	// and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Resource name of the DICOM store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}`.
	Name string `json:"name,omitempty"`
	// NotificationConfig: Optional. Notification destination for new DICOM
	// instances. Supplied by the client.
	NotificationConfig *NotificationConfig `json:"notificationConfig,omitempty"`
	// NotificationConfigs: Optional. Specifies where and whether to send
	// notifications upon changes to a DICOM store.
	NotificationConfigs []*DicomNotificationConfig `json:"notificationConfigs,omitempty"`
	// StreamConfigs: Optional. A list of streaming configs used to configure the
	// destination of streaming exports for every DICOM instance insertion in this
	// DICOM store. After a new config is added to `stream_configs`, DICOM instance
	// insertions are streamed to the new destination. When a config is removed
	// from `stream_configs`, the server stops streaming to that destination. Each
	// config must contain a unique destination.
	StreamConfigs []*GoogleCloudHealthcareV1DicomStreamConfig `json:"streamConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomStore) MarshalJSON() ([]byte, error) {
	type NoMethod DicomStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DicomStoreMetrics: DicomStoreMetrics contains metrics describing a DICOM
// store.
type DicomStoreMetrics struct {
	// BlobStorageSizeBytes: Total blob storage bytes for all instances in the
	// store.
	BlobStorageSizeBytes int64 `json:"blobStorageSizeBytes,omitempty,string"`
	// InstanceCount: Number of instances in the store.
	InstanceCount int64 `json:"instanceCount,omitempty,string"`
	// Name: Resource name of the DICOM store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}`.
	Name string `json:"name,omitempty"`
	// SeriesCount: Number of series in the store.
	SeriesCount int64 `json:"seriesCount,omitempty,string"`
	// StructuredStorageSizeBytes: Total structured storage bytes for all instances
	// in the store.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`
	// StudyCount: Number of studies in the store.
	StudyCount int64 `json:"studyCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSizeBytes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DicomStoreMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod DicomStoreMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EncryptionSpec: Represents a customer-managed encryption key spec that can
// be applied to a resource.
type EncryptionSpec struct {
	// KmsKeyName: Required. The resource name of customer-managed encryption key
	// that is used to secure a resource and its sub-resources. Only the key in the
	// same location as this Dataset is allowed to be used for encryption. Format
	// is:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Entity: The candidate entities that an entity mention could link to.
type Entity struct {
	// EntityId: entity_id is a first class field entity_id uniquely identifies
	// this concept and its meta-vocabulary. For example, "UMLS/C0000970".
	EntityId string `json:"entityId,omitempty"`
	// PreferredTerm: preferred_term is the preferred term for this concept. For
	// example, "Acetaminophen". For ad hoc entities formed by normalization, this
	// is the most popular unnormalized string.
	PreferredTerm string `json:"preferredTerm,omitempty"`
	// VocabularyCodes: Vocabulary codes are first-class fields and differentiated
	// from the concept unique identifier (entity_id). vocabulary_codes contains
	// the representation of this concept in particular vocabularies, such as
	// ICD-10, SNOMED-CT and RxNORM. These are prefixed by the name of the
	// vocabulary, followed by the unique code within that vocabulary. For example,
	// "RXNORM/A10334543".
	VocabularyCodes []string `json:"vocabularyCodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Entity) MarshalJSON() ([]byte, error) {
	type NoMethod Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EntityMention: An entity mention in the document.
type EntityMention struct {
	// CertaintyAssessment: The certainty assessment of the entity mention. Its
	// value is one of: LIKELY, SOMEWHAT_LIKELY, UNCERTAIN, SOMEWHAT_UNLIKELY,
	// UNLIKELY, CONDITIONAL
	CertaintyAssessment *Feature `json:"certaintyAssessment,omitempty"`
	// Confidence: The model's confidence in this entity mention annotation. A
	// number between 0 and 1.
	Confidence float64 `json:"confidence,omitempty"`
	// LinkedEntities: linked_entities are candidate ontological concepts that this
	// entity mention may refer to. They are sorted by decreasing confidence.
	LinkedEntities []*LinkedEntity `json:"linkedEntities,omitempty"`
	// MentionId: mention_id uniquely identifies each entity mention in a single
	// response.
	MentionId string `json:"mentionId,omitempty"`
	// Subject: The subject this entity mention relates to. Its value is one of:
	// PATIENT, FAMILY_MEMBER, OTHER
	Subject *Feature `json:"subject,omitempty"`
	// TemporalAssessment: How this entity mention relates to the subject
	// temporally. Its value is one of: CURRENT, CLINICAL_HISTORY, FAMILY_HISTORY,
	// UPCOMING, ALLERGY
	TemporalAssessment *Feature `json:"temporalAssessment,omitempty"`
	// Text: text is the location of the entity mention in the document.
	Text *TextSpan `json:"text,omitempty"`
	// Type: The semantic type of the entity: UNKNOWN_ENTITY_TYPE, ALONE,
	// ANATOMICAL_STRUCTURE, ASSISTED_LIVING, BF_RESULT, BM_RESULT, BM_UNIT,
	// BM_VALUE, BODY_FUNCTION, BODY_MEASUREMENT, COMPLIANT, DOESNOT_FOLLOWUP,
	// FAMILY, FOLLOWSUP, LABORATORY_DATA, LAB_RESULT, LAB_UNIT, LAB_VALUE,
	// MEDICAL_DEVICE, MEDICINE, MED_DOSE, MED_DURATION, MED_FORM, MED_FREQUENCY,
	// MED_ROUTE, MED_STATUS, MED_STRENGTH, MED_TOTALDOSE, MED_UNIT, NON_COMPLIANT,
	// OTHER_LIVINGSTATUS, PROBLEM, PROCEDURE, PROCEDURE_RESULT, PROC_METHOD,
	// REASON_FOR_NONCOMPLIANCE, SEVERITY, SUBSTANCE_ABUSE, UNCLEAR_FOLLOWUP.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertaintyAssessment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertaintyAssessment") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EntityMention) MarshalJSON() ([]byte, error) {
	type NoMethod EntityMention
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *EntityMention) UnmarshalJSON(data []byte) error {
	type NoMethod EntityMention
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// EntityMentionRelationship: Defines directed relationship from one entity
// mention to another.
type EntityMentionRelationship struct {
	// Confidence: The model's confidence in this annotation. A number between 0
	// and 1.
	Confidence float64 `json:"confidence,omitempty"`
	// ObjectId: object_id is the id of the object entity mention.
	ObjectId string `json:"objectId,omitempty"`
	// SubjectId: subject_id is the id of the subject entity mention.
	SubjectId string `json:"subjectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EntityMentionRelationship) MarshalJSON() ([]byte, error) {
	type NoMethod EntityMentionRelationship
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *EntityMentionRelationship) UnmarshalJSON(data []byte) error {
	type NoMethod EntityMentionRelationship
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// EvaluateUserConsentsRequest: Evaluate a user's Consents for all matching
// User data mappings. Note: User data mappings are indexed asynchronously,
// causing slight delays between the time mappings are created or updated and
// when they are included in EvaluateUserConsents results.
type EvaluateUserConsentsRequest struct {
	// ConsentList: Optional. Specific Consents to evaluate the access request
	// against. These Consents must have the same `user_id` as the User data
	// mappings being evalauted, must exist in the current `consent_store`, and
	// must have a `state` of either `ACTIVE` or `DRAFT`. A maximum of 100 Consents
	// can be provided here. If unspecified, all `ACTIVE` unexpired Consents in the
	// current `consent_store` will be evaluated.
	ConsentList *ConsentList `json:"consentList,omitempty"`
	// PageSize: Optional. Limit on the number of User data mappings to return in a
	// single response. If not specified, 100 is used. May not be larger than 1000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. Token to retrieve the next page of results, or empty to
	// get the first page.
	PageToken string `json:"pageToken,omitempty"`
	// RequestAttributes: Required. The values of request attributes associated
	// with this access request.
	RequestAttributes map[string]string `json:"requestAttributes,omitempty"`
	// ResourceAttributes: Optional. The values of resource attributes associated
	// with the resources being requested. If no values are specified, then all
	// resources are queried.
	ResourceAttributes map[string]string `json:"resourceAttributes,omitempty"`
	// ResponseView: Optional. The view for EvaluateUserConsentsResponse. If
	// unspecified, defaults to `BASIC` and returns `consented` as `TRUE` or
	// `FALSE`.
	//
	// Possible values:
	//   "RESPONSE_VIEW_UNSPECIFIED" - No response view specified. The API will
	// default to the BASIC view.
	//   "BASIC" - Only the `data_id` and `consented` fields are populated in the
	// response.
	//   "FULL" - All fields within the response are populated. When set to `FULL`,
	// all `ACTIVE` Consents are evaluated even if a matching policy is found
	// during evaluation.
	ResponseView string `json:"responseView,omitempty"`
	// UserId: Required. User ID to evaluate consents for.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluateUserConsentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluateUserConsentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EvaluateUserConsentsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list. This token is valid for 72 hours after it
	// is created.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Results: The consent evaluation result for each `data_id`.
	Results []*Result `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluateUserConsentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluateUserConsentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainDataAccessConsentInfo: The enforcing consent's metadata.
type ExplainDataAccessConsentInfo struct {
	// CascadeOrigins: The compartment base resources that matched a cascading
	// policy. Each resource has the following format:
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
	// es/{fhir_store_id}/fhir/{resource_type}/{resource_id}`
	CascadeOrigins []string `json:"cascadeOrigins,omitempty"`
	// ConsentResource: The resource name of this consent resource, in the format:
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}/fhir/Consent/{resource_id}`.
	ConsentResource string `json:"consentResource,omitempty"`
	// EnforcementTime: Last enforcement timestamp of this consent resource.
	EnforcementTime string `json:"enforcementTime,omitempty"`
	// MatchingAccessorScopes: A list of all the matching accessor scopes of this
	// consent policy that enforced ExplainDataAccessConsentScope.accessor_scope.
	MatchingAccessorScopes []*ConsentAccessorScope `json:"matchingAccessorScopes,omitempty"`
	// PatientConsentOwner: The patient owning the consent (only applicable for
	// patient consents), in the format:
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
	// es/{fhir_store_id}/fhir/Patient/{patient_id}`
	PatientConsentOwner string `json:"patientConsentOwner,omitempty"`
	// Type: The policy type of consent resource (e.g. PATIENT, ADMIN).
	//
	// Possible values:
	//   "CONSENT_POLICY_TYPE_UNSPECIFIED" - Unspecified policy type.
	//   "CONSENT_POLICY_TYPE_PATIENT" - Consent represent a patient consent.
	//   "CONSENT_POLICY_TYPE_ADMIN" - Consent represent an admin consent.
	Type string `json:"type,omitempty"`
	// Variants: The consent's variant combinations. A single consent may have
	// multiple variants.
	//
	// Possible values:
	//   "CONSENT_VARIANT_UNSPECIFIED" - Consent variant unspecified.
	//   "CONSENT_VARIANT_STANDARD" - Consent is a standard patient or admin
	// consent.
	//   "CONSENT_VARIANT_CASCADE" - Consent is a cascading consent.
	Variants []string `json:"variants,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CascadeOrigins") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CascadeOrigins") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainDataAccessConsentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainDataAccessConsentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainDataAccessConsentScope: A single consent scope that provides info on
// who has access to the requested resource scope for a particular purpose and
// environment, enforced by which consent.
type ExplainDataAccessConsentScope struct {
	// AccessorScope: The accessor scope that describes who can access, for what
	// purpose, and in which environment.
	AccessorScope *ConsentAccessorScope `json:"accessorScope,omitempty"`
	// Decision: Whether the current consent scope is permitted or denied access on
	// the requested resource.
	//
	// Possible values:
	//   "CONSENT_DECISION_TYPE_UNSPECIFIED" - Unspecified consent decision type.
	//   "CONSENT_DECISION_TYPE_PERMIT" - Consent permitted access.
	//   "CONSENT_DECISION_TYPE_DENY" - Consent denied access.
	Decision string `json:"decision,omitempty"`
	// EnforcingConsents: Metadata of the consent resources that enforce the
	// consent scope's access.
	EnforcingConsents []*ExplainDataAccessConsentInfo `json:"enforcingConsents,omitempty"`
	// Exceptions: Other consent scopes that created exceptions within this scope.
	Exceptions []*ExplainDataAccessConsentScope `json:"exceptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessorScope") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessorScope") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainDataAccessConsentScope) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainDataAccessConsentScope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainDataAccessResponse: List of consent scopes that are applicable to the
// explained access on a given resource.
type ExplainDataAccessResponse struct {
	// ConsentScopes: List of applicable consent scopes. Sorted in order of actor
	// such that scopes belonging to the same actor will be adjacent to each other
	// in the list.
	ConsentScopes []*ExplainDataAccessConsentScope `json:"consentScopes,omitempty"`
	// Warning: Warnings associated with this response. It inform user with
	// exceeded scope limit errors.
	Warning string `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentScopes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentScopes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainDataAccessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainDataAccessResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportDicomDataRequest: Exports data from the specified DICOM store. If a
// given resource, such as a DICOM object with the same SOPInstance UID,
// already exists in the output, it is overwritten with the version in the
// source dataset. Exported DICOM data persists when the DICOM store from which
// it was exported is deleted.
type ExportDicomDataRequest struct {
	// BigqueryDestination: The BigQuery output destination. You can only export to
	// a BigQuery dataset that's in the same project as the DICOM store you're
	// exporting from. The Cloud Healthcare Service Agent requires two IAM roles on
	// the BigQuery location: `roles/bigquery.dataEditor` and
	// `roles/bigquery.jobUser`.
	BigqueryDestination *GoogleCloudHealthcareV1DicomBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// GcsDestination: The Cloud Storage output destination. The Cloud Healthcare
	// Service Agent requires the `roles/storage.objectAdmin` Cloud IAM roles on
	// the Cloud Storage location.
	GcsDestination *GoogleCloudHealthcareV1DicomGcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportDicomDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportDicomDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportDicomDataResponse: Returns additional information in regards to a
// completed DICOM store export.
type ExportDicomDataResponse struct {
}

// ExportMessagesRequest: Request to schedule an export.
type ExportMessagesRequest struct {
	// EndTime: The end of the range in `send_time` (MSH.7,
	// https://www.hl7.org/documentcenter/public_temp_2E58C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm)
	// to process. If not specified, the time when the export is scheduled is used.
	// This value has to come after the `start_time` defined below. Only messages
	// whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
	// (exclusive) are exported.
	EndTime string `json:"endTime,omitempty"`
	// Filter: Restricts messages exported to those matching a filter, only
	// applicable to PubsubDestination and GcsDestination. The following syntax is
	// available: * A string field value can be written as text inside quotation
	// marks, for example "query text". The only valid relational operation for
	// text fields is equality (`=`), where text is searched within the field,
	// rather than having the field be equal to the text. For example, "Comment =
	// great" returns messages with `great` in the comment field. * A number field
	// value can be written as an integer, a decimal, or an exponential. The valid
	// relational operators for number fields are the equality operator (`=`),
	// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
	// that there is no inequality (`!=`) operator. You can prepend the `NOT`
	// operator to an expression to negate it. * A date field value must be written
	// in the `yyyy-mm-dd` format. Fields with date and time use the RFC3339 time
	// format. Leading zeros are required for one-digit months and days. The valid
	// relational operators for date fields are the equality operator (`=`) , along
	// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
	// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
	// to an expression to negate it. * Multiple field query expressions can be
	// combined in one query by adding `AND` or `OR` operators between the
	// expressions. If a boolean operator appears within a quoted string, it is not
	// treated as special, and is just another part of the character string to be
	// matched. You can prepend the `NOT` operator to an expression to negate it.
	// The following fields and functions are available for filtering: *
	// `message_type`, from the MSH-9.1 field. For example, `NOT message_type =
	// "ADT". * `send_date` or `sendDate`, the `yyyy-mm-dd` date the message was
	// sent in the dataset's time_zone, from the MSH-7 segment. For example,
	// `send_date < "2017-01-02". * `send_time`, the timestamp when the message
	// was sent, using the RFC3339 time format for comparisons, from the MSH-7
	// segment. For example, `send_time < "2017-01-02T00:00:00-05:00". *
	// `create_time`, the timestamp when the message was created in the HL7v2
	// store. Use the RFC3339 time format for comparisons. For example,
	// `create_time < "2017-01-02T00:00:00-05:00". * `send_facility`, the care
	// center that the message came from, from the MSH-4 segment. For example,
	// `send_facility = "ABC". Note: The filter will be applied to every message
	// in the HL7v2 store whose `send_time` lies in the range defined by the
	// `start_time` and the `end_time`. Even if the filter only matches a small set
	// of messages, the export operation can still take a long time to finish when
	// a lot of messages are between the specified `start_time` and `end_time`
	// range.
	Filter string `json:"filter,omitempty"`
	// GcsDestination: Export to a Cloud Storage destination.
	GcsDestination *GcsDestination `json:"gcsDestination,omitempty"`
	// PubsubDestination: Export messages to a Pub/Sub topic.
	PubsubDestination *PubsubDestination `json:"pubsubDestination,omitempty"`
	// StartTime: The start of the range in `send_time` (MSH.7,
	// https://www.hl7.org/documentcenter/public_temp_2E58C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm)
	// to process. If not specified, the UNIX epoch (1970-01-01T00:00:00Z) is used.
	// This value has to come before the `end_time` defined below. Only messages
	// whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
	// (exclusive) are exported.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportMessagesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportMessagesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportMessagesResponse: Final response for the export operation. This
// structure is included in the response to describe the detailed outcome.
type ExportMessagesResponse struct {
}

// ExportResourcesRequest: Request to export resources.
type ExportResourcesRequest struct {
	// Since: If provided, only resources updated after this time are exported. The
	// time uses the format YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example,
	// `2015-02-07T13:28:17.239+02:00` or `2017-01-01T00:00:00Z`. The time must be
	// specified to the second and include a time zone.
	Since string `json:"_since,omitempty"`
	// Type: String of comma-delimited FHIR resource types. If provided, only
	// resources of the specified resource type(s) are exported.
	Type string `json:"_type,omitempty"`
	// BigqueryDestination: The BigQuery output destination. The Cloud Healthcare
	// Service Agent requires two IAM roles on the BigQuery location:
	// `roles/bigquery.dataEditor` and `roles/bigquery.jobUser`. The output is one
	// BigQuery table per resource type. Unlike when setting `BigQueryDestination`
	// for `StreamConfig`, `ExportResources` does not create BigQuery views.
	BigqueryDestination *GoogleCloudHealthcareV1FhirBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// GcsDestination: The Cloud Storage output destination. The Healthcare Service
	// Agent account requires the `roles/storage.objectAdmin` role on the Cloud
	// Storage location. The exported outputs are organized by FHIR resource types.
	// The server creates one object per resource type. Each object contains
	// newline delimited JSON, and each line is a FHIR resource.
	GcsDestination *GoogleCloudHealthcareV1FhirGcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Since") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Since") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportResourcesResponse: Response when all resources export successfully.
// This structure is included in the response to describe the detailed outcome
// after the operation finishes successfully.
type ExportResourcesResponse struct {
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Feature: A feature of an entity mention.
type Feature struct {
	// Confidence: The model's confidence in this feature annotation. A number
	// between 0 and 1.
	Confidence float64 `json:"confidence,omitempty"`
	// Value: The value of this feature annotation. Its range depends on the type
	// of the feature.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Feature) MarshalJSON() ([]byte, error) {
	type NoMethod Feature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Feature) UnmarshalJSON(data []byte) error {
	type NoMethod Feature
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// FhirConfig: Specifies how to handle de-identification of a FHIR store.
type FhirConfig struct {
	// DefaultKeepExtensions: Optional. The behaviour for handling FHIR extensions
	// that aren't otherwise specified for de-identification. If true, all
	// extensions are preserved during de-identification by default. If false or
	// unspecified, all extensions are removed during de-identification by default.
	DefaultKeepExtensions bool `json:"defaultKeepExtensions,omitempty"`
	// FieldMetadataList: Optional. Specifies FHIR paths to match and how to
	// transform them. Any field that is not matched by a FieldMetadata is passed
	// through to the output dataset unmodified. All extensions will be processed
	// according to `default_keep_extensions`.
	FieldMetadataList []*FieldMetadata `json:"fieldMetadataList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultKeepExtensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultKeepExtensions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FhirConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirFilter: Filter configuration.
type FhirFilter struct {
	// Resources: List of resources to include in the output. If this list is empty
	// or not specified, all resources are included in the output.
	Resources *Resources `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirFilter) MarshalJSON() ([]byte, error) {
	type NoMethod FhirFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirNotificationConfig: Contains the configuration for FHIR notifications.
type FhirNotificationConfig struct {
	// PubsubTopic: Optional. The Pub/Sub (https://cloud.google.com/pubsub/docs/)
	// topic that notifications of changes are published on. Supplied by the
	// client. The notification is a `PubsubMessage` with the following fields: *
	// `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId`
	// is the ID of this notification. It is guaranteed to be unique within the
	// topic. * `PubsubMessage.PublishTime` is the time when the message was
	// published. Note that notifications are only sent if the topic is non-empty.
	// Topic names (https://cloud.google.com/pubsub/docs/overview#names) must be
	// scoped to a project. The Cloud Healthcare API service account,
	// service-@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher
	// permissions on the given Pub/Sub topic. Not having adequate permissions
	// causes the calls that send notifications to fail
	// (https://cloud.google.com/healthcare-api/docs/permissions-healthcare-api-gcp-products#dicom_fhir_and_hl7v2_store_cloud_pubsub_permissions).
	// If a notification can't be published to Pub/Sub, errors are logged to Cloud
	// Logging. For more information, see Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare-api/docs/how-tos/logging).
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// SendFullResource: Optional. Whether to send full FHIR resource to this
	// Pub/Sub topic. The default value is false.
	SendFullResource bool `json:"sendFullResource,omitempty"`
	// SendPreviousResourceOnDelete: Optional. Whether to send full FHIR resource
	// to this Pub/Sub topic for deleting FHIR resource. The default value is
	// false. Note that setting this to true does not guarantee that all previous
	// resources will be sent in the format of full FHIR resource. When a resource
	// change is too large or during heavy traffic, only the resource name will be
	// sent. Clients should always check the "payloadType" label from a Pub/Sub
	// message to determine whether it needs to fetch the full previous resource as
	// a separate operation.
	SendPreviousResourceOnDelete bool `json:"sendPreviousResourceOnDelete,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PubsubTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PubsubTopic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirNotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FhirNotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirStore: Represents a FHIR store.
type FhirStore struct {
	// BulkExportGcsDestination: Optional. FHIR bulk export exports resources to
	// the specified Cloud Storage destination. A Cloud Storage destination is a
	// URI for a Cloud Storage directory where result files will be written. Only
	// used in the spec-defined bulk $export methods. The Cloud Healthcare Service
	// Agent requires the `roles/storage.objectAdmin` Cloud IAM role on the
	// destination.
	BulkExportGcsDestination *BulkExportGcsDestination `json:"bulkExportGcsDestination,omitempty"`
	// ComplexDataTypeReferenceParsing: Optional. Enable parsing of references
	// within complex FHIR data types such as Extensions. If this value is set to
	// ENABLED, then features like referential integrity and Bundle reference
	// rewriting apply to all references. If this flag has not been specified the
	// behavior of the FHIR store will not change, references in complex data types
	// will not be parsed. New stores will have this value set to ENABLED after a
	// notification period. Warning: turning on this flag causes processing
	// existing resources to fail if they contain references to non-existent
	// resources. Cannot be disabled in R5.
	//
	// Possible values:
	//   "COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED" - No parsing behavior
	// specified. This is the same as DISABLED for backwards compatibility.
	//   "DISABLED" - References in complex data types are ignored.
	//   "ENABLED" - References in complex data types are parsed.
	ComplexDataTypeReferenceParsing string `json:"complexDataTypeReferenceParsing,omitempty"`
	// ConsentConfig: Optional. Specifies whether this store has consent
	// enforcement. Not available for DSTU2 FHIR version due to absence of Consent
	// resources. Not supported for R5 FHIR version.
	ConsentConfig *ConsentConfig `json:"consentConfig,omitempty"`
	// DefaultSearchHandlingStrict: Optional. If true, overrides the default search
	// behavior for this FHIR store to `handling=strict` which returns an error for
	// unrecognized search parameters. If false, uses the FHIR specification
	// default `handling=lenient` which ignores unrecognized search parameters. The
	// handling can always be changed from the default on an individual API call by
	// setting the HTTP header `Prefer: handling=strict` or `Prefer:
	// handling=lenient`. Defaults to false.
	DefaultSearchHandlingStrict bool `json:"defaultSearchHandlingStrict,omitempty"`
	// DisableReferentialIntegrity: Immutable. Whether to disable referential
	// integrity in this FHIR store. This field is immutable after FHIR store
	// creation. The default value is false, meaning that the API enforces
	// referential integrity and fails the requests that result in inconsistent
	// state in the FHIR store. When this field is set to true, the API skips
	// referential integrity checks. Consequently, operations that rely on
	// references, such as GetPatientEverything, do not return all the results if
	// broken references exist.
	DisableReferentialIntegrity bool `json:"disableReferentialIntegrity,omitempty"`
	// DisableResourceVersioning: Immutable. Whether to disable resource versioning
	// for this FHIR store. This field can not be changed after the creation of
	// FHIR store. If set to false, all write operations cause historical versions
	// to be recorded automatically. The historical versions can be fetched through
	// the history APIs, but cannot be updated. If set to true, no historical
	// versions are kept. The server sends errors for attempts to read the
	// historical versions. Defaults to false.
	DisableResourceVersioning bool `json:"disableResourceVersioning,omitempty"`
	// EnableUpdateCreate: Optional. Whether this FHIR store has the updateCreate
	// capability
	// (https://www.hl7.org/fhir/capabilitystatement-definitions.html#CapabilityStatement.rest.resource.updateCreate).
	// This determines if the client can use an Update operation to create a new
	// resource with a client-specified ID. If false, all IDs are server-assigned
	// through the Create operation and attempts to update a non-existent resource
	// return errors. It is strongly advised not to include or encode any sensitive
	// data such as patient identifiers in client-specified resource IDs. Those IDs
	// are part of the FHIR resource path recorded in Cloud audit logs and Pub/Sub
	// notifications. Those IDs can also be contained in reference fields within
	// other resources. Defaults to false.
	EnableUpdateCreate bool `json:"enableUpdateCreate,omitempty"`
	// Labels: User-supplied key-value pairs used to organize FHIR stores. Label
	// keys must be between 1 and 63 characters long, have a UTF-8 encoding of
	// maximum 128 bytes, and must conform to the following PCRE regular
	// expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1
	// and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Identifier. Resource name of the FHIR store, of the form
	// `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStores/
	// {fhir_store_id}`.
	Name string `json:"name,omitempty"`
	// NotificationConfig: Deprecated. Use `notification_configs` instead. If
	// non-empty, publish all resource modifications of this FHIR store to this
	// destination. The Pub/Sub message attributes contain a map with a string
	// describing the action that has triggered the notification. For example,
	// "action":"CreateResource". Not supported in R5. Use `notification_configs`
	// instead.
	NotificationConfig *NotificationConfig `json:"notificationConfig,omitempty"`
	// NotificationConfigs: Optional. Specifies where and whether to send
	// notifications upon changes to a FHIR store.
	NotificationConfigs []*FhirNotificationConfig `json:"notificationConfigs,omitempty"`
	// StreamConfigs: Optional. A list of streaming configs that configure the
	// destinations of streaming export for every resource mutation in this FHIR
	// store. Each store is allowed to have up to 10 streaming configs. After a new
	// config is added, the next resource mutation is streamed to the new location
	// in addition to the existing ones. When a location is removed from the list,
	// the server stops streaming to that location. Before adding a new config, you
	// must add the required `bigquery.dataEditor`
	// (https://cloud.google.com/bigquery/docs/access-control#bigquery.dataEditor)
	// role to your project's **Cloud Healthcare Service Agent** service account
	// (https://cloud.google.com/iam/docs/service-accounts). Some lag (typically on
	// the order of dozens of seconds) is expected before the results show up in
	// the streaming destination.
	StreamConfigs []*StreamConfig `json:"streamConfigs,omitempty"`
	// ValidationConfig: Optional. Configuration for how to validate incoming FHIR
	// resources against configured profiles.
	ValidationConfig *ValidationConfig `json:"validationConfig,omitempty"`
	// Version: Required. Immutable. The FHIR specification version that this FHIR
	// store supports natively. This field is immutable after store creation.
	// Requests are rejected if they contain FHIR resources of a different version.
	// Version is required for every FHIR store.
	//
	// Possible values:
	//   "VERSION_UNSPECIFIED" - Users must specify a version on store creation or
	// an error is returned.
	//   "DSTU2" - Draft Standard for Trial Use, [Release
	// 2](https://www.hl7.org/fhir/DSTU2)
	//   "STU3" - Standard for Trial Use, [Release
	// 3](https://www.hl7.org/fhir/STU3)
	//   "R4" - [Release 4](https://www.hl7.org/fhir/R4)
	//   "R5" - [Release 5](https://www.hl7.org/fhir/R5)
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BulkExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BulkExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirStore) MarshalJSON() ([]byte, error) {
	type NoMethod FhirStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirStoreMetric: Count of resources and total storage size by type for a
// given FHIR store.
type FhirStoreMetric struct {
	// Count: The total count of FHIR resources in the store of this resource type.
	Count int64 `json:"count,omitempty,string"`
	// ResourceType: The FHIR resource type this metric applies to.
	ResourceType string `json:"resourceType,omitempty"`
	// StructuredStorageSizeBytes: The total amount of structured storage used by
	// FHIR resources of this resource type in the store.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirStoreMetric) MarshalJSON() ([]byte, error) {
	type NoMethod FhirStoreMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FhirStoreMetrics: List of metrics for a given FHIR store.
type FhirStoreMetrics struct {
	// Metrics: List of FhirStoreMetric by resource type.
	Metrics []*FhirStoreMetric `json:"metrics,omitempty"`
	// Name: The resource name of the FHIR store to get metrics for, in the format
	// `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FhirStoreMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod FhirStoreMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Field: A (sub) field of a type.
type Field struct {
	// MaxOccurs: The maximum number of times this field can be repeated. 0 or -1
	// means unbounded.
	MaxOccurs int64 `json:"maxOccurs,omitempty"`
	// MinOccurs: The minimum number of times this field must be present/repeated.
	MinOccurs int64 `json:"minOccurs,omitempty"`
	// Name: The name of the field. For example, "PID-1" or just "1".
	Name string `json:"name,omitempty"`
	// Table: The HL7v2 table this field refers to. For example, PID-15 (Patient's
	// Primary Language) usually refers to table "0296".
	Table string `json:"table,omitempty"`
	// Type: The type of this field. A Type with this name must be defined in an
	// Hl7TypesConfig.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxOccurs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxOccurs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Field) MarshalJSON() ([]byte, error) {
	type NoMethod Field
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldMetadata: Specifies FHIR paths to match, and how to handle
// de-identification of matching fields.
type FieldMetadata struct {
	// Action: Optional. Deidentify action for one field.
	//
	// Possible values:
	//   "ACTION_UNSPECIFIED" - No action specified. Defaults to DO_NOT_TRANSFORM.
	//   "TRANSFORM" - Transform the entire field.
	//   "INSPECT_AND_TRANSFORM" - Inspect and transform any found PHI.
	//   "DO_NOT_TRANSFORM" - Do not transform.
	Action string `json:"action,omitempty"`
	// Paths: Optional. List of paths to FHIR fields to be redacted. Each path is a
	// period-separated list where each component is either a field name or FHIR
	// type name, for example: Patient, HumanName. For "choice" types (those
	// defined in the FHIR spec with the form: field[x]) we use two separate
	// components. For example, "deceasedAge.unit" is matched by
	// "Deceased.Age.unit". Supported types are: AdministrativeGenderCode,
	// Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName, Id,
	// Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String,
	// UnsignedInt, Uri, Uuid, Xhtml.
	Paths []string `json:"paths,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod FieldMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsDestination: The Cloud Storage output destination. The Cloud Healthcare
// Service Agent requires the `roles/storage.objectAdmin` Cloud IAM roles on
// the Cloud Storage location.
type GcsDestination struct {
	// ContentStructure: The format of the exported HL7v2 message files.
	//
	// Possible values:
	//   "CONTENT_STRUCTURE_UNSPECIFIED" - If the content structure is not
	// specified, the default value `MESSAGE_JSON` will be used.
	//   "MESSAGE_JSON" - Messages are printed using the JSON format returned from
	// the `GetMessage` API. Messages are delimited with newlines.
	ContentStructure string `json:"contentStructure,omitempty"`
	// MessageView: Specifies the parts of the Message resource to include in the
	// export. If not specified, FULL is used.
	//
	// Possible values:
	//   "MESSAGE_VIEW_UNSPECIFIED" - Not specified, equivalent to FULL.
	//   "RAW_ONLY" - Server responses include all the message fields except
	// parsed_data field, and schematized_data fields.
	//   "PARSED_ONLY" - Server responses include all the message fields except
	// data field, and schematized_data fields.
	//   "FULL" - Server responses include all the message fields.
	//   "SCHEMATIZED_ONLY" - Server responses include all the message fields
	// except data and parsed_data fields.
	//   "BASIC" - Server responses include only the name field.
	MessageView string `json:"messageView,omitempty"`
	// UriPrefix: URI of an existing Cloud Storage directory where the server
	// writes result files, in the format
	// `gs://{bucket-id}/{path/to/destination/dir}`. If there is no trailing slash,
	// the service appends one when composing the object path.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentStructure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentStructure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsSource: Specifies the configuration for importing data from Cloud
// Storage.
type GcsSource struct {
	// Uri: Points to a Cloud Storage URI containing file(s) to import. The URI
	// must be in the following format: `gs://{bucket_id}/{object_id}`. The URI can
	// include wildcards in `object_id` and thus identify multiple files. Supported
	// wildcards: * `*` to match 0 or more non-separator characters * `**` to match
	// 0 or more characters (including separators). Must be used at the end of a
	// path and with no other wildcards in the path. Can also be used with a file
	// extension (such as .ndjson), which imports all files with the extension in
	// the specified directory and its sub-directories. For example,
	// `gs://my-bucket/my-directory/**.ndjson` imports all files with `.ndjson`
	// extensions in `my-directory/` and its sub-directories. * `?` to match 1
	// character Files matching the wildcard are expected to contain content only,
	// no metadata.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1ConsentGcsDestination: The Cloud Storage location for
// export.
type GoogleCloudHealthcareV1ConsentGcsDestination struct {
	// UriPrefix: URI for a Cloud Storage directory where the server writes result
	// files, in the format `gs://{bucket-id}/{path/to/destination/dir}`. If there
	// is no trailing slash, the service appends one when composing the object
	// path. The user is responsible for creating the Cloud Storage bucket and
	// directory referenced in `uri_prefix`.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1ConsentGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1ConsentGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1ConsentPolicy: Represents a user's consent in terms
// of the resources that can be accessed and under what conditions.
type GoogleCloudHealthcareV1ConsentPolicy struct {
	// AuthorizationRule: Required. The request conditions to meet to grant access.
	// In addition to any supported comparison operators, authorization rules may
	// have `IN` operator as well as at most 10 logical operators that are limited
	// to `AND` (`&&`), `OR` (`||`).
	AuthorizationRule *Expr `json:"authorizationRule,omitempty"`
	// ResourceAttributes: The resources that this policy applies to. A resource is
	// a match if it matches all the attributes listed here. If empty, this policy
	// applies to all User data mappings for the given user.
	ResourceAttributes []*Attribute `json:"resourceAttributes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthorizationRule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizationRule") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1ConsentPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1ConsentPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1DeidentifyDeidentifyDicomStoreSummary: Contains a
// summary of the DeidentifyDicomStore operation.
type GoogleCloudHealthcareV1DeidentifyDeidentifyDicomStoreSummary struct {
}

// GoogleCloudHealthcareV1DeidentifyDeidentifyFhirStoreSummary: Contains a
// summary of the DeidentifyFhirStore operation.
type GoogleCloudHealthcareV1DeidentifyDeidentifyFhirStoreSummary struct {
}

// GoogleCloudHealthcareV1DicomBigQueryDestination: The BigQuery table where
// the server writes the output.
type GoogleCloudHealthcareV1DicomBigQueryDestination struct {
	// Force: Optional. Use `write_disposition` instead. If `write_disposition` is
	// specified, this parameter is ignored. force=false is equivalent to
	// write_disposition=WRITE_EMPTY and force=true is equivalent to
	// write_disposition=WRITE_TRUNCATE.
	Force bool `json:"force,omitempty"`
	// TableUri: Optional. BigQuery URI to a table, up to 2000 characters long, in
	// the format `bq://projectId.bqDatasetId.tableId`
	TableUri string `json:"tableUri,omitempty"`
	// WriteDisposition: Optional. Determines whether the existing table in the
	// destination is to be overwritten or appended to. If a write_disposition is
	// specified, the `force` parameter is ignored.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Default behavior is the same as
	// WRITE_EMPTY.
	//   "WRITE_EMPTY" - Only export data if the destination table is empty.
	//   "WRITE_TRUNCATE" - Erase all existing data in the destination table before
	// writing the instances.
	//   "WRITE_APPEND" - Append data to the destination table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Force") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Force") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1DicomBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1DicomBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1DicomGcsDestination: The Cloud Storage location where
// the server writes the output and the export configuration.
type GoogleCloudHealthcareV1DicomGcsDestination struct {
	// MimeType: MIME types supported by DICOM spec. Each file is written in the
	// following format:
	// `.../{study_id}/{series_id}/{instance_id}[/{frame_number}].{extension}` The
	// frame_number component exists only for multi-frame instances. Supported MIME
	// types are consistent with supported formats in DICOMweb:
	// https://cloud.google.com/healthcare/docs/dicom#retrieve_transaction.
	// Specifically, the following are supported: - application/dicom;
	// transfer-syntax=1.2.840.10008.1.2.1 (uncompressed DICOM) -
	// application/dicom; transfer-syntax=1.2.840.10008.1.2.4.50 (DICOM with
	// embedded JPEG Baseline) - application/dicom;
	// transfer-syntax=1.2.840.10008.1.2.4.90 (DICOM with embedded JPEG 2000
	// Lossless Only) - application/dicom; transfer-syntax=1.2.840.10008.1.2.4.91
	// (DICOM with embedded JPEG 2000) - application/dicom; transfer-syntax=*
	// (DICOM with no transcoding) - application/octet-stream;
	// transfer-syntax=1.2.840.10008.1.2.1 (raw uncompressed PixelData) -
	// application/octet-stream; transfer-syntax=* (raw PixelData in whatever
	// format it was uploaded in) - image/jpeg;
	// transfer-syntax=1.2.840.10008.1.2.4.50 (Consumer JPEG) - image/png The
	// following extensions are used for output files: - application/dicom -> .dcm
	// - image/jpeg -> .jpg - image/png -> .png - application/octet-stream -> no
	// extension If unspecified, the instances are exported in the original DICOM
	// format they were uploaded in.
	MimeType string `json:"mimeType,omitempty"`
	// UriPrefix: The Cloud Storage destination to export to. URI for a Cloud
	// Storage directory where the server writes the result files, in the format
	// `gs://{bucket-id}/{path/to/destination/dir}`). If there is no trailing
	// slash, the service appends one when composing the object path. The user is
	// responsible for creating the Cloud Storage bucket referenced in
	// `uri_prefix`.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1DicomGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1DicomGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1DicomGcsSource: Specifies the configuration for
// importing data from Cloud Storage.
type GoogleCloudHealthcareV1DicomGcsSource struct {
	// Uri: Points to a Cloud Storage URI containing file(s) with content only. The
	// URI must be in the following format: `gs://{bucket_id}/{object_id}`. The URI
	// can include wildcards in `object_id` and thus identify multiple files.
	// Supported wildcards: * '*' to match 0 or more non-separator characters *
	// '**' to match 0 or more characters (including separators). Must be used at
	// the end of a path and with no other wildcards in the path. Can also be used
	// with a file extension (such as .dcm), which imports all files with the
	// extension in the specified directory and its sub-directories. For example,
	// `gs://my-bucket/my-directory/**.dcm` imports all files with .dcm extensions
	// in `my-directory/` and its sub-directories. * '?' to match 1 character. All
	// other URI formats are invalid. Files matching the wildcard are expected to
	// contain content only, no metadata.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1DicomGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1DicomGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1DicomStreamConfig: StreamConfig specifies
// configuration for a streaming DICOM export.
type GoogleCloudHealthcareV1DicomStreamConfig struct {
	// BigqueryDestination: Results are appended to this table. The server creates
	// a new table in the given BigQuery dataset if the specified table does not
	// exist. To enable the Cloud Healthcare API to write to your BigQuery table,
	// you must give the Cloud Healthcare API service account the
	// bigquery.dataEditor role. The service account is:
	// `service-{PROJECT_NUMBER}@gcp-sa-healthcare.iam.gserviceaccount.com`. The
	// PROJECT_NUMBER identifies the project that the DICOM store resides in. To
	// get the project number, go to the Cloud Console Dashboard. It is recommended
	// to not have a custom schema in the destination table which could conflict
	// with the schema created by the Cloud Healthcare API. Instance deletions are
	// not applied to the destination table. The destination's table schema will be
	// automatically updated in case a new instance's data is incompatible with the
	// current schema. The schema should not be updated manually as this can cause
	// incompatibilies that cannot be resolved automatically. One resolution in
	// this case is to delete the incompatible table and let the server recreate
	// one, though the newly created table only contains data after the table
	// recreation. BigQuery imposes a 1 MB limit on streaming insert row size,
	// therefore any instance that generates more than 1 MB of BigQuery data will
	// not be streamed. If an instance cannot be streamed to BigQuery, errors will
	// be logged to Cloud Logging (see Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
	BigqueryDestination *GoogleCloudHealthcareV1DicomBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1DicomStreamConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1DicomStreamConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1FhirBigQueryDestination: The configuration for
// exporting to BigQuery.
type GoogleCloudHealthcareV1FhirBigQueryDestination struct {
	// DatasetUri: Optional. BigQuery URI to an existing dataset, up to 2000
	// characters long, in the format `bq://projectId.bqDatasetId`.
	DatasetUri string `json:"datasetUri,omitempty"`
	// Force: Optional. The default value is false. If this flag is `TRUE`, all
	// tables are deleted from the dataset before the new exported tables are
	// written. If the flag is not set and the destination dataset contains tables,
	// the export call returns an error. If `write_disposition` is specified, this
	// parameter is ignored. force=false is equivalent to
	// write_disposition=WRITE_EMPTY and force=true is equivalent to
	// write_disposition=WRITE_TRUNCATE.
	Force bool `json:"force,omitempty"`
	// SchemaConfig: Optional. The configuration for the exported BigQuery schema.
	SchemaConfig *SchemaConfig `json:"schemaConfig,omitempty"`
	// WriteDisposition: Optional. Determines if existing data in the destination
	// dataset is overwritten, appended to, or not written if the tables contain
	// data. If a write_disposition is specified, the `force` parameter is ignored.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Default behavior is the same as
	// WRITE_EMPTY.
	//   "WRITE_EMPTY" - Only export data if the destination tables are empty.
	//   "WRITE_TRUNCATE" - Erase all existing data in the destination tables
	// before writing the FHIR resources.
	//   "WRITE_APPEND" - Append data to the destination tables.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1FhirBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1FhirBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1FhirGcsDestination: The configuration for exporting
// to Cloud Storage.
type GoogleCloudHealthcareV1FhirGcsDestination struct {
	// UriPrefix: URI for a Cloud Storage directory where result files should be
	// written, in the format of `gs://{bucket-id}/{path/to/destination/dir}`. If
	// there is no trailing slash, the service appends one when composing the
	// object path. The user is responsible for creating the Cloud Storage bucket
	// referenced in `uri_prefix`.
	UriPrefix string `json:"uriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UriPrefix") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1FhirGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1FhirGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudHealthcareV1FhirGcsSource: Specifies the configuration for
// importing data from Cloud Storage.
type GoogleCloudHealthcareV1FhirGcsSource struct {
	// Uri: Points to a Cloud Storage URI containing file(s) to import. The URI
	// must be in the following format: `gs://{bucket_id}/{object_id}`. The URI can
	// include wildcards in `object_id` and thus identify multiple files. Supported
	// wildcards: * `*` to match 0 or more non-separator characters * `**` to match
	// 0 or more characters (including separators). Must be used at the end of a
	// path and with no other wildcards in the path. Can also be used with a file
	// extension (such as .ndjson), which imports all files with the extension in
	// the specified directory and its sub-directories. For example,
	// `gs://my-bucket/my-directory/**.ndjson` imports all files with `.ndjson`
	// extensions in `my-directory/` and its sub-directories. * `?` to match 1
	// character Files matching the wildcard are expected to contain content only,
	// no metadata.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudHealthcareV1FhirGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudHealthcareV1FhirGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GroupOrSegment: Construct representing a logical group or a segment.
type GroupOrSegment struct {
	Group   *SchemaGroup   `json:"group,omitempty"`
	Segment *SchemaSegment `json:"segment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Group") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Group") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroupOrSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GroupOrSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7SchemaConfig: Root config message for HL7v2 schema. This contains a
// schema structure of groups and segments, and filters that determine which
// messages to apply the schema structure to.
type Hl7SchemaConfig struct {
	// MessageSchemaConfigs: Map from each HL7v2 message type and trigger event
	// pair, such as ADT_A04, to its schema configuration root group.
	MessageSchemaConfigs map[string]SchemaGroup `json:"messageSchemaConfigs,omitempty"`
	// Version: Each VersionSource is tested and only if they all match is the
	// schema used for the message.
	Version []*VersionSource `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MessageSchemaConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MessageSchemaConfigs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7SchemaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7SchemaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7TypesConfig: Root config for HL7v2 datatype definitions for a specific
// HL7v2 version.
type Hl7TypesConfig struct {
	// Type: The HL7v2 type definitions.
	Type []*Type `json:"type,omitempty"`
	// Version: The version selectors that this config applies to. A message must
	// match ALL version sources to apply.
	Version []*VersionSource `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7TypesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7TypesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7V2NotificationConfig: Specifies where and whether to send notifications
// upon changes to a data store.
type Hl7V2NotificationConfig struct {
	// Filter: Optional. Restricts notifications sent for messages matching a
	// filter. If this is empty, all messages are matched. The following syntax is
	// available: * A string field value can be written as text inside quotation
	// marks, for example "query text". The only valid relational operation for
	// text fields is equality (`=`), where text is searched within the field,
	// rather than having the field be equal to the text. For example, "Comment =
	// great" returns messages with `great` in the comment field. * A number field
	// value can be written as an integer, a decimal, or an exponential. The valid
	// relational operators for number fields are the equality operator (`=`),
	// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
	// that there is no inequality (`!=`) operator. You can prepend the `NOT`
	// operator to an expression to negate it. * A date field value must be written
	// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
	// Leading zeros are required for one-digit months and days. The valid
	// relational operators for date fields are the equality operator (`=`) , along
	// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
	// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
	// to an expression to negate it. * Multiple field query expressions can be
	// combined in one query by adding `AND` or `OR` operators between the
	// expressions. If a boolean operator appears within a quoted string, it is not
	// treated as special, it's just another part of the character string to be
	// matched. You can prepend the `NOT` operator to an expression to negate it.
	// The following fields and functions are available for filtering: *
	// `message_type`, from the MSH-9.1 field. For example, `NOT message_type =
	// "ADT". * `send_date` or `sendDate`, the YYYY-MM-DD date the message was
	// sent in the dataset's time_zone, from the MSH-7 segment. For example,
	// `send_date < "2017-01-02". * `send_time`, the timestamp when the message
	// was sent, using the RFC3339 time format for comparisons, from the MSH-7
	// segment. For example, `send_time < "2017-01-02T00:00:00-05:00". *
	// `create_time`, the timestamp when the message was created in the HL7v2
	// store. Use the RFC3339 time format for comparisons. For example,
	// `create_time < "2017-01-02T00:00:00-05:00". * `send_facility`, the care
	// center that the message came from, from the MSH-4 segment. For example,
	// `send_facility = "ABC". * `PatientId(value, type)`, which matches if the
	// message lists a patient having an ID of the given value and type in the
	// PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`.
	// * `labels.x`, a string value of the label with key `x` as set using the
	// Message.labels map. For example, `labels."priority"="high". The operator
	// `:*` can be used to assert the existence of a label. For example,
	// `labels."priority":*`.
	Filter string `json:"filter,omitempty"`
	// PubsubTopic: The Pub/Sub (https://cloud.google.com/pubsub/docs/) topic that
	// notifications of changes are published on. Supplied by the client. The
	// notification is a `PubsubMessage` with the following fields: *
	// `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId`
	// is the ID of this notification. It's guaranteed to be unique within the
	// topic. * `PubsubMessage.PublishTime` is the time when the message was
	// published. Note that notifications are only sent if the topic is non-empty.
	// Topic names (https://cloud.google.com/pubsub/docs/overview#names) must be
	// scoped to a project. The Cloud Healthcare API service account,
	// service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com, must have
	// publisher permissions on the given Pub/Sub topic. Not having adequate
	// permissions causes the calls that send notifications to fail. If a
	// notification cannot be published to Pub/Sub, errors are logged to Cloud
	// Logging. For more information, see Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7V2NotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7V2NotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7V2Store: Represents an HL7v2 store.
type Hl7V2Store struct {
	// Labels: User-supplied key-value pairs used to organize HL7v2 stores. Label
	// keys must be between 1 and 63 characters long, have a UTF-8 encoding of
	// maximum 128 bytes, and must conform to the following PCRE regular
	// expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1
	// and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Resource name of the HL7v2 store, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/hl7V2Sto
	// res/{hl7v2_store_id}`.
	Name string `json:"name,omitempty"`
	// NotificationConfigs: Optional. A list of notification configs. Each
	// configuration uses a filter to determine whether to publish a message (both
	// Ingest & Create) on the corresponding notification destination. Only the
	// message name is sent as part of the notification. Supplied by the client.
	NotificationConfigs []*Hl7V2NotificationConfig `json:"notificationConfigs,omitempty"`
	// ParserConfig: Optional. The configuration for the parser. It determines how
	// the server parses the messages.
	ParserConfig *ParserConfig `json:"parserConfig,omitempty"`
	// RejectDuplicateMessage: Optional. Determines whether to reject duplicate
	// messages. A duplicate message is a message with the same raw bytes as a
	// message that has already been ingested/created in this HL7v2 store. The
	// default value is false, meaning that the store accepts the duplicate
	// messages and it also returns the same ACK message in the
	// IngestMessageResponse as has been returned previously. Note that only one
	// resource is created in the store. When this field is set to true,
	// CreateMessage/IngestMessage requests with a duplicate message will be
	// rejected by the store, and IngestMessageErrorDetail returns a NACK message
	// upon rejection.
	RejectDuplicateMessage bool `json:"rejectDuplicateMessage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7V2Store) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7V2Store
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7V2StoreMetric: Count of messages and total storage size by type for a
// given HL7 store.
type Hl7V2StoreMetric struct {
	// Count: The total count of HL7v2 messages in the store for the given message
	// type.
	Count int64 `json:"count,omitempty,string"`
	// MessageType: The Hl7v2 message type this metric applies to, such as `ADT` or
	// `ORU`.
	MessageType string `json:"messageType,omitempty"`
	// StructuredStorageSizeBytes: The total amount of structured storage used by
	// HL7v2 messages of this message type in the store.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7V2StoreMetric) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7V2StoreMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hl7V2StoreMetrics: List of metrics for a given HL7v2 store.
type Hl7V2StoreMetrics struct {
	// Metrics: List of HL7v2 store metrics by message type.
	Metrics []*Hl7V2StoreMetric `json:"metrics,omitempty"`
	// Name: The resource name of the HL7v2 store to get metrics for, in the format
	// `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hl7V2StoreMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod Hl7V2StoreMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpBody: Message that represents an arbitrary HTTP body. It should only be
// used for payload formats that can't be represented as JSON, such as raw
// binary or an HTML page. This message can be used both in streaming and
// non-streaming API methods in the request as well as the response. It can be
// used as a top-level request field, which is convenient if one wants to
// extract parameters from either the URL or HTTP template into the request
// fields and also want access to the raw HTTP body. Example: message
// GetResourceRequest { // A unique request id. string request_id = 1; // The
// raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; }
// service ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); } Use of this type only changes how the
// request and response bodies are handled, all other features will continue to
// work unchanged.
type HttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the content type
	// of the body.
	ContentType string `json:"contentType,omitempty"`
	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`
	// Extensions: Application specific response metadata. Must be set in the first
	// response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod HttpBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Image: Raw bytes representing consent artifact content.
type Image struct {
	// GcsUri: Input only. Points to a Cloud Storage URI containing the consent
	// artifact content. The URI must be in the following format:
	// `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account
	// must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud
	// Storage location. The consent artifact content at this URI is copied to a
	// Cloud Storage location managed by the Cloud Healthcare API. Responses to
	// fetching requests return the consent artifact content in raw_bytes.
	GcsUri string `json:"gcsUri,omitempty"`
	// RawBytes: Consent artifact content represented as a stream of bytes. This
	// field is populated when returned in GetConsentArtifact response, but not
	// included in CreateConsentArtifact and ListConsentArtifact response.
	RawBytes string `json:"rawBytes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImageConfig: Specifies how to handle de-identification of image pixels.
type ImageConfig struct {
	// TextRedactionMode: Optional. Determines how to redact text from image.
	//
	// Possible values:
	//   "TEXT_REDACTION_MODE_UNSPECIFIED" - No text redaction specified. Same as
	// REDACT_NO_TEXT.
	//   "REDACT_ALL_TEXT" - Redact all text.
	//   "REDACT_SENSITIVE_TEXT" - Redact sensitive text. Uses the set of [Default
	// DICOM
	// InfoTypes](https://cloud.google.com/healthcare-api/docs/how-tos/dicom-deident
	// ify#default_dicom_infotypes).
	//   "REDACT_NO_TEXT" - Do not redact text.
	TextRedactionMode string `json:"textRedactionMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TextRedactionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TextRedactionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ImageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportDicomDataRequest: Imports data into the specified DICOM store. Returns
// an error if any of the files to import are not DICOM files. This API accepts
// duplicate DICOM instances by ignoring the newly-pushed instance. It does not
// overwrite.
type ImportDicomDataRequest struct {
	// BlobStorageSettings: Optional. The blob storage settings for the data
	// imported by this operation.
	BlobStorageSettings *BlobStorageSettings `json:"blobStorageSettings,omitempty"`
	// GcsSource: Cloud Storage source data location and import configuration. The
	// Cloud Healthcare Service Agent requires the `roles/storage.objectViewer`
	// Cloud IAM roles on the Cloud Storage location.
	GcsSource *GoogleCloudHealthcareV1DicomGcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportDicomDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportDicomDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportDicomDataResponse: Returns additional information in regards to a
// completed DICOM store import.
type ImportDicomDataResponse struct {
}

// ImportMessagesRequest: Request to import messages.
type ImportMessagesRequest struct {
	// GcsSource: Cloud Storage source data location and import configuration. The
	// Cloud Healthcare Service Agent requires the `roles/storage.objectViewer`
	// Cloud IAM roles on the Cloud Storage location.
	GcsSource *GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportMessagesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportMessagesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportMessagesResponse: Final response of importing messages. This structure
// is included in the response to describe the detailed outcome. It is only
// included when the operation finishes successfully.
type ImportMessagesResponse struct {
}

// ImportResourcesRequest: Request to import resources.
type ImportResourcesRequest struct {
	// ContentStructure: The content structure in the source location. If not
	// specified, the server treats the input source files as BUNDLE.
	//
	// Possible values:
	//   "CONTENT_STRUCTURE_UNSPECIFIED" - If the content structure is not
	// specified, the default value `BUNDLE` is used.
	//   "BUNDLE" - The source file contains one or more lines of newline-delimited
	// JSON (ndjson). Each line is a bundle that contains one or more resources.
	//   "RESOURCE" - The source file contains one or more lines of
	// newline-delimited JSON (ndjson). Each line is a single resource.
	//   "BUNDLE_PRETTY" - The entire file is one JSON bundle. The JSON can span
	// multiple lines.
	//   "RESOURCE_PRETTY" - The entire file is one JSON resource. The JSON can
	// span multiple lines.
	ContentStructure string `json:"contentStructure,omitempty"`
	// GcsSource: Cloud Storage source data location and import configuration. The
	// Healthcare Service Agent account requires the `roles/storage.objectAdmin`
	// role on the Cloud Storage location. Each Cloud Storage object should be a
	// text file that contains the format specified in ContentStructure.
	GcsSource *GoogleCloudHealthcareV1FhirGcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentStructure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentStructure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportResourcesResponse: Final response of importing resources. This
// structure is included in the response to describe the detailed outcome after
// the operation finishes successfully.
type ImportResourcesResponse struct {
}

// InfoTypeTransformation: A transformation to apply to text that is identified
// as a specific info_type.
type InfoTypeTransformation struct {
	// CharacterMaskConfig: Config for character mask.
	CharacterMaskConfig *CharacterMaskConfig `json:"characterMaskConfig,omitempty"`
	// CryptoHashConfig: Config for crypto hash.
	CryptoHashConfig *CryptoHashConfig `json:"cryptoHashConfig,omitempty"`
	// DateShiftConfig: Config for date shift.
	DateShiftConfig *DateShiftConfig `json:"dateShiftConfig,omitempty"`
	// InfoTypes: Optional. InfoTypes to apply this transformation to. If this is
	// not specified, the transformation applies to any info_type.
	InfoTypes []string `json:"infoTypes,omitempty"`
	// RedactConfig: Config for text redaction.
	RedactConfig *RedactConfig `json:"redactConfig,omitempty"`
	// ReplaceWithInfoTypeConfig: Config for replace with InfoType.
	ReplaceWithInfoTypeConfig *ReplaceWithInfoTypeConfig `json:"replaceWithInfoTypeConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CharacterMaskConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CharacterMaskConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InfoTypeTransformation) MarshalJSON() ([]byte, error) {
	type NoMethod InfoTypeTransformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IngestMessageRequest: Ingests a message into the specified HL7v2 store.
type IngestMessageRequest struct {
	// Message: Required. HL7v2 message to ingest.
	Message *Message `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IngestMessageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod IngestMessageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IngestMessageResponse: Acknowledges that a message has been ingested into
// the specified HL7v2 store.
type IngestMessageResponse struct {
	// Hl7Ack: HL7v2 ACK message.
	Hl7Ack string `json:"hl7Ack,omitempty"`
	// Message: Created message resource.
	Message *Message `json:"message,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Hl7Ack") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hl7Ack") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IngestMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod IngestMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KmsWrappedCryptoKey: Include to use an existing data crypto key wrapped by
// KMS. The wrapped key must be a 128-, 192-, or 256-bit key. The key must
// grant the Cloud IAM permission `cloudkms.cryptoKeyVersions.useToDecrypt` to
// the project's Cloud Healthcare Service Agent service account. For more
// information, see [Creating a wrapped key]
// (https://cloud.google.com/dlp/docs/create-wrapped-key).
type KmsWrappedCryptoKey struct {
	// CryptoKey: Required. The resource name of the KMS CryptoKey to use for
	// unwrapping. For example,
	// `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/
	// {key}`.
	CryptoKey string `json:"cryptoKey,omitempty"`
	// WrappedKey: Required. The wrapped data crypto key.
	WrappedKey string `json:"wrappedKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KmsWrappedCryptoKey) MarshalJSON() ([]byte, error) {
	type NoMethod KmsWrappedCryptoKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LinkedEntity: EntityMentions can be linked to multiple entities using a
// LinkedEntity message lets us add other fields, e.g. confidence.
type LinkedEntity struct {
	// EntityId: entity_id is a concept unique identifier. These are prefixed by a
	// string that identifies the entity coding system, followed by the unique
	// identifier within that system. For example, "UMLS/C0000970". This also
	// supports ad hoc entities, which are formed by normalizing entity mention
	// content.
	EntityId string `json:"entityId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinkedEntity) MarshalJSON() ([]byte, error) {
	type NoMethod LinkedEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListAttributeDefinitionsResponse struct {
	// AttributeDefinitions: The returned Attribute definitions. The maximum number
	// of attributes returned is determined by the value of page_size in the
	// ListAttributeDefinitionsRequest.
	AttributeDefinitions []*AttributeDefinition `json:"attributeDefinitions,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AttributeDefinitions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeDefinitions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAttributeDefinitionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAttributeDefinitionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListConsentArtifactsResponse struct {
	// ConsentArtifacts: The returned Consent artifacts. The maximum number of
	// artifacts returned is determined by the value of page_size in the
	// ListConsentArtifactsRequest.
	ConsentArtifacts []*ConsentArtifact `json:"consentArtifacts,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifacts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifacts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConsentArtifactsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConsentArtifactsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListConsentRevisionsResponse struct {
	// Consents: The returned Consent revisions. The maximum number of revisions
	// returned is determined by the value of `page_size` in the
	// ListConsentRevisionsRequest.
	Consents []*Consent `json:"consents,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Consents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Consents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConsentRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConsentRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListConsentStoresResponse struct {
	// ConsentStores: The returned consent stores. The maximum number of stores
	// returned is determined by the value of page_size in the
	// ListConsentStoresRequest.
	ConsentStores []*ConsentStore `json:"consentStores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConsentStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConsentStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConsentStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListConsentsResponse struct {
	// Consents: The returned Consents. The maximum number of Consents returned is
	// determined by the value of page_size in the ListConsentsRequest.
	Consents []*Consent `json:"consents,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Consents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Consents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConsentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConsentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDatasetsResponse: Lists the available datasets.
type ListDatasetsResponse struct {
	// Datasets: The first page of datasets.
	Datasets []*Dataset `json:"datasets,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDicomStoresResponse: Lists the DICOM stores in the given dataset.
type ListDicomStoresResponse struct {
	// DicomStores: The returned DICOM stores. Won't be more DICOM stores than the
	// value of page_size in the request.
	DicomStores []*DicomStore `json:"dicomStores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DicomStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DicomStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDicomStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDicomStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFhirStoresResponse: Lists the FHIR stores in the given dataset.
type ListFhirStoresResponse struct {
	// FhirStores: The returned FHIR stores. Won't be more FHIR stores than the
	// value of page_size in the request.
	FhirStores []*FhirStore `json:"fhirStores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FhirStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFhirStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFhirStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListHl7V2StoresResponse: Lists the HL7v2 stores in the given dataset.
type ListHl7V2StoresResponse struct {
	// Hl7V2Stores: The returned HL7v2 stores. Won't be more HL7v2 stores than the
	// value of page_size in the request.
	Hl7V2Stores []*Hl7V2Store `json:"hl7V2Stores,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Hl7V2Stores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hl7V2Stores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListHl7V2StoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListHl7V2StoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMessagesResponse: Lists the messages in the specified HL7v2 store.
type ListMessagesResponse struct {
	// Hl7V2Messages: The returned Messages. Won't be more Messages than the value
	// of page_size in the request. See view for populated fields.
	Hl7V2Messages []*Message `json:"hl7V2Messages,omitempty"`
	// NextPageToken: Token to retrieve the next page of results or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Hl7V2Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hl7V2Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMessagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMessagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListUserDataMappingsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UserDataMappings: The returned User data mappings. The maximum number of
	// User data mappings returned is determined by the value of page_size in the
	// ListUserDataMappingsRequest.
	UserDataMappings []*UserDataMapping `json:"userDataMappings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListUserDataMappingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUserDataMappingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Message: A complete HL7v2 message. See [Introduction to HL7 Standards]
// (https://www.hl7.org/implement/standards/index.cfm?ref=common) for details
// on the standard.
type Message struct {
	// CreateTime: Output only. The datetime when the message was created. Set by
	// the server.
	CreateTime string `json:"createTime,omitempty"`
	// Data: Required. Raw message bytes.
	Data string `json:"data,omitempty"`
	// Labels: User-supplied key-value pairs used to organize HL7v2 stores. Label
	// keys must be between 1 and 63 characters long, have a UTF-8 encoding of
	// maximum 128 bytes, and must conform to the following PCRE regular
	// expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1
	// and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
	// conform to the following PCRE regular expression:
	// [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a
	// given store.
	Labels map[string]string `json:"labels,omitempty"`
	// MessageType: Output only. The message type for this message. MSH-9.1.
	MessageType string `json:"messageType,omitempty"`
	// Name: Output only. Resource name of the Message, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/hl7V2Sto
	// res/{hl7_v2_store_id}/messages/{message_id}`.
	Name string `json:"name,omitempty"`
	// ParsedData: Output only. The parsed version of the raw message data.
	ParsedData *ParsedData `json:"parsedData,omitempty"`
	// PatientIds: Output only. All patient IDs listed in the PID-2, PID-3, and
	// PID-4 segments of this message.
	PatientIds []*PatientId `json:"patientIds,omitempty"`
	// SchematizedData: Output only. The parsed version of the raw message data
	// schematized according to this store's schemas and type definitions.
	SchematizedData *SchematizedData `json:"schematizedData,omitempty"`
	// SendFacility: Output only. The hospital that this message came from. MSH-4.
	SendFacility string `json:"sendFacility,omitempty"`
	// SendTime: Output only. The datetime the sending application sent this
	// message. MSH-7.
	SendTime string `json:"sendTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Message) MarshalJSON() ([]byte, error) {
	type NoMethod Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NotificationConfig: Specifies where to send notifications upon changes to a
// data store.
type NotificationConfig struct {
	// PubsubTopic: The Pub/Sub (https://cloud.google.com/pubsub/docs/) topic that
	// notifications of changes are published on. Supplied by the client.
	// PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is
	// the ID of this message. It is guaranteed to be unique within the topic.
	// PubsubMessage.PublishTime is the time at which the message was published.
	// Notifications are only sent if the topic is non-empty. Topic names
	// (https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a
	// project. Cloud Healthcare API service account must have publisher
	// permissions on the given Pub/Sub topic. Not having adequate permissions
	// causes the calls that send notifications to fail. If a notification can't be
	// published to Pub/Sub, errors are logged to Cloud Logging (see Viewing error
	// logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number
	// of errors exceeds a certain rate, some aren't submitted. Note that not all
	// operations trigger notifications, see Configuring Pub/Sub notifications
	// (https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific
	// details.
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// SendForBulkImport: Indicates whether or not to send Pub/Sub notifications on
	// bulk import. Only supported for DICOM imports.
	SendForBulkImport bool `json:"sendForBulkImport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PubsubTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PubsubTopic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod NotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: OperationMetadata provides information about the
// operation execution. Returned in the long-running operation's metadata
// field.
type OperationMetadata struct {
	// ApiMethodName: The name of the API method that initiated the operation.
	ApiMethodName string `json:"apiMethodName,omitempty"`
	// CancelRequested: Specifies if cancellation was requested for the operation.
	CancelRequested bool             `json:"cancelRequested,omitempty"`
	Counter         *ProgressCounter `json:"counter,omitempty"`
	// CreateTime: The time at which the operation was created by the API.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time at which execution was completed.
	EndTime string `json:"endTime,omitempty"`
	// LogsUrl: A link to audit and error logs in the log viewer. Error logs are
	// generated only by some operations, listed at Viewing error logs in Cloud
	// Logging (https://cloud.google.com/healthcare/docs/how-tos/logging).
	LogsUrl string `json:"logsUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiMethodName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiMethodName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ParsedData: The content of a HL7v2 message in a structured format.
type ParsedData struct {
	Segments []*Segment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ParsedData) MarshalJSON() ([]byte, error) {
	type NoMethod ParsedData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ParserConfig: The configuration for the parser. It determines how the server
// parses the messages.
type ParserConfig struct {
	// AllowNullHeader: Optional. Determines whether messages with no header are
	// allowed.
	AllowNullHeader bool `json:"allowNullHeader,omitempty"`
	// Schema: Optional. Schemas used to parse messages in this store, if
	// schematized parsing is desired.
	Schema *SchemaPackage `json:"schema,omitempty"`
	// SegmentTerminator: Optional. Byte(s) to use as the segment terminator. If
	// this is unset, '\r' is used as segment terminator, matching the HL7 version
	// 2 specification.
	SegmentTerminator string `json:"segmentTerminator,omitempty"`
	// Version: Immutable. Determines the version of both the default parser to be
	// used when `schema` is not given, as well as the schematized parser used when
	// `schema` is specified. This field is immutable after HL7v2 store creation.
	//
	// Possible values:
	//   "PARSER_VERSION_UNSPECIFIED" - Unspecified parser version, equivalent to
	// V1.
	//   "V1" - The `parsed_data` includes every given non-empty message field
	// except the Field Separator (MSH-1) field. As a result, the parsed MSH
	// segment starts with the MSH-2 field and the field numbers are off-by-one
	// with respect to the HL7 standard.
	//   "V2" - The `parsed_data` includes every given non-empty message field.
	//   "V3" - This version is the same as V2, with the following change. The
	// `parsed_data` contains unescaped escaped field separators, component
	// separators, sub-component separators, repetition separators, escape
	// characters, and truncation characters. If `schema` is specified, the
	// schematized parser uses improved parsing heuristics compared to previous
	// versions.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowNullHeader") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowNullHeader") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ParserConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ParserConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatientId: A patient identifier and associated type.
type PatientId struct {
	// Type: ID type. For example, MRN or NHS.
	Type string `json:"type,omitempty"`
	// Value: The patient's unique identifier.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatientId) MarshalJSON() ([]byte, error) {
	type NoMethod PatientId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatientScope: Apply consents given by a list of patients.
type PatientScope struct {
	// PatientIds: Optional. The list of patient IDs whose Consent resources will
	// be enforced. At most 10,000 patients can be specified. An empty list is
	// equivalent to all patients (meaning the entire FHIR store).
	PatientIds []string `json:"patientIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PatientIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PatientIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatientScope) MarshalJSON() ([]byte, error) {
	type NoMethod PatientScope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProgressCounter: ProgressCounter provides counters to describe an
// operation's progress.
type ProgressCounter struct {
	// Failure: The number of units that failed in the operation.
	Failure int64 `json:"failure,omitempty,string"`
	// Pending: The number of units that are pending in the operation.
	Pending int64 `json:"pending,omitempty,string"`
	// Success: The number of units that succeeded in the operation.
	Success int64 `json:"success,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Failure") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Failure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProgressCounter) MarshalJSON() ([]byte, error) {
	type NoMethod ProgressCounter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PubsubDestination: The Pub/Sub output destination. The Cloud Healthcare
// Service Agent requires the `roles/pubsub.publisher` Cloud IAM role on the
// Pub/Sub topic.
type PubsubDestination struct {
	// PubsubTopic: The Pub/Sub (https://cloud.google.com/pubsub/docs/) topic that
	// Pub/Sub messages are published on. Supplied by the client. The
	// `PubsubMessage` contains the following fields: * `PubsubMessage.Data`
	// contains the resource name. * `PubsubMessage.MessageId` is the ID of this
	// notification. It is guaranteed to be unique within the topic. *
	// `PubsubMessage.PublishTime` is the time when the message was published.
	// Topic names (https://cloud.google.com/pubsub/docs/overview#names) must be
	// scoped to a project. The Cloud Healthcare API service account,
	// service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com, must have
	// publisher permissions on the given Pub/Sub topic. Not having adequate
	// permissions causes the calls that send notifications to fail.
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PubsubTopic") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PubsubTopic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PubsubDestination) MarshalJSON() ([]byte, error) {
	type NoMethod PubsubDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryAccessibleDataRequest: Queries all data_ids that are consented for a
// given use in the given consent store and writes them to a specified
// destination. The returned Operation includes a progress counter for the
// number of User data mappings processed. Errors are logged to Cloud Logging
// (see [Viewing error logs in Cloud Logging]
// (https://cloud.google.com/healthcare/docs/how-tos/logging) and
// [QueryAccessibleData] for a sample log entry).
type QueryAccessibleDataRequest struct {
	// GcsDestination: The Cloud Storage destination. The Cloud Healthcare API
	// service account must have the `roles/storage.objectAdmin` Cloud IAM role for
	// this Cloud Storage location.
	GcsDestination *GoogleCloudHealthcareV1ConsentGcsDestination `json:"gcsDestination,omitempty"`
	// RequestAttributes: The values of request attributes associated with this
	// access request.
	RequestAttributes map[string]string `json:"requestAttributes,omitempty"`
	// ResourceAttributes: Optional. The values of resource attributes associated
	// with the type of resources being requested. If no values are specified, then
	// all resource types are included in the output.
	ResourceAttributes map[string]string `json:"resourceAttributes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryAccessibleDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod QueryAccessibleDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryAccessibleDataResponse: Response for successful QueryAccessibleData
// operations. This structure is included in the response upon operation
// completion.
type QueryAccessibleDataResponse struct {
	// GcsUris: List of files, each of which contains a list of data_id(s) that are
	// consented for a specified use in the request.
	GcsUris []string `json:"gcsUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUris") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryAccessibleDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod QueryAccessibleDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RedactConfig: Define how to redact sensitive values. Default behaviour is
// erase. For example, "My name is Jane." becomes "My name is ."
type RedactConfig struct {
}

// RejectConsentRequest: Rejects the latest revision of the specified Consent
// by committing a new revision with `state` updated to `REJECTED`. If the
// latest revision of the given Consent is in the `REJECTED` state, no new
// revision is committed.
type RejectConsentRequest struct {
	// ConsentArtifact: Optional. The resource name of the Consent artifact that
	// contains documentation of the user's rejection of the draft Consent, of the
	// form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`. If the
	// draft Consent had a Consent artifact, this Consent artifact overwrites it.
	ConsentArtifact string `json:"consentArtifact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifact") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RejectConsentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RejectConsentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReplaceWithInfoTypeConfig: When using the INSPECT_AND_TRANSFORM action, each
// match is replaced with the name of the info_type. For example, "My name is
// Jane" becomes "My name is [PERSON_NAME]." The TRANSFORM action is equivalent
// to redacting.
type ReplaceWithInfoTypeConfig struct {
}

// Resources: A list of FHIR resources.
type Resources struct {
	// Resources: List of resources IDs. For example, "Patient/1234".
	Resources []string `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Resources) MarshalJSON() ([]byte, error) {
	type NoMethod Resources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Result: The consent evaluation result for a single `data_id`.
type Result struct {
	// ConsentDetails: The resource names of all evaluated Consents mapped to their
	// evaluation.
	ConsentDetails map[string]ConsentEvaluation `json:"consentDetails,omitempty"`
	// Consented: Whether the resource is consented for the given use.
	Consented bool `json:"consented,omitempty"`
	// DataId: The unique identifier of the evaluated resource.
	DataId string `json:"dataId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Result) MarshalJSON() ([]byte, error) {
	type NoMethod Result
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RevokeConsentRequest: Revokes the latest revision of the specified Consent
// by committing a new revision with `state` updated to `REVOKED`. If the
// latest revision of the given Consent is in the `REVOKED` state, no new
// revision is committed.
type RevokeConsentRequest struct {
	// ConsentArtifact: Optional. The resource name of the Consent artifact that
	// contains proof of the user's revocation of the Consent, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`.
	ConsentArtifact string `json:"consentArtifact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsentArtifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsentArtifact") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RevokeConsentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RevokeConsentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RollbackFhirResourceFilteringFields struct {
	// MetadataFilter: Optional. A filter expression that matches data in the
	// `Resource.meta` element. Supports all filters in AIP-160
	// (https://google.aip.dev/160) except the "has" (`:`) operator. Supports the
	// following custom functions: * `tag("") = "" for tag filtering. *
	// `extension_value_ts("") = ` for filtering extensions with a timestamp, where
	// `` is a Unix timestamp. Supports the `>`, `<`, `<=`, `>=`, and `!=`
	// comparison operators.
	MetadataFilter string `json:"metadataFilter,omitempty"`
	// OperationIds: Optional. A list of operation IDs to roll back.
	OperationIds googleapi.Uint64s `json:"operationIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetadataFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataFilter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackFhirResourceFilteringFields) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackFhirResourceFilteringFields
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RollbackFhirResourcesRequest struct {
	// ChangeType: Optional. CREATE/UPDATE/DELETE/ALL for reverting all txns of a
	// certain type.
	//
	// Possible values:
	//   "CHANGE_TYPE_UNSPECIFIED" - When unspecified, revert all transactions
	//   "ALL" - All transactions
	//   "CREATE" - Revert only CREATE transactions
	//   "UPDATE" - Revert only Update transactions
	//   "DELETE" - Revert only Delete transactions
	ChangeType string `json:"changeType,omitempty"`
	// ExcludeRollbacks: Optional. Specifies whether to exclude earlier rollbacks.
	ExcludeRollbacks bool `json:"excludeRollbacks,omitempty"`
	// FilteringFields: Optional. Parameters for filtering resources
	FilteringFields *RollbackFhirResourceFilteringFields `json:"filteringFields,omitempty"`
	// Force: Optional. When enabled, changes will be reverted without explicit
	// confirmation
	Force bool `json:"force,omitempty"`
	// InputGcsObject: Optional. Cloud Storage object containing list of
	// {resourceType}/{resourceId} lines, identifying resources to be reverted
	InputGcsObject string `json:"inputGcsObject,omitempty"`
	// ResultGcsBucket: Required. Bucket to deposit result
	ResultGcsBucket string `json:"resultGcsBucket,omitempty"`
	// RollbackTime: Required. Time point to rollback to.
	RollbackTime string `json:"rollbackTime,omitempty"`
	// Type: Optional. If specified, revert only resources of these types
	Type []string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackFhirResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackFhirResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackFhirResourcesResponse: Final response of rollback FIHR resources
// request.
type RollbackFhirResourcesResponse struct {
	// FhirStore: The name of the FHIR store to rollback, in the format of
	// "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}
	// /fhirStores/{fhir_store_id}".
	FhirStore string `json:"fhirStore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FhirStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FhirStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackFhirResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackFhirResourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackHL7MessagesFilteringFields: Filtering fields for an HL7v2 rollback.
// Currently only supports a list of operation ids to roll back.
type RollbackHL7MessagesFilteringFields struct {
	// OperationIds: Optional. A list of operation IDs to roll back.
	OperationIds googleapi.Uint64s `json:"operationIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackHL7MessagesFilteringFields) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackHL7MessagesFilteringFields
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackHl7V2MessagesRequest: Point in time recovery rollback request.
type RollbackHl7V2MessagesRequest struct {
	// ChangeType: Optional. CREATE/UPDATE/DELETE/ALL for reverting all txns of a
	// certain type.
	//
	// Possible values:
	//   "CHANGE_TYPE_UNSPECIFIED" - When unspecified, revert all transactions
	//   "ALL" - All transactions
	//   "CREATE" - Revert only CREATE transactions
	//   "UPDATE" - Revert only Update transactions
	//   "DELETE" - Revert only Delete transactions
	ChangeType string `json:"changeType,omitempty"`
	// ExcludeRollbacks: Optional. Specifies whether to exclude earlier rollbacks.
	ExcludeRollbacks bool `json:"excludeRollbacks,omitempty"`
	// FilteringFields: Optional. Parameters for filtering.
	FilteringFields *RollbackHL7MessagesFilteringFields `json:"filteringFields,omitempty"`
	// Force: Optional. When enabled, changes will be reverted without explicit
	// confirmation.
	Force bool `json:"force,omitempty"`
	// InputGcsObject: Optional. Cloud storage object containing list of
	// {resourceId} lines, identifying resources to be reverted
	InputGcsObject string `json:"inputGcsObject,omitempty"`
	// ResultGcsBucket: Required. Bucket to deposit result
	ResultGcsBucket string `json:"resultGcsBucket,omitempty"`
	// RollbackTime: Required. Times point to rollback to.
	RollbackTime string `json:"rollbackTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChangeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChangeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackHl7V2MessagesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackHl7V2MessagesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackHl7V2MessagesResponse: Final response of rollback HL7v2 messages
// request.
type RollbackHl7V2MessagesResponse struct {
	// Hl7v2Store: The name of the HL7v2 store to rollback, in the format of
	// "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}
	// /hl7v2Stores/{hl7v2_store_id}".
	Hl7v2Store string `json:"hl7v2Store,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hl7v2Store") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hl7v2Store") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackHl7V2MessagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackHl7V2MessagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaConfig: Configuration for the FHIR BigQuery schema. Determines how the
// server generates the schema.
type SchemaConfig struct {
	// LastUpdatedPartitionConfig: The configuration for exported BigQuery tables
	// to be partitioned by FHIR resource's last updated time column.
	LastUpdatedPartitionConfig *TimePartitioning `json:"lastUpdatedPartitionConfig,omitempty"`
	// RecursiveStructureDepth: The depth for all recursive structures in the
	// output analytics schema. For example, `concept` in the CodeSystem resource
	// is a recursive structure; when the depth is 2, the CodeSystem table will
	// have a column called `concept.concept` but not `concept.concept.concept`. If
	// not specified or set to 0, the server will use the default value 2. The
	// maximum depth allowed is 5.
	RecursiveStructureDepth int64 `json:"recursiveStructureDepth,omitempty,string"`
	// SchemaType: Specifies the output schema type. Schema type is required.
	//
	// Possible values:
	//   "SCHEMA_TYPE_UNSPECIFIED" - No schema type specified. This type is
	// unsupported.
	//   "ANALYTICS" - Analytics schema defined by the FHIR community. See
	// https://github.com/FHIR/sql-on-fhir/blob/master/sql-on-fhir.md. BigQuery
	// only allows a maximum of 10,000 columns per table. Due to this limitation,
	// the server will not generate schemas for fields of type `Resource`, which
	// can hold any resource type. The affected fields are
	// `Parameters.parameter.resource`, `Bundle.entry.resource`, and
	// `Bundle.entry.response.outcome`. Analytics schema does not gracefully handle
	// extensions with one or more occurrences, anaytics schema also does not
	// handle contained resource. Additionally, extensions with a URL ending in
	// "/{existing_resource_field_name}" may cause undefined behavior.
	//   "ANALYTICS_V2" - Analytics V2, similar to schema defined by the FHIR
	// community, with added support for extensions with one or more occurrences
	// and contained resources in stringified JSON. Extensions with a URL ending in
	// "/{existing_resource_field_name}" will cause conflict and prevent the
	// resource from being sent to BigQuery. Analytics V2 uses more space in the
	// destination table than Analytics V1. It is generally recommended to use
	// Analytics V2 over Analytics.
	SchemaType string `json:"schemaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastUpdatedPartitionConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastUpdatedPartitionConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaGroup: An HL7v2 logical group construct.
type SchemaGroup struct {
	// Choice: True indicates that this is a choice group, meaning that only one of
	// its segments can exist in a given message.
	Choice bool `json:"choice,omitempty"`
	// MaxOccurs: The maximum number of times this group can be repeated. 0 or -1
	// means unbounded.
	MaxOccurs int64 `json:"maxOccurs,omitempty"`
	// Members: Nested groups and/or segments.
	Members []*GroupOrSegment `json:"members,omitempty"`
	// MinOccurs: The minimum number of times this group must be present/repeated.
	MinOccurs int64 `json:"minOccurs,omitempty"`
	// Name: The name of this group. For example, "ORDER_DETAIL".
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Choice") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Choice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaGroup) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaPackage: A schema package contains a set of schemas and type
// definitions.
type SchemaPackage struct {
	// IgnoreMinOccurs: Optional. Flag to ignore all min_occurs restrictions in the
	// schema. This means that incoming messages can omit any group, segment,
	// field, component, or subcomponent.
	IgnoreMinOccurs bool `json:"ignoreMinOccurs,omitempty"`
	// Schemas: Optional. Schema configs that are layered based on their
	// VersionSources that match the incoming message. Schema configs present in
	// higher indices override those in lower indices with the same message type
	// and trigger event if their VersionSources all match an incoming message.
	Schemas []*Hl7SchemaConfig `json:"schemas,omitempty"`
	// SchematizedParsingType: Optional. Determines how messages that fail to parse
	// are handled.
	//
	// Possible values:
	//   "SCHEMATIZED_PARSING_TYPE_UNSPECIFIED" - Unspecified schematized parsing
	// type, equivalent to `SOFT_FAIL`.
	//   "SOFT_FAIL" - Messages that fail to parse are still stored and ACKed but a
	// parser error is stored in place of the schematized data.
	//   "HARD_FAIL" - Messages that fail to parse are rejected from
	// ingestion/insertion and return an error code.
	SchematizedParsingType string `json:"schematizedParsingType,omitempty"`
	// Types: Optional. Schema type definitions that are layered based on their
	// VersionSources that match the incoming message. Type definitions present in
	// higher indices override those in lower indices with the same type name if
	// their VersionSources all match an incoming message.
	Types []*Hl7TypesConfig `json:"types,omitempty"`
	// UnexpectedSegmentHandling: Optional. Determines how unexpected segments
	// (segments not matched to the schema) are handled.
	//
	// Possible values:
	//   "UNEXPECTED_SEGMENT_HANDLING_MODE_UNSPECIFIED" - Unspecified handling
	// mode, equivalent to FAIL.
	//   "FAIL" - Unexpected segments fail to parse and return an error.
	//   "SKIP" - Unexpected segments do not fail, but are omitted from the output.
	//   "PARSE" - Unexpected segments do not fail, but are parsed in place and
	// added to the current group. If a segment has a type definition, it is used,
	// otherwise it is parsed as VARIES.
	UnexpectedSegmentHandling string `json:"unexpectedSegmentHandling,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreMinOccurs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreMinOccurs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaPackage) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaSegment: An HL7v2 Segment.
type SchemaSegment struct {
	// MaxOccurs: The maximum number of times this segment can be present in this
	// group. 0 or -1 means unbounded.
	MaxOccurs int64 `json:"maxOccurs,omitempty"`
	// MinOccurs: The minimum number of times this segment can be present in this
	// group.
	MinOccurs int64 `json:"minOccurs,omitempty"`
	// Type: The Segment type. For example, "PID".
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxOccurs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxOccurs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaSegment) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchematizedData: The content of an HL7v2 message in a structured format as
// specified by a schema.
type SchematizedData struct {
	// Data: JSON output of the parser.
	Data string `json:"data,omitempty"`
	// Error: The error output of the parser.
	Error string `json:"error,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchematizedData) MarshalJSON() ([]byte, error) {
	type NoMethod SchematizedData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchResourcesRequest: Request to search the resources in the specified
// FHIR store.
type SearchResourcesRequest struct {
	// ResourceType: Optional. The FHIR resource type to search, such as Patient or
	// Observation. For a complete list, see the FHIR Resource Index (DSTU2
	// (https://hl7.org/fhir/DSTU2/resourcelist.html), STU3
	// (https://hl7.org/fhir/STU3/resourcelist.html), R4
	// (https://hl7.org/fhir/R4/resourcelist.html)), R5
	// (https://hl7.org/fhir/R5/resourcelist.html)).
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SearchResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Segment: A segment in a structured format.
type Segment struct {
	// Fields: A mapping from the positional location to the value. The key string
	// uses zero-based indexes separated by dots to identify Fields, components and
	// sub-components. A bracket notation is also used to identify different
	// instances of a repeated field. Regex for key: (\d+)(\[\d+\])?(.\d+)?(.\d+)?
	// Examples of (key, value) pairs: * (0.1, "hemoglobin") denotes that the first
	// component of Field 0 has the value "hemoglobin". * (1.1.2, "CBC") denotes
	// that the second sub-component of the first component of Field 1 has the
	// value "CBC". * (1[0].1, "HbA1c") denotes that the first component of the
	// first Instance of Field 1, which is repeated, has the value "HbA1c".
	Fields map[string]string `json:"fields,omitempty"`
	// SegmentId: A string that indicates the type of segment. For example, EVN or
	// PID.
	SegmentId string `json:"segmentId,omitempty"`
	// SetId: Set ID for segments that can be in a set. This can be empty if it's
	// missing or isn't applicable.
	SetId string `json:"setId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Segment) MarshalJSON() ([]byte, error) {
	type NoMethod Segment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SeriesMetrics: SeriesMetrics contains metrics describing a DICOM series.
type SeriesMetrics struct {
	// BlobStorageSizeBytes: Total blob storage bytes for all instances in the
	// series.
	BlobStorageSizeBytes int64 `json:"blobStorageSizeBytes,omitempty,string"`
	// InstanceCount: Number of instances in the series.
	InstanceCount int64 `json:"instanceCount,omitempty,string"`
	// Series: The series resource path. For example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}/dicomWeb/studies/{study_uid}/series/{series_uid}`.
	Series string `json:"series,omitempty"`
	// StructuredStorageSizeBytes: Total structured storage bytes for all instances
	// in the series.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSizeBytes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SeriesMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod SeriesMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetBlobStorageSettingsRequest: Request message for `SetBlobStorageSettings`
// method.
type SetBlobStorageSettingsRequest struct {
	// BlobStorageSettings: The blob storage settings to update for the specified
	// resources. Only fields listed in `update_mask` are applied.
	BlobStorageSettings *BlobStorageSettings `json:"blobStorageSettings,omitempty"`
	// FilterConfig: Optional. A filter configuration. If `filter_config` is
	// specified, set the value of `resource` to the resource name of a DICOM store
	// in the format
	// `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStores
	// /{dicomStoreID}`.
	FilterConfig *DicomFilterConfig `json:"filterConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetBlobStorageSettingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetBlobStorageSettingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetBlobStorageSettingsResponse: Returns additional info in regards to a
// completed set blob storage settings API.
type SetBlobStorageSettingsResponse struct {
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Signature: User signature.
type Signature struct {
	// Image: Optional. An image of the user's signature.
	Image *Image `json:"image,omitempty"`
	// Metadata: Optional. Metadata associated with the user's signature. For
	// example, the user's name or the user's title.
	Metadata map[string]string `json:"metadata,omitempty"`
	// SignatureTime: Optional. Timestamp of the signature.
	SignatureTime string `json:"signatureTime,omitempty"`
	// UserId: Required. User's UUID provided by the client.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Image") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Signature) MarshalJSON() ([]byte, error) {
	type NoMethod Signature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StorageInfo: StorageInfo encapsulates all the storage info of a resource.
type StorageInfo struct {
	// BlobStorageInfo: Info about the data stored in blob storage for the
	// resource.
	BlobStorageInfo *BlobStorageInfo `json:"blobStorageInfo,omitempty"`
	// ReferencedResource: The resource whose storage info is returned. For
	// example:
	// `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStores
	// /{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/instances/{ins
	// tanceUID}`
	ReferencedResource string `json:"referencedResource,omitempty"`
	// StructuredStorageInfo: Info about the data stored in structured storage for
	// the resource.
	StructuredStorageInfo *StructuredStorageInfo `json:"structuredStorageInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StorageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod StorageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StreamConfig: Contains configuration for streaming FHIR export.
type StreamConfig struct {
	// BigqueryDestination: Optional. The destination BigQuery structure that
	// contains both the dataset location and corresponding schema config. The
	// output is organized in one table per resource type. The server reuses the
	// existing tables (if any) that are named after the resource types. For
	// example, "Patient", "Observation". When there is no existing table for a
	// given resource type, the server attempts to create one. When a table schema
	// doesn't align with the schema config, either because of existing
	// incompatible schema or out of band incompatible modification, the server
	// does not stream in new data. BigQuery imposes a 1 MB limit on streaming
	// insert row size, therefore any resource mutation that generates more than 1
	// MB of BigQuery data is not streamed. One resolution in this case is to
	// delete the incompatible table and let the server recreate one, though the
	// newly created table only contains data after the table recreation. Results
	// are written to BigQuery tables according to the parameters in
	// BigQueryDestination.WriteDisposition. Different versions of the same
	// resource are distinguishable by the meta.versionId and meta.lastUpdated
	// columns. The operation (CREATE/UPDATE/DELETE) that results in the new
	// version is recorded in the meta.tag. The tables contain all historical
	// resource versions since streaming was enabled. For query convenience, the
	// server also creates one view per table of the same name containing only the
	// current resource version. The streamed data in the BigQuery dataset is not
	// guaranteed to be completely unique. The combination of the id and
	// meta.versionId columns should ideally identify a single unique row. But in
	// rare cases, duplicates may exist. At query time, users may use the SQL
	// select statement to keep only one of the duplicate rows given an id and
	// meta.versionId pair. Alternatively, the server created view mentioned above
	// also filters out duplicates. If a resource mutation cannot be streamed to
	// BigQuery, errors are logged to Cloud Logging. For more information, see
	// Viewing error logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
	BigqueryDestination *GoogleCloudHealthcareV1FhirBigQueryDestination `json:"bigqueryDestination,omitempty"`
	// DeidentifiedStoreDestination: The destination FHIR store for de-identified
	// resources. After this field is added, all subsequent creates/updates/patches
	// to the source store will be de-identified using the provided configuration
	// and applied to the destination store. Resources deleted from the source
	// store will be deleted from the destination store. Importing resources to the
	// source store will not trigger the streaming. If the source store already
	// contains resources when this option is enabled, those resources will not be
	// copied to the destination store unless they are subsequently updated. This
	// may result in invalid references in the destination store. Before adding
	// this config, you must grant the healthcare.fhirResources.update permission
	// on the destination store to your project's **Cloud Healthcare Service
	// Agent** service account
	// (https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent).
	// The destination store must set enable_update_create to true. The destination
	// store must have disable_referential_integrity set to true. If a resource
	// cannot be de-identified, errors will be logged to Cloud Logging (see Viewing
	// error logs in Cloud Logging
	// (https://cloud.google.com/healthcare/docs/how-tos/logging)). Not supported
	// for R5 stores.
	DeidentifiedStoreDestination *DeidentifiedStoreDestination `json:"deidentifiedStoreDestination,omitempty"`
	// ResourceTypes: Optional. Supply a FHIR resource type (such as "Patient" or
	// "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html
	// for a list of all FHIR resource types. The server treats an empty list as an
	// intent to stream all the supported resource types in this FHIR store.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StreamConfig) MarshalJSON() ([]byte, error) {
	type NoMethod StreamConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StructuredStorageInfo: StructuredStorageInfo contains details about the data
// stored in Structured Storage for the referenced resource.
type StructuredStorageInfo struct {
	// SizeBytes: Size in bytes of data stored in structured storage.
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "SizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SizeBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StructuredStorageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod StructuredStorageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StudyMetrics: StudyMetrics contains metrics describing a DICOM study.
type StudyMetrics struct {
	// BlobStorageSizeBytes: Total blob storage bytes for all instances in the
	// study.
	BlobStorageSizeBytes int64 `json:"blobStorageSizeBytes,omitempty,string"`
	// InstanceCount: Number of instances in the study.
	InstanceCount int64 `json:"instanceCount,omitempty,string"`
	// SeriesCount: Number of series in the study.
	SeriesCount int64 `json:"seriesCount,omitempty,string"`
	// StructuredStorageSizeBytes: Total structured storage bytes for all instances
	// in the study.
	StructuredStorageSizeBytes int64 `json:"structuredStorageSizeBytes,omitempty,string"`
	// Study: The study resource path. For example,
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomSto
	// res/{dicom_store_id}/dicomWeb/studies/{study_uid}`.
	Study string `json:"study,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlobStorageSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobStorageSizeBytes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StudyMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod StudyMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TagFilterList: List of tags to be filtered.
type TagFilterList struct {
	// Tags: Optional. Tags to be filtered. Tags must be DICOM Data Elements, File
	// Meta Elements, or Directory Structuring Elements, as defined at:
	// http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,.
	// They may be provided by "Keyword" or "Tag". For example "PatientID",
	// "00100010".
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tags") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tags") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TagFilterList) MarshalJSON() ([]byte, error) {
	type NoMethod TagFilterList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TextConfig struct {
	// AdditionalTransformations: Optional. Transformations to apply to the
	// detected data, overridden by `exclude_info_types`.
	AdditionalTransformations []*InfoTypeTransformation `json:"additionalTransformations,omitempty"`
	// ExcludeInfoTypes: Optional. InfoTypes to skip transforming, overriding
	// `additional_transformations`.
	ExcludeInfoTypes []string `json:"excludeInfoTypes,omitempty"`
	// Transformations: Optional. The transformations to apply to the detected
	// data. Deprecated. Use `additional_transformations` instead.
	Transformations []*InfoTypeTransformation `json:"transformations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalTransformations")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalTransformations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextConfig) MarshalJSON() ([]byte, error) {
	type NoMethod TextConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextSpan: A span of text in the provided document.
type TextSpan struct {
	// BeginOffset: The unicode codepoint index of the beginning of this span.
	BeginOffset int64 `json:"beginOffset,omitempty"`
	// Content: The original text contained in this span.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BeginOffset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BeginOffset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextSpan) MarshalJSON() ([]byte, error) {
	type NoMethod TextSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimePartitioning: Configuration for FHIR BigQuery time-partitioned tables.
type TimePartitioning struct {
	// ExpirationMs: Number of milliseconds for which to keep the storage for a
	// partition.
	ExpirationMs int64 `json:"expirationMs,omitempty,string"`
	// Type: Type of partitioning.
	//
	// Possible values:
	//   "PARTITION_TYPE_UNSPECIFIED" - Default unknown time.
	//   "HOUR" - Data partitioned by hour.
	//   "DAY" - Data partitioned by day.
	//   "MONTH" - Data partitioned by month.
	//   "YEAR" - Data partitioned by year.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpirationMs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpirationMs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimePartitioning) MarshalJSON() ([]byte, error) {
	type NoMethod TimePartitioning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeRange: Apply consents given by patients whose most recent consent
// changes are in the time range. Note that after identifying these patients,
// the server applies all Consent resources given by those patients, not just
// the Consent resources within the timestamp in the range.
type TimeRange struct {
	// End: Optional. The latest consent change time, in format
	// YYYY-MM-DDThh:mm:ss.sss+zz:zz If not specified, the system uses the time
	// when ApplyConsents was called.
	End string `json:"end,omitempty"`
	// Start: Optional. The earliest consent change time, in format
	// YYYY-MM-DDThh:mm:ss.sss+zz:zz If not specified, the system uses the FHIR
	// store creation time.
	Start string `json:"start,omitempty"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod TimeRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Type: A type definition for some HL7v2 type (incl. Segments and Datatypes).
type Type struct {
	// Fields: The (sub) fields this type has (if not primitive).
	Fields []*Field `json:"fields,omitempty"`
	// Name: The name of this type. This would be the segment or datatype name. For
	// example, "PID" or "XPN".
	Name string `json:"name,omitempty"`
	// Primitive: If this is a primitive type then this field is the type of the
	// primitive For example, STRING. Leave unspecified for composite types.
	//
	// Possible values:
	//   "PRIMITIVE_UNSPECIFIED" - Not a primitive.
	//   "STRING" - String primitive.
	//   "VARIES" - Element that can have unschematized children.
	//   "UNESCAPED_STRING" - Like STRING, but all delimiters below this element
	// are ignored.
	Primitive string `json:"primitive,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Type) MarshalJSON() ([]byte, error) {
	type NoMethod Type
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserDataMapping: Maps a resource to the associated user and Attributes.
type UserDataMapping struct {
	// ArchiveTime: Output only. Indicates the time when this mapping was archived.
	ArchiveTime string `json:"archiveTime,omitempty"`
	// Archived: Output only. Indicates whether this mapping is archived.
	Archived bool `json:"archived,omitempty"`
	// DataId: Required. A unique identifier for the mapped resource.
	DataId string `json:"dataId,omitempty"`
	// Name: Resource name of the User data mapping, of the form
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
	// tores/{consent_store_id}/userDataMappings/{user_data_mapping_id}`.
	Name string `json:"name,omitempty"`
	// ResourceAttributes: Attributes of the resource. Only explicitly set
	// attributes are displayed here. Attribute definitions with defaults set
	// implicitly apply to these User data mappings. Attributes listed here must be
	// single valued, that is, exactly one value is specified for the field
	// "values" in each Attribute.
	ResourceAttributes []*Attribute `json:"resourceAttributes,omitempty"`
	// UserId: Required. User's UUID provided by the client.
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ArchiveTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserDataMapping) MarshalJSON() ([]byte, error) {
	type NoMethod UserDataMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidationConfig: Contains the configuration for FHIR profiles and
// validation.
type ValidationConfig struct {
	// DisableFhirpathValidation: Optional. Whether to disable FHIRPath validation
	// for incoming resources. The default value is false. Set this to true to
	// disable checking incoming resources for conformance against FHIRPath
	// requirement defined in the FHIR specification. This property only affects
	// resource types that do not have profiles configured for them, any rules in
	// enabled implementation guides will still be enforced.
	DisableFhirpathValidation bool `json:"disableFhirpathValidation,omitempty"`
	// DisableProfileValidation: Optional. Whether to disable profile validation
	// for this FHIR store. The default value is false. Set this to true to disable
	// checking incoming resources for conformance against structure definitions in
	// this FHIR store.
	DisableProfileValidation bool `json:"disableProfileValidation,omitempty"`
	// DisableReferenceTypeValidation: Optional. Whether to disable reference type
	// validation for incoming resources. The default value is false. Set this to
	// true to disable checking incoming resources for conformance against
	// reference type requirement defined in the FHIR specification. This property
	// only affects resource types that do not have profiles configured for them,
	// any rules in enabled implementation guides will still be enforced.
	DisableReferenceTypeValidation bool `json:"disableReferenceTypeValidation,omitempty"`
	// DisableRequiredFieldValidation: Optional. Whether to disable required fields
	// validation for incoming resources. The default value is false. Set this to
	// true to disable checking incoming resources for conformance against required
	// fields requirement defined in the FHIR specification. This property only
	// affects resource types that do not have profiles configured for them, any
	// rules in enabled implementation guides will still be enforced.
	DisableRequiredFieldValidation bool `json:"disableRequiredFieldValidation,omitempty"`
	// EnabledImplementationGuides: Optional. A list of implementation guide URLs
	// in this FHIR store that are used to configure the profiles to use for
	// validation. For example, to use the US Core profiles for validation, set
	// `enabled_implementation_guides` to
	// `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If
	// `enabled_implementation_guides` is empty or omitted, then incoming resources
	// are only required to conform to the base FHIR profiles. Otherwise, a
	// resource must conform to at least one profile listed in the `global`
	// property of one of the enabled ImplementationGuides. The Cloud Healthcare
	// API does not currently enforce all of the rules in a StructureDefinition.
	// The following rules are supported: - min/max - minValue/maxValue - maxLength
	// - type - fixed[x] - pattern[x] on simple types - slicing, when using "value"
	// as the discriminator type When a URL cannot be resolved (for example, in a
	// type assertion), the server does not return an error.
	EnabledImplementationGuides []string `json:"enabledImplementationGuides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableFhirpathValidation")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableFhirpathValidation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VersionSource: Describes a selector for extracting and matching an MSH field
// to a value.
type VersionSource struct {
	// MshField: The field to extract from the MSH segment. For example, "3.1" or
	// "18[1].1".
	MshField string `json:"mshField,omitempty"`
	// Value: The value to match with the field. For example, "My Application Name"
	// or "2.3".
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MshField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MshField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VersionSource) MarshalJSON() ([]byte, error) {
	type NoMethod VersionSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": A list
// of extra location types that should be used as conditions for controlling
// the visibility of the locations.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsCreateCall struct {
	s          *Service
	parent     string
	dataset    *Dataset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new health dataset. Results are returned through the
// Operation interface which returns either an `Operation.response` which
// contains a Dataset or `Operation.error`. The metadata field type is
// OperationMetadata.
//
//   - parent: The name of the project where the server creates the dataset. For
//     example, `projects/{project_id}/locations/{location_id}`.
func (r *ProjectsLocationsDatasetsService) Create(parent string, dataset *Dataset) *ProjectsLocationsDatasetsCreateCall {
	c := &ProjectsLocationsDatasetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dataset = dataset
	return c
}

// DatasetId sets the optional parameter "datasetId": Required. The ID of the
// dataset that is being created. The string must match the following regex:
// `[\p{L}\p{N}_\-\.]{1,256}`.
func (c *ProjectsLocationsDatasetsCreateCall) DatasetId(datasetId string) *ProjectsLocationsDatasetsCreateCall {
	c.urlParams_.Set("datasetId", datasetId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDeidentifyCall struct {
	s                        *Service
	sourceDataset            string
	deidentifydatasetrequest *DeidentifyDatasetRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Deidentify: Creates a new dataset containing de-identified data from the
// source dataset. The metadata field type is OperationMetadata. If the request
// is successful, the response field type is DeidentifySummary. If errors
// occur, error is set. The LRO result may still be successful if
// de-identification fails for some DICOM instances. The new de-identified
// dataset will not contain these failed resources. Failed resource totals are
// tracked in Operation.metadata. Error details are also logged to Cloud
// Logging. For more information, see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging).
//
//   - sourceDataset: Source dataset resource name. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`. R5
//     FHIR stores are not supported and will be skipped.
func (r *ProjectsLocationsDatasetsService) Deidentify(sourceDataset string, deidentifydatasetrequest *DeidentifyDatasetRequest) *ProjectsLocationsDatasetsDeidentifyCall {
	c := &ProjectsLocationsDatasetsDeidentifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sourceDataset = sourceDataset
	c.deidentifydatasetrequest = deidentifydatasetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDeidentifyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDeidentifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDeidentifyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDeidentifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDeidentifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDeidentifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.deidentifydatasetrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+sourceDataset}:deidentify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sourceDataset": c.sourceDataset,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.deidentify", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.deidentify" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDeidentifyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.deidentify", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified health dataset and all data contained in the
// dataset. Deleting a dataset does not affect the sources from which the
// dataset was imported (if any).
//
//   - name: The name of the dataset to delete. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
func (r *ProjectsLocationsDatasetsService) Delete(name string) *ProjectsLocationsDatasetsDeleteCall {
	c := &ProjectsLocationsDatasetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets any metadata associated with a dataset.
//
//   - name: The name of the dataset to read. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
func (r *ProjectsLocationsDatasetsService) Get(name string) *ProjectsLocationsDatasetsGetCall {
	c := &ProjectsLocationsDatasetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsGetCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the health datasets in the current project.
//
//   - parent: The name of the project whose datasets should be listed. For
//     example, `projects/{project_id}/locations/{location_id}`.
func (r *ProjectsLocationsDatasetsService) List(parent string) *ProjectsLocationsDatasetsListCall {
	c := &ProjectsLocationsDatasetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. If not specified, 100 is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from a previous List request, if any.
func (c *ProjectsLocationsDatasetsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDatasetsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsListCall) Do(opts ...googleapi.CallOption) (*ListDatasetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDatasetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsListCall) Pages(ctx context.Context, f func(*ListDatasetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsPatchCall struct {
	s          *Service
	name       string
	dataset    *Dataset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates dataset metadata.
//
//   - name: Identifier. Resource name of the dataset, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
func (r *ProjectsLocationsDatasetsService) Patch(name string, dataset *Dataset) *ProjectsLocationsDatasetsPatchCall {
	c := &ProjectsLocationsDatasetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.dataset = dataset
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsLocationsDatasetsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsPatchCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall struct {
	s                      *Service
	consentStore           string
	checkdataaccessrequest *CheckDataAccessRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// CheckDataAccess: Checks if a particular data_id of a User data mapping in
// the specified consent store is consented for the specified use.
//
//   - consentStore: Name of the consent store where the requested data_id is
//     stored, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}`.
func (r *ProjectsLocationsDatasetsConsentStoresService) CheckDataAccess(consentStore string, checkdataaccessrequest *CheckDataAccessRequest) *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall {
	c := &ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.consentStore = consentStore
	c.checkdataaccessrequest = checkdataaccessrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.checkdataaccessrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+consentStore}:checkDataAccess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"consentStore": c.consentStore,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.checkDataAccess", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.checkDataAccess" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckDataAccessResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresCheckDataAccessCall) Do(opts ...googleapi.CallOption) (*CheckDataAccessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckDataAccessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.checkDataAccess", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresCreateCall struct {
	s            *Service
	parent       string
	consentstore *ConsentStore
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new consent store in the parent dataset. Attempting to
// create a consent store with the same ID as an existing store fails with an
// ALREADY_EXISTS error.
//
// - parent: The name of the dataset this consent store belongs to.
func (r *ProjectsLocationsDatasetsConsentStoresService) Create(parent string, consentstore *ConsentStore) *ProjectsLocationsDatasetsConsentStoresCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.consentstore = consentstore
	return c
}

// ConsentStoreId sets the optional parameter "consentStoreId": Required. The
// ID of the consent store to create. The string must match the following
// regex: `[\p{L}\p{N}_\-\.]{1,256}`. Cannot be changed after creation.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) ConsentStoreId(consentStoreId string) *ProjectsLocationsDatasetsConsentStoresCreateCall {
	c.urlParams_.Set("consentStoreId", consentStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.consentstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/consentStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentStore.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresCreateCall) Do(opts ...googleapi.CallOption) (*ConsentStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified consent store and removes all the consent
// store's data.
//
// - name: The resource name of the consent store to delete.
func (r *ProjectsLocationsDatasetsConsentStoresService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall struct {
	s                           *Service
	consentStore                string
	evaluateuserconsentsrequest *EvaluateUserConsentsRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// EvaluateUserConsents: Evaluates the user's Consents for all matching User
// data mappings. Note: User data mappings are indexed asynchronously, which
// can cause a slight delay between the time mappings are created or updated
// and when they are included in EvaluateUserConsents results.
//
//   - consentStore: Name of the consent store to retrieve User data mappings
//     from.
func (r *ProjectsLocationsDatasetsConsentStoresService) EvaluateUserConsents(consentStore string, evaluateuserconsentsrequest *EvaluateUserConsentsRequest) *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall {
	c := &ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.consentStore = consentStore
	c.evaluateuserconsentsrequest = evaluateuserconsentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.evaluateuserconsentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+consentStore}:evaluateUserConsents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"consentStore": c.consentStore,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.evaluateUserConsents", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.evaluateUserConsents" call.
// Any non-2xx status code is an error. Response headers are in either
// *EvaluateUserConsentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Do(opts ...googleapi.CallOption) (*EvaluateUserConsentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EvaluateUserConsentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.evaluateUserConsents", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresEvaluateUserConsentsCall) Pages(ctx context.Context, f func(*EvaluateUserConsentsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.evaluateuserconsentsrequest.PageToken = pt }(c.evaluateuserconsentsrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.evaluateuserconsentsrequest.PageToken = x.NextPageToken
	}
}

type ProjectsLocationsDatasetsConsentStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified consent store.
//
// - name: The resource name of the consent store to get.
func (r *ProjectsLocationsDatasetsConsentStoresService) Get(name string) *ProjectsLocationsDatasetsConsentStoresGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentStore.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresGetCall) Do(opts ...googleapi.CallOption) (*ConsentStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsConsentStoresService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the consent stores in the specified dataset.
//
// - parent: Name of the dataset.
func (r *ProjectsLocationsDatasetsConsentStoresService) List(parent string) *ProjectsLocationsDatasetsConsentStoresListCall {
	c := &ProjectsLocationsDatasetsConsentStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the stores returned
// to those matching a filter. Only filtering on labels is supported. For
// example, `filter=labels.key=value`.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// consent stores to return in a single response. If not specified, 100 is
// used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to retrieve the
// next page of results, or empty to get the first page.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/consentStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConsentStoresResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Do(opts ...googleapi.CallOption) (*ListConsentStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConsentStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresListCall) Pages(ctx context.Context, f func(*ListConsentStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresPatchCall struct {
	s            *Service
	name         string
	consentstore *ConsentStore
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates the specified consent store.
//
//   - name: Identifier. Resource name of the consent store, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}`. Cannot be changed after creation.
func (r *ProjectsLocationsDatasetsConsentStoresService) Patch(name string, consentstore *ConsentStore) *ProjectsLocationsDatasetsConsentStoresPatchCall {
	c := &ProjectsLocationsDatasetsConsentStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.consentstore = consentstore
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask that applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
// Only the `labels`, `default_consent_ttl`, and
// `enable_consent_create_on_update` fields are allowed to be updated.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsConsentStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.consentstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentStore.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresPatchCall) Do(opts ...googleapi.CallOption) (*ConsentStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall struct {
	s                          *Service
	consentStore               string
	queryaccessibledatarequest *QueryAccessibleDataRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// QueryAccessibleData: Queries all data_ids that are consented for a specified
// use in the given consent store and writes them to a specified destination.
// The returned Operation includes a progress counter for the number of User
// data mappings processed. If the request is successful, a detailed response
// is returned of type QueryAccessibleDataResponse, contained in the response
// field when the operation finishes. The metadata field type is
// OperationMetadata. Errors are logged to Cloud Logging (see Viewing error
// logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging)). For example,
// the following sample log entry shows a `failed to evaluate consent policy`
// error that occurred during a QueryAccessibleData call to consent store
// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
// tores/{consent_store_id}`. ```json jsonPayload: { @type:
// "type.googleapis.com/google.cloud.healthcare.logging.QueryAccessibleDataLogEn
// try" error: { code: 9 message: "failed to evaluate consent policy" }
// resourceName:
// "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentS
// tores/{consent_store_id}/consents/{consent_id}" } logName:
// "projects/{project_id}/logs/healthcare.googleapis.com%2Fquery_accessible_data
// " operation: { id:
// "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/operatio
// ns/{operation_id}" producer: "healthcare.googleapis.com/QueryAccessibleData"
// } receiveTimestamp: "TIMESTAMP" resource: { labels: { consent_store_id:
// "{consent_store_id}" dataset_id: "{dataset_id}" location: "{location_id}"
// project_id: "{project_id}" } type: "healthcare_consent_store" } severity:
// "ERROR" timestamp: "TIMESTAMP" ```
//
//   - consentStore: Name of the consent store to retrieve User data mappings
//     from.
func (r *ProjectsLocationsDatasetsConsentStoresService) QueryAccessibleData(consentStore string, queryaccessibledatarequest *QueryAccessibleDataRequest) *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall {
	c := &ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.consentStore = consentStore
	c.queryaccessibledatarequest = queryaccessibledatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.queryaccessibledatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+consentStore}:queryAccessibleData")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"consentStore": c.consentStore,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.queryAccessibleData", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.queryAccessibleData" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresQueryAccessibleDataCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.queryAccessibleData", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsConsentStoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsConsentStoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall struct {
	s                   *Service
	parent              string
	attributedefinition *AttributeDefinition
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a new Attribute definition in the parent consent store.
//
//   - parent: The name of the consent store that this Attribute definition
//     belongs to.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) Create(parent string, attributedefinition *AttributeDefinition) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.attributedefinition = attributedefinition
	return c
}

// AttributeDefinitionId sets the optional parameter "attributeDefinitionId":
// Required. The ID of the Attribute definition to create. The string must
// match the following regex: `_a-zA-Z{0,255}` and must not be a reserved
// keyword within the Common Expression Language as listed on
// https://github.com/google/cel-spec/blob/master/doc/langdef.md.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) AttributeDefinitionId(attributeDefinitionId string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall {
	c.urlParams_.Set("attributeDefinitionId", attributeDefinitionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.attributedefinition)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attributeDefinitions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AttributeDefinition.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateCall) Do(opts ...googleapi.CallOption) (*AttributeDefinition, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AttributeDefinition{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified Attribute definition. Fails if the Attribute
// definition is referenced by any User data mapping, or the latest revision of
// any Consent.
//
//   - name: The resource name of the Attribute definition to delete. To preserve
//     referential integrity, Attribute definitions referenced by a User data
//     mapping or the latest revision of a Consent cannot be deleted.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified Attribute definition.
//
// - name: The resource name of the Attribute definition to get.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) Get(name string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AttributeDefinition.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetCall) Do(opts ...googleapi.CallOption) (*AttributeDefinition, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AttributeDefinition{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Attribute definitions in the specified consent store.
//
// - parent: Name of the consent store to retrieve Attribute definitions from.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) List(parent string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the attributes
// returned to those matching a filter. The only field available for filtering
// is `category`. For example, `filter=category=\"REQUEST\".
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// Attribute definitions to return in a single response. If not specified, 100
// is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to retrieve the
// next page of results or empty to get the first page.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attributeDefinitions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAttributeDefinitionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Do(opts ...googleapi.CallOption) (*ListAttributeDefinitionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAttributeDefinitionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListCall) Pages(ctx context.Context, f func(*ListAttributeDefinitionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall struct {
	s                   *Service
	name                string
	attributedefinition *AttributeDefinition
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Patch: Updates the specified Attribute definition.
//
//   - name: Identifier. Resource name of the Attribute definition, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/attributeDefinitions/{attribute_definition_id}`.
//     Cannot be changed after creation.
func (r *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService) Patch(name string, attributedefinition *AttributeDefinition) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall {
	c := &ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.attributedefinition = attributedefinition
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask that applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
// Only the `description`, `allowed_values`, `consent_default_values` and
// `data_mapping_default_value` fields can be updated. The updated
// `allowed_values` must contain all values from the previous `allowed_values`.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.attributedefinition)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *AttributeDefinition.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchCall) Do(opts ...googleapi.CallOption) (*AttributeDefinition, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AttributeDefinition{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.attributeDefinitions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall struct {
	s               *Service
	parent          string
	consentartifact *ConsentArtifact
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new Consent artifact in the parent consent store.
//
// - parent: The name of the consent store this Consent artifact belongs to.
func (r *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService) Create(parent string, consentartifact *ConsentArtifact) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.consentartifact = consentartifact
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.consentartifact)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/consentArtifacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consentArtifacts.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consentArtifacts.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentArtifact.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateCall) Do(opts ...googleapi.CallOption) (*ConsentArtifact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentArtifact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consentArtifacts.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified Consent artifact. Fails if the artifact is
// referenced by the latest revision of any Consent.
//
//   - name: The resource name of the Consent artifact to delete. To preserve
//     referential integrity, Consent artifacts referenced by the latest revision
//     of a Consent cannot be deleted.
func (r *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consentArtifacts.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consentArtifacts.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consentArtifacts.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified Consent artifact.
//
// - name: The resource name of the Consent artifact to retrieve.
func (r *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService) Get(name string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consentArtifacts.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consentArtifacts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConsentArtifact.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsGetCall) Do(opts ...googleapi.CallOption) (*ConsentArtifact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConsentArtifact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consentArtifacts.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Consent artifacts in the specified consent store.
//
// - parent: Name of the consent store to retrieve consent artifacts from.
func (r *ProjectsLocationsDatasetsConsentStoresConsentArtifactsService) List(parent string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the artifacts
// returned to those matching a filter. The following syntax is available: * A
// string field value can be written as text inside quotation marks, for
// example "query text". The only valid relational operation for text fields
// is equality (`=`), where text is searched within the field, rather than
// having the field be equal to the text. For example, "Comment = great"
// returns messages with `great` in the comment field. * A number field value
// can be written as an integer, a decimal, or an exponential. The valid
// relational operators for number fields are the equality operator (`=`),
// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
// that there is no inequality (`!=`) operator. You can prepend the `NOT`
// operator to an expression to negate it. * A date field value must be written
// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// The fields available for filtering are: - user_id. For example,
// `filter=user_id=\"user123\". - consent_content_version - metadata. For
// example, `filter=Metadata(\"testkey\")=\"value\" or
// `filter=HasMetadata(\"testkey\")`.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// consent artifacts to return in a single response. If not specified, 100 is
// used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/consentArtifacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consentArtifacts.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consentArtifacts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConsentArtifactsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Do(opts ...googleapi.CallOption) (*ListConsentArtifactsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConsentArtifactsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consentArtifacts.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentArtifactsListCall) Pages(ctx context.Context, f func(*ListConsentArtifactsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresConsentsActivateCall struct {
	s                      *Service
	name                   string
	activateconsentrequest *ActivateConsentRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Activate: Activates the latest revision of the specified Consent by
// committing a new revision with `state` updated to `ACTIVE`. If the latest
// revision of the specified Consent is in the `ACTIVE` state, no new revision
// is committed. A FAILED_PRECONDITION error occurs if the latest revision of
// the specified Consent is in the `REJECTED` or `REVOKED` state.
//
//   - name: The resource name of the Consent to activate, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. An INVALID_ARGUMENT
//     error occurs if `revision_id` is specified in the name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Activate(name string, activateconsentrequest *ActivateConsentRequest) *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.activateconsentrequest = activateconsentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.activateconsentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.activate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.activate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsActivateCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.activate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsCreateCall struct {
	s          *Service
	parent     string
	consent    *Consent
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Consent in the parent consent store.
//
// - parent: Name of the consent store.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Create(parent string, consent *Consent) *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.consent = consent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.consent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/consents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsCreateCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the Consent and its revisions. To keep a record of the
// Consent but mark it inactive, see [RevokeConsent]. To delete a revision of a
// Consent, see [DeleteConsentRevision]. This operation does not delete the
// related Consent artifact.
//
//   - name: The resource name of the Consent to delete, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. An INVALID_ARGUMENT
//     error occurs if `revision_id` is specified in the name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// DeleteRevision: Deletes the specified revision of a Consent. An
// INVALID_ARGUMENT error occurs if the specified revision is the latest
// revision.
//
//   - name: The resource name of the Consent revision to delete, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}@{revision_id}`. An
//     INVALID_ARGUMENT error occurs if `revision_id` is not specified in the
//     name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) DeleteRevision(name string) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:deleteRevision")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.deleteRevision", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.deleteRevision" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsDeleteRevisionCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.deleteRevision", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified revision of a Consent, or the latest revision if
// `revision_id` is not specified in the resource name.
//
//   - name: The resource name of the Consent to retrieve, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. In order to retrieve a
//     previous revision of the Consent, also provide the revision ID:
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}@{revision_id}`.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Get(name string) *ProjectsLocationsDatasetsConsentStoresConsentsGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsGetCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Consent in the given consent store, returning each Consent's
// latest revision.
//
// - parent: Name of the consent store to retrieve Consents from.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) List(parent string) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the Consents returned
// to those matching a filter. The following syntax is available: * A string
// field value can be written as text inside quotation marks, for example
// "query text". The only valid relational operation for text fields is
// equality (`=`), where text is searched within the field, rather than having
// the field be equal to the text. For example, "Comment = great" returns
// messages with `great` in the comment field. * A number field value can be
// written as an integer, a decimal, or an exponential. The valid relational
// operators for number fields are the equality operator (`=`), along with the
// less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is
// no inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
// `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// The fields available for filtering are: - user_id. For example,
// `filter='user_id="user123"'`. - consent_artifact - state -
// revision_create_time - metadata. For example,
// `filter=Metadata(\"testkey\")=\"value\" or
// `filter=HasMetadata(\"testkey\")`.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// Consents to return in a single response. If not specified, 100 is used. May
// not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/consents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConsentsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Do(opts ...googleapi.CallOption) (*ListConsentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConsentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListCall) Pages(ctx context.Context, f func(*ListConsentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListRevisions: Lists the revisions of the specified Consent in reverse
// chronological order.
//
// - name: The resource name of the Consent to retrieve revisions for.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) ListRevisions(name string) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": Restricts the revisions
// returned to those matching a filter. The following syntax is available: * A
// string field value can be written as text inside quotation marks, for
// example "query text". The only valid relational operation for text fields
// is equality (`=`), where text is searched within the field, rather than
// having the field be equal to the text. For example, "Comment = great"
// returns messages with `great` in the comment field. * A number field value
// can be written as an integer, a decimal, or an exponential. The valid
// relational operators for number fields are the equality operator (`=`),
// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
// that there is no inequality (`!=`) operator. You can prepend the `NOT`
// operator to an expression to negate it. * A date field value must be written
// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// Fields available for filtering are: - user_id. For example,
// `filter='user_id="user123"'`. - consent_artifact - state -
// revision_create_time - metadata. For example,
// `filter=Metadata(\"testkey\")=\"value\" or
// `filter=HasMetadata(\"testkey\")`.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// revisions to return in a single response. If not specified, 100 is used. May
// not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to retrieve the
// next page of results or empty if there are no more results in the list.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:listRevisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.listRevisions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.listRevisions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConsentRevisionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Do(opts ...googleapi.CallOption) (*ListConsentRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConsentRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.listRevisions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsListRevisionsCall) Pages(ctx context.Context, f func(*ListConsentRevisionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresConsentsPatchCall struct {
	s          *Service
	name       string
	consent    *Consent
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the latest revision of the specified Consent by committing a
// new revision with the changes. A FAILED_PRECONDITION error occurs if the
// latest revision of the specified Consent is in the `REJECTED` or `REVOKED`
// state.
//
//   - name: Identifier. Resource name of the Consent, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. Cannot be changed after
//     creation.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Patch(name string, consent *Consent) *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.consent = consent
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask to apply to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
// Only the `user_id`, `policies`, `consent_artifact`, and `metadata` fields
// can be updated.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.consent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsPatchCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsRejectCall struct {
	s                    *Service
	name                 string
	rejectconsentrequest *RejectConsentRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Reject: Rejects the latest revision of the specified Consent by committing a
// new revision with `state` updated to `REJECTED`. If the latest revision of
// the specified Consent is in the `REJECTED` state, no new revision is
// committed. A FAILED_PRECONDITION error occurs if the latest revision of the
// specified Consent is in the `ACTIVE` or `REVOKED` state.
//
//   - name: The resource name of the Consent to reject, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. An INVALID_ARGUMENT
//     error occurs if `revision_id` is specified in the name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Reject(name string, rejectconsentrequest *RejectConsentRequest) *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsRejectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rejectconsentrequest = rejectconsentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rejectconsentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:reject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.reject", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.reject" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRejectCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.reject", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall struct {
	s                    *Service
	name                 string
	revokeconsentrequest *RevokeConsentRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Revoke: Revokes the latest revision of the specified Consent by committing a
// new revision with `state` updated to `REVOKED`. If the latest revision of
// the specified Consent is in the `REVOKED` state, no new revision is
// committed. A FAILED_PRECONDITION error occurs if the latest revision of the
// given consent is in `DRAFT` or `REJECTED` state.
//
//   - name: The resource name of the Consent to revoke, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/consents/{consent_id}`. An INVALID_ARGUMENT
//     error occurs if `revision_id` is specified in the name.
func (r *ProjectsLocationsDatasetsConsentStoresConsentsService) Revoke(name string, revokeconsentrequest *RevokeConsentRequest) *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall {
	c := &ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.revokeconsentrequest = revokeconsentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.revokeconsentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:revoke")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.revoke", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.consents.revoke" call.
// Any non-2xx status code is an error. Response headers are in either
// *Consent.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresConsentsRevokeCall) Do(opts ...googleapi.CallOption) (*Consent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Consent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.consents.revoke", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall struct {
	s                             *Service
	name                          string
	archiveuserdatamappingrequest *ArchiveUserDataMappingRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Archive: Archives the specified User data mapping.
//
// - name: The resource name of the User data mapping to archive.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Archive(name string, archiveuserdatamappingrequest *ArchiveUserDataMappingRequest) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.archiveuserdatamappingrequest = archiveuserdatamappingrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.archiveuserdatamappingrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:archive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.archive", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.archive" call.
// Any non-2xx status code is an error. Response headers are in either
// *ArchiveUserDataMappingResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveCall) Do(opts ...googleapi.CallOption) (*ArchiveUserDataMappingResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ArchiveUserDataMappingResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.archive", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall struct {
	s               *Service
	parent          string
	userdatamapping *UserDataMapping
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new User data mapping in the parent consent store.
//
// - parent: Name of the consent store.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Create(parent string, userdatamapping *UserDataMapping) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.userdatamapping = userdatamapping
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.userdatamapping)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/userDataMappings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserDataMapping.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateCall) Do(opts ...googleapi.CallOption) (*UserDataMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserDataMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified User data mapping.
//
// - name: The resource name of the User data mapping to delete.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Delete(name string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified User data mapping.
//
// - name: The resource name of the User data mapping to retrieve.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Get(name string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserDataMapping.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsGetCall) Do(opts ...googleapi.CallOption) (*UserDataMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserDataMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the User data mappings in the specified consent store.
//
// - parent: Name of the consent store to retrieve User data mappings from.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) List(parent string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts the User data
// mappings returned to those matching a filter. The following syntax is
// available: * A string field value can be written as text inside quotation
// marks, for example "query text". The only valid relational operation for
// text fields is equality (`=`), where text is searched within the field,
// rather than having the field be equal to the text. For example, "Comment =
// great" returns messages with `great` in the comment field. * A number field
// value can be written as an integer, a decimal, or an exponential. The valid
// relational operators for number fields are the equality operator (`=`),
// along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note
// that there is no inequality (`!=`) operator. You can prepend the `NOT`
// operator to an expression to negate it. * A date field value must be written
// in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// The fields available for filtering are: - data_id - user_id. For example,
// `filter=user_id=\"user123\". - archived - archive_time
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Filter(filter string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of User
// data mappings to return in a single response. If not specified, 100 is used.
// May not be larger than 1000.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to retrieve the
// next page of results, or empty to get the first page.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/userDataMappings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListUserDataMappingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Do(opts ...googleapi.CallOption) (*ListUserDataMappingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListUserDataMappingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsListCall) Pages(ctx context.Context, f func(*ListUserDataMappingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall struct {
	s               *Service
	name            string
	userdatamapping *UserDataMapping
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the specified User data mapping.
//
//   - name: Resource name of the User data mapping, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consen
//     tStores/{consent_store_id}/userDataMappings/{user_data_mapping_id}`.
func (r *ProjectsLocationsDatasetsConsentStoresUserDataMappingsService) Patch(name string, userdatamapping *UserDataMapping) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall {
	c := &ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.userdatamapping = userdatamapping
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask that applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
// Only the `data_id`, `user_id` and `resource_attributes` fields can be
// updated.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.userdatamapping)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.consentStores.userDataMappings.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserDataMapping.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchCall) Do(opts ...googleapi.CallOption) (*UserDataMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserDataMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.consentStores.userDataMappings.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsDataMapperWorkspacesService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dataMapperWorkspaces.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dataMapperWorkspaces.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dataMapperWorkspaces.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsDataMapperWorkspacesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dataMapperWorkspaces.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dataMapperWorkspaces.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dataMapperWorkspaces.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsDataMapperWorkspacesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dataMapperWorkspaces.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dataMapperWorkspaces.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDataMapperWorkspacesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dataMapperWorkspaces.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresCreateCall struct {
	s          *Service
	parent     string
	dicomstore *DicomStore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new DICOM store within the parent dataset.
//
// - parent: The name of the dataset this DICOM store belongs to.
func (r *ProjectsLocationsDatasetsDicomStoresService) Create(parent string, dicomstore *DicomStore) *ProjectsLocationsDatasetsDicomStoresCreateCall {
	c := &ProjectsLocationsDatasetsDicomStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomstore = dicomstore
	return c
}

// DicomStoreId sets the optional parameter "dicomStoreId": Required. The ID of
// the DICOM store that is being created. Any string value up to 256 characters
// in length.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) DicomStoreId(dicomStoreId string) *ProjectsLocationsDatasetsDicomStoresCreateCall {
	c.urlParams_.Set("dicomStoreId", dicomStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dicomstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *DicomStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresCreateCall) Do(opts ...googleapi.CallOption) (*DicomStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DicomStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDeidentifyCall struct {
	s                           *Service
	sourceStore                 string
	deidentifydicomstorerequest *DeidentifyDicomStoreRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Deidentify: De-identifies data from the source store and writes it to the
// destination store. The metadata field type is OperationMetadata. If the
// request is successful, the response field type is
// DeidentifyDicomStoreSummary. If errors occur, error is set. The LRO result
// may still be successful if de-identification fails for some DICOM instances.
// The output DICOM store will not contain these failed resources. Failed
// resource totals are tracked in Operation.metadata. Error details are also
// logged to Cloud Logging (see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
//
//   - sourceStore: Source DICOM store resource name. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) Deidentify(sourceStore string, deidentifydicomstorerequest *DeidentifyDicomStoreRequest) *ProjectsLocationsDatasetsDicomStoresDeidentifyCall {
	c := &ProjectsLocationsDatasetsDicomStoresDeidentifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sourceStore = sourceStore
	c.deidentifydicomstorerequest = deidentifydicomstorerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDeidentifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDeidentifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.deidentifydicomstorerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+sourceStore}:deidentify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sourceStore": c.sourceStore,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.deidentify", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.deidentify" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDeidentifyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.deidentify", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified DICOM store and removes all images that are
// contained within it.
//
// - name: The resource name of the DICOM store to delete.
func (r *ProjectsLocationsDatasetsDicomStoresService) Delete(name string) *ProjectsLocationsDatasetsDicomStoresDeleteCall {
	c := &ProjectsLocationsDatasetsDicomStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresExportCall struct {
	s                      *Service
	name                   string
	exportdicomdatarequest *ExportDicomDataRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Export: Exports data to the specified destination by copying it from the
// DICOM store. Errors are also logged to Cloud Logging. For more information,
// see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging). The metadata
// field type is OperationMetadata.
//
//   - name: The DICOM store resource name from which to export the data. For
//     example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) Export(name string, exportdicomdatarequest *ExportDicomDataRequest) *ProjectsLocationsDatasetsDicomStoresExportCall {
	c := &ProjectsLocationsDatasetsDicomStoresExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exportdicomdatarequest = exportdicomdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresExportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exportdicomdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.export", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresExportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.export", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified DICOM store.
//
// - name: The resource name of the DICOM store to get.
func (r *ProjectsLocationsDatasetsDicomStoresService) Get(name string) *ProjectsLocationsDatasetsDicomStoresGetCall {
	c := &ProjectsLocationsDatasetsDicomStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DicomStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresGetCall) Do(opts ...googleapi.CallOption) (*DicomStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DicomStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDICOMStoreMetrics: Gets metrics associated with the DICOM store.
//
// - name: The resource name of the DICOM store to get metrics for.
func (r *ProjectsLocationsDatasetsDicomStoresService) GetDICOMStoreMetrics(name string) *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall {
	c := &ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getDICOMStoreMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.getDICOMStoreMetrics", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.getDICOMStoreMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *DicomStoreMetrics.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsDicomStoresGetDICOMStoreMetricsCall) Do(opts ...googleapi.CallOption) (*DicomStoreMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DicomStoreMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.getDICOMStoreMetrics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsDicomStoresService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresImportCall struct {
	s                      *Service
	name                   string
	importdicomdatarequest *ImportDicomDataRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Import: Imports data into the DICOM store by copying it from the specified
// source. Errors are logged to Cloud Logging. For more information, see
// Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging). The metadata
// field type is OperationMetadata.
//
//   - name: The name of the DICOM store resource into which the data is
//     imported. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) Import(name string, importdicomdatarequest *ImportDicomDataRequest) *ProjectsLocationsDatasetsDicomStoresImportCall {
	c := &ProjectsLocationsDatasetsDicomStoresImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.importdicomdatarequest = importdicomdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresImportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importdicomdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.import", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresImportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.import", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the DICOM stores in the given dataset.
//
// - parent: Name of the dataset.
func (r *ProjectsLocationsDatasetsDicomStoresService) List(parent string) *ProjectsLocationsDatasetsDicomStoresListCall {
	c := &ProjectsLocationsDatasetsDicomStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts stores returned to
// those matching a filter. The following syntax is available: * A string field
// value can be written as text inside quotation marks, for example "query
// text". The only valid relational operation for text fields is equality
// (`=`), where text is searched within the field, rather than having the field
// be equal to the text. For example, "Comment = great" returns messages with
// `great` in the comment field. * A number field value can be written as an
// integer, a decimal, or an exponential. The valid relational operators for
// number fields are the equality operator (`=`), along with the less
// than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
// inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
// `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// Only filtering on labels is supported. For example, `labels.key=value`.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Filter(filter string) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of
// DICOM stores to return in a single response. If not specified, 100 is used.
// May not be larger than 1000.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDicomStoresResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Do(opts ...googleapi.CallOption) (*ListDicomStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDicomStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsDicomStoresListCall) Pages(ctx context.Context, f func(*ListDicomStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsDicomStoresPatchCall struct {
	s          *Service
	name       string
	dicomstore *DicomStore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the specified DICOM store.
//
//   - name: Identifier. Resource name of the DICOM store, of the form
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) Patch(name string, dicomstore *DicomStore) *ProjectsLocationsDatasetsDicomStoresPatchCall {
	c := &ProjectsLocationsDatasetsDicomStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.dicomstore = dicomstore
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsDicomStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dicomstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *DicomStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresPatchCall) Do(opts ...googleapi.CallOption) (*DicomStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DicomStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForInstances: SearchForInstances returns a list of matching instances.
// See [Search Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6).
// For details on the implementation of SearchForInstances, see Search
// transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForInstances, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
//     For example, `instances`, `series/{series_uid}/instances`, or
//     `studies/{study_uid}/instances`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) SearchForInstances(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.searchForInstances", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.searchForInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForSeries: SearchForSeries returns a list of matching series. See
// [Search Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6).
// For details on the implementation of SearchForSeries, see Search transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForSeries, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForSeries DICOMweb request. For
//     example, `series` or `studies/{study_uid}/series`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) SearchForSeries(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall {
	c := &ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.searchForSeries", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.searchForSeries" call.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForSeriesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForStudies: SearchForStudies returns a list of matching studies. See
// [Search Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6).
// For details on the implementation of SearchForStudies, see Search
// transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForStudies, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForStudies DICOMweb request. For
//     example, `studies`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) SearchForStudies(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall {
	c := &ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.searchForStudies", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.searchForStudies" call.
func (c *ProjectsLocationsDatasetsDicomStoresSearchForStudiesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall struct {
	s                             *Service
	resource                      string
	setblobstoragesettingsrequest *SetBlobStorageSettingsRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// SetBlobStorageSettings: SetBlobStorageSettings sets the blob storage
// settings of the specified resources.
//
//   - resource: The path of the resource to update the blob storage settings in
//     the format of
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}`,
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/`, or
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/instances/
//     {instanceUID}`. If `filter_config` is specified, set the value of
//     `resource` to the resource name of a DICOM store in the format
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) SetBlobStorageSettings(resource string, setblobstoragesettingsrequest *SetBlobStorageSettingsRequest) *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall {
	c := &ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setblobstoragesettingsrequest = setblobstoragesettingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setblobstoragesettingsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setBlobStorageSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.setBlobStorageSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.setBlobStorageSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresSetBlobStorageSettingsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.setBlobStorageSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsDicomStoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStoreInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	body_        io.Reader
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// StoreInstances: StoreInstances stores DICOM instances associated with study
// instance unique identifiers (SUID). See [Store Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5).
// For details on the implementation of StoreInstances, see Store transaction
// (https://cloud.google.com/healthcare/docs/dicom#store_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call StoreInstances, see Store DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#store-dicom).
//
//   - dicomWebPath: The path of the StoreInstances DICOMweb request. For
//     example, `studies/[{study_uid}]`. Note that the `study_uid` is optional.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresService) StoreInstances(parent string, dicomWebPath string, body_ io.Reader) *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStoreInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.storeInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.storeInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresStoreInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsDicomStoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall struct {
	s            *Service
	study        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetStudyMetrics: GetStudyMetrics returns metrics for a study.
//
//   - study: The study resource path. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}/dicomWeb/studies/{study_uid}`.
func (r *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService) GetStudyMetrics(study string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall {
	c := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.study = study
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+study}:getStudyMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"study": c.study,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.getStudyMetrics", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.getStudyMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *StudyMetrics.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesGetStudyMetricsCall) Do(opts ...googleapi.CallOption) (*StudyMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StudyMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.getStudyMetrics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall struct {
	s                             *Service
	resource                      string
	setblobstoragesettingsrequest *SetBlobStorageSettingsRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// SetBlobStorageSettings: SetBlobStorageSettings sets the blob storage
// settings of the specified resources.
//
//   - resource: The path of the resource to update the blob storage settings in
//     the format of
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}`,
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/`, or
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/instances/
//     {instanceUID}`. If `filter_config` is specified, set the value of
//     `resource` to the resource name of a DICOM store in the format
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}`.
func (r *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesService) SetBlobStorageSettings(resource string, setblobstoragesettingsrequest *SetBlobStorageSettingsRequest) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall {
	c := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setblobstoragesettingsrequest = setblobstoragesettingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setblobstoragesettingsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setBlobStorageSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.setBlobStorageSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.setBlobStorageSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSetBlobStorageSettingsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.setBlobStorageSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall struct {
	s            *Service
	series       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSeriesMetrics: GetSeriesMetrics returns metrics for a series.
//
//   - series: The series resource path. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}/dicomWeb/studies/{study_uid}/series/{series_uid}`.
func (r *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesService) GetSeriesMetrics(series string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall {
	c := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.series = series
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+series}:getSeriesMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"series": c.series,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.getSeriesMetrics", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.getSeriesMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *SeriesMetrics.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesGetSeriesMetricsCall) Do(opts ...googleapi.CallOption) (*SeriesMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SeriesMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.getSeriesMetrics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetStorageInfo: GetStorageInfo returns the storage info of the specified
// resource.
//
//   - resource: The path of the instance to return storage info for, in the
//     form:
//     `projects/{projectID}/locations/{locationID}/datasets/{datasetID}/dicomStor
//     es/{dicomStoreID}/dicomWeb/studies/{studyUID}/series/{seriesUID}/instances/
//     {instanceUID}`.
func (r *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesService) GetStorageInfo(resource string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall {
	c := &ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getStorageInfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.getStorageInfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.getStorageInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *StorageInfo.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresDicomWebStudiesSeriesInstancesGetStorageInfoCall) Do(opts ...googleapi.CallOption) (*StorageInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &StorageInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.dicomWeb.studies.series.instances.getStorageInfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: DeleteStudy deletes all instances within the given study. Delete
// requests are equivalent to the GET requests specified in the Retrieve
// transaction. The method returns an Operation which will be marked successful
// when the deletion is complete. Warning: Instances cannot be inserted into a
// study that is being deleted by an operation until the operation completes.
// For samples that show how to call DeleteStudy, see Delete a study, series,
// or instance
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#delete-dicom).
//
//   - dicomWebPath: The path of the DeleteStudy request. For example,
//     `studies/{study_uid}`.
//   - parent: .
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) Delete(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveMetadata: RetrieveStudyMetadata returns instance associated with the
// given study presented as metadata. See [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveStudyMetadata, see Metadata
// resources
// (https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveStudyMetadata, see Retrieve metadata
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-metadata).
//
//   - dicomWebPath: The path of the RetrieveStudyMetadata DICOMweb request. For
//     example, `studies/{study_uid}/metadata`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) RetrieveMetadata(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.retrieveMetadata", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.retrieveMetadata" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveStudy: RetrieveStudy returns all instances within the given study.
// See [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveStudy, see DICOM
// study/series/instances
// (https://cloud.google.com/healthcare/docs/dicom#dicom_studyseriesinstances)
// in the Cloud Healthcare API conformance statement. For samples that show how
// to call RetrieveStudy, see Retrieve DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-dicom).
//
//   - dicomWebPath: The path of the RetrieveStudy DICOMweb request. For example,
//     `studies/{study_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) RetrieveStudy(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.retrieveStudy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.retrieveStudy" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForInstances: SearchForInstances returns a list of matching instances.
// See [Search Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6).
// For details on the implementation of SearchForInstances, see Search
// transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForInstances, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
//     For example, `instances`, `series/{series_uid}/instances`, or
//     `studies/{study_uid}/instances`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) SearchForInstances(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.searchForInstances", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.searchForInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForSeries: SearchForSeries returns a list of matching series. See
// [Search Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6).
// For details on the implementation of SearchForSeries, see Search transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForSeries, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForSeries DICOMweb request. For
//     example, `series` or `studies/{study_uid}/series`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) SearchForSeries(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.searchForSeries", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.searchForSeries" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	body_        io.Reader
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// StoreInstances: StoreInstances stores DICOM instances associated with study
// instance unique identifiers (SUID). See [Store Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.5).
// For details on the implementation of StoreInstances, see Store transaction
// (https://cloud.google.com/healthcare/docs/dicom#store_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call StoreInstances, see Store DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#store-dicom).
//
//   - dicomWebPath: The path of the StoreInstances DICOMweb request. For
//     example, `studies/[{study_uid}]`. Note that the `study_uid` is optional.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesService) StoreInstances(parent string, dicomWebPath string, body_ io.Reader) *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.storeInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.storeInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: DeleteSeries deletes all instances within the given study and
// series. Delete requests are equivalent to the GET requests specified in the
// Retrieve transaction. The method returns an Operation which will be marked
// successful when the deletion is complete. Warning: Instances cannot be
// inserted into a series that is being deleted by an operation until the
// operation completes. For samples that show how to call DeleteSeries, see
// Delete a study, series, or instance
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#delete-dicom).
//
//   - dicomWebPath: The path of the DeleteSeries request. For example,
//     `studies/{study_uid}/series/{series_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService) Delete(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveMetadata: RetrieveSeriesMetadata returns instance associated with
// the given study and series, presented as metadata. See [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveSeriesMetadata, see Metadata
// resources
// (https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveSeriesMetadata, see Retrieve metadata
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-metadata).
//
//   - dicomWebPath: The path of the RetrieveSeriesMetadata DICOMweb request. For
//     example, `studies/{study_uid}/series/{series_uid}/metadata`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService) RetrieveMetadata(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.retrieveMetadata", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.retrieveMetadata" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveSeries: RetrieveSeries returns all instances within the given study
// and series. See [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveSeries, see DICOM
// study/series/instances
// (https://cloud.google.com/healthcare/docs/dicom#dicom_studyseriesinstances)
// in the Cloud Healthcare API conformance statement. For samples that show how
// to call RetrieveSeries, see Retrieve DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-dicom).
//
//   - dicomWebPath: The path of the RetrieveSeries DICOMweb request. For
//     example, `studies/{study_uid}/series/{series_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService) RetrieveSeries(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.retrieveSeries", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.retrieveSeries" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchForInstances: SearchForInstances returns a list of matching instances.
// See [Search Transaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.6).
// For details on the implementation of SearchForInstances, see Search
// transaction
// (https://cloud.google.com/healthcare/docs/dicom#search_transaction) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call SearchForInstances, see Search for DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#search-dicom).
//
//   - dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
//     For example, `instances`, `series/{series_uid}/instances`, or
//     `studies/{study_uid}/instances`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesService) SearchForInstances(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.searchForInstances", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.searchForInstances" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: DeleteInstance deletes an instance associated with the given study,
// series, and SOP Instance UID. Delete requests are equivalent to the GET
// requests specified in the Retrieve transaction. Study and series search
// results can take a few seconds to be updated after an instance is deleted
// using DeleteInstance. For samples that show how to call DeleteInstance, see
// Delete a study, series, or instance
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#delete-dicom).
//
//   - dicomWebPath: The path of the DeleteInstance request. For example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService) Delete(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveInstance: RetrieveInstance returns instance associated with the
// given study, series, and SOP Instance UID. See [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveInstance, see DICOM
// study/series/instances
// (https://cloud.google.com/healthcare/docs/dicom#dicom_studyseriesinstances)
// and DICOM instances
// (https://cloud.google.com/healthcare/docs/dicom#dicom_instances) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveInstance, see Retrieve an instance
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-instance).
//
//   - dicomWebPath: The path of the RetrieveInstance DICOMweb request. For
//     example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService) RetrieveInstance(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveInstance", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveInstance" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveMetadata: RetrieveInstanceMetadata returns instance associated with
// the given study, series, and SOP Instance UID presented as metadata. See
// [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveInstanceMetadata, see Metadata
// resources
// (https://cloud.google.com/healthcare/docs/dicom#metadata_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveInstanceMetadata, see Retrieve metadata
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-metadata).
//
//   - dicomWebPath: The path of the RetrieveInstanceMetadata DICOMweb request.
//     For example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/metadata`
//     .
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService) RetrieveMetadata(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveMetadata", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveMetadata" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveRendered: RetrieveRenderedInstance returns instance associated with
// the given study, series, and SOP Instance UID in an acceptable Rendered
// Media Type. See [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveRenderedInstance, see Rendered
// resources
// (https://cloud.google.com/healthcare/docs/dicom#rendered_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveRenderedInstance, see Retrieve consumer image formats
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-consumer).
//
//   - dicomWebPath: The path of the RetrieveRenderedInstance DICOMweb request.
//     For example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/rendered`
//     .
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesService) RetrieveRendered(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Viewport sets the optional parameter "viewport": The viewport setting to use
// as specified in
// https://dicom.nema.org/medical/dicom/current/output/chtml/part18/sect_8.3.5.html#sect_8.3.5.1.3
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Viewport(viewport string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c.urlParams_.Set("viewport", viewport)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveRendered", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.retrieveRendered" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveBulkdata: Returns uncompressed, unencoded bytes representing the
// referenced bulkdata tag from an instance. See Retrieve Transaction
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveBulkdata, see Bulkdata
// resources
// (https://cloud.google.com/healthcare/docs/dicom#bulkdata-resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveBulkdata, see Retrieve bulkdata
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-bulkdata).
//
//   - dicomWebPath: The path for the `RetrieveBulkdata` DICOMweb request. For
//     example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/bukdata/{
//     bulkdata_uri}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataService) RetrieveBulkdata(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.bulkdata.retrieveBulkdata", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.bulkdata.retrieveBulkdata" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesBulkdataRetrieveBulkdataCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveFrames: RetrieveFrames returns instances associated with the given
// study, series, SOP Instance UID and frame numbers. See [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4}.
// For details on the implementation of RetrieveFrames, see DICOM frames
// (https://cloud.google.com/healthcare/docs/dicom#dicom_frames) in the Cloud
// Healthcare API conformance statement. For samples that show how to call
// RetrieveFrames, see Retrieve DICOM data
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-dicom).
//
//   - dicomWebPath: The path of the RetrieveFrames DICOMweb request. For
//     example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{f
//     rame_list}`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService) RetrieveFrames(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.frames.retrieveFrames", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.frames.retrieveFrames" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall struct {
	s            *Service
	parent       string
	dicomWebPath string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// RetrieveRendered: RetrieveRenderedFrames returns instances associated with
// the given study, series, SOP Instance UID and frame numbers in an acceptable
// Rendered Media Type. See [RetrieveTransaction]
// (http://dicom.nema.org/medical/dicom/current/output/html/part18.html#sect_10.4).
// For details on the implementation of RetrieveRenderedFrames, see Rendered
// resources
// (https://cloud.google.com/healthcare/docs/dicom#rendered_resources) in the
// Cloud Healthcare API conformance statement. For samples that show how to
// call RetrieveRenderedFrames, see Retrieve consumer image formats
// (https://cloud.google.com/healthcare/docs/how-tos/dicomweb#retrieve-consumer).
//
//   - dicomWebPath: The path of the RetrieveRenderedFrames DICOMweb request. For
//     example,
//     `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}/frames/{f
//     rame_list}/rendered`.
//   - parent: The name of the DICOM store that is being accessed. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomS
//     tores/{dicom_store_id}`.
func (r *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesService) RetrieveRendered(parent string, dicomWebPath string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c := &ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dicomWebPath = dicomWebPath
	return c
}

// Viewport sets the optional parameter "viewport": The viewport setting to use
// as specified in
// https://dicom.nema.org/medical/dicom/current/output/chtml/part18/sect_8.3.5.html#sect_8.3.5.1.3
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Viewport(viewport string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c.urlParams_.Set("viewport", viewport)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dicomWeb/{+dicomWebPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"dicomWebPath": c.dicomWebPath,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.frames.retrieveRendered", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.dicomStores.studies.series.instances.frames.retrieveRendered" call.
func (c *ProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall struct {
	s                         *Service
	name                      string
	applyadminconsentsrequest *ApplyAdminConsentsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// ApplyAdminConsents: Applies the admin Consent resources for the FHIR store
// and reindexes the underlying resources in the FHIR store according to the
// aggregate consents. This method also updates the
// `consent_config.enforced_admin_consents` field of the FhirStore unless
// `validate_only=true` in ApplyAdminConsentsRequest. Any admin Consent
// resource change after this operation execution (including deletion) requires
// you to call ApplyAdminConsents again for the change to take effect. This
// method returns an Operation that can be used to track the progress of the
// resources that were reindexed, by calling GetOperation. Upon completion, the
// ApplyAdminConsentsResponse additionally contains the number of resources
// that were reindexed. If at least one Consent resource contains an error or
// fails be be enforced for any reason, the method returns an error instead of
// an Operation. No resources will be reindexed and the
// `consent_config.enforced_admin_consents` field will be unchanged. To enforce
// a consent check for data access, `consent_config.access_enforced` must be
// set to true for the FhirStore. FHIR Consent is not supported in DSTU2 or R5.
//
//   - name: The name of the FHIR store to enforce, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ApplyAdminConsents(name string, applyadminconsentsrequest *ApplyAdminConsentsRequest) *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall {
	c := &ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.applyadminconsentsrequest = applyadminconsentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.applyadminconsentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:applyAdminConsents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.applyAdminConsents", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.applyAdminConsents" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresApplyAdminConsentsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.applyAdminConsents", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresApplyConsentsCall struct {
	s                    *Service
	name                 string
	applyconsentsrequest *ApplyConsentsRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// ApplyConsents: Apply the Consent resources for the FHIR store and reindex
// the underlying resources in the FHIR store according to the aggregate
// consent. The aggregate consent of the patient in scope in this request
// replaces any previous call of this method. Any Consent resource change after
// this operation execution (including deletion) requires you to call
// ApplyConsents again to have effect. This method returns an Operation that
// can be used to track the progress of the consent resources that were
// processed by calling GetOperation. Upon completion, the
// ApplyConsentsResponse additionally contains the number of resources that was
// reindexed. Errors are logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// To enforce consent check for data access, `consent_config.access_enforced`
// must be set to true for the FhirStore. FHIR Consent is not supported in
// DSTU2 or R5.
//
//   - name: The name of the FHIR store to enforce, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ApplyConsents(name string, applyconsentsrequest *ApplyConsentsRequest) *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall {
	c := &ProjectsLocationsDatasetsFhirStoresApplyConsentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.applyconsentsrequest = applyconsentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.applyconsentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:applyConsents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.applyConsents", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.applyConsents" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresApplyConsentsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.applyConsents", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BulkExportGroup: Bulk exports a Group resource and resources in the member
// field, including related resources for each Patient member. The export for
// each Patient is identical to a GetPatientEverything request. Implements the
// FHIR implementation guide $export group of patients
// (https://build.fhir.org/ig/HL7/bulk-data/export.html#endpoint---group-of-patients).
// The following headers must be set in the request: * `Accept`: specifies the
// format of the `OperationOutcome` response. Only `application/fhir+json` is
// supported. * `Prefer`: specifies whether the response is immediate or
// asynchronous. Must be to `respond-async` because only asynchronous responses
// are supported. Specify the destination for the server to write result files
// by setting the Cloud Storage location bulk_export_gcs_destination on the
// FHIR store. URI of an existing Cloud Storage directory where the server
// writes result files, in the format
// gs://{bucket-id}/{path/to/destination/dir}. If there is no trailing slash,
// the service appends one when composing the object path. The user is
// responsible for creating the Cloud Storage bucket referenced. Supports the
// following query parameters: * `_type`: string of comma-delimited FHIR
// resource types. If provided, only resources of the specified type(s) are
// exported. * `_since`: if provided, only resources updated after the
// specified time are exported. * `_outputFormat`: optional, specify ndjson to
// export data in NDJSON format. Exported file names use the format:
// {export_id}_{resource_type}.ndjson. * `organizeOutputBy`: resource type to
// organize the output by. Required and must be set to `Patient`. When
// specified, output files are organized by instances of the specified resource
// type, including the resource, referenced resources, and resources that
// contain references to that resource. On success, the `Content-Location`
// header of response is set to a URL that you can use to query the status of
// the export. The URL is in the format
// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
// es/{fhir_store_id}/operations/{export_id}`. See get-fhir-operation-status
// for more information. Errors generated by the FHIR store contain a
// JSON-encoded `OperationOutcome` resource describing the reason for the
// error.
//
//   - name: Name of the Group resource that is exported, in format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}/fhir/Group/{group_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) BulkExportGroup(name string) *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall {
	c := &ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Since sets the optional parameter "_since": If provided, only resources
// updated after this time are exported. The time uses the format
// YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example, `2015-02-07T13:28:17.239+02:00`
// or `2017-01-01T00:00:00Z`. The time must be specified to the second and
// include a time zone.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) Since(Since string) *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall {
	c.urlParams_.Set("_since", Since)
	return c
}

// Type sets the optional parameter "_type": String of comma-delimited FHIR
// resource types. If provided, only resources of the specified resource
// type(s) are exported.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) Type(Type string) *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall {
	c.urlParams_.Set("_type", Type)
	return c
}

// OrganizeOutputBy sets the optional parameter "organizeOutputBy": Required.
// The FHIR resource type used to organize exported resources. Only supports
// "Patient". When organized by Patient resource, output files are grouped as
// follows: * Patient file(s) containing the Patient resources. Each Patient is
// sequentially followed by all resources the Patient references, and all
// resources that reference the Patient (equivalent to a GetPatientEverything
// request). * Individual files grouped by resource type for resources in the
// Group's member field and the Group resource itself. Resources may be
// duplicated across multiple Patients. For example, if two Patient resources
// reference the same Organization resource, it will appear twice, once after
// each Patient. The Group resource from the request does not appear in the
// Patient files.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) OrganizeOutputBy(organizeOutputBy string) *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall {
	c.urlParams_.Set("organizeOutputBy", organizeOutputBy)
	return c
}

// OutputFormat sets the optional parameter "outputFormat": Output format of
// the export. This field is optional and only `application/fhir+ndjson` is
// supported.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) OutputFormat(outputFormat string) *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall {
	c.urlParams_.Set("outputFormat", outputFormat)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/$export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.bulk-export-group", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.bulk-export-group" call.
func (c *ProjectsLocationsDatasetsFhirStoresBulkExportGroupCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresCreateCall struct {
	s          *Service
	parent     string
	fhirstore  *FhirStore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new FHIR store within the parent dataset.
//
// - parent: The name of the dataset this FHIR store belongs to.
func (r *ProjectsLocationsDatasetsFhirStoresService) Create(parent string, fhirstore *FhirStore) *ProjectsLocationsDatasetsFhirStoresCreateCall {
	c := &ProjectsLocationsDatasetsFhirStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.fhirstore = fhirstore
	return c
}

// FhirStoreId sets the optional parameter "fhirStoreId": Required. The ID of
// the FHIR store that is being created. The string must match the following
// regex: `[\p{L}\p{N}_\-\.]{1,256}`.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) FhirStoreId(fhirStoreId string) *ProjectsLocationsDatasetsFhirStoresCreateCall {
	c.urlParams_.Set("fhirStoreId", fhirStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.fhirstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhirStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *FhirStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresCreateCall) Do(opts ...googleapi.CallOption) (*FhirStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FhirStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresDeidentifyCall struct {
	s                          *Service
	sourceStore                string
	deidentifyfhirstorerequest *DeidentifyFhirStoreRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Deidentify: De-identifies data from the source store and writes it to the
// destination store. The metadata field type is OperationMetadata. If the
// request is successful, the response field type is
// DeidentifyFhirStoreSummary. If errors occur, error is set. Error details are
// also logged to Cloud Logging (see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging)).
//
//   - sourceStore: Source FHIR store resource name. For example,
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`. R5 stores are not supported.
func (r *ProjectsLocationsDatasetsFhirStoresService) Deidentify(sourceStore string, deidentifyfhirstorerequest *DeidentifyFhirStoreRequest) *ProjectsLocationsDatasetsFhirStoresDeidentifyCall {
	c := &ProjectsLocationsDatasetsFhirStoresDeidentifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sourceStore = sourceStore
	c.deidentifyfhirstorerequest = deidentifyfhirstorerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresDeidentifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresDeidentifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.deidentifyfhirstorerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+sourceStore}:deidentify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sourceStore": c.sourceStore,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.deidentify", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.deidentify" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresDeidentifyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.deidentify", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified FHIR store and removes all resources within
// it.
//
// - name: The resource name of the FHIR store to delete.
func (r *ProjectsLocationsDatasetsFhirStoresService) Delete(name string) *ProjectsLocationsDatasetsFhirStoresDeleteCall {
	c := &ProjectsLocationsDatasetsFhirStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ExplainDataAccess: Explains all the permitted/denied actor, purpose and
// environment for a given resource. FHIR Consent is not supported in DSTU2 or
// R5.
//
//   - name: The name of the FHIR store to enforce, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) ExplainDataAccess(name string) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c := &ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ResourceId sets the optional parameter "resourceId": Required. The ID
// (`{resourceType}/{id}`) of the resource to explain data access on.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) ResourceId(resourceId string) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c.urlParams_.Set("resourceId", resourceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:explainDataAccess")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.explainDataAccess", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.explainDataAccess" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExplainDataAccessResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresExplainDataAccessCall) Do(opts ...googleapi.CallOption) (*ExplainDataAccessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExplainDataAccessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.explainDataAccess", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresExportCall struct {
	s                      *Service
	name                   string
	exportresourcesrequest *ExportResourcesRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Export: Export resources from the FHIR store to the specified destination.
// This method returns an Operation that can be used to track the status of the
// export by calling GetOperation. Immediate fatal errors appear in the error
// field, errors are also logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// Otherwise, when the operation finishes, a detailed response of type
// ExportResourcesResponse is returned in the response field. The metadata
// field type for this operation is OperationMetadata.
//
//   - name: The name of the FHIR store to export resource from, in the format of
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) Export(name string, exportresourcesrequest *ExportResourcesRequest) *ProjectsLocationsDatasetsFhirStoresExportCall {
	c := &ProjectsLocationsDatasetsFhirStoresExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exportresourcesrequest = exportresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresExportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exportresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.export", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresExportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.export", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the configuration of the specified FHIR store.
//
// - name: The resource name of the FHIR store to get.
func (r *ProjectsLocationsDatasetsFhirStoresService) Get(name string) *ProjectsLocationsDatasetsFhirStoresGetCall {
	c := &ProjectsLocationsDatasetsFhirStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FhirStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresGetCall) Do(opts ...googleapi.CallOption) (*FhirStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FhirStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetFHIRStoreMetrics: Gets metrics associated with the FHIR store.
//
// - name: The resource name of the FHIR store to get metrics for.
func (r *ProjectsLocationsDatasetsFhirStoresService) GetFHIRStoreMetrics(name string) *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall {
	c := &ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getFHIRStoreMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.getFHIRStoreMetrics", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.getFHIRStoreMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *FhirStoreMetrics.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsFhirStoresGetFHIRStoreMetricsCall) Do(opts ...googleapi.CallOption) (*FhirStoreMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FhirStoreMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.getFHIRStoreMetrics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsFhirStoresService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresImportCall struct {
	s                      *Service
	name                   string
	importresourcesrequest *ImportResourcesRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Import: Imports resources to the FHIR store by loading data from the
// specified sources. This method is optimized to load large quantities of data
// using import semantics that ignore some FHIR store configuration options and
// are not suitable for all use cases. It is primarily intended to load data
// into an empty FHIR store that is not being used by other clients. In cases
// where this method is not appropriate, consider using ExecuteBundle to load
// data. Every resource in the input must contain a client-supplied ID. Each
// resource is stored using the supplied ID regardless of the
// enable_update_create setting on the FHIR store. It is strongly advised not
// to include or encode any sensitive data such as patient identifiers in
// client-specified resource IDs. Those IDs are part of the FHIR resource path
// recorded in Cloud Audit Logs and Cloud Pub/Sub notifications. Those IDs can
// also be contained in reference fields within other resources. The import
// process does not enforce referential integrity, regardless of the
// disable_referential_integrity setting on the FHIR store. This allows the
// import of resources with arbitrary interdependencies without considering
// grouping or ordering, but if the input data contains invalid references or
// if some resources fail to be imported, the FHIR store might be left in a
// state that violates referential integrity. The import process does not
// trigger Pub/Sub notification or BigQuery streaming update, regardless of how
// those are configured on the FHIR store. If a resource with the specified ID
// already exists, the most recent version of the resource is overwritten
// without creating a new historical version, regardless of the
// disable_resource_versioning setting on the FHIR store. If transient failures
// occur during the import, it's possible that successfully imported resources
// will be overwritten more than once. The import operation is idempotent
// unless the input data contains multiple valid resources with the same ID but
// different contents. In that case, after the import completes, the store
// contains exactly one resource with that ID but there is no ordering
// guarantee on which version of the contents it will have. The operation
// result counters do not count duplicate IDs as an error and count one success
// for each resource in the input, which might result in a success count larger
// than the number of resources in the FHIR store. This often occurs when
// importing data organized in bundles produced by Patient-everything where
// each bundle contains its own copy of a resource such as Practitioner that
// might be referred to by many patients. If some resources fail to import, for
// example due to parsing errors, successfully imported resources are not
// rolled back. The location and format of the input data is specified by the
// parameters in ImportResourcesRequest. Note that if no format is specified,
// this method assumes the `BUNDLE` format. When using the `BUNDLE` format this
// method ignores the `Bundle.type` field, except that `history` bundles are
// rejected, and does not apply any of the bundle processing semantics for
// batch or transaction bundles. Unlike in ExecuteBundle, transaction bundles
// are not executed as a single transaction and bundle-internal references are
// not rewritten. The bundle is treated as a collection of resources to be
// written as provided in `Bundle.entry.resource`, ignoring
// `Bundle.entry.request`. As an example, this allows the import of `searchset`
// bundles produced by a FHIR search or Patient-everything operation. This
// method returns an Operation that can be used to track the status of the
// import by calling GetOperation. Immediate fatal errors appear in the error
// field, errors are also logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// Otherwise, when the operation finishes, a detailed response of type
// ImportResourcesResponse is returned in the response field. The metadata
// field type for this operation is OperationMetadata.
//
//   - name: The name of the FHIR store to import FHIR resources to, in the
//     format of
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) Import(name string, importresourcesrequest *ImportResourcesRequest) *ProjectsLocationsDatasetsFhirStoresImportCall {
	c := &ProjectsLocationsDatasetsFhirStoresImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.importresourcesrequest = importresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresImportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.import", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresImportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.import", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the FHIR stores in the given dataset.
//
// - parent: Name of the dataset.
func (r *ProjectsLocationsDatasetsFhirStoresService) List(parent string) *ProjectsLocationsDatasetsFhirStoresListCall {
	c := &ProjectsLocationsDatasetsFhirStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts stores returned to
// those matching a filter. The following syntax is available: * A string field
// value can be written as text inside quotation marks, for example "query
// text". The only valid relational operation for text fields is equality
// (`=`), where text is searched within the field, rather than having the field
// be equal to the text. For example, "Comment = great" returns messages with
// `great` in the comment field. * A number field value can be written as an
// integer, a decimal, or an exponential. The valid relational operators for
// number fields are the equality operator (`=`), along with the less
// than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
// inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
// `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format.
// Leading zeros are required for one-digit months and days. The valid
// relational operators for date fields are the equality operator (`=`) , along
// with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that
// there is no inequality (`!=`) operator. You can prepend the `NOT` operator
// to an expression to negate it. * Multiple field query expressions can be
// combined in one query by adding `AND` or `OR` operators between the
// expressions. If a boolean operator appears within a quoted string, it is not
// treated as special, it's just another part of the character string to be
// matched. You can prepend the `NOT` operator to an expression to negate it.
// Only filtering on labels is supported, for example `labels.key=value`.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Filter(filter string) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Limit on the number of FHIR
// stores to return in a single response. If not specified, 100 is used. May
// not be larger than 1000.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The next_page_token value
// returned from the previous List request, if any.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhirStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFhirStoresResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Do(opts ...googleapi.CallOption) (*ListFhirStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFhirStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsFhirStoresListCall) Pages(ctx context.Context, f func(*ListFhirStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsFhirStoresPatchCall struct {
	s          *Service
	name       string
	fhirstore  *FhirStore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the configuration of the specified FHIR store.
//
//   - name: Output only. Identifier. Resource name of the FHIR store, of the
//     form
//     `projects/{project_id}/locations/{location}/datasets/{dataset_id}/fhirStore
//     s/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresService) Patch(name string, fhirstore *FhirStore) *ProjectsLocationsDatasetsFhirStoresPatchCall {
	c := &ProjectsLocationsDatasetsFhirStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.fhirstore = fhirstore
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The update
// mask applies to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDatasetsFhirStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.fhirstore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *FhirStore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresPatchCall) Do(opts ...googleapi.CallOption) (*FhirStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FhirStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresRollbackCall struct {
	s                            *Service
	name                         string
	rollbackfhirresourcesrequest *RollbackFhirResourcesRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Rollback: Rolls back resources from the FHIR store to the specified time.
// This method returns an Operation that can be used to track the status of the
// rollback by calling GetOperation. Immediate fatal errors appear in the error
// field, errors are also logged to Cloud Logging (see Viewing error logs in
// Cloud Logging (https://cloud.google.com/healthcare/docs/how-tos/logging)).
// Otherwise, when the operation finishes, a detailed response of type
// RollbackFhirResourcesResponse is returned in the response field. The
// metadata field type for this operation is OperationMetadata.
//
//   - name: The name of the FHIR store to rollback, in the format of
//     "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}
//     /fhirStores/{fhir_store_id}".
func (r *ProjectsLocationsDatasetsFhirStoresService) Rollback(name string, rollbackfhirresourcesrequest *RollbackFhirResourcesRequest) *ProjectsLocationsDatasetsFhirStoresRollbackCall {
	c := &ProjectsLocationsDatasetsFhirStoresRollbackCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rollbackfhirresourcesrequest = rollbackfhirresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresRollbackCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresRollbackCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rollbackfhirresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:rollback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.rollback", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.rollback" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresRollbackCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.rollback", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsFhirStoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall {
	c := &ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsDatasetsFhirStoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall {
	c := &ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall struct {
	s          *Service
	parent     string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// BinaryCreate: Creates a FHIR Binary resource. This method can be used to
// create a Binary resource either by using one of the accepted FHIR JSON
// content types, or as a raw data stream. If a resource is created with this
// method using the FHIR content type this method's behavior is the same as
// `fhir.create`
// (https://cloud.google.com/healthcare-api/docs/reference/rest/v1/projects.locations.datasets.fhirStores.fhir/create).
// If a resource type other than Binary is used in the request it's treated in
// the same way as non-FHIR data (e.g., images, zip archives, pdf files,
// documents). When a non-FHIR content type is used in the request, a Binary
// resource will be generated, and the uploaded data will be stored in the
// `content` field (`DSTU2` and `STU3`), or the `data` field (`R4` and `R5`).
// The Binary resource's `contentType` will be filled in using the value of the
// `Content-Type` header, and the `securityContext` field (not present in
// `DSTU2`) will be populated from the `X-Security-Context` header if it
// exists. At this time `securityContext` has no special behavior in the Cloud
// Healthcare API. Note: the limit on data ingested through this method is 1
// GB. For best performance, use a non-FHIR data type instead of wrapping the
// data in a Binary resource. Some of the Healthcare API features, such as
// exporting to BigQuery
// (https://cloud.google.com/healthcare-api/docs/how-tos/fhir-export-bigquery)
// or Pub/Sub notifications
// (https://cloud.google.com/healthcare-api/docs/fhir-pubsub#behavior_when_a_fhir_resource_is_too_large_or_traffic_is_high)
// with full resource content, do not support Binary resources that are larger
// than 10 MB. In these cases the resource's `data` field will be omitted.
// Instead, the "http://hl7.org/fhir/StructureDefinition/data-absent-reason"
// extension will be present to indicate that including the data is
// `unsupported`. On success, an empty `201 Created` response is returned. The
// newly created resource's ID and version are returned in the Location header.
// Using `Prefer: representation=resource` is not allowed for this method. The
// definition of the Binary REST API can be found at
// https://hl7.org/fhir/binary.html#rest.
//
// - parent: The name of the FHIR store this resource belongs to.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BinaryCreate(parent string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir/Binary")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-create" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryCreateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BinaryRead: Gets the contents of a FHIR Binary resource. This method can be
// used to retrieve a Binary resource either by using the FHIR JSON mimetype as
// the value for the Accept header, or as a raw data stream. If the FHIR Accept
// type is used this method will return a Binary resource with the data
// base64-encoded, regardless of how the resource was created. The resource
// data can be retrieved in base64-decoded form if the Accept type of the
// request matches the value of the resource's `contentType` field. The
// definition of the Binary REST API can be found at
// https://hl7.org/fhir/binary.html#rest.
//
// - name: The name of the Binary resource to retrieve.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BinaryRead(name string) *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-read", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-read" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryReadCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall struct {
	s          *Service
	name       string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// BinaryUpdate: Updates the entire contents of a Binary resource. If the
// specified resource does not exist and the FHIR store has
// enable_update_create set, creates the resource with the client-specified ID.
// It is strongly advised not to include or encode any sensitive data such as
// patient identifiers in client-specified resource IDs. Those IDs are part of
// the FHIR resource path recorded in Cloud Audit Logs and Pub/Sub
// notifications. Those IDs can also be contained in reference fields within
// other resources. This method can be used to update a Binary resource either
// by using one of the accepted FHIR JSON content types, or as a raw data
// stream. If a resource is updated with this method using the FHIR content
// type this method's behavior is the same as `update`. If a resource type
// other than Binary is used in the request it will be treated in the same way
// as non-FHIR data. When a non-FHIR content type is used in the request, a
// Binary resource will be generated using the ID from the resource path, and
// the uploaded data will be stored in the `content` field (`DSTU2` and
// `STU3`), or the `data` field (`R4` and `R5`). The Binary resource's
// `contentType` will be filled in using the value of the `Content-Type`
// header, and the `securityContext` field (not present in `DSTU2`) will be
// populated from the `X-Security-Context` header if it exists. At this time
// `securityContext` has no special behavior in the Cloud Healthcare API. Note:
// the limit on data ingested through this method is 2 GB. For best
// performance, use a non-FHIR data type instead of wrapping the data in a
// Binary resource. Some of the Healthcare API features, such as exporting to
// BigQuery
// (https://cloud.google.com/healthcare-api/docs/how-tos/fhir-export-bigquery)
// or Pub/Sub notifications
// (https://cloud.google.com/healthcare-api/docs/fhir-pubsub#behavior_when_a_fhir_resource_is_too_large_or_traffic_is_high)
// with full resource content, do not support Binary resources that are larger
// than 10 MB. In these cases the resource's `data` field will be omitted.
// Instead, the "http://hl7.org/fhir/StructureDefinition/data-absent-reason"
// extension will be present to indicate that including the data is
// `unsupported`. On success, an empty 200 OK response will be returned, or a
// 201 Created if the resource did not exit. The resource's ID and version are
// returned in the Location header. Using `Prefer: representation=resource` is
// not allowed for this method. The definition of the Binary REST API can be
// found at https://hl7.org/fhir/binary.html#rest.
//
// - name: The name of the resource to update.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BinaryUpdate(name string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-update" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryUpdateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BinaryVread: Gets the contents of a version (current or historical) of a
// FHIR Binary resource by version ID. This method can be used to retrieve a
// Binary resource version either by using the FHIR JSON mimetype as the value
// for the Accept header, or as a raw data stream. If the FHIR Accept type is
// used this method will return a Binary resource with the data base64-encoded,
// regardless of how the resource version was created. The resource data can be
// retrieved in base64-decoded form if the Accept type of the request matches
// the value of the resource version's `contentType` field. The definition of
// the Binary REST API can be found at https://hl7.org/fhir/binary.html#rest.
//
// - name: The name of the Binary resource version to retrieve.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BinaryVread(name string) *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-vread", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Binary-vread" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBinaryVreadCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ConsentEnforcementStatus: Returns the consent enforcement status of a single
// consent resource. On success, the response body contains a JSON-encoded
// representation of a `Parameters` (http://hl7.org/fhir/parameters.html) FHIR
// resource, containing the current enforcement status. Does not support DSTU2.
//
//   - name: The name of the consent resource to find enforcement status, in the
//     format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}/fhir/Consent/{consent_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ConsentEnforcementStatus(name string) *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/$consent-enforcement-status")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Consent-enforcement-status", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Consent-enforcement-status" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConsentEnforcementStatusCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// PatientConsentEnforcementStatus: Returns the consent enforcement status of
// all consent resources for a patient. On success, the response body contains
// a JSON-encoded representation of a bundle of `Parameters`
// (http://hl7.org/fhir/parameters.html) FHIR resources, containing the current
// enforcement status for each consent resource of the patient. Does not
// support DSTU2.
//
//   - name: The name of the patient to find enforcement statuses, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}/fhir/Patient/{patient_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) PatientConsentEnforcementStatus(name string) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Count sets the optional parameter "_count": The maximum number of results on
// a page. If not specified, 100 is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Count(Count int64) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.urlParams_.Set("_count", fmt.Sprint(Count))
	return c
}

// PageToken sets the optional parameter "_page_token": Used to retrieve the
// first, previous, next, or last page of consent enforcement statuses when
// using pagination. Value should be set to the value of `_page_token` set in
// next or previous page links' URLs. Next and previous page are returned in
// the response bundle's links field, where `link.relation` is "previous" or
// "next". Omit `_page_token` if no previous request has been made.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) PageToken(PageToken string) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.urlParams_.Set("_page_token", PageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/$consent-enforcement-status")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Patient-consent-enforcement-status", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Patient-consent-enforcement-status" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientConsentEnforcementStatusCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// PatientEverything: Retrieves a Patient resource and resources related to
// that patient. Implements the FHIR extended operation Patient-everything
// (DSTU2 (https://hl7.org/fhir/DSTU2/patient-operations.html#everything), STU3
// (https://hl7.org/fhir/STU3/patient-operations.html#everything), R4
// (https://hl7.org/fhir/R4/patient-operation-everything.html), R5
// (https://hl7.org/fhir/R5/patient-operation-everything.html)). On success,
// the response body contains a JSON-encoded representation of a `Bundle`
// resource of type `searchset`, containing the results of the operation.
// Errors generated by the FHIR store contain a JSON-encoded `OperationOutcome`
// resource describing the reason for the error. If the request cannot be
// mapped to a valid API method on a FHIR store, a generic GCP error might be
// returned instead. The resources in scope for the response are: * The patient
// resource itself. * All the resources directly referenced by the patient
// resource. * Resources directly referencing the patient resource that meet
// the inclusion criteria. The inclusion criteria are based on the membership
// rules in the patient compartment definition (DSTU2
// (http://hl7.org/fhir/DSTU2/compartment-patient.html), STU3
// (http://www.hl7.org/fhir/stu3/compartmentdefinition-patient.html), R4
// (http://hl7.org/fhir/R4/compartmentdefinition-patient.html), R5
// (http://hl7.org/fhir/R5/compartmentdefinition-patient.html)), which details
// the eligible resource types and referencing search parameters. For samples
// that show how to call `Patient-everything`, see Getting all patient
// compartment resources
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#getting_all_patient_compartment_resources).
//
//   - name: Name of the `Patient` resource for which the information is
//     required.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) PatientEverything(name string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Count sets the optional parameter "_count": Maximum number of resources in a
// page. If not specified, 100 is used. May not be larger than 1000.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Count(Count int64) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("_count", fmt.Sprint(Count))
	return c
}

// PageToken sets the optional parameter "_page_token": Used to retrieve the
// next or previous page of results when using pagination. Set `_page_token` to
// the value of _page_token set in next or previous page links' url. Next and
// previous page are returned in the response bundle's links field, where
// `link.relation` is "previous" or "next". Omit `_page_token` if no previous
// request has been made.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) PageToken(PageToken string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("_page_token", PageToken)
	return c
}

// Since sets the optional parameter "_since": If provided, only resources
// updated after this time are returned. The time uses the format
// YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example, `2015-02-07T13:28:17.239+02:00`
// or `2017-01-01T00:00:00Z`. The time must be specified to the second and
// include a time zone.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Since(Since string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("_since", Since)
	return c
}

// Type sets the optional parameter "_type": String of comma-delimited FHIR
// resource types. If provided, only resources of the specified resource
// type(s) are returned. Specifying multiple `_type` parameters isn't
// supported. For example, the result of `_type=Observation&_type=Encounter` is
// undefined. Use `_type=Observation,Encounter` instead.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Type(Type string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("_type", Type)
	return c
}

// End sets the optional parameter "end": The response includes records prior
// to the end date. The date uses the format YYYY-MM-DD. If no end date is
// provided, all records subsequent to the start date are in scope.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) End(end string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("end", end)
	return c
}

// Start sets the optional parameter "start": The response includes records
// subsequent to the start date. The date uses the format YYYY-MM-DD. If no
// start date is provided, all records prior to the end date are in scope.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Start(start string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("start", start)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/$everything")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Patient-everything", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Patient-everything" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatientEverythingCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ResourcePurge: Deletes all the historical versions of a resource (excluding
// the current version) from the FHIR store. To remove all versions of a
// resource, first delete the current version and then call this method. This
// is not a FHIR standard operation. For samples that show how to call
// `Resource-purge`, see Deleting historical versions of a FHIR resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#deleting_historical_versions_of_a_fhir_resource).
//
// - name: The name of the resource to purge.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ResourcePurge(name string) *ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/$purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Resource-purge", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Resource-purge" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourcePurgeCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Resource-purge", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall struct {
	s          *Service
	parent     string
	type_      string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ResourceValidate: Validates an input FHIR resource's conformance to its
// profiles and the profiles configured on the FHIR store. Implements the FHIR
// extended operation $validate (DSTU2
// (https://hl7.org/fhir/DSTU2/resource-operations.html#validate), STU3
// (https://hl7.org/fhir/STU3/resource-operations.html#validate), R4
// (https://hl7.org/fhir/R4/resource-operation-validate.html). or R5
// (https://hl7.org/fhir/R5/resource-operation-validate.html)). The request
// body must contain a JSON-encoded FHIR resource, and the request headers must
// contain `Content-Type: application/fhir+json`. The `Parameters` input syntax
// is not supported. The `profile` query parameter can be used to request that
// the resource only be validated against a specific profile. If a profile with
// the given URL cannot be found in the FHIR store then an error is returned.
// Errors generated by validation contain a JSON-encoded `OperationOutcome`
// resource describing the reason for the error. If the request cannot be
// mapped to a valid API method on a FHIR store, a generic GCP error might be
// returned instead.
//
//   - parent: The name of the FHIR store that holds the profiles being used for
//     validation.
//   - type: The FHIR resource type of the resource being validated. For a
//     complete list, see the FHIR Resource Index (DSTU2
//     (https://hl7.org/fhir/DSTU2/resourcelist.html), STU3
//     (https://hl7.org/fhir/STU3/resourcelist.html), R4
//     (https://hl7.org/fhir/R4/resourcelist.html), or R5
//     (https://hl7.org/fhir/R5/resourcelist.html)). Must match the resource type
//     in the provided content.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ResourceValidate(parent string, type_ string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.type_ = type_
	c.body_ = body_
	return c
}

// Profile sets the optional parameter "profile": The canonical URL of a
// profile that this resource should be validated against. For example, to
// validate a Patient resource against the US Core Patient profile this
// parameter would be
// `http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient`. A
// StructureDefinition with this canonical URL must exist in the FHIR store.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall) Profile(profile string) *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall {
	c.urlParams_.Set("profile", profile)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir/{+type}/$validate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
		"type":   c.type_,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.Resource-validate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.Resource-validate" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirResourceValidateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BulkExport: Bulk exports all resources from the FHIR store to the specified
// destination. Implements the FHIR implementation guide system level $export
// (https://build.fhir.org/ig/HL7/bulk-data/export.html#endpoint---system-level-export.
// The following headers must be set in the request: * `Accept`: specifies the
// format of the `OperationOutcome` response. Only `application/fhir+json` is
// supported. * `Prefer`: specifies whether the response is immediate or
// asynchronous. Must be to `respond-async` because only asynchronous responses
// are supported. Specify the destination for the server to write result files
// by setting the Cloud Storage location bulk_export_gcs_destination on the
// FHIR store. URI of an existing Cloud Storage directory where the server
// writes result files, in the format
// gs://{bucket-id}/{path/to/destination/dir}. If there is no trailing slash,
// the service appends one when composing the object path. The user is
// responsible for creating the Cloud Storage bucket referenced. Supports the
// following query parameters: * `_type`: string of comma-delimited FHIR
// resource types. If provided, only the resources of the specified type(s) are
// exported. * `_since`: if provided, only the resources that are updated after
// the specified time are exported. * `_outputFormat`: optional, specify ndjson
// to export data in NDJSON format. Exported file names use the format:
// {export_id}_{resource_type}.ndjson. On success, the `Content-Location`
// header of the response is set to a URL that the user can use to query the
// status of the export. The URL is in the format:
// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStor
// es/{fhir_store_id}/operations/{export_id}`. See get-fhir-operation-status
// for more information. Errors generated by the FHIR store contain a
// JSON-encoded `OperationOutcome` resource describing the reason for the
// error.
//
//   - name: The name of the FHIR store to export resources from, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) BulkExport(name string) *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Since sets the optional parameter "_since": If provided, only resources
// updated after this time are exported. The time uses the format
// YYYY-MM-DDThh:mm:ss.sss+zz:zz. For example, `2015-02-07T13:28:17.239+02:00`
// or `2017-01-01T00:00:00Z`. The time must be specified to the second and
// include a time zone.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) Since(Since string) *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall {
	c.urlParams_.Set("_since", Since)
	return c
}

// Type sets the optional parameter "_type": String of comma-delimited FHIR
// resource types. If provided, only resources of the specified resource
// type(s) are exported.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) Type(Type string) *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall {
	c.urlParams_.Set("_type", Type)
	return c
}

// OutputFormat sets the optional parameter "outputFormat": Output format of
// the export. This field is optional and only `application/fhir+ndjson` is
// supported.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) OutputFormat(outputFormat string) *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall {
	c.urlParams_.Set("outputFormat", outputFormat)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/fhir/$export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.bulk-export", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.bulk-export" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirBulkExportCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Capabilities: Gets the FHIR capability statement (STU3
// (https://hl7.org/fhir/STU3/capabilitystatement.html), R4
// (https://hl7.org/fhir/R4/capabilitystatement.html), R5
// (https://hl7.org/fhir/R5/capabilitystatement.html)), or the conformance
// statement (https://hl7.org/fhir/DSTU2/conformance.html) in the DSTU2 case
// for the store, which contains a description of functionality supported by
// the server. Implements the FHIR standard capabilities interaction (STU3
// (https://hl7.org/fhir/STU3/http.html#capabilities), R4
// (https://hl7.org/fhir/R4/http.html#capabilities), R5
// (https://hl7.org/fhir/R5/http.html#capabilities)), or the conformance
// interaction (https://hl7.org/fhir/DSTU2/http.html#conformance) in the DSTU2
// case. On success, the response body contains a JSON-encoded representation
// of a `CapabilityStatement` resource.
//
// - name: Name of the FHIR store to retrieve the capabilities for.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) Capabilities(name string) *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/fhir/metadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.capabilities", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.capabilities" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCapabilitiesCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall struct {
	s          *Service
	parent     string
	type_      string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ConditionalDelete: Deletes a FHIR resource that match an identifier search
// query. Implements the FHIR standard conditional delete interaction, limited
// to searching by resource identifier. If multiple resources match, 412
// Precondition Failed error will be returned. Search term for identifier
// should be in the pattern `identifier=system|value` or `identifier=value` -
// similar to the `search` method on resources with a specific identifier.
// Note: Unless resource versioning is disabled by setting the
// disable_resource_versioning flag on the FHIR store, the deleted resource is
// moved to a history repository that can still be retrieved through vread and
// related methods, unless they are removed by the purge method. For samples
// that show how to call `conditionalDelete`, see Conditionally deleting a FHIR
// resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#conditionally_deleting_a_fhir_resource).
//
//   - parent: The name of the FHIR store this resource belongs to.
//   - type: The FHIR resource type to delete, such as Patient or Observation.
//     For a complete list, see the FHIR Resource Index (DSTU2
//     (https://hl7.org/fhir/DSTU2/resourcelist.html), STU3
//     (https://hl7.org/fhir/STU3/resourcelist.html), R4
//     (https://hl7.org/fhir/R4/resourcelist.html), R5
//     (https://hl7.org/fhir/R5/resourcelist.html)).
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ConditionalDelete(parent string, type_ string) *ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.type_ = type_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir/{+type}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
		"type":   c.type_,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.conditionalDelete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.conditionalDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.conditionalDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall struct {
	s          *Service
	parent     string
	type_      string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ConditionalPatch: If a resource is found with the identifier specified in
// the query parameters, updates part of that resource by applying the
// operations specified in a JSON Patch (http://jsonpatch.com/) document.
// Implements the FHIR standard conditional patch interaction, limited to
// searching by resource identifier. DSTU2 doesn't define a conditional patch
// method, but the server supports it in the same way it supports STU3. Search
// term for identifier should be in the pattern `identifier=system|value` or
// `identifier=value` - similar to the `search` method on resources with a
// specific identifier. If the search criteria identify more than one match,
// the request returns a `412 Precondition Failed` error. The request body must
// contain a JSON Patch document, and the request headers must contain
// `Content-Type: application/json-patch+json`. On success, the response body
// contains a JSON-encoded representation of the updated resource, including
// the server-assigned version ID. Errors generated by the FHIR store contain a
// JSON-encoded `OperationOutcome` resource describing the reason for the
// error. If the request cannot be mapped to a valid API method on a FHIR
// store, a generic GCP error might be returned instead. For samples that show
// how to call `conditionalPatch`, see Conditionally patching a FHIR resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#conditionally_patching_a_fhir_resource).
//
//   - parent: The name of the FHIR store this resource belongs to.
//   - type: The FHIR resource type to update, such as Patient or Observation.
//     For a complete list, see the FHIR Resource Index (DSTU2
//     (https://hl7.org/fhir/DSTU2/resourcelist.html), STU3
//     (https://hl7.org/fhir/STU3/resourcelist.html), R4
//     (https://hl7.org/fhir/R4/resourcelist.html), R5
//     (https://hl7.org/fhir/R5/resourcelist.html)).
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ConditionalPatch(parent string, type_ string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.type_ = type_
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir/{+type}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
		"type":   c.type_,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.conditionalPatch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.conditionalPatch" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalPatchCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall struct {
	s          *Service
	parent     string
	type_      string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ConditionalUpdate: If a resource is found with the identifier specified in
// the query parameters, updates the entire contents of that resource.
// Implements the FHIR standard conditional update interaction, limited to
// searching by resource identifier. Search term for identifier should be in
// the pattern `identifier=system|value` or `identifier=value` - similar to the
// `search` method on resources with a specific identifier. If the search
// criteria identify more than one match, the request returns a `412
// Precondition Failed` error. If the search criteria identify zero matches,
// and the supplied resource body contains an `id`, and the FHIR store has
// enable_update_create set, creates the resource with the client-specified ID.
// It is strongly advised not to include or encode any sensitive data such as
// patient identifiers in client-specified resource IDs. Those IDs are part of
// the FHIR resource path recorded in Cloud Audit Logs and Pub/Sub
// notifications. Those IDs can also be contained in reference fields within
// other resources. If the search criteria identify zero matches, and the
// supplied resource body does not contain an `id`, the resource is created
// with a server-assigned ID as per the create method. The request body must
// contain a JSON-encoded FHIR resource, and the request headers must contain
// `Content-Type: application/fhir+json`. On success, the response body
// contains a JSON-encoded representation of the updated resource, including
// the server-assigned version ID. Errors generated by the FHIR store contain a
// JSON-encoded `OperationOutcome` resource describing the reason for the
// error. If the request cannot be mapped to a valid API method on a FHIR
// store, a generic GCP error might be returned instead. For samples that show
// how to call `conditionalUpdate`, see Conditionally updating a FHIR resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#conditionally_updating_a_fhir_resource).
//
//   - parent: The name of the FHIR store this resource belongs to.
//   - type: The FHIR resource type to update, such as Patient or Observation.
//     For a complete list, see the FHIR Resource Index (DSTU2
//     (https://hl7.org/fhir/DSTU2/resourcelist.html), STU3
//     (https://hl7.org/fhir/STU3/resourcelist.html), R4
//     (https://hl7.org/fhir/R4/resourcelist.html), R5
//     (https://hl7.org/fhir/R5/resourcelist.html)). Must match the resource type
//     in the provided content.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ConditionalUpdate(parent string, type_ string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.type_ = type_
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir/{+type}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
		"type":   c.type_,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.conditionalUpdate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.conditionalUpdate" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirCreateCall struct {
	s          *Service
	parent     string
	type_      string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a FHIR resource. Implements the FHIR standard create
// interaction (DSTU2 (https://hl7.org/fhir/DSTU2/http.html#create), STU3
// (https://hl7.org/fhir/STU3/http.html#create), R4
// (https://hl7.org/fhir/R4/http.html#create), R5
// (https://hl7.org/fhir/R5/http.html#create)), which creates a new resource
// with a server-assigned resource ID. Also supports the FHIR standard
// conditional create interaction (DSTU2
// (https://hl7.org/fhir/DSTU2/http.html#ccreate), STU3
// (https://hl7.org/fhir/STU3/http.html#ccreate), R4
// (https://hl7.org/fhir/R4/http.html#ccreate), R5
// (https://hl7.org/fhir/R5/http.html#ccreate)), specified by supplying an
// `If-None-Exist` header containing a FHIR search query, limited to searching
// by resource identifier. If no resources match this search query, the server
// processes the create operation as normal. When using conditional create, the
// search term for identifier should be in the pattern
// `identifier=system|value` or `identifier=value` - similar to the `search`
// method on resources with a specific identifier. The request body must
// contain a JSON-encoded FHIR resource, and the request headers must contain
// `Content-Type: application/fhir+json`. On success, the response body
// contains a JSON-encoded representation of the resource as it was created on
// the server, including the server-assigned resource ID and version ID. Errors
// generated by the FHIR store contain a JSON-encoded `OperationOutcome`
// resource describing the reason for the error. If the request cannot be
// mapped to a valid API method on a FHIR store, a generic GCP error might be
// returned instead. For samples that show how to call `create`, see Creating a
// FHIR resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#creating_a_fhir_resource).
//
//   - parent: The name of the FHIR store this resource belongs to.
//   - type: The FHIR resource type to create, such as Patient or Observation.
//     For a complete list, see the FHIR Resource Index (DSTU2
//     (https://hl7.org/fhir/DSTU2/resourcelist.html), STU3
//     (https://hl7.org/fhir/STU3/resourcelist.html), R4
//     (https://hl7.org/fhir/R4/resourcelist.html), R5
//     (https://hl7.org/fhir/R5/resourcelist.html)). Must match the resource type
//     in the provided content.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) Create(parent string, type_ string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirCreateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.type_ = type_
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir/{+type}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
		"type":   c.type_,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.create" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirCreateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a FHIR resource. Implements the FHIR standard delete
// interaction (DSTU2 (https://hl7.org/fhir/DSTU2/http.html#delete), STU3
// (https://hl7.org/fhir/STU3/http.html#delete), R4
// (https://hl7.org/fhir/R4/http.html#delete), R5
// (https://hl7.org/fhir/R5/http.html#delete)). Note: Unless resource
// versioning is disabled by setting the disable_resource_versioning flag on
// the FHIR store, the deleted resources will be moved to a history repository
// that can still be retrieved through vread and related methods, unless they
// are removed by the purge method. For samples that show how to call `delete`,
// see Deleting a FHIR resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#deleting_a_fhir_resource).
//
// - name: The name of the resource to delete.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) Delete(name string) *ProjectsLocationsDatasetsFhirStoresFhirDeleteCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.delete" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirDeleteCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall struct {
	s          *Service
	parent     string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ExecuteBundle: Executes all the requests in the given Bundle. Implements the
// FHIR standard batch/transaction interaction (DSTU2
// (https://hl7.org/fhir/DSTU2/http.html#transaction), STU3
// (https://hl7.org/fhir/STU3/http.html#transaction), R4
// (https://hl7.org/fhir/R4/http.html#transaction), R5
// (https://hl7.org/fhir/R5/http.html#transaction)). Supports all interactions
// within a bundle, except search. This method accepts Bundles of type `batch`
// and `transaction`, processing them according to the batch processing rules
// (DSTU2 (https://hl7.org/fhir/DSTU2/http.html#2.1.0.16.1), STU3
// (https://hl7.org/fhir/STU3/http.html#2.21.0.17.1), R4
// (https://hl7.org/fhir/R4/http.html#brules), R5
// (https://hl7.org/fhir/R5/http.html#brules)) and transaction processing rules
// (DSTU2 (https://hl7.org/fhir/DSTU2/http.html#2.1.0.16.2), STU3
// (https://hl7.org/fhir/STU3/http.html#2.21.0.17.2), R4
// (https://hl7.org/fhir/R4/http.html#trules), R5
// (https://hl7.org/fhir/R5/http.html#trules)). The request body must contain a
// JSON-encoded FHIR `Bundle` resource, and the request headers must contain
// `Content-Type: application/fhir+json`. For a batch bundle or a successful
// transaction, the response body contains a JSON-encoded representation of a
// `Bundle` resource of type `batch-response` or `transaction-response`
// containing one entry for each entry in the request, with the outcome of
// processing the entry. In the case of an error for a transaction bundle, the
// response body contains a JSON-encoded `OperationOutcome` resource describing
// the reason for the error. If the request cannot be mapped to a valid API
// method on a FHIR store, a generic GCP error might be returned instead. This
// method checks permissions for each request in the bundle. The
// `executeBundle` permission is required to call this method, but you must
// also grant sufficient permissions to execute the individual requests in the
// bundle. For example, if the bundle contains a request to create a FHIR
// resource, the caller must also have been granted the
// `healthcare.fhirResources.create` permission. You can use audit logs to view
// the permissions for `executeBundle` and each request in the bundle. For more
// information, see Viewing Cloud Audit logs
// (https://cloud.google.com/healthcare-api/docs/how-tos/audit-logging). For
// samples that show how to call `executeBundle`, see Managing FHIR resources
// using FHIR bundles
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-bundles).
//
// - parent: Name of the FHIR store in which this bundle will be executed.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) ExecuteBundle(parent string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.executeBundle", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.executeBundle" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirExecuteBundleCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirHistoryCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// History: Lists all the versions of a resource (including the current version
// and deleted versions) from the FHIR store. Implements the per-resource form
// of the FHIR standard history interaction (DSTU2
// (https://hl7.org/fhir/DSTU2/http.html#history), STU3
// (https://hl7.org/fhir/STU3/http.html#history), R4
// (https://hl7.org/fhir/R4/http.html#history), R5
// (https://hl7.org/fhir/R5/http.html#history)). On success, the response body
// contains a JSON-encoded representation of a `Bundle` resource of type
// `history`, containing the version history sorted from most recent to oldest
// versions. Errors generated by the FHIR store contain a JSON-encoded
// `OperationOutcome` resource describing the reason for the error. If the
// request cannot be mapped to a valid API method on a FHIR store, a generic
// GCP error might be returned instead. For samples that show how to call
// `history`, see Listing FHIR resource versions
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#listing_fhir_resource_versions).
//
// - name: The name of the resource to retrieve.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) History(name string) *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirHistoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// At sets the optional parameter "_at": Only include resource versions that
// were current at some point during the time period specified in the date time
// value. The date parameter format is yyyy-mm-ddThh:mm:ss[Z|(+|-)hh:mm]
// Clients may specify any of the following: * An entire year: `_at=2019` * An
// entire month: `_at=2019-01` * A specific day: `_at=2019-01-20` * A specific
// second: `_at=2018-12-31T23:59:58Z`
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) At(At string) *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall {
	c.urlParams_.Set("_at", At)
	return c
}

// Count sets the optional parameter "_count": The maximum number of search
// results on a page. If not specified, 100 is used. May not be larger than
// 1000.
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) Count(Count int64) *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall {
	c.urlParams_.Set("_count", fmt.Sprint(Count))
	return c
}

// PageToken sets the optional parameter "_page_token": Used to retrieve the
// first, previous, next, or last page of resource versions when using
// pagination. Value should be set to the value of `_page_token` set in next or
// previous page links' URLs. Next and previous page are returned in the
// response bundle's links field, where `link.relation` is "previous" or
// "next". Omit `_page_token` if no previous request has been made.
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) PageToken(PageToken string) *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall {
	c.urlParams_.Set("_page_token", PageToken)
	return c
}

// Since sets the optional parameter "_since": Only include resource versions
// that were created at or after the given instant in time. The instant in time
// uses the format YYYY-MM-DDThh:mm:ss.sss+zz:zz (for example
// 2015-02-07T13:28:17.239+02:00 or 2017-01-01T00:00:00Z). The time must be
// specified to the second and include a time zone.
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) Since(Since string) *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall {
	c.urlParams_.Set("_since", Since)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/_history")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.history", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.history" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirHistoryCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirPatchCall struct {
	s          *Service
	name       string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates part of an existing resource by applying the operations
// specified in a JSON Patch (http://jsonpatch.com/) document. Implements the
// FHIR standard patch interaction (STU3
// (https://hl7.org/fhir/STU3/http.html#patch), R4
// (https://hl7.org/fhir/R4/http.html#patch), R5
// (https://hl7.org/fhir/R5/http.html#patch)). DSTU2 doesn't define a patch
// method, but the server supports it in the same way it supports STU3. The
// request body must contain a JSON Patch document, and the request headers
// must contain `Content-Type: application/json-patch+json`. On success, the
// response body contains a JSON-encoded representation of the updated
// resource, including the server-assigned version ID. Errors generated by the
// FHIR store contain a JSON-encoded `OperationOutcome` resource describing the
// reason for the error. If the request cannot be mapped to a valid API method
// on a FHIR store, a generic GCP error might be returned instead. For samples
// that show how to call `patch`, see Patching a FHIR resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#patching_a_fhir_resource).
//
// - name: The name of the resource to update.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) Patch(name string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirPatchCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.patch" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirPatchCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirReadCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Read: Gets the contents of a FHIR resource. Implements the FHIR standard
// read interaction (DSTU2 (https://hl7.org/fhir/DSTU2/http.html#read), STU3
// (https://hl7.org/fhir/STU3/http.html#read), R4
// (https://hl7.org/fhir/R4/http.html#read), R5
// (https://hl7.org/fhir/R5/http.html#read)). Also supports the FHIR standard
// conditional read interaction (DSTU2
// (https://hl7.org/fhir/DSTU2/http.html#cread), STU3
// (https://hl7.org/fhir/STU3/http.html#cread), R4
// (https://hl7.org/fhir/R4/http.html#cread), R5
// (https://hl7.org/fhir/R5/http.html#cread)) specified by supplying an
// `If-Modified-Since` header with a date/time value or an `If-None-Match`
// header with an ETag value. On success, the response body contains a
// JSON-encoded representation of the resource. Errors generated by the FHIR
// store contain a JSON-encoded `OperationOutcome` resource describing the
// reason for the error. If the request cannot be mapped to a valid API method
// on a FHIR store, a generic GCP error might be returned instead. For samples
// that show how to call `read`, see Getting a FHIR resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#getting_a_fhir_resource).
//
// - name: The name of the resource to retrieve.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) Read(name string) *ProjectsLocationsDatasetsFhirStoresFhirReadCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirReadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirReadCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirReadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirReadCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirReadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirReadCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirReadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirReadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirReadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.read", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.read" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirReadCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirSearchCall struct {
	s                      *Service
	parent                 string
	searchresourcesrequest *SearchResourcesRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Search: Searches for resources in the given FHIR store according to criteria
// specified as query parameters. Implements the FHIR standard search
// interaction (DSTU2 (https://hl7.org/fhir/DSTU2/http.html#search), STU3
// (https://hl7.org/fhir/STU3/http.html#search), R4
// (https://hl7.org/fhir/R4/http.html#search), R5
// (https://hl7.org/fhir/R5/http.html#search)) using the search semantics
// described in the FHIR Search specification (DSTU2
// (https://hl7.org/fhir/DSTU2/search.html), STU3
// (https://hl7.org/fhir/STU3/search.html), R4
// (https://hl7.org/fhir/R4/search.html), R5
// (https://hl7.org/fhir/R5/search.html)). Supports four methods of search
// defined by the specification: * `GET [base]?[parameters]` to search across
// all resources. * `GET [base]/[type]?[parameters]` to search resources of a
// specified type. * `POST [base]/_search?[parameters]` as an alternate form
// having the same semantics as the `GET` method across all resources. * `POST
// [base]/[type]/_search?[parameters]` as an alternate form having the same
// semantics as the `GET` method for the specified type. The `GET` and `POST`
// methods do not support compartment searches. The `POST` method does not
// support `application/x-www-form-urlencoded` search parameters. On success,
// the response body contains a JSON-encoded representation of a `Bundle`
// resource of type `searchset`, containing the results of the search. Errors
// generated by the FHIR store contain a JSON-encoded `OperationOutcome`
// resource describing the reason for the error. If the request cannot be
// mapped to a valid API method on a FHIR store, a generic GCP error might be
// returned instead. The server's capability statement, retrieved through
// capabilities, indicates what search parameters are supported on each FHIR
// resource. A list of all search parameters defined by the specification can
// be found in the FHIR Search Parameter Registry (STU3
// (https://hl7.org/fhir/STU3/searchparameter-registry.html), R4
// (https://hl7.org/fhir/R4/searchparameter-registry.html), R5
// (https://hl7.org/fhir/R5/searchparameter-registry.html)). FHIR search
// parameters for DSTU2 can be found on each resource's definition page.
// Supported search modifiers: `:missing`, `:exact`, `:contains`, `:text`,
// `:in`, `:not-in`, `:above`, `:below`, `:[type]`, `:not`, and `recurse`
// (DSTU2 and STU3) or `:iterate` (R4 and R5). Supported search result
// parameters: `_sort`, `_count`, `_include`, `_revinclude`, `_summary=text`,
// `_summary=data`, and `_elements`. The maximum number of search results
// returned defaults to 100, which can be overridden by the `_count` parameter
// up to a maximum limit of 1000. The server might return fewer resources than
// requested to prevent excessively large responses. If there are additional
// results, the returned `Bundle` contains a link of `relation` "next", which
// has a `_page_token` parameter for an opaque pagination token that can be
// used to retrieve the next page. Resources with a total size larger than 5MB
// or a field count larger than 50,000 might not be fully searchable as the
// server might trim its generated search index in those cases. Note: FHIR
// resources are indexed asynchronously, so there might be a slight delay
// between the time a resource is created or changed, and the time when the
// change reflects in search results. The only exception is resource identifier
// data, which is indexed synchronously as a special index. As a result,
// searching using resource identifier is not subject to indexing delay. To use
// the special synchronous index, the search term for identifier should be in
// the pattern `identifier=[system]|[value]` or `identifier=[value]`, and any
// of the following search result parameters can be used: * `_count` *
// `_include` * `_revinclude` * `_summary` * `_elements` If your query contains
// any other search parameters, the standard asynchronous index will be used
// instead. Note that searching against the special index is optimized for
// resolving a small number of matches. The search isn't optimized if your
// identifier search criteria matches a large number (i.e. more than 2,000) of
// resources. For a search query that will match a large number of resources,
// you can avoiding using the special synchronous index by including an
// additional `_sort` parameter in your query. Use `_sort=-_lastUpdated` if you
// want to keep the default sorting order. Note: The special synchronous
// identifier index are currently disabled for DocumentReference and
// DocumentManifest searches. For samples and detailed information, see
// Searching for FHIR resources
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-search) and Advanced
// FHIR search features
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-advanced-search).
//
// - parent: Name of the FHIR store to retrieve resources from.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) Search(parent string, searchresourcesrequest *SearchResourcesRequest) *ProjectsLocationsDatasetsFhirStoresFhirSearchCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.searchresourcesrequest = searchresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.searchresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir/_search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.search", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.search" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall struct {
	s                      *Service
	parent                 string
	resourceType           string
	searchresourcesrequest *SearchResourcesRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SearchType: Searches for resources in the given FHIR store according to
// criteria specified as query parameters. Implements the FHIR standard search
// interaction (DSTU2 (https://hl7.org/fhir/DSTU2/http.html#search), STU3
// (https://hl7.org/fhir/STU3/http.html#search), R4
// (https://hl7.org/fhir/R4/http.html#search), R5
// (https://hl7.org/fhir/R5/http.html#search)) using the search semantics
// described in the FHIR Search specification (DSTU2
// (https://hl7.org/fhir/DSTU2/search.html), STU3
// (https://hl7.org/fhir/STU3/search.html), R4
// (https://hl7.org/fhir/R4/search.html), R5
// (https://hl7.org/fhir/R5/search.html)). Supports four methods of search
// defined by the specification: * `GET [base]?[parameters]` to search across
// all resources. * `GET [base]/[type]?[parameters]` to search resources of a
// specified type. * `POST [base]/_search?[parameters]` as an alternate form
// having the same semantics as the `GET` method across all resources. * `POST
// [base]/[type]/_search?[parameters]` as an alternate form having the same
// semantics as the `GET` method for the specified type. The `GET` and `POST`
// methods do not support compartment searches. The `POST` method does not
// support `application/x-www-form-urlencoded` search parameters. On success,
// the response body contains a JSON-encoded representation of a `Bundle`
// resource of type `searchset`, containing the results of the search. Errors
// generated by the FHIR store contain a JSON-encoded `OperationOutcome`
// resource describing the reason for the error. If the request cannot be
// mapped to a valid API method on a FHIR store, a generic GCP error might be
// returned instead. The server's capability statement, retrieved through
// capabilities, indicates what search parameters are supported on each FHIR
// resource. A list of all search parameters defined by the specification can
// be found in the FHIR Search Parameter Registry (STU3
// (https://hl7.org/fhir/STU3/searchparameter-registry.html), R4
// (https://hl7.org/fhir/R4/searchparameter-registry.html), R5
// (https://hl7.org/fhir/R5/searchparameter-registry.html)). FHIR search
// parameters for DSTU2 can be found on each resource's definition page.
// Supported search modifiers: `:missing`, `:exact`, `:contains`, `:text`,
// `:in`, `:not-in`, `:above`, `:below`, `:[type]`, `:not`, and `recurse`
// (DSTU2 and STU3) or `:iterate` (R4 and R5). Supported search result
// parameters: `_sort`, `_count`, `_include`, `_revinclude`, `_summary=text`,
// `_summary=data`, and `_elements`. The maximum number of search results
// returned defaults to 100, which can be overridden by the `_count` parameter
// up to a maximum limit of 1000. The server might return fewer resources than
// requested to prevent excessively large responses. If there are additional
// results, the returned `Bundle` contains a link of `relation` "next", which
// has a `_page_token` parameter for an opaque pagination token that can be
// used to retrieve the next page. Resources with a total size larger than 5MB
// or a field count larger than 50,000 might not be fully searchable as the
// server might trim its generated search index in those cases. Note: FHIR
// resources are indexed asynchronously, so there might be a slight delay
// between the time a resource is created or changed, and the time when the
// change reflects in search results. The only exception is resource identifier
// data, which is indexed synchronously as a special index. As a result,
// searching using resource identifier is not subject to indexing delay. To use
// the special synchronous index, the search term for identifier should be in
// the pattern `identifier=[system]|[value]` or `identifier=[value]`, and any
// of the following search result parameters can be used: * `_count` *
// `_include` * `_revinclude` * `_summary` * `_elements` If your query contains
// any other search parameters, the standard asynchronous index will be used
// instead. Note that searching against the special index is optimized for
// resolving a small number of matches. The search isn't optimized if your
// identifier search criteria matches a large number (i.e. more than 2,000) of
// resources. For a search query that will match a large number of resources,
// you can avoiding using the special synchronous index by including an
// additional `_sort` parameter in your query. Use `_sort=-_lastUpdated` if you
// want to keep the default sorting order. Note: The special synchronous
// identifier index are currently disabled for DocumentReference and
// DocumentManifest searches. For samples and detailed information, see
// Searching for FHIR resources
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-search) and Advanced
// FHIR search features
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-advanced-search).
//
//   - parent: Name of the FHIR store to retrieve resources from.
//   - resourceType: Optional. The FHIR resource type to search, such as Patient
//     or Observation. For a complete list, see the FHIR Resource Index (DSTU2
//     (https://hl7.org/fhir/DSTU2/resourcelist.html), STU3
//     (https://hl7.org/fhir/STU3/resourcelist.html), R4
//     (https://hl7.org/fhir/R4/resourcelist.html)), R5
//     (https://hl7.org/fhir/R5/resourcelist.html)).
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) SearchType(parent string, resourceType string, searchresourcesrequest *SearchResourcesRequest) *ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.resourceType = resourceType
	c.searchresourcesrequest = searchresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.searchresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/fhir/{resourceType}/_search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"resourceType": c.resourceType,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.search-type", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.search-type" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirSearchTypeCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirUpdateCall struct {
	s          *Service
	name       string
	body_      io.Reader
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the entire contents of a resource. Implements the FHIR
// standard update interaction (DSTU2
// (https://hl7.org/fhir/DSTU2/http.html#update), STU3
// (https://hl7.org/fhir/STU3/http.html#update), R4
// (https://hl7.org/fhir/R4/http.html#update), R5
// (https://hl7.org/fhir/R5/http.html#update)). If the specified resource does
// not exist and the FHIR store has enable_update_create set, creates the
// resource with the client-specified ID. It is strongly advised not to include
// or encode any sensitive data such as patient identifiers in client-specified
// resource IDs. Those IDs are part of the FHIR resource path recorded in Cloud
// Audit Logs and Pub/Sub notifications. Those IDs can also be contained in
// reference fields within other resources. The request body must contain a
// JSON-encoded FHIR resource, and the request headers must contain
// `Content-Type: application/fhir+json`. The resource must contain an `id`
// element having an identical value to the ID in the REST path of the request.
// On success, the response body contains a JSON-encoded representation of the
// updated resource, including the server-assigned version ID. Errors generated
// by the FHIR store contain a JSON-encoded `OperationOutcome` resource
// describing the reason for the error. If the request cannot be mapped to a
// valid API method on a FHIR store, a generic GCP error might be returned
// instead. The conditional update interaction If-None-Match is supported,
// including the wildcard behaviour, as defined by the R5 spec. This
// functionality is supported in R4 and R5. For samples that show how to call
// `update`, see Updating a FHIR resource
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#updating_a_fhir_resource).
//
// - name: The name of the resource to update.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) Update(name string, body_ io.Reader) *ProjectsLocationsDatasetsFhirStoresFhirUpdateCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.body_ = body_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirUpdateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	body := bytes.NewBuffer(nil)
	_, err := body.ReadFrom(c.body_)
	if err != nil {
		return nil, err
	}
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.update" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirUpdateCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresFhirVreadCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Vread: Gets the contents of a version (current or historical) of a FHIR
// resource by version ID. Implements the FHIR standard vread interaction
// (DSTU2 (https://hl7.org/fhir/DSTU2/http.html#vread), STU3
// (https://hl7.org/fhir/STU3/http.html#vread), R4
// (https://hl7.org/fhir/R4/http.html#vread), R5
// (https://hl7.org/fhir/R5/http.html#vread)). On success, the response body
// contains a JSON-encoded representation of the resource. Errors generated by
// the FHIR store contain a JSON-encoded `OperationOutcome` resource describing
// the reason for the error. If the request cannot be mapped to a valid API
// method on a FHIR store, a generic GCP error might be returned instead. For
// samples that show how to call `vread`, see Retrieving a FHIR resource
// version
// (https://cloud.google.com/healthcare/docs/how-tos/fhir-resources#retrieving_a_fhir_resource_version).
//
// - name: The name of the resource version to retrieve.
func (r *ProjectsLocationsDatasetsFhirStoresFhirService) Vread(name string) *ProjectsLocationsDatasetsFhirStoresFhirVreadCall {
	c := &ProjectsLocationsDatasetsFhirStoresFhirVreadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresFhirVreadCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresFhirVreadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirVreadCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresFhirVreadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresFhirVreadCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresFhirVreadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresFhirVreadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresFhirVreadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.fhir.vread", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.fhir.vread" call.
func (c *ProjectsLocationsDatasetsFhirStoresFhirVreadCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// DeleteFhirOperation: Deletes operations as defined in the FHIR
// specification. Implements the FHIR implementation guide bulk data delete
// request
// (https://build.fhir.org/ig/HL7/bulk-data/export.html#bulk-data-delete-request).
// Returns success if the operation was successfully cancelled. If the
// operation is complete, or has already been cancelled, returns an error
// response.
//
//   - name: Name of the operation to be deleted, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}/operations/{operation_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresOperationsService) DeleteFhirOperation(name string) *ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall {
	c := &ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.operations.delete-fhir-operation", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.operations.delete-fhir-operation" call.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsDeleteFhirOperationCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetFhirOperationStatus: Gets the status of operations as defined in the FHIR
// specification. Implements the FHIR implementation guide bulk data status
// request
// (https://build.fhir.org/ig/HL7/bulk-data/export.html#bulk-data-status-request).
// Operations can have one of these states: * in-progress: response status code
// is `202` and `X-Progress` header is set to `in progress`. * complete:
// response status code is `200` and the body is a JSON-encoded operation
// response as defined by the spec. For a bulk export, this response is defined
// in
// https://build.fhir.org/ig/HL7/bulk-data/export.html#response---complete-status.
// * error: response status code is `5XX`, and the body is a JSON-encoded
// `OperationOutcome` resource describing the reason for the error.
//
//   - name: Name of the operation to query, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirSt
//     ores/{fhir_store_id}/operations/{operation_id}`.
func (r *ProjectsLocationsDatasetsFhirStoresOperationsService) GetFhirOperationStatus(name string) *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall {
	c := &ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall) Context(ctx context.Context) *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.fhirStores.operations.get-fhir-operation-status", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.fhirStores.operations.get-fhir-operation-status" call.
func (c *ProjectsLocationsDatasetsFhirStoresOperationsGetFhirOperationStatusCall) Do(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	return c.doRequest("")
}

type ProjectsLocationsDatasetsHl7V2StoresCreateCall struct {
	s          *Service
	parent     string
	hl7v2store *Hl7V2Store
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new HL7v2 store within the parent dataset.
//
// - parent: The name of the dataset this HL7v2 store belongs to.
func (r *ProjectsLocationsDatasetsHl7V2StoresService) Create(parent string, hl7v2store *Hl7V2Store) *ProjectsLocationsDatasetsHl7V2StoresCreateCall {
	c := &ProjectsLocationsDatasetsHl7V2StoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.hl7v2store = hl7v2store
	return c
}

// Hl7V2StoreId sets the optional parameter "hl7V2StoreId": Required. The ID of
// the HL7v2 store that is being created. The string must match the following
// regex: `[\p{L}\p{N}_\-\.]{1,256}`.
func (c *ProjectsLocationsDatasetsHl7V2StoresCreateCall) Hl7V2StoreId(hl7V2StoreId string) *ProjectsLocationsDatasetsHl7V2StoresCreateCall {
	c.urlParams_.Set("hl7V2StoreId", hl7V2StoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsHl7V2StoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsHl7V2StoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsHl7V2StoresCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsHl7V2StoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsHl7V2StoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsHl7V2StoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.hl7v2store)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/hl7V2Stores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.hl7V2Stores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Hl7V2Store.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsHl7V2StoresCreateCall) Do(opts ...googleapi.CallOption) (*Hl7V2Store, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Hl7V2Store{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsHl7V2StoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified HL7v2 store and removes all messages that it
// contains.
//
// - name: The resource name of the HL7v2 store to delete.
func (r *ProjectsLocationsDatasetsHl7V2StoresService) Delete(name string) *ProjectsLocationsDatasetsHl7V2StoresDeleteCall {
	c := &ProjectsLocationsDatasetsHl7V2StoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsHl7V2StoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsHl7V2StoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsHl7V2StoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsHl7V2StoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsHl7V2StoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsHl7V2StoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.hl7V2Stores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsHl7V2StoresDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsHl7V2StoresExportCall struct {
	s                     *Service
	name                  string
	exportmessagesrequest *ExportMessagesRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Export: Exports the messages to a destination. To filter messages to be
// exported, define a filter using the start and end time, relative to the
// message generation time (MSH.7). This API returns an Operation that can be
// used to track the status of the job by calling GetOperation. Immediate fatal
// errors appear in the error field. Otherwise, when the operation finishes, a
// detailed response of type ExportMessagesResponse is returned in the response
// field. The metadata field type for this operation is OperationMetadata.
//
//   - name: The name of the source HL7v2 store, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/hl7v2S
//     tores/{hl7v2_store_id}`.
func (r *ProjectsLocationsDatasetsHl7V2StoresService) Export(name string, exportmessagesrequest *ExportMessagesRequest) *ProjectsLocationsDatasetsHl7V2StoresExportCall {
	c := &ProjectsLocationsDatasetsHl7V2StoresExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exportmessagesrequest = exportmessagesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsHl7V2StoresExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsHl7V2StoresExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsHl7V2StoresExportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsHl7V2StoresExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsHl7V2StoresExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsHl7V2StoresExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exportmessagesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.export", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.hl7V2Stores.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsHl7V2StoresExportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.export", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsHl7V2StoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified HL7v2 store.
//
// - name: The resource name of the HL7v2 store to get.
func (r *ProjectsLocationsDatasetsHl7V2StoresService) Get(name string) *ProjectsLocationsDatasetsHl7V2StoresGetCall {
	c := &ProjectsLocationsDatasetsHl7V2StoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsHl7V2StoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsHl7V2StoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsHl7V2StoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsHl7V2StoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.hl7V2Stores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Hl7V2Store.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetCall) Do(opts ...googleapi.CallOption) (*Hl7V2Store, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Hl7V2Store{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetHL7v2StoreMetrics: Gets metrics associated with the HL7v2 store.
//
//   - name: The resource name of the HL7v2 store to get metrics for, in the
//     format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/hl7V2S
//     tores/{hl7v2_store_id}`.
func (r *ProjectsLocationsDatasetsHl7V2StoresService) GetHL7v2StoreMetrics(name string) *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall {
	c := &ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall) Context(ctx context.Context) *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getHL7v2StoreMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.getHL7v2StoreMetrics", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.hl7V2Stores.getHL7v2StoreMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *Hl7V2StoreMetrics.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetHL7v2StoreMetricsCall) Do(opts ...googleapi.CallOption) (*Hl7V2StoreMetrics, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Hl7V2StoreMetrics{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.getHL7v2StoreMetrics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsDatasetsHl7V2StoresService) GetIamPolicy(resource string) *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall {
	c := &ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.hl7V2Stores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsHl7V2StoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsHl7V2StoresImportCall struct {
	s                     *Service
	name                  string
	importmessagesrequest *ImportMessagesRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Import: Import messages to the HL7v2 store by loading data from the
// specified sources. This method is optimized to load large quantities of data
// using import semantics that ignore some HL7v2 store configuration options
// and are not suitable for all use cases. It is primarily intended to load
// data into an empty HL7v2 store that is not being used by other clients. An
// existing message will be overwritten if a duplicate message is imported. A
// duplicate message is a message with the same raw bytes as a message that
// already exists in this HL7v2 store. When a message is overwritten, its
// labels will also be overwritten. The import operation is idempotent unless
// the input data contains multiple valid messages with the same raw bytes but
// different labels. In that case, after the import completes, the store
// contains exactly one message with those raw bytes but there is no ordering
// guarantee on which version of the labels it has. The operation result
// counters do not count duplicated raw bytes as an error and count one success
// for each message in the input, which might result in a success count larger
// than the number of messages in the HL7v2 store. If some messages fail to
// import, for example due to parsing errors, successfully imported messages
// are not rolled back. This method returns an Operation that can be used to
// track the status of the import by calling GetOperation. Immediate fatal
// errors appear in the error field, errors are also logged to Cloud Logging
// (see Viewing error logs in Cloud Logging
// (https://cloud.google.com/healthcare/docs/how-tos/logging)). Otherwise, when
// the operation finishes, a response of type ImportMessagesResponse is
// returned in the response field. The metadata field type for this operation
// is OperationMetadata.
//
//   - name: The name of the target HL7v2 store, in the format
//     `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/hl7v2S
//     tores/{hl7v2_store_id}`.
func (r *ProjectsLocationsDatasetsHl7V2StoresService) Import(name string, importmessagesrequest *ImportMessagesRequest) *ProjectsLocationsDatasetsHl7V2StoresImportCall {
	c := &ProjectsLocationsDatasetsHl7V2StoresImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.importmessagesrequest = importmessagesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsHl7V2StoresImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsHl7V2StoresImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsHl7V2StoresImportCall) Context(ctx context.Context) *ProjectsLocationsDatasetsHl7V2StoresImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsHl7V2StoresImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsHl7V2StoresImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importmessagesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.import", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "healthcare.projects.locations.datasets.hl7V2Stores.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsHl7V2StoresImportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "healthcare.projects.locations.datasets.hl7V2Stores.import", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsHl7V2StoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the HL7v2 stores in the given dataset.
//
// - parent: Name of the dataset.
func (r *ProjectsLocationsDatasetsHl7V2StoresService) List(parent string) *ProjectsLocationsDatasetsHl7V2StoresListCall {
	c := &ProjectsLocationsDatasetsHl7V2StoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Restricts stores returned to
// those matching a filter. The following syntax is available: * A string field
// value can be written as text inside quotation marks, for example "query
// text". The only valid relational operation for text fields is equality
// (`=`), where text is searched within the field, rather than having the field
// be equal to the text. For example, "Comment = great" returns messages with
// `great` in the comment field. * A number field value can be written as an
// integer, a decimal, or an exponential. The valid relational operators for
// number fields are the equality operator (`=`), along with the less
// than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
// inequality (`!=`) operator. You can prepend the `NOT` operator to an
// expression to negate it. * A date field value must be written in
/