// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package merchantapi provides access to the Merchant API.
//
// For product documentation, see: https://developers.google.com/merchant/api
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/merchantapi/ordertracking_v1beta"
//	...
//	ctx := context.Background()
//	merchantapiService, err := merchantapi.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package merchantapi // import "google.golang.org/api/merchantapi/ordertracking_v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "merchantapi:ordertracking_v1beta"
const apiName = "merchantapi"
const apiVersion = "ordertracking_v1beta"
const basePath = "https://merchantapi.googleapis.com/"
const basePathTemplate = "https://merchantapi.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://merchantapi.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Manage your product listings and accounts for Google Shopping
	ContentScope = "https://www.googleapis.com/auth/content"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/content",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Accounts = NewAccountsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.OrderTrackingSignals = NewAccountsOrderTrackingSignalsService(s)
	return rs
}

type AccountsService struct {
	s *Service

	OrderTrackingSignals *AccountsOrderTrackingSignalsService
}

func NewAccountsOrderTrackingSignalsService(s *Service) *AccountsOrderTrackingSignalsService {
	rs := &AccountsOrderTrackingSignalsService{s: s}
	return rs
}

type AccountsOrderTrackingSignalsService struct {
	s *Service
}

// DateTime: Represents civil time (or occasionally physical time). This type
// can represent a civil time in one of a few possible ways: * When utc_offset
// is set and time_zone is unset: a civil time on a calendar day with a
// particular offset from UTC. * When time_zone is set and utc_offset is unset:
// a civil time on a calendar day in a particular time zone. * When neither
// time_zone nor utc_offset is set: a civil time on a calendar day in local
// time. The date is relative to the Proleptic Gregorian Calendar. If year,
// month, or day are 0, the DateTime is considered not to have a specific year,
// month, or day respectively. This type may also be used to represent a
// physical time if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for physical
// time instead. If your use case also would like to store the user's timezone,
// that can be done in another field. This type is more flexible than some
// applications may want. Make sure to document and validate your application's
// limitations.
type DateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the year and
	// month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`
	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23,
	// defaults to 0 (midnight). An API may choose to allow the value "24:00:00"
	// for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults to
	// 0.
	Minutes int64 `json:"minutes,omitempty"`
	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a
	// datetime without a month.
	Month int64 `json:"month,omitempty"`
	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to
	// 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Optional. Seconds of minutes of the time. Must normally be from 0
	// to 59, defaults to 0. An API may allow the value 60 if it allows
	// leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// TimeZone: Time zone.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and +18
	// hours. For example, a UTC offset of -4:00 would be represented as { seconds:
	// -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`
	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
	// datetime without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DateTime) MarshalJSON() ([]byte, error) {
	type NoMethod DateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LineItemDetails: The line items of the order.
type LineItemDetails struct {
	// Brand: Optional. Brand of the product.
	Brand string `json:"brand,omitempty"`
	// Gtin: Optional. The Global Trade Item Number.
	Gtin string `json:"gtin,omitempty"`
	// Gtins: Optional. The Global Trade Item Numbers.
	Gtins []string `json:"gtins,omitempty"`
	// LineItemId: Required. The ID for this line item.
	LineItemId string `json:"lineItemId,omitempty"`
	// Mpn: Optional. The manufacturer part number.
	Mpn string `json:"mpn,omitempty"`
	// ProductId: Required. The Content API REST ID of the product, in the form
	// channel:contentLanguage:targetCountry:offerId.
	ProductId string `json:"productId,omitempty"`
	// ProductTitle: Optional. Plain text title of this product.
	ProductTitle string `json:"productTitle,omitempty"`
	// Quantity: Required. The quantity of the line item in the order.
	Quantity int64 `json:"quantity,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LineItemDetails) MarshalJSON() ([]byte, error) {
	type NoMethod LineItemDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrderTrackingSignal: Represents a business trade from which signals are
// extracted, such as shipping.
type OrderTrackingSignal struct {
	// CustomerShippingFee: Optional. The shipping fee of the order; this value
	// should be set to zero in the case of free shipping.
	CustomerShippingFee *Price `json:"customerShippingFee,omitempty"`
	// DeliveryPostalCode: Optional. The delivery postal code, as a continuous
	// string without spaces or dashes, for example "95016". This field will be
	// anonymized in returned OrderTrackingSignal creation response.
	DeliveryPostalCode string `json:"deliveryPostalCode,omitempty"`
	// DeliveryRegionCode: Optional. The [CLDR territory code]
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for the
	// shipping destination.
	DeliveryRegionCode string `json:"deliveryRegionCode,omitempty"`
	// LineItems: Required. Information about line items in the order.
	LineItems []*LineItemDetails `json:"lineItems,omitempty"`
	// MerchantId: Optional. The Google Merchant Center ID of this order tracking
	// signal. This value is optional. If left unset, the caller's Merchant Center
	// ID is used. You must request access in order to provide data on behalf of
	// another business. For more information, see Submitting Order Tracking
	// Signals (/shopping-content/guides/order-tracking-signals).
	MerchantId int64 `json:"merchantId,omitempty,string"`
	// OrderCreatedTime: Required. The time when the order was created on the
	// businesses side. Include the year and timezone string, if available.
	OrderCreatedTime *DateTime `json:"orderCreatedTime,omitempty"`
	// OrderId: Required. The ID of the order on the businesses side. This field
	// will be hashed in returned OrderTrackingSignal creation response.
	OrderId string `json:"orderId,omitempty"`
	// OrderTrackingSignalId: Output only. The ID that uniquely identifies this
	// order tracking signal.
	OrderTrackingSignalId int64 `json:"orderTrackingSignalId,omitempty,string"`
	// ShipmentLineItemMapping: Optional. The mapping of the line items to the
	// shipment information.
	ShipmentLineItemMapping []*ShipmentLineItemMapping `json:"shipmentLineItemMapping,omitempty"`
	// ShippingInfo: Required. The shipping information for the order.
	ShippingInfo []*ShippingInfo `json:"shippingInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomerShippingFee") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomerShippingFee") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrderTrackingSignal) MarshalJSON() ([]byte, error) {
	type NoMethod OrderTrackingSignal
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Price: The price represented as a number and currency.
type Price struct {
	// AmountMicros: The price represented as a number in micros (1 million micros
	// is an equivalent to one's currency standard unit, for example, 1 USD =
	// 1000000 micros).
	AmountMicros int64 `json:"amountMicros,omitempty,string"`
	// CurrencyCode: The currency of the price using three-letter acronyms
	// according to ISO 4217 (http://en.wikipedia.org/wiki/ISO_4217).
	CurrencyCode string `json:"currencyCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AmountMicros") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AmountMicros") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductChange: The change that happened to the product including old value,
// new value, country code as the region code and reporting context.
type ProductChange struct {
	// NewValue: The new value of the changed resource or attribute. If empty, it
	// means that the product was deleted. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	NewValue string `json:"newValue,omitempty"`
	// OldValue: The old value of the changed resource or attribute. If empty, it
	// means that the product was created. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	OldValue string `json:"oldValue,omitempty"`
	// RegionCode: Countries that have the change (if applicable). Represented in
	// the ISO 3166 format.
	RegionCode string `json:"regionCode,omitempty"`
	// ReportingContext: Reporting contexts that have the change (if applicable).
	// Currently this field supports only (`SHOPPING_ADS`, `LOCAL_INVENTORY_ADS`,
	// `YOUTUBE_SHOPPING`, `YOUTUBE_CHECKOUT`, `YOUTUBE_AFFILIATE`) from the enum
	// value ReportingContextEnum
	// (/merchant/api/reference/rest/Shared.Types/ReportingContextEnum)
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductChange) MarshalJSON() ([]byte, error) {
	type NoMethod ProductChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductStatusChangeMessage: The message that the merchant will receive to
// notify about product status change event
type ProductStatusChangeMessage struct {
	// Account: The target account that owns the entity that changed. Format :
	// `accounts/{merchant_id}`
	Account string `json:"account,omitempty"`
	// Attribute: The attribute in the resource that changed, in this case it will
	// be always `Status`.
	//
	// Possible values:
	//   "ATTRIBUTE_UNSPECIFIED" - Unspecified attribute
	//   "STATUS" - Status of the changed entity
	Attribute string `json:"attribute,omitempty"`
	// Changes: A message to describe the change that happened to the product
	Changes []*ProductChange `json:"changes,omitempty"`
	// EventTime: The time at which the event was generated. If you want to order
	// the notification messages you receive you should rely on this field not on
	// the order of receiving the notifications.
	EventTime string `json:"eventTime,omitempty"`
	// ExpirationTime: Optional. The product expiration time. This field will not
	// be set if the notification is sent for a product deletion event.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// ManagingAccount: The account that manages the merchant's account. can be the
	// same as merchant id if it is standalone account. Format :
	// `accounts/{service_provider_id}`
	ManagingAccount string `json:"managingAccount,omitempty"`
	// Resource: The product name. Format: `accounts/{account}/products/{product}`
	Resource string `json:"resource,omitempty"`
	// ResourceId: The product id.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceType: The resource that changed, in this case it will always be
	// `Product`.
	//
	// Possible values:
	//   "RESOURCE_UNSPECIFIED" - Unspecified resource
	//   "PRODUCT" - Resource type : product
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStatusChangeMessage) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusChangeMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShipmentLineItemMapping: Represents how many items are in the shipment for
// the given shipment_id and line_item_id.
type ShipmentLineItemMapping struct {
	// LineItemId: Required. The line item ID.
	LineItemId string `json:"lineItemId,omitempty"`
	// Quantity: Required. The line item quantity in the shipment.
	Quantity int64 `json:"quantity,omitempty,string"`
	// ShipmentId: Required. The shipment ID. This field will be hashed in returned
	// OrderTrackingSignal creation response.
	ShipmentId string `json:"shipmentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LineItemId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LineItemId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShipmentLineItemMapping) MarshalJSON() ([]byte, error) {
	type NoMethod ShipmentLineItemMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShippingInfo: The shipping information for the order.
type ShippingInfo struct {
	// ActualDeliveryTime: Optional. The time when the shipment was actually
	// delivered. Include the year and timezone string, if available. This field is
	// required, if one of the following fields is absent: tracking_id or
	// carrier_name.
	ActualDeliveryTime *DateTime `json:"actualDeliveryTime,omitempty"`
	// Carrier: Optional. The name of the shipping carrier for the delivery. This
	// field is required if one of the following fields is absent:
	// earliest_delivery_promise_time, latest_delivery_promise_time, and
	// actual_delivery_time.
	Carrier string `json:"carrier,omitempty"`
	// CarrierService: Optional. The service type for fulfillment, such as GROUND,
	// FIRST_CLASS, etc.
	CarrierService string `json:"carrierService,omitempty"`
	// EarliestDeliveryPromiseTime: Optional. The earliest delivery promised time.
	// Include the year and timezone string, if available. This field is required,
	// if one of the following fields is absent: tracking_id or carrier_name.
	EarliestDeliveryPromiseTime *DateTime `json:"earliestDeliveryPromiseTime,omitempty"`
	// LatestDeliveryPromiseTime: Optional. The latest delivery promised time.
	// Include the year and timezone string, if available. This field is required,
	// if one of the following fields is absent: tracking_id or carrier_name.
	LatestDeliveryPromiseTime *DateTime `json:"latestDeliveryPromiseTime,omitempty"`
	// OriginPostalCode: Required. The origin postal code, as a continuous string
	// without spaces or dashes, for example "95016". This field will be anonymized
	// in returned OrderTrackingSignal creation response.
	OriginPostalCode string `json:"originPostalCode,omitempty"`
	// OriginRegionCode: Required. The [CLDR territory code]
	// (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for the
	// shipping origin.
	OriginRegionCode string `json:"originRegionCode,omitempty"`
	// ShipmentId: Required. The shipment ID. This field will be hashed in returned
	// OrderTrackingSignal creation response.
	ShipmentId string `json:"shipmentId,omitempty"`
	// ShippedTime: Optional. The time when the shipment was shipped. Include the
	// year and timezone string, if available.
	ShippedTime *DateTime `json:"shippedTime,omitempty"`
	// ShippingStatus: Required. The status of the shipment.
	//
	// Possible values:
	//   "SHIPPING_STATE_UNSPECIFIED" - The shipping status is not known to
	// business.
	//   "SHIPPED" - All items are shipped.
	//   "DELIVERED" - The shipment is already delivered.
	ShippingStatus string `json:"shippingStatus,omitempty"`
	// TrackingId: Optional. The tracking ID of the shipment. This field is
	// required if one of the following fields is absent:
	// earliest_delivery_promise_time, latest_delivery_promise_time, and
	// actual_delivery_time.
	TrackingId string `json:"trackingId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActualDeliveryTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActualDeliveryTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShippingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ShippingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type TimeZone struct {
	// Id: IANA Time Zone Database time zone. For example "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number. For example
	// "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsOrderTrackingSignalsCreateCall struct {
	s                   *Service
	parent              string
	ordertrackingsignal *OrderTrackingSignal
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates new order tracking signal.
//
//   - parent: The account of the business for which the order signal is created.
//     Format: accounts/{account}.
func (r *AccountsOrderTrackingSignalsService) Create(parent string, ordertrackingsignal *OrderTrackingSignal) *AccountsOrderTrackingSignalsCreateCall {
	c := &AccountsOrderTrackingSignalsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.ordertrackingsignal = ordertrackingsignal
	return c
}

// OrderTrackingSignalId sets the optional parameter "orderTrackingSignalId":
// Output only. The ID that uniquely identifies this order tracking signal.
func (c *AccountsOrderTrackingSignalsCreateCall) OrderTrackingSignalId(orderTrackingSignalId string) *AccountsOrderTrackingSignalsCreateCall {
	c.urlParams_.Set("orderTrackingSignalId", orderTrackingSignalId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsOrderTrackingSignalsCreateCall) Fields(s ...googleapi.Field) *AccountsOrderTrackingSignalsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsOrderTrackingSignalsCreateCall) Context(ctx context.Context) *AccountsOrderTrackingSignalsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsOrderTrackingSignalsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsOrderTrackingSignalsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.ordertrackingsignal)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "ordertracking/v1beta/{+parent}/orderTrackingSignals")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.orderTrackingSignals.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.orderTrackingSignals.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *OrderTrackingSignal.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsOrderTrackingSignalsCreateCall) Do(opts ...googleapi.CallOption) (*OrderTrackingSignal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrderTrackingSignal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.orderTrackingSignals.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
