// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/devtools/clouddebugger/v2/data.proto

package clouddebugger

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/devtools/source/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Enumerates references to which the message applies.
type StatusMessage_Reference int32

const (
	// Status doesn't refer to any particular input.
	StatusMessage_UNSPECIFIED StatusMessage_Reference = 0
	// Status applies to the breakpoint and is related to its location.
	StatusMessage_BREAKPOINT_SOURCE_LOCATION StatusMessage_Reference = 3
	// Status applies to the breakpoint and is related to its condition.
	StatusMessage_BREAKPOINT_CONDITION StatusMessage_Reference = 4
	// Status applies to the breakpoint and is related to its expressions.
	StatusMessage_BREAKPOINT_EXPRESSION StatusMessage_Reference = 7
	// Status applies to the breakpoint and is related to its age.
	StatusMessage_BREAKPOINT_AGE StatusMessage_Reference = 8
	// Status applies to the entire variable.
	StatusMessage_VARIABLE_NAME StatusMessage_Reference = 5
	// Status applies to variable value (variable name is valid).
	StatusMessage_VARIABLE_VALUE StatusMessage_Reference = 6
)

// Enum value maps for StatusMessage_Reference.
var (
	StatusMessage_Reference_name = map[int32]string{
		0: "UNSPECIFIED",
		3: "BREAKPOINT_SOURCE_LOCATION",
		4: "BREAKPOINT_CONDITION",
		7: "BREAKPOINT_EXPRESSION",
		8: "BREAKPOINT_AGE",
		5: "VARIABLE_NAME",
		6: "VARIABLE_VALUE",
	}
	StatusMessage_Reference_value = map[string]int32{
		"UNSPECIFIED":                0,
		"BREAKPOINT_SOURCE_LOCATION": 3,
		"BREAKPOINT_CONDITION":       4,
		"BREAKPOINT_EXPRESSION":      7,
		"BREAKPOINT_AGE":             8,
		"VARIABLE_NAME":              5,
		"VARIABLE_VALUE":             6,
	}
)

func (x StatusMessage_Reference) Enum() *StatusMessage_Reference {
	p := new(StatusMessage_Reference)
	*p = x
	return p
}

func (x StatusMessage_Reference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatusMessage_Reference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_clouddebugger_v2_data_proto_enumTypes[0].Descriptor()
}

func (StatusMessage_Reference) Type() protoreflect.EnumType {
	return &file_google_devtools_clouddebugger_v2_data_proto_enumTypes[0]
}

func (x StatusMessage_Reference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StatusMessage_Reference.Descriptor instead.
func (StatusMessage_Reference) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{1, 0}
}

// Actions that can be taken when a breakpoint hits.
// Agents should reject breakpoints with unsupported or unknown action values.
type Breakpoint_Action int32

const (
	// Capture stack frame and variables and update the breakpoint.
	// The data is only captured once. After that the breakpoint is set
	// in a final state.
	Breakpoint_CAPTURE Breakpoint_Action = 0
	// Log each breakpoint hit. The breakpoint remains active until
	// deleted or expired.
	Breakpoint_LOG Breakpoint_Action = 1
)

// Enum value maps for Breakpoint_Action.
var (
	Breakpoint_Action_name = map[int32]string{
		0: "CAPTURE",
		1: "LOG",
	}
	Breakpoint_Action_value = map[string]int32{
		"CAPTURE": 0,
		"LOG":     1,
	}
)

func (x Breakpoint_Action) Enum() *Breakpoint_Action {
	p := new(Breakpoint_Action)
	*p = x
	return p
}

func (x Breakpoint_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Breakpoint_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_clouddebugger_v2_data_proto_enumTypes[1].Descriptor()
}

func (Breakpoint_Action) Type() protoreflect.EnumType {
	return &file_google_devtools_clouddebugger_v2_data_proto_enumTypes[1]
}

func (x Breakpoint_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Breakpoint_Action.Descriptor instead.
func (Breakpoint_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{5, 0}
}

// Log severity levels.
type Breakpoint_LogLevel int32

const (
	// Information log message.
	Breakpoint_INFO Breakpoint_LogLevel = 0
	// Warning log message.
	Breakpoint_WARNING Breakpoint_LogLevel = 1
	// Error log message.
	Breakpoint_ERROR Breakpoint_LogLevel = 2
)

// Enum value maps for Breakpoint_LogLevel.
var (
	Breakpoint_LogLevel_name = map[int32]string{
		0: "INFO",
		1: "WARNING",
		2: "ERROR",
	}
	Breakpoint_LogLevel_value = map[string]int32{
		"INFO":    0,
		"WARNING": 1,
		"ERROR":   2,
	}
)

func (x Breakpoint_LogLevel) Enum() *Breakpoint_LogLevel {
	p := new(Breakpoint_LogLevel)
	*p = x
	return p
}

func (x Breakpoint_LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Breakpoint_LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_clouddebugger_v2_data_proto_enumTypes[2].Descriptor()
}

func (Breakpoint_LogLevel) Type() protoreflect.EnumType {
	return &file_google_devtools_clouddebugger_v2_data_proto_enumTypes[2]
}

func (x Breakpoint_LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Breakpoint_LogLevel.Descriptor instead.
func (Breakpoint_LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{5, 1}
}

// Represents a message with parameters.
type FormatMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format template for the message. The `format` uses placeholders `$0`,
	// `$1`, etc. to reference parameters. `$$` can be used to denote the `$`
	// character.
	//
	// Examples:
	//
	// *   `Failed to load '$0' which helps debug $1 the first time it
	//     is loaded.  Again, $0 is very important.`
	// *   `Please pay $$10 to use $0 instead of $1.`
	Format string `protobuf:"bytes,1,opt,name=format,proto3" json:"format,omitempty"`
	// Optional parameters to be embedded into the message.
	Parameters []string `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *FormatMessage) Reset() {
	*x = FormatMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FormatMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FormatMessage) ProtoMessage() {}

func (x *FormatMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FormatMessage.ProtoReflect.Descriptor instead.
func (*FormatMessage) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{0}
}

func (x *FormatMessage) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *FormatMessage) GetParameters() []string {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Represents a contextual status message.
// The message can indicate an error or informational status, and refer to
// specific parts of the containing object.
// For example, the `Breakpoint.status` field can indicate an error referring
// to the `BREAKPOINT_SOURCE_LOCATION` with the message `Location not found`.
type StatusMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Distinguishes errors from informational messages.
	IsError bool `protobuf:"varint,1,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
	// Reference to which the message applies.
	RefersTo StatusMessage_Reference `protobuf:"varint,2,opt,name=refers_to,json=refersTo,proto3,enum=google.devtools.clouddebugger.v2.StatusMessage_Reference" json:"refers_to,omitempty"`
	// Status message text.
	Description *FormatMessage `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *StatusMessage) Reset() {
	*x = StatusMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusMessage) ProtoMessage() {}

func (x *StatusMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusMessage.ProtoReflect.Descriptor instead.
func (*StatusMessage) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{1}
}

func (x *StatusMessage) GetIsError() bool {
	if x != nil {
		return x.IsError
	}
	return false
}

func (x *StatusMessage) GetRefersTo() StatusMessage_Reference {
	if x != nil {
		return x.RefersTo
	}
	return StatusMessage_UNSPECIFIED
}

func (x *StatusMessage) GetDescription() *FormatMessage {
	if x != nil {
		return x.Description
	}
	return nil
}

// Represents a location in the source code.
type SourceLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the source file within the source context of the target binary.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Line inside the file. The first line in the file has the value `1`.
	Line int32 `protobuf:"varint,2,opt,name=line,proto3" json:"line,omitempty"`
	// Column within a line. The first column in a line as the value `1`.
	// Agents that do not support setting breakpoints on specific columns ignore
	// this field.
	Column int32 `protobuf:"varint,3,opt,name=column,proto3" json:"column,omitempty"`
}

func (x *SourceLocation) Reset() {
	*x = SourceLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceLocation) ProtoMessage() {}

func (x *SourceLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceLocation.ProtoReflect.Descriptor instead.
func (*SourceLocation) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{2}
}

func (x *SourceLocation) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *SourceLocation) GetLine() int32 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *SourceLocation) GetColumn() int32 {
	if x != nil {
		return x.Column
	}
	return 0
}

// Represents a variable or an argument possibly of a compound object type.
// Note how the following variables are represented:
//
// 1) A simple variable:
//
//     int x = 5
//
//     { name: "x", value: "5", type: "int" }  // Captured variable
//
// 2) A compound object:
//
//     struct T {
//         int m1;
//         int m2;
//     };
//     T x = { 3, 7 };
//
//     {  // Captured variable
//         name: "x",
//         type: "T",
//         members { name: "m1", value: "3", type: "int" },
//         members { name: "m2", value: "7", type: "int" }
//     }
//
// 3) A pointer where the pointee was captured:
//
//     T x = { 3, 7 };
//     T* p = &x;
//
//     {   // Captured variable
//         name: "p",
//         type: "T*",
//         value: "0x00500500",
//         members { name: "m1", value: "3", type: "int" },
//         members { name: "m2", value: "7", type: "int" }
//     }
//
// 4) A pointer where the pointee was not captured:
//
//     T* p = new T;
//
//     {   // Captured variable
//         name: "p",
//         type: "T*",
//         value: "0x00400400"
//         status { is_error: true, description { format: "unavailable" } }
//     }
//
// The status should describe the reason for the missing value,
// such as `<optimized out>`, `<inaccessible>`, `<pointers limit reached>`.
//
// Note that a null pointer should not have members.
//
// 5) An unnamed value:
//
//     int* p = new int(7);
//
//     {   // Captured variable
//         name: "p",
//         value: "0x00500500",
//         type: "int*",
//         members { value: "7", type: "int" } }
//
// 6) An unnamed pointer where the pointee was not captured:
//
//     int* p = new int(7);
//     int** pp = &p;
//
//     {  // Captured variable
//         name: "pp",
//         value: "0x00500500",
//         type: "int**",
//         members {
//             value: "0x00400400",
//             type: "int*"
//             status {
//                 is_error: true,
//                 description: { format: "unavailable" } }
//             }
//         }
//     }
//
// To optimize computation, memory and network traffic, variables that
// repeat in the output multiple times can be stored once in a shared
// variable table and be referenced using the `var_table_index` field.  The
// variables stored in the shared table are nameless and are essentially
// a partition of the complete variable. To reconstruct the complete
// variable, merge the referencing variable with the referenced variable.
//
// When using the shared variable table, the following variables:
//
//     T x = { 3, 7 };
//     T* p = &x;
//     T& r = x;
//
//     { name: "x", var_table_index: 3, type: "T" }  // Captured variables
//     { name: "p", value "0x00500500", type="T*", var_table_index: 3 }
//     { name: "r", type="T&", var_table_index: 3 }
//
//     {  // Shared variable table entry #3:
//         members { name: "m1", value: "3", type: "int" },
//         members { name: "m2", value: "7", type: "int" }
//     }
//
// Note that the pointer address is stored with the referencing variable
// and not with the referenced variable. This allows the referenced variable
// to be shared between pointers and references.
//
// The type field is optional. The debugger agent may or may not support it.
type Variable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the variable, if any.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Simple value of the variable.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Variable type (e.g. `MyClass`). If the variable is split with
	// `var_table_index`, `type` goes next to `value`. The interpretation of
	// a type is agent specific. It is recommended to include the dynamic type
	// rather than a static type of an object.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// Members contained or pointed to by the variable.
	Members []*Variable `protobuf:"bytes,3,rep,name=members,proto3" json:"members,omitempty"`
	// Reference to a variable in the shared variable table. More than
	// one variable can reference the same variable in the table. The
	// `var_table_index` field is an index into `variable_table` in Breakpoint.
	VarTableIndex *wrapperspb.Int32Value `protobuf:"bytes,4,opt,name=var_table_index,json=varTableIndex,proto3" json:"var_table_index,omitempty"`
	// Status associated with the variable. This field will usually stay
	// unset. A status of a single variable only applies to that variable or
	// expression. The rest of breakpoint data still remains valid. Variables
	// might be reported in error state even when breakpoint is not in final
	// state.
	//
	// The message may refer to variable name with `refers_to` set to
	// `VARIABLE_NAME`. Alternatively `refers_to` will be set to `VARIABLE_VALUE`.
	// In either case variable value and members will be unset.
	//
	// Example of error message applied to name: `Invalid expression syntax`.
	//
	// Example of information message applied to value: `Not captured`.
	//
	// Examples of error message applied to value:
	//
	// *   `Malformed string`,
	// *   `Field f not found in class C`
	// *   `Null pointer dereference`
	Status *StatusMessage `protobuf:"bytes,5,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *Variable) Reset() {
	*x = Variable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Variable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Variable) ProtoMessage() {}

func (x *Variable) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Variable.ProtoReflect.Descriptor instead.
func (*Variable) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{3}
}

func (x *Variable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Variable) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Variable) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Variable) GetMembers() []*Variable {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *Variable) GetVarTableIndex() *wrapperspb.Int32Value {
	if x != nil {
		return x.VarTableIndex
	}
	return nil
}

func (x *Variable) GetStatus() *StatusMessage {
	if x != nil {
		return x.Status
	}
	return nil
}

// Represents a stack frame context.
type StackFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Demangled function name at the call site.
	Function string `protobuf:"bytes,1,opt,name=function,proto3" json:"function,omitempty"`
	// Source location of the call site.
	Location *SourceLocation `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Set of arguments passed to this function.
	// Note that this might not be populated for all stack frames.
	Arguments []*Variable `protobuf:"bytes,3,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// Set of local variables at the stack frame location.
	// Note that this might not be populated for all stack frames.
	Locals []*Variable `protobuf:"bytes,4,rep,name=locals,proto3" json:"locals,omitempty"`
}

func (x *StackFrame) Reset() {
	*x = StackFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StackFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackFrame) ProtoMessage() {}

func (x *StackFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackFrame.ProtoReflect.Descriptor instead.
func (*StackFrame) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{4}
}

func (x *StackFrame) GetFunction() string {
	if x != nil {
		return x.Function
	}
	return ""
}

func (x *StackFrame) GetLocation() *SourceLocation {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *StackFrame) GetArguments() []*Variable {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *StackFrame) GetLocals() []*Variable {
	if x != nil {
		return x.Locals
	}
	return nil
}

// Represents the breakpoint specification, status and results.
type Breakpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Breakpoint identifier, unique in the scope of the debuggee.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Action that the agent should perform when the code at the
	// breakpoint location is hit.
	Action Breakpoint_Action `protobuf:"varint,13,opt,name=action,proto3,enum=google.devtools.clouddebugger.v2.Breakpoint_Action" json:"action,omitempty"`
	// Breakpoint source location.
	Location *SourceLocation `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Condition that triggers the breakpoint.
	// The condition is a compound boolean expression composed using expressions
	// in a programming language at the source location.
	Condition string `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// List of read-only expressions to evaluate at the breakpoint location.
	// The expressions are composed using expressions in the programming language
	// at the source location. If the breakpoint action is `LOG`, the evaluated
	// expressions are included in log statements.
	Expressions []string `protobuf:"bytes,4,rep,name=expressions,proto3" json:"expressions,omitempty"`
	// Only relevant when action is `LOG`. Defines the message to log when
	// the breakpoint hits. The message may include parameter placeholders `$0`,
	// `$1`, etc. These placeholders are replaced with the evaluated value
	// of the appropriate expression. Expressions not referenced in
	// `log_message_format` are not logged.
	//
	// Example: `Message received, id = $0, count = $1` with
	// `expressions` = `[ message.id, message.count ]`.
	LogMessageFormat string `protobuf:"bytes,14,opt,name=log_message_format,json=logMessageFormat,proto3" json:"log_message_format,omitempty"`
	// Indicates the severity of the log. Only relevant when action is `LOG`.
	LogLevel Breakpoint_LogLevel `protobuf:"varint,15,opt,name=log_level,json=logLevel,proto3,enum=google.devtools.clouddebugger.v2.Breakpoint_LogLevel" json:"log_level,omitempty"`
	// When true, indicates that this is a final result and the
	// breakpoint state will not change from here on.
	IsFinalState bool `protobuf:"varint,5,opt,name=is_final_state,json=isFinalState,proto3" json:"is_final_state,omitempty"`
	// Time this breakpoint was created by the server in seconds resolution.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time this breakpoint was finalized as seen by the server in seconds
	// resolution.
	FinalTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=final_time,json=finalTime,proto3" json:"final_time,omitempty"`
	// E-mail address of the user that created this breakpoint
	UserEmail string `protobuf:"bytes,16,opt,name=user_email,json=userEmail,proto3" json:"user_email,omitempty"`
	// Breakpoint status.
	//
	// The status includes an error flag and a human readable message.
	// This field is usually unset. The message can be either
	// informational or an error message. Regardless, clients should always
	// display the text message back to the user.
	//
	// Error status indicates complete failure of the breakpoint.
	//
	// Example (non-final state): `Still loading symbols...`
	//
	// Examples (final state):
	//
	// *   `Invalid line number` referring to location
	// *   `Field f not found in class C` referring to condition
	Status *StatusMessage `protobuf:"bytes,10,opt,name=status,proto3" json:"status,omitempty"`
	// The stack at breakpoint time, where stack_frames[0] represents the most
	// recently entered function.
	StackFrames []*StackFrame `protobuf:"bytes,7,rep,name=stack_frames,json=stackFrames,proto3" json:"stack_frames,omitempty"`
	// Values of evaluated expressions at breakpoint time.
	// The evaluated expressions appear in exactly the same order they
	// are listed in the `expressions` field.
	// The `name` field holds the original expression text, the `value` or
	// `members` field holds the result of the evaluated expression.
	// If the expression cannot be evaluated, the `status` inside the `Variable`
	// will indicate an error and contain the error text.
	EvaluatedExpressions []*Variable `protobuf:"bytes,8,rep,name=evaluated_expressions,json=evaluatedExpressions,proto3" json:"evaluated_expressions,omitempty"`
	// The `variable_table` exists to aid with computation, memory and network
	// traffic optimization.  It enables storing a variable once and reference
	// it from multiple variables, including variables stored in the
	// `variable_table` itself.
	// For example, the same `this` object, which may appear at many levels of
	// the stack, can have all of its data stored once in this table.  The
	// stack frame variables then would hold only a reference to it.
	//
	// The variable `var_table_index` field is an index into this repeated field.
	// The stored objects are nameless and get their name from the referencing
	// variable. The effective variable is a merge of the referencing variable
	// and the referenced variable.
	VariableTable []*Variable `protobuf:"bytes,9,rep,name=variable_table,json=variableTable,proto3" json:"variable_table,omitempty"`
	// A set of custom breakpoint properties, populated by the agent, to be
	// displayed to the user.
	Labels map[string]string `protobuf:"bytes,17,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Breakpoint) Reset() {
	*x = Breakpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Breakpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Breakpoint) ProtoMessage() {}

func (x *Breakpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Breakpoint.ProtoReflect.Descriptor instead.
func (*Breakpoint) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{5}
}

func (x *Breakpoint) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Breakpoint) GetAction() Breakpoint_Action {
	if x != nil {
		return x.Action
	}
	return Breakpoint_CAPTURE
}

func (x *Breakpoint) GetLocation() *SourceLocation {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Breakpoint) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *Breakpoint) GetExpressions() []string {
	if x != nil {
		return x.Expressions
	}
	return nil
}

func (x *Breakpoint) GetLogMessageFormat() string {
	if x != nil {
		return x.LogMessageFormat
	}
	return ""
}

func (x *Breakpoint) GetLogLevel() Breakpoint_LogLevel {
	if x != nil {
		return x.LogLevel
	}
	return Breakpoint_INFO
}

func (x *Breakpoint) GetIsFinalState() bool {
	if x != nil {
		return x.IsFinalState
	}
	return false
}

func (x *Breakpoint) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Breakpoint) GetFinalTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FinalTime
	}
	return nil
}

func (x *Breakpoint) GetUserEmail() string {
	if x != nil {
		return x.UserEmail
	}
	return ""
}

func (x *Breakpoint) GetStatus() *StatusMessage {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Breakpoint) GetStackFrames() []*StackFrame {
	if x != nil {
		return x.StackFrames
	}
	return nil
}

func (x *Breakpoint) GetEvaluatedExpressions() []*Variable {
	if x != nil {
		return x.EvaluatedExpressions
	}
	return nil
}

func (x *Breakpoint) GetVariableTable() []*Variable {
	if x != nil {
		return x.VariableTable
	}
	return nil
}

func (x *Breakpoint) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Represents the debugged application. The application may include one or more
// replicated processes executing the same code. Each of these processes is
// attached with a debugger agent, carrying out the debugging commands.
// Agents attached to the same debuggee identify themselves as such by using
// exactly the same Debuggee message value when registering.
type Debuggee struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for the debuggee generated by the controller service.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Project the debuggee is associated with.
	// Use project number or id when registering a Google Cloud Platform project.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Uniquifier to further distinguish the application.
	// It is possible that different applications might have identical values in
	// the debuggee message, thus, incorrectly identified as a single application
	// by the Controller service. This field adds salt to further distinguish the
	// application. Agents should consider seeding this field with value that
	// identifies the code, binary, configuration and environment.
	Uniquifier string `protobuf:"bytes,3,opt,name=uniquifier,proto3" json:"uniquifier,omitempty"`
	// Human readable description of the debuggee.
	// Including a human-readable project name, environment name and version
	// information is recommended.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// If set to `true`, indicates that Controller service does not detect any
	// activity from the debuggee agents and the application is possibly stopped.
	IsInactive bool `protobuf:"varint,5,opt,name=is_inactive,json=isInactive,proto3" json:"is_inactive,omitempty"`
	// Version ID of the agent.
	// Schema: `domain/language-platform/vmajor.minor` (for example
	// `google.com/java-gcp/v1.1`).
	AgentVersion string `protobuf:"bytes,6,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	// If set to `true`, indicates that the agent should disable itself and
	// detach from the debuggee.
	IsDisabled bool `protobuf:"varint,7,opt,name=is_disabled,json=isDisabled,proto3" json:"is_disabled,omitempty"`
	// Human readable message to be displayed to the user about this debuggee.
	// Absence of this field indicates no status. The message can be either
	// informational or an error status.
	Status *StatusMessage `protobuf:"bytes,8,opt,name=status,proto3" json:"status,omitempty"`
	// References to the locations and revisions of the source code used in the
	// deployed application.
	SourceContexts []*v1.SourceContext `protobuf:"bytes,9,rep,name=source_contexts,json=sourceContexts,proto3" json:"source_contexts,omitempty"`
	// References to the locations and revisions of the source code used in the
	// deployed application.
	//
	// Deprecated: Do not use.
	ExtSourceContexts []*v1.ExtendedSourceContext `protobuf:"bytes,13,rep,name=ext_source_contexts,json=extSourceContexts,proto3" json:"ext_source_contexts,omitempty"`
	// A set of custom debuggee properties, populated by the agent, to be
	// displayed to the user.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Debuggee) Reset() {
	*x = Debuggee{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Debuggee) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Debuggee) ProtoMessage() {}

func (x *Debuggee) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_data_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Debuggee.ProtoReflect.Descriptor instead.
func (*Debuggee) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP(), []int{6}
}

func (x *Debuggee) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Debuggee) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *Debuggee) GetUniquifier() string {
	if x != nil {
		return x.Uniquifier
	}
	return ""
}

func (x *Debuggee) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Debuggee) GetIsInactive() bool {
	if x != nil {
		return x.IsInactive
	}
	return false
}

func (x *Debuggee) GetAgentVersion() string {
	if x != nil {
		return x.AgentVersion
	}
	return ""
}

func (x *Debuggee) GetIsDisabled() bool {
	if x != nil {
		return x.IsDisabled
	}
	return false
}

func (x *Debuggee) GetStatus() *StatusMessage {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Debuggee) GetSourceContexts() []*v1.SourceContext {
	if x != nil {
		return x.SourceContexts
	}
	return nil
}

// Deprecated: Do not use.
func (x *Debuggee) GetExtSourceContexts() []*v1.ExtendedSourceContext {
	if x != nil {
		return x.ExtSourceContexts
	}
	return nil
}

func (x *Debuggee) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

var File_google_devtools_clouddebugger_v2_data_proto protoreflect.FileDescriptor

var file_google_devtools_clouddebugger_v2_data_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2f,
	0x76, 0x32, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x47,
	0x0a, 0x0d, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x84, 0x03, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x56, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x73, 0x5f, 0x74,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x66, 0x65, 0x72, 0x73, 0x54, 0x6f, 0x12, 0x51, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xac, 0x01, 0x0a, 0x09, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x0f, 0x0a,
	0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e,
	0x0a, 0x1a, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x18,
	0x0a, 0x14, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x4e,
	0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x42, 0x52, 0x45, 0x41,
	0x4b, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x45, 0x58, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x10, 0x07, 0x12, 0x12, 0x0a, 0x0e, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x50, 0x4f, 0x49, 0x4e,
	0x54, 0x5f, 0x41, 0x47, 0x45, 0x10, 0x08, 0x12, 0x11, 0x0a, 0x0d, 0x56, 0x41, 0x52, 0x49, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x56, 0x41,
	0x52, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x06, 0x22, 0x50,
	0x0a, 0x0e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x22, 0x9c, 0x02, 0x0a, 0x08, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x12, 0x43, 0x0a, 0x0f, 0x76, 0x61, 0x72, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x76, 0x61, 0x72, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x47, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x84, 0x02, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x42, 0x0a, 0x06, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x73, 0x22, 0xdf, 0x08, 0x0a, 0x0a, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x4b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62,
	0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75,
	0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x6f, 0x67, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6c, 0x6f,
	0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x52,
	0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e,
	0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x46, 0x69,
	0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12,
	0x47, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4f, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x0b, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x15, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x52, 0x14, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0d,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x50, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x1e, 0x0a, 0x06, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x41, 0x50, 0x54, 0x55, 0x52, 0x45, 0x10,
	0x00, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x47, 0x10, 0x01, 0x22, 0x2c, 0x0a, 0x08, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x22, 0xea, 0x04, 0x0a, 0x08, 0x44, 0x65, 0x62,
	0x75, 0x67, 0x67, 0x65, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x1e, 0x0a, 0x0a, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x69, 0x6e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x49, 0x6e, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73,
	0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x47, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x51, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x73, 0x12, 0x64, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x65, 0x78, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0xd9, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x09,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x3b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x18,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x65, 0x62,
	0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72,
	0x5c, 0x56, 0x32, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x3a, 0x3a, 0x56,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_clouddebugger_v2_data_proto_rawDescOnce sync.Once
	file_google_devtools_clouddebugger_v2_data_proto_rawDescData = file_google_devtools_clouddebugger_v2_data_proto_rawDesc
)

func file_google_devtools_clouddebugger_v2_data_proto_rawDescGZIP() []byte {
	file_google_devtools_clouddebugger_v2_data_proto_rawDescOnce.Do(func() {
		file_google_devtools_clouddebugger_v2_data_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_clouddebugger_v2_data_proto_rawDescData)
	})
	return file_google_devtools_clouddebugger_v2_data_proto_rawDescData
}

var file_google_devtools_clouddebugger_v2_data_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_devtools_clouddebugger_v2_data_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_devtools_clouddebugger_v2_data_proto_goTypes = []interface{}{
	(StatusMessage_Reference)(0),     // 0: google.devtools.clouddebugger.v2.StatusMessage.Reference
	(Breakpoint_Action)(0),           // 1: google.devtools.clouddebugger.v2.Breakpoint.Action
	(Breakpoint_LogLevel)(0),         // 2: google.devtools.clouddebugger.v2.Breakpoint.LogLevel
	(*FormatMessage)(nil),            // 3: google.devtools.clouddebugger.v2.FormatMessage
	(*StatusMessage)(nil),            // 4: google.devtools.clouddebugger.v2.StatusMessage
	(*SourceLocation)(nil),           // 5: google.devtools.clouddebugger.v2.SourceLocation
	(*Variable)(nil),                 // 6: google.devtools.clouddebugger.v2.Variable
	(*StackFrame)(nil),               // 7: google.devtools.clouddebugger.v2.StackFrame
	(*Breakpoint)(nil),               // 8: google.devtools.clouddebugger.v2.Breakpoint
	(*Debuggee)(nil),                 // 9: google.devtools.clouddebugger.v2.Debuggee
	nil,                              // 10: google.devtools.clouddebugger.v2.Breakpoint.LabelsEntry
	nil,                              // 11: google.devtools.clouddebugger.v2.Debuggee.LabelsEntry
	(*wrapperspb.Int32Value)(nil),    // 12: google.protobuf.Int32Value
	(*timestamppb.Timestamp)(nil),    // 13: google.protobuf.Timestamp
	(*v1.SourceContext)(nil),         // 14: google.devtools.source.v1.SourceContext
	(*v1.ExtendedSourceContext)(nil), // 15: google.devtools.source.v1.ExtendedSourceContext
}
var file_google_devtools_clouddebugger_v2_data_proto_depIdxs = []int32{
	0,  // 0: google.devtools.clouddebugger.v2.StatusMessage.refers_to:type_name -> google.devtools.clouddebugger.v2.StatusMessage.Reference
	3,  // 1: google.devtools.clouddebugger.v2.StatusMessage.description:type_name -> google.devtools.clouddebugger.v2.FormatMessage
	6,  // 2: google.devtools.clouddebugger.v2.Variable.members:type_name -> google.devtools.clouddebugger.v2.Variable
	12, // 3: google.devtools.clouddebugger.v2.Variable.var_table_index:type_name -> google.protobuf.Int32Value
	4,  // 4: google.devtools.clouddebugger.v2.Variable.status:type_name -> google.devtools.clouddebugger.v2.StatusMessage
	5,  // 5: google.devtools.clouddebugger.v2.StackFrame.location:type_name -> google.devtools.clouddebugger.v2.SourceLocation
	6,  // 6: google.devtools.clouddebugger.v2.StackFrame.arguments:type_name -> google.devtools.clouddebugger.v2.Variable
	6,  // 7: google.devtools.clouddebugger.v2.StackFrame.locals:type_name -> google.devtools.clouddebugger.v2.Variable
	1,  // 8: google.devtools.clouddebugger.v2.Breakpoint.action:type_name -> google.devtools.clouddebugger.v2.Breakpoint.Action
	5,  // 9: google.devtools.clouddebugger.v2.Breakpoint.location:type_name -> google.devtools.clouddebugger.v2.SourceLocation
	2,  // 10: google.devtools.clouddebugger.v2.Breakpoint.log_level:type_name -> google.devtools.clouddebugger.v2.Breakpoint.LogLevel
	13, // 11: google.devtools.clouddebugger.v2.Breakpoint.create_time:type_name -> google.protobuf.Timestamp
	13, // 12: google.devtools.clouddebugger.v2.Breakpoint.final_time:type_name -> google.protobuf.Timestamp
	4,  // 13: google.devtools.clouddebugger.v2.Breakpoint.status:type_name -> google.devtools.clouddebugger.v2.StatusMessage
	7,  // 14: google.devtools.clouddebugger.v2.Breakpoint.stack_frames:type_name -> google.devtools.clouddebugger.v2.StackFrame
	6,  // 15: google.devtools.clouddebugger.v2.Breakpoint.evaluated_expressions:type_name -> google.devtools.clouddebugger.v2.Variable
	6,  // 16: google.devtools.clouddebugger.v2.Breakpoint.variable_table:type_name -> google.devtools.clouddebugger.v2.Variable
	10, // 17: google.devtools.clouddebugger.v2.Breakpoint.labels:type_name -> google.devtools.clouddebugger.v2.Breakpoint.LabelsEntry
	4,  // 18: google.devtools.clouddebugger.v2.Debuggee.status:type_name -> google.devtools.clouddebugger.v2.StatusMessage
	14, // 19: google.devtools.clouddebugger.v2.Debuggee.source_contexts:type_name -> google.devtools.source.v1.SourceContext
	15, // 20: google.devtools.clouddebugger.v2.Debuggee.ext_source_contexts:type_name -> google.devtools.source.v1.ExtendedSourceContext
	11, // 21: google.devtools.clouddebugger.v2.Debuggee.labels:type_name -> google.devtools.clouddebugger.v2.Debuggee.LabelsEntry
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_devtools_clouddebugger_v2_data_proto_init() }
func file_google_devtools_clouddebugger_v2_data_proto_init() {
	if File_google_devtools_clouddebugger_v2_data_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_clouddebugger_v2_data_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FormatMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_data_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_data_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_data_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Variable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_data_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StackFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_data_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Breakpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_data_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Debuggee); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_clouddebugger_v2_data_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_clouddebugger_v2_data_proto_goTypes,
		DependencyIndexes: file_google_devtools_clouddebugger_v2_data_proto_depIdxs,
		EnumInfos:         file_google_devtools_clouddebugger_v2_data_proto_enumTypes,
		MessageInfos:      file_google_devtools_clouddebugger_v2_data_proto_msgTypes,
	}.Build()
	File_google_devtools_clouddebugger_v2_data_proto = out.File
	file_google_devtools_clouddebugger_v2_data_proto_rawDesc = nil
	file_google_devtools_clouddebugger_v2_data_proto_goTypes = nil
	file_google_devtools_clouddebugger_v2_data_proto_depIdxs = nil
}
