// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/aiplatform/v1beta1/schema/trainingjob/definition/automl_forecasting.proto

package definition

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A TrainingJob that trains and uploads an AutoML Forecasting Model.
type AutoMlForecasting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input parameters of this TrainingJob.
	Inputs *AutoMlForecastingInputs `protobuf:"bytes,1,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// The metadata information.
	Metadata *AutoMlForecastingMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *AutoMlForecasting) Reset() {
	*x = AutoMlForecasting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecasting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecasting) ProtoMessage() {}

func (x *AutoMlForecasting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecasting.ProtoReflect.Descriptor instead.
func (*AutoMlForecasting) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{0}
}

func (x *AutoMlForecasting) GetInputs() *AutoMlForecastingInputs {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *AutoMlForecasting) GetMetadata() *AutoMlForecastingMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type AutoMlForecastingInputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the column that the model is to predict.
	TargetColumn string `protobuf:"bytes,1,opt,name=target_column,json=targetColumn,proto3" json:"target_column,omitempty"`
	// The name of the column that identifies the time series.
	TimeSeriesIdentifierColumn string `protobuf:"bytes,2,opt,name=time_series_identifier_column,json=timeSeriesIdentifierColumn,proto3" json:"time_series_identifier_column,omitempty"`
	// The name of the column that identifies time order in the time series.
	TimeColumn string `protobuf:"bytes,3,opt,name=time_column,json=timeColumn,proto3" json:"time_column,omitempty"`
	// Each transformation will apply transform function to given input column.
	// And the result will be used for training.
	// When creating transformation for BigQuery Struct column, the column should
	// be flattened using "." as the delimiter.
	Transformations []*AutoMlForecastingInputs_Transformation `protobuf:"bytes,4,rep,name=transformations,proto3" json:"transformations,omitempty"`
	// Objective function the model is optimizing towards. The training process
	// creates a model that optimizes the value of the objective
	// function over the validation set.
	//
	// The supported optimization objectives:
	//   "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE).
	//   "minimize-mae" - Minimize mean-absolute error (MAE).
	//   "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE).
	//   "minimize-rmspe" - Minimize root-mean-squared percentage error (RMSPE).
	//   "minimize-wape-mae" - Minimize the combination of weighted absolute
	//     percentage error (WAPE) and mean-absolute-error (MAE).
	OptimizationObjective string `protobuf:"bytes,5,opt,name=optimization_objective,json=optimizationObjective,proto3" json:"optimization_objective,omitempty"`
	// Required. The train budget of creating this model, expressed in milli node
	// hours i.e. 1,000 value in this field means 1 node hour.
	//
	// The training cost of the model will not exceed this budget. The final cost
	// will be attempted to be close to the budget, though may end up being (even)
	// noticeably smaller - at the backend's discretion. This especially may
	// happen when further model training ceases to provide any improvements.
	//
	// If the budget is set to a value known to be insufficient to train a
	// model for the given dataset, the training won't be attempted and
	// will error.
	//
	// The train budget must be between 1,000 and 72,000 milli node hours,
	// inclusive.
	TrainBudgetMilliNodeHours int64 `protobuf:"varint,6,opt,name=train_budget_milli_node_hours,json=trainBudgetMilliNodeHours,proto3" json:"train_budget_milli_node_hours,omitempty"`
	// Column name that should be used as the weight column.
	// Higher values in this column give more importance to the row
	// during model training. The column must have numeric values between 0 and
	// 10000 inclusively; 0 means the row is ignored for training. If weight
	// column field is not set, then all rows are assumed to have equal weight
	// of 1.
	WeightColumn string `protobuf:"bytes,7,opt,name=weight_column,json=weightColumn,proto3" json:"weight_column,omitempty"`
	// Column names that should be used as static columns.
	// The value of these columns are static per time series.
	StaticColumns []string `protobuf:"bytes,8,rep,name=static_columns,json=staticColumns,proto3" json:"static_columns,omitempty"`
	// Column names that should be used as time variant past only columns.
	// This column contains information for the given entity (identified by the
	// time_series_identifier_column) that is known for the past but not the
	// future (e.g. population of a city in a given year, or weather on a given
	// day).
	TimeVariantPastOnlyColumns []string `protobuf:"bytes,9,rep,name=time_variant_past_only_columns,json=timeVariantPastOnlyColumns,proto3" json:"time_variant_past_only_columns,omitempty"`
	// Column names that should be used as time variant past and future columns.
	// This column contains information for the given entity (identified by the
	// key column) that is known for the past and the future
	TimeVariantPastAndFutureColumns []string `protobuf:"bytes,10,rep,name=time_variant_past_and_future_columns,json=timeVariantPastAndFutureColumns,proto3" json:"time_variant_past_and_future_columns,omitempty"`
	// Expected difference in time granularity between rows in the data. If it is
	// not set, the period is inferred from data.
	Period *AutoMlForecastingInputs_Period `protobuf:"bytes,11,opt,name=period,proto3" json:"period,omitempty"`
	// The number of periods offset into the future as the start of the forecast
	// window (the window of future values to predict, relative to the present.),
	// where each period is one unit of granularity as defined by the `period`
	// field above. Default to 0. Inclusive.
	ForecastWindowStart int64 `protobuf:"varint,12,opt,name=forecast_window_start,json=forecastWindowStart,proto3" json:"forecast_window_start,omitempty"`
	// The number of periods offset into the future as the end of the forecast
	// window (the window of future values to predict, relative to the present.),
	// where each period is one unit of granularity as defined by the `period`
	// field above. Inclusive.
	ForecastWindowEnd int64 `protobuf:"varint,13,opt,name=forecast_window_end,json=forecastWindowEnd,proto3" json:"forecast_window_end,omitempty"`
	// The number of periods offset into the past to restrict past sequence, where
	// each period is one unit of granularity as defined by the `period`. Default
	// value 0 means that it lets algorithm to define the value. Inclusive.
	PastHorizon int64 `protobuf:"varint,14,opt,name=past_horizon,json=pastHorizon,proto3" json:"past_horizon,omitempty"`
	// Configuration for exporting test set predictions to a BigQuery table. If
	// this configuration is absent, then the export is not performed.
	ExportEvaluatedDataItemsConfig *ExportEvaluatedDataItemsConfig `protobuf:"bytes,15,opt,name=export_evaluated_data_items_config,json=exportEvaluatedDataItemsConfig,proto3" json:"export_evaluated_data_items_config,omitempty"`
}

func (x *AutoMlForecastingInputs) Reset() {
	*x = AutoMlForecastingInputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs) ProtoMessage() {}

func (x *AutoMlForecastingInputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1}
}

func (x *AutoMlForecastingInputs) GetTargetColumn() string {
	if x != nil {
		return x.TargetColumn
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTimeSeriesIdentifierColumn() string {
	if x != nil {
		return x.TimeSeriesIdentifierColumn
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTimeColumn() string {
	if x != nil {
		return x.TimeColumn
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTransformations() []*AutoMlForecastingInputs_Transformation {
	if x != nil {
		return x.Transformations
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetOptimizationObjective() string {
	if x != nil {
		return x.OptimizationObjective
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetTrainBudgetMilliNodeHours() int64 {
	if x != nil {
		return x.TrainBudgetMilliNodeHours
	}
	return 0
}

func (x *AutoMlForecastingInputs) GetWeightColumn() string {
	if x != nil {
		return x.WeightColumn
	}
	return ""
}

func (x *AutoMlForecastingInputs) GetStaticColumns() []string {
	if x != nil {
		return x.StaticColumns
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetTimeVariantPastOnlyColumns() []string {
	if x != nil {
		return x.TimeVariantPastOnlyColumns
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetTimeVariantPastAndFutureColumns() []string {
	if x != nil {
		return x.TimeVariantPastAndFutureColumns
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetPeriod() *AutoMlForecastingInputs_Period {
	if x != nil {
		return x.Period
	}
	return nil
}

func (x *AutoMlForecastingInputs) GetForecastWindowStart() int64 {
	if x != nil {
		return x.ForecastWindowStart
	}
	return 0
}

func (x *AutoMlForecastingInputs) GetForecastWindowEnd() int64 {
	if x != nil {
		return x.ForecastWindowEnd
	}
	return 0
}

func (x *AutoMlForecastingInputs) GetPastHorizon() int64 {
	if x != nil {
		return x.PastHorizon
	}
	return 0
}

func (x *AutoMlForecastingInputs) GetExportEvaluatedDataItemsConfig() *ExportEvaluatedDataItemsConfig {
	if x != nil {
		return x.ExportEvaluatedDataItemsConfig
	}
	return nil
}

// Model metadata specific to AutoML Forecasting.
type AutoMlForecastingMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The actual training cost of the model, expressed in milli
	// node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed
	// to not exceed the train budget.
	TrainCostMilliNodeHours int64 `protobuf:"varint,1,opt,name=train_cost_milli_node_hours,json=trainCostMilliNodeHours,proto3" json:"train_cost_milli_node_hours,omitempty"`
}

func (x *AutoMlForecastingMetadata) Reset() {
	*x = AutoMlForecastingMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingMetadata) ProtoMessage() {}

func (x *AutoMlForecastingMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingMetadata.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{2}
}

func (x *AutoMlForecastingMetadata) GetTrainCostMilliNodeHours() int64 {
	if x != nil {
		return x.TrainCostMilliNodeHours
	}
	return 0
}

type AutoMlForecastingInputs_Transformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transformation that the training pipeline will apply to the input
	// columns.
	//
	// Types that are assignable to TransformationDetail:
	//	*AutoMlForecastingInputs_Transformation_Auto
	//	*AutoMlForecastingInputs_Transformation_Numeric
	//	*AutoMlForecastingInputs_Transformation_Categorical
	//	*AutoMlForecastingInputs_Transformation_Timestamp
	//	*AutoMlForecastingInputs_Transformation_Text
	//	*AutoMlForecastingInputs_Transformation_RepeatedNumeric
	//	*AutoMlForecastingInputs_Transformation_RepeatedCategorical
	//	*AutoMlForecastingInputs_Transformation_RepeatedText
	TransformationDetail isAutoMlForecastingInputs_Transformation_TransformationDetail `protobuf_oneof:"transformation_detail"`
}

func (x *AutoMlForecastingInputs_Transformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0}
}

func (m *AutoMlForecastingInputs_Transformation) GetTransformationDetail() isAutoMlForecastingInputs_Transformation_TransformationDetail {
	if m != nil {
		return m.TransformationDetail
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetAuto() *AutoMlForecastingInputs_Transformation_AutoTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Auto); ok {
		return x.Auto
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetNumeric() *AutoMlForecastingInputs_Transformation_NumericTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Numeric); ok {
		return x.Numeric
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetCategorical() *AutoMlForecastingInputs_Transformation_CategoricalTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Categorical); ok {
		return x.Categorical
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetTimestamp() *AutoMlForecastingInputs_Transformation_TimestampTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Timestamp); ok {
		return x.Timestamp
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetText() *AutoMlForecastingInputs_Transformation_TextTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_Text); ok {
		return x.Text
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetRepeatedNumeric() *AutoMlForecastingInputs_Transformation_NumericArrayTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_RepeatedNumeric); ok {
		return x.RepeatedNumeric
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetRepeatedCategorical() *AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_RepeatedCategorical); ok {
		return x.RepeatedCategorical
	}
	return nil
}

func (x *AutoMlForecastingInputs_Transformation) GetRepeatedText() *AutoMlForecastingInputs_Transformation_TextArrayTransformation {
	if x, ok := x.GetTransformationDetail().(*AutoMlForecastingInputs_Transformation_RepeatedText); ok {
		return x.RepeatedText
	}
	return nil
}

type isAutoMlForecastingInputs_Transformation_TransformationDetail interface {
	isAutoMlForecastingInputs_Transformation_TransformationDetail()
}

type AutoMlForecastingInputs_Transformation_Auto struct {
	Auto *AutoMlForecastingInputs_Transformation_AutoTransformation `protobuf:"bytes,1,opt,name=auto,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_Numeric struct {
	Numeric *AutoMlForecastingInputs_Transformation_NumericTransformation `protobuf:"bytes,2,opt,name=numeric,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_Categorical struct {
	Categorical *AutoMlForecastingInputs_Transformation_CategoricalTransformation `protobuf:"bytes,3,opt,name=categorical,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_Timestamp struct {
	Timestamp *AutoMlForecastingInputs_Transformation_TimestampTransformation `protobuf:"bytes,4,opt,name=timestamp,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_Text struct {
	Text *AutoMlForecastingInputs_Transformation_TextTransformation `protobuf:"bytes,5,opt,name=text,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_RepeatedNumeric struct {
	RepeatedNumeric *AutoMlForecastingInputs_Transformation_NumericArrayTransformation `protobuf:"bytes,6,opt,name=repeated_numeric,json=repeatedNumeric,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_RepeatedCategorical struct {
	RepeatedCategorical *AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation `protobuf:"bytes,7,opt,name=repeated_categorical,json=repeatedCategorical,proto3,oneof"`
}

type AutoMlForecastingInputs_Transformation_RepeatedText struct {
	RepeatedText *AutoMlForecastingInputs_Transformation_TextArrayTransformation `protobuf:"bytes,8,opt,name=repeated_text,json=repeatedText,proto3,oneof"`
}

func (*AutoMlForecastingInputs_Transformation_Auto) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_Numeric) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_Categorical) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_Timestamp) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_Text) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_RepeatedNumeric) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_RepeatedCategorical) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

func (*AutoMlForecastingInputs_Transformation_RepeatedText) isAutoMlForecastingInputs_Transformation_TransformationDetail() {
}

// A duration of time expressed in time granularity units.
type AutoMlForecastingInputs_Period struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time granularity unit of this time period.
	// The supported unit are:
	//  "hour"
	//  "day"
	//  "week"
	//  "month"
	//  "year"
	Unit string `protobuf:"bytes,1,opt,name=unit,proto3" json:"unit,omitempty"`
	// The number of units per period, e.g. 3 weeks or 2 months.
	Quantity int64 `protobuf:"varint,2,opt,name=quantity,proto3" json:"quantity,omitempty"`
}

func (x *AutoMlForecastingInputs_Period) Reset() {
	*x = AutoMlForecastingInputs_Period{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Period) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Period) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Period) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Period.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Period) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 1}
}

func (x *AutoMlForecastingInputs_Period) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

func (x *AutoMlForecastingInputs_Period) GetQuantity() int64 {
	if x != nil {
		return x.Quantity
	}
	return 0
}

// Training pipeline will infer the proper transformation based on the
// statistic of dataset.
type AutoMlForecastingInputs_Transformation_AutoTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_AutoTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_AutoTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_AutoTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_AutoTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_AutoTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_AutoTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_AutoTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *AutoMlForecastingInputs_Transformation_AutoTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Training pipeline will perform following transformation functions.
// *  The value converted to float32.
// *  The z_score of the value.
// *  log(value+1) when the value is greater than or equal to 0. Otherwise,
//    this transformation is not applied and the value is considered a
//    missing value.
// *  z_score of log(value+1) when the value is greater than or equal to 0.
//    Otherwise, this transformation is not applied and the value is
//    considered a missing value.
// *  A boolean value that indicates whether the value is valid.
type AutoMlForecastingInputs_Transformation_NumericTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// If invalid values is allowed, the training pipeline will create a
	// boolean feature that indicated whether the value is valid.
	// Otherwise, the training pipeline will discard the input row from
	// trainining data.
	InvalidValuesAllowed bool `protobuf:"varint,2,opt,name=invalid_values_allowed,json=invalidValuesAllowed,proto3" json:"invalid_values_allowed,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_NumericTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_NumericTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_NumericTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_NumericTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0, 1}
}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *AutoMlForecastingInputs_Transformation_NumericTransformation) GetInvalidValuesAllowed() bool {
	if x != nil {
		return x.InvalidValuesAllowed
	}
	return false
}

// Training pipeline will perform following transformation functions.
// *  The categorical string as is--no change to case, punctuation,
// spelling,
//    tense, and so on.
// *  Convert the category name to a dictionary lookup index and generate an
//    embedding for each index.
// *  Categories that appear less than 5 times in the training dataset are
//    treated as the "unknown" category. The "unknown" category gets its own
//    special lookup index and resulting embedding.
type AutoMlForecastingInputs_Transformation_CategoricalTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_CategoricalTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_CategoricalTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_CategoricalTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_CategoricalTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_CategoricalTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0, 2}
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Training pipeline will perform following transformation functions.
// *  Apply the transformation functions for Numerical columns.
// *  Determine the year, month, day,and weekday. Treat each value from the
// *  timestamp as a Categorical column.
// *  Invalid numerical values (for example, values that fall outside of a
//    typical timestamp range, or are extreme values) receive no special
//    treatment and are not removed.
type AutoMlForecastingInputs_Transformation_TimestampTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// The format in which that time field is expressed. The time_format must
	// either be one of:
	// * `unix-seconds`
	// * `unix-milliseconds`
	// * `unix-microseconds`
	// * `unix-nanoseconds`
	// (for respectively number of seconds, milliseconds, microseconds and
	// nanoseconds since start of the Unix epoch);
	// or be written in `strftime` syntax. If time_format is not set, then the
	// default format is RFC 3339 `date-time` format, where
	// `time-offset` = `"Z"` (e.g. 1985-04-12T23:20:50.52Z)
	TimeFormat string `protobuf:"bytes,2,opt,name=time_format,json=timeFormat,proto3" json:"time_format,omitempty"`
	// If invalid values is allowed, the training pipeline will create a
	// boolean feature that indicated whether the value is valid.
	// Otherwise, the training pipeline will discard the input row from
	// trainining data.
	InvalidValuesAllowed bool `protobuf:"varint,3,opt,name=invalid_values_allowed,json=invalidValuesAllowed,proto3" json:"invalid_values_allowed,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_TimestampTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_TimestampTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_TimestampTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_TimestampTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0, 3}
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) GetTimeFormat() string {
	if x != nil {
		return x.TimeFormat
	}
	return ""
}

func (x *AutoMlForecastingInputs_Transformation_TimestampTransformation) GetInvalidValuesAllowed() bool {
	if x != nil {
		return x.InvalidValuesAllowed
	}
	return false
}

// Training pipeline will perform following transformation functions.
// *  The text as is--no change to case, punctuation, spelling, tense, and
// so
//    on.
// *  Tokenize text to words. Convert each words to a dictionary lookup
// index
//    and generate an embedding for each index. Combine the embedding of all
//    elements into a single embedding using the mean.
// *  Tokenization is based on unicode script boundaries.
// *  Missing values get their own lookup index and resulting embedding.
// *  Stop-words receive no special treatment and are not removed.
type AutoMlForecastingInputs_Transformation_TextTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_TextTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_TextTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_TextTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_TextTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_TextTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_TextTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_TextTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0, 4}
}

func (x *AutoMlForecastingInputs_Transformation_TextTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Treats the column as numerical array and performs following
// transformation functions.
// *  All transformations for Numerical types applied to the average of the
//    all elements.
// *  The average of empty arrays is treated as zero.
type AutoMlForecastingInputs_Transformation_NumericArrayTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// If invalid values is allowed, the training pipeline will create a
	// boolean feature that indicated whether the value is valid.
	// Otherwise, the training pipeline will discard the input row from
	// trainining data.
	InvalidValuesAllowed bool `protobuf:"varint,2,opt,name=invalid_values_allowed,json=invalidValuesAllowed,proto3" json:"invalid_values_allowed,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_NumericArrayTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_NumericArrayTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_NumericArrayTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_NumericArrayTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_NumericArrayTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_NumericArrayTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_NumericArrayTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0, 5}
}

func (x *AutoMlForecastingInputs_Transformation_NumericArrayTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *AutoMlForecastingInputs_Transformation_NumericArrayTransformation) GetInvalidValuesAllowed() bool {
	if x != nil {
		return x.InvalidValuesAllowed
	}
	return false
}

// Treats the column as categorical array and performs following
// transformation functions.
// *  For each element in the array, convert the category name to a
// dictionary
//    lookup index and generate an embedding for each index.
//    Combine the embedding of all elements into a single embedding using
//    the mean.
// *  Empty arrays treated as an embedding of zeroes.
type AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0, 6}
}

func (x *AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

// Treats the column as text array and performs following transformation
// functions.
// *  Concatenate all text values in the array into a single text value
// using
//    a space (" ") as a delimiter, and then treat the result as a single
//    text value. Apply the transformations for Text columns.
// *  Empty arrays treated as an empty text.
type AutoMlForecastingInputs_Transformation_TextArrayTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
}

func (x *AutoMlForecastingInputs_Transformation_TextArrayTransformation) Reset() {
	*x = AutoMlForecastingInputs_Transformation_TextArrayTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlForecastingInputs_Transformation_TextArrayTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlForecastingInputs_Transformation_TextArrayTransformation) ProtoMessage() {}

func (x *AutoMlForecastingInputs_Transformation_TextArrayTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlForecastingInputs_Transformation_TextArrayTransformation.ProtoReflect.Descriptor instead.
func (*AutoMlForecastingInputs_Transformation_TextArrayTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP(), []int{1, 0, 7}
}

func (x *AutoMlForecastingInputs_Transformation_TextArrayTransformation) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDesc = []byte{
	0x0a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x66, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf9, 0x01,
	0x0a, 0x11, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x6e, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x52, 0x06, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x74, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xd7, 0x18, 0x0a, 0x17, 0x41, 0x75,
	0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x41, 0x0a, 0x1d, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x1a, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1f, 0x0a,
	0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x8f,
	0x01, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x35, 0x0a, 0x16, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x15, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x40, 0x0a, 0x1d, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69,
	0x4e, 0x6f, 0x64, 0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x25,
	0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x1e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x74, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x5f,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1a, 0x74,
	0x69, 0x6d, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x50, 0x61, 0x73, 0x74, 0x4f, 0x6e,
	0x6c, 0x79, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x24, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x74, 0x5f, 0x61,
	0x6e, 0x64, 0x5f, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1f, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x50, 0x61, 0x73, 0x74, 0x41, 0x6e, 0x64, 0x46, 0x75, 0x74, 0x75, 0x72,
	0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x75, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x2e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12,
	0x32, 0x0a, 0x15, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13,
	0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x11, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x45, 0x6e, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x73, 0x74, 0x5f, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x73, 0x74, 0x48,
	0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x12, 0xa9, 0x01, 0x0a, 0x22, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x1e, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0xe4, 0x0f, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e, 0x01, 0x0a, 0x04, 0x61, 0x75, 0x74, 0x6f, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63,
	0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x04, 0x61, 0x75, 0x74, 0x6f, 0x12, 0x97, 0x01, 0x0a, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x7b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63,
	0x12, 0xa3, 0x01, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x7f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x9d, 0x01, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x7d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e,
	0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d,
	0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x8e, 0x01, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x78,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0xae, 0x01, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x80, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x12, 0xba, 0x01, 0x0a, 0x14, 0x72, 0x65, 0x70,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x84, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x41, 0x72, 0x72, 0x61, 0x79,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x13, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x69, 0x63, 0x61, 0x6c, 0x12, 0xa4, 0x01, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x7d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a,
	0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c,
	0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x1a, 0x35, 0x0a, 0x12,
	0x41, 0x75, 0x74, 0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x1a, 0x6e, 0x0a, 0x15, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a,
	0x16, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x1a, 0x3c, 0x0a, 0x19, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x1a, 0x91, 0x01, 0x0a, 0x17, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12,
	0x34, 0x0a, 0x16, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x41, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x1a, 0x35, 0x0a, 0x12, 0x54, 0x65, 0x78, 0x74, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x73, 0x0a, 0x1a,
	0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x69,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x1a, 0x41, 0x0a, 0x1e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x41, 0x72, 0x72, 0x61, 0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x3a, 0x0a, 0x17, 0x54, 0x65, 0x78, 0x74, 0x41, 0x72, 0x72, 0x61,
	0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65,
	0x42, 0x17, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x1a, 0x38, 0x0a, 0x06, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x22, 0x59, 0x0a, 0x19, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x3c, 0x0a, 0x1b, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d,
	0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x73, 0x74,
	0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x42, 0xc6,
	0x01, 0x0a, 0x41, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x16, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x4c, 0x46, 0x6f, 0x72, 0x65,
	0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x67,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f,
	0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3b, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_goTypes = []interface{}{
	(*AutoMlForecasting)(nil),                                                     // 0: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecasting
	(*AutoMlForecastingInputs)(nil),                                               // 1: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs
	(*AutoMlForecastingMetadata)(nil),                                             // 2: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingMetadata
	(*AutoMlForecastingInputs_Transformation)(nil),                                // 3: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation
	(*AutoMlForecastingInputs_Period)(nil),                                        // 4: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Period
	(*AutoMlForecastingInputs_Transformation_AutoTransformation)(nil),             // 5: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.AutoTransformation
	(*AutoMlForecastingInputs_Transformation_NumericTransformation)(nil),          // 6: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.NumericTransformation
	(*AutoMlForecastingInputs_Transformation_CategoricalTransformation)(nil),      // 7: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.CategoricalTransformation
	(*AutoMlForecastingInputs_Transformation_TimestampTransformation)(nil),        // 8: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TimestampTransformation
	(*AutoMlForecastingInputs_Transformation_TextTransformation)(nil),             // 9: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TextTransformation
	(*AutoMlForecastingInputs_Transformation_NumericArrayTransformation)(nil),     // 10: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.NumericArrayTransformation
	(*AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation)(nil), // 11: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.CategoricalArrayTransformation
	(*AutoMlForecastingInputs_Transformation_TextArrayTransformation)(nil),        // 12: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TextArrayTransformation
	(*ExportEvaluatedDataItemsConfig)(nil),                                        // 13: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.ExportEvaluatedDataItemsConfig
}
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_depIdxs = []int32{
	1,  // 0: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecasting.inputs:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs
	2,  // 1: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecasting.metadata:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingMetadata
	3,  // 2: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.transformations:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation
	4,  // 3: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.period:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Period
	13, // 4: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.export_evaluated_data_items_config:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.ExportEvaluatedDataItemsConfig
	5,  // 5: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.auto:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.AutoTransformation
	6,  // 6: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.numeric:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.NumericTransformation
	7,  // 7: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.categorical:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.CategoricalTransformation
	8,  // 8: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.timestamp:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TimestampTransformation
	9,  // 9: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.text:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TextTransformation
	10, // 10: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.repeated_numeric:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.NumericArrayTransformation
	11, // 11: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.repeated_categorical:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.CategoricalArrayTransformation
	12, // 12: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.repeated_text:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlForecastingInputs.Transformation.TextArrayTransformation
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() {
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_init()
}
func file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_export_evaluated_data_items_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecasting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Period); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_AutoTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_NumericTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_CategoricalTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_TimestampTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_TextTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_NumericArrayTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_CategoricalArrayTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlForecastingInputs_Transformation_TextArrayTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*AutoMlForecastingInputs_Transformation_Auto)(nil),
		(*AutoMlForecastingInputs_Transformation_Numeric)(nil),
		(*AutoMlForecastingInputs_Transformation_Categorical)(nil),
		(*AutoMlForecastingInputs_Transformation_Timestamp)(nil),
		(*AutoMlForecastingInputs_Transformation_Text)(nil),
		(*AutoMlForecastingInputs_Transformation_RepeatedNumeric)(nil),
		(*AutoMlForecastingInputs_Transformation_RepeatedCategorical)(nil),
		(*AutoMlForecastingInputs_Transformation_RepeatedText)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto = out.File
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_forecasting_proto_depIdxs = nil
}
