// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/talent/v4beta1/profile.proto

package talent

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The format of a structured resume.
type Resume_ResumeType int32

const (
	// Default value.
	Resume_RESUME_TYPE_UNSPECIFIED Resume_ResumeType = 0
	// The profile contents in HR-XML format.
	// See https://schemas.liquid-technologies.com/hr-xml/2007-04-15/ for more
	// information about Human Resources XML.
	Resume_HRXML Resume_ResumeType = 1
	// Resume type not specified.
	Resume_OTHER_RESUME_TYPE Resume_ResumeType = 2
)

// Enum value maps for Resume_ResumeType.
var (
	Resume_ResumeType_name = map[int32]string{
		0: "RESUME_TYPE_UNSPECIFIED",
		1: "HRXML",
		2: "OTHER_RESUME_TYPE",
	}
	Resume_ResumeType_value = map[string]int32{
		"RESUME_TYPE_UNSPECIFIED": 0,
		"HRXML":                   1,
		"OTHER_RESUME_TYPE":       2,
	}
)

func (x Resume_ResumeType) Enum() *Resume_ResumeType {
	p := new(Resume_ResumeType)
	*p = x
	return p
}

func (x Resume_ResumeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Resume_ResumeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_profile_proto_enumTypes[0].Descriptor()
}

func (Resume_ResumeType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_profile_proto_enumTypes[0]
}

func (x Resume_ResumeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Resume_ResumeType.Descriptor instead.
func (Resume_ResumeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{2, 0}
}

// Enum that represents the type of the telephone.
type Phone_PhoneType int32

const (
	// Default value.
	Phone_PHONE_TYPE_UNSPECIFIED Phone_PhoneType = 0
	// A landline.
	Phone_LANDLINE Phone_PhoneType = 1
	// A mobile.
	Phone_MOBILE Phone_PhoneType = 2
	// A fax.
	Phone_FAX Phone_PhoneType = 3
	// A pager.
	Phone_PAGER Phone_PhoneType = 4
	// A TTY (test telephone) or TDD (telecommunication device for the deaf).
	Phone_TTY_OR_TDD Phone_PhoneType = 5
	// A voicemail.
	Phone_VOICEMAIL Phone_PhoneType = 6
	// A virtual telephone number is a number that can be routed to another
	// number and managed by the user via Web, SMS, IVR, and so on.  It is
	// associated with a particular person, and may be routed to either a MOBILE
	// or LANDLINE number. The [phone usage][google.cloud.talent.v4beta1.ContactInfoUsage] should
	// be set to PERSONAL for these phone types. Some more information can be
	// found here: https://en.wikipedia.org/wiki/Personal_Numbers
	Phone_VIRTUAL Phone_PhoneType = 7
	// Voice over IP numbers. This includes TSoIP (Telephony Service over IP).
	Phone_VOIP Phone_PhoneType = 8
	// In some regions (e.g. the USA), it is impossible to distinguish between
	// fixed-line and mobile numbers by looking at the phone number itself.
	Phone_MOBILE_OR_LANDLINE Phone_PhoneType = 9
)

// Enum value maps for Phone_PhoneType.
var (
	Phone_PhoneType_name = map[int32]string{
		0: "PHONE_TYPE_UNSPECIFIED",
		1: "LANDLINE",
		2: "MOBILE",
		3: "FAX",
		4: "PAGER",
		5: "TTY_OR_TDD",
		6: "VOICEMAIL",
		7: "VIRTUAL",
		8: "VOIP",
		9: "MOBILE_OR_LANDLINE",
	}
	Phone_PhoneType_value = map[string]int32{
		"PHONE_TYPE_UNSPECIFIED": 0,
		"LANDLINE":               1,
		"MOBILE":                 2,
		"FAX":                    3,
		"PAGER":                  4,
		"TTY_OR_TDD":             5,
		"VOICEMAIL":              6,
		"VIRTUAL":                7,
		"VOIP":                   8,
		"MOBILE_OR_LANDLINE":     9,
	}
)

func (x Phone_PhoneType) Enum() *Phone_PhoneType {
	p := new(Phone_PhoneType)
	*p = x
	return p
}

func (x Phone_PhoneType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Phone_PhoneType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_profile_proto_enumTypes[1].Descriptor()
}

func (Phone_PhoneType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_profile_proto_enumTypes[1]
}

func (x Phone_PhoneType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Phone_PhoneType.Descriptor instead.
func (Phone_PhoneType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{6, 0}
}

// A resource that represents the profile for a job candidate (also referred to
// as a "single-source profile").
type Profile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required during profile update.
	//
	// Resource name assigned to a profile by the API.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
	// for example, "projects/foo/tenants/bar/profiles/baz".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Profile's id in client system, if available. This value is unique for each
	// profile inside a tenant. An error is thrown if another profile with the
	// same external_id is created.
	//
	// The maximum number of bytes allowed is 100.
	ExternalId string `protobuf:"bytes,2,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	// The source description indicating where the profile is acquired.
	//
	// For example, if a candidate profile is acquired from a resume, the user can
	// input "resume" here to indicate the source.
	//
	// The maximum number of bytes allowed is 100.
	Source string `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// The URI set by clients that links to this profile's client-side copy.
	//
	// The maximum number of bytes allowed is 4000.
	Uri string `protobuf:"bytes,4,opt,name=uri,proto3" json:"uri,omitempty"`
	// The cluster id of the profile to associate with other profile(s) for the
	// same candidate.
	//
	// This field should be generated by the customer. If a value is not provided,
	// a random UUID is assigned to this field of the profile.
	//
	// This is used to link multiple profiles to the same candidate. For example,
	// a client has a candidate with two profiles, where one was created recently
	// and the other one was created 5 years ago. These two profiles may be very
	// different. The clients can create the first profile and get a generated
	// [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
	// indicating these two profiles are referring to the same candidate.
	GroupId string `protobuf:"bytes,5,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Indicates the hirable status of the candidate.
	IsHirable *wrapperspb.BoolValue `protobuf:"bytes,6,opt,name=is_hirable,json=isHirable,proto3" json:"is_hirable,omitempty"`
	// The timestamp when the profile was first created at this source.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The timestamp when the profile was last updated at this source.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The timestamp when the profile was last updated as a result of a direct or
	// indirect action by a candidate.
	//
	// These actions include:
	//
	// * Direct actions such as the candidate submitting a new resume as part of a
	// job application to the agency, using a self-service tool such as a website
	// to update their profile, and so on.
	// * Indirect actions by the candidate such as uploading a resume to a job
	// board that is collected by the agency through a feed, providing a resume to
	// a recruiter who then uploads it into the ATS, and so on.
	// * Updates made to the candidate's profile by the recruiter as a result of
	// interacting with the candidate (for example adding a skill or work
	// preference, and so on). Changes to [recruiting_notes][google.cloud.talent.v4beta1.Profile.recruiting_notes] are specifically
	// excluded from this action type.
	//
	// Note: [candidate_update_time][google.cloud.talent.v4beta1.Profile.candidate_update_time] must be greater than or equal to
	// [resume_update_time][google.cloud.talent.v4beta1.Profile.resume_update_time] or an error is thrown.
	CandidateUpdateTime *timestamppb.Timestamp `protobuf:"bytes,67,opt,name=candidate_update_time,json=candidateUpdateTime,proto3" json:"candidate_update_time,omitempty"`
	// The timestamp when the candidate's resume was added or updated on the
	// candidate's profile. Whether that resume was directly uploaded by a
	// candidate, pulled from a 3rd party job board feed, added by a recruiter,
	// and so on.
	//
	// If this field is updated, it's expected that [resume][google.cloud.talent.v4beta1.Profile.resume] is provided in
	// the create or update calls.
	ResumeUpdateTime *timestamppb.Timestamp `protobuf:"bytes,68,opt,name=resume_update_time,json=resumeUpdateTime,proto3" json:"resume_update_time,omitempty"`
	// The resume representing this profile.
	Resume *Resume `protobuf:"bytes,53,opt,name=resume,proto3" json:"resume,omitempty"`
	// The names of the candidate this profile references.
	//
	// Currently only one person name is supported.
	PersonNames []*PersonName `protobuf:"bytes,11,rep,name=person_names,json=personNames,proto3" json:"person_names,omitempty"`
	// The candidate's postal addresses. It's highly recommended to
	// input this information as accurately as possible to help improve search
	// quality. Here are some recommendations:
	//
	// * Provide [Address.usage][google.cloud.talent.v4beta1.Address.usage] if possible, especially if the address is
	// PERSONAL. During a search only personal addresses are considered. If there
	// is no such address, all addresses with unspecified usage are assumed to be
	// personal.
	// * Provide [Address.current][google.cloud.talent.v4beta1.Address.current] for the current address if possible. During
	// a search, only current addresses are considered. If there is no such
	// address, all addresses are assumed to be current.
	//
	// When displaying a candidate's addresses, it is sometimes desirable to limit
	// the number of addresses shown. In these cases we recommend that you display
	// the addresses in the following order of priority:
	// 1. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
	// 2. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not
	// set.
	// 3. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
	// [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
	// 4. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
	// [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not set.
	Addresses []*Address `protobuf:"bytes,12,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// The candidate's email addresses.
	EmailAddresses []*Email `protobuf:"bytes,13,rep,name=email_addresses,json=emailAddresses,proto3" json:"email_addresses,omitempty"`
	// The candidate's phone number(s).
	PhoneNumbers []*Phone `protobuf:"bytes,14,rep,name=phone_numbers,json=phoneNumbers,proto3" json:"phone_numbers,omitempty"`
	// The candidate's personal URIs.
	PersonalUris []*PersonalUri `protobuf:"bytes,15,rep,name=personal_uris,json=personalUris,proto3" json:"personal_uris,omitempty"`
	// Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
	// [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
	AdditionalContactInfo []*AdditionalContactInfo `protobuf:"bytes,16,rep,name=additional_contact_info,json=additionalContactInfo,proto3" json:"additional_contact_info,omitempty"`
	// The employment history records of the candidate. It's highly recommended
	// to input this information as accurately as possible to help improve search
	// quality. Here are some recommendations:
	//
	// * Specify the start and end dates of the employment records.
	// * List different employment types separately, no matter how minor the
	// change is.
	// For example, only job title is changed from "software engineer" to "senior
	// software engineer".
	// * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
	// possible. If not, it's inferred from user inputs.
	//
	// The limitation for max number of employment records is 100.
	EmploymentRecords []*EmploymentRecord `protobuf:"bytes,17,rep,name=employment_records,json=employmentRecords,proto3" json:"employment_records,omitempty"`
	// The education history record of the candidate. It's highly recommended to
	// input this information as accurately as possible to help improve search
	// quality. Here are some recommendations:
	//
	// * Specify the start and end dates of the education records.
	// * List each education type separately, no matter how minor the change is.
	// For example, the profile contains the education experience from the same
	// school but different degrees.
	// * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
	// possible. If not, it's inferred from user inputs.
	//
	// The limitation for max number of education records is 100.
	EducationRecords []*EducationRecord `protobuf:"bytes,18,rep,name=education_records,json=educationRecords,proto3" json:"education_records,omitempty"`
	// The skill set of the candidate. It's highly recommended to provide as
	// much information as possible to help improve the search quality.
	//
	// The limitation for max number of skills is 500.
	Skills []*Skill `protobuf:"bytes,19,rep,name=skills,proto3" json:"skills,omitempty"`
	// The individual or collaborative activities which the candidate has
	// participated in, for example, open-source projects, class assignments that
	// aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	//
	// The limitation for max number of activities is 50.
	Activities []*Activity `protobuf:"bytes,20,rep,name=activities,proto3" json:"activities,omitempty"`
	// The publications published by the candidate.
	//
	// The limitation for max number of publications is 50.
	Publications []*Publication `protobuf:"bytes,21,rep,name=publications,proto3" json:"publications,omitempty"`
	// The patents acquired by the candidate.
	Patents []*Patent `protobuf:"bytes,22,rep,name=patents,proto3" json:"patents,omitempty"`
	// The certifications acquired by the candidate.
	Certifications []*Certification `protobuf:"bytes,23,rep,name=certifications,proto3" json:"certifications,omitempty"`
	// Output only. The resource names of the candidate's applications.
	Applications []string `protobuf:"bytes,47,rep,name=applications,proto3" json:"applications,omitempty"`
	// Output only. The resource names of the candidate's assignments.
	Assignments []string `protobuf:"bytes,48,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// A map of fields to hold both filterable and non-filterable custom profile
	// attributes that aren't covered by the provided structured fields. See
	// [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
	//
	// At most 100 filterable and at most 100 unfilterable keys are supported. If
	// limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
	// by default. These are filterable when the `filterable` flag is set to
	// `true`.
	//
	// Numeric custom attributes: each key can only map to one numeric value,
	// otherwise an error is thrown. Client can also filter on numeric custom
	// attributes using '>', '<' or '=' operators.
	//
	// String custom attributes: each key can map up to 50 string values. For
	// filterable string value, each value has a byte size of no more than 256B.
	// For unfilterable string values, the maximum byte size of a single key is
	// 64B. An error is thrown for any request exceeding the limit.
	// The maximum total byte size is 10KB.
	CustomAttributes map[string]*CustomAttribute `protobuf:"bytes,26,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Indicates if a summarized profile was created as part of the
	// profile creation API call. This flag does not indicate whether a profile is
	// searchable or not.
	Processed bool `protobuf:"varint,27,opt,name=processed,proto3" json:"processed,omitempty"`
	// Output only. Keyword snippet shows how the search result is related to a
	// search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
	KeywordSnippet string `protobuf:"bytes,28,opt,name=keyword_snippet,json=keywordSnippet,proto3" json:"keyword_snippet,omitempty"`
	// Output only. Candidate's availability signals.
	AvailabilitySignals []*AvailabilitySignal `protobuf:"bytes,70,rep,name=availability_signals,json=availabilitySignals,proto3" json:"availability_signals,omitempty"`
	// Output only. Derived locations of the profile, resolved from [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses].
	//
	// [derived_addresses][google.cloud.talent.v4beta1.Profile.derived_addresses] are exactly matched to [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] in the
	// same order.
	DerivedAddresses []*Location `protobuf:"bytes,64,rep,name=derived_addresses,json=derivedAddresses,proto3" json:"derived_addresses,omitempty"`
}

func (x *Profile) Reset() {
	*x = Profile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Profile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Profile) ProtoMessage() {}

func (x *Profile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Profile.ProtoReflect.Descriptor instead.
func (*Profile) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{0}
}

func (x *Profile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Profile) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

func (x *Profile) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *Profile) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Profile) GetGroupId() string {
	if x != nil {
		return x.GroupId
	}
	return ""
}

func (x *Profile) GetIsHirable() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsHirable
	}
	return nil
}

func (x *Profile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Profile) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Profile) GetCandidateUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CandidateUpdateTime
	}
	return nil
}

func (x *Profile) GetResumeUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ResumeUpdateTime
	}
	return nil
}

func (x *Profile) GetResume() *Resume {
	if x != nil {
		return x.Resume
	}
	return nil
}

func (x *Profile) GetPersonNames() []*PersonName {
	if x != nil {
		return x.PersonNames
	}
	return nil
}

func (x *Profile) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *Profile) GetEmailAddresses() []*Email {
	if x != nil {
		return x.EmailAddresses
	}
	return nil
}

func (x *Profile) GetPhoneNumbers() []*Phone {
	if x != nil {
		return x.PhoneNumbers
	}
	return nil
}

func (x *Profile) GetPersonalUris() []*PersonalUri {
	if x != nil {
		return x.PersonalUris
	}
	return nil
}

func (x *Profile) GetAdditionalContactInfo() []*AdditionalContactInfo {
	if x != nil {
		return x.AdditionalContactInfo
	}
	return nil
}

func (x *Profile) GetEmploymentRecords() []*EmploymentRecord {
	if x != nil {
		return x.EmploymentRecords
	}
	return nil
}

func (x *Profile) GetEducationRecords() []*EducationRecord {
	if x != nil {
		return x.EducationRecords
	}
	return nil
}

func (x *Profile) GetSkills() []*Skill {
	if x != nil {
		return x.Skills
	}
	return nil
}

func (x *Profile) GetActivities() []*Activity {
	if x != nil {
		return x.Activities
	}
	return nil
}

func (x *Profile) GetPublications() []*Publication {
	if x != nil {
		return x.Publications
	}
	return nil
}

func (x *Profile) GetPatents() []*Patent {
	if x != nil {
		return x.Patents
	}
	return nil
}

func (x *Profile) GetCertifications() []*Certification {
	if x != nil {
		return x.Certifications
	}
	return nil
}

func (x *Profile) GetApplications() []string {
	if x != nil {
		return x.Applications
	}
	return nil
}

func (x *Profile) GetAssignments() []string {
	if x != nil {
		return x.Assignments
	}
	return nil
}

func (x *Profile) GetCustomAttributes() map[string]*CustomAttribute {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

func (x *Profile) GetProcessed() bool {
	if x != nil {
		return x.Processed
	}
	return false
}

func (x *Profile) GetKeywordSnippet() string {
	if x != nil {
		return x.KeywordSnippet
	}
	return ""
}

func (x *Profile) GetAvailabilitySignals() []*AvailabilitySignal {
	if x != nil {
		return x.AvailabilitySignals
	}
	return nil
}

func (x *Profile) GetDerivedAddresses() []*Location {
	if x != nil {
		return x.DerivedAddresses
	}
	return nil
}

// Candidate availability signal.
type AvailabilitySignal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of signal.
	Type AvailabilitySignalType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.AvailabilitySignalType" json:"type,omitempty"`
	// Timestamp of when the given availability activity last happened.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// Indicates if the [last_update_time][google.cloud.talent.v4beta1.AvailabilitySignal.last_update_time] is within
	// [AvailabilityFilter.range][google.cloud.talent.v4beta1.AvailabilityFilter.range].
	//
	// Returned only in a search response when there is an [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter]
	// in [ProfileQuery.availability_filters][google.cloud.talent.v4beta1.ProfileQuery.availability_filters] where
	// [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type] matches [type][google.cloud.talent.v4beta1.AvailabilitySignal.type].
	FilterSatisfied *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=filter_satisfied,json=filterSatisfied,proto3" json:"filter_satisfied,omitempty"`
}

func (x *AvailabilitySignal) Reset() {
	*x = AvailabilitySignal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvailabilitySignal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailabilitySignal) ProtoMessage() {}

func (x *AvailabilitySignal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailabilitySignal.ProtoReflect.Descriptor instead.
func (*AvailabilitySignal) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{1}
}

func (x *AvailabilitySignal) GetType() AvailabilitySignalType {
	if x != nil {
		return x.Type
	}
	return AvailabilitySignalType_AVAILABILITY_SIGNAL_TYPE_UNSPECIFIED
}

func (x *AvailabilitySignal) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *AvailabilitySignal) GetFilterSatisfied() *wrapperspb.BoolValue {
	if x != nil {
		return x.FilterSatisfied
	}
	return nil
}

// Resource that represents a resume.
type Resume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Users can create a profile with only this field field, if [resume_type][google.cloud.talent.v4beta1.Resume.resume_type]
	// is [HRXML][google.cloud.talent.v4beta1.Resume.ResumeType.HRXML]. For example, the API parses this field and
	// creates a profile
	// with all structured fields populated. [EmploymentRecord][google.cloud.talent.v4beta1.EmploymentRecord],
	// [EducationRecord][google.cloud.talent.v4beta1.EducationRecord], and so on. An error is thrown if this field cannot be
	// parsed.
	//
	// Note that the use of the functionality offered by this field to extract
	// data from resumes is an Alpha feature and as such is not covered by any
	// SLA.
	StructuredResume string `protobuf:"bytes,1,opt,name=structured_resume,json=structuredResume,proto3" json:"structured_resume,omitempty"`
	// The format of [structured_resume][google.cloud.talent.v4beta1.Resume.structured_resume].
	ResumeType Resume_ResumeType `protobuf:"varint,2,opt,name=resume_type,json=resumeType,proto3,enum=google.cloud.talent.v4beta1.Resume_ResumeType" json:"resume_type,omitempty"`
}

func (x *Resume) Reset() {
	*x = Resume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resume) ProtoMessage() {}

func (x *Resume) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resume.ProtoReflect.Descriptor instead.
func (*Resume) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{2}
}

func (x *Resume) GetStructuredResume() string {
	if x != nil {
		return x.StructuredResume
	}
	return ""
}

func (x *Resume) GetResumeType() Resume_ResumeType {
	if x != nil {
		return x.ResumeType
	}
	return Resume_RESUME_TYPE_UNSPECIFIED
}

// Resource that represents the name of a person.
type PersonName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of a person. It can be one of
	// [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name] or
	// [structured_name][google.cloud.talent.v4beta1.PersonName.structured_name].
	//
	// Types that are assignable to PersonName:
	//	*PersonName_FormattedName
	//	*PersonName_StructuredName
	PersonName isPersonName_PersonName `protobuf_oneof:"person_name"`
	// Preferred name for the person. This field is ignored if [structured_name][google.cloud.talent.v4beta1.PersonName.structured_name]
	// is provided.
	//
	// Number of characters allowed is 100.
	PreferredName string `protobuf:"bytes,3,opt,name=preferred_name,json=preferredName,proto3" json:"preferred_name,omitempty"`
}

func (x *PersonName) Reset() {
	*x = PersonName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonName) ProtoMessage() {}

func (x *PersonName) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonName.ProtoReflect.Descriptor instead.
func (*PersonName) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{3}
}

func (m *PersonName) GetPersonName() isPersonName_PersonName {
	if m != nil {
		return m.PersonName
	}
	return nil
}

func (x *PersonName) GetFormattedName() string {
	if x, ok := x.GetPersonName().(*PersonName_FormattedName); ok {
		return x.FormattedName
	}
	return ""
}

func (x *PersonName) GetStructuredName() *PersonName_PersonStructuredName {
	if x, ok := x.GetPersonName().(*PersonName_StructuredName); ok {
		return x.StructuredName
	}
	return nil
}

func (x *PersonName) GetPreferredName() string {
	if x != nil {
		return x.PreferredName
	}
	return ""
}

type isPersonName_PersonName interface {
	isPersonName_PersonName()
}

type PersonName_FormattedName struct {
	// A string represents a person's full name. For example, "Dr. John Smith".
	//
	// Number of characters allowed is 100.
	FormattedName string `protobuf:"bytes,1,opt,name=formatted_name,json=formattedName,proto3,oneof"`
}

type PersonName_StructuredName struct {
	// A person's name in a structured way (last name, first name, suffix, and
	// so on.)
	StructuredName *PersonName_PersonStructuredName `protobuf:"bytes,2,opt,name=structured_name,json=structuredName,proto3,oneof"`
}

func (*PersonName_FormattedName) isPersonName_PersonName() {}

func (*PersonName_StructuredName) isPersonName_PersonName() {}

// Resource that represents a address.
type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The usage of the address. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// The address of a person. It can be one of
	// [unstructured_address][google.cloud.talent.v4beta1.Address.unstructured_address] or
	// [structured_address][google.cloud.talent.v4beta1.Address.structured_address].
	//
	// Types that are assignable to Address:
	//	*Address_UnstructuredAddress
	//	*Address_StructuredAddress
	Address isAddress_Address `protobuf_oneof:"address"`
	// Indicates if it's the person's current address.
	Current *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=current,proto3" json:"current,omitempty"`
}

func (x *Address) Reset() {
	*x = Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{4}
}

func (x *Address) GetUsage() ContactInfoUsage {
	if x != nil {
		return x.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (m *Address) GetAddress() isAddress_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (x *Address) GetUnstructuredAddress() string {
	if x, ok := x.GetAddress().(*Address_UnstructuredAddress); ok {
		return x.UnstructuredAddress
	}
	return ""
}

func (x *Address) GetStructuredAddress() *postaladdress.PostalAddress {
	if x, ok := x.GetAddress().(*Address_StructuredAddress); ok {
		return x.StructuredAddress
	}
	return nil
}

func (x *Address) GetCurrent() *wrapperspb.BoolValue {
	if x != nil {
		return x.Current
	}
	return nil
}

type isAddress_Address interface {
	isAddress_Address()
}

type Address_UnstructuredAddress struct {
	// Unstructured address.
	//
	// For example, "1600 Amphitheatre Pkwy, Mountain View, CA 94043",
	// "Sunnyvale, California".
	//
	// Number of characters allowed is 100.
	UnstructuredAddress string `protobuf:"bytes,2,opt,name=unstructured_address,json=unstructuredAddress,proto3,oneof"`
}

type Address_StructuredAddress struct {
	// Structured address that contains street address, city, state, country,
	// and so on.
	StructuredAddress *postaladdress.PostalAddress `protobuf:"bytes,3,opt,name=structured_address,json=structuredAddress,proto3,oneof"`
}

func (*Address_UnstructuredAddress) isAddress_Address() {}

func (*Address_StructuredAddress) isAddress_Address() {}

// Resource that represents a person's email address.
type Email struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The usage of the email address. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// Email address.
	//
	// Number of characters allowed is 4,000.
	EmailAddress string `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
}

func (x *Email) Reset() {
	*x = Email{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Email) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Email) ProtoMessage() {}

func (x *Email) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Email.ProtoReflect.Descriptor instead.
func (*Email) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{5}
}

func (x *Email) GetUsage() ContactInfoUsage {
	if x != nil {
		return x.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (x *Email) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

// Resource that represents a person's telephone number.
type Phone struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The usage of the phone. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// The phone type. For example, LANDLINE, MOBILE, FAX.
	Type Phone_PhoneType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.Phone_PhoneType" json:"type,omitempty"`
	// Phone number.
	//
	// Any phone formats are supported and only exact matches are performed on
	// searches. For example, if a phone number in profile is provided in the
	// format of "(xxx)xxx-xxxx", in profile searches the same phone format
	// has to be provided.
	//
	// Number of characters allowed is 20.
	Number string `protobuf:"bytes,3,opt,name=number,proto3" json:"number,omitempty"`
	// When this number is available. Any descriptive string is expected.
	//
	// Number of characters allowed is 100.
	WhenAvailable string `protobuf:"bytes,4,opt,name=when_available,json=whenAvailable,proto3" json:"when_available,omitempty"`
}

func (x *Phone) Reset() {
	*x = Phone{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Phone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Phone) ProtoMessage() {}

func (x *Phone) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Phone.ProtoReflect.Descriptor instead.
func (*Phone) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{6}
}

func (x *Phone) GetUsage() ContactInfoUsage {
	if x != nil {
		return x.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (x *Phone) GetType() Phone_PhoneType {
	if x != nil {
		return x.Type
	}
	return Phone_PHONE_TYPE_UNSPECIFIED
}

func (x *Phone) GetNumber() string {
	if x != nil {
		return x.Number
	}
	return ""
}

func (x *Phone) GetWhenAvailable() string {
	if x != nil {
		return x.WhenAvailable
	}
	return ""
}

// Resource that represents a valid URI for a personal use.
type PersonalUri struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The personal URI.
	//
	// Number of characters allowed is 4,000.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *PersonalUri) Reset() {
	*x = PersonalUri{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonalUri) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonalUri) ProtoMessage() {}

func (x *PersonalUri) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonalUri.ProtoReflect.Descriptor instead.
func (*PersonalUri) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{7}
}

func (x *PersonalUri) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Resource that represents contact information other than phone, email,
// URI and addresses.
type AdditionalContactInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The usage of this contact method. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// The name of the contact method.
	//
	// For example, "hangout", "skype".
	//
	// Number of characters allowed is 100.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The contact id.
	//
	// Number of characters allowed is 100.
	ContactId string `protobuf:"bytes,3,opt,name=contact_id,json=contactId,proto3" json:"contact_id,omitempty"`
}

func (x *AdditionalContactInfo) Reset() {
	*x = AdditionalContactInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdditionalContactInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdditionalContactInfo) ProtoMessage() {}

func (x *AdditionalContactInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdditionalContactInfo.ProtoReflect.Descriptor instead.
func (*AdditionalContactInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{8}
}

func (x *AdditionalContactInfo) GetUsage() ContactInfoUsage {
	if x != nil {
		return x.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (x *AdditionalContactInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AdditionalContactInfo) GetContactId() string {
	if x != nil {
		return x.ContactId
	}
	return ""
}

// Resource that represents an employment record of a candidate.
type EmploymentRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start date of the employment.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date of the employment.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// The name of the employer company/organization.
	//
	// For example, "Google", "Alphabet", and so on.
	//
	// Number of characters allowed is 250.
	EmployerName string `protobuf:"bytes,3,opt,name=employer_name,json=employerName,proto3" json:"employer_name,omitempty"`
	// The division name of the employment.
	//
	// For example, division, department, client, and so on.
	//
	// Number of characters allowed is 100.
	DivisionName string `protobuf:"bytes,4,opt,name=division_name,json=divisionName,proto3" json:"division_name,omitempty"`
	// The physical address of the employer.
	Address *Address `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	// The job title of the employment.
	//
	// For example, "Software Engineer", "Data Scientist", and so on.
	//
	// Number of characters allowed is 250.
	JobTitle string `protobuf:"bytes,6,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// The description of job content.
	//
	// Number of characters allowed is 100,000.
	JobDescription string `protobuf:"bytes,7,opt,name=job_description,json=jobDescription,proto3" json:"job_description,omitempty"`
	// If the jobs is a supervisor position.
	IsSupervisor *wrapperspb.BoolValue `protobuf:"bytes,8,opt,name=is_supervisor,json=isSupervisor,proto3" json:"is_supervisor,omitempty"`
	// If this employment is self-employed.
	IsSelfEmployed *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=is_self_employed,json=isSelfEmployed,proto3" json:"is_self_employed,omitempty"`
	// If this employment is current.
	IsCurrent *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=is_current,json=isCurrent,proto3" json:"is_current,omitempty"`
	// Output only. The job title snippet shows how the [job_title][google.cloud.talent.v4beta1.EmploymentRecord.job_title] is related
	// to a search query. It's empty if the [job_title][google.cloud.talent.v4beta1.EmploymentRecord.job_title] isn't related to the
	// search query.
	JobTitleSnippet string `protobuf:"bytes,11,opt,name=job_title_snippet,json=jobTitleSnippet,proto3" json:"job_title_snippet,omitempty"`
	// Output only. The job description snippet shows how the [job_description][google.cloud.talent.v4beta1.EmploymentRecord.job_description]
	// is related to a search query. It's empty if the [job_description][google.cloud.talent.v4beta1.EmploymentRecord.job_description] isn't
	// related to the search query.
	JobDescriptionSnippet string `protobuf:"bytes,12,opt,name=job_description_snippet,json=jobDescriptionSnippet,proto3" json:"job_description_snippet,omitempty"`
	// Output only. The employer name snippet shows how the [employer_name][google.cloud.talent.v4beta1.EmploymentRecord.employer_name] is
	// related to a search query. It's empty if the [employer_name][google.cloud.talent.v4beta1.EmploymentRecord.employer_name] isn't
	// related to the search query.
	EmployerNameSnippet string `protobuf:"bytes,13,opt,name=employer_name_snippet,json=employerNameSnippet,proto3" json:"employer_name_snippet,omitempty"`
}

func (x *EmploymentRecord) Reset() {
	*x = EmploymentRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EmploymentRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmploymentRecord) ProtoMessage() {}

func (x *EmploymentRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmploymentRecord.ProtoReflect.Descriptor instead.
func (*EmploymentRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{9}
}

func (x *EmploymentRecord) GetStartDate() *date.Date {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *EmploymentRecord) GetEndDate() *date.Date {
	if x != nil {
		return x.EndDate
	}
	return nil
}

func (x *EmploymentRecord) GetEmployerName() string {
	if x != nil {
		return x.EmployerName
	}
	return ""
}

func (x *EmploymentRecord) GetDivisionName() string {
	if x != nil {
		return x.DivisionName
	}
	return ""
}

func (x *EmploymentRecord) GetAddress() *Address {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *EmploymentRecord) GetJobTitle() string {
	if x != nil {
		return x.JobTitle
	}
	return ""
}

func (x *EmploymentRecord) GetJobDescription() string {
	if x != nil {
		return x.JobDescription
	}
	return ""
}

func (x *EmploymentRecord) GetIsSupervisor() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsSupervisor
	}
	return nil
}

func (x *EmploymentRecord) GetIsSelfEmployed() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsSelfEmployed
	}
	return nil
}

func (x *EmploymentRecord) GetIsCurrent() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsCurrent
	}
	return nil
}

func (x *EmploymentRecord) GetJobTitleSnippet() string {
	if x != nil {
		return x.JobTitleSnippet
	}
	return ""
}

func (x *EmploymentRecord) GetJobDescriptionSnippet() string {
	if x != nil {
		return x.JobDescriptionSnippet
	}
	return ""
}

func (x *EmploymentRecord) GetEmployerNameSnippet() string {
	if x != nil {
		return x.EmployerNameSnippet
	}
	return ""
}

// Resource that represents an education record of a candidate.
type EducationRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start date of the education.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The end date of the education.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// The expected graduation date if currently pursuing a degree.
	ExpectedGraduationDate *date.Date `protobuf:"bytes,3,opt,name=expected_graduation_date,json=expectedGraduationDate,proto3" json:"expected_graduation_date,omitempty"`
	// The name of the school or institution.
	//
	// For example, "Stanford University", "UC Berkeley", and so on.
	//
	// Number of characters allowed is 250.
	SchoolName string `protobuf:"bytes,4,opt,name=school_name,json=schoolName,proto3" json:"school_name,omitempty"`
	// The physical address of the education institution.
	Address *Address `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	// The degree information. It can be one of
	// [degree_description][google.cloud.talent.v4beta1.EducationRecord.degree_description] or
	// [structured_degree][google.cloud.talent.v4beta1.EducationRecord.structured_degree].
	//
	// Types that are assignable to Degree:
	//	*EducationRecord_DegreeDescription
	//	*EducationRecord_StructuredDegree
	Degree isEducationRecord_Degree `protobuf_oneof:"degree"`
	// The description of the education.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	// If this education is current.
	IsCurrent *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=is_current,json=isCurrent,proto3" json:"is_current,omitempty"`
	// Output only. The school name snippet shows how the [school_name][google.cloud.talent.v4beta1.EducationRecord.school_name] is related to a
	// search query in search result. It's empty if the [school_name][google.cloud.talent.v4beta1.EducationRecord.school_name] isn't
	// related to the search query.
	SchoolNameSnippet string `protobuf:"bytes,10,opt,name=school_name_snippet,json=schoolNameSnippet,proto3" json:"school_name_snippet,omitempty"`
	// Output only. The job description snippet shows how the [Degree][google.cloud.talent.v4beta1.Degree] is related to a search
	// query in search result. It's empty if the [Degree][google.cloud.talent.v4beta1.Degree] isn't related to the
	// search query.
	DegreeSnippet string `protobuf:"bytes,11,opt,name=degree_snippet,json=degreeSnippet,proto3" json:"degree_snippet,omitempty"`
}

func (x *EducationRecord) Reset() {
	*x = EducationRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EducationRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EducationRecord) ProtoMessage() {}

func (x *EducationRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EducationRecord.ProtoReflect.Descriptor instead.
func (*EducationRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{10}
}

func (x *EducationRecord) GetStartDate() *date.Date {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *EducationRecord) GetEndDate() *date.Date {
	if x != nil {
		return x.EndDate
	}
	return nil
}

func (x *EducationRecord) GetExpectedGraduationDate() *date.Date {
	if x != nil {
		return x.ExpectedGraduationDate
	}
	return nil
}

func (x *EducationRecord) GetSchoolName() string {
	if x != nil {
		return x.SchoolName
	}
	return ""
}

func (x *EducationRecord) GetAddress() *Address {
	if x != nil {
		return x.Address
	}
	return nil
}

func (m *EducationRecord) GetDegree() isEducationRecord_Degree {
	if m != nil {
		return m.Degree
	}
	return nil
}

func (x *EducationRecord) GetDegreeDescription() string {
	if x, ok := x.GetDegree().(*EducationRecord_DegreeDescription); ok {
		return x.DegreeDescription
	}
	return ""
}

func (x *EducationRecord) GetStructuredDegree() *Degree {
	if x, ok := x.GetDegree().(*EducationRecord_StructuredDegree); ok {
		return x.StructuredDegree
	}
	return nil
}

func (x *EducationRecord) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EducationRecord) GetIsCurrent() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsCurrent
	}
	return nil
}

func (x *EducationRecord) GetSchoolNameSnippet() string {
	if x != nil {
		return x.SchoolNameSnippet
	}
	return ""
}

func (x *EducationRecord) GetDegreeSnippet() string {
	if x != nil {
		return x.DegreeSnippet
	}
	return ""
}

type isEducationRecord_Degree interface {
	isEducationRecord_Degree()
}

type EducationRecord_DegreeDescription struct {
	// The full description of the degree.
	//
	// For example, "Master of Science in Computer Science", "B.S in Math".
	//
	// Number of characters allowed is 100.
	DegreeDescription string `protobuf:"bytes,6,opt,name=degree_description,json=degreeDescription,proto3,oneof"`
}

type EducationRecord_StructuredDegree struct {
	// The structured notation of the degree.
	StructuredDegree *Degree `protobuf:"bytes,7,opt,name=structured_degree,json=structuredDegree,proto3,oneof"`
}

func (*EducationRecord_DegreeDescription) isEducationRecord_Degree() {}

func (*EducationRecord_StructuredDegree) isEducationRecord_Degree() {}

// Resource that represents a degree pursuing or acquired by a candidate.
type Degree struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ISCED degree type.
	DegreeType DegreeType `protobuf:"varint,1,opt,name=degree_type,json=degreeType,proto3,enum=google.cloud.talent.v4beta1.DegreeType" json:"degree_type,omitempty"`
	// Full Degree name.
	//
	// For example, "B.S.", "Master of Arts", and so on.
	//
	// Number of characters allowed is 100.
	DegreeName string `protobuf:"bytes,2,opt,name=degree_name,json=degreeName,proto3" json:"degree_name,omitempty"`
	// Fields of study for the degree.
	//
	// For example, "Computer science", "engineering".
	//
	// Number of characters allowed is 100.
	FieldsOfStudy []string `protobuf:"bytes,3,rep,name=fields_of_study,json=fieldsOfStudy,proto3" json:"fields_of_study,omitempty"`
}

func (x *Degree) Reset() {
	*x = Degree{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Degree) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Degree) ProtoMessage() {}

func (x *Degree) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Degree.ProtoReflect.Descriptor instead.
func (*Degree) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{11}
}

func (x *Degree) GetDegreeType() DegreeType {
	if x != nil {
		return x.DegreeType
	}
	return DegreeType_DEGREE_TYPE_UNSPECIFIED
}

func (x *Degree) GetDegreeName() string {
	if x != nil {
		return x.DegreeName
	}
	return ""
}

func (x *Degree) GetFieldsOfStudy() []string {
	if x != nil {
		return x.FieldsOfStudy
	}
	return nil
}

// Resource that represents an individual or collaborative activity participated
// in by a candidate, for example, an open-source project, a class assignment,
// and so on.
type Activity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Activity display name.
	//
	// Number of characters allowed is 100.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Activity description.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Activity URI.
	//
	// Number of characters allowed is 4,000.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// The first creation date of the activity.
	CreateDate *date.Date `protobuf:"bytes,4,opt,name=create_date,json=createDate,proto3" json:"create_date,omitempty"`
	// The last update date of the activity.
	UpdateDate *date.Date `protobuf:"bytes,5,opt,name=update_date,json=updateDate,proto3" json:"update_date,omitempty"`
	// A list of team members involved in this activity.
	//
	// Number of characters allowed is 100.
	//
	// The limitation for max number of team members is 50.
	TeamMembers []string `protobuf:"bytes,6,rep,name=team_members,json=teamMembers,proto3" json:"team_members,omitempty"`
	// A list of skills used in this activity.
	//
	// The limitation for max number of skills used is 50.
	SkillsUsed []*Skill `protobuf:"bytes,7,rep,name=skills_used,json=skillsUsed,proto3" json:"skills_used,omitempty"`
	// Output only. Activity name snippet shows how the [display_name][google.cloud.talent.v4beta1.Activity.display_name] is related to a search
	// query. It's empty if the [display_name][google.cloud.talent.v4beta1.Activity.display_name] isn't related to the search
	// query.
	ActivityNameSnippet string `protobuf:"bytes,8,opt,name=activity_name_snippet,json=activityNameSnippet,proto3" json:"activity_name_snippet,omitempty"`
	// Output only. Activity description snippet shows how the
	// [description][google.cloud.talent.v4beta1.Activity.description] is related to a search query. It's empty if the
	// [description][google.cloud.talent.v4beta1.Activity.description] isn't related to the search query.
	ActivityDescriptionSnippet string `protobuf:"bytes,9,opt,name=activity_description_snippet,json=activityDescriptionSnippet,proto3" json:"activity_description_snippet,omitempty"`
	// Output only. Skill used snippet shows how the corresponding
	// [skills_used][google.cloud.talent.v4beta1.Activity.skills_used] are related to a search query. It's empty if the
	// corresponding [skills_used][google.cloud.talent.v4beta1.Activity.skills_used] are not related to the search query.
	SkillsUsedSnippet []string `protobuf:"bytes,10,rep,name=skills_used_snippet,json=skillsUsedSnippet,proto3" json:"skills_used_snippet,omitempty"`
}

func (x *Activity) Reset() {
	*x = Activity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Activity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Activity) ProtoMessage() {}

func (x *Activity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Activity.ProtoReflect.Descriptor instead.
func (*Activity) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{12}
}

func (x *Activity) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Activity) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Activity) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Activity) GetCreateDate() *date.Date {
	if x != nil {
		return x.CreateDate
	}
	return nil
}

func (x *Activity) GetUpdateDate() *date.Date {
	if x != nil {
		return x.UpdateDate
	}
	return nil
}

func (x *Activity) GetTeamMembers() []string {
	if x != nil {
		return x.TeamMembers
	}
	return nil
}

func (x *Activity) GetSkillsUsed() []*Skill {
	if x != nil {
		return x.SkillsUsed
	}
	return nil
}

func (x *Activity) GetActivityNameSnippet() string {
	if x != nil {
		return x.ActivityNameSnippet
	}
	return ""
}

func (x *Activity) GetActivityDescriptionSnippet() string {
	if x != nil {
		return x.ActivityDescriptionSnippet
	}
	return ""
}

func (x *Activity) GetSkillsUsedSnippet() []string {
	if x != nil {
		return x.SkillsUsedSnippet
	}
	return nil
}

// Resource that represents a publication resource of a candidate.
type Publication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of author names.
	//
	// Number of characters allowed is 100.
	Authors []string `protobuf:"bytes,1,rep,name=authors,proto3" json:"authors,omitempty"`
	// The title of the publication.
	//
	// Number of characters allowed is 100.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// The description of the publication.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The journal name of the publication.
	//
	// Number of characters allowed is 100.
	Journal string `protobuf:"bytes,4,opt,name=journal,proto3" json:"journal,omitempty"`
	// Volume number.
	//
	// Number of characters allowed is 100.
	Volume string `protobuf:"bytes,5,opt,name=volume,proto3" json:"volume,omitempty"`
	// The publisher of the journal.
	//
	// Number of characters allowed is 100.
	Publisher string `protobuf:"bytes,6,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// The publication date.
	PublicationDate *date.Date `protobuf:"bytes,7,opt,name=publication_date,json=publicationDate,proto3" json:"publication_date,omitempty"`
	// The publication type.
	//
	// Number of characters allowed is 100.
	PublicationType string `protobuf:"bytes,8,opt,name=publication_type,json=publicationType,proto3" json:"publication_type,omitempty"`
	// ISBN number.
	//
	// Number of characters allowed is 100.
	Isbn string `protobuf:"bytes,9,opt,name=isbn,proto3" json:"isbn,omitempty"`
}

func (x *Publication) Reset() {
	*x = Publication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Publication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Publication) ProtoMessage() {}

func (x *Publication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Publication.ProtoReflect.Descriptor instead.
func (*Publication) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{13}
}

func (x *Publication) GetAuthors() []string {
	if x != nil {
		return x.Authors
	}
	return nil
}

func (x *Publication) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Publication) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Publication) GetJournal() string {
	if x != nil {
		return x.Journal
	}
	return ""
}

func (x *Publication) GetVolume() string {
	if x != nil {
		return x.Volume
	}
	return ""
}

func (x *Publication) GetPublisher() string {
	if x != nil {
		return x.Publisher
	}
	return ""
}

func (x *Publication) GetPublicationDate() *date.Date {
	if x != nil {
		return x.PublicationDate
	}
	return nil
}

func (x *Publication) GetPublicationType() string {
	if x != nil {
		return x.PublicationType
	}
	return ""
}

func (x *Publication) GetIsbn() string {
	if x != nil {
		return x.Isbn
	}
	return ""
}

// Resource that represents the patent acquired by a candidate.
type Patent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the patent.
	//
	// Number of characters allowed is 100.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A list of inventors' names.
	//
	// Number of characters allowed for each is 100.
	Inventors []string `protobuf:"bytes,2,rep,name=inventors,proto3" json:"inventors,omitempty"`
	// The status of the patent.
	//
	// Number of characters allowed is 100.
	PatentStatus string `protobuf:"bytes,3,opt,name=patent_status,json=patentStatus,proto3" json:"patent_status,omitempty"`
	// The date the last time the status of the patent was checked.
	PatentStatusDate *date.Date `protobuf:"bytes,4,opt,name=patent_status_date,json=patentStatusDate,proto3" json:"patent_status_date,omitempty"`
	// The date that the patent was filed.
	PatentFilingDate *date.Date `protobuf:"bytes,5,opt,name=patent_filing_date,json=patentFilingDate,proto3" json:"patent_filing_date,omitempty"`
	// The name of the patent office.
	//
	// Number of characters allowed is 100.
	PatentOffice string `protobuf:"bytes,6,opt,name=patent_office,json=patentOffice,proto3" json:"patent_office,omitempty"`
	// The number of the patent.
	//
	// Number of characters allowed is 100.
	PatentNumber string `protobuf:"bytes,7,opt,name=patent_number,json=patentNumber,proto3" json:"patent_number,omitempty"`
	// The description of the patent.
	//
	// Number of characters allowed is 100,000.
	PatentDescription string `protobuf:"bytes,8,opt,name=patent_description,json=patentDescription,proto3" json:"patent_description,omitempty"`
	// The skills used in this patent.
	SkillsUsed []*Skill `protobuf:"bytes,9,rep,name=skills_used,json=skillsUsed,proto3" json:"skills_used,omitempty"`
}

func (x *Patent) Reset() {
	*x = Patent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Patent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Patent) ProtoMessage() {}

func (x *Patent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Patent.ProtoReflect.Descriptor instead.
func (*Patent) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{14}
}

func (x *Patent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Patent) GetInventors() []string {
	if x != nil {
		return x.Inventors
	}
	return nil
}

func (x *Patent) GetPatentStatus() string {
	if x != nil {
		return x.PatentStatus
	}
	return ""
}

func (x *Patent) GetPatentStatusDate() *date.Date {
	if x != nil {
		return x.PatentStatusDate
	}
	return nil
}

func (x *Patent) GetPatentFilingDate() *date.Date {
	if x != nil {
		return x.PatentFilingDate
	}
	return nil
}

func (x *Patent) GetPatentOffice() string {
	if x != nil {
		return x.PatentOffice
	}
	return ""
}

func (x *Patent) GetPatentNumber() string {
	if x != nil {
		return x.PatentNumber
	}
	return ""
}

func (x *Patent) GetPatentDescription() string {
	if x != nil {
		return x.PatentDescription
	}
	return ""
}

func (x *Patent) GetSkillsUsed() []*Skill {
	if x != nil {
		return x.SkillsUsed
	}
	return nil
}

// Resource that represents a person's structured name.
type PersonName_PersonStructuredName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Given/first name.
	//
	// It's derived from [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name] if not provided.
	//
	// Number of characters allowed is 100.
	GivenName string `protobuf:"bytes,1,opt,name=given_name,json=givenName,proto3" json:"given_name,omitempty"`
	// Preferred given/first name or nickname.
	//
	// Number of characters allowed is 100.
	PreferredName string `protobuf:"bytes,6,opt,name=preferred_name,json=preferredName,proto3" json:"preferred_name,omitempty"`
	// Middle initial.
	//
	// It's derived from [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name] if not provided.
	//
	// Number of characters allowed is 20.
	MiddleInitial string `protobuf:"bytes,2,opt,name=middle_initial,json=middleInitial,proto3" json:"middle_initial,omitempty"`
	// Family/last name.
	//
	// It's derived from [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name] if not provided.
	//
	// Number of characters allowed is 100.
	FamilyName string `protobuf:"bytes,3,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// Suffixes.
	//
	// Number of characters allowed is 20.
	Suffixes []string `protobuf:"bytes,4,rep,name=suffixes,proto3" json:"suffixes,omitempty"`
	// Prefixes.
	//
	// Number of characters allowed is 20.
	Prefixes []string `protobuf:"bytes,5,rep,name=prefixes,proto3" json:"prefixes,omitempty"`
}

func (x *PersonName_PersonStructuredName) Reset() {
	*x = PersonName_PersonStructuredName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonName_PersonStructuredName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonName_PersonStructuredName) ProtoMessage() {}

func (x *PersonName_PersonStructuredName) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_profile_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonName_PersonStructuredName.ProtoReflect.Descriptor instead.
func (*PersonName_PersonStructuredName) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP(), []int{3, 0}
}

func (x *PersonName_PersonStructuredName) GetGivenName() string {
	if x != nil {
		return x.GivenName
	}
	return ""
}

func (x *PersonName_PersonStructuredName) GetPreferredName() string {
	if x != nil {
		return x.PreferredName
	}
	return ""
}

func (x *PersonName_PersonStructuredName) GetMiddleInitial() string {
	if x != nil {
		return x.MiddleInitial
	}
	return ""
}

func (x *PersonName_PersonStructuredName) GetFamilyName() string {
	if x != nil {
		return x.FamilyName
	}
	return ""
}

func (x *PersonName_PersonStructuredName) GetSuffixes() []string {
	if x != nil {
		return x.Suffixes
	}
	return nil
}

func (x *PersonName_PersonStructuredName) GetPrefixes() []string {
	if x != nil {
		return x.Prefixes
	}
	return nil
}

var File_google_cloud_talent_v4beta1_profile_proto protoreflect.FileDescriptor

var file_google_cloud_talent_v4beta1_profile_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa6, 0x11, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x69, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x39, 0x0a,
	0x0a, 0x69, 0x73, 0x5f, 0x68, 0x69, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x69,
	0x73, 0x48, 0x69, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x15, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x43, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x13, 0x63,
	0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x44, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x72, 0x65, 0x73, 0x75,
	0x6d, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x18, 0x35, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d,
	0x65, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x0c, 0x70, 0x65, 0x72,
	0x73, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x65,
	0x72, 0x73, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x09,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0f, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x52, 0x0e, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x0d, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x6e,
	0x65, 0x52, 0x0c, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12,
	0x4d, 0x0a, 0x0d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x69, 0x73,
	0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x69,
	0x52, 0x0c, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x12, 0x6a,
	0x0a, 0x17, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5c, 0x0a, 0x12, 0x65, 0x6d,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73,
	0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x11, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x12, 0x59, 0x0a, 0x11, 0x65, 0x64, 0x75, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x12, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x52, 0x10, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x73, 0x12, 0x3a, 0x0a, 0x06, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x73, 0x18, 0x13, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x6b, 0x69, 0x6c, 0x6c, 0x52, 0x06, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x73, 0x12,
	0x45, 0x0a, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x14, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x07, 0x70, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x70, 0x61, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x52, 0x0a, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x2f, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x25, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x30, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x67, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x1a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x12, 0x21, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x18, 0x1b, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x73,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x12, 0x67, 0x0a, 0x14, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x18, 0x46, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x12, 0x57, 0x0a, 0x11, 0x64, 0x65,
	0x72, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18,
	0x40, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x10, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x1a, 0x71, 0x0a, 0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x58, 0xea, 0x41, 0x55, 0x0a, 0x1b, 0x6a, 0x6f, 0x62,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x7d,
	0x22, 0xea, 0x01, 0x0a, 0x12, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x53, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x64, 0x22, 0xd3, 0x01,
	0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x75, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x2e,
	0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x75,
	0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x4b, 0x0a, 0x0a, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x52, 0x58, 0x4d, 0x4c, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11,
	0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x10, 0x02, 0x22, 0xb3, 0x03, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x0f, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x2e, 0x50, 0x65,
	0x72, 0x73, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x4e, 0x61,
	0x6d, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65,
	0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xdc, 0x01, 0x0a, 0x14,
	0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x69,
	0x64, 0x64, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x65, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x70, 0x65,
	0x72, 0x73, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x91, 0x02, 0x0a, 0x07, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x43, 0x0a, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x12, 0x33, 0x0a, 0x14, 0x75, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x13, 0x75, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x4b, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x61, 0x6c,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x11, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x34, 0x0a, 0x07,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x71, 0x0a,
	0x05, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x43, 0x0a, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x22, 0xf3, 0x02, 0x0a, 0x05, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x6e,
	0x65, 0x2e, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x77, 0x68, 0x65,
	0x6e, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x77, 0x68, 0x65, 0x6e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0xa3, 0x01, 0x0a, 0x09, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x16, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x41,
	0x4e, 0x44, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x42, 0x49,
	0x4c, 0x45, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x46, 0x41, 0x58, 0x10, 0x03, 0x12, 0x09, 0x0a,
	0x05, 0x50, 0x41, 0x47, 0x45, 0x52, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x54, 0x59, 0x5f,
	0x4f, 0x52, 0x5f, 0x54, 0x44, 0x44, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x4f, 0x49, 0x43,
	0x45, 0x4d, 0x41, 0x49, 0x4c, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x56, 0x49, 0x52, 0x54, 0x55,
	0x41, 0x4c, 0x10, 0x07, 0x12, 0x08, 0x0a, 0x04, 0x56, 0x4f, 0x49, 0x50, 0x10, 0x08, 0x12, 0x16,
	0x0a, 0x12, 0x4d, 0x4f, 0x42, 0x49, 0x4c, 0x45, 0x5f, 0x4f, 0x52, 0x5f, 0x4c, 0x41, 0x4e, 0x44,
	0x4c, 0x49, 0x4e, 0x45, 0x10, 0x09, 0x22, 0x1f, 0x0a, 0x0b, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x61, 0x6c, 0x55, 0x72, 0x69, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0x8f, 0x01, 0x0a, 0x15, 0x41, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x43, 0x0a, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x49, 0x64, 0x22, 0xab, 0x05, 0x0a, 0x10, 0x45, 0x6d,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x30,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65,
	0x12, 0x2c, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x69, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52,
	0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6a, 0x6f, 0x62, 0x5f,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6a, 0x6f, 0x62,
	0x54, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6a, 0x6f, 0x62, 0x5f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x6a, 0x6f, 0x62, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f,
	0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0c, 0x69, 0x73, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x12,
	0x44, 0x0a, 0x10, 0x69, 0x73, 0x5f, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x65, 0x6d, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x69, 0x73, 0x53, 0x65, 0x6c, 0x66, 0x45, 0x6d, 0x70,
	0x6c, 0x6f, 0x79, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x69, 0x73, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x2f, 0x0a, 0x11, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x5f, 0x73, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x6a, 0x6f, 0x62, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x12, 0x3b, 0x0a, 0x17, 0x6a, 0x6f, 0x62, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x6a, 0x6f, 0x62, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x37,
	0x0a, 0x15, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x13, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x22, 0xec, 0x04, 0x0a, 0x0f, 0x45, 0x64, 0x75, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x30, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x4b, 0x0a, 0x18, 0x65,
	0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x67, 0x72, 0x61, 0x64, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x52, 0x16, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x47, 0x72, 0x61, 0x64, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x6f,
	0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73,
	0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x07, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2f, 0x0a, 0x12, 0x64, 0x65, 0x67,
	0x72, 0x65, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x11, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65, 0x48, 0x00, 0x52, 0x10, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x39, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x09, 0x69, 0x73, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x73,
	0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70,
	0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73,
	0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x12, 0x2a, 0x0a, 0x0e, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70,
	0x65, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64,
	0x65, 0x67, 0x72, 0x65, 0x65, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x42, 0x08, 0x0a, 0x06,
	0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x67, 0x72, 0x65,
	0x65, 0x12, 0x48, 0x0a, 0x0b, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0a, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x65, 0x67, 0x72, 0x65, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x74, 0x75, 0x64, 0x79, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x4f, 0x66, 0x53,
	0x74, 0x75, 0x64, 0x79, 0x22, 0xe6, 0x03, 0x0a, 0x08, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x32, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x44, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x74, 0x65, 0x61, 0x6d, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x65, 0x61, 0x6d, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x12, 0x43, 0x0a, 0x0b, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x73, 0x5f, 0x75, 0x73,
	0x65, 0x64, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6b, 0x69, 0x6c, 0x6c, 0x52, 0x0a, 0x73, 0x6b,
	0x69, 0x6c, 0x6c, 0x73, 0x55, 0x73, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x15, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x12, 0x45, 0x0a, 0x1c, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x73, 0x6b, 0x69, 0x6c,
	0x6c, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x6b, 0x69, 0x6c,
	0x6c, 0x73, 0x55, 0x73, 0x65, 0x64, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x22, 0xac, 0x02,
	0x0a, 0x0b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a,
	0x07, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12,
	0x3c, 0x0a, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x29, 0x0a,
	0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x69, 0x73, 0x62, 0x6e,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x69, 0x73, 0x62, 0x6e, 0x22, 0xae, 0x03, 0x0a,
	0x06, 0x50, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x69,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x70, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3f, 0x0a,
	0x12, 0x70, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x10, 0x70, 0x61,
	0x74, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x61, 0x74, 0x65, 0x12, 0x3f,
	0x0a, 0x12, 0x70, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x10, 0x70,
	0x61, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x70, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x4f, 0x66,
	0x66, 0x69, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x74,
	0x65, 0x6e, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x12, 0x70, 0x61, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x61, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0b, 0x73, 0x6b, 0x69, 0x6c,
	0x6c, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6b, 0x69, 0x6c,
	0x6c, 0x52, 0x0a, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x73, 0x55, 0x73, 0x65, 0x64, 0x42, 0x82, 0x01,
	0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x42, 0x14, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0xa2, 0x02, 0x03, 0x43,
	0x54, 0x53, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_talent_v4beta1_profile_proto_rawDescOnce sync.Once
	file_google_cloud_talent_v4beta1_profile_proto_rawDescData = file_google_cloud_talent_v4beta1_profile_proto_rawDesc
)

func file_google_cloud_talent_v4beta1_profile_proto_rawDescGZIP() []byte {
	file_google_cloud_talent_v4beta1_profile_proto_rawDescOnce.Do(func() {
		file_google_cloud_talent_v4beta1_profile_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_talent_v4beta1_profile_proto_rawDescData)
	})
	return file_google_cloud_talent_v4beta1_profile_proto_rawDescData
}

var file_google_cloud_talent_v4beta1_profile_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_talent_v4beta1_profile_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_talent_v4beta1_profile_proto_goTypes = []interface{}{
	(Resume_ResumeType)(0),                  // 0: google.cloud.talent.v4beta1.Resume.ResumeType
	(Phone_PhoneType)(0),                    // 1: google.cloud.talent.v4beta1.Phone.PhoneType
	(*Profile)(nil),                         // 2: google.cloud.talent.v4beta1.Profile
	(*AvailabilitySignal)(nil),              // 3: google.cloud.talent.v4beta1.AvailabilitySignal
	(*Resume)(nil),                          // 4: google.cloud.talent.v4beta1.Resume
	(*PersonName)(nil),                      // 5: google.cloud.talent.v4beta1.PersonName
	(*Address)(nil),                         // 6: google.cloud.talent.v4beta1.Address
	(*Email)(nil),                           // 7: google.cloud.talent.v4beta1.Email
	(*Phone)(nil),                           // 8: google.cloud.talent.v4beta1.Phone
	(*PersonalUri)(nil),                     // 9: google.cloud.talent.v4beta1.PersonalUri
	(*AdditionalContactInfo)(nil),           // 10: google.cloud.talent.v4beta1.AdditionalContactInfo
	(*EmploymentRecord)(nil),                // 11: google.cloud.talent.v4beta1.EmploymentRecord
	(*EducationRecord)(nil),                 // 12: google.cloud.talent.v4beta1.EducationRecord
	(*Degree)(nil),                          // 13: google.cloud.talent.v4beta1.Degree
	(*Activity)(nil),                        // 14: google.cloud.talent.v4beta1.Activity
	(*Publication)(nil),                     // 15: google.cloud.talent.v4beta1.Publication
	(*Patent)(nil),                          // 16: google.cloud.talent.v4beta1.Patent
	nil,                                     // 17: google.cloud.talent.v4beta1.Profile.CustomAttributesEntry
	(*PersonName_PersonStructuredName)(nil), // 18: google.cloud.talent.v4beta1.PersonName.PersonStructuredName
	(*wrapperspb.BoolValue)(nil),            // 19: google.protobuf.BoolValue
	(*timestamppb.Timestamp)(nil),           // 20: google.protobuf.Timestamp
	(*Skill)(nil),                           // 21: google.cloud.talent.v4beta1.Skill
	(*Certification)(nil),                   // 22: google.cloud.talent.v4beta1.Certification
	(*Location)(nil),                        // 23: google.cloud.talent.v4beta1.Location
	(AvailabilitySignalType)(0),             // 24: google.cloud.talent.v4beta1.AvailabilitySignalType
	(ContactInfoUsage)(0),                   // 25: google.cloud.talent.v4beta1.ContactInfoUsage
	(*postaladdress.PostalAddress)(nil),     // 26: google.type.PostalAddress
	(*date.Date)(nil),                       // 27: google.type.Date
	(DegreeType)(0),                         // 28: google.cloud.talent.v4beta1.DegreeType
	(*CustomAttribute)(nil),                 // 29: google.cloud.talent.v4beta1.CustomAttribute
}
var file_google_cloud_talent_v4beta1_profile_proto_depIdxs = []int32{
	19, // 0: google.cloud.talent.v4beta1.Profile.is_hirable:type_name -> google.protobuf.BoolValue
	20, // 1: google.cloud.talent.v4beta1.Profile.create_time:type_name -> google.protobuf.Timestamp
	20, // 2: google.cloud.talent.v4beta1.Profile.update_time:type_name -> google.protobuf.Timestamp
	20, // 3: google.cloud.talent.v4beta1.Profile.candidate_update_time:type_name -> google.protobuf.Timestamp
	20, // 4: google.cloud.talent.v4beta1.Profile.resume_update_time:type_name -> google.protobuf.Timestamp
	4,  // 5: google.cloud.talent.v4beta1.Profile.resume:type_name -> google.cloud.talent.v4beta1.Resume
	5,  // 6: google.cloud.talent.v4beta1.Profile.person_names:type_name -> google.cloud.talent.v4beta1.PersonName
	6,  // 7: google.cloud.talent.v4beta1.Profile.addresses:type_name -> google.cloud.talent.v4beta1.Address
	7,  // 8: google.cloud.talent.v4beta1.Profile.email_addresses:type_name -> google.cloud.talent.v4beta1.Email
	8,  // 9: google.cloud.talent.v4beta1.Profile.phone_numbers:type_name -> google.cloud.talent.v4beta1.Phone
	9,  // 10: google.cloud.talent.v4beta1.Profile.personal_uris:type_name -> google.cloud.talent.v4beta1.PersonalUri
	10, // 11: google.cloud.talent.v4beta1.Profile.additional_contact_info:type_name -> google.cloud.talent.v4beta1.AdditionalContactInfo
	11, // 12: google.cloud.talent.v4beta1.Profile.employment_records:type_name -> google.cloud.talent.v4beta1.EmploymentRecord
	12, // 13: google.cloud.talent.v4beta1.Profile.education_records:type_name -> google.cloud.talent.v4beta1.EducationRecord
	21, // 14: google.cloud.talent.v4beta1.Profile.skills:type_name -> google.cloud.talent.v4beta1.Skill
	14, // 15: google.cloud.talent.v4beta1.Profile.activities:type_name -> google.cloud.talent.v4beta1.Activity
	15, // 16: google.cloud.talent.v4beta1.Profile.publications:type_name -> google.cloud.talent.v4beta1.Publication
	16, // 17: google.cloud.talent.v4beta1.Profile.patents:type_name -> google.cloud.talent.v4beta1.Patent
	22, // 18: google.cloud.talent.v4beta1.Profile.certifications:type_name -> google.cloud.talent.v4beta1.Certification
	17, // 19: google.cloud.talent.v4beta1.Profile.custom_attributes:type_name -> google.cloud.talent.v4beta1.Profile.CustomAttributesEntry
	3,  // 20: google.cloud.talent.v4beta1.Profile.availability_signals:type_name -> google.cloud.talent.v4beta1.AvailabilitySignal
	23, // 21: google.cloud.talent.v4beta1.Profile.derived_addresses:type_name -> google.cloud.talent.v4beta1.Location
	24, // 22: google.cloud.talent.v4beta1.AvailabilitySignal.type:type_name -> google.cloud.talent.v4beta1.AvailabilitySignalType
	20, // 23: google.cloud.talent.v4beta1.AvailabilitySignal.last_update_time:type_name -> google.protobuf.Timestamp
	19, // 24: google.cloud.talent.v4beta1.AvailabilitySignal.filter_satisfied:type_name -> google.protobuf.BoolValue
	0,  // 25: google.cloud.talent.v4beta1.Resume.resume_type:type_name -> google.cloud.talent.v4beta1.Resume.ResumeType
	18, // 26: google.cloud.talent.v4beta1.PersonName.structured_name:type_name -> google.cloud.talent.v4beta1.PersonName.PersonStructuredName
	25, // 27: google.cloud.talent.v4beta1.Address.usage:type_name -> google.cloud.talent.v4beta1.ContactInfoUsage
	26, // 28: google.cloud.talent.v4beta1.Address.structured_address:type_name -> google.type.PostalAddress
	19, // 29: google.cloud.talent.v4beta1.Address.current:type_name -> google.protobuf.BoolValue
	25, // 30: google.cloud.talent.v4beta1.Email.usage:type_name -> google.cloud.talent.v4beta1.ContactInfoUsage
	25, // 31: google.cloud.talent.v4beta1.Phone.usage:type_name -> google.cloud.talent.v4beta1.ContactInfoUsage
	1,  // 32: google.cloud.talent.v4beta1.Phone.type:type_name -> google.cloud.talent.v4beta1.Phone.PhoneType
	25, // 33: google.cloud.talent.v4beta1.AdditionalContactInfo.usage:type_name -> google.cloud.talent.v4beta1.ContactInfoUsage
	27, // 34: google.cloud.talent.v4beta1.EmploymentRecord.start_date:type_name -> google.type.Date
	27, // 35: google.cloud.talent.v4beta1.EmploymentRecord.end_date:type_name -> google.type.Date
	6,  // 36: google.cloud.talent.v4beta1.EmploymentRecord.address:type_name -> google.cloud.talent.v4beta1.Address
	19, // 37: google.cloud.talent.v4beta1.EmploymentRecord.is_supervisor:type_name -> google.protobuf.BoolValue
	19, // 38: google.cloud.talent.v4beta1.EmploymentRecord.is_self_employed:type_name -> google.protobuf.BoolValue
	19, // 39: google.cloud.talent.v4beta1.EmploymentRecord.is_current:type_name -> google.protobuf.BoolValue
	27, // 40: google.cloud.talent.v4beta1.EducationRecord.start_date:type_name -> google.type.Date
	27, // 41: google.cloud.talent.v4beta1.EducationRecord.end_date:type_name -> google.type.Date
	27, // 42: google.cloud.talent.v4beta1.EducationRecord.expected_graduation_date:type_name -> google.type.Date
	6,  // 43: google.cloud.talent.v4beta1.EducationRecord.address:type_name -> google.cloud.talent.v4beta1.Address
	13, // 44: google.cloud.talent.v4beta1.EducationRecord.structured_degree:type_name -> google.cloud.talent.v4beta1.Degree
	19, // 45: google.cloud.talent.v4beta1.EducationRecord.is_current:type_name -> google.protobuf.BoolValue
	28, // 46: google.cloud.talent.v4beta1.Degree.degree_type:type_name -> google.cloud.talent.v4beta1.DegreeType
	27, // 47: google.cloud.talent.v4beta1.Activity.create_date:type_name -> google.type.Date
	27, // 48: google.cloud.talent.v4beta1.Activity.update_date:type_name -> google.type.Date
	21, // 49: google.cloud.talent.v4beta1.Activity.skills_used:type_name -> google.cloud.talent.v4beta1.Skill
	27, // 50: google.cloud.talent.v4beta1.Publication.publication_date:type_name -> google.type.Date
	27, // 51: google.cloud.talent.v4beta1.Patent.patent_status_date:type_name -> google.type.Date
	27, // 52: google.cloud.talent.v4beta1.Patent.patent_filing_date:type_name -> google.type.Date
	21, // 53: google.cloud.talent.v4beta1.Patent.skills_used:type_name -> google.cloud.talent.v4beta1.Skill
	29, // 54: google.cloud.talent.v4beta1.Profile.CustomAttributesEntry.value:type_name -> google.cloud.talent.v4beta1.CustomAttribute
	55, // [55:55] is the sub-list for method output_type
	55, // [55:55] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_cloud_talent_v4beta1_profile_proto_init() }
func file_google_cloud_talent_v4beta1_profile_proto_init() {
	if File_google_cloud_talent_v4beta1_profile_proto != nil {
		return
	}
	file_google_cloud_talent_v4beta1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Profile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvailabilitySignal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Email); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Phone); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonalUri); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdditionalContactInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EmploymentRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EducationRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Degree); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Activity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Publication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Patent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_profile_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonName_PersonStructuredName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_talent_v4beta1_profile_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*PersonName_FormattedName)(nil),
		(*PersonName_StructuredName)(nil),
	}
	file_google_cloud_talent_v4beta1_profile_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Address_UnstructuredAddress)(nil),
		(*Address_StructuredAddress)(nil),
	}
	file_google_cloud_talent_v4beta1_profile_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*EducationRecord_DegreeDescription)(nil),
		(*EducationRecord_StructuredDegree)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_talent_v4beta1_profile_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_talent_v4beta1_profile_proto_goTypes,
		DependencyIndexes: file_google_cloud_talent_v4beta1_profile_proto_depIdxs,
		EnumInfos:         file_google_cloud_talent_v4beta1_profile_proto_enumTypes,
		MessageInfos:      file_google_cloud_talent_v4beta1_profile_proto_msgTypes,
	}.Build()
	File_google_cloud_talent_v4beta1_profile_proto = out.File
	file_google_cloud_talent_v4beta1_profile_proto_rawDesc = nil
	file_google_cloud_talent_v4beta1_profile_proto_goTypes = nil
	file_google_cloud_talent_v4beta1_profile_proto_depIdxs = nil
}
