// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/stream/logging/v1/logging.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// OperationEventType is the enum value for the state of operation.
type OperationEventType int32

const (
	// Unspecified operation event type.
	OperationEventType_OPERATION_EVENT_TYPE_UNSPECIFIED OperationEventType = 0
	// Operation for create stream content started.
	OperationEventType_OPERATION_EVENT_CREATE_CONTENT_STARTED OperationEventType = 1
	// Operation for create stream content ended.
	OperationEventType_OPERATION_EVENT_CREATE_CONTENT_ENDED OperationEventType = 2
	// Operation for build stream content started.
	OperationEventType_OPERATION_EVENT_BUILD_CONTENT_STARTED OperationEventType = 3
	// Operation for build stream content ended.
	OperationEventType_OPERATION_EVENT_BUILD_CONTENT_ENDED OperationEventType = 4
	// Operation for update stream content started.
	OperationEventType_OPERATION_EVENT_UPDATE_CONTENT_STARTED OperationEventType = 5
	// Operation for update stream content ended.
	OperationEventType_OPERATION_EVENT_UPDATE_CONTENT_ENDED OperationEventType = 6
	// Operation for delete stream content started.
	OperationEventType_OPERATION_EVENT_DELETE_CONTENT_STARTED OperationEventType = 7
	// Operation for delete stream content ended.
	OperationEventType_OPERATION_EVENT_DELETE_CONTENT_ENDED OperationEventType = 8
	// Operation for create stream instance started.
	OperationEventType_OPERATION_EVENT_CREATE_INSTANCE_STARTED OperationEventType = 9
	// Operation for create stream instance ended.
	OperationEventType_OPERATION_EVENT_CREATE_INSTANCE_ENDED OperationEventType = 10
	// Operation for update stream instance started.
	OperationEventType_OPERATION_EVENT_UPDATE_INSTANCE_STARTED OperationEventType = 11
	// Operation for update stream instance ended.
	OperationEventType_OPERATION_EVENT_UPDATE_INSTANCE_ENDED OperationEventType = 12
	// Operation for delete stream instance started.
	OperationEventType_OPERATION_EVENT_DELETE_INSTANCE_STARTED OperationEventType = 13
	// Operation for delete stream instance ended.
	OperationEventType_OPERATION_EVENT_DELETE_INSTANCE_ENDED OperationEventType = 14
)

// Enum value maps for OperationEventType.
var (
	OperationEventType_name = map[int32]string{
		0:  "OPERATION_EVENT_TYPE_UNSPECIFIED",
		1:  "OPERATION_EVENT_CREATE_CONTENT_STARTED",
		2:  "OPERATION_EVENT_CREATE_CONTENT_ENDED",
		3:  "OPERATION_EVENT_BUILD_CONTENT_STARTED",
		4:  "OPERATION_EVENT_BUILD_CONTENT_ENDED",
		5:  "OPERATION_EVENT_UPDATE_CONTENT_STARTED",
		6:  "OPERATION_EVENT_UPDATE_CONTENT_ENDED",
		7:  "OPERATION_EVENT_DELETE_CONTENT_STARTED",
		8:  "OPERATION_EVENT_DELETE_CONTENT_ENDED",
		9:  "OPERATION_EVENT_CREATE_INSTANCE_STARTED",
		10: "OPERATION_EVENT_CREATE_INSTANCE_ENDED",
		11: "OPERATION_EVENT_UPDATE_INSTANCE_STARTED",
		12: "OPERATION_EVENT_UPDATE_INSTANCE_ENDED",
		13: "OPERATION_EVENT_DELETE_INSTANCE_STARTED",
		14: "OPERATION_EVENT_DELETE_INSTANCE_ENDED",
	}
	OperationEventType_value = map[string]int32{
		"OPERATION_EVENT_TYPE_UNSPECIFIED":        0,
		"OPERATION_EVENT_CREATE_CONTENT_STARTED":  1,
		"OPERATION_EVENT_CREATE_CONTENT_ENDED":    2,
		"OPERATION_EVENT_BUILD_CONTENT_STARTED":   3,
		"OPERATION_EVENT_BUILD_CONTENT_ENDED":     4,
		"OPERATION_EVENT_UPDATE_CONTENT_STARTED":  5,
		"OPERATION_EVENT_UPDATE_CONTENT_ENDED":    6,
		"OPERATION_EVENT_DELETE_CONTENT_STARTED":  7,
		"OPERATION_EVENT_DELETE_CONTENT_ENDED":    8,
		"OPERATION_EVENT_CREATE_INSTANCE_STARTED": 9,
		"OPERATION_EVENT_CREATE_INSTANCE_ENDED":   10,
		"OPERATION_EVENT_UPDATE_INSTANCE_STARTED": 11,
		"OPERATION_EVENT_UPDATE_INSTANCE_ENDED":   12,
		"OPERATION_EVENT_DELETE_INSTANCE_STARTED": 13,
		"OPERATION_EVENT_DELETE_INSTANCE_ENDED":   14,
	}
)

func (x OperationEventType) Enum() *OperationEventType {
	p := new(OperationEventType)
	*p = x
	return p
}

func (x OperationEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_stream_logging_v1_logging_proto_enumTypes[0].Descriptor()
}

func (OperationEventType) Type() protoreflect.EnumType {
	return &file_google_cloud_stream_logging_v1_logging_proto_enumTypes[0]
}

func (x OperationEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationEventType.Descriptor instead.
func (OperationEventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_stream_logging_v1_logging_proto_rawDescGZIP(), []int{0}
}

// SessionEventType is the enum value for the state of session.
type SessionEventType int32

const (
	// Unspecified session event type.
	SessionEventType_SESSION_EVENT_TYPE_UNSPECIFIED SessionEventType = 0
	// Session in streamer shutting down state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_SHUTTING_DOWN SessionEventType = 1
	// Session in streamer ready state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_READY SessionEventType = 2
	// Session in streamer binary started state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_BINARY_STARTED SessionEventType = 3
	// Session in streamer read pod image names state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_READ_POD_IMAGE_NAMES SessionEventType = 4
	// Session in streamer connected to game state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_CONNECTED_TO_GAME SessionEventType = 5
	// Session in streamer connected to client state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_CONNECTED_TO_CLIENT SessionEventType = 6
	// Session in streamer disconnected from client state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_DISCONNECTED_FROM_CLIENT SessionEventType = 7
	// Session in streamer received create session request state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_RECEIVED_CREATE_SESSION_REQUEST SessionEventType = 8
	// Session in streamer game message to stream closed state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_GAME_MESSAGE_STREAM_CLOSED SessionEventType = 9
	// Session in streamer game frame stream closed state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_GAME_FRAME_STREAM_CLOSED SessionEventType = 10
	// Session in streamer game message stream error state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_GAME_MESSAGE_STREAM_ERROR SessionEventType = 11
	// Session in streamer game audio stream error state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_GAME_AUDIO_STREAM_ERROR SessionEventType = 12
	// Session in streamer game audio stream closed state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_GAME_AUDIO_STREAM_CLOSED SessionEventType = 13
	// Session in streamer game frame stream error state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_GAME_FRAME_STREAM_ERROR SessionEventType = 14
	// Session in game disconnecting after paused too long state.
	SessionEventType_SESSION_EVENT_SERVER_GAME_DISCONNECTING_AFTER_PAUSED_TOO_LONG SessionEventType = 15
	// Session in streamer received experiment configuration state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_RECEIVED_EXPERIMENT_CONFIGURATION SessionEventType = 16
	// Session in game connected to logging service state.
	SessionEventType_SESSION_EVENT_SERVER_GAME_CONNECTED_TO_LOGGING_SERVICE SessionEventType = 17
	// Session in streamer determined session options state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_DETERMINED_SESSION_OPTIONS SessionEventType = 18
	// Session in streamer killed in middle of session state.
	SessionEventType_SESSION_EVENT_SERVER_STREAMER_KILLED_IN_MIDDLE_OF_SESSION SessionEventType = 19
	// Session in game updated frame pipeline state.
	SessionEventType_SESSION_EVENT_SERVER_GAME_UPDATED_FRAME_PIPELINE SessionEventType = 20
	// Session in server error state.
	SessionEventType_SESSION_EVENT_SERVER_ERROR SessionEventType = 21
)

// Enum value maps for SessionEventType.
var (
	SessionEventType_name = map[int32]string{
		0:  "SESSION_EVENT_TYPE_UNSPECIFIED",
		1:  "SESSION_EVENT_SERVER_STREAMER_SHUTTING_DOWN",
		2:  "SESSION_EVENT_SERVER_STREAMER_READY",
		3:  "SESSION_EVENT_SERVER_STREAMER_BINARY_STARTED",
		4:  "SESSION_EVENT_SERVER_STREAMER_READ_POD_IMAGE_NAMES",
		5:  "SESSION_EVENT_SERVER_STREAMER_CONNECTED_TO_GAME",
		6:  "SESSION_EVENT_SERVER_STREAMER_CONNECTED_TO_CLIENT",
		7:  "SESSION_EVENT_SERVER_STREAMER_DISCONNECTED_FROM_CLIENT",
		8:  "SESSION_EVENT_SERVER_STREAMER_RECEIVED_CREATE_SESSION_REQUEST",
		9:  "SESSION_EVENT_SERVER_STREAMER_GAME_MESSAGE_STREAM_CLOSED",
		10: "SESSION_EVENT_SERVER_STREAMER_GAME_FRAME_STREAM_CLOSED",
		11: "SESSION_EVENT_SERVER_STREAMER_GAME_MESSAGE_STREAM_ERROR",
		12: "SESSION_EVENT_SERVER_STREAMER_GAME_AUDIO_STREAM_ERROR",
		13: "SESSION_EVENT_SERVER_STREAMER_GAME_AUDIO_STREAM_CLOSED",
		14: "SESSION_EVENT_SERVER_STREAMER_GAME_FRAME_STREAM_ERROR",
		15: "SESSION_EVENT_SERVER_GAME_DISCONNECTING_AFTER_PAUSED_TOO_LONG",
		16: "SESSION_EVENT_SERVER_STREAMER_RECEIVED_EXPERIMENT_CONFIGURATION",
		17: "SESSION_EVENT_SERVER_GAME_CONNECTED_TO_LOGGING_SERVICE",
		18: "SESSION_EVENT_SERVER_STREAMER_DETERMINED_SESSION_OPTIONS",
		19: "SESSION_EVENT_SERVER_STREAMER_KILLED_IN_MIDDLE_OF_SESSION",
		20: "SESSION_EVENT_SERVER_GAME_UPDATED_FRAME_PIPELINE",
		21: "SESSION_EVENT_SERVER_ERROR",
	}
	SessionEventType_value = map[string]int32{
		"SESSION_EVENT_TYPE_UNSPECIFIED":                                  0,
		"SESSION_EVENT_SERVER_STREAMER_SHUTTING_DOWN":                     1,
		"SESSION_EVENT_SERVER_STREAMER_READY":                             2,
		"SESSION_EVENT_SERVER_STREAMER_BINARY_STARTED":                    3,
		"SESSION_EVENT_SERVER_STREAMER_READ_POD_IMAGE_NAMES":              4,
		"SESSION_EVENT_SERVER_STREAMER_CONNECTED_TO_GAME":                 5,
		"SESSION_EVENT_SERVER_STREAMER_CONNECTED_TO_CLIENT":               6,
		"SESSION_EVENT_SERVER_STREAMER_DISCONNECTED_FROM_CLIENT":          7,
		"SESSION_EVENT_SERVER_STREAMER_RECEIVED_CREATE_SESSION_REQUEST":   8,
		"SESSION_EVENT_SERVER_STREAMER_GAME_MESSAGE_STREAM_CLOSED":        9,
		"SESSION_EVENT_SERVER_STREAMER_GAME_FRAME_STREAM_CLOSED":          10,
		"SESSION_EVENT_SERVER_STREAMER_GAME_MESSAGE_STREAM_ERROR":         11,
		"SESSION_EVENT_SERVER_STREAMER_GAME_AUDIO_STREAM_ERROR":           12,
		"SESSION_EVENT_SERVER_STREAMER_GAME_AUDIO_STREAM_CLOSED":          13,
		"SESSION_EVENT_SERVER_STREAMER_GAME_FRAME_STREAM_ERROR":           14,
		"SESSION_EVENT_SERVER_GAME_DISCONNECTING_AFTER_PAUSED_TOO_LONG":   15,
		"SESSION_EVENT_SERVER_STREAMER_RECEIVED_EXPERIMENT_CONFIGURATION": 16,
		"SESSION_EVENT_SERVER_GAME_CONNECTED_TO_LOGGING_SERVICE":          17,
		"SESSION_EVENT_SERVER_STREAMER_DETERMINED_SESSION_OPTIONS":        18,
		"SESSION_EVENT_SERVER_STREAMER_KILLED_IN_MIDDLE_OF_SESSION":       19,
		"SESSION_EVENT_SERVER_GAME_UPDATED_FRAME_PIPELINE":                20,
		"SESSION_EVENT_SERVER_ERROR":                                      21,
	}
)

func (x SessionEventType) Enum() *SessionEventType {
	p := new(SessionEventType)
	*p = x
	return p
}

func (x SessionEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SessionEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_stream_logging_v1_logging_proto_enumTypes[1].Descriptor()
}

func (SessionEventType) Type() protoreflect.EnumType {
	return &file_google_cloud_stream_logging_v1_logging_proto_enumTypes[1]
}

func (x SessionEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SessionEventType.Descriptor instead.
func (SessionEventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_stream_logging_v1_logging_proto_rawDescGZIP(), []int{1}
}

// OperationEventLog contains the time series data of the operations on the
// stream resources. Internally, these logs represent events happening in
// the control plane as result of API invocations against the stream resource
// entities.
type OperationEventLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enum for type of event being logged.
	EventType OperationEventType `protobuf:"varint,1,opt,name=event_type,json=eventType,proto3,enum=google.cloud.stream.logging.v1.OperationEventType" json:"event_type,omitempty"`
	// Timestamp when the event occurred.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Operation resource identifier.
	Operation string `protobuf:"bytes,3,opt,name=operation,proto3" json:"operation,omitempty"`
	// Artifact created as a result of the operation.
	OperationArtifacts []*OperationArtifact `protobuf:"bytes,4,rep,name=operation_artifacts,json=operationArtifacts,proto3" json:"operation_artifacts,omitempty"`
}

func (x *OperationEventLog) Reset() {
	*x = OperationEventLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_stream_logging_v1_logging_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationEventLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationEventLog) ProtoMessage() {}

func (x *OperationEventLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_stream_logging_v1_logging_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationEventLog.ProtoReflect.Descriptor instead.
func (*OperationEventLog) Descriptor() ([]byte, []int) {
	return file_google_cloud_stream_logging_v1_logging_proto_rawDescGZIP(), []int{0}
}

func (x *OperationEventLog) GetEventType() OperationEventType {
	if x != nil {
		return x.EventType
	}
	return OperationEventType_OPERATION_EVENT_TYPE_UNSPECIFIED
}

func (x *OperationEventLog) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *OperationEventLog) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *OperationEventLog) GetOperationArtifacts() []*OperationArtifact {
	if x != nil {
		return x.OperationArtifacts
	}
	return nil
}

// OperationArtifact contains the information about the artifact created as
// result of the operation.
type OperationArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the artifact.
	ArtifactType string `protobuf:"bytes,1,opt,name=artifact_type,json=artifactType,proto3" json:"artifact_type,omitempty"`
	// Location of the artifact.
	ArtifactUri string `protobuf:"bytes,2,opt,name=artifact_uri,json=artifactUri,proto3" json:"artifact_uri,omitempty"`
}

func (x *OperationArtifact) Reset() {
	*x = OperationArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_stream_logging_v1_logging_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationArtifact) ProtoMessage() {}

func (x *OperationArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_stream_logging_v1_logging_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationArtifact.ProtoReflect.Descriptor instead.
func (*OperationArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_stream_logging_v1_logging_proto_rawDescGZIP(), []int{1}
}

func (x *OperationArtifact) GetArtifactType() string {
	if x != nil {
		return x.ArtifactType
	}
	return ""
}

func (x *OperationArtifact) GetArtifactUri() string {
	if x != nil {
		return x.ArtifactUri
	}
	return ""
}

// SessionEventLog contains the time series data regarding the streaming session
// to serve the end consumer. Internally, these logs represent events in the
// data plane streamer instance as a result of end consumer interacting with the
// stream resources.
type SessionEventLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enum for type of event being logged.
	EventType SessionEventType `protobuf:"varint,1,opt,name=event_type,json=eventType,proto3,enum=google.cloud.stream.logging.v1.SessionEventType" json:"event_type,omitempty"`
	// Timestamp when the event occurred.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Session identifier generated from the server.
	SessionId string `protobuf:"bytes,3,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (x *SessionEventLog) Reset() {
	*x = SessionEventLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_stream_logging_v1_logging_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionEventLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionEventLog) ProtoMessage() {}

func (x *SessionEventLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_stream_logging_v1_logging_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionEventLog.ProtoReflect.Descriptor instead.
func (*SessionEventLog) Descriptor() ([]byte, []int) {
	return file_google_cloud_stream_logging_v1_logging_proto_rawDescGZIP(), []int{2}
}

func (x *SessionEventLog) GetEventType() SessionEventType {
	if x != nil {
		return x.EventType
	}
	return SessionEventType_SESSION_EVENT_TYPE_UNSPECIFIED
}

func (x *SessionEventLog) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *SessionEventLog) GetSessionId() string {
	if x != nil {
		return x.SessionId
	}
	return ""
}

var File_google_cloud_stream_logging_v1_logging_proto protoreflect.FileDescriptor

var file_google_cloud_stream_logging_v1_logging_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31,
	0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xa3, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x12, 0x51, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x62, 0x0a, 0x13, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x52, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x22, 0x5b, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x55,
	0x72, 0x69, 0x22, 0xbc, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x12, 0x4f, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x2a, 0x98, 0x05, 0x0a, 0x12, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x4f, 0x50, 0x45, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2a,
	0x0a, 0x26, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54,
	0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x4f, 0x50,
	0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x4e, 0x44,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x29, 0x0a, 0x25, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x43, 0x4f,
	0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x27, 0x0a, 0x23, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54,
	0x5f, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x2a, 0x0a, 0x26, 0x4f, 0x50, 0x45, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54,
	0x45, 0x44, 0x10, 0x05, 0x12, 0x28, 0x0a, 0x24, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x43,
	0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x06, 0x12, 0x2a,
	0x0a, 0x26, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54,
	0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x28, 0x0a, 0x24, 0x4f, 0x50,
	0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x4e, 0x44,
	0x45, 0x44, 0x10, 0x08, 0x12, 0x2b, 0x0a, 0x27, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10,
	0x09, 0x12, 0x29, 0x0a, 0x25, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x5f, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x2b, 0x0a, 0x27,
	0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f,
	0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x0b, 0x12, 0x29, 0x0a, 0x25, 0x4f, 0x50, 0x45,
	0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x50, 0x44,
	0x41, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x45, 0x4e, 0x44,
	0x45, 0x44, 0x10, 0x0c, 0x12, 0x2b, 0x0a, 0x27, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10,
	0x0d, 0x12, 0x29, 0x0a, 0x25, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x5f, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x0e, 0x2a, 0xe5, 0x09, 0x0a,
	0x10, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2f, 0x0a, 0x2b, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54,
	0x52, 0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f, 0x53, 0x48, 0x55, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f,
	0x44, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12,
	0x30, 0x0a, 0x2c, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x45, 0x52,
	0x5f, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x36, 0x0a, 0x32, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d,
	0x45, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x50, 0x4f, 0x44, 0x5f, 0x49, 0x4d, 0x41, 0x47,
	0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x10, 0x04, 0x12, 0x33, 0x0a, 0x2f, 0x53, 0x45, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45,
	0x43, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x5f, 0x47, 0x41, 0x4d, 0x45, 0x10, 0x05, 0x12, 0x35,
	0x0a, 0x31, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x5f, 0x43, 0x4c, 0x49,
	0x45, 0x4e, 0x54, 0x10, 0x06, 0x12, 0x3a, 0x0a, 0x36, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54,
	0x52, 0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43,
	0x54, 0x45, 0x44, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x10,
	0x07, 0x12, 0x41, 0x0a, 0x3d, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d,
	0x45, 0x52, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x5f, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45,
	0x53, 0x54, 0x10, 0x08, 0x12, 0x3c, 0x0a, 0x38, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52,
	0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f, 0x47, 0x41, 0x4d, 0x45, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41,
	0x47, 0x45, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44,
	0x10, 0x09, 0x12, 0x3a, 0x0a, 0x36, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41,
	0x4d, 0x45, 0x52, 0x5f, 0x47, 0x41, 0x4d, 0x45, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x5f, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x3b,
	0x0a, 0x37, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f,
	0x47, 0x41, 0x4d, 0x45, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x52,
	0x45, 0x41, 0x4d, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x0b, 0x12, 0x39, 0x0a, 0x35, 0x53,
	0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f, 0x47, 0x41, 0x4d,
	0x45, 0x5f, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x0c, 0x12, 0x3a, 0x0a, 0x36, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x45, 0x52, 0x5f, 0x47, 0x41, 0x4d, 0x45, 0x5f, 0x41, 0x55, 0x44,
	0x49, 0x4f, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44,
	0x10, 0x0d, 0x12, 0x39, 0x0a, 0x35, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41,
	0x4d, 0x45, 0x52, 0x5f, 0x47, 0x41, 0x4d, 0x45, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x5f, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x0e, 0x12, 0x41, 0x0a,
	0x3d, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53,
	0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x47, 0x41, 0x4d, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f, 0x50,
	0x41, 0x55, 0x53, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x4f, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x0f,
	0x12, 0x43, 0x0a, 0x3f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x45,
	0x52, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x52,
	0x49, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x10, 0x12, 0x3a, 0x0a, 0x36, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x47, 0x41,
	0x4d, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x5f,
	0x4c, 0x4f, 0x47, 0x47, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10,
	0x11, 0x12, 0x3c, 0x0a, 0x38, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d,
	0x45, 0x52, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x53, 0x45,
	0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x12, 0x12,
	0x3d, 0x0a, 0x39, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x45, 0x52,
	0x5f, 0x4b, 0x49, 0x4c, 0x4c, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x5f, 0x4d, 0x49, 0x44, 0x44, 0x4c,
	0x45, 0x5f, 0x4f, 0x46, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x13, 0x12, 0x34,
	0x0a, 0x30, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x47, 0x41, 0x4d, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x44, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x5f, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49,
	0x4e, 0x45, 0x10, 0x14, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0x15, 0x42, 0x7b, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_stream_logging_v1_logging_proto_rawDescOnce sync.Once
	file_google_cloud_stream_logging_v1_logging_proto_rawDescData = file_google_cloud_stream_logging_v1_logging_proto_rawDesc
)

func file_google_cloud_stream_logging_v1_logging_proto_rawDescGZIP() []byte {
	file_google_cloud_stream_logging_v1_logging_proto_rawDescOnce.Do(func() {
		file_google_cloud_stream_logging_v1_logging_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_stream_logging_v1_logging_proto_rawDescData)
	})
	return file_google_cloud_stream_logging_v1_logging_proto_rawDescData
}

var file_google_cloud_stream_logging_v1_logging_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_stream_logging_v1_logging_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_stream_logging_v1_logging_proto_goTypes = []interface{}{
	(OperationEventType)(0),       // 0: google.cloud.stream.logging.v1.OperationEventType
	(SessionEventType)(0),         // 1: google.cloud.stream.logging.v1.SessionEventType
	(*OperationEventLog)(nil),     // 2: google.cloud.stream.logging.v1.OperationEventLog
	(*OperationArtifact)(nil),     // 3: google.cloud.stream.logging.v1.OperationArtifact
	(*SessionEventLog)(nil),       // 4: google.cloud.stream.logging.v1.SessionEventLog
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_google_cloud_stream_logging_v1_logging_proto_depIdxs = []int32{
	0, // 0: google.cloud.stream.logging.v1.OperationEventLog.event_type:type_name -> google.cloud.stream.logging.v1.OperationEventType
	5, // 1: google.cloud.stream.logging.v1.OperationEventLog.event_time:type_name -> google.protobuf.Timestamp
	3, // 2: google.cloud.stream.logging.v1.OperationEventLog.operation_artifacts:type_name -> google.cloud.stream.logging.v1.OperationArtifact
	1, // 3: google.cloud.stream.logging.v1.SessionEventLog.event_type:type_name -> google.cloud.stream.logging.v1.SessionEventType
	5, // 4: google.cloud.stream.logging.v1.SessionEventLog.event_time:type_name -> google.protobuf.Timestamp
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_stream_logging_v1_logging_proto_init() }
func file_google_cloud_stream_logging_v1_logging_proto_init() {
	if File_google_cloud_stream_logging_v1_logging_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_stream_logging_v1_logging_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationEventLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_stream_logging_v1_logging_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_stream_logging_v1_logging_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionEventLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_stream_logging_v1_logging_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_stream_logging_v1_logging_proto_goTypes,
		DependencyIndexes: file_google_cloud_stream_logging_v1_logging_proto_depIdxs,
		EnumInfos:         file_google_cloud_stream_logging_v1_logging_proto_enumTypes,
		MessageInfos:      file_google_cloud_stream_logging_v1_logging_proto_msgTypes,
	}.Build()
	File_google_cloud_stream_logging_v1_logging_proto = out.File
	file_google_cloud_stream_logging_v1_logging_proto_rawDesc = nil
	file_google_cloud_stream_logging_v1_logging_proto_goTypes = nil
	file_google_cloud_stream_logging_v1_logging_proto_depIdxs = nil
}
